<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 21.09.2006
 *
 * Version 0.1
 * This Class shows informations in the admin interface
 ******************************/

class admin_info extends extension_base {

	function main() {
		$content = "";
		
		// add menu item to admin navi
		$this->menu['admin']['info']['name'] = $this->CLASS['language']->get['ext']['admin_info']['menuitem'];
		$this->menu['admin']['info']['link'] = "index.php?action=show_info";
		$this->menu['admin']['info']['priority'] = "10";
		
		// add logout
		$this->menu['admin']['logout']['name'] = "logout";
		$this->menu['admin']['logout']['link'] = "index.php?action=logout";
		$this->menu['admin']['logout']['priority'] = "90";
		
		/*
		// add submenu item to item info in admin navi
		$this->menu['admin']['info_sub']['parent'] = "info";
		$this->menu['admin']['info_sub']['name'] = $this->CLASS['language']->get['ext']['admin_info']['submenuitem'];
		$this->menu['admin']['info_sub']['link'] = "index.php?action=test";
		$this->menu['admin']['info_sub']['priority'] = "12";
		
		$this->menu['admin']['info_sub2']['parent'] = "info";
		$this->menu['admin']['info_sub2']['name'] = $this->CLASS['language']->get['ext']['admin_info']['submenuitem'];
		$this->menu['admin']['info_sub2']['link'] = "index.php?action=test2";
		$this->menu['admin']['info_sub2']['priority'] = "13";
		*/
		
		// check for logout
		if(isset($_GET['action']) and $_GET['action'] == "logout") {
			$this->logout();
		}
		
		// check if informations should be shown
		if(isset($_GET['action']) and $_GET['action'] == "show_info") {
			$content = $this->show_info();
		}

		// set default content for admin interface
		$this->CLASS['kr_extension']->default_content = $this->show_info();

		return $content;
	}
	
	// show informations
	function show_info() {
		$out = '
			<h2>Welcome to the Administrationinterface of Knowledgeroot</h2>
			At this interface you can configure Knowledgeroot and you can install more features as extensions.
		';
		return $out;
	}
	
	function logout() {
		$_SESSION = array();
		
		if (isset($_COOKIE[session_name()])) {
			setcookie(session_name(), '', time()-42000, '/');
		}
		
		session_destroy();
		header("Location: index.php");
		exit();
	}
}

?>