
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQScroller.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QScroller>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPointF>
#include <QRectF>
#include <QScrollerProperties>
#include <QThread>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QScroller

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QScroller::staticMetaObject);
}


// void QScroller::ensureVisible(const QRectF &rect, double xmargin, double ymargin)


static void _init_f_ensureVisible_3788 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin");
  decl->add_arg<double > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3788 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->ensureVisible (arg1, arg2, arg3);
}


// void QScroller::ensureVisible(const QRectF &rect, double xmargin, double ymargin, int scrollTime)


static void _init_f_ensureVisible_4447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("scrollTime");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_4447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->ensureVisible (arg1, arg2, arg3, arg4);
}


// QPointF QScroller::finalPosition()


static void _init_f_finalPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_finalPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QScroller *)cls)->finalPosition ());
}


// bool QScroller::handleInput(QScroller::Input input, const QPointF &position, qint64 timestamp)


static void _init_f_handleInput_4755 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const qt_gsi::Converter<QScroller::Input>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("position");
  decl->add_arg<const QPointF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("timestamp", true, "0");
  decl->add_arg<qint64 > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_handleInput_4755 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QScroller::Input>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QScroller::Input>::target_type & >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  qint64 arg3 = args ? gsi::arg_reader<qint64 >() (args, heap) : gsi::arg_maker<qint64 >() (0, heap);
  ret.write<bool > ((bool)((QScroller *)cls)->handleInput (qt_gsi::QtToCppAdaptor<QScroller::Input>(arg1).cref(), arg2, arg3));
}


// QPointF QScroller::pixelPerMeter()


static void _init_f_pixelPerMeter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_pixelPerMeter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QScroller *)cls)->pixelPerMeter ());
}


// void QScroller::resendPrepareEvent()


static void _init_f_resendPrepareEvent_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resendPrepareEvent_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->resendPrepareEvent ();
}


// void QScroller::scrollTo(const QPointF &pos)


static void _init_f_scrollTo_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_scrollTo_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->scrollTo (arg1);
}


// void QScroller::scrollTo(const QPointF &pos, int scrollTime)


static void _init_f_scrollTo_2645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("scrollTime");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollTo_2645 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->scrollTo (arg1, arg2);
}


// QScrollerProperties QScroller::scrollerProperties()


static void _init_f_scrollerProperties_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QScrollerProperties > ();
}

static void _call_f_scrollerProperties_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QScrollerProperties > ((QScrollerProperties)((QScroller *)cls)->scrollerProperties ());
}


// void QScroller::setScrollerProperties(const QScrollerProperties &prop)


static void _init_f_setScrollerProperties_3301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prop");
  decl->add_arg<const QScrollerProperties & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScrollerProperties_3301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QScrollerProperties &arg1 = gsi::arg_reader<const QScrollerProperties & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->setScrollerProperties (arg1);
}


// void QScroller::setSnapPositionsX(const QList<qreal> &positions)


static void _init_f_setSnapPositionsX_2461 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("positions");
  decl->add_arg<const QList<qreal> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSnapPositionsX_2461 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<qreal> &arg1 = gsi::arg_reader<const QList<qreal> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->setSnapPositionsX (arg1);
}


// void QScroller::setSnapPositionsX(double first, double interval)


static void _init_f_setSnapPositionsX_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("first");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("interval");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSnapPositionsX_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->setSnapPositionsX (arg1, arg2);
}


// void QScroller::setSnapPositionsY(const QList<qreal> &positions)


static void _init_f_setSnapPositionsY_2461 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("positions");
  decl->add_arg<const QList<qreal> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSnapPositionsY_2461 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<qreal> &arg1 = gsi::arg_reader<const QList<qreal> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->setSnapPositionsY (arg1);
}


// void QScroller::setSnapPositionsY(double first, double interval)


static void _init_f_setSnapPositionsY_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("first");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("interval");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSnapPositionsY_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->setSnapPositionsY (arg1, arg2);
}


// QScroller::State QScroller::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QScroller::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QScroller::State>::target_type > ((qt_gsi::Converter<QScroller::State>::target_type)qt_gsi::CppToQtAdaptor<QScroller::State>(((QScroller *)cls)->state ()));
}


// void QScroller::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScroller *)cls)->stop ();
}


// QObject *QScroller::target()


static void _init_f_target_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_target_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QScroller *)cls)->target ());
}


// QPointF QScroller::velocity()


static void _init_f_velocity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_velocity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QScroller *)cls)->velocity ());
}


// static QList<QScroller *> QScroller::activeScrollers()


static void _init_f_activeScrollers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QScroller *> > ();
}

static void _call_f_activeScrollers_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QScroller *> > ((QList<QScroller *>)QScroller::activeScrollers ());
}


// static Qt::GestureType QScroller::grabGesture(QObject *target, QScroller::ScrollerGestureType gestureType)


static void _init_f_grabGesture_4656 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("gestureType", true, "QScroller::TouchGesture");
  decl->add_arg<const qt_gsi::Converter<QScroller::ScrollerGestureType>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<Qt::GestureType>::target_type > ();
}

static void _call_f_grabGesture_4656 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const qt_gsi::Converter<QScroller::ScrollerGestureType>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QScroller::ScrollerGestureType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QScroller::ScrollerGestureType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QScroller::ScrollerGestureType>(heap, QScroller::TouchGesture), heap);
  ret.write<qt_gsi::Converter<Qt::GestureType>::target_type > ((qt_gsi::Converter<Qt::GestureType>::target_type)qt_gsi::CppToQtAdaptor<Qt::GestureType>(QScroller::grabGesture (arg1, qt_gsi::QtToCppAdaptor<QScroller::ScrollerGestureType>(arg2).cref())));
}


// static Qt::GestureType QScroller::grabbedGesture(QObject *target)


static void _init_f_grabbedGesture_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::GestureType>::target_type > ();
}

static void _call_f_grabbedGesture_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<qt_gsi::Converter<Qt::GestureType>::target_type > ((qt_gsi::Converter<Qt::GestureType>::target_type)qt_gsi::CppToQtAdaptor<Qt::GestureType>(QScroller::grabbedGesture (arg1)));
}


// static bool QScroller::hasScroller(QObject *target)


static void _init_f_hasScroller_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasScroller_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<bool > ((bool)QScroller::hasScroller (arg1));
}


// static QScroller *QScroller::scroller(QObject *target)


static void _init_f_scroller_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QScroller * > ();
}

static void _call_f_scroller_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QScroller * > ((QScroller *)QScroller::scroller (arg1));
}


// static const QScroller *QScroller::scroller(const QObject *target)


static void _init_f_scroller_1997 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<const QObject * > (argspec_0);
  decl->set_return<const QScroller * > ();
}

static void _call_f_scroller_1997 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QObject *arg1 = gsi::arg_reader<const QObject * >() (args, heap);
  ret.write<const QScroller * > ((const QScroller *)QScroller::scroller (arg1));
}


// static QString QScroller::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QScroller::tr (arg1, arg2, arg3));
}


// static QString QScroller::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QScroller::trUtf8 (arg1, arg2, arg3));
}


// static void QScroller::ungrabGesture(QObject *target)


static void _init_f_ungrabGesture_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("target");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ungrabGesture_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QScroller::ungrabGesture (arg1);
}



namespace gsi
{

static gsi::Methods methods_QScroller () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QScroller::ensureVisible(const QRectF &rect, double xmargin, double ymargin)\n", false, &_init_f_ensureVisible_3788, &_call_f_ensureVisible_3788);
  methods += new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QScroller::ensureVisible(const QRectF &rect, double xmargin, double ymargin, int scrollTime)\n", false, &_init_f_ensureVisible_4447, &_call_f_ensureVisible_4447);
  methods += new qt_gsi::GenericMethod ("finalPosition", "@brief Method QPointF QScroller::finalPosition()\n", true, &_init_f_finalPosition_c0, &_call_f_finalPosition_c0);
  methods += new qt_gsi::GenericMethod ("handleInput", "@brief Method bool QScroller::handleInput(QScroller::Input input, const QPointF &position, qint64 timestamp)\n", false, &_init_f_handleInput_4755, &_call_f_handleInput_4755);
  methods += new qt_gsi::GenericMethod ("pixelPerMeter", "@brief Method QPointF QScroller::pixelPerMeter()\n", true, &_init_f_pixelPerMeter_c0, &_call_f_pixelPerMeter_c0);
  methods += new qt_gsi::GenericMethod ("resendPrepareEvent", "@brief Method void QScroller::resendPrepareEvent()\n", false, &_init_f_resendPrepareEvent_0, &_call_f_resendPrepareEvent_0);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Method void QScroller::scrollTo(const QPointF &pos)\n", false, &_init_f_scrollTo_1986, &_call_f_scrollTo_1986);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Method void QScroller::scrollTo(const QPointF &pos, int scrollTime)\n", false, &_init_f_scrollTo_2645, &_call_f_scrollTo_2645);
  methods += new qt_gsi::GenericMethod (":scrollerProperties", "@brief Method QScrollerProperties QScroller::scrollerProperties()\n", true, &_init_f_scrollerProperties_c0, &_call_f_scrollerProperties_c0);
  methods += new qt_gsi::GenericMethod ("setScrollerProperties|scrollerProperties=", "@brief Method void QScroller::setScrollerProperties(const QScrollerProperties &prop)\n", false, &_init_f_setScrollerProperties_3301, &_call_f_setScrollerProperties_3301);
  methods += new qt_gsi::GenericMethod ("setSnapPositionsX", "@brief Method void QScroller::setSnapPositionsX(const QList<qreal> &positions)\n", false, &_init_f_setSnapPositionsX_2461, &_call_f_setSnapPositionsX_2461);
  methods += new qt_gsi::GenericMethod ("setSnapPositionsX", "@brief Method void QScroller::setSnapPositionsX(double first, double interval)\n", false, &_init_f_setSnapPositionsX_2034, &_call_f_setSnapPositionsX_2034);
  methods += new qt_gsi::GenericMethod ("setSnapPositionsY", "@brief Method void QScroller::setSnapPositionsY(const QList<qreal> &positions)\n", false, &_init_f_setSnapPositionsY_2461, &_call_f_setSnapPositionsY_2461);
  methods += new qt_gsi::GenericMethod ("setSnapPositionsY", "@brief Method void QScroller::setSnapPositionsY(double first, double interval)\n", false, &_init_f_setSnapPositionsY_2034, &_call_f_setSnapPositionsY_2034);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QScroller::State QScroller::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QScroller::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("target", "@brief Method QObject *QScroller::target()\n", true, &_init_f_target_c0, &_call_f_target_c0);
  methods += new qt_gsi::GenericMethod ("velocity", "@brief Method QPointF QScroller::velocity()\n", true, &_init_f_velocity_c0, &_call_f_velocity_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QScroller::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QScroller::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QScrollerProperties & > ("scrollerPropertiesChanged(const QScrollerProperties &)", "scrollerPropertiesChanged", gsi::arg("arg1"), "@brief Signal declaration for QScroller::scrollerPropertiesChanged(const QScrollerProperties &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QScroller::State>::target_type & > ("stateChanged(QScroller::State)", "stateChanged", gsi::arg("newstate"), "@brief Signal declaration for QScroller::stateChanged(QScroller::State newstate)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("activeScrollers", "@brief Static method QList<QScroller *> QScroller::activeScrollers()\nThis method is static and can be called without an instance.", &_init_f_activeScrollers_0, &_call_f_activeScrollers_0);
  methods += new qt_gsi::GenericStaticMethod ("grabGesture", "@brief Static method Qt::GestureType QScroller::grabGesture(QObject *target, QScroller::ScrollerGestureType gestureType)\nThis method is static and can be called without an instance.", &_init_f_grabGesture_4656, &_call_f_grabGesture_4656);
  methods += new qt_gsi::GenericStaticMethod ("grabbedGesture", "@brief Static method Qt::GestureType QScroller::grabbedGesture(QObject *target)\nThis method is static and can be called without an instance.", &_init_f_grabbedGesture_1302, &_call_f_grabbedGesture_1302);
  methods += new qt_gsi::GenericStaticMethod ("hasScroller", "@brief Static method bool QScroller::hasScroller(QObject *target)\nThis method is static and can be called without an instance.", &_init_f_hasScroller_1302, &_call_f_hasScroller_1302);
  methods += new qt_gsi::GenericStaticMethod ("scroller", "@brief Static method QScroller *QScroller::scroller(QObject *target)\nThis method is static and can be called without an instance.", &_init_f_scroller_1302, &_call_f_scroller_1302);
  methods += new qt_gsi::GenericStaticMethod ("scroller", "@brief Static method const QScroller *QScroller::scroller(const QObject *target)\nThis method is static and can be called without an instance.", &_init_f_scroller_1997, &_call_f_scroller_1997);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QScroller::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QScroller::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericStaticMethod ("ungrabGesture", "@brief Static method void QScroller::ungrabGesture(QObject *target)\nThis method is static and can be called without an instance.", &_init_f_ungrabGesture_1302, &_call_f_ungrabGesture_1302);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QScroller> decl_QScroller (qtdecl_QObject (), "QtWidgets", "QScroller",
  methods_QScroller (),
  "@qt\n@brief Binding of QScroller");


GSI_QTWIDGETS_PUBLIC gsi::Class<QScroller> &qtdecl_QScroller () { return decl_QScroller; }

}


//  Implementation of the enum wrapper class for QScroller::Input
namespace qt_gsi
{

static gsi::Enum<QScroller::Input> decl_QScroller_Input_Enum ("QtWidgets", "QScroller_Input",
    gsi::enum_const ("InputPress", QScroller::InputPress, "@brief Enum constant QScroller::InputPress") +
    gsi::enum_const ("InputMove", QScroller::InputMove, "@brief Enum constant QScroller::InputMove") +
    gsi::enum_const ("InputRelease", QScroller::InputRelease, "@brief Enum constant QScroller::InputRelease"),
  "@qt\n@brief This class represents the QScroller::Input enum");

static gsi::QFlagsClass<QScroller::Input > decl_QScroller_Input_Enums ("QtWidgets", "QScroller_QFlags_Input",
  "@qt\n@brief This class represents the QFlags<QScroller::Input> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QScroller> inject_QScroller_Input_Enum_in_parent (decl_QScroller_Input_Enum.defs ());
static gsi::ClassExt<QScroller> decl_QScroller_Input_Enum_as_child (decl_QScroller_Input_Enum, "Input");
static gsi::ClassExt<QScroller> decl_QScroller_Input_Enums_as_child (decl_QScroller_Input_Enums, "QFlags_Input");

}


//  Implementation of the enum wrapper class for QScroller::ScrollerGestureType
namespace qt_gsi
{

static gsi::Enum<QScroller::ScrollerGestureType> decl_QScroller_ScrollerGestureType_Enum ("QtWidgets", "QScroller_ScrollerGestureType",
    gsi::enum_const ("TouchGesture", QScroller::TouchGesture, "@brief Enum constant QScroller::TouchGesture") +
    gsi::enum_const ("LeftMouseButtonGesture", QScroller::LeftMouseButtonGesture, "@brief Enum constant QScroller::LeftMouseButtonGesture") +
    gsi::enum_const ("RightMouseButtonGesture", QScroller::RightMouseButtonGesture, "@brief Enum constant QScroller::RightMouseButtonGesture") +
    gsi::enum_const ("MiddleMouseButtonGesture", QScroller::MiddleMouseButtonGesture, "@brief Enum constant QScroller::MiddleMouseButtonGesture"),
  "@qt\n@brief This class represents the QScroller::ScrollerGestureType enum");

static gsi::QFlagsClass<QScroller::ScrollerGestureType > decl_QScroller_ScrollerGestureType_Enums ("QtWidgets", "QScroller_QFlags_ScrollerGestureType",
  "@qt\n@brief This class represents the QFlags<QScroller::ScrollerGestureType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QScroller> inject_QScroller_ScrollerGestureType_Enum_in_parent (decl_QScroller_ScrollerGestureType_Enum.defs ());
static gsi::ClassExt<QScroller> decl_QScroller_ScrollerGestureType_Enum_as_child (decl_QScroller_ScrollerGestureType_Enum, "ScrollerGestureType");
static gsi::ClassExt<QScroller> decl_QScroller_ScrollerGestureType_Enums_as_child (decl_QScroller_ScrollerGestureType_Enums, "QFlags_ScrollerGestureType");

}


//  Implementation of the enum wrapper class for QScroller::State
namespace qt_gsi
{

static gsi::Enum<QScroller::State> decl_QScroller_State_Enum ("QtWidgets", "QScroller_State",
    gsi::enum_const ("Inactive", QScroller::Inactive, "@brief Enum constant QScroller::Inactive") +
    gsi::enum_const ("Pressed", QScroller::Pressed, "@brief Enum constant QScroller::Pressed") +
    gsi::enum_const ("Dragging", QScroller::Dragging, "@brief Enum constant QScroller::Dragging") +
    gsi::enum_const ("Scrolling", QScroller::Scrolling, "@brief Enum constant QScroller::Scrolling"),
  "@qt\n@brief This class represents the QScroller::State enum");

static gsi::QFlagsClass<QScroller::State > decl_QScroller_State_Enums ("QtWidgets", "QScroller_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QScroller::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QScroller> inject_QScroller_State_Enum_in_parent (decl_QScroller_State_Enum.defs ());
static gsi::ClassExt<QScroller> decl_QScroller_State_Enum_as_child (decl_QScroller_State_Enum, "State");
static gsi::ClassExt<QScroller> decl_QScroller_State_Enums_as_child (decl_QScroller_State_Enums, "QFlags_State");

}

