
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRadioTuner.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRadioTuner>
#include <QChildEvent>
#include <QEvent>
#include <QMediaService>
#include <QMetaMethod>
#include <QObject>
#include <QRadioData>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRadioTuner

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRadioTuner::staticMetaObject);
}


// void QRadioTuner::antennaConnectedChanged(bool connectionStatus)


static void _init_f_antennaConnectedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("connectionStatus");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_antennaConnectedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->antennaConnectedChanged (arg1);
}


// QMultimedia::AvailabilityStatus QRadioTuner::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QRadioTuner *)cls)->availability ()));
}


// QRadioTuner::Band QRadioTuner::band()


static void _init_f_band_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::Band>::target_type > ();
}

static void _call_f_band_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::Band>::target_type > ((qt_gsi::Converter<QRadioTuner::Band>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::Band>(((QRadioTuner *)cls)->band ()));
}


// void QRadioTuner::bandChanged(QRadioTuner::Band band)


static void _init_f_bandChanged_2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("band");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_bandChanged_2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->bandChanged (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref());
}


// void QRadioTuner::cancelSearch()


static void _init_f_cancelSearch_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cancelSearch_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->cancelSearch ();
}


// QRadioTuner::Error QRadioTuner::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::Error>::target_type > ((qt_gsi::Converter<QRadioTuner::Error>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::Error>(((QRadioTuner *)cls)->error ()));
}


// void QRadioTuner::error(QRadioTuner::Error error)


static void _init_f_error_2176 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2176 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->error (qt_gsi::QtToCppAdaptor<QRadioTuner::Error>(arg1).cref());
}


// QString QRadioTuner::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioTuner *)cls)->errorString ());
}


// int QRadioTuner::frequency()


static void _init_f_frequency_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_frequency_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTuner *)cls)->frequency ());
}


// void QRadioTuner::frequencyChanged(int frequency)


static void _init_f_frequencyChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_frequencyChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->frequencyChanged (arg1);
}


// QPair<int, int> QRadioTuner::frequencyRange(QRadioTuner::Band band)


static void _init_f_frequencyRange_c2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("band");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<QPair<int, int> > ();
}

static void _call_f_frequencyRange_c2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  ret.write<QPair<int, int> > ((QPair<int, int>)((QRadioTuner *)cls)->frequencyRange (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref()));
}


// int QRadioTuner::frequencyStep(QRadioTuner::Band band)


static void _init_f_frequencyStep_c2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("band");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_frequencyStep_c2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  ret.write<int > ((int)((QRadioTuner *)cls)->frequencyStep (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref()));
}


// bool QRadioTuner::isAntennaConnected()


static void _init_f_isAntennaConnected_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAntennaConnected_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTuner *)cls)->isAntennaConnected ());
}


// bool QRadioTuner::isBandSupported(QRadioTuner::Band b)


static void _init_f_isBandSupported_c2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isBandSupported_c2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QRadioTuner *)cls)->isBandSupported (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref()));
}


// bool QRadioTuner::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTuner *)cls)->isMuted ());
}


// bool QRadioTuner::isSearching()


static void _init_f_isSearching_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSearching_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTuner *)cls)->isSearching ());
}


// bool QRadioTuner::isStereo()


static void _init_f_isStereo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isStereo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTuner *)cls)->isStereo ());
}


// void QRadioTuner::mutedChanged(bool muted)


static void _init_f_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->mutedChanged (arg1);
}


// QRadioData *QRadioTuner::radioData()


static void _init_f_radioData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRadioData * > ();
}

static void _call_f_radioData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRadioData * > ((QRadioData *)((QRadioTuner *)cls)->radioData ());
}


// void QRadioTuner::searchAllStations(QRadioTuner::SearchMode searchMode)


static void _init_f_searchAllStations_2641 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("searchMode", true, "QRadioTuner::SearchFast");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_searchAllStations_2641 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QRadioTuner::SearchMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QRadioTuner::SearchMode>(heap, QRadioTuner::SearchFast), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->searchAllStations (qt_gsi::QtToCppAdaptor<QRadioTuner::SearchMode>(arg1).cref());
}


// void QRadioTuner::searchBackward()


static void _init_f_searchBackward_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_searchBackward_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->searchBackward ();
}


// void QRadioTuner::searchForward()


static void _init_f_searchForward_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_searchForward_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->searchForward ();
}


// void QRadioTuner::searchingChanged(bool searching)


static void _init_f_searchingChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("searching");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_searchingChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->searchingChanged (arg1);
}


// void QRadioTuner::setBand(QRadioTuner::Band band)


static void _init_f_setBand_2027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("band");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::Band>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBand_2027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::Band>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::Band>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->setBand (qt_gsi::QtToCppAdaptor<QRadioTuner::Band>(arg1).cref());
}


// void QRadioTuner::setFrequency(int frequency)


static void _init_f_setFrequency_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFrequency_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->setFrequency (arg1);
}


// void QRadioTuner::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->setMuted (arg1);
}


// void QRadioTuner::setStereoMode(QRadioTuner::StereoMode mode)


static void _init_f_setStereoMode_2669 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStereoMode_2669 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::StereoMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->setStereoMode (qt_gsi::QtToCppAdaptor<QRadioTuner::StereoMode>(arg1).cref());
}


// void QRadioTuner::setVolume(int volume)


static void _init_f_setVolume_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->setVolume (arg1);
}


// int QRadioTuner::signalStrength()


static void _init_f_signalStrength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_signalStrength_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTuner *)cls)->signalStrength ());
}


// void QRadioTuner::signalStrengthChanged(int signalStrength)


static void _init_f_signalStrengthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signalStrength");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_signalStrengthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->signalStrengthChanged (arg1);
}


// void QRadioTuner::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->start ();
}


// QRadioTuner::State QRadioTuner::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::State>::target_type > ((qt_gsi::Converter<QRadioTuner::State>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::State>(((QRadioTuner *)cls)->state ()));
}


// void QRadioTuner::stateChanged(QRadioTuner::State state)


static void _init_f_stateChanged_2167 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QRadioTuner::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_2167 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioTuner::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioTuner::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QRadioTuner::State>(arg1).cref());
}


// void QRadioTuner::stationFound(int frequency, QString stationId)


static void _init_f_stationFound_1807 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frequency");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stationId");
  decl->add_arg<QString > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_stationFound_1807 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QString arg2 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->stationFound (arg1, arg2);
}


// QRadioTuner::StereoMode QRadioTuner::stereoMode()


static void _init_f_stereoMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioTuner::StereoMode>::target_type > ();
}

static void _call_f_stereoMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioTuner::StereoMode>::target_type > ((qt_gsi::Converter<QRadioTuner::StereoMode>::target_type)qt_gsi::CppToQtAdaptor<QRadioTuner::StereoMode>(((QRadioTuner *)cls)->stereoMode ()));
}


// void QRadioTuner::stereoStatusChanged(bool stereo)


static void _init_f_stereoStatusChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stereo");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stereoStatusChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->stereoStatusChanged (arg1);
}


// void QRadioTuner::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->stop ();
}


// int QRadioTuner::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTuner *)cls)->volume ());
}


// void QRadioTuner::volumeChanged(int volume)


static void _init_f_volumeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_volumeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner *)cls)->volumeChanged (arg1);
}


// static QString QRadioTuner::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioTuner::tr (arg1, arg2, arg3));
}


// static QString QRadioTuner::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioTuner::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QRadioTuner () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("antennaConnectedChanged", "@brief Method void QRadioTuner::antennaConnectedChanged(bool connectionStatus)\n", false, &_init_f_antennaConnectedChanged_864, &_call_f_antennaConnectedChanged_864);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QRadioTuner::availability()\nThis is a reimplementation of QMediaObject::availability", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod (":band", "@brief Method QRadioTuner::Band QRadioTuner::band()\n", true, &_init_f_band_c0, &_call_f_band_c0);
  methods += new qt_gsi::GenericMethod ("bandChanged", "@brief Method void QRadioTuner::bandChanged(QRadioTuner::Band band)\n", false, &_init_f_bandChanged_2027, &_call_f_bandChanged_2027);
  methods += new qt_gsi::GenericMethod ("cancelSearch", "@brief Method void QRadioTuner::cancelSearch()\n", false, &_init_f_cancelSearch_0, &_call_f_cancelSearch_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QRadioTuner::Error QRadioTuner::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QRadioTuner::error(QRadioTuner::Error error)\n", false, &_init_f_error_2176, &_call_f_error_2176);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRadioTuner::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod (":frequency", "@brief Method int QRadioTuner::frequency()\n", true, &_init_f_frequency_c0, &_call_f_frequency_c0);
  methods += new qt_gsi::GenericMethod ("frequencyChanged", "@brief Method void QRadioTuner::frequencyChanged(int frequency)\n", false, &_init_f_frequencyChanged_767, &_call_f_frequencyChanged_767);
  methods += new qt_gsi::GenericMethod ("frequencyRange", "@brief Method QPair<int, int> QRadioTuner::frequencyRange(QRadioTuner::Band band)\n", true, &_init_f_frequencyRange_c2027, &_call_f_frequencyRange_c2027);
  methods += new qt_gsi::GenericMethod ("frequencyStep", "@brief Method int QRadioTuner::frequencyStep(QRadioTuner::Band band)\n", true, &_init_f_frequencyStep_c2027, &_call_f_frequencyStep_c2027);
  methods += new qt_gsi::GenericMethod ("isAntennaConnected?|:antennaConnected", "@brief Method bool QRadioTuner::isAntennaConnected()\n", true, &_init_f_isAntennaConnected_c0, &_call_f_isAntennaConnected_c0);
  methods += new qt_gsi::GenericMethod ("isBandSupported?", "@brief Method bool QRadioTuner::isBandSupported(QRadioTuner::Band b)\n", true, &_init_f_isBandSupported_c2027, &_call_f_isBandSupported_c2027);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QRadioTuner::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("isSearching?|:searching", "@brief Method bool QRadioTuner::isSearching()\n", true, &_init_f_isSearching_c0, &_call_f_isSearching_c0);
  methods += new qt_gsi::GenericMethod ("isStereo?|:stereo", "@brief Method bool QRadioTuner::isStereo()\n", true, &_init_f_isStereo_c0, &_call_f_isStereo_c0);
  methods += new qt_gsi::GenericMethod ("mutedChanged", "@brief Method void QRadioTuner::mutedChanged(bool muted)\n", false, &_init_f_mutedChanged_864, &_call_f_mutedChanged_864);
  methods += new qt_gsi::GenericMethod (":radioData", "@brief Method QRadioData *QRadioTuner::radioData()\n", true, &_init_f_radioData_c0, &_call_f_radioData_c0);
  methods += new qt_gsi::GenericMethod ("searchAllStations", "@brief Method void QRadioTuner::searchAllStations(QRadioTuner::SearchMode searchMode)\n", false, &_init_f_searchAllStations_2641, &_call_f_searchAllStations_2641);
  methods += new qt_gsi::GenericMethod ("searchBackward", "@brief Method void QRadioTuner::searchBackward()\n", false, &_init_f_searchBackward_0, &_call_f_searchBackward_0);
  methods += new qt_gsi::GenericMethod ("searchForward", "@brief Method void QRadioTuner::searchForward()\n", false, &_init_f_searchForward_0, &_call_f_searchForward_0);
  methods += new qt_gsi::GenericMethod ("searchingChanged", "@brief Method void QRadioTuner::searchingChanged(bool searching)\n", false, &_init_f_searchingChanged_864, &_call_f_searchingChanged_864);
  methods += new qt_gsi::GenericMethod ("setBand|band=", "@brief Method void QRadioTuner::setBand(QRadioTuner::Band band)\n", false, &_init_f_setBand_2027, &_call_f_setBand_2027);
  methods += new qt_gsi::GenericMethod ("setFrequency|frequency=", "@brief Method void QRadioTuner::setFrequency(int frequency)\n", false, &_init_f_setFrequency_767, &_call_f_setFrequency_767);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QRadioTuner::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setStereoMode|stereoMode=", "@brief Method void QRadioTuner::setStereoMode(QRadioTuner::StereoMode mode)\n", false, &_init_f_setStereoMode_2669, &_call_f_setStereoMode_2669);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QRadioTuner::setVolume(int volume)\n", false, &_init_f_setVolume_767, &_call_f_setVolume_767);
  methods += new qt_gsi::GenericMethod (":signalStrength", "@brief Method int QRadioTuner::signalStrength()\n", true, &_init_f_signalStrength_c0, &_call_f_signalStrength_c0);
  methods += new qt_gsi::GenericMethod ("signalStrengthChanged", "@brief Method void QRadioTuner::signalStrengthChanged(int signalStrength)\n", false, &_init_f_signalStrengthChanged_767, &_call_f_signalStrengthChanged_767);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QRadioTuner::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QRadioTuner::State QRadioTuner::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QRadioTuner::stateChanged(QRadioTuner::State state)\n", false, &_init_f_stateChanged_2167, &_call_f_stateChanged_2167);
  methods += new qt_gsi::GenericMethod ("stationFound", "@brief Method void QRadioTuner::stationFound(int frequency, QString stationId)\n", false, &_init_f_stationFound_1807, &_call_f_stationFound_1807);
  methods += new qt_gsi::GenericMethod (":stereoMode", "@brief Method QRadioTuner::StereoMode QRadioTuner::stereoMode()\n", true, &_init_f_stereoMode_c0, &_call_f_stereoMode_c0);
  methods += new qt_gsi::GenericMethod ("stereoStatusChanged", "@brief Method void QRadioTuner::stereoStatusChanged(bool stereo)\n", false, &_init_f_stereoStatusChanged_864, &_call_f_stereoStatusChanged_864);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QRadioTuner::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method int QRadioTuner::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericMethod ("volumeChanged", "@brief Method void QRadioTuner::volumeChanged(int volume)\n", false, &_init_f_volumeChanged_767, &_call_f_volumeChanged_767);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRadioTuner::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRadioTuner::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaObject> &qtdecl_QMediaObject ();

qt_gsi::QtNativeClass<QRadioTuner> decl_QRadioTuner (qtdecl_QMediaObject (), "QtMultimedia", "QRadioTuner_Native",
  methods_QRadioTuner (),
  "@hide\n@alias QRadioTuner");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QRadioTuner> &qtdecl_QRadioTuner () { return decl_QRadioTuner; }

}


class QRadioTuner_Adaptor : public QRadioTuner, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRadioTuner_Adaptor();

  //  [adaptor ctor] QRadioTuner::QRadioTuner(QObject *parent)
  QRadioTuner_Adaptor() : QRadioTuner()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QRadioTuner::QRadioTuner(QObject *parent)
  QRadioTuner_Adaptor(QObject *parent) : QRadioTuner(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QRadioTuner::addPropertyWatch(QByteArray const &name)
  void fp_QRadioTuner_addPropertyWatch_2309 (QByteArray const &name) {
    QRadioTuner::addPropertyWatch(name);
  }

  //  [expose] bool QRadioTuner::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRadioTuner_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRadioTuner::isSignalConnected(signal);
  }

  //  [expose] int QRadioTuner::receivers(const char *signal)
  int fp_QRadioTuner_receivers_c1731 (const char *signal) const {
    return QRadioTuner::receivers(signal);
  }

  //  [expose] void QRadioTuner::removePropertyWatch(QByteArray const &name)
  void fp_QRadioTuner_removePropertyWatch_2309 (QByteArray const &name) {
    QRadioTuner::removePropertyWatch(name);
  }

  //  [expose] QObject *QRadioTuner::sender()
  QObject * fp_QRadioTuner_sender_c0 () const {
    return QRadioTuner::sender();
  }

  //  [expose] int QRadioTuner::senderSignalIndex()
  int fp_QRadioTuner_senderSignalIndex_c0 () const {
    return QRadioTuner::senderSignalIndex();
  }

  //  [adaptor impl] QMultimedia::AvailabilityStatus QRadioTuner::availability()
  qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type cbs_availability_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(QRadioTuner::availability());
  }

  virtual QMultimedia::AvailabilityStatus availability() const
  {
    if (cb_availability_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(cb_availability_c0_0.issue<QRadioTuner_Adaptor, qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type>(&QRadioTuner_Adaptor::cbs_availability_c0_0)).cref();
    } else {
      return QRadioTuner::availability();
    }
  }

  //  [adaptor impl] bool QRadioTuner::bind(QObject *)
  bool cbs_bind_1302_0(QObject *arg1)
  {
    return QRadioTuner::bind(arg1);
  }

  virtual bool bind(QObject *arg1)
  {
    if (cb_bind_1302_0.can_issue()) {
      return cb_bind_1302_0.issue<QRadioTuner_Adaptor, bool, QObject *>(&QRadioTuner_Adaptor::cbs_bind_1302_0, arg1);
    } else {
      return QRadioTuner::bind(arg1);
    }
  }

  //  [adaptor impl] bool QRadioTuner::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QRadioTuner::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRadioTuner_Adaptor, bool, QEvent *>(&QRadioTuner_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QRadioTuner::event(arg1);
    }
  }

  //  [adaptor impl] bool QRadioTuner::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QRadioTuner::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRadioTuner_Adaptor, bool, QObject *, QEvent *>(&QRadioTuner_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QRadioTuner::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QRadioTuner::isAvailable()
  bool cbs_isAvailable_c0_0() const
  {
    return QRadioTuner::isAvailable();
  }

  virtual bool isAvailable() const
  {
    if (cb_isAvailable_c0_0.can_issue()) {
      return cb_isAvailable_c0_0.issue<QRadioTuner_Adaptor, bool>(&QRadioTuner_Adaptor::cbs_isAvailable_c0_0);
    } else {
      return QRadioTuner::isAvailable();
    }
  }

  //  [adaptor impl] QMediaService *QRadioTuner::service()
  QMediaService * cbs_service_c0_0() const
  {
    return QRadioTuner::service();
  }

  virtual QMediaService * service() const
  {
    if (cb_service_c0_0.can_issue()) {
      return cb_service_c0_0.issue<QRadioTuner_Adaptor, QMediaService *>(&QRadioTuner_Adaptor::cbs_service_c0_0);
    } else {
      return QRadioTuner::service();
    }
  }

  //  [adaptor impl] void QRadioTuner::unbind(QObject *)
  void cbs_unbind_1302_0(QObject *arg1)
  {
    QRadioTuner::unbind(arg1);
  }

  virtual void unbind(QObject *arg1)
  {
    if (cb_unbind_1302_0.can_issue()) {
      cb_unbind_1302_0.issue<QRadioTuner_Adaptor, QObject *>(&QRadioTuner_Adaptor::cbs_unbind_1302_0, arg1);
    } else {
      QRadioTuner::unbind(arg1);
    }
  }

  //  [adaptor impl] void QRadioTuner::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QRadioTuner::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRadioTuner_Adaptor, QChildEvent *>(&QRadioTuner_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QRadioTuner::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioTuner::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QRadioTuner::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRadioTuner_Adaptor, QEvent *>(&QRadioTuner_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QRadioTuner::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioTuner::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRadioTuner::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRadioTuner_Adaptor, const QMetaMethod &>(&QRadioTuner_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRadioTuner::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QRadioTuner::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QRadioTuner::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRadioTuner_Adaptor, QTimerEvent *>(&QRadioTuner_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QRadioTuner::timerEvent(arg1);
    }
  }

  gsi::Callback cb_availability_c0_0;
  gsi::Callback cb_bind_1302_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAvailable_c0_0;
  gsi::Callback cb_service_c0_0;
  gsi::Callback cb_unbind_1302_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QRadioTuner_Adaptor::~QRadioTuner_Adaptor() { }

//  Constructor QRadioTuner::QRadioTuner(QObject *parent) (adaptor class)

static void _init_ctor_QRadioTuner_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QRadioTuner_Adaptor> ();
}

static void _call_ctor_QRadioTuner_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QRadioTuner_Adaptor *> (new QRadioTuner_Adaptor (arg1));
}


// exposed void QRadioTuner::addPropertyWatch(QByteArray const &name)

static void _init_fp_addPropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addPropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->fp_QRadioTuner_addPropertyWatch_2309 (arg1);
}


// QMultimedia::AvailabilityStatus QRadioTuner::availability()

static void _init_cbs_availability_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_cbs_availability_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)((QRadioTuner_Adaptor *)cls)->cbs_availability_c0_0 ());
}

static void _set_callback_cbs_availability_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_availability_c0_0 = cb;
}


// bool QRadioTuner::bind(QObject *)

static void _init_cbs_bind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_bind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QRadioTuner_Adaptor *)cls)->cbs_bind_1302_0 (arg1));
}

static void _set_callback_cbs_bind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_bind_1302_0 = cb;
}


// void QRadioTuner::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QRadioTuner::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QRadioTuner::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QRadioTuner::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioTuner_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRadioTuner::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioTuner_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QRadioTuner::isAvailable()

static void _init_cbs_isAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioTuner_Adaptor *)cls)->cbs_isAvailable_c0_0 ());
}

static void _set_callback_cbs_isAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_isAvailable_c0_0 = cb;
}


// exposed bool QRadioTuner::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QRadioTuner_Adaptor *)cls)->fp_QRadioTuner_isSignalConnected_c2394 (arg1));
}


// exposed int QRadioTuner::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QRadioTuner_Adaptor *)cls)->fp_QRadioTuner_receivers_c1731 (arg1));
}


// exposed void QRadioTuner::removePropertyWatch(QByteArray const &name)

static void _init_fp_removePropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_removePropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->fp_QRadioTuner_removePropertyWatch_2309 (arg1);
}


// exposed QObject *QRadioTuner::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRadioTuner_Adaptor *)cls)->fp_QRadioTuner_sender_c0 ());
}


// exposed int QRadioTuner::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioTuner_Adaptor *)cls)->fp_QRadioTuner_senderSignalIndex_c0 ());
}


// QMediaService *QRadioTuner::service()

static void _init_cbs_service_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_cbs_service_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QRadioTuner_Adaptor *)cls)->cbs_service_c0_0 ());
}

static void _set_callback_cbs_service_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_service_c0_0 = cb;
}


// void QRadioTuner::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QRadioTuner::unbind(QObject *)

static void _init_cbs_unbind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unbind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioTuner_Adaptor *)cls)->cbs_unbind_1302_0 (arg1);
}

static void _set_callback_cbs_unbind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioTuner_Adaptor *)cls)->cb_unbind_1302_0 = cb;
}


namespace gsi
{

gsi::Class<QRadioTuner> &qtdecl_QRadioTuner ();

static gsi::Methods methods_QRadioTuner_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRadioTuner::QRadioTuner(QObject *parent)\nThis method creates an object of class QRadioTuner.", &_init_ctor_QRadioTuner_Adaptor_1302, &_call_ctor_QRadioTuner_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*addPropertyWatch", "@brief Method void QRadioTuner::addPropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addPropertyWatch_2309, &_call_fp_addPropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Virtual method QMultimedia::AvailabilityStatus QRadioTuner::availability()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("availability", "@hide", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0, &_set_callback_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Virtual method bool QRadioTuner::bind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("bind", "@hide", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0, &_set_callback_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRadioTuner::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRadioTuner::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRadioTuner::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QRadioTuner::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRadioTuner::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@brief Virtual method bool QRadioTuner::isAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@hide", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0, &_set_callback_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRadioTuner::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRadioTuner::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removePropertyWatch", "@brief Method void QRadioTuner::removePropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removePropertyWatch_2309, &_call_fp_removePropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRadioTuner::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRadioTuner::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("service", "@brief Virtual method QMediaService *QRadioTuner::service()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("service", "@hide", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0, &_set_callback_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRadioTuner::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Virtual method void QRadioTuner::unbind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@hide", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0, &_set_callback_cbs_unbind_1302_0);
  return methods;
}

gsi::Class<QRadioTuner_Adaptor> decl_QRadioTuner_Adaptor (qtdecl_QRadioTuner (), "QtMultimedia", "QRadioTuner",
  methods_QRadioTuner_Adaptor (),
  "@qt\n@brief Binding of QRadioTuner");

}


//  Implementation of the enum wrapper class for QRadioTuner::Band
namespace qt_gsi
{

static gsi::Enum<QRadioTuner::Band> decl_QRadioTuner_Band_Enum ("QtMultimedia", "QRadioTuner_Band",
    gsi::enum_const ("AM", QRadioTuner::AM, "@brief Enum constant QRadioTuner::AM") +
    gsi::enum_const ("FM", QRadioTuner::FM, "@brief Enum constant QRadioTuner::FM") +
    gsi::enum_const ("SW", QRadioTuner::SW, "@brief Enum constant QRadioTuner::SW") +
    gsi::enum_const ("LW", QRadioTuner::LW, "@brief Enum constant QRadioTuner::LW") +
    gsi::enum_const ("FM2", QRadioTuner::FM2, "@brief Enum constant QRadioTuner::FM2"),
  "@qt\n@brief This class represents the QRadioTuner::Band enum");

static gsi::QFlagsClass<QRadioTuner::Band > decl_QRadioTuner_Band_Enums ("QtMultimedia", "QRadioTuner_QFlags_Band",
  "@qt\n@brief This class represents the QFlags<QRadioTuner::Band> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioTuner> inject_QRadioTuner_Band_Enum_in_parent (decl_QRadioTuner_Band_Enum.defs ());
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_Band_Enum_as_child (decl_QRadioTuner_Band_Enum, "Band");
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_Band_Enums_as_child (decl_QRadioTuner_Band_Enums, "QFlags_Band");

}


//  Implementation of the enum wrapper class for QRadioTuner::Error
namespace qt_gsi
{

static gsi::Enum<QRadioTuner::Error> decl_QRadioTuner_Error_Enum ("QtMultimedia", "QRadioTuner_Error",
    gsi::enum_const ("NoError", QRadioTuner::NoError, "@brief Enum constant QRadioTuner::NoError") +
    gsi::enum_const ("ResourceError", QRadioTuner::ResourceError, "@brief Enum constant QRadioTuner::ResourceError") +
    gsi::enum_const ("OpenError", QRadioTuner::OpenError, "@brief Enum constant QRadioTuner::OpenError") +
    gsi::enum_const ("OutOfRangeError", QRadioTuner::OutOfRangeError, "@brief Enum constant QRadioTuner::OutOfRangeError"),
  "@qt\n@brief This class represents the QRadioTuner::Error enum");

static gsi::QFlagsClass<QRadioTuner::Error > decl_QRadioTuner_Error_Enums ("QtMultimedia", "QRadioTuner_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QRadioTuner::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioTuner> inject_QRadioTuner_Error_Enum_in_parent (decl_QRadioTuner_Error_Enum.defs ());
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_Error_Enum_as_child (decl_QRadioTuner_Error_Enum, "Error");
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_Error_Enums_as_child (decl_QRadioTuner_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QRadioTuner::SearchMode
namespace qt_gsi
{

static gsi::Enum<QRadioTuner::SearchMode> decl_QRadioTuner_SearchMode_Enum ("QtMultimedia", "QRadioTuner_SearchMode",
    gsi::enum_const ("SearchFast", QRadioTuner::SearchFast, "@brief Enum constant QRadioTuner::SearchFast") +
    gsi::enum_const ("SearchGetStationId", QRadioTuner::SearchGetStationId, "@brief Enum constant QRadioTuner::SearchGetStationId"),
  "@qt\n@brief This class represents the QRadioTuner::SearchMode enum");

static gsi::QFlagsClass<QRadioTuner::SearchMode > decl_QRadioTuner_SearchMode_Enums ("QtMultimedia", "QRadioTuner_QFlags_SearchMode",
  "@qt\n@brief This class represents the QFlags<QRadioTuner::SearchMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioTuner> inject_QRadioTuner_SearchMode_Enum_in_parent (decl_QRadioTuner_SearchMode_Enum.defs ());
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_SearchMode_Enum_as_child (decl_QRadioTuner_SearchMode_Enum, "SearchMode");
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_SearchMode_Enums_as_child (decl_QRadioTuner_SearchMode_Enums, "QFlags_SearchMode");

}


//  Implementation of the enum wrapper class for QRadioTuner::State
namespace qt_gsi
{

static gsi::Enum<QRadioTuner::State> decl_QRadioTuner_State_Enum ("QtMultimedia", "QRadioTuner_State",
    gsi::enum_const ("ActiveState", QRadioTuner::ActiveState, "@brief Enum constant QRadioTuner::ActiveState") +
    gsi::enum_const ("StoppedState", QRadioTuner::StoppedState, "@brief Enum constant QRadioTuner::StoppedState"),
  "@qt\n@brief This class represents the QRadioTuner::State enum");

static gsi::QFlagsClass<QRadioTuner::State > decl_QRadioTuner_State_Enums ("QtMultimedia", "QRadioTuner_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QRadioTuner::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioTuner> inject_QRadioTuner_State_Enum_in_parent (decl_QRadioTuner_State_Enum.defs ());
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_State_Enum_as_child (decl_QRadioTuner_State_Enum, "State");
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_State_Enums_as_child (decl_QRadioTuner_State_Enums, "QFlags_State");

}


//  Implementation of the enum wrapper class for QRadioTuner::StereoMode
namespace qt_gsi
{

static gsi::Enum<QRadioTuner::StereoMode> decl_QRadioTuner_StereoMode_Enum ("QtMultimedia", "QRadioTuner_StereoMode",
    gsi::enum_const ("ForceStereo", QRadioTuner::ForceStereo, "@brief Enum constant QRadioTuner::ForceStereo") +
    gsi::enum_const ("ForceMono", QRadioTuner::ForceMono, "@brief Enum constant QRadioTuner::ForceMono") +
    gsi::enum_const ("Auto", QRadioTuner::Auto, "@brief Enum constant QRadioTuner::Auto"),
  "@qt\n@brief This class represents the QRadioTuner::StereoMode enum");

static gsi::QFlagsClass<QRadioTuner::StereoMode > decl_QRadioTuner_StereoMode_Enums ("QtMultimedia", "QRadioTuner_QFlags_StereoMode",
  "@qt\n@brief This class represents the QFlags<QRadioTuner::StereoMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioTuner> inject_QRadioTuner_StereoMode_Enum_in_parent (decl_QRadioTuner_StereoMode_Enum.defs ());
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_StereoMode_Enum_as_child (decl_QRadioTuner_StereoMode_Enum, "StereoMode");
static gsi::ClassExt<QRadioTuner> decl_QRadioTuner_StereoMode_Enums_as_child (decl_QRadioTuner_StereoMode_Enums, "QFlags_StereoMode");

}

