
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPaintEngine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPaintEngine>
#include <QImage>
#include <QPaintDevice>
#include <QPaintEngineState>
#include <QPainter>
#include <QPainterPath>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRectF>
#include <QRegion>
#include <QTextItem>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPaintEngine

// bool QPaintEngine::begin(QPaintDevice *pdev)


static void _init_f_begin_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pdev");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_begin_1803 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  ret.write<bool > ((bool)((QPaintEngine *)cls)->begin (arg1));
}


// void QPaintEngine::clearDirty(QFlags<QPaintEngine::DirtyFlag> df)


static void _init_f_clearDirty_3337 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("df");
  decl->add_arg<QFlags<QPaintEngine::DirtyFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_clearDirty_3337 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPaintEngine::DirtyFlag> arg1 = gsi::arg_reader<QFlags<QPaintEngine::DirtyFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->clearDirty (arg1);
}


// QPoint QPaintEngine::coordinateOffset()


static void _init_f_coordinateOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_coordinateOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QPaintEngine *)cls)->coordinateOffset ());
}


// void QPaintEngine::drawEllipse(const QRectF &r)


static void _init_f_drawEllipse_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawEllipse (arg1);
}


// void QPaintEngine::drawEllipse(const QRect &r)


static void _init_f_drawEllipse_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawEllipse_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawEllipse (arg1);
}


// void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_drawImage_8645 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawImage_8645 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  const QRectF &arg3 = gsi::arg_reader<const QRectF & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawImage (arg1, arg2, arg3, arg4);
}


// void QPaintEngine::drawPath(const QPainterPath &path)


static void _init_f_drawPath_2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_drawPath_2514 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = gsi::arg_reader<const QPainterPath & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawPath (arg1);
}


// void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)


static void _init_f_drawPixmap_5525 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawPixmap_5525 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QRectF &arg3 = gsi::arg_reader<const QRectF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawPixmap (arg1, arg2, arg3);
}


// void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)


static void _init_f_drawTextItem_4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("textItem");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawTextItem_4092 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QTextItem &arg2 = gsi::arg_reader<const QTextItem & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawTextItem (arg1, arg2);
}


// void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)


static void _init_f_drawTiledPixmap_5649 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("s");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_drawTiledPixmap_5649 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  const QPixmap &arg2 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QPointF &arg3 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->drawTiledPixmap (arg1, arg2, arg3);
}


// bool QPaintEngine::end()


static void _init_f_end_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_end_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPaintEngine *)cls)->end ());
}


// bool QPaintEngine::hasFeature(QFlags<QPaintEngine::PaintEngineFeature> feature)


static void _init_f_hasFeature_c4257 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("feature");
  decl->add_arg<QFlags<QPaintEngine::PaintEngineFeature> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasFeature_c4257 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPaintEngine::PaintEngineFeature> arg1 = gsi::arg_reader<QFlags<QPaintEngine::PaintEngineFeature> >() (args, heap);
  ret.write<bool > ((bool)((QPaintEngine *)cls)->hasFeature (arg1));
}


// bool QPaintEngine::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPaintEngine *)cls)->isActive ());
}


// bool QPaintEngine::isExtended()


static void _init_f_isExtended_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isExtended_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPaintEngine *)cls)->isExtended ());
}


// QPaintDevice *QPaintEngine::paintDevice()


static void _init_f_paintDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_paintDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPaintEngine *)cls)->paintDevice ());
}


// QPainter *QPaintEngine::painter()


static void _init_f_painter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_f_painter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPaintEngine *)cls)->painter ());
}


// void QPaintEngine::setActive(bool newState)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->setActive (arg1);
}


// void QPaintEngine::setDirty(QFlags<QPaintEngine::DirtyFlag> df)


static void _init_f_setDirty_3337 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("df");
  decl->add_arg<QFlags<QPaintEngine::DirtyFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirty_3337 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPaintEngine::DirtyFlag> arg1 = gsi::arg_reader<QFlags<QPaintEngine::DirtyFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->setDirty (arg1);
}


// void QPaintEngine::setPaintDevice(QPaintDevice *device)


static void _init_f_setPaintDevice_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaintDevice_1803 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = gsi::arg_reader<QPaintDevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->setPaintDevice (arg1);
}


// void QPaintEngine::setSystemClip(const QRegion &baseClip)


static void _init_f_setSystemClip_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("baseClip");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemClip_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->setSystemClip (arg1);
}


// void QPaintEngine::setSystemRect(const QRect &rect)


static void _init_f_setSystemRect_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemRect_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->setSystemRect (arg1);
}


// void QPaintEngine::syncState()


static void _init_f_syncState_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_syncState_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->syncState ();
}


// QRegion QPaintEngine::systemClip()


static void _init_f_systemClip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_systemClip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QPaintEngine *)cls)->systemClip ());
}


// QRect QPaintEngine::systemRect()


static void _init_f_systemRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_systemRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QPaintEngine *)cls)->systemRect ());
}


// bool QPaintEngine::testDirty(QFlags<QPaintEngine::DirtyFlag> df)


static void _init_f_testDirty_3337 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("df");
  decl->add_arg<QFlags<QPaintEngine::DirtyFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testDirty_3337 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPaintEngine::DirtyFlag> arg1 = gsi::arg_reader<QFlags<QPaintEngine::DirtyFlag> >() (args, heap);
  ret.write<bool > ((bool)((QPaintEngine *)cls)->testDirty (arg1));
}


// QPaintEngine::Type QPaintEngine::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPaintEngine::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPaintEngine::Type>::target_type > ((qt_gsi::Converter<QPaintEngine::Type>::target_type)qt_gsi::CppToQtAdaptor<QPaintEngine::Type>(((QPaintEngine *)cls)->type ()));
}


// void QPaintEngine::updateState(const QPaintEngineState &state)


static void _init_f_updateState_3013 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QPaintEngineState & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateState_3013 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPaintEngineState &arg1 = gsi::arg_reader<const QPaintEngineState & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine *)cls)->updateState (arg1);
}


namespace gsi
{

static gsi::Methods methods_QPaintEngine () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("begin", "@brief Method bool QPaintEngine::begin(QPaintDevice *pdev)\n", false, &_init_f_begin_1803, &_call_f_begin_1803);
  methods += new qt_gsi::GenericMethod ("clearDirty", "@brief Method void QPaintEngine::clearDirty(QFlags<QPaintEngine::DirtyFlag> df)\n", false, &_init_f_clearDirty_3337, &_call_f_clearDirty_3337);
  methods += new qt_gsi::GenericMethod ("coordinateOffset", "@brief Method QPoint QPaintEngine::coordinateOffset()\n", true, &_init_f_coordinateOffset_c0, &_call_f_coordinateOffset_c0);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPaintEngine::drawEllipse(const QRectF &r)\n", false, &_init_f_drawEllipse_1862, &_call_f_drawEllipse_1862);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Method void QPaintEngine::drawEllipse(const QRect &r)\n", false, &_init_f_drawEllipse_1792, &_call_f_drawEllipse_1792);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Method void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)\n", false, &_init_f_drawImage_8645, &_call_f_drawImage_8645);
  methods += new qt_gsi::GenericMethod ("drawPath", "@brief Method void QPaintEngine::drawPath(const QPainterPath &path)\n", false, &_init_f_drawPath_2514, &_call_f_drawPath_2514);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Method void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)\n", false, &_init_f_drawPixmap_5525, &_call_f_drawPixmap_5525);
  methods += new qt_gsi::GenericMethod ("drawTextItem", "@brief Method void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)\n", false, &_init_f_drawTextItem_4092, &_call_f_drawTextItem_4092);
  methods += new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Method void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)\n", false, &_init_f_drawTiledPixmap_5649, &_call_f_drawTiledPixmap_5649);
  methods += new qt_gsi::GenericMethod ("end", "@brief Method bool QPaintEngine::end()\n", false, &_init_f_end_0, &_call_f_end_0);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Method bool QPaintEngine::hasFeature(QFlags<QPaintEngine::PaintEngineFeature> feature)\n", true, &_init_f_hasFeature_c4257, &_call_f_hasFeature_c4257);
  methods += new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QPaintEngine::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("isExtended?", "@brief Method bool QPaintEngine::isExtended()\n", true, &_init_f_isExtended_c0, &_call_f_isExtended_c0);
  methods += new qt_gsi::GenericMethod (":paintDevice", "@brief Method QPaintDevice *QPaintEngine::paintDevice()\n", true, &_init_f_paintDevice_c0, &_call_f_paintDevice_c0);
  methods += new qt_gsi::GenericMethod ("painter", "@brief Method QPainter *QPaintEngine::painter()\n", true, &_init_f_painter_c0, &_call_f_painter_c0);
  methods += new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QPaintEngine::setActive(bool newState)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
  methods += new qt_gsi::GenericMethod ("setDirty", "@brief Method void QPaintEngine::setDirty(QFlags<QPaintEngine::DirtyFlag> df)\n", false, &_init_f_setDirty_3337, &_call_f_setDirty_3337);
  methods += new qt_gsi::GenericMethod ("setPaintDevice|paintDevice=", "@brief Method void QPaintEngine::setPaintDevice(QPaintDevice *device)\n", false, &_init_f_setPaintDevice_1803, &_call_f_setPaintDevice_1803);
  methods += new qt_gsi::GenericMethod ("setSystemClip|systemClip=", "@brief Method void QPaintEngine::setSystemClip(const QRegion &baseClip)\n", false, &_init_f_setSystemClip_2006, &_call_f_setSystemClip_2006);
  methods += new qt_gsi::GenericMethod ("setSystemRect|systemRect=", "@brief Method void QPaintEngine::setSystemRect(const QRect &rect)\n", false, &_init_f_setSystemRect_1792, &_call_f_setSystemRect_1792);
  methods += new qt_gsi::GenericMethod ("syncState", "@brief Method void QPaintEngine::syncState()\n", false, &_init_f_syncState_0, &_call_f_syncState_0);
  methods += new qt_gsi::GenericMethod (":systemClip", "@brief Method QRegion QPaintEngine::systemClip()\n", true, &_init_f_systemClip_c0, &_call_f_systemClip_c0);
  methods += new qt_gsi::GenericMethod (":systemRect", "@brief Method QRect QPaintEngine::systemRect()\n", true, &_init_f_systemRect_c0, &_call_f_systemRect_c0);
  methods += new qt_gsi::GenericMethod ("testDirty", "@brief Method bool QPaintEngine::testDirty(QFlags<QPaintEngine::DirtyFlag> df)\n", false, &_init_f_testDirty_3337, &_call_f_testDirty_3337);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method QPaintEngine::Type QPaintEngine::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod ("updateState", "@brief Method void QPaintEngine::updateState(const QPaintEngineState &state)\n", false, &_init_f_updateState_3013, &_call_f_updateState_3013);
  return methods;
}

gsi::Class<QPaintEngine> decl_QPaintEngine ("QtGui", "QPaintEngine_Native",
  methods_QPaintEngine (),
  "@hide\n@alias QPaintEngine");

GSI_QTGUI_PUBLIC gsi::Class<QPaintEngine> &qtdecl_QPaintEngine () { return decl_QPaintEngine; }

}


class QPaintEngine_Adaptor : public QPaintEngine, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPaintEngine_Adaptor();

  //  [adaptor ctor] QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features)
  QPaintEngine_Adaptor() : QPaintEngine()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features)
  QPaintEngine_Adaptor(QFlags<QPaintEngine::PaintEngineFeature> features) : QPaintEngine(features)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] bool QPaintEngine::begin(QPaintDevice *pdev)
  bool cbs_begin_1803_0(QPaintDevice *pdev)
  {
    __SUPPRESS_UNUSED_WARNING (pdev);
    throw qt_gsi::AbstractMethodCalledException("begin");
  }

  virtual bool begin(QPaintDevice *pdev)
  {
    if (cb_begin_1803_0.can_issue()) {
      return cb_begin_1803_0.issue<QPaintEngine_Adaptor, bool, QPaintDevice *>(&QPaintEngine_Adaptor::cbs_begin_1803_0, pdev);
    } else {
      throw qt_gsi::AbstractMethodCalledException("begin");
    }
  }

  //  [adaptor impl] QPoint QPaintEngine::coordinateOffset()
  QPoint cbs_coordinateOffset_c0_0() const
  {
    return QPaintEngine::coordinateOffset();
  }

  virtual QPoint coordinateOffset() const
  {
    if (cb_coordinateOffset_c0_0.can_issue()) {
      return cb_coordinateOffset_c0_0.issue<QPaintEngine_Adaptor, QPoint>(&QPaintEngine_Adaptor::cbs_coordinateOffset_c0_0);
    } else {
      return QPaintEngine::coordinateOffset();
    }
  }

  //  [adaptor impl] void QPaintEngine::drawEllipse(const QRectF &r)
  void cbs_drawEllipse_1862_0(const QRectF &r)
  {
    QPaintEngine::drawEllipse(r);
  }

  virtual void drawEllipse(const QRectF &r)
  {
    if (cb_drawEllipse_1862_0.can_issue()) {
      cb_drawEllipse_1862_0.issue<QPaintEngine_Adaptor, const QRectF &>(&QPaintEngine_Adaptor::cbs_drawEllipse_1862_0, r);
    } else {
      QPaintEngine::drawEllipse(r);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawEllipse(const QRect &r)
  void cbs_drawEllipse_1792_0(const QRect &r)
  {
    QPaintEngine::drawEllipse(r);
  }

  virtual void drawEllipse(const QRect &r)
  {
    if (cb_drawEllipse_1792_0.can_issue()) {
      cb_drawEllipse_1792_0.issue<QPaintEngine_Adaptor, const QRect &>(&QPaintEngine_Adaptor::cbs_drawEllipse_1792_0, r);
    } else {
      QPaintEngine::drawEllipse(r);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)
  void cbs_drawImage_8645_1(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)
  {
    QPaintEngine::drawImage(r, pm, sr, flags);
  }

  virtual void drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)
  {
    if (cb_drawImage_8645_1.can_issue()) {
      cb_drawImage_8645_1.issue<QPaintEngine_Adaptor, const QRectF &, const QImage &, const QRectF &, QFlags<Qt::ImageConversionFlag> >(&QPaintEngine_Adaptor::cbs_drawImage_8645_1, r, pm, sr, flags);
    } else {
      QPaintEngine::drawImage(r, pm, sr, flags);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawPath(const QPainterPath &path)
  void cbs_drawPath_2514_0(const QPainterPath &path)
  {
    QPaintEngine::drawPath(path);
  }

  virtual void drawPath(const QPainterPath &path)
  {
    if (cb_drawPath_2514_0.can_issue()) {
      cb_drawPath_2514_0.issue<QPaintEngine_Adaptor, const QPainterPath &>(&QPaintEngine_Adaptor::cbs_drawPath_2514_0, path);
    } else {
      QPaintEngine::drawPath(path);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)
  void cbs_drawPixmap_5525_0(const QRectF &r, const QPixmap &pm, const QRectF &sr)
  {
    __SUPPRESS_UNUSED_WARNING (r);
    __SUPPRESS_UNUSED_WARNING (pm);
    __SUPPRESS_UNUSED_WARNING (sr);
    throw qt_gsi::AbstractMethodCalledException("drawPixmap");
  }

  virtual void drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)
  {
    if (cb_drawPixmap_5525_0.can_issue()) {
      cb_drawPixmap_5525_0.issue<QPaintEngine_Adaptor, const QRectF &, const QPixmap &, const QRectF &>(&QPaintEngine_Adaptor::cbs_drawPixmap_5525_0, r, pm, sr);
    } else {
      throw qt_gsi::AbstractMethodCalledException("drawPixmap");
    }
  }

  //  [adaptor impl] void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)
  void cbs_drawTextItem_4092_0(const QPointF &p, const QTextItem &textItem)
  {
    QPaintEngine::drawTextItem(p, textItem);
  }

  virtual void drawTextItem(const QPointF &p, const QTextItem &textItem)
  {
    if (cb_drawTextItem_4092_0.can_issue()) {
      cb_drawTextItem_4092_0.issue<QPaintEngine_Adaptor, const QPointF &, const QTextItem &>(&QPaintEngine_Adaptor::cbs_drawTextItem_4092_0, p, textItem);
    } else {
      QPaintEngine::drawTextItem(p, textItem);
    }
  }

  //  [adaptor impl] void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)
  void cbs_drawTiledPixmap_5649_0(const QRectF &r, const QPixmap &pixmap, const QPointF &s)
  {
    QPaintEngine::drawTiledPixmap(r, pixmap, s);
  }

  virtual void drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)
  {
    if (cb_drawTiledPixmap_5649_0.can_issue()) {
      cb_drawTiledPixmap_5649_0.issue<QPaintEngine_Adaptor, const QRectF &, const QPixmap &, const QPointF &>(&QPaintEngine_Adaptor::cbs_drawTiledPixmap_5649_0, r, pixmap, s);
    } else {
      QPaintEngine::drawTiledPixmap(r, pixmap, s);
    }
  }

  //  [adaptor impl] bool QPaintEngine::end()
  bool cbs_end_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("end");
  }

  virtual bool end()
  {
    if (cb_end_0_0.can_issue()) {
      return cb_end_0_0.issue<QPaintEngine_Adaptor, bool>(&QPaintEngine_Adaptor::cbs_end_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("end");
    }
  }

  //  [adaptor impl] QPaintEngine::Type QPaintEngine::type()
  qt_gsi::Converter<QPaintEngine::Type>::target_type cbs_type_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("type");
  }

  virtual QPaintEngine::Type type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QPaintEngine::Type>(cb_type_c0_0.issue<QPaintEngine_Adaptor, qt_gsi::Converter<QPaintEngine::Type>::target_type>(&QPaintEngine_Adaptor::cbs_type_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("type");
    }
  }

  //  [adaptor impl] void QPaintEngine::updateState(const QPaintEngineState &state)
  void cbs_updateState_3013_0(const QPaintEngineState &state)
  {
    __SUPPRESS_UNUSED_WARNING (state);
    throw qt_gsi::AbstractMethodCalledException("updateState");
  }

  virtual void updateState(const QPaintEngineState &state)
  {
    if (cb_updateState_3013_0.can_issue()) {
      cb_updateState_3013_0.issue<QPaintEngine_Adaptor, const QPaintEngineState &>(&QPaintEngine_Adaptor::cbs_updateState_3013_0, state);
    } else {
      throw qt_gsi::AbstractMethodCalledException("updateState");
    }
  }

  gsi::Callback cb_begin_1803_0;
  gsi::Callback cb_coordinateOffset_c0_0;
  gsi::Callback cb_drawEllipse_1862_0;
  gsi::Callback cb_drawEllipse_1792_0;
  gsi::Callback cb_drawImage_8645_1;
  gsi::Callback cb_drawPath_2514_0;
  gsi::Callback cb_drawPixmap_5525_0;
  gsi::Callback cb_drawTextItem_4092_0;
  gsi::Callback cb_drawTiledPixmap_5649_0;
  gsi::Callback cb_end_0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_updateState_3013_0;
};

QPaintEngine_Adaptor::~QPaintEngine_Adaptor() { }

//  Constructor QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features) (adaptor class)

static void _init_ctor_QPaintEngine_Adaptor_4257 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("features", true, "0");
  decl->add_arg<QFlags<QPaintEngine::PaintEngineFeature> > (argspec_0);
  decl->set_return_new<QPaintEngine_Adaptor> ();
}

static void _call_ctor_QPaintEngine_Adaptor_4257 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QPaintEngine::PaintEngineFeature> arg1 = args ? gsi::arg_reader<QFlags<QPaintEngine::PaintEngineFeature> >() (args, heap) : gsi::arg_maker<QFlags<QPaintEngine::PaintEngineFeature> >() (0, heap);
  ret.write<QPaintEngine_Adaptor *> (new QPaintEngine_Adaptor (arg1));
}


// bool QPaintEngine::begin(QPaintDevice *pdev)

static void _init_cbs_begin_1803_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pdev");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_begin_1803_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintDevice *arg1 = args.read<QPaintDevice * > (heap);
  ret.write<bool > ((bool)((QPaintEngine_Adaptor *)cls)->cbs_begin_1803_0 (arg1));
}

static void _set_callback_cbs_begin_1803_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_begin_1803_0 = cb;
}


// QPoint QPaintEngine::coordinateOffset()

static void _init_cbs_coordinateOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_cbs_coordinateOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QPaintEngine_Adaptor *)cls)->cbs_coordinateOffset_c0_0 ());
}

static void _set_callback_cbs_coordinateOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_coordinateOffset_c0_0 = cb;
}


// void QPaintEngine::drawEllipse(const QRectF &r)

static void _init_cbs_drawEllipse_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawEllipse_1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawEllipse_1862_0 (arg1);
}

static void _set_callback_cbs_drawEllipse_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawEllipse_1862_0 = cb;
}


// void QPaintEngine::drawEllipse(const QRect &r)

static void _init_cbs_drawEllipse_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawEllipse_1792_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawEllipse_1792_0 (arg1);
}

static void _set_callback_cbs_drawEllipse_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawEllipse_1792_0 = cb;
}


// void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)

static void _init_cbs_drawImage_8645_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QImage & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("flags");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawImage_8645_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  const QImage &arg2 = args.read<const QImage & > (heap);
  const QRectF &arg3 = args.read<const QRectF & > (heap);
  QFlags<Qt::ImageConversionFlag> arg4 = args.read<QFlags<Qt::ImageConversionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawImage_8645_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawImage_8645_1 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawImage_8645_1 = cb;
}


// void QPaintEngine::drawPath(const QPainterPath &path)

static void _init_cbs_drawPath_2514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_drawPath_2514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = args.read<const QPainterPath & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawPath_2514_0 (arg1);
}

static void _set_callback_cbs_drawPath_2514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawPath_2514_0 = cb;
}


// void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)

static void _init_cbs_drawPixmap_5525_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pm");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sr");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawPixmap_5525_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  const QPixmap &arg2 = args.read<const QPixmap & > (heap);
  const QRectF &arg3 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawPixmap_5525_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawPixmap_5525_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawPixmap_5525_0 = cb;
}


// void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)

static void _init_cbs_drawTextItem_4092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("textItem");
  decl->add_arg<const QTextItem & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawTextItem_4092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  const QTextItem &arg2 = args.read<const QTextItem & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawTextItem_4092_0 (arg1, arg2);
}

static void _set_callback_cbs_drawTextItem_4092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawTextItem_4092_0 = cb;
}


// void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)

static void _init_cbs_drawTiledPixmap_5649_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("s");
  decl->add_arg<const QPointF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawTiledPixmap_5649_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  const QPixmap &arg2 = args.read<const QPixmap & > (heap);
  const QPointF &arg3 = args.read<const QPointF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_drawTiledPixmap_5649_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawTiledPixmap_5649_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_drawTiledPixmap_5649_0 = cb;
}


// bool QPaintEngine::end()

static void _init_cbs_end_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_end_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPaintEngine_Adaptor *)cls)->cbs_end_0_0 ());
}

static void _set_callback_cbs_end_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_end_0_0 = cb;
}


// QPaintEngine::Type QPaintEngine::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPaintEngine::Type>::target_type > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPaintEngine::Type>::target_type > ((qt_gsi::Converter<QPaintEngine::Type>::target_type)((QPaintEngine_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_type_c0_0 = cb;
}


// void QPaintEngine::updateState(const QPaintEngineState &state)

static void _init_cbs_updateState_3013_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QPaintEngineState & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_3013_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPaintEngineState &arg1 = args.read<const QPaintEngineState & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPaintEngine_Adaptor *)cls)->cbs_updateState_3013_0 (arg1);
}

static void _set_callback_cbs_updateState_3013_0 (void *cls, const gsi::Callback &cb)
{
  ((QPaintEngine_Adaptor *)cls)->cb_updateState_3013_0 = cb;
}


namespace gsi
{

gsi::Class<QPaintEngine> &qtdecl_QPaintEngine ();

static gsi::Methods methods_QPaintEngine_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPaintEngine::QPaintEngine(QFlags<QPaintEngine::PaintEngineFeature> features)\nThis method creates an object of class QPaintEngine.", &_init_ctor_QPaintEngine_Adaptor_4257, &_call_ctor_QPaintEngine_Adaptor_4257);
  methods += new qt_gsi::GenericMethod ("begin", "@brief Virtual method bool QPaintEngine::begin(QPaintDevice *pdev)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_begin_1803_0, &_call_cbs_begin_1803_0);
  methods += new qt_gsi::GenericMethod ("begin", "@hide", false, &_init_cbs_begin_1803_0, &_call_cbs_begin_1803_0, &_set_callback_cbs_begin_1803_0);
  methods += new qt_gsi::GenericMethod ("coordinateOffset", "@brief Virtual method QPoint QPaintEngine::coordinateOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_coordinateOffset_c0_0, &_call_cbs_coordinateOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("coordinateOffset", "@hide", true, &_init_cbs_coordinateOffset_c0_0, &_call_cbs_coordinateOffset_c0_0, &_set_callback_cbs_coordinateOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Virtual method void QPaintEngine::drawEllipse(const QRectF &r)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawEllipse_1862_0, &_call_cbs_drawEllipse_1862_0);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@hide", false, &_init_cbs_drawEllipse_1862_0, &_call_cbs_drawEllipse_1862_0, &_set_callback_cbs_drawEllipse_1862_0);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@brief Virtual method void QPaintEngine::drawEllipse(const QRect &r)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawEllipse_1792_0, &_call_cbs_drawEllipse_1792_0);
  methods += new qt_gsi::GenericMethod ("drawEllipse", "@hide", false, &_init_cbs_drawEllipse_1792_0, &_call_cbs_drawEllipse_1792_0, &_set_callback_cbs_drawEllipse_1792_0);
  methods += new qt_gsi::GenericMethod ("drawImage", "@brief Virtual method void QPaintEngine::drawImage(const QRectF &r, const QImage &pm, const QRectF &sr, QFlags<Qt::ImageConversionFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawImage_8645_1, &_call_cbs_drawImage_8645_1);
  methods += new qt_gsi::GenericMethod ("drawImage", "@hide", false, &_init_cbs_drawImage_8645_1, &_call_cbs_drawImage_8645_1, &_set_callback_cbs_drawImage_8645_1);
  methods += new qt_gsi::GenericMethod ("drawPath", "@brief Virtual method void QPaintEngine::drawPath(const QPainterPath &path)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawPath_2514_0, &_call_cbs_drawPath_2514_0);
  methods += new qt_gsi::GenericMethod ("drawPath", "@hide", false, &_init_cbs_drawPath_2514_0, &_call_cbs_drawPath_2514_0, &_set_callback_cbs_drawPath_2514_0);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@brief Virtual method void QPaintEngine::drawPixmap(const QRectF &r, const QPixmap &pm, const QRectF &sr)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawPixmap_5525_0, &_call_cbs_drawPixmap_5525_0);
  methods += new qt_gsi::GenericMethod ("drawPixmap", "@hide", false, &_init_cbs_drawPixmap_5525_0, &_call_cbs_drawPixmap_5525_0, &_set_callback_cbs_drawPixmap_5525_0);
  methods += new qt_gsi::GenericMethod ("drawTextItem", "@brief Virtual method void QPaintEngine::drawTextItem(const QPointF &p, const QTextItem &textItem)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawTextItem_4092_0, &_call_cbs_drawTextItem_4092_0);
  methods += new qt_gsi::GenericMethod ("drawTextItem", "@hide", false, &_init_cbs_drawTextItem_4092_0, &_call_cbs_drawTextItem_4092_0, &_set_callback_cbs_drawTextItem_4092_0);
  methods += new qt_gsi::GenericMethod ("drawTiledPixmap", "@brief Virtual method void QPaintEngine::drawTiledPixmap(const QRectF &r, const QPixmap &pixmap, const QPointF &s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawTiledPixmap_5649_0, &_call_cbs_drawTiledPixmap_5649_0);
  methods += new qt_gsi::GenericMethod ("drawTiledPixmap", "@hide", false, &_init_cbs_drawTiledPixmap_5649_0, &_call_cbs_drawTiledPixmap_5649_0, &_set_callback_cbs_drawTiledPixmap_5649_0);
  methods += new qt_gsi::GenericMethod ("end", "@brief Virtual method bool QPaintEngine::end()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_end_0_0, &_call_cbs_end_0_0);
  methods += new qt_gsi::GenericMethod ("end", "@hide", false, &_init_cbs_end_0_0, &_call_cbs_end_0_0, &_set_callback_cbs_end_0_0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Virtual method QPaintEngine::Type QPaintEngine::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("updateState", "@brief Virtual method void QPaintEngine::updateState(const QPaintEngineState &state)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_3013_0, &_call_cbs_updateState_3013_0);
  methods += new qt_gsi::GenericMethod ("updateState", "@hide", false, &_init_cbs_updateState_3013_0, &_call_cbs_updateState_3013_0, &_set_callback_cbs_updateState_3013_0);
  return methods;
}

gsi::Class<QPaintEngine_Adaptor> decl_QPaintEngine_Adaptor (qtdecl_QPaintEngine (), "QtGui", "QPaintEngine",
  methods_QPaintEngine_Adaptor (),
  "@qt\n@brief Binding of QPaintEngine");

}


//  Implementation of the enum wrapper class for QPaintEngine::DirtyFlag
namespace qt_gsi
{

static gsi::Enum<QPaintEngine::DirtyFlag> decl_QPaintEngine_DirtyFlag_Enum ("QtGui", "QPaintEngine_DirtyFlag",
    gsi::enum_const ("DirtyPen", QPaintEngine::DirtyPen, "@brief Enum constant QPaintEngine::DirtyPen") +
    gsi::enum_const ("DirtyBrush", QPaintEngine::DirtyBrush, "@brief Enum constant QPaintEngine::DirtyBrush") +
    gsi::enum_const ("DirtyBrushOrigin", QPaintEngine::DirtyBrushOrigin, "@brief Enum constant QPaintEngine::DirtyBrushOrigin") +
    gsi::enum_const ("DirtyFont", QPaintEngine::DirtyFont, "@brief Enum constant QPaintEngine::DirtyFont") +
    gsi::enum_const ("DirtyBackground", QPaintEngine::DirtyBackground, "@brief Enum constant QPaintEngine::DirtyBackground") +
    gsi::enum_const ("DirtyBackgroundMode", QPaintEngine::DirtyBackgroundMode, "@brief Enum constant QPaintEngine::DirtyBackgroundMode") +
    gsi::enum_const ("DirtyTransform", QPaintEngine::DirtyTransform, "@brief Enum constant QPaintEngine::DirtyTransform") +
    gsi::enum_const ("DirtyClipRegion", QPaintEngine::DirtyClipRegion, "@brief Enum constant QPaintEngine::DirtyClipRegion") +
    gsi::enum_const ("DirtyClipPath", QPaintEngine::DirtyClipPath, "@brief Enum constant QPaintEngine::DirtyClipPath") +
    gsi::enum_const ("DirtyHints", QPaintEngine::DirtyHints, "@brief Enum constant QPaintEngine::DirtyHints") +
    gsi::enum_const ("DirtyCompositionMode", QPaintEngine::DirtyCompositionMode, "@brief Enum constant QPaintEngine::DirtyCompositionMode") +
    gsi::enum_const ("DirtyClipEnabled", QPaintEngine::DirtyClipEnabled, "@brief Enum constant QPaintEngine::DirtyClipEnabled") +
    gsi::enum_const ("DirtyOpacity", QPaintEngine::DirtyOpacity, "@brief Enum constant QPaintEngine::DirtyOpacity") +
    gsi::enum_const ("AllDirty", QPaintEngine::AllDirty, "@brief Enum constant QPaintEngine::AllDirty"),
  "@qt\n@brief This class represents the QPaintEngine::DirtyFlag enum");

static gsi::QFlagsClass<QPaintEngine::DirtyFlag > decl_QPaintEngine_DirtyFlag_Enums ("QtGui", "QPaintEngine_QFlags_DirtyFlag",
  "@qt\n@brief This class represents the QFlags<QPaintEngine::DirtyFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPaintEngine> inject_QPaintEngine_DirtyFlag_Enum_in_parent (decl_QPaintEngine_DirtyFlag_Enum.defs ());
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_DirtyFlag_Enum_as_child (decl_QPaintEngine_DirtyFlag_Enum, "DirtyFlag");
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_DirtyFlag_Enums_as_child (decl_QPaintEngine_DirtyFlag_Enums, "QFlags_DirtyFlag");

}


//  Implementation of the enum wrapper class for QPaintEngine::PaintEngineFeature
namespace qt_gsi
{

static gsi::Enum<QPaintEngine::PaintEngineFeature> decl_QPaintEngine_PaintEngineFeature_Enum ("QtGui", "QPaintEngine_PaintEngineFeature",
    gsi::enum_const ("PrimitiveTransform", QPaintEngine::PrimitiveTransform, "@brief Enum constant QPaintEngine::PrimitiveTransform") +
    gsi::enum_const ("PatternTransform", QPaintEngine::PatternTransform, "@brief Enum constant QPaintEngine::PatternTransform") +
    gsi::enum_const ("PixmapTransform", QPaintEngine::PixmapTransform, "@brief Enum constant QPaintEngine::PixmapTransform") +
    gsi::enum_const ("PatternBrush", QPaintEngine::PatternBrush, "@brief Enum constant QPaintEngine::PatternBrush") +
    gsi::enum_const ("LinearGradientFill", QPaintEngine::LinearGradientFill, "@brief Enum constant QPaintEngine::LinearGradientFill") +
    gsi::enum_const ("RadialGradientFill", QPaintEngine::RadialGradientFill, "@brief Enum constant QPaintEngine::RadialGradientFill") +
    gsi::enum_const ("ConicalGradientFill", QPaintEngine::ConicalGradientFill, "@brief Enum constant QPaintEngine::ConicalGradientFill") +
    gsi::enum_const ("AlphaBlend", QPaintEngine::AlphaBlend, "@brief Enum constant QPaintEngine::AlphaBlend") +
    gsi::enum_const ("PorterDuff", QPaintEngine::PorterDuff, "@brief Enum constant QPaintEngine::PorterDuff") +
    gsi::enum_const ("PainterPaths", QPaintEngine::PainterPaths, "@brief Enum constant QPaintEngine::PainterPaths") +
    gsi::enum_const ("Antialiasing", QPaintEngine::Antialiasing, "@brief Enum constant QPaintEngine::Antialiasing") +
    gsi::enum_const ("BrushStroke", QPaintEngine::BrushStroke, "@brief Enum constant QPaintEngine::BrushStroke") +
    gsi::enum_const ("ConstantOpacity", QPaintEngine::ConstantOpacity, "@brief Enum constant QPaintEngine::ConstantOpacity") +
    gsi::enum_const ("MaskedBrush", QPaintEngine::MaskedBrush, "@brief Enum constant QPaintEngine::MaskedBrush") +
    gsi::enum_const ("PerspectiveTransform", QPaintEngine::PerspectiveTransform, "@brief Enum constant QPaintEngine::PerspectiveTransform") +
    gsi::enum_const ("BlendModes", QPaintEngine::BlendModes, "@brief Enum constant QPaintEngine::BlendModes") +
    gsi::enum_const ("ObjectBoundingModeGradients", QPaintEngine::ObjectBoundingModeGradients, "@brief Enum constant QPaintEngine::ObjectBoundingModeGradients") +
    gsi::enum_const ("RasterOpModes", QPaintEngine::RasterOpModes, "@brief Enum constant QPaintEngine::RasterOpModes") +
    gsi::enum_const ("PaintOutsidePaintEvent", QPaintEngine::PaintOutsidePaintEvent, "@brief Enum constant QPaintEngine::PaintOutsidePaintEvent") +
    gsi::enum_const ("AllFeatures", QPaintEngine::AllFeatures, "@brief Enum constant QPaintEngine::AllFeatures"),
  "@qt\n@brief This class represents the QPaintEngine::PaintEngineFeature enum");

static gsi::QFlagsClass<QPaintEngine::PaintEngineFeature > decl_QPaintEngine_PaintEngineFeature_Enums ("QtGui", "QPaintEngine_QFlags_PaintEngineFeature",
  "@qt\n@brief This class represents the QFlags<QPaintEngine::PaintEngineFeature> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPaintEngine> inject_QPaintEngine_PaintEngineFeature_Enum_in_parent (decl_QPaintEngine_PaintEngineFeature_Enum.defs ());
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_PaintEngineFeature_Enum_as_child (decl_QPaintEngine_PaintEngineFeature_Enum, "PaintEngineFeature");
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_PaintEngineFeature_Enums_as_child (decl_QPaintEngine_PaintEngineFeature_Enums, "QFlags_PaintEngineFeature");

}


//  Implementation of the enum wrapper class for QPaintEngine::Type
namespace qt_gsi
{

static gsi::Enum<QPaintEngine::Type> decl_QPaintEngine_Type_Enum ("QtGui", "QPaintEngine_Type",
    gsi::enum_const ("X11", QPaintEngine::X11, "@brief Enum constant QPaintEngine::X11") +
    gsi::enum_const ("Windows", QPaintEngine::Windows, "@brief Enum constant QPaintEngine::Windows") +
    gsi::enum_const ("QuickDraw", QPaintEngine::QuickDraw, "@brief Enum constant QPaintEngine::QuickDraw") +
    gsi::enum_const ("CoreGraphics", QPaintEngine::CoreGraphics, "@brief Enum constant QPaintEngine::CoreGraphics") +
    gsi::enum_const ("MacPrinter", QPaintEngine::MacPrinter, "@brief Enum constant QPaintEngine::MacPrinter") +
    gsi::enum_const ("QWindowSystem", QPaintEngine::QWindowSystem, "@brief Enum constant QPaintEngine::QWindowSystem") +
    gsi::enum_const ("PostScript", QPaintEngine::PostScript, "@brief Enum constant QPaintEngine::PostScript") +
    gsi::enum_const ("OpenGL", QPaintEngine::OpenGL, "@brief Enum constant QPaintEngine::OpenGL") +
    gsi::enum_const ("Picture", QPaintEngine::Picture, "@brief Enum constant QPaintEngine::Picture") +
    gsi::enum_const ("SVG", QPaintEngine::SVG, "@brief Enum constant QPaintEngine::SVG") +
    gsi::enum_const ("Raster", QPaintEngine::Raster, "@brief Enum constant QPaintEngine::Raster") +
    gsi::enum_const ("Direct3D", QPaintEngine::Direct3D, "@brief Enum constant QPaintEngine::Direct3D") +
    gsi::enum_const ("Pdf", QPaintEngine::Pdf, "@brief Enum constant QPaintEngine::Pdf") +
    gsi::enum_const ("OpenVG", QPaintEngine::OpenVG, "@brief Enum constant QPaintEngine::OpenVG") +
    gsi::enum_const ("OpenGL2", QPaintEngine::OpenGL2, "@brief Enum constant QPaintEngine::OpenGL2") +
    gsi::enum_const ("PaintBuffer", QPaintEngine::PaintBuffer, "@brief Enum constant QPaintEngine::PaintBuffer") +
    gsi::enum_const ("Blitter", QPaintEngine::Blitter, "@brief Enum constant QPaintEngine::Blitter") +
    gsi::enum_const ("Direct2D", QPaintEngine::Direct2D, "@brief Enum constant QPaintEngine::Direct2D") +
    gsi::enum_const ("User", QPaintEngine::User, "@brief Enum constant QPaintEngine::User") +
    gsi::enum_const ("MaxUser", QPaintEngine::MaxUser, "@brief Enum constant QPaintEngine::MaxUser"),
  "@qt\n@brief This class represents the QPaintEngine::Type enum");

static gsi::QFlagsClass<QPaintEngine::Type > decl_QPaintEngine_Type_Enums ("QtGui", "QPaintEngine_QFlags_Type",
  "@qt\n@brief This class represents the QFlags<QPaintEngine::Type> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPaintEngine> inject_QPaintEngine_Type_Enum_in_parent (decl_QPaintEngine_Type_Enum.defs ());
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_Type_Enum_as_child (decl_QPaintEngine_Type_Enum, "Type");
static gsi::ClassExt<QPaintEngine> decl_QPaintEngine_Type_Enums_as_child (decl_QPaintEngine_Type_Enums, "QFlags_Type");

}

