import logging
l = logging.getLogger(__name__)

WINDOW_SYSTEM_QT = 'QT'
WINDOW_SYSTEM_QT4 = 'QT4'
WINDOW_SYSTEM_WX = 'WX'

class GuiFactory:

    def getFactory(self,windowsystem, control):
        self.control = control
        self.windowsystem = windowsystem
        if self.windowsystem == WINDOW_SYSTEM_QT:
            try:
                from qtgui import qtfactory
            except:
                l.exception( "qt not available")

            self.factory = qtfactory.QtFactory()
        elif self.windowsystem == WINDOW_SYSTEM_QT4:
            try:
                from qt4gui import qt4factory
            except:
                l.exception( "qt4 not available")
            self.factory = qt4factory.Qt4Factory()
        else:
            try:
                from wxgui import wxfactory
            except:
                l.exception( "wxwindows not available")
            self.factory = wxfactory.wxfactory()
        return self.factory
    
