Installation
=============================

| Name                           |  Description                                                |
|  ----------------------------  |  ---------------------------------------------------------  |
|[ build_executable.jl ](https://github.com/JuliaLang/julia/blob/master/contrib/build_executable.jl) | Support building       standalone executables |
|[ build_sysimg.jl ](https://github.com/JuliaLang/julia/blob/master/contrib/build_sysimg.jl) | Build a system image binary |
|[ check-whitespace.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/check-whitespace.sh) | Check for trailing white space |                                                                                                                 
|[ fixup-libgfortran.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/fixup-libgfortran.sh) | Include libgfortran  and libquadmath for installations |
|[ fixup-libstdc++.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/fixup-libstdc++.sh) | Include libstdc++ for    installations |
|[ install.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/install.sh) | installation script with different       permissions |
|[ julia.appdata.xml ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.appdata.xml) | Appdata config file |
|[ julia.desktop ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.desktop) | GNOME desktop config file |
|[ julia.svg ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.svg) | julia svg image file |
|[ mac/ ](https://github.com/JuliaLang/julia/blob/master/contrib/mac/) | Mac install files |
|[ relative_path.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/relative_path.sh) | convert absolute path into   relative path script |
|[ stringreplace.c ](https://github.com/JuliaLang/julia/blob/master/contrib/stringreplace.c) | replace strings to hardcoded paths in binaries during `make install` |
|[ vagrant/ ](https://github.com/JuliaLang/julia/blob/master/contrib/vagrant/) | portable development environment Vagrant     install files |
|[ windows/ ](https://github.com/JuliaLang/julia/blob/master/contrib/windows/) | windows install files |

Editors  + Debuggers
=============================

| Name                           |  Description                                                |
| ------------------------------ | ----------------------------------------------------------- |
|[ ackrc  ](https://github.com/JuliaLang/julia/blob/master/contrib/ackrc ) |  config for Ack search tool |
|[ BBEditTextWrangler-julia.plist  ](https://github.com/JuliaLang/julia/blob/master/contrib/BBEditTextWrangler-julia.plist )  |  language module for BBEdit and TextWrangler text editors |
|[ ctags ](https://github.com/JuliaLang/julia/blob/master/contrib/ctags) | Add more keywords to ctags regex search tool |
|[ debug_bootstrap.gdb ](https://github.com/JuliaLang/julia/blob/master/contrib/debug_bootstrap.gdb) | bootstrap process      using the debug build |
|[ filterArgs.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/filterArgs.sh) | Update library search code to use  only tokens that start with -L |
|[ julia.hrc ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.hrc) | Julia syntax highlighting definition for   Colorer |
|[ julia.lang ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.lang) | GtkSourceView (GTK+ framework) for       multiline text editing config file |
|[ julia-mode.el ](https://github.com/JuliaLang/julia/blob/master/contrib/julia-mode.el) | Emacs Julia mode config file |
|[ Julia_Notepad++.xml ](https://github.com/JuliaLang/julia/blob/master/contrib/Julia_Notepad++.xml) | Notepad++ config file |
|[ julia.xml ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.xml) | KDE editors Kate and Kwrite config file |
|[ Notepad++_2_Julia.ahk ](https://github.com/JuliaLang/julia/blob/master/contrib/Notepad++_2_Julia.ahk) | Auto Hotkey for    Notepad++ config file |
|[ README.ackrc.txt ](https://github.com/JuliaLang/julia/blob/master/contrib/README.ackrc.txt) | README for ackrc config file |
|[ README.ctags.txt ](https://github.com/JuliaLang/julia/blob/master/contrib/README.ctags.txt) | README for ctags config file |
|[ repackage_system_suitesparse4.make ](https://github.com/JuliaLang/julia/blob/master/contrib/repackage_system_suitesparse4. make) | reinstall_suitesparse4 script |
|[ valgrind-julia.supp ](https://github.com/JuliaLang/julia/blob/master/contrib/valgrind-julia.supp) | suppressions for Valgrind debugging tool |
