# ISOPLOT -- Plots isophote parameters generated by task ELLIPSE.
#
# The STSDAS plotting facility is used to read 3 columns from
# the SDAS table generated by ELLIPSE and generate a graph.
#
#                                               Ivo Busko   10/89
#
#  8/19/93  Updated pset names for sgraph parameters.  This is not the
#  optimum solution, but is a quick interim fix.  ZGL
#
#  5/03/95  Modified to enable INDEFs in error bars (sgraph crashes with
#  INDEFs in error columns).  IB

procedure isoplot (input, xaxis, yaxis)

char	input  = ""         {prompt="input table"}
char	xaxis  = "RSMA"     {prompt="x axis",enum="SMA|RSMA"}
char	yaxis  = "MAG"      {prompt="y axis"}
char	device = "stdgraph" {prompt="output graphics device"}

begin
        file    in, temp1, temp2
        char    xa, ya, column, sdev, smark, serrc
	char	select
        int     iline, nlines, serra
        real    szmar
        bool    sappe, spoin, sflip

        # Check for the presence of pre-requisite packages.
        if (!deftask("sgraph")) {
            print ("Package 'stplot or tbplot' must be loaded first !\n")
            bye
        }
        if (!deftask("tcalc")) {
            print ("Package 'ttools' must be loaded first !\n")
            bye
        }

        # Save called tasks parameters.
        sdev  = dvpar.device
        sappe = dvpar.append
        smark = pltpar.marker
        szmar = pltpar.szmarker
        serra = pltpar.erraxis
        sflip = axispar.yflip
        serrc = sgraph.errcolumn
        spoin = pltpar.pointmode

        # Read task parameters.
        in = input
        xa = xaxis
        ya = yaxis
        dvpar.device = device

	# No error bars.
	sgraph.errcolumn = ""
	column = "NDATA"  # fake column signals NO error bars.

        # Set axis data.
        if (ya == "MAG")
            axispar.yflip = yes
        if (ya == "MAG") {
            sgraph.errcolumn = "MAG_LERR MAG_LERR"
	    column = "MAG_LERR"
	}
        else if (ya == "ELLIP") {
            sgraph.errcolumn = "ELLIP_ERR ELLIP_ERR"
	    column = "ELLIP_ERR"
	}
        else if (ya == "INTENS") {
            sgraph.errcolumn = "INT_ERR INT_ERR"
	    column = "INT_ERR"
	}
        else if (ya == "PA") {
            sgraph.errcolumn = "PA_ERR PA_ERR"
	    column = "PA_ERR"
	}
        else if (ya == "X0") {
            sgraph.errcolumn = "X0_ERR X0_ERR"
	    column = "X0_ERR"
	}
        else if (ya == "Y0") {
            sgraph.errcolumn = "Y0_ERR Y0_ERR"
	    column = "Y0_ERR"
	}
        else if (ya == "A3") {
            sgraph.errcolumn = "A3_ERR A3_ERR"
	    column = "A3_ERR"
	}
        else if (ya == "B3") {
            sgraph.errcolumn = "B3_ERR B3_ERR"
	    column = "B3_ERR"
	}
        else if (ya == "A4") {
            sgraph.errcolumn = "A4_ERR A4_ERR"
	    column = "A4_ERR"
	}
        else if (ya == "B4") {
	    sgraph.errcolumn = "B4_ERR B4_ERR"
	    column = "B4_ERR"
	}
        else if (ya == "GRAD") {
            sgraph.errcolumn = "GRAD_ERR GRAD_ERR"
	    column = "GRAD_ERR"
	}

	# Store table in temporary file.
	temp1 = mktemp ("tmp$isoplot")
	temp2 = mktemp ("tmp$isoplot")
        delete (temp1, go_ahead=yes, verify=no, default_action=yes,
                allversions=yes, subfiles=yes, >& "dev$null")
        delete (temp2, go_ahead=yes, verify=no, default_action=yes,
                allversions=yes, subfiles=yes, >& "dev$null")
	tcopy (in, temp1, verbose=no)

	# Remove first point when data is not relevant.
	if ((ya == "INTENS") || (ya == "MAG")) {
	    tabpar (temp1, ya, 1)
	    if (tabpar.undef) 
	        tselect (temp1, temp2, "row() != 1", mode="h")
	    else
	        tcopy (temp1, temp2, verbose=no)
	} else
	    tselect (temp1, temp2, "row() != 1", mode="h")

	# Remove INDEFs from error columns.
	tinfo (temp2, ttout=no)
	nlines = tinfo.nrows
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, column, iline)
	    if (tabpar.undef) 
	        partab (0., temp2, column, iline)
	}

        # Do it.
        pltpar.marker = "box"
        pltpar.szmarker = 0.015
        pltpar.erraxis = 2
        pltpar.pointmode = yes
        sgraph (temp2 // " " // xa // " " // ya)
	if (column != "NDATA") {
            pltpar.pointmode = no
            dvpar.append = yes
            sgraph (temp2 // " " // xa // " " // ya)
	}

        # Restore called tasks parameters.
        dvpar.device = sdev
        dvpar.append = sappe
        pltpar.marker = smark
        pltpar.szmarker = szmar
        pltpar.erraxis = serra
        axispar.yflip = sflip
        sgraph.errcolumn = serrc
        pltpar.pointmode = spoin

       delete (temp1 // ".tab", go_ahead=yes, verify=no, default_action=yes,
               allversions=yes, subfiles=yes, >& "dev$null")
       delete (temp2 // ".tab", go_ahead=yes, verify=no, default_action=yes,
               allversions=yes, subfiles=yes, >& "dev$null")
end

