# -*- makefile -*-
# --------------------------------------------------------------------
#
# Building Ipe --- common definitions
#
# --------------------------------------------------------------------
# Are we compiling for Windows?  For Mac OS X?
ifdef COMSPEC
  WIN32	=  1
  IPEBUNDLE = 1
  IPEUI = WIN32
else ifdef IPECROSS
  # http://mingw-w64.sourceforge.net/
  WIN32 = 1
  IPEBUNDLE = 1
  IPEUI = WIN32
else
  UNAME = $(shell uname)
  ifeq "$(UNAME)" "Darwin"
    MACOS = 1
    IPEUI = QT
  endif
endif
# --------------------------------------------------------------------
# IPESRCDIR is Ipe's top "src" directory
# if 'common.mak' is included on a different level than a subdirectory
# of "src", then IPESRCDIR must be set before including 'common.mak'.

IPESRCDIR ?= ..

# User interface library
# Possible values are QT, WIN32, GTK,
# but GTK is unfinished and WIN32 only works on Windows

IPEUI ?= QT

# --------------------------------------------------------------------
# Read configuration options (not used on Win32)

ifndef WIN32
ifdef MACOS
  include $(IPESRCDIR)/macos.mak
else
  include $(IPESRCDIR)/config.mak
endif
  BUILDDIR = $(IPESRCDIR)/../build
ifdef IPECXX
  CXX = $(IPECXX)
endif
endif

# --------------------------------------------------------------------

# set variables for UI choice
ifeq ($(IPEUI),QT)
CPPFLAGS += -DIPEUI_QT
# Qt5 requires -fPIC depending on its own compilation settings.
CPPFLAGS += -fPIC
CXXFLAGS += -fPIC
DLL_CFLAGS = -fPIC
IPEUI_QT := 1
UI_CFLAGS = $(QT_CFLAGS)
UI_LIBS = $(QT_LIBS)
moc_sources = $(addprefix moc_, $(subst .h,.cpp,$(moc_headers)))
all_sources = $(sources) $(qt_sources)
objects = $(addprefix $(OBJDIR)/, $(subst .cpp,.o,$(all_sources) \
	$(moc_sources)))
else
ifeq ($(IPEUI), WIN32)
CPPFLAGS += -DIPEUI_WIN32
IPEUI_WIN32 := 1
UI_CFLAGS := 
UI_LIBS := -lcomctl32 -lcomdlg32 -lgdi32 -lgdiplus
all_sources = $(sources) $(win_sources)
objects = $(addprefix $(OBJDIR)/, $(subst .cpp,.o,$(all_sources)))
else
ifeq ($(IPEUI), GTK)
CPPFLAGS += -DIPEUI_GTK -DGDK_DISABLE_DEPRECATED -DGTK_DISABLE_DEPRECATED
IPEUI_GTK := 1
UI_CFLAGS = $(GTK_CFLAGS)
UI_LIBS = $(GTK_LIBS)
all_sources = $(sources) $(gtk_sources)
BUILDDIR = $(IPESRCDIR)/../gtkbuild
objects = $(addprefix $(OBJDIR)/, $(subst .cpp,.o,$(all_sources)))
else
error("Unknown IPEUI selected")
endif
endif
endif

CXXFLAGS += -Wall

ifdef IPESTRICT
  CXXFLAGS += -Werror
endif

DEPEND ?= $(OBJDIR)/depend.mak

.PHONY: clean 
.PHONY: install
.PHONY: all

ifdef WIN32
  # iconv is not needed under windows
  IPE_USE_ICONV :=
  # Set just in case user has environment variables set
  IPEDOCDIR	:=
  IPEICONDIR	:=

  CPPFLAGS	+= -DWIN32 -DUNICODE -D_UNICODE
  DLL_LDFLAGS	+= -shared 
  PLUGIN_LDFLAGS += -shared
  DL_LIBS	:= 
  buildlib	= $(BUILDDIR)/bin
  buildbin = $(BUILDDIR)/bin
  buildipelets = $(BUILDDIR)/ipelets
  exe_target	= $(BUILDDIR)/bin/$1.exe
  dll_target    = $(buildlib)/$1.dll
  soname        = 
  dll_symlinks  = 
  install_symlinks = 
  ipelet_target = $(BUILDDIR)/ipelets/$1.dll

  BUILDDIR = $(IPESRCDIR)/../mingw
  CXXFLAGS	+= -g -O2 -fno-rtti -fno-exceptions
ifdef IPECROSS
  # --------------- Cross compiling with Mingw-w64 ---------------
  CXX = i686-w64-mingw32-g++
  CC = i686-w64-mingw32-gcc
  STRIP_TARGET  = i686-w64-mingw32-strip $(TARGET)
  WINDRES	= i686-w64-mingw32-windres
  IPEDEPS	?= /sw/mingwlibs
else
  # --------------- Compiling with Mingw-w64 under Windows ---------------
  WINDRES	= windres.exe
  CXXFLAGS	+= -g -O2
  STRIP_TARGET  = strip $(TARGET)
  IPEDEPS	?= /mingwlibs
endif

  ZLIB_CFLAGS   := -I$(IPEDEPS)/include
  ZLIB_LIBS     := -L$(IPEDEPS)/lib -lz
  FREETYPE_CFLAGS := -I$(IPEDEPS)/include/freetype2 \
       -I$(IPEDEPS)/include
  FREETYPE_LIBS := -L$(IPEDEPS)/lib -lfreetype
  CAIRO_CFLAGS  := -I$(IPEDEPS)/include/cairo
  CAIRO_LIBS    := -L$(IPEDEPS)/lib -lcairo
  LUA_CFLAGS    := -I$(IPEDEPS)/lua53/include
  LUA_LIBS      := $(IPEDEPS)/lua53/lua53.dll

  # using Windows services
  JPEG_CFLAGS   := 
  JPEG_LIBS     := -lgdiplus
  PNG_CFLAGS	:= 
  PNG_LIBS	:= -lgdiplus
  ICONV_CFLAGS  :=
  ICONV_LIBS    :=

else
  # -------------------- Unix --------------------
  CXXFLAGS	+= -g -O2
  ifdef MACOS
    DLL_LDFLAGS	+= -dynamiclib 
    PLUGIN_LDFLAGS += -bundle
    ifdef IPEBUNDLE
      IPELIBDIRINFO = @executable_path/../Frameworks
      buildlib	  = $(BUILDDIR)/Ipe.app/Contents/Frameworks
      buildbin = $(BUILDDIR)/Ipe.app/Contents/MacOS
      buildipelets = $(BUILDDIR)/Ipe.app/Contents/Resources/ipelets
      exe_target  = $(BUILDDIR)/Ipe.app/Contents/MacOS/$1
      ipelet_target = $(BUILDDIR)/Ipe.app/Contents/Resources/ipelets/$1.so
    else
      IPELIBDIRINFO ?= $(IPELIBDIR)
      buildlib	= $(BUILDDIR)/lib
      exe_target = $(BUILDDIR)/bin/$1
      ipelet_target = $(BUILDDIR)/ipelets/$1.so
      buildbin = $(BUILDDIR)/bin
      buildipelets = $(BUILDDIR)/ipelets
    endif
    soname      = -Wl,-dylib_install_name,$(IPELIBDIRINFO)/lib$1.$(IPEVERS).dylib
    dll_target    = $(buildlib)/lib$1.$(IPEVERS).dylib
    dll_symlinks  = ln -sf lib$1.$(IPEVERS).dylib $(buildlib)/lib$1.dylib
    install_symlinks = ln -sf lib$1.$(IPEVERS).dylib \
		$(INSTALL_ROOT)$(IPELIBDIR)/lib$1.dylib
  else	
    DLL_LDFLAGS	+= -shared 
    PLUGIN_LDFLAGS += -shared
    soname      = -Wl,-soname,lib$1.so.$(IPEVERS)
    dll_target    = $(buildlib)/lib$1.so.$(IPEVERS)
    dll_symlinks  = ln -sf lib$1.so.$(IPEVERS) $(buildlib)/lib$1.so
    install_symlinks = ln -sf lib$1.so.$(IPEVERS) \
			$(INSTALL_ROOT)$(IPELIBDIR)/lib$1.so
    buildlib	= $(BUILDDIR)/lib
    buildbin = $(BUILDDIR)/bin
    buildipelets = $(BUILDDIR)/ipelets
    exe_target	= $(BUILDDIR)/bin/$1
    ipelet_target = $(BUILDDIR)/ipelets/$1.so
  endif
endif

# Macros

INSTALL_DIR = install -d
INSTALL_FILES = install -m 0644
INSTALL_SCRIPTS = install -m 0755
ifdef MACOS
# stripping is faulty on Mac?
INSTALL_PROGRAMS = install -m 0755
else
INSTALL_PROGRAMS = install -s -m 0755
endif

MAKE_BINDIR = mkdir -p $(buildbin)

MAKE_LIBDIR = mkdir -p $(buildlib)

MAKE_IPELETDIR = mkdir -p $(buildipelets) 

MAKE_DEPEND = \
	mkdir -p $(OBJDIR); \
	echo "" > $@; \
	for f in $(all_sources); do \
	$(CXX) -MM -MT $(OBJDIR)/$${f%%.cpp}.o $(CPPFLAGS) $$f >> $@; done

# The rules

$(OBJDIR)/%.o:  %.cpp
	@echo Compiling $(<F)...
	$(COMPILE.cc) -o $@ $<

ifdef IPEUI_QT
moc_%.cpp:  %.h
	@echo Running moc on $(<F)...
	$(MOC) $(CPPFLAGS )-o $@ $<
endif

# --------------------------------------------------------------------
