/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

struct loggingplugininfo
{
	std::string pluginname;
};

typedef bool (*initloggingplugintype)(struct loggingplugininfo &loggingplugininfo,
	class Options &options, bool debugmode);
typedef void (*closeloggingplugintype)(void);
typedef int (*logeventstype)(std::vector<struct imevent> &imevents);

class LoggingPlugin
{
	public:
		struct loggingplugininfo loggingplugininfo;
	
		LoggingPlugin();
		~LoggingPlugin();
		bool loadplugin(std::string filename);
		bool unloadplugin(void);
		
		bool callinitloggingplugin(class Options &options, bool debugmode);
		void callcloseloggingplugin(void);
		int calllogevents(std::vector<struct imevent> &imevents);

	private:
		void *handle;

		initloggingplugintype initloggingplugin;
		closeloggingplugintype closeloggingplugin;
		logeventstype logevents;
};
