# - try to find glut library and include files
#  GLUT_INCLUDE_DIR, where to find GL/glut.h, etc.
#  GLUT_LIBRARIES, the libraries to link against
#  GLUT_FOUND, If false, do not try to use GLUT.
# Also defined, but not for general use are:
#  GLUT_glut_LIBRARY = the full path to the glut library.
#  GLUT_Xmu_LIBRARY  = the full path to the Xmu library.
#  GLUT_Xi_LIBRARY   = the full path to the Xi Library.


    FIND_PATH( OpenCV_INCLUDE_DIR cv.h
      /usr/include
      /usr/include/opencv
      /usr/local/include
      /usr/openwin/share/include
      /usr/openwin/include
      /usr/X11R6/include
      /usr/include/X11
    )

    FIND_LIBRARY( OpenCV_cv_LIBRARY cv
      /usr/lib
      /usr/local/lib
    )

    FIND_LIBRARY( OpenCV_cvaux_LIBRARY cvaux
      /usr/lib
      /usr/local/lib
    )

    FIND_LIBRARY( OpenCV_highgui_LIBRARY highgui
      /usr/lib
      /usr/local/lib
    )


SET( OpenCV_FOUND "NO" )
IF(OpenCV_INCLUDE_DIR)
  IF(OpenCV_cv_LIBRARY)
    SET( OpenCV_LIBRARIES
      ${OpenCV_cv_LIBRARY}
      ${OpenCV_cvaux_LIBRARY}
      ${OpenCV_highgui_LIBRARY}
    )
    SET( OpenCV_FOUND "YES" )

#The following deprecated settings are for backwards compatibility with CMake1.4
    SET (OpenCV_LIBRARY ${OpenCV_LIBRARIES})
    SET (OpenCV_INCLUDE_PATH ${OpenCV_INCLUDE_DIR})

  ENDIF(OpenCV_cv_LIBRARY)
ENDIF(OpenCV_INCLUDE_DIR)

MARK_AS_ADVANCED(
#  OpenCV_INCLUDE_DIR
#  OpenCV_cv_LIBRARY
  OpenCV_cvaux_LIBRARY
  OpenCV_highgui_LIBRARY
)


#MESSAGE(${OpenCV_INCLUDE_DIR})
#MESSAGE(${OpenCV_cv_LIBRARY})
#MESSAGE(${OpenCV_cvaux_LIBRARY})
#MESSAGE(${OpenCV_highgui_LIBRARY})
#MESSAGE(${OpenCV_LIBRARIES})

