/* $Id: endian.h,v 1.1.1.1 2005/08/04 19:45:27 jim-campbell Exp $ */

#ifndef RECCONV_ENDIAN_H
#define RECCONV_ENDIAN_H

#include <sys/types.h>

#ifdef __BIG_ENDIAN__
#define le16toh(x)	_bswap16((u_int16_t)x)
#define le32toh(x)	_bswap32((u_int32_t)x)
#define htole16(x)	_bswap16((u_int16_t)x)
#define htole32(x)	_bswap32((u_int32_t)x)

#else
#define le16toh(x)	(x)
#define le32toh(x)	(x)
#define htole16(x)	(x)
#define htole32(x)	(x)

#endif	/* __BIG_ENDIAN__ */

#define _bswap16(x)	( ((x & 0xff00) >> 8) | \
			  ((x & 0x00ff) << 8) )

#define _bswap32(x)	( ((x & 0xff000000) >> 24) | \
			  ((x & 0x00ff0000) >>  8) | \
			  ((x & 0x0000ff00) <<  8) | \
			  ((x & 0x000000ff) << 24) )


#endif	/* RECCONV_ENDIAN_H */
