/*
Copyright (c) 2015 - present Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "CUDA2HIP.h"

// Maps the names of CUDA SPARSE API functions to the corresponding HIP functions
const std::map<llvm::StringRef, hipCounter> CUDA_SPARSE_FUNCTION_MAP {
  // 5. cuSPARSE Management Function Reference
  {"cusparseCreate",                                    {"hipsparseCreate",                                    "rocsparse_create_handle",                                          CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseDestroy",                                   {"hipsparseDestroy",                                   "rocsparse_destroy_handle",                                         CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseGetPointerMode",                            {"hipsparseGetPointerMode",                            "rocsparse_get_pointer_mode",                                       CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseGetVersion",                                {"hipsparseGetVersion",                                "rocsparse_get_version",                                            CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseSetPointerMode",                            {"hipsparseSetPointerMode",                            "rocsparse_set_pointer_mode",                                       CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseSetStream",                                 {"hipsparseSetStream",                                 "rocsparse_set_stream",                                             CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseGetStream",                                 {"hipsparseGetStream",                                 "rocsparse_get_stream",                                             CONV_LIB_FUNC, API_SPARSE, 5}},
  {"cusparseGetErrorName",                              {"hipsparseGetErrorName",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 5, ROC_UNSUPPORTED}},
  {"cusparseGetErrorString",                            {"hipsparseGetErrorString",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 5, ROC_UNSUPPORTED}},

  // 6. cuSPARSE Logging
  {"cusparseLoggerSetCallback",                         {"hipsparseLoggerSetCallback",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 6, UNSUPPORTED}},
  {"cusparseLoggerSetFile",                             {"hipsparseLoggerSetFile",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 6, UNSUPPORTED}},
  {"cusparseLoggerOpenFile",                            {"hipsparseLoggerOpenFile",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 6, UNSUPPORTED}},
  {"cusparseLoggerSetLevel",                            {"hipsparseLoggerSetLevel",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 6, UNSUPPORTED}},
  {"cusparseLoggerSetMask",                             {"hipsparseLoggerSetMask",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 6, UNSUPPORTED}},
  {"cusparseLoggerForceDisable",                        {"hipsparseLoggerForceDisable",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 6, UNSUPPORTED}},

  // 7. cuSPARSE Helper Function Reference
  {"cusparseCreateSolveAnalysisInfo",                   {"hipsparseCreateSolveAnalysisInfo",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCreateHybMat",                              {"hipsparseCreateHybMat",                              "rocsparse_create_hyb_mat",                                         CONV_LIB_FUNC, API_SPARSE, 7, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCreateMatDescr",                            {"hipsparseCreateMatDescr",                            "rocsparse_create_mat_descr",                                       CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseDestroySolveAnalysisInfo",                  {"hipsparseDestroySolveAnalysisInfo",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDestroyHybMat",                             {"hipsparseDestroyHybMat",                             "rocsparse_destroy_hyb_mat",                                        CONV_LIB_FUNC, API_SPARSE, 7, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDestroyMatDescr",                           {"hipsparseDestroyMatDescr",                           "rocsparse_destroy_mat_descr",                                      CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseCopyMatDescr",                              {"hipsparseCopyMatDescr",                              "rocsparse_copy_mat_descr",                                         CONV_LIB_FUNC, API_SPARSE, 7, CUDA_REMOVED}},
  {"cusparseGetLevelInfo",                              {"hipsparseGetLevelInfo",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, UNSUPPORTED | CUDA_REMOVED}},
  {"cusparseGetMatDiagType",                            {"hipsparseGetMatDiagType",                            "rocsparse_get_mat_diag_type",                                      CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseGetMatFillMode",                            {"hipsparseGetMatFillMode",                            "rocsparse_get_mat_fill_mode",                                      CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseGetMatIndexBase",                           {"hipsparseGetMatIndexBase",                           "rocsparse_get_mat_index_base",                                     CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseGetMatType",                                {"hipsparseGetMatType",                                "rocsparse_get_mat_type",                                           CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseSetMatDiagType",                            {"hipsparseSetMatDiagType",                            "rocsparse_set_mat_diag_type",                                      CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseSetMatFillMode",                            {"hipsparseSetMatFillMode",                            "rocsparse_set_mat_fill_mode",                                      CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseSetMatIndexBase",                           {"hipsparseSetMatIndexBase",                           "rocsparse_set_mat_index_base",                                     CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseSetMatType",                                {"hipsparseSetMatType",                                "rocsparse_set_mat_type",                                           CONV_LIB_FUNC, API_SPARSE, 7}},
  {"cusparseCreateCsrsv2Info",                          {"hipsparseCreateCsrsv2Info",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDestroyCsrsv2Info",                         {"hipsparseDestroyCsrsv2Info",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCreateCsrsm2Info",                          {"hipsparseCreateCsrsm2Info",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDestroyCsrsm2Info",                         {"hipsparseDestroyCsrsm2Info",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCreateCsric02Info",                         {"hipsparseCreateCsric02Info",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyCsric02Info",                        {"hipsparseDestroyCsric02Info",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateCsrilu02Info",                        {"hipsparseCreateCsrilu02Info",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyCsrilu02Info",                       {"hipsparseDestroyCsrilu02Info",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateBsrsv2Info",                          {"hipsparseCreateBsrsv2Info",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyBsrsv2Info",                         {"hipsparseDestroyBsrsv2Info",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateBsrsm2Info",                          {"hipsparseCreateBsrsm2Info",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyBsrsm2Info",                         {"hipsparseDestroyBsrsm2Info",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateBsric02Info",                         {"hipsparseCreateBsric02Info",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyBsric02Info",                        {"hipsparseDestroyBsric02Info",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateBsrilu02Info",                        {"hipsparseCreateBsrilu02Info",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyBsrilu02Info",                       {"hipsparseDestroyBsrilu02Info",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateCsrgemm2Info",                        {"hipsparseCreateCsrgemm2Info",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDestroyCsrgemm2Info",                       {"hipsparseDestroyCsrgemm2Info",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCreatePruneInfo",                           {"hipsparseCreatePruneInfo",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyPruneInfo",                          {"hipsparseDestroyPruneInfo",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 7, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCreateColorInfo",                           {"hipsparseCreateColorInfo",                           "rocsparse_create_color_info",                                      CONV_LIB_FUNC, API_SPARSE, 7, CUDA_DEPRECATED}},
  {"cusparseDestroyColorInfo",                          {"hipsparseDestroyColorInfo",                          "rocsparse_destroy_color_info",                                     CONV_LIB_FUNC, API_SPARSE, 7, CUDA_DEPRECATED}},

  // 8. cuSPARSE Level 1 Function Reference
  {"cusparseSaxpyi",                                    {"hipsparseSaxpyi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDaxpyi",                                    {"hipsparseDaxpyi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCaxpyi",                                    {"hipsparseCaxpyi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZaxpyi",                                    {"hipsparseZaxpyi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSdoti",                                     {"hipsparseSdoti",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDdoti",                                     {"hipsparseDdoti",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCdoti",                                     {"hipsparseCdoti",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZdoti",                                     {"hipsparseZdoti",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseCdotci",                                    {"hipsparseCdotci",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZdotci",                                    {"hipsparseZdotci",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSgthr",                                     {"hipsparseSgthr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDgthr",                                     {"hipsparseDgthr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCgthr",                                     {"hipsparseCgthr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZgthr",                                     {"hipsparseZgthr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSgthrz",                                    {"hipsparseSgthrz",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDgthrz",                                    {"hipsparseDgthrz",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCgthrz",                                    {"hipsparseCgthrz",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZgthrz",                                    {"hipsparseZgthrz",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSroti",                                     {"hipsparseSroti",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDroti",                                     {"hipsparseDroti",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSsctr",                                     {"hipsparseSsctr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDsctr",                                     {"hipsparseDsctr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCsctr",                                     {"hipsparseCsctr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZsctr",                                     {"hipsparseZsctr",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 8, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  // 9. cuSPARSE Level 2 Function Reference
  {"cusparseSbsrmv",                                    {"hipsparseSbsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseDbsrmv",                                    {"hipsparseDbsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseCbsrmv",                                    {"hipsparseCbsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseZbsrmv",                                    {"hipsparseZbsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},

  {"cusparseSbsrxmv",                                   {"hipsparseSbsrxmv",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrxmv",                                   {"hipsparseDbsrxmv",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrxmv",                                   {"hipsparseCbsrxmv",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrxmv",                                   {"hipsparseZbsrxmv",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsrmv",                                    {"hipsparseScsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrmv",                                    {"hipsparseDcsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrmv",                                    {"hipsparseCcsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrmv",                                    {"hipsparseZcsrmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseCsrmvEx",                                   {"hipsparseCsrmvEx",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCsrmvEx_bufferSize",                        {"hipsparseCsrmvEx_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrmv_mp",                                 {"hipsparseScsrmv_mp",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrmv_mp",                                 {"hipsparseDcsrmv_mp",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrmv_mp",                                 {"hipsparseCcsrmv_mp",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrmv_mp",                                 {"hipsparseZcsrmv_mp",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSgemvi",                                    {"hipsparseSgemvi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseDgemvi",                                    {"hipsparseDgemvi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseCgemvi",                                    {"hipsparseCgemvi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseZgemvi",                                    {"hipsparseZgemvi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},

  {"cusparseSgemvi_bufferSize",                         {"hipsparseSgemvi_bufferSize",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseDgemvi_bufferSize",                         {"hipsparseDgemvi_bufferSize",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseCgemvi_bufferSize",                         {"hipsparseCgemvi_bufferSize",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},
  {"cusparseZgemvi_bufferSize",                         {"hipsparseZgemvi_bufferSize",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED}},

  {"cusparseSbsrsv2_bufferSize",                        {"hipsparseSbsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSbsrsv2_bufferSizeExt",                     {"hipsparseSbsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsv2_bufferSize",                        {"hipsparseDbsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsv2_bufferSizeExt",                     {"hipsparseDbsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsv2_bufferSize",                        {"hipsparseCbsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsv2_bufferSizeExt",                     {"hipsparseCbsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsv2_bufferSize",                        {"hipsparseZbsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsv2_bufferSizeExt",                     {"hipsparseZbsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseSbsrsv2_analysis",                          {"hipsparseSbsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsv2_analysis",                          {"hipsparseDbsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsv2_analysis",                          {"hipsparseCbsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsv2_analysis",                          {"hipsparseZbsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsrsv_solve",                              {"hipsparseScsrsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsv_solve",                              {"hipsparseDcsrsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsv_solve",                              {"hipsparseCcsrsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsv_solve",                              {"hipsparseZcsrsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSbsrsv2_solve",                             {"hipsparseSbsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsv2_solve",                             {"hipsparseDbsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsv2_solve",                             {"hipsparseCbsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsv2_solve",                             {"hipsparseZbsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseXbsrsv2_zeroPivot",                         {"hipsparseXbsrsv2_zeroPivot",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsrsv_analysis",                           {"hipsparseScsrsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsv_analysis",                           {"hipsparseDcsrsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsv_analysis",                           {"hipsparseCcsrsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsv_analysis",                           {"hipsparseZcsrsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseCsrsv_analysisEx",                          {"hipsparseCsrsv_analysisEx",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCsrsv_solveEx",                             {"hipsparseCsrsv_solveEx",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsv2_bufferSize",                        {"hipsparseScsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseScsrsv2_bufferSizeExt",                     {"hipsparseScsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsv2_bufferSize",                        {"hipsparseDcsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsv2_bufferSizeExt",                     {"hipsparseDcsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsv2_bufferSize",                        {"hipsparseCcsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsv2_bufferSizeExt",                     {"hipsparseCcsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsv2_bufferSize",                        {"hipsparseZcsrsv2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsv2_bufferSizeExt",                     {"hipsparseZcsrsv2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsv2_analysis",                          {"hipsparseScsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsv2_analysis",                          {"hipsparseDcsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsv2_analysis",                          {"hipsparseCcsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsv2_analysis",                          {"hipsparseZcsrsv2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsv2_solve",                             {"hipsparseScsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsv2_solve",                             {"hipsparseDcsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsv2_solve",                             {"hipsparseCcsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsv2_solve",                             {"hipsparseZcsrsv2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseXcsrsv2_zeroPivot",                         {"hipsparseXcsrsv2_zeroPivot",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseShybmv",                                    {"hipsparseShybmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDhybmv",                                    {"hipsparseDhybmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseChybmv",                                    {"hipsparseChybmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZhybmv",                                    {"hipsparseZhybmv",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseShybsv_analysis",                           {"hipsparseShybsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDhybsv_analysis",                           {"hipsparseDhybsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseChybsv_analysis",                           {"hipsparseChybsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZhybsv_analysis",                           {"hipsparseZhybsv_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseShybsv_solve",                              {"hipsparseShybsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDhybsv_solve",                              {"hipsparseDhybsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseChybsv_solve",                              {"hipsparseChybsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZhybsv_solve",                              {"hipsparseZhybsv_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 9, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  // 10. cuSPARSE Level 3 Function Reference
  {"cusparseScsrmm",                                    {"hipsparseScsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrmm",                                    {"hipsparseDcsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrmm",                                    {"hipsparseCcsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrmm",                                    {"hipsparseZcsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrmm2",                                   {"hipsparseScsrmm2",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrmm2",                                   {"hipsparseDcsrmm2",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrmm2",                                   {"hipsparseCcsrmm2",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrmm2",                                   {"hipsparseZcsrmm2",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsm_analysis",                           {"hipsparseScsrsm_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsm_analysis",                           {"hipsparseDcsrsm_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsm_analysis",                           {"hipsparseCcsrsm_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsm_analysis",                           {"hipsparseZcsrsm_analysis",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsm_solve",                              {"hipsparseScsrsm_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsm_solve",                              {"hipsparseDcsrsm_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsm_solve",                              {"hipsparseCcsrsm_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsm_solve",                              {"hipsparseZcsrsm_solve",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsm2_bufferSizeExt",                     {"hipsparseScsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsm2_bufferSizeExt",                     {"hipsparseDcsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsm2_bufferSizeExt",                     {"hipsparseCcsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsm2_bufferSizeExt",                     {"hipsparseZcsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsm2_analysis",                          {"hipsparseScsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsm2_analysis",                          {"hipsparseDcsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsm2_analysis",                          {"hipsparseCcsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsm2_analysis",                          {"hipsparseZcsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrsm2_solve",                             {"hipsparseScsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrsm2_solve",                             {"hipsparseDcsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrsm2_solve",                             {"hipsparseCcsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrsm2_solve",                             {"hipsparseZcsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseXcsrsm2_zeroPivot",                         {"hipsparseXcsrsm2_zeroPivot",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSbsrmm",                                    {"hipsparseSbsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED}},
  {"cusparseDbsrmm",                                    {"hipsparseDbsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED}},
  {"cusparseCbsrmm",                                    {"hipsparseCbsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED}},
  {"cusparseZbsrmm",                                    {"hipsparseZbsrmm",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED}},

  {"cusparseSbsrsm2_bufferSize",                        {"hipsparseSbsrsm2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSbsrsm2_bufferSizeExt",                     {"hipsparseSbsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsm2_bufferSize",                        {"hipsparseDbsrsm2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsm2_bufferSizeExt",                     {"hipsparseDbsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsm2_bufferSize",                        {"hipsparseCbsrsm2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsm2_bufferSizeExt",                     {"hipsparseCbsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsm2_bufferSize",                        {"hipsparseZbsrsm2_bufferSize",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsm2_bufferSizeExt",                     {"hipsparseZbsrsm2_bufferSizeExt",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseSbsrsm2_analysis",                          {"hipsparseSbsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsm2_analysis",                          {"hipsparseDbsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsm2_analysis",                          {"hipsparseCbsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsm2_analysis",                          {"hipsparseZbsrsm2_analysis",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseSbsrsm2_solve",                             {"hipsparseSbsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrsm2_solve",                             {"hipsparseDbsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrsm2_solve",                             {"hipsparseCbsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrsm2_solve",                             {"hipsparseZbsrsm2_solve",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseXbsrsm2_zeroPivot",                         {"hipsparseXbsrsm2_zeroPivot",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseSgemmi",                                    {"hipsparseSgemmi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDgemmi",                                    {"hipsparseDgemmi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCgemmi",                                    {"hipsparseCgemmi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZgemmi",                                    {"hipsparseZgemmi",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 10, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  // 11. cuSPARSE Extra Function Reference
  {"cusparseScsrgeam",                                  {"hipsparseScsrgeam",                                  "rocsparse_scsrgeam",                                               CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrgeam",                                  {"hipsparseDcsrgeam",                                  "rocsparse_dcsrgeam",                                               CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrgeam",                                  {"hipsparseCcsrgeam",                                  "rocsparse_ccsrgeam",                                               CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrgeam",                                  {"hipsparseZcsrgeam",                                  "rocsparse_zcsrgeam",                                               CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseXcsrgeamNnz",                               {"hipsparseXcsrgeamNnz",                               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrgeam2",                                 {"hipsparseScsrgeam2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseDcsrgeam2",                                 {"hipsparseDcsrgeam2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseCcsrgeam2",                                 {"hipsparseCcsrgeam2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseZcsrgeam2",                                 {"hipsparseZcsrgeam2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseXcsrgeam2Nnz",                              {"hipsparseXcsrgeam2Nnz",                              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},

  {"cusparseScsrgeam2_bufferSizeExt",                   {"hipsparseScsrgeam2_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseDcsrgeam2_bufferSizeExt",                   {"hipsparseDcsrgeam2_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseCcsrgeam2_bufferSizeExt",                   {"hipsparseCcsrgeam2_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},
  {"cusparseZcsrgeam2_bufferSizeExt",                   {"hipsparseZcsrgeam2_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED}},

  // NOTE: rocsparse_(s|d|c|z)csrgemm have different signatures, thus they are unsupported yet
  {"cusparseScsrgemm",                                  {"hipsparseScsrgemm",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrgemm",                                  {"hipsparseDcsrgemm",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrgemm",                                  {"hipsparseCcsrgemm",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrgemm",                                  {"hipsparseZcsrgemm",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  // NOTE: rocsparse_csrgemm_nnz has different signature, thus it is unsupported yet
  {"cusparseXcsrgemmNnz",                               {"hipsparseXcsrgemmNnz",                               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrgemm2",                                 {"hipsparseScsrgemm2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrgemm2",                                 {"hipsparseDcsrgemm2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrgemm2",                                 {"hipsparseCcsrgemm2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrgemm2",                                 {"hipsparseZcsrgemm2",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 11, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseXcsrgemm2Nnz",                              {"hipsparseXcsrgemm2Nnz",                              "rocsparse_csrgemm_nnz",                                            CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrgemm2_bufferSizeExt",                   {"hipsparseScsrgemm2_bufferSizeExt",                   "rocsparse_scsrgemm_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrgemm2_bufferSizeExt",                   {"hipsparseDcsrgemm2_bufferSizeExt",                   "rocsparse_dcsrgemm_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrgemm2_bufferSizeExt",                   {"hipsparseCcsrgemm2_bufferSizeExt",                   "rocsparse_ccsrgemm_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrgemm2_bufferSizeExt",                   {"hipsparseZcsrgemm2_bufferSizeExt",                   "rocsparse_zcsrgemm_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 11, CUDA_DEPRECATED | CUDA_REMOVED}},

  // 12. cuSPARSE Preconditioners Reference
  // 12.1. Incomplete Cholesky Factorization : level 0
  {"cusparseScsric0",                                   {"hipsparseScsric0",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsric0",                                   {"hipsparseDcsric0",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsric0",                                   {"hipsparseCcsric0",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsric0",                                   {"hipsparseZcsric0",                                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsric02_bufferSize",                       {"hipsparseScsric02_bufferSize",                       "rocsparse_scsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseScsric02_bufferSizeExt",                    {"hipsparseScsric02_bufferSizeExt",                    "rocsparse_scsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsric02_bufferSize",                       {"hipsparseDcsric02_bufferSize",                       "rocsparse_dcsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsric02_bufferSizeExt",                    {"hipsparseDcsric02_bufferSizeExt",                    "rocsparse_dcsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsric02_bufferSize",                       {"hipsparseCcsric02_bufferSize",                       "rocsparse_ccsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsric02_bufferSizeExt",                    {"hipsparseCcsric02_bufferSizeExt",                    "rocsparse_ccsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsric02_bufferSize",                       {"hipsparseZcsric02_bufferSize",                       "rocsparse_zcsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsric02_bufferSizeExt",                    {"hipsparseZcsric02_bufferSizeExt",                    "rocsparse_zcsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseScsric02_analysis",                         {"hipsparseScsric02_analysis",                         "rocsparse_scsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsric02_analysis",                         {"hipsparseDcsric02_analysis",                         "rocsparse_dcsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsric02_analysis",                         {"hipsparseCcsric02_analysis",                         "rocsparse_ccsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsric02_analysis",                         {"hipsparseZcsric02_analysis",                         "rocsparse_zcsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseScsric02",                                  {"hipsparseScsric02",                                  "rocsparse_scsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsric02",                                  {"hipsparseDcsric02",                                  "rocsparse_dcsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsric02",                                  {"hipsparseCcsric02",                                  "rocsparse_ccsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsric02",                                  {"hipsparseZcsric02",                                  "rocsparse_zcsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseXcsric02_zeroPivot",                        {"hipsparseXcsric02_zeroPivot",                        "rocsparse_csric0_zero_pivot",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseSbsric02_bufferSize",                       {"hipsparseSbsric02_bufferSize",                       "rocsparse_sbsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseSbsric02_bufferSizeExt",                    {"hipsparseSbsric02_bufferSizeExt",                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsric02_bufferSize",                       {"hipsparseDbsric02_bufferSize",                       "rocsparse_dbsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDbsric02_bufferSizeExt",                    {"hipsparseDbsric02_bufferSizeExt",                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsric02_bufferSize",                       {"hipsparseCbsric02_bufferSize",                       "rocsparse_cbsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCbsric02_bufferSizeExt",                    {"hipsparseCbsric02_bufferSizeExt",                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsric02_bufferSize",                       {"hipsparseZbsric02_bufferSize",                       "rocsparse_zbsric0_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZbsric02_bufferSizeExt",                    {"hipsparseZbsric02_bufferSizeExt",                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseSbsric02_analysis",                         {"hipsparseSbsric02_analysis",                         "rocsparse_sbsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDbsric02_analysis",                         {"hipsparseDbsric02_analysis",                         "rocsparse_dbsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCbsric02_analysis",                         {"hipsparseCbsric02_analysis",                         "rocsparse_cbsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZbsric02_analysis",                         {"hipsparseZbsric02_analysis",                         "rocsparse_zbsric0_analysis",                                       CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseSbsric02",                                  {"hipsparseSbsric02",                                  "rocsparse_sbsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDbsric02",                                  {"hipsparseDbsric02",                                  "rocsparse_dbsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCbsric02",                                  {"hipsparseCbsric02",                                  "rocsparse_cbsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZbsric02",                                  {"hipsparseZbsric02",                                  "rocsparse_zbsric0",                                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  // TODO: rocsparse_get_stream and hipStreamSynchronize need to be added correspondingly before and after rocsparse_bsric0_zero_pivot call, because cusparseXbsric02_zeroPivot is blocking, and rocsparse_bsric0_zero_pivot is not
  {"cusparseXbsric02_zeroPivot",                        {"hipsparseXbsric02_zeroPivot",                        "rocsparse_bsric0_zero_pivot",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  // 12.2. Incomplete LU Factorization: level 0
  // NOTE: rocsparse_(s|d|c|z)csrilu0 have different signatures, thus they are also unsupported yet
  {"cusparseScsrilu0",                                  {"hipsparseScsrilu0",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsrilu0",                                  {"hipsparseDcsrilu0",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsrilu0",                                  {"hipsparseCcsrilu0",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsrilu0",                                  {"hipsparseZcsrilu0",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCsrilu0Ex",                                 {"hipsparseCsrilu0Ex",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsrilu02_numericBoost",                    {"hipsparseScsrilu02_numericBoost",                    "rocsparse_dscsrilu0_numeric_boost",                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsrilu02_numericBoost",                    {"hipsparseDcsrilu02_numericBoost",                    "rocsparse_dcsrilu0_numeric_boost",                                 CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsrilu02_numericBoost",                    {"hipsparseCcsrilu02_numericBoost",                    "rocsparse_dccsrilu0_numeric_boost",                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsrilu02_numericBoost",                    {"hipsparseZcsrilu02_numericBoost",                    "rocsparse_zcsrilu0_numeric_boost",                                 CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseScsrilu02_bufferSize",                      {"hipsparseScsrilu02_bufferSize",                      "rocsparse_scsrilu0_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseScsrilu02_bufferSizeExt",                   {"hipsparseScsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDcsrilu02_bufferSize",                      {"hipsparseDcsrilu02_bufferSize",                      "rocsparse_dcsrilu0_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsrilu02_bufferSizeExt",                   {"hipsparseDcsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCcsrilu02_bufferSize",                      {"hipsparseCcsrilu02_bufferSize",                      "rocsparse_ccsrilu0_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsrilu02_bufferSizeExt",                   {"hipsparseCcsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZcsrilu02_bufferSize",                      {"hipsparseZcsrilu02_bufferSize",                      "rocsparse_zcsrilu0_buffer_size",                                   CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsrilu02_bufferSizeExt",                   {"hipsparseZcsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsrilu02_analysis",                        {"hipsparseScsrilu02_analysis",                        "rocsparse_scsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsrilu02_analysis",                        {"hipsparseDcsrilu02_analysis",                        "rocsparse_dcsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsrilu02_analysis",                        {"hipsparseCcsrilu02_analysis",                        "rocsparse_ccsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsrilu02_analysis",                        {"hipsparseZcsrilu02_analysis",                        "rocsparse_zcsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseScsrilu02",                                 {"hipsparseScsrilu02",                                 "rocsparse_scsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDcsrilu02",                                 {"hipsparseDcsrilu02",                                 "rocsparse_dcsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCcsrilu02",                                 {"hipsparseCcsrilu02",                                 "rocsparse_ccsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZcsrilu02",                                 {"hipsparseZcsrilu02",                                 "rocsparse_zcsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseXcsrilu02_zeroPivot",                       {"hipsparseXcsrilu02_zeroPivot",                       "rocsparse_csrilu0_zero_pivot",                                     CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseSbsrilu02_numericBoost",                    {"hipsparseSbsrilu02_numericBoost",                    "rocsparse_dsbsrilu0_numeric_boost",                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDbsrilu02_numericBoost",                    {"hipsparseDbsrilu02_numericBoost",                    "rocsparse_dbsrilu0_numeric_boost",                                 CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCbsrilu02_numericBoost",                    {"hipsparseCbsrilu02_numericBoost",                    "rocsparse_dcbsrilu0_numeric_boost",                                CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZbsrilu02_numericBoost",                    {"hipsparseZbsrilu02_numericBoost",                    "rocsparse_zbsrilu0_numeric_boost",                                 CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  // NOTE: rocsparse_(s|d|c|z)bsrilu0_buffer_size have an additional parameter void* temp_buffer
  {"cusparseSbsrilu02_bufferSize",                      {"hipsparseSbsrilu02_bufferSize",                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSbsrilu02_bufferSizeExt",                   {"hipsparseSbsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrilu02_bufferSize",                      {"hipsparseDbsrilu02_bufferSize",                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDbsrilu02_bufferSizeExt",                   {"hipsparseDbsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrilu02_bufferSize",                      {"hipsparseCbsrilu02_bufferSize",                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCbsrilu02_bufferSizeExt",                   {"hipsparseCbsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrilu02_bufferSize",                      {"hipsparseZbsrilu02_bufferSize",                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZbsrilu02_bufferSizeExt",                   {"hipsparseZbsrilu02_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseSbsrilu02_analysis",                        {"hipsparseSbsrilu02_analysis",                        "rocsparse_sbsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDbsrilu02_analysis",                        {"hipsparseDbsrilu02_analysis",                        "rocsparse_dbsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCbsrilu02_analysis",                        {"hipsparseCbsrilu02_analysis",                        "rocsparse_cbsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZbsrilu02_analysis",                        {"hipsparseZbsrilu02_analysis",                        "rocsparse_zbsrilu0_analysis",                                      CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  {"cusparseSbsrilu02",                                 {"hipsparseSbsrilu02",                                 "rocsparse_sbsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseDbsrilu02",                                 {"hipsparseDbsrilu02",                                 "rocsparse_dbsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseCbsrilu02",                                 {"hipsparseCbsrilu02",                                 "rocsparse_cbsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseZbsrilu02",                                 {"hipsparseZbsrilu02",                                 "rocsparse_zbsrilu0",                                               CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},
  {"cusparseXbsrilu02_zeroPivot",                       {"hipsparseXbsrilu02_zeroPivot",                       "rocsparse_bsrilu0_zero_pivot",                                     CONV_LIB_FUNC, API_SPARSE, 12, CUDA_DEPRECATED}},

  // 12.3. Tridiagonal Solve
  // NOTE: rocsparse_(s|d|c|z)gtsv have an additional parameter void* temp_buffer
  {"cusparseSgtsv",                                     {"hipsparseSgtsv",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDgtsv",                                     {"hipsparseDgtsv",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCgtsv",                                     {"hipsparseCgtsv",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZgtsv",                                     {"hipsparseZgtsv",                                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  // NOTE: rocsparse_(s|d|c|z)gtsv_no_pivot have an additional parameter void* temp_buffer
  {"cusparseSgtsv_nopivot",                             {"hipsparseSgtsv_nopivot",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDgtsv_nopivot",                             {"hipsparseDgtsv_nopivot",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCgtsv_nopivot",                             {"hipsparseCgtsv_nopivot",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZgtsv_nopivot",                             {"hipsparseZgtsv_nopivot",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSgtsv2_bufferSizeExt",                      {"hipsparseSgtsv2_bufferSizeExt",                      "rocsparse_sgtsv_buffer_size",                                      CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsv2_bufferSizeExt",                      {"hipsparseDgtsv2_bufferSizeExt",                      "rocsparse_dgtsv_buffer_size",                                      CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsv2_bufferSizeExt",                      {"hipsparseCgtsv2_bufferSizeExt",                      "rocsparse_cgtsv_buffer_size",                                      CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsv2_bufferSizeExt",                      {"hipsparseZgtsv2_bufferSizeExt",                      "rocsparse_zgtsv_buffer_size",                                      CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgtsv2",                                    {"hipsparseSgtsv2",                                    "rocsparse_sgtsv",                                                  CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsv2",                                    {"hipsparseDgtsv2",                                    "rocsparse_dgtsv",                                                  CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsv2",                                    {"hipsparseCgtsv2",                                    "rocsparse_cgtsv",                                                  CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsv2",                                    {"hipsparseZgtsv2",                                    "rocsparse_zgtsv",                                                  CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgtsv2_nopivot_bufferSizeExt",              {"hipsparseSgtsv2_nopivot_bufferSizeExt",              "rocsparse_sgtsv_no_pivot_buffer_size",                             CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsv2_nopivot_bufferSizeExt",              {"hipsparseDgtsv2_nopivot_bufferSizeExt",              "rocsparse_dgtsv_no_pivot_buffer_size",                             CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsv2_nopivot_bufferSizeExt",              {"hipsparseCgtsv2_nopivot_bufferSizeExt",              "rocsparse_cgtsv_no_pivot_buffer_size",                             CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsv2_nopivot_bufferSizeExt",              {"hipsparseZgtsv2_nopivot_bufferSizeExt",              "rocsparse_zgtsv_no_pivot_buffer_size",                             CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgtsv2_nopivot",                            {"hipsparseSgtsv2_nopivot",                            "rocsparse_sgtsv_no_pivot",                                         CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsv2_nopivot",                            {"hipsparseDgtsv2_nopivot",                            "rocsparse_dgtsv_no_pivot",                                         CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsv2_nopivot",                            {"hipsparseCgtsv2_nopivot",                            "rocsparse_cgtsv_no_pivot",                                         CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsv2_nopivot",                            {"hipsparseZgtsv2_nopivot",                            "rocsparse_zgtsv_no_pivot",                                         CONV_LIB_FUNC, API_SPARSE, 12}},

  // 12.4. Batched Tridiagonal Solve
  {"cusparseSgtsvStridedBatch",                         {"hipsparseSgtsvStridedBatch",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDgtsvStridedBatch",                         {"hipsparseDgtsvStridedBatch",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCgtsvStridedBatch",                         {"hipsparseCgtsvStridedBatch",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZgtsvStridedBatch",                         {"hipsparseZgtsvStridedBatch",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 12, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSgtsv2StridedBatch_bufferSizeExt",          {"hipsparseSgtsv2StridedBatch_bufferSizeExt",          "rocsparse_sgtsv_no_pivot_strided_batch_buffer_size",               CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsv2StridedBatch_bufferSizeExt",          {"hipsparseDgtsv2StridedBatch_bufferSizeExt",          "rocsparse_dgtsv_no_pivot_strided_batch_buffer_size",               CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsv2StridedBatch_bufferSizeExt",          {"hipsparseCgtsv2StridedBatch_bufferSizeExt",          "rocsparse_cgtsv_no_pivot_strided_batch_buffer_size",               CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsv2StridedBatch_bufferSizeExt",          {"hipsparseZgtsv2StridedBatch_bufferSizeExt",          "rocsparse_zgtsv_no_pivot_strided_batch_buffer_size",               CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgtsv2StridedBatch",                        {"hipsparseSgtsv2StridedBatch",                        "rocsparse_sgtsv_no_pivot_strided_batch",                           CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsv2StridedBatch",                        {"hipsparseDgtsv2StridedBatch",                        "rocsparse_dgtsv_no_pivot_strided_batch",                           CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsv2StridedBatch",                        {"hipsparseCgtsv2StridedBatch",                        "rocsparse_cgtsv_no_pivot_strided_batch",                           CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsv2StridedBatch",                        {"hipsparseZgtsv2StridedBatch",                        "rocsparse_zgtsv_no_pivot_strided_batch",                           CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgtsvInterleavedBatch_bufferSizeExt",       {"hipsparseSgtsvInterleavedBatch_bufferSizeExt",       "rocsparse_sgtsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsvInterleavedBatch_bufferSizeExt",       {"hipsparseDgtsvInterleavedBatch_bufferSizeExt",       "rocsparse_dgtsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsvInterleavedBatch_bufferSizeExt",       {"hipsparseCgtsvInterleavedBatch_bufferSizeExt",       "rocsparse_cgtsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsvInterleavedBatch_bufferSizeExt",       {"hipsparseZgtsvInterleavedBatch_bufferSizeExt",       "rocsparse_zgtsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgtsvInterleavedBatch",                     {"hipsparseSgtsvInterleavedBatch",                     "rocsparse_sgtsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgtsvInterleavedBatch",                     {"hipsparseDgtsvInterleavedBatch",                     "rocsparse_dgtsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgtsvInterleavedBatch",                     {"hipsparseCgtsvInterleavedBatch",                     "rocsparse_cgtsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgtsvInterleavedBatch",                     {"hipsparseZgtsvInterleavedBatch",                     "rocsparse_zgtsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},

  // 12.5. Batched Pentadiagonal Solve
  {"cusparseSgpsvInterleavedBatch_bufferSizeExt",       {"hipsparseSgpsvInterleavedBatch_bufferSizeExt",       "rocsparse_sgpsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgpsvInterleavedBatch_bufferSizeExt",       {"hipsparseDgpsvInterleavedBatch_bufferSizeExt",       "rocsparse_dgpsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgpsvInterleavedBatch_bufferSizeExt",       {"hipsparseCgpsvInterleavedBatch_bufferSizeExt",       "rocsparse_cgpsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgpsvInterleavedBatch_bufferSizeExt",       {"hipsparseZgpsvInterleavedBatch_bufferSizeExt",       "rocsparse_zgpsv_interleaved_batch_buffer_size",                    CONV_LIB_FUNC, API_SPARSE, 12}},

  {"cusparseSgpsvInterleavedBatch",                     {"hipsparseSgpsvInterleavedBatch",                     "rocsparse_sgpsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseDgpsvInterleavedBatch",                     {"hipsparseDgpsvInterleavedBatch",                     "rocsparse_dgpsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseCgpsvInterleavedBatch",                     {"hipsparseCgpsvInterleavedBatch",                     "rocsparse_cgpsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},
  {"cusparseZgpsvInterleavedBatch",                     {"hipsparseZgpsvInterleavedBatch",                     "rocsparse_zgpsv_interleaved_batch",                                CONV_LIB_FUNC, API_SPARSE, 12}},

  // 13. cuSPARSE Matrix Reorderings Reference
  {"cusparseScsrcolor",                                 {"hipsparseScsrcolor",                                 "rocsparse_scsrcolor",                                              CONV_LIB_FUNC, API_SPARSE, 13, CUDA_DEPRECATED}},
  {"cusparseDcsrcolor",                                 {"hipsparseDcsrcolor",                                 "rocsparse_dcsrcolor",                                              CONV_LIB_FUNC, API_SPARSE, 13, CUDA_DEPRECATED}},
  {"cusparseCcsrcolor",                                 {"hipsparseCcsrcolor",                                 "rocsparse_ccsrcolor",                                              CONV_LIB_FUNC, API_SPARSE, 13, CUDA_DEPRECATED}},
  {"cusparseZcsrcolor",                                 {"hipsparseZcsrcolor",                                 "rocsparse_zcsrcolor",                                              CONV_LIB_FUNC, API_SPARSE, 13, CUDA_DEPRECATED}},

  // 14. cuSPARSE Format Conversion Reference
  {"cusparseSbsr2csr",                                  {"hipsparseSbsr2csr",                                  "rocsparse_sbsr2csr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDbsr2csr",                                  {"hipsparseDbsr2csr",                                  "rocsparse_dbsr2csr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCbsr2csr",                                  {"hipsparseCbsr2csr",                                  "rocsparse_cbsr2csr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZbsr2csr",                                  {"hipsparseZbsr2csr",                                  "rocsparse_zbsr2csr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseSgebsr2gebsc_bufferSize",                   {"hipsparseSgebsr2gebsc_bufferSize",                   "rocsparse_sgebsr2gebsc_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseSgebsr2gebsc_bufferSizeExt",                {"hipsparseSgebsr2gebsc_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseDgebsr2gebsc_bufferSize",                   {"hipsparseDgebsr2gebsc_bufferSize",                   "rocsparse_dgebsr2gebsc_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDgebsr2gebsc_bufferSizeExt",                {"hipsparseDgebsr2gebsc_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseCgebsr2gebsc_bufferSize",                   {"hipsparseCgebsr2gebsc_bufferSize",                   "rocsparse_cgebsr2gebsc_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCgebsr2gebsc_bufferSizeExt",                {"hipsparseCgebsr2gebsc_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseZgebsr2gebsc_bufferSize",                   {"hipsparseZgebsr2gebsc_bufferSize",                   "rocsparse_zgebsr2gebsc_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZgebsr2gebsc_bufferSizeExt",                {"hipsparseZgebsr2gebsc_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},

  {"cusparseSgebsr2gebsc",                              {"hipsparseSgebsr2gebsc",                              "rocsparse_sgebsr2gebsc",                                           CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDgebsr2gebsc",                              {"hipsparseDgebsr2gebsc",                              "rocsparse_dgebsr2gebsc",                                           CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCgebsr2gebsc",                              {"hipsparseCgebsr2gebsc",                              "rocsparse_cgebsr2gebsc",                                           CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZgebsr2gebsc",                              {"hipsparseZgebsr2gebsc",                              "rocsparse_zgebsr2gebsc",                                           CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseSgebsr2gebsr_bufferSize",                   {"hipsparseSgebsr2gebsr_bufferSize",                   "rocsparse_sgebsr2gebsr_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseSgebsr2gebsr_bufferSizeExt",                {"hipsparseSgebsr2gebsr_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseDgebsr2gebsr_bufferSize",                   {"hipsparseDgebsr2gebsr_bufferSize",                   "rocsparse_dgebsr2gebsr_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDgebsr2gebsr_bufferSizeExt",                {"hipsparseDgebsr2gebsr_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseCgebsr2gebsr_bufferSize",                   {"hipsparseCgebsr2gebsr_bufferSize",                   "rocsparse_cgebsr2gebsr_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCgebsr2gebsr_bufferSizeExt",                {"hipsparseCgebsr2gebsr_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseZgebsr2gebsr_bufferSize",                   {"hipsparseZgebsr2gebsr_bufferSize",                   "rocsparse_zgebsr2gebsr_buffer_size",                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZgebsr2gebsr_bufferSizeExt",                {"hipsparseZgebsr2gebsr_bufferSizeExt",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},

  {"cusparseXgebsr2csr",                                {"hipsparseXgebsr2csr",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseSgebsr2csr",                                {"hipsparseSgebsr2csr",                                "rocsparse_sgebsr2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDgebsr2csr",                                {"hipsparseDgebsr2csr",                                "rocsparse_dgebsr2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCgebsr2csr",                                {"hipsparseCgebsr2csr",                                "rocsparse_cgebsr2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZgebsr2csr",                                {"hipsparseZgebsr2csr",                                "rocsparse_zgebsr2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseXgebsr2gebsrNnz",                           {"hipsparseXgebsr2gebsrNnz",                           "rocsparse_gebsr2gebsr_nnz",                                        CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseSgebsr2gebsr",                              {"hipsparseSgebsr2gebsr",                              "rocsparse_sgebsr2gebsr",                                           CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDgebsr2gebsr",                              {"hipsparseDgebsr2gebsr",                              "rocsparse_dgebsr2gebsr",                                           CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCgebsr2gebsr",                              {"hipsparseCgebsr2gebsr",                              "rocsparse_cgebsr2gebsr",                                           CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZgebsr2gebsr",                              {"hipsparseZgebsr2gebsr",                              "rocsparse_zgebsr2gebsr",                                           CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseScsr2gebsr_bufferSize",                     {"hipsparseScsr2gebsr_bufferSize",                     "rocsparse_scsr2gebsr_buffer_size",                                 CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseScsr2gebsr_bufferSizeExt",                  {"hipsparseScsr2gebsr_bufferSizeExt",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseDcsr2gebsr_bufferSize",                     {"hipsparseDcsr2gebsr_bufferSize",                     "rocsparse_dcsr2gebsr_buffer_size",                                 CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDcsr2gebsr_bufferSizeExt",                  {"hipsparseDcsr2gebsr_bufferSizeExt",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseCcsr2gebsr_bufferSize",                     {"hipsparseCcsr2gebsr_bufferSize",                     "rocsparse_ccsr2gebsr_buffer_size",                                 CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCcsr2gebsr_bufferSizeExt",                  {"hipsparseCcsr2gebsr_bufferSizeExt",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},
  {"cusparseZcsr2gebsr_bufferSize",                     {"hipsparseZcsr2gebsr_bufferSize",                     "rocsparse_zcsr2gebsr_buffer_size",                                 CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZcsr2gebsr_bufferSizeExt",                  {"hipsparseZcsr2gebsr_bufferSizeExt",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED}},

  {"cusparseXcsr2gebsrNnz",                             {"hipsparseXcsr2gebsrNnz",                             "rocsparse_csr2gebsr_nnz",                                          CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseScsr2gebsr",                                {"hipsparseScsr2gebsr",                                "rocsparse_scsr2gebsr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDcsr2gebsr",                                {"hipsparseDcsr2gebsr",                                "rocsparse_dcsr2gebsr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCcsr2gebsr",                                {"hipsparseCcsr2gebsr",                                "rocsparse_ccsr2gebsr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZcsr2gebsr",                                {"hipsparseZcsr2gebsr",                                "rocsparse_zcsr2gebsr",                                             CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseXcoo2csr",                                  {"hipsparseXcoo2csr",                                  "rocsparse_coo2csr",                                                CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseScsc2dense",                                {"hipsparseScsc2dense",                                "rocsparse_scsc2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsc2dense",                                {"hipsparseDcsc2dense",                                "rocsparse_dcsc2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsc2dense",                                {"hipsparseCcsc2dense",                                "rocsparse_ccsc2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsc2dense",                                {"hipsparseZcsc2dense",                                "rocsparse_zcsc2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsc2hyb",                                  {"hipsparseScsc2hyb",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsc2hyb",                                  {"hipsparseDcsc2hyb",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsc2hyb",                                  {"hipsparseCcsc2hyb",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsc2hyb",                                  {"hipsparseZcsc2hyb",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseXcsr2bsrNnz",                               {"hipsparseXcsr2bsrNnz",                               "rocsparse_csr2bsr_nnz",                                            CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseScsr2bsr",                                  {"hipsparseScsr2bsr",                                  "rocsparse_scsr2bsr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDcsr2bsr",                                  {"hipsparseDcsr2bsr",                                  "rocsparse_dcsr2bsr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCcsr2bsr",                                  {"hipsparseCcsr2bsr",                                  "rocsparse_ccsr2bsr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZcsr2bsr",                                  {"hipsparseZcsr2bsr",                                  "rocsparse_zcsr2bsr",                                               CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseXcsr2coo",                                  {"hipsparseXcsr2coo",                                  "rocsparse_csr2coo",                                                CONV_LIB_FUNC, API_SPARSE, 14}},
  // NOTE: rocsparse_(s|d|c|z)csr2csc have an additional parameter void* temp_buffer
  {"cusparseScsr2csc",                                  {"hipsparseScsr2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsr2csc",                                  {"hipsparseDcsr2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsr2csc",                                  {"hipsparseCcsr2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsr2csc",                                  {"hipsparseZcsr2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseCsr2cscEx",                                 {"hipsparseCsr2cscEx",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCsr2cscEx2",                                {"hipsparseCsr2cscEx2",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED}},
  {"cusparseCsr2cscEx2_bufferSize",                     {"hipsparseCsr2cscEx2_bufferSize",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED}},

  {"cusparseScsr2dense",                                {"hipsparseScsr2dense",                                "rocsparse_scsr2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsr2dense",                                {"hipsparseDcsr2dense",                                "rocsparse_dcsr2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsr2dense",                                {"hipsparseCcsr2dense",                                "rocsparse_ccsr2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsr2dense",                                {"hipsparseZcsr2dense",                                "rocsparse_zcsr2dense",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseScsr2csr_compress",                         {"hipsparseScsr2csr_compress",                         "rocsparse_scsr2csr_compress",                                      CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDcsr2csr_compress",                         {"hipsparseDcsr2csr_compress",                         "rocsparse_dcsr2csr_compress",                                      CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseCcsr2csr_compress",                         {"hipsparseCcsr2csr_compress",                         "rocsparse_ccsr2csr_compress",                                      CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseZcsr2csr_compress",                         {"hipsparseZcsr2csr_compress",                         "rocsparse_zcsr2csr_compress",                                      CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseScsr2hyb",                                  {"hipsparseScsr2hyb",                                  "rocsparse_scsr2hyb",                                               CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDcsr2hyb",                                  {"hipsparseDcsr2hyb",                                  "rocsparse_dcsr2hyb",                                               CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCcsr2hyb",                                  {"hipsparseCcsr2hyb",                                  "rocsparse_ccsr2hyb",                                               CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZcsr2hyb",                                  {"hipsparseZcsr2hyb",                                  "rocsparse_zcsr2hyb",                                               CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSdense2csc",                                {"hipsparseSdense2csc",                                "rocsparse_sdense2csc",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDdense2csc",                                {"hipsparseDdense2csc",                                "rocsparse_ddense2csc",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCdense2csc",                                {"hipsparseCdense2csc",                                "rocsparse_cdense2csc",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZdense2csc",                                {"hipsparseZdense2csc",                                "rocsparse_zdense2csc",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSdense2csr",                                {"hipsparseSdense2csr",                                "rocsparse_sdense2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDdense2csr",                                {"hipsparseDdense2csr",                                "rocsparse_ddense2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCdense2csr",                                {"hipsparseCdense2csr",                                "rocsparse_cdense2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZdense2csr",                                {"hipsparseZdense2csr",                                "rocsparse_zdense2csr",                                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSdense2hyb",                                {"hipsparseSdense2hyb",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDdense2hyb",                                {"hipsparseDdense2hyb",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCdense2hyb",                                {"hipsparseCdense2hyb",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZdense2hyb",                                {"hipsparseZdense2hyb",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseShyb2csc",                                  {"hipsparseShyb2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDhyb2csc",                                  {"hipsparseDhyb2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseChyb2csc",                                  {"hipsparseChyb2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZhyb2csc",                                  {"hipsparseZhyb2csc",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  // NOTE: rocsparse_shyb2csr has one additioanl attribute void* temp_buffer; see hipsparseShyb2csr implementation, which wraps rocsparse_hyb2csr_buffer_size + rocsparse_shyb2csr
  {"cusparseShyb2csr",                                  {"hipsparseShyb2csr",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  // NOTE: rocsparse_dhyb2csr has one additioanl attribute void* temp_buffer; see hipsparseDhyb2csr implementation, which wraps rocsparse_hyb2csr_buffer_size + rocsparse_dhyb2csr
  {"cusparseDhyb2csr",                                  {"hipsparseDhyb2csr",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  // NOTE: rocsparse_chyb2csr has one additioanl attribute void* temp_buffer; see hipsparseChyb2csr implementation, which wraps rocsparse_hyb2csr_buffer_size + rocsparse_chyb2csr
  {"cusparseChyb2csr",                                  {"hipsparseChyb2csr",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  // NOTE: rocsparse_zhyb2csr has one additioanl attribute void* temp_buffer; see hipsparseZhyb2csr implementation, which wraps rocsparse_hyb2csr_buffer_size + rocsparse_zhyb2csr
  {"cusparseZhyb2csr",                                  {"hipsparseZhyb2csr",                                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseShyb2dense",                                {"hipsparseShyb2dense",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseDhyb2dense",                                {"hipsparseDhyb2dense",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseChyb2dense",                                {"hipsparseChyb2dense",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseZhyb2dense",                                {"hipsparseZhyb2dense",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  {"cusparseSnnz",                                      {"hipsparseSnnz",                                      "rocsparse_snnz",                                                   CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseDnnz",                                      {"hipsparseDnnz",                                      "rocsparse_dnnz",                                                   CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseCnnz",                                      {"hipsparseCnnz",                                      "rocsparse_cnnz",                                                   CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseZnnz",                                      {"hipsparseZnnz",                                      "rocsparse_znnz",                                                   CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseCreateIdentityPermutation",                 {"hipsparseCreateIdentityPermutation",                 "rocsparse_create_identity_permutation",                            CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseXcoosort_bufferSizeExt",                    {"hipsparseXcoosort_bufferSizeExt",                    "rocsparse_coosort_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseXcoosortByRow",                             {"hipsparseXcoosortByRow",                             "rocsparse_coosort_by_row",                                         CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseXcoosortByColumn",                          {"hipsparseXcoosortByColumn",                          "rocsparse_coosort_by_column",                                      CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseXcsrsort_bufferSizeExt",                    {"hipsparseXcsrsort_bufferSizeExt",                    "rocsparse_csrsort_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseXcsrsort",                                  {"hipsparseXcsrsort",                                  "rocsparse_csrsort",                                                CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseXcscsort_bufferSizeExt",                    {"hipsparseXcscsort_bufferSizeExt",                    "rocsparse_cscsort_buffer_size",                                    CONV_LIB_FUNC, API_SPARSE, 14}},
  {"cusparseXcscsort",                                  {"hipsparseXcscsort",                                  "rocsparse_cscsort",                                                CONV_LIB_FUNC, API_SPARSE, 14}},

  {"cusparseCreateCsru2csrInfo",                        {"hipsparseCreateCsru2csrInfo",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDestroyCsru2csrInfo",                       {"hipsparseDestroyCsru2csrInfo",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsru2csr",                                 {"hipsparseScsru2csr",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDcsru2csr",                                 {"hipsparseDcsru2csr",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCcsru2csr",                                 {"hipsparseCcsru2csr",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZcsru2csr",                                 {"hipsparseZcsru2csr",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsru2csr_bufferSizeExt",                   {"hipsparseScsru2csr_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDcsru2csr_bufferSizeExt",                   {"hipsparseDcsru2csr_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCcsru2csr_bufferSizeExt",                   {"hipsparseCcsru2csr_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZcsru2csr_bufferSizeExt",                   {"hipsparseZcsru2csr_bufferSizeExt",                   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseScsr2csru",                                 {"hipsparseScsr2csru",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseDcsr2csru",                                 {"hipsparseDcsr2csru",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseCcsr2csru",                                 {"hipsparseCcsr2csru",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseZcsr2csru",                                 {"hipsparseZcsr2csru",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, ROC_UNSUPPORTED | CUDA_DEPRECATED}},

  {"cusparseHpruneDense2csr",                           {"hipsparseHpruneDense2csr",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneDense2csr",                           {"hipsparseSpruneDense2csr",                           "rocsparse_sprune_dense2csr",                                       CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneDense2csr",                           {"hipsparseDpruneDense2csr",                           "rocsparse_dprune_dense2csr",                                       CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneDense2csr_bufferSizeExt",             {"hipsparseHpruneDense2csr_bufferSizeExt",             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneDense2csr_bufferSizeExt",             {"hipsparseSpruneDense2csr_bufferSizeExt",             "rocsparse_sprune_dense2csr_buffer_size",                           CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneDense2csr_bufferSizeExt",             {"hipsparseDpruneDense2csr_bufferSizeExt",             "rocsparse_dprune_dense2csr_buffer_size",                           CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneDense2csrNnz",                        {"hipsparseHpruneDense2csrNnz",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneDense2csrNnz",                        {"hipsparseSpruneDense2csrNnz",                        "rocsparse_sprune_dense2csr_nnz",                                   CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneDense2csrNnz",                        {"hipsparseDpruneDense2csrNnz",                        "rocsparse_dprune_dense2csr_nnz",                                   CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneCsr2csr",                             {"hipsparseHpruneCsr2csr",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneCsr2csr",                             {"hipsparseSpruneCsr2csr",                             "rocsparse_sprune_csr2csr",                                         CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneCsr2csr",                             {"hipsparseDpruneCsr2csr",                             "rocsparse_dprune_csr2csr",                                         CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneCsr2csr_bufferSizeExt",               {"hipsparseHpruneCsr2csr_bufferSizeExt",               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneCsr2csr_bufferSizeExt",               {"hipsparseSpruneCsr2csr_bufferSizeExt",               "rocsparse_sprune_csr2csr_buffer_size",                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneCsr2csr_bufferSizeExt",               {"hipsparseDpruneCsr2csr_bufferSizeExt",               "rocsparse_dprune_csr2csr_buffer_size",                             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneCsr2csrNnz",                          {"hipsparseHpruneCsr2csrNnz",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneCsr2csrNnz",                          {"hipsparseSpruneCsr2csrNnz",                          "rocsparse_sprune_csr2csr_nnz",                                     CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneCsr2csrNnz",                          {"hipsparseDpruneCsr2csrNnz",                          "rocsparse_dprune_csr2csr_nnz",                                     CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneDense2csrByPercentage",               {"hipsparseHpruneDense2csrByPercentage",               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneDense2csrByPercentage",               {"hipsparseSpruneDense2csrByPercentage",               "rocsparse_sprune_dense2csr_by_percentage",                         CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneDense2csrByPercentage",               {"hipsparseDpruneDense2csrByPercentage",               "rocsparse_dprune_dense2csr_by_percentage",                         CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneDense2csrByPercentage_bufferSizeExt", {"hipsparseHpruneDense2csrByPercentage_bufferSizeExt", "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneDense2csrByPercentage_bufferSizeExt", {"hipsparseSpruneDense2csrByPercentage_bufferSizeExt", "rocsparse_sprune_dense2csr_by_percentage_buffer_size",             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneDense2csrByPercentage_bufferSizeExt", {"hipsparseDpruneDense2csrByPercentage_bufferSizeExt", "rocsparse_dprune_dense2csr_by_percentage_buffer_size",             CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneDense2csrNnzByPercentage",            {"hipsparseHpruneDense2csrNnzByPercentage",            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneDense2csrNnzByPercentage",            {"hipsparseSpruneDense2csrNnzByPercentage",            "rocsparse_sprune_dense2csr_nnz_by_percentage",                     CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneDense2csrNnzByPercentage",            {"hipsparseDpruneDense2csrNnzByPercentage",            "rocsparse_dprune_dense2csr_nnz_by_percentage",                     CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneCsr2csrByPercentage",                 {"hipsparseHpruneCsr2csrByPercentage",                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneCsr2csrByPercentage",                 {"hipsparseSpruneCsr2csrByPercentage",                 "rocsparse_sprune_csr2csr_by_percentage",                           CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneCsr2csrByPercentage",                 {"hipsparseDpruneCsr2csrByPercentage",                 "rocsparse_dprune_csr2csr_by_percentage",                           CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneCsr2csrByPercentage_bufferSizeExt",   {"hipsparseHpruneCsr2csrByPercentage_bufferSizeExt",   "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneCsr2csrByPercentage_bufferSizeExt",   {"hipsparseSpruneCsr2csrByPercentage_bufferSizeExt",   "rocsparse_sprune_csr2csr_by_percentage_buffer_size",               CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneCsr2csrByPercentage_bufferSizeExt",   {"hipsparseDpruneCsr2csrByPercentage_bufferSizeExt",   "rocsparse_dprune_csr2csr_by_percentage_buffer_size",               CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseHpruneCsr2csrNnzByPercentage",              {"hipsparseHpruneCsr2csrNnzByPercentage",              "",                                                                 CONV_LIB_FUNC, API_SPARSE, 14, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cusparseSpruneCsr2csrNnzByPercentage",              {"hipsparseSpruneCsr2csrNnzByPercentage",              "rocsparse_sprune_csr2csr_nnz_by_percentage",                       CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDpruneCsr2csrNnzByPercentage",              {"hipsparseDpruneCsr2csrNnzByPercentage",              "rocsparse_dprune_csr2csr_nnz_by_percentage",                       CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  {"cusparseSnnz_compress",                             {"hipsparseSnnz_compress",                             "rocsparse_snnz_compress",                                          CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseDnnz_compress",                             {"hipsparseDnnz_compress",                             "rocsparse_dnnz_compress",                                          CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseCnnz_compress",                             {"hipsparseCnnz_compress",                             "rocsparse_cnnz_compress",                                          CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},
  {"cusparseZnnz_compress",                             {"hipsparseZnnz_compress",                             "rocsparse_znnz_compress",                                          CONV_LIB_FUNC, API_SPARSE, 14, CUDA_DEPRECATED}},

  // 15. cuSPARSE Generic API Reference
  // Generic Sparse API helper functions
  // Sparse Matrix descriptor
  {"cusparseCreateCoo",                                 {"hipsparseCreateCoo",                                 "rocsparse_create_coo_descr",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstCoo",                            {"hipsparseCreateConstCoo",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseCreateCooAoS",                              {"hipsparseCreateCooAoS",                              "rocsparse_create_coo_aos_descr",                                   CONV_LIB_FUNC, API_SPARSE, 15, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseCreateCsr",                                 {"hipsparseCreateCsr",                                 "rocsparse_create_csr_descr",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstCsr",                            {"hipsparseCreateConstCsr",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseCreateCsc",                                 {"hipsparseCreateCsc",                                 "rocsparse_create_csc_descr",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstCsc",                            {"hipsparseCreateConstCsc",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDestroySpMat",                              {"hipsparseDestroySpMat",                              "rocsparse_destroy_spmat_descr",                                    CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCooGet",                                    {"hipsparseCooGet",                                    "rocsparse_coo_get",                                                CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCooAoSGet",                                 {"hipsparseCooAoSGet",                                 "rocsparse_coo_aos_get",                                            CONV_LIB_FUNC, API_SPARSE, 15, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseConstCooGet",                               {"hipsparseConstCooGet",                               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseCooSetStridedBatch",                        {"hipsparseCooSetStridedBatch",                        "rocsparse_coo_set_strided_batch",                                  CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCsrGet",                                    {"hipsparseCsrGet",                                    "rocsparse_csr_get",                                                CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstCsrGet",                               {"hipsparseConstCsrGet",                               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseCsrSetPointers",                            {"hipsparseCsrSetPointers",                            "rocsparse_csr_set_pointers",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCscSetPointers",                            {"hipsparseCscSetPointers",                            "rocsparse_csc_set_pointers",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCscGet",                                    {"hipsparseCscGet",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseConstCscGet",                               {"hipsparseConstCscGet",                               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseCooSetPointers",                            {"hipsparseCooSetPointers",                            "rocsparse_coo_set_pointers",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCsrSetStridedBatch",                        {"hipsparseCsrSetStridedBatch",                        "rocsparse_csr_set_strided_batch",                                  CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatGetFormat",                            {"hipsparseSpMatGetFormat",                            "rocsparse_spmat_get_format",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatGetIndexBase",                         {"hipsparseSpMatGetIndexBase",                         "rocsparse_spmat_get_index_base",                                   CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatGetValues",                            {"hipsparseSpMatGetValues",                            "rocsparse_spmat_get_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstSpMatGetValues",                       {"hipsparseConstSpMatGetValues",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpMatSetValues",                            {"hipsparseSpMatSetValues",                            "rocsparse_spmat_set_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatGetStridedBatch",                      {"hipsparseSpMatGetStridedBatch",                      "rocsparse_spmat_get_strided_batch",                                CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatSetStridedBatch",                      {"hipsparseSpMatSetStridedBatch",                      "rocsparse_spmat_set_strided_batch",                                CONV_LIB_FUNC, API_SPARSE, 15, CUDA_REMOVED}},
  {"cusparseSpMatSetNumBatches",                        {"hipsparseSpMatSetNumBatches",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseSpMatGetNumBatches",                        {"hipsparseSpMatGetNumBatches",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseSpMatGetSize",                              {"hipsparseSpMatGetSize",                              "rocsparse_spmat_get_size",                                         CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatGetAttribute",                         {"hipsparseSpMatGetAttribute",                         "rocsparse_spmat_get_attribute",                                    CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMatSetAttribute",                         {"hipsparseSpMatSetAttribute",                         "rocsparse_spmat_set_attribute",                                    CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseBlockedEllGet",                             {"hipsparseBlockedEllGet",                             "rocsparse_bell_get",                                               CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstBlockedEllGet",                        {"hipsparseConstBlockedEllGet",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseCreateBlockedEll",                          {"hipsparseCreateBlockedEll",                          "rocsparse_create_bell_descr",                                      CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstBlockedEll",                     {"hipsparseCreateConstBlockedEll",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseBsrSetStridedBatch",                        {"hipsparseBsrSetStridedBatch",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  // NOTE: rocsparse_create_bsr_descr has appeared earlier than cusparseCreateBsr and has a different signature
  {"cusparseCreateBsr",                                 {"hipsparseCreateBsr",                                 "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseCreateConstBsr",                            {"hipsparseCreateConstBsr",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseCreateSlicedEll",                           {"hipsparseCreateSlicedEll",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseCreateConstSlicedEll",                      {"hipsparseCreateConstSlicedEll",                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  // Sparse Vector descriptor
  {"cusparseCreateSpVec",                               {"hipsparseCreateSpVec",                               "rocsparse_create_spvec_descr",                                     CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstSpVec",                          {"hipsparseCreateConstSpVec",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDestroySpVec",                              {"hipsparseDestroySpVec",                              "rocsparse_destroy_spvec_descr",                                    CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpVecGet",                                  {"hipsparseSpVecGet",                                  "rocsparse_spvec_get",                                              CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstSpVecGet",                             {"hipsparseConstSpVecGet",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpVecGetIndexBase",                         {"hipsparseSpVecGetIndexBase",                         "rocsparse_spvec_get_index_base",                                   CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpVecGetValues",                            {"hipsparseSpVecGetValues",                            "rocsparse_spvec_get_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstSpVecGetValues",                       {"hipsparseConstSpVecGetValues",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpVecSetValues",                            {"hipsparseSpVecSetValues",                            "rocsparse_spvec_set_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},

  // Generic Dense API helper functions
  // Dense Matrix descriptor
  {"cusparseCreateDnMat",                               {"hipsparseCreateDnMat",                               "rocsparse_create_dnmat_descr",                                     CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstDnMat",                          {"hipsparseCreateConstDnMat",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDestroyDnMat",                              {"hipsparseDestroyDnMat",                              "rocsparse_destroy_dnmat_descr",                                    CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseDnMatGet",                                  {"hipsparseDnMatGet",                                  "rocsparse_dnmat_get",                                              CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstDnMatGet",                             {"hipsparseConstDnMatGet",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDnMatGetValues",                            {"hipsparseDnMatGetValues",                            "rocsparse_dnmat_get_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstDnMatGetValues",                       {"hipsparseConstDnMatGetValues",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDnMatSetValues",                            {"hipsparseDnMatSetValues",                            "rocsparse_dnmat_set_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseDnMatSetStridedBatch",                      {"hipsparseDnMatSetStridedBatch",                      "rocsparse_dnmat_set_strided_batch",                                CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseDnMatGetStridedBatch",                      {"hipsparseDnMatGetStridedBatch",                      "rocsparse_dnmat_get_strided_batch",                                CONV_LIB_FUNC, API_SPARSE, 15}},
  // Dense Vector descriptor
  {"cusparseCreateDnVec",                               {"hipsparseCreateDnVec",                               "rocsparse_create_dnvec_descr",                                     CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseCreateConstDnVec",                          {"hipsparseCreateConstDnVec",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDestroyDnVec",                              {"hipsparseDestroyDnVec",                              "rocsparse_destroy_dnvec_descr",                                    CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseDnVecGet",                                  {"hipsparseDnVecGet",                                  "rocsparse_dnvec_get",                                              CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstDnVecGet",                             {"hipsparseConstDnVecGet",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDnVecGetValues",                            {"hipsparseDnVecGetValues",                            "rocsparse_dnvec_get_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseConstDnVecGetValues",                       {"hipsparseConstDnVecGetValues",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDnVecSetValues",                            {"hipsparseDnVecSetValues",                            "rocsparse_dnvec_set_values",                                       CONV_LIB_FUNC, API_SPARSE, 15}},

  {"cusparseSpGEMM_createDescr",                        {"hipsparseSpGEMM_createDescr",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMM_destroyDescr",                       {"hipsparseSpGEMM_destroyDescr",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMM_workEstimation",                     {"hipsparseSpGEMM_workEstimation",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMM_compute",                            {"hipsparseSpGEMM_compute",                            "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMM_copy",                               {"hipsparseSpGEMM_copy",                               "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMM_getNumProducts",                     {"hipsparseSpGEMM_getNumProducts",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseSpGEMM_estimateMemory",                     {"hipsparseSpGEMM_estimateMemory",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},

  // Sparse Triangular Vector Solve
  {"cusparseSpSV_createDescr",                          {"hipsparseSpSV_createDescr",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSV_destroyDescr",                         {"hipsparseSpSV_destroyDescr",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSV_bufferSize",                           {"hipsparseSpSV_bufferSize",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSV_analysis",                             {"hipsparseSpSV_analysis",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSV_solve",                                {"hipsparseSpSV_solve",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSV_updateMatrix",                         {"hipsparseSpSV_updateMatrix",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},

  // Sparse Matrix * Matrix Multiplication
  {"cusparseSpMM",                                      {"hipsparseSpMM",                                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpMM_bufferSize",                           {"hipsparseSpMM_bufferSize",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpMM_preprocess",                           {"hipsparseSpMM_preprocess",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpMMOp",                                    {"hipsparseSpMMOp",                                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseSpMMOp_createPlan",                         {"hipsparseSpMMOp_createPlan",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},
  {"cusparseSpMMOp_destroyPlan",                        {"hipsparseSpMMOp_destroyPlan",                        "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED}},

  // Sparse Triangular Matrix Solve
  {"cusparseSpSM_createDescr",                          {"hipsparseSpSM_createDescr",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSM_destroyDescr",                         {"hipsparseSpSM_destroyDescr",                         "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSM_bufferSize",                           {"hipsparseSpSM_bufferSize",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSM_analysis",                             {"hipsparseSpSM_analysis",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpSM_solve",                                {"hipsparseSpSM_solve",                                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},

  // Sparse Matrix Multiplication (SpGEMM) Structure Reuse
  {"cusparseSpGEMMreuse_workEstimation",                {"hipsparseSpGEMMreuse_workEstimation",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMMreuse_nnz",                           {"hipsparseSpGEMMreuse_nnz",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMMreuse_copy",                          {"hipsparseSpGEMMreuse_copy",                          "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpGEMMreuse_compute",                       {"hipsparseSpGEMMreuse_compute",                       "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},

  // Sparse Matrix * Matrix Pattern-constrained Multiplication
  {"cusparseConstrainedGeMM",                           {"hipsparseConstrainedGeMM",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cusparseConstrainedGeMM_bufferSize",                {"hipsparseConstrainedGeMM_bufferSize",                "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},

  // Sparse Vector * Vector Operations
  // NOTE: rocsparse_spvv has one additional argument: size_t* buffer_size, thus cusparseSpVV is still ROC_UNSUPPORTED
  {"cusparseSpVV",                                      {"hipsparseSpVV",                                      "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSpVV_bufferSize",                           {"hipsparseSpVV_bufferSize",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},

  {"cusparseAxpby",                                     {"hipsparseAxpby",                                     "rocsparse_axpby",                                                  CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseGather",                                    {"hipsparseGather",                                    "rocsparse_gather",                                                 CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseScatter",                                   {"hipsparseScatter",                                   "rocsparse_scatter",                                                CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseRot",                                       {"hipsparseRot",                                       "rocsparse_rot",                                                    CONV_LIB_FUNC, API_SPARSE, 15, CUDA_DEPRECATED}},

  // Sparse Matrix * Vector Multiplication
  {"cusparseSpMV",                                      {"hipsparseSpMV",                                      "rocsparse_spmv",                                                   CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSpMV_bufferSize",                           {"hipsparseSpMV_bufferSize",                           "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},

  {"cusparseSparseToDense",                             {"hipsparseSparseToDense",                             "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseSparseToDense_bufferSize",                  {"hipsparseSparseToDense_bufferSize",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDenseToSparse_bufferSize",                  {"hipsparseDenseToSparse_bufferSize",                  "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDenseToSparse_analysis",                    {"hipsparseDenseToSparse_analysis",                    "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},
  {"cusparseDenseToSparse_convert",                     {"hipsparseDenseToSparse_convert",                     "",                                                                 CONV_LIB_FUNC, API_SPARSE, 15, ROC_UNSUPPORTED}},

  // Sampled Dense-dense Matrix Multiplication
  {"cusparseSDDMM",                                     {"hipsparseSDDMM",                                     "rocsparse_sddmm",                                                  CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSDDMM_bufferSize",                          {"hipsparseSDDMM_bufferSize",                          "rocsparse_sddmm_buffer_size",                                      CONV_LIB_FUNC, API_SPARSE, 15}},
  {"cusparseSDDMM_preprocess",                          {"hipsparseSDDMM_preprocess",                          "rocsparse_sddmm_preprocess",                                       CONV_LIB_FUNC, API_SPARSE, 15}},
};

const std::map<llvm::StringRef, cudaAPIversions> CUDA_SPARSE_FUNCTION_VER_MAP {
  {"cusparseCreateCsrgemm2Info",                        {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCreateCsrsm2Info",                          {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseCreateHybMat",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCreatePruneInfo",                           {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateSolveAnalysisInfo",                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDestroyCsrgemm2Info",                       {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDestroyCsrsm2Info",                         {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseDestroyHybMat",                             {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDestroyPruneInfo",                          {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroySolveAnalysisInfo",                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseGetLevelInfo",                              {CUDA_0,   CUDA_0,   CUDA_110}},
  {"cusparseSdoti",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDdoti",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCdoti",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZdoti",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCdotci",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZdotci",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCsrmvEx",                                   {CUDA_80,  CUDA_112, CUDA_120}},
  {"cusparseCsrmvEx_bufferSize",                        {CUDA_80,  CUDA_112, CUDA_120}},
  {"cusparseScsrmv_mp",                                 {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseDcsrmv_mp",                                 {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseCcsrmv_mp",                                 {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseZcsrmv_mp",                                 {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseSgemvi",                                    {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseDgemvi",                                    {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseCgemvi",                                    {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseZgemvi",                                    {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseSgemvi_bufferSize",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseDgemvi_bufferSize",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseCgemvi_bufferSize",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseZgemvi_bufferSize",                         {CUDA_75,  CUDA_0,   CUDA_0  }},
  {"cusparseScsrsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCsrsv_analysisEx",                          {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseCsrsv_solveEx",                             {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseShybmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDhybmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseChybmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZhybmv",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseShybsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDhybsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseChybsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZhybsv_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseShybsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDhybsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseChybsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZhybsv_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrmm",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrmm",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrmm",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrmm",                                    {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrmm2",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrmm2",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrmm2",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrmm2",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrsm_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrsm_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrsm_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrsm_analysis",                           {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrsm_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrsm_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrsm_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrsm_solve",                              {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrsm2_bufferSizeExt",                     {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseDcsrsm2_bufferSizeExt",                     {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseCcsrsm2_bufferSizeExt",                     {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseZcsrsm2_bufferSizeExt",                     {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseScsrsm2_analysis",                          {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseDcsrsm2_analysis",                          {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseCcsrsm2_analysis",                          {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseZcsrsm2_analysis",                          {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseScsrsm2_solve",                             {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseDcsrsm2_solve",                             {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseCcsrsm2_solve",                             {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseZcsrsm2_solve",                             {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseXcsrsm2_zeroPivot",                         {CUDA_100, CUDA_113, CUDA_120}},
  {"cusparseSgemmi",                                    {CUDA_80,  CUDA_110, CUDA_120}},
  {"cusparseDgemmi",                                    {CUDA_80,  CUDA_110, CUDA_120}},
  {"cusparseCgemmi",                                    {CUDA_80,  CUDA_110, CUDA_120}},
  {"cusparseZgemmi",                                    {CUDA_80,  CUDA_110, CUDA_120}},
  {"cusparseScsrgeam",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrgeam",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrgeam",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrgeam",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseXcsrgeamNnz",                               {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrgeam2",                                 {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseDcsrgeam2",                                 {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseCcsrgeam2",                                 {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseZcsrgeam2",                                 {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseXcsrgeam2Nnz",                              {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseScsrgeam2_bufferSizeExt",                   {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseDcsrgeam2_bufferSizeExt",                   {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseCcsrgeam2_bufferSizeExt",                   {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseZcsrgeam2_bufferSizeExt",                   {CUDA_100, CUDA_0,   CUDA_0  }},
  {"cusparseScsrgemm",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrgemm",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrgemm",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrgemm",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseXcsrgemmNnz",                               {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrgemm2",                                 {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDcsrgemm2",                                 {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCcsrgemm2",                                 {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseZcsrgemm2",                                 {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseXcsrgemm2Nnz",                              {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseScsrgemm2_bufferSizeExt",                   {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDcsrgemm2_bufferSizeExt",                   {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCcsrgemm2_bufferSizeExt",                   {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseZcsrgemm2_bufferSizeExt",                   {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseScsric0",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsric0",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsric0",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsric0",                                   {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseScsrilu0",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsrilu0",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsrilu0",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsrilu0",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCsrilu0Ex",                                 {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseSgtsv",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDgtsv",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCgtsv",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZgtsv",                                     {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseSgtsv_nopivot",                             {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDgtsv_nopivot",                             {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCgtsv_nopivot",                             {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZgtsv_nopivot",                             {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseSgtsv2_bufferSizeExt",                      {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseDgtsv2_bufferSizeExt",                      {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseCgtsv2_bufferSizeExt",                      {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseZgtsv2_bufferSizeExt",                      {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2",                                    {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseDgtsv2",                                    {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseCgtsv2",                                    {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseZgtsv2",                                    {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2_nopivot_bufferSizeExt",              {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseDgtsv2_nopivot_bufferSizeExt",              {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseCgtsv2_nopivot_bufferSizeExt",              {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseZgtsv2_nopivot_bufferSizeExt",              {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2_nopivot",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseDgtsv2_nopivot",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseCgtsv2_nopivot",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseZgtsv2_nopivot",                            {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsvStridedBatch",                         {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDgtsvStridedBatch",                         {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCgtsvStridedBatch",                         {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZgtsvStridedBatch",                         {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseSgtsv2StridedBatch_bufferSizeExt",          {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsvDStridedBatch_bufferSizeExt",          {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsvCStridedBatch_bufferSizeExt",          {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsvZStridedBatch_bufferSizeExt",          {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2StridedBatch",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2DtridedBatch",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2CtridedBatch",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsv2ZtridedBatch",                        {CUDA_90,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseDgtsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseCgtsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseZgtsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseSgtsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseDgtsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseCgtsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseZgtsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseSgpsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseDgpsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseCgpsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseZgpsvInterleavedBatch_bufferSizeExt",       {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseSgpsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseDgpsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseCgpsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseZgpsvInterleavedBatch",                     {CUDA_92,  CUDA_0,   CUDA_0  }},
  {"cusparseScsc2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsc2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsc2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsc2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCsr2cscEx",                                 {CUDA_80,  CUDA_102, CUDA_110}},
  {"cusparseCsr2cscEx2",                                {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseCsr2cscEx2_bufferSize",                     {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseScsr2csr_compress",                         {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsr2csr_compress",                         {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsr2csr_compress",                         {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsr2csr_compress",                         {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsr2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsr2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsr2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsr2hyb",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseSdense2hyb",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDdense2hyb",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCdense2hyb",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZdense2hyb",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseShyb2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDhyb2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseChyb2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZhyb2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseShyb2csr",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDhyb2csr",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseChyb2csr",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZhyb2csr",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseShyb2dense",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDhyb2dense",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseChyb2dense",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZhyb2dense",                                {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseHpruneDense2csr",                           {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneDense2csr",                           {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneDense2csr",                           {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneDense2csr_bufferSizeExt",             {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneDense2csr_bufferSizeExt",             {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneDense2csr_bufferSizeExt",             {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneDense2csrNnz",                        {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneDense2csrNnz",                        {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneDense2csrNnz",                        {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneCsr2csr",                             {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneCsr2csr",                             {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneCsr2csr",                             {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneCsr2csr_bufferSizeExt",               {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneCsr2csr_bufferSizeExt",               {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneCsr2csr_bufferSizeExt",               {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneCsr2csrNnz",                          {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneCsr2csrNnz",                          {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneCsr2csrNnz",                          {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneDense2csrByPercentage",               {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneDense2csrByPercentage",               {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneDense2csrByPercentage",               {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneDense2csrByPercentage_bufferSizeExt", {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneDense2csrByPercentage_bufferSizeExt", {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneDense2csrByPercentage_bufferSizeExt", {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneDense2csrNnzByPercentage",            {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneDense2csrNnzByPercentage",            {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneDense2csrNnzByPercentage",            {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneCsr2csrByPercentage",                 {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneCsr2csrByPercentage",                 {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneCsr2csrByPercentage",                 {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneCsr2csrByPercentage_bufferSizeExt",   {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneCsr2csrByPercentage_bufferSizeExt",   {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneCsr2csrByPercentage_bufferSizeExt",   {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseHpruneCsr2csrNnzByPercentage",              {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpruneCsr2csrNnzByPercentage",              {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDpruneCsr2csrNnzByPercentage",              {CUDA_90,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSnnz_compress",                             {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDnnz_compress",                             {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCnnz_compress",                             {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZnnz_compress",                             {CUDA_80,  CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateCoo",                                 {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseCreateCooAoS",                              {CUDA_102, CUDA_112, CUDA_120}},
  {"cusparseCreateCsr",                                 {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDestroySpMat",                              {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseCooGet",                                    {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseCooAoSGet",                                 {CUDA_102, CUDA_112, CUDA_120}},
  {"cusparseCsrGet",                                    {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatGetFormat",                            {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatGetIndexBase",                         {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatGetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatSetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatGetStridedBatch",                      {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatSetStridedBatch",                      {CUDA_102, CUDA_0,   CUDA_120}},
  {"cusparseSpMatSetNumBatches",                        {CUDA_101, CUDA_0,   CUDA_102}},
  {"cusparseSpMatGetNumBatches",                        {CUDA_101, CUDA_0,   CUDA_102}},
  {"cusparseCreateSpVec",                               {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDestroySpVec",                              {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpVecGet",                                  {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpVecGetIndexBase",                         {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpVecGetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpVecSetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseCreateDnMat",                               {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseDestroyDnMat",                              {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseDnMatGet",                                  {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseDnMatGetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDnMatSetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDnMatSetStridedBatch",                      {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseDnMatGetStridedBatch",                      {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseCreateDnVec",                               {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDestroyDnVec",                              {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDnVecGet",                                  {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDnVecGetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseDnVecSetValues",                            {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMM",                                      {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseSpMM_bufferSize",                           {CUDA_101, CUDA_0,   CUDA_0  }},
  {"cusparseSpVV",                                      {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpVV_bufferSize",                           {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMV",                                      {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSpMV_bufferSize",                           {CUDA_102, CUDA_0,   CUDA_0  }},
  {"cusparseSaxpyi",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDaxpyi",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCaxpyi",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseZaxpyi",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseSgthr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDgthr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCgthr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseZgthr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseSgthrz",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDgthrz",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCgthrz",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseZgthrz",                                    {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseSsctr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDsctr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseCsctr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseZsctr",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseSroti",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseDroti",                                     {CUDA_0,   CUDA_110, CUDA_120}},
  {"cusparseScsr2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseDcsr2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseCcsr2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseZcsr2csc",                                  {CUDA_0,   CUDA_102, CUDA_110}},
  {"cusparseSpMatGetSize",                              {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseCooSetStridedBatch",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseCsrSetStridedBatch",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseAxpby",                                     {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseGather",                                    {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseScatter",                                   {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseRot",                                       {CUDA_110, CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSpGEMM_createDescr",                        {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMM_destroyDescr",                       {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMM_compute",                            {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMM_copy",                               {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMM_workEstimation",                     {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseConstrainedGeMM",                           {CUDA_102, CUDA_112, CUDA_120}},
  {"cusparseConstrainedGeMM_bufferSize",                {CUDA_102, CUDA_112, CUDA_120}},
  {"cusparseSdense2csr",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseDdense2csr",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseCdense2csr",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseZdense2csr",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseScsr2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseDcsr2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseCcsr2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseZcsr2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseSdense2csc",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseDdense2csc",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseCdense2csc",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseZdense2csc",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseScsc2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseDcsc2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseCcsc2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseZcsc2dense",                                {CUDA_0,   CUDA_111, CUDA_120}},
  {"cusparseCreateCsc",                                 {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseCsrSetPointers",                            {CUDA_110, CUDA_0,   CUDA_0  }},
  {"cusparseCscSetPointers",                            {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseCooSetPointers",                            {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseSparseToDense_bufferSize",                  {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseSparseToDense",                             {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseDenseToSparse_bufferSize",                  {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseDenseToSparse_analysis",                    {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseDenseToSparse_convert",                     {CUDA_111, CUDA_0,   CUDA_0  }},
  {"cusparseCreateCsrsv2Info",                          {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseDestroyCsrsv2Info",                         {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseXcsrsv2_zeroPivot",                         {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseScsrsv2_bufferSize",                        {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseDcsrsv2_bufferSize",                        {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseCcsrsv2_bufferSize",                        {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseZcsrsv2_bufferSize",                        {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseScsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseDcsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseCcsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseZcsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseScsrsv2_analysis",                          {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseDcsrsv2_analysis",                          {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseCcsrsv2_analysis",                          {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseZcsrsv2_analysis",                          {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseScsrsv2_solve",                             {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseDcsrsv2_solve",                             {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseCcsrsv2_solve",                             {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseZcsrsv2_solve",                             {CUDA_0,   CUDA_113, CUDA_120}},
  {"cusparseSpMatGetAttribute",                         {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpMatSetAttribute",                         {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSV_createDescr",                          {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSV_destroyDescr",                         {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSV_bufferSize",                           {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSV_analysis",                             {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSV_solve",                                {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSM_createDescr",                          {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSM_destroyDescr",                         {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSM_bufferSize",                           {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSM_analysis",                             {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpSM_solve",                                {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMMreuse_workEstimation",                {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMMreuse_nnz",                           {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMMreuse_copy",                          {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMMreuse_compute",                       {CUDA_113, CUDA_0,   CUDA_0  }},
  {"cusparseSDDMM",                                     {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusparseSDDMM_bufferSize",                          {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusparseSDDMM_preprocess",                          {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusparseCreateBlockedEll",                          {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusparseBlockedEllGet",                             {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusparseSpMM_preprocess",                           {CUDA_112, CUDA_0,   CUDA_0  }},
  {"cusparseLoggerSetCallback",                         {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseLoggerSetFile",                             {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseLoggerOpenFile",                            {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseLoggerSetLevel",                            {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseLoggerSetMask",                             {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseLoggerForceDisable",                        {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseSpMMOp",                                    {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseSpMMOp_createPlan",                         {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseSpMMOp_destroyPlan",                        {CUDA_115, CUDA_0,   CUDA_0  }},
  {"cusparseCscGet",                                    {CUDA_117, CUDA_0,   CUDA_0  }},
  {"cusparseCopyMatDescr",                              {CUDA_80,  CUDA_0,   CUDA_120}},
  {"cusparseCreateConstSpVec",                          {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstSpVecGet",                             {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstSpVecGetValues",                       {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseCreateConstDnVec",                          {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstDnVecGet",                             {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstDnVecGetValues",                       {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstSpMatGetValues",                       {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseCreateConstCsr",                            {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseCreateConstCsc",                            {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstCsrGet",                               {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstCscGet",                               {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseCreateConstCoo",                            {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstCooGet",                               {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseCreateConstBlockedEll",                     {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstBlockedEllGet",                        {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseCreateConstDnMat",                          {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstDnMatGet",                             {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseConstDnMatGetValues",                       {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMM_getNumProducts",                     {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseSpGEMM_estimateMemory",                     {CUDA_120, CUDA_0,   CUDA_0  }},
  {"cusparseBsrSetStridedBatch",                        {CUDA_121, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 12100
  {"cusparseCreateBsr",                                 {CUDA_121, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 12100
  {"cusparseCreateConstBsr",                            {CUDA_121, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 12100
  {"cusparseCreateSlicedEll",                           {CUDA_121, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 12100
  {"cusparseCreateConstSlicedEll",                      {CUDA_121, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 12100
  {"cusparseSpSV_updateMatrix",                         {CUDA_121, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 12100
  {"cusparseCreateCsric02Info",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyCsric02Info",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateBsric02Info",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyBsric02Info",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateCsrilu02Info",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyCsrilu02Info",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateBsrilu02Info",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyBsrilu02Info",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateBsrsv2Info",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyBsrsv2Info",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateBsrsm2Info",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyBsrsm2Info",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateCsru2csrInfo",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyCsru2csrInfo",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateColorInfo",                           {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDestroyColorInfo",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrxmv",                                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrxmv",                                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrxmv",                                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrxmv",                                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXbsrsv2_zeroPivot",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsv2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsv2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsv2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsv2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsv2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsv2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsv2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsv2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsv2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsv2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsv2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsv2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsv2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXbsrsm2_zeroPivot",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsm2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsm2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsm2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsm2_bufferSize",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsm2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsm2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsm2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsm2_bufferSizeExt",                     {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsm2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsm2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsm2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsm2_analysis",                          {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrsm2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrsm2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrsm2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrsm2_solve",                             {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXcsrilu02_zeroPivot",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrilu02_numericBoost",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXbsrilu02_zeroPivot",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrilu02_bufferSize",                      {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrilu02_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrilu02_analysis",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsrilu02",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXcsric02_zeroPivot",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXcsric02_zeroPivot",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsric02_bufferSize",                       {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsric02_bufferSizeExt",                    {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsric02_analysis",                         {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseSbsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDbsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCbsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZbsric02",                                  {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsrcolor",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsrcolor",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsrcolor",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsrcolor",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCreateIdentityPermutation",                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsru2csr_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsru2csr_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsru2csr_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsru2csr_bufferSizeExt",                   {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsru2csr",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsru2csr",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsru2csr",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsru2csr",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseScsr2csru",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseDcsr2csru",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseCcsr2csru",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseZcsr2csru",                                 {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseXbsric02_zeroPivot",                        {CUDA_0,   CUDA_122, CUDA_0  }}, // CUSPARSE_VERSION 12120
  {"cusparseGetErrorName",                              {CUDA_102, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 10301
  {"cusparseGetErrorString",                            {CUDA_102, CUDA_0,   CUDA_0  }}, // CUSPARSE_VERSION 10301
};

const std::map<llvm::StringRef, hipAPIversions> HIP_SPARSE_FUNCTION_VER_MAP {
  {"hipsparseCreate",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDestroy",                                   {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetPointerMode",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetVersion",                                {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSetPointerMode",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSetStream",                                 {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetStream",                                 {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCreateHybMat",                              {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCreateMatDescr",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDestroyHybMat",                             {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDestroyMatDescr",                           {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetMatDiagType",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetMatFillMode",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetMatIndexBase",                           {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetMatType",                                {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSetMatDiagType",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSetMatFillMode",                            {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSetMatIndexBase",                           {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSetMatType",                                {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsrsv2Info",                          {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDestroyCsrsv2Info",                         {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsrsm2Info",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDestroyCsrsm2Info",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsric02Info",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDestroyCsric02Info",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsrilu02Info",                        {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDestroyCsrilu02Info",                       {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCreateBsrsv2Info",                          {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseDestroyBsrsv2Info",                         {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseCreateBsric02Info",                         {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseDestroyBsric02Info",                        {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseCreateBsrilu02Info",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDestroyBsrilu02Info",                       {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsrgemm2Info",                        {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseDestroyCsrgemm2Info",                       {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseCreatePruneInfo",                           {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDestroyPruneInfo",                          {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSaxpyi",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDaxpyi",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCaxpyi",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZaxpyi",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSdoti",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDdoti",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCdoti",                                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZdoti",                                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCdotci",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZdotci",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSgthr",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDgthr",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCgthr",                                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZgthr",                                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSgthrz",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDgthrz",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCgthrz",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZgthrz",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSroti",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDroti",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseSsctr",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDsctr",                                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCsctr",                                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZsctr",                                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSbsrmv",                                    {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDbsrmv",                                    {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCbsrmv",                                    {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZbsrmv",                                    {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsrmv",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrmv",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrmv",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrmv",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsv2_bufferSize",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsv2_bufferSizeExt",                     {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsv2_bufferSize",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsv2_bufferSizeExt",                     {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsv2_bufferSize",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsv2_bufferSizeExt",                     {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsv2_bufferSize",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsv2_bufferSizeExt",                     {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsv2_analysis",                          {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsv2_analysis",                          {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsv2_analysis",                          {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsv2_analysis",                          {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsv2_solve",                             {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsv2_solve",                             {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsv2_solve",                             {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsv2_solve",                             {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseXbsrsv2_zeroPivot",                         {HIP_3060, HIP_0,    HIP_0   }},
  {"hipsparseScsrsv2_bufferSize",                        {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseScsrsv2_bufferSizeExt",                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsv2_bufferSize",                        {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsv2_bufferSizeExt",                     {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsv2_bufferSize",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsv2_bufferSizeExt",                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsv2_bufferSize",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsv2_bufferSizeExt",                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrsv2_analysis",                          {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsv2_analysis",                          {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsv2_analysis",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsv2_analysis",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrsv2_solve",                             {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsv2_solve",                             {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsv2_solve",                             {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsv2_solve",                             {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseXcsrsv2_zeroPivot",                         {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseShybmv",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDhybmv",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseChybmv",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZhybmv",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrmm",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrmm",                                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrmm",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrmm",                                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrmm2",                                   {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrmm2",                                   {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrmm2",                                   {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrmm2",                                   {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrsm2_bufferSizeExt",                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsm2_bufferSizeExt",                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsm2_bufferSizeExt",                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsm2_bufferSizeExt",                     {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrsm2_analysis",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsm2_analysis",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsm2_analysis",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsm2_analysis",                          {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrsm2_solve",                             {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsrsm2_solve",                             {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsrsm2_solve",                             {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrsm2_solve",                             {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseXcsrsm2_zeroPivot",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSbsrmm",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseDbsrmm",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseCbsrmm",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseZbsrmm",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseSgemmi",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseDgemmi",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseCgemmi",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseZgemmi",                                    {HIP_3070, HIP_0,    HIP_0   }},
  {"hipsparseScsrgeam",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsrgeam",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsrgeam",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsrgeam",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseXcsrgeamNnz",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsrgeam2",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsrgeam2",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsrgeam2",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsrgeam2",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseXcsrgeam2Nnz",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsrgeam2_bufferSizeExt",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsrgeam2_bufferSizeExt",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsrgeam2_bufferSizeExt",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsrgeam2_bufferSizeExt",                   {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsrgemm",                                  {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseDcsrgemm",                                  {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseCcsrgemm",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrgemm",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseXcsrgemmNnz",                               {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseScsrgemm2",                                 {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseDcsrgemm2",                                 {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseCcsrgemm2",                                 {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrgemm2",                                 {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseXcsrgemm2Nnz",                              {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseScsrgemm2_bufferSizeExt",                   {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseDcsrgemm2_bufferSizeExt",                   {HIP_2080, HIP_0,    HIP_0   }},
  {"hipsparseCcsrgemm2_bufferSizeExt",                   {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrgemm2_bufferSizeExt",                   {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsric02_bufferSize",                       {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsric02_bufferSizeExt",                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsric02_bufferSize",                       {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsric02_bufferSizeExt",                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsric02_bufferSize",                       {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsric02_bufferSizeExt",                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsric02_bufferSize",                       {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsric02_bufferSizeExt",                    {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsric02_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsric02_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsric02_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsric02_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsric02",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDcsric02",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsric02",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsric02",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseXcsric02_zeroPivot",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSbsric02_bufferSize",                       {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseDbsric02_bufferSize",                       {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseCbsric02_bufferSize",                       {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseZbsric02_bufferSize",                       {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseSbsric02_analysis",                         {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseDbsric02_analysis",                         {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseCbsric02_analysis",                         {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseZbsric02_analysis",                         {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseSbsric02",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseDbsric02",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseCbsric02",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseZbsric02",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseXbsric02_zeroPivot",                        {HIP_3080, HIP_0,    HIP_0   }},
  {"hipsparseScsrilu02_numericBoost",                    {HIP_3100, HIP_0,    HIP_0   }},
  {"hipsparseDcsrilu02_numericBoost",                    {HIP_3100, HIP_0,    HIP_0   }},
  {"hipsparseCcsrilu02_numericBoost",                    {HIP_3100, HIP_0,    HIP_0   }},
  {"hipsparseZcsrilu02_numericBoost",                    {HIP_3100, HIP_0,    HIP_0   }},
  {"hipsparseXcsrilu02_zeroPivot",                       {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseScsrilu02_bufferSize",                      {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseScsrilu02_bufferSizeExt",                   {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrilu02_bufferSize",                      {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrilu02_bufferSizeExt",                   {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrilu02_bufferSize",                      {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseCcsrilu02_bufferSizeExt",                   {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrilu02_bufferSize",                      {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrilu02_bufferSizeExt",                   {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrilu02_analysis",                        {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrilu02_analysis",                        {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrilu02_analysis",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrilu02_analysis",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsrilu02",                                 {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsrilu02",                                 {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsrilu02",                                 {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsrilu02",                                 {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSbsrilu02_numericBoost",                    {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDbsrilu02_numericBoost",                    {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseCbsrilu02_numericBoost",                    {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseZbsrilu02_numericBoost",                    {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSbsrilu02_bufferSize",                      {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDbsrilu02_bufferSize",                      {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseCbsrilu02_bufferSize",                      {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseZbsrilu02_bufferSize",                      {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSbsrilu02_analysis",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDbsrilu02_analysis",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseCbsrilu02_analysis",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseZbsrilu02_analysis",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSbsrilu02",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDbsrilu02",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseCbsrilu02",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseZbsrilu02",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseXbsrilu02_zeroPivot",                       {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSbsr2csr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDbsr2csr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCbsr2csr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZbsr2csr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseXcoo2csr",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseScsc2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsc2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsc2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsc2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseXcsr2bsrNnz",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsr2bsr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2bsr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2bsr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2bsr",                                  {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseXcsr2coo",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseScsr2csc",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2csc",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2csc",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2csc",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseScsr2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2dense",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsr2csr_compress",                         {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2csr_compress",                         {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2csr_compress",                         {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2csr_compress",                         {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseScsr2hyb",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2hyb",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2hyb",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2hyb",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSdense2csc",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDdense2csc",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCdense2csc",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZdense2csc",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseSdense2csr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDdense2csr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCdense2csr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZdense2csr",                                {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseShyb2csr",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseDhyb2csr",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseChyb2csr",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseZhyb2csr",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"hipsparseSnnz",                                      {HIP_3020, HIP_0,    HIP_0   }},
  {"hipsparseDnnz",                                      {HIP_3020, HIP_0,    HIP_0   }},
  {"hipsparseCnnz",                                      {HIP_3020, HIP_0,    HIP_0   }},
  {"hipsparseZnnz",                                      {HIP_3020, HIP_0,    HIP_0   }},
  {"hipsparseCreateIdentityPermutation",                 {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseXcoosort_bufferSizeExt",                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseXcoosortByRow",                             {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseXcoosortByColumn",                          {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseXcsrsort_bufferSizeExt",                    {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseXcsrsort",                                  {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseXcscsort_bufferSizeExt",                    {HIP_2100, HIP_0,    HIP_0   }},
  {"hipsparseXcscsort",                                  {HIP_2100, HIP_0,    HIP_0   }},
  {"hipsparseSpruneDense2csr",                           {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneDense2csr",                           {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneDense2csr_bufferSizeExt",             {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneDense2csr_bufferSizeExt",             {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneDense2csrNnz",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneDense2csrNnz",                        {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneCsr2csr",                             {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneCsr2csr",                             {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneCsr2csr_bufferSizeExt",               {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneCsr2csr_bufferSizeExt",               {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneCsr2csrNnz",                          {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneCsr2csrNnz",                          {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneDense2csrByPercentage",               {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneDense2csrByPercentage",               {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneDense2csrByPercentage_bufferSizeExt", {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneDense2csrByPercentage_bufferSizeExt", {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneDense2csrNnzByPercentage",            {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneDense2csrNnzByPercentage",            {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneCsr2csrByPercentage",                 {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneCsr2csrByPercentage",                 {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneCsr2csrByPercentage_bufferSizeExt",   {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneCsr2csrByPercentage_bufferSizeExt",   {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSpruneCsr2csrNnzByPercentage",              {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseDpruneCsr2csrNnzByPercentage",              {HIP_3090, HIP_0,    HIP_0   }},
  {"hipsparseSnnz_compress",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseDnnz_compress",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseCnnz_compress",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseZnnz_compress",                             {HIP_3050, HIP_0,    HIP_0   }},
  {"hipsparseSgebsr2gebsc_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDgebsr2gebsc_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCgebsr2gebsc_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZgebsr2gebsc_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSgebsr2gebsc",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDgebsr2gebsc",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCgebsr2gebsc",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZgebsr2gebsc",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSgebsr2gebsr_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDgebsr2gebsr_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCgebsr2gebsr_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZgebsr2gebsr_bufferSize",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSgebsr2csr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDgebsr2csr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCgebsr2csr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZgebsr2csr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseXgebsr2gebsrNnz",                           {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSgebsr2gebsr",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDgebsr2gebsr",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCgebsr2gebsr",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZgebsr2gebsr",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseScsr2gebsr_bufferSize",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2gebsr_bufferSize",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2gebsr_bufferSize",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2gebsr_bufferSize",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseXcsr2gebsrNnz",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseScsr2gebsr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2gebsr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2gebsr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2gebsr",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCreateCoo",                                 {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCreateCooAoS",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsr",                                 {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDestroySpMat",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCooGet",                                    {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCooAoSGet",                                 {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCsrGet",                                    {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCsrSetPointers",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMatGetFormat",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMatGetIndexBase",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMatGetValues",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMatSetValues",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMatGetSize",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCreateSpVec",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDestroySpVec",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpVecGet",                                  {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpVecGetIndexBase",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpVecGetValues",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpVecSetValues",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCreateDnVec",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDestroyDnVec",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDnVecGet",                                  {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDnVecGetValues",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseDnVecSetValues",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMM_createDescr",                        {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMM_destroyDescr",                       {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMM_workEstimation",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMM_compute",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMM_copy",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpVV",                                      {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpVV_bufferSize",                           {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseAxpby",                                     {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseGather",                                    {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseScatter",                                   {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseRot",                                       {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMV",                                      {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseSpMV_bufferSize",                           {HIP_4010, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsru2csrInfo",                        {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDestroyCsru2csrInfo",                       {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseScsru2csr_bufferSizeExt",                   {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDcsru2csr_bufferSizeExt",                   {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCcsru2csr_bufferSizeExt",                   {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseZcsru2csr_bufferSizeExt",                   {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseScsru2csr",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDcsru2csr",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCcsru2csr",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseZcsru2csr",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseScsr2csru",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDcsr2csru",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCcsr2csru",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseZcsr2csru",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCreateCsc",                                 {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCscSetPointers",                            {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCooSetPointers",                            {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseCreateDnMat",                               {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDestroyDnMat",                              {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDnMatGet",                                  {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDnMatGetValues",                            {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDnMatSetValues",                            {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseSparseToDense_bufferSize",                  {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseSparseToDense",                             {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDenseToSparse_bufferSize",                  {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDenseToSparse_analysis",                    {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseDenseToSparse_convert",                     {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseSpMM_bufferSize",                           {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseSpMM",                                      {HIP_4020, HIP_0,    HIP_0   }},
  {"hipsparseSgemvi_bufferSize",                         {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseDgemvi_bufferSize",                         {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCgemvi_bufferSize",                         {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseZgemvi_bufferSize",                         {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSgemvi",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseDgemvi",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCgemvi",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseZgemvi",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSgtsv2_bufferSizeExt",                      {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseDgtsv2_bufferSizeExt",                      {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCgtsv2_bufferSizeExt",                      {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseZgtsv2_bufferSizeExt",                      {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSgtsv2",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseDgtsv2",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCgtsv2",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseZgtsv2",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSgtsv2_nopivot_bufferSizeExt",              {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseDgtsv2_nopivot_bufferSizeExt",              {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCgtsv2_nopivot_bufferSizeExt",              {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseZgtsv2_nopivot_bufferSizeExt",              {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSgtsv2_nopivot",                            {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseDgtsv2_nopivot",                            {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCgtsv2_nopivot",                            {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseZgtsv2_nopivot",                            {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSDDMM",                                     {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSDDMM_bufferSize",                          {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseSDDMM_preprocess",                          {HIP_4030, HIP_0,    HIP_0   }},
  {"hipsparseCreateBsrsm2Info",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDestroyBsrsm2Info",                         {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCreateColorInfo",                           {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDestroyColorInfo",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSbsrxmv",                                   {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDbsrxmv",                                   {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCbsrxmv",                                   {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZbsrxmv",                                   {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseXbsrsm2_zeroPivot",                         {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsm2_bufferSize",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsm2_bufferSize",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsm2_bufferSize",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsm2_bufferSize",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsm2_analysis",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsm2_analysis",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsm2_analysis",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsm2_analysis",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSbsrsm2_solve",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDbsrsm2_solve",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCbsrsm2_solve",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZbsrsm2_solve",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseScsrcolor",                                 {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDcsrcolor",                                 {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCcsrcolor",                                 {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZcsrcolor",                                 {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCreateBlockedEll",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseBlockedEllGet",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpMatGetAttribute",                         {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpMatSetAttribute",                         {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpMM_preprocess",                           {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSV_createDescr",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSV_destroyDescr",                         {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSV_bufferSize",                           {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSV_analysis",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSV_solve",                                {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSM_createDescr",                          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSM_destroyDescr",                         {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSM_bufferSize",                           {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSM_analysis",                             {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSpSM_solve",                                {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSgtsv2StridedBatch_bufferSizeExt",          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDgtsv2StridedBatch_bufferSizeExt",          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCgtsv2StridedBatch_bufferSizeExt",          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZgtsv2StridedBatch_bufferSizeExt",          {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSgtsv2StridedBatch",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseDgtsv2StridedBatch",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseCgtsv2StridedBatch",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseZgtsv2StridedBatch",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"hipsparseSgtsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseDgtsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseCgtsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseZgtsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSgtsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseDgtsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseCgtsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseZgtsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSgpsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseDgpsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseCgpsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseZgpsvInterleavedBatch_bufferSizeExt",       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSgpsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseDgpsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseCgpsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseZgpsvInterleavedBatch",                     {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMMreuse_workEstimation",                {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMMreuse_nnz",                           {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMMreuse_compute",                       {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSpGEMMreuse_copy",                          {HIP_5010, HIP_0,    HIP_0   }},
  {"hipsparseSpMatGetStridedBatch",                      {HIP_5020, HIP_0,    HIP_0   }},
  {"hipsparseSpMatSetStridedBatch",                      {HIP_5020, HIP_0,    HIP_0   }},
  {"hipsparseCooSetStridedBatch",                        {HIP_5020, HIP_0,    HIP_0   }},
  {"hipsparseCsrSetStridedBatch",                        {HIP_5020, HIP_0,    HIP_0   }},
  {"hipsparseDnMatGetStridedBatch",                      {HIP_5020, HIP_0,    HIP_0   }},
  {"hipsparseDnMatSetStridedBatch",                      {HIP_5020, HIP_0,    HIP_0   }},
  {"hipsparseCsr2cscEx2_bufferSize",                     {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsparseCsr2cscEx2",                                {HIP_5040, HIP_0,    HIP_0   }},
  {"hipsparseCopyMatDescr",                              {HIP_1092, HIP_0,    HIP_0   }},
  {"hipsparseGetErrorName",                              {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseGetErrorString",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstSpVec",                          {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstSpVecGet",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstSpVecGetValues",                       {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstCoo",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstCsr",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstCsc",                            {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstBlockedEll",                     {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstCooGet",                               {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstCsrGet",                               {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstBlockedEllGet",                        {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstSpMatGetValues",                       {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstDnVec",                          {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstDnVecGet",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstDnVecGetValues",                       {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseCreateConstDnMat",                          {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstDnMatGet",                             {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"hipsparseConstDnMatGetValues",                       {HIP_6000, HIP_0,    HIP_0,  HIP_LATEST}},
  {"rocsparse_create_handle",                            {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_handle",                           {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_set_stream",                               {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_stream",                               {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_set_pointer_mode",                         {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_pointer_mode",                         {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_version",                              {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_create_mat_descr",                         {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_copy_mat_descr",                           {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_mat_descr",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_set_mat_index_base",                       {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_mat_index_base",                       {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_set_mat_type",                             {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_mat_type",                             {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_set_mat_fill_mode",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_mat_fill_mode",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_set_mat_diag_type",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_get_mat_diag_type",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_create_hyb_mat",                           {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_hyb_mat",                          {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_create_color_info",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_color_info",                       {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_create_spvec_descr",                       {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_spvec_descr",                      {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spvec_get",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spvec_get_index_base",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spvec_get_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spvec_set_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_create_coo_descr",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_create_coo_aos_descr",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_create_csr_descr",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_create_csc_descr",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_create_bell_descr",                        {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_spmat_descr",                      {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_coo_get",                                  {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_coo_aos_get",                              {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_csr_get",                                  {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_bell_get",                                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_coo_set_pointers",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_csr_set_pointers",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_csc_set_pointers",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_get_size",                           {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_get_format",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_get_index_base",                     {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_get_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_set_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_get_strided_batch",                  {HIP_5020, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_set_strided_batch",                  {HIP_5020, HIP_0,    HIP_0   }},
  {"rocsparse_coo_set_strided_batch",                    {HIP_5020, HIP_0,    HIP_0   }},
  {"rocsparse_csr_set_strided_batch",                    {HIP_5020, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_get_attribute",                      {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_spmat_set_attribute",                      {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_create_dnvec_descr",                       {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_dnvec_descr",                      {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnvec_get",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnvec_get_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnvec_set_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_create_dnmat_descr",                       {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_destroy_dnmat_descr",                      {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnmat_get",                                {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnmat_get_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnmat_set_values",                         {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dnmat_get_strided_batch",                  {HIP_5020, HIP_0,    HIP_0   }},
  {"rocsparse_dnmat_set_strided_batch",                  {HIP_5020, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrcolor",                                {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_ccsrcolor",                                {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrcolor",                                {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_scsrcolor",                                {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_sddmm_preprocess",                         {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sddmm_buffer_size",                        {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sddmm",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_spmv",                                     {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_rot",                                      {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_scatter",                                  {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_gather",                                   {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_axpby",                                    {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_zgebsr2gebsr",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_zgebsr2gebsr_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_cgebsr2gebsr",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_cgebsr2gebsr_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dgebsr2gebsr",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dgebsr2gebsr_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_sgebsr2gebsr",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_sgebsr2gebsr_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_gebsr2gebsr_nnz",                          {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_zgebsr2csr",                               {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_cgebsr2csr",                               {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_dgebsr2csr",                               {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_sgebsr2csr",                               {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_zbsr2csr",                                 {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_cbsr2csr",                                 {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_dbsr2csr",                                 {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_sbsr2csr",                                 {HIP_3100, HIP_0,    HIP_0   }},
  {"rocsparse_coosort_by_column",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_coosort_by_row",                           {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_coosort_buffer_size",                      {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_cscsort",                                  {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_cscsort_buffer_size",                      {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_csrsort",                                  {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_csrsort_buffer_size",                      {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_create_identity_permutation",              {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_coo2csr",                                  {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_csr2csr_by_percentage",             {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_csr2csr_by_percentage",             {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_csr2csr_nnz_by_percentage",         {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_csr2csr_nnz_by_percentage",         {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_csr2csr_by_percentage_buffer_size", {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_csr2csr_by_percentage_buffer_size", {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_csr2csr",                           {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_csr2csr",                           {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_csr2csr_nnz",                       {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_csr2csr_nnz",                       {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_csr2csr_buffer_size",               {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_csr2csr_buffer_size",               {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_zcsr2csr_compress",                        {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_ccsr2csr_compress",                        {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsr2csr_compress",                        {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_scsr2csr_compress",                        {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_zcsr2gebsr",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_ccsr2gebsr",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dcsr2gebsr",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_scsr2gebsr",                               {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_csr2gebsr_nnz",                            {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_zcsr2gebsr_buffer_size",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_ccsr2gebsr_buffer_size",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dcsr2gebsr_buffer_size",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_scsr2gebsr_buffer_size",                   {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_zcsr2bsr",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_ccsr2bsr",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsr2bsr",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_scsr2bsr",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_csr2bsr_nnz",                              {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_zcsr2hyb",                                 {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_ccsr2hyb",                                 {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_dcsr2hyb",                                 {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_scsr2hyb",                                 {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_zgebsr2gebsc",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_cgebsr2gebsc",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dgebsr2gebsc",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_sgebsr2gebsc",                             {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_zgebsr2gebsc_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_cgebsr2gebsc_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_dgebsr2gebsc_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_sgebsr2gebsc_buffer_size",                 {HIP_4010, HIP_0,    HIP_0   }},
  {"rocsparse_csr2coo",                                  {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_znnz_compress",                            {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_cnnz_compress",                            {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_dnnz_compress",                            {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_snnz_compress",                            {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_zcsc2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_ccsc2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsc2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_scsc2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_zcsr2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_ccsr2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsr2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_scsr2dense",                               {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_zdense2csc",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_cdense2csc",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_ddense2csc",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_sdense2csc",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_dense2csr_by_percentage",           {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_dense2csr_by_percentage",           {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_dense2csr_nnz_by_percentage",       {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_dense2csr_nnz_by_percentage",       {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_dense2csr_by_percentage_buffer_size", {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_dense2csr_by_percentage_buffer_size", {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_dense2csr",                         {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_dense2csr",                         {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_dense2csr_nnz",                     {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_dense2csr_nnz",                     {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dprune_dense2csr_buffer_size",             {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sprune_dense2csr_buffer_size",             {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_zdense2csr",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_cdense2csr",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_ddense2csr",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_sdense2csr",                               {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_znnz",                                     {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_cnnz",                                     {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_dnnz",                                     {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_snnz",                                     {HIP_3020, HIP_0,    HIP_0   }},
  {"rocsparse_zgpsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_cgpsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_dgpsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_sgpsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_zgpsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_cgpsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_dgpsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_sgpsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_interleaved_batch",                  {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_interleaved_batch_buffer_size",      {HIP_5010, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_no_pivot_strided_batch",             {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_no_pivot_strided_batch",             {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_no_pivot_strided_batch",             {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_no_pivot_strided_batch",             {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_no_pivot_strided_batch_buffer_size", {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_no_pivot_strided_batch_buffer_size", {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_no_pivot_strided_batch_buffer_size", {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_no_pivot_strided_batch_buffer_size", {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_no_pivot",                           {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_no_pivot",                           {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_no_pivot",                           {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_no_pivot",                           {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_no_pivot_buffer_size",               {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_no_pivot_buffer_size",               {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_no_pivot_buffer_size",               {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_no_pivot_buffer_size",               {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv",                                    {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_zgtsv_buffer_size",                        {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_cgtsv_buffer_size",                        {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_dgtsv_buffer_size",                        {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_sgtsv_buffer_size",                        {HIP_4030, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrilu0",                                 {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_ccsrilu0",                                 {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrilu0",                                 {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_scsrilu0",                                 {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrilu0_analysis",                        {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_ccsrilu0_analysis",                        {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrilu0_analysis",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_scsrilu0_analysis",                        {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrilu0_buffer_size",                     {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_ccsrilu0_buffer_size",                     {HIP_2100, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrilu0_buffer_size",                     {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_scsrilu0_buffer_size",                     {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrilu0_numeric_boost",                   {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dccsrilu0_numeric_boost",                  {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrilu0_numeric_boost",                   {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dscsrilu0_numeric_boost",                  {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_csrilu0_zero_pivot",                       {HIP_1090, HIP_0,    HIP_0   }},
  {"rocsparse_zcsric0",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_ccsric0",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_dcsric0",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_scsric0",                                  {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_zcsric0_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_ccsric0_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_dcsric0_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_scsric0_analysis",                         {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_zcsric0_buffer_size",                      {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_ccsric0_buffer_size",                      {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_dcsric0_buffer_size",                      {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_scsric0_buffer_size",                      {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_csric0_zero_pivot",                        {HIP_3010, HIP_0,    HIP_0   }},
  {"rocsparse_zbsrilu0",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_cbsrilu0",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dbsrilu0",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_sbsrilu0",                                 {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_bsrilu0_zero_pivot",                       {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_zbsrilu0_analysis",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_cbsrilu0_analysis",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_dbsrilu0_analysis",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_sbsrilu0_analysis",                        {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_dcbsrilu0_numeric_boost",                  {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_dsbsrilu0_numeric_boost",                  {HIP_4050, HIP_0,    HIP_0   }},
  {"rocsparse_zbsrilu0_numeric_boost",                   {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_dbsrilu0_numeric_boost",                   {HIP_3090, HIP_0,    HIP_0   }},
  {"rocsparse_zbsric0",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_cbsric0",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_dbsric0",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_sbsric0",                                  {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_zbsric0_analysis",                         {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_cbsric0_analysis",                         {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_dbsric0_analysis",                         {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_sbsric0_analysis",                         {HIP_3060, HIP_0,    HIP_0   }},
  {"rocsparse_zbsric0_buffer_size",                      {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_cbsric0_buffer_size",                      {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_dbsric0_buffer_size",                      {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_sbsric0_buffer_size",                      {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_bsric0_zero_pivot",                        {HIP_3080, HIP_0,    HIP_0   }},
  {"rocsparse_csrgemm_nnz",                              {HIP_2080, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrgemm_buffer_size",                     {HIP_2080, HIP_0,    HIP_0   }},
  {"rocsparse_ccsrgemm_buffer_size",                     {HIP_2080, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrgemm_buffer_size",                     {HIP_2080, HIP_0,    HIP_0   }},
  {"rocsparse_scsrgemm_buffer_size",                     {HIP_2080, HIP_0,    HIP_0   }},
  {"rocsparse_zcsrgeam",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_ccsrgeam",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_dcsrgeam",                                 {HIP_3050, HIP_0,    HIP_0   }},
  {"rocsparse_scsrgeam",                                 {HIP_3050, HIP_0,    HIP_0   }},
};

const std::map<llvm::StringRef, cudaAPIChangedVersions> CUDA_SPARSE_FUNCTION_CHANGED_VER_MAP {
  {"cusparseSpVecGetIndexBase",                          {CUDA_120}},
  {"cusparseDestroySpVec",                               {CUDA_120}},
  {"cusparseDestroyDnVec",                               {CUDA_120}},
  {"cusparseSpMatGetAttribute",                          {CUDA_120}},
  {"cusparseSpMatGetFormat",                             {CUDA_120}},
  {"cusparseSpMatGetSize",                               {CUDA_120}},
  {"cusparseSpMatGetIndexBase",                          {CUDA_120}},
  {"cusparseSpMatGetStridedBatch",                       {CUDA_120}},
  {"cusparseDestroySpMat",                               {CUDA_120}},
  {"cusparseSpGEMM_compute",                             {CUDA_120}},
  {"cusparseSpGEMM_copy",                                {CUDA_120}},
  {"cusparseSpGEMM_workEstimation",                      {CUDA_120}},
  {"cusparseSpGEMMreuse_compute",                        {CUDA_120}},
  {"cusparseSpGEMMreuse_copy",                           {CUDA_120}},
  {"cusparseSpGEMMreuse_nnz",                            {CUDA_120}},
  {"cusparseSpGEMMreuse_workEstimation",                 {CUDA_120}},
  {"cusparseDnMatGetStridedBatch",                       {CUDA_120}},
  {"cusparseDestroyDnMat",                               {CUDA_120}},
  {"cusparseSpMM",                                       {CUDA_120}},
  {"cusparseSpMM_bufferSize",                            {CUDA_120}},
  {"cusparseSpMM_preprocess",                            {CUDA_120}},
  {"cusparseSpMV",                                       {CUDA_120}},
  {"cusparseSpMV_bufferSize",                            {CUDA_120}},
  {"cusparseSpSM_analysis",                              {CUDA_120}},
  {"cusparseSpSM_bufferSize",                            {CUDA_120}},
  {"cusparseSpSM_solve",                                 {CUDA_120}},
  {"cusparseSpSV_analysis",                              {CUDA_120}},
  {"cusparseSpSV_bufferSize",                            {CUDA_120}},
  {"cusparseSpSV_solve",                                 {CUDA_120}},
  {"cusparseSpVV",                                       {CUDA_120}},
  {"cusparseSpVV_bufferSize",                            {CUDA_120}},
  {"cusparseSDDMM",                                      {CUDA_120}},
  {"cusparseSDDMM_bufferSize",                           {CUDA_120}},
  {"cusparseSDDMM_preprocess",                           {CUDA_120}},
  {"cusparseAxpby",                                      {CUDA_120}},
  {"cusparseGather",                                     {CUDA_120}},
  {"cusparseScatter",                                    {CUDA_120}},
  {"cusparseSparseToDense",                              {CUDA_120}},
  {"cusparseSparseToDense_bufferSize",                   {CUDA_120}},
  {"cusparseDenseToSparse_analysis",                     {CUDA_120}},
  {"cusparseDenseToSparse_bufferSize",                   {CUDA_120}},
  {"cusparseDenseToSparse_convert",                      {CUDA_120}},
};

const std::map<llvm::StringRef, hipAPIChangedVersions> HIP_SPARSE_FUNCTION_CHANGED_VER_MAP {
  {"hipsparseSpVecGetIndexBase",                         {HIP_6000}},
  {"hipsparseDestroySpVec",                              {HIP_6000}},
  {"hipsparseDestroyDnVec",                              {HIP_6000}},
  {"hipsparseSpMatGetAttribute",                         {HIP_6000}},
  {"hipsparseSpMatGetFormat",                            {HIP_6000}},
  {"hipsparseSpMatGetSize",                              {HIP_6000}},
  {"hipsparseSpMatGetIndexBase",                         {HIP_6000}},
  {"hipsparseSpMatGetStridedBatch",                      {HIP_6000}},
  {"hipsparseDestroySpMat",                              {HIP_6000}},
  {"hipsparseSpGEMM_compute",                            {HIP_6000}},
  {"hipsparseSpGEMM_copy",                               {HIP_6000}},
  {"hipsparseSpGEMM_workEstimation",                     {HIP_6000}},
  {"hipsparseSpGEMMreuse_compute",                       {HIP_6000}},
  {"hipsparseSpGEMMreuse_copy",                          {HIP_6000}},
  {"hipsparseSpGEMMreuse_nnz",                           {HIP_6000}},
  {"hipsparseSpGEMMreuse_workEstimation",                {HIP_6000}},
  {"hipsparseDnMatGetStridedBatch",                      {HIP_6000}},
  {"hipsparseDestroyDnMat",                              {HIP_6000}},
  {"hipsparseSpMM",                                      {HIP_6000}},
  {"hipsparseSpMM_bufferSize",                           {HIP_6000}},
  {"hipsparseSpMM_preprocess",                           {HIP_6000}},
  {"hipsparseSpMV",                                      {HIP_6000}},
  {"hipsparseSpMV_bufferSize",                           {HIP_6000}},
  {"hipsparseSpSM_analysis",                             {HIP_6000}},
  {"hipsparseSpSM_bufferSize",                           {HIP_6000}},
  {"hipsparseSpSM_solve",                                {HIP_6000}},
  {"hipsparseSpSV_analysis",                             {HIP_6000}},
  {"hipsparseSpSV_bufferSize",                           {HIP_6000}},
  {"hipsparseSpSV_solve",                                {HIP_6000}},
  {"hipsparseSpVV",                                      {HIP_6000}},
  {"hipsparseSpVV_bufferSize",                           {HIP_6000}},
  {"hipsparseSDDMM",                                     {HIP_6000}},
  {"hipsparseSDDMM_bufferSize",                          {HIP_6000}},
  {"hipsparseSDDMM_preprocess",                          {HIP_6000}},
  {"hipsparseAxpby",                                     {HIP_6000}},
  {"hipsparseGather",                                    {HIP_6000}},
  {"hipsparseScatter",                                   {HIP_6000}},
  {"hipsparseSparseToDense",                             {HIP_6000}},
  {"hipsparseSparseToDense_bufferSize",                  {HIP_6000}},
  {"hipsparseDenseToSparse_analysis",                    {HIP_6000}},
  {"hipsparseDenseToSparse_bufferSize",                  {HIP_6000}},
  {"hipsparseDenseToSparse_convert",                     {HIP_6000}},
};

const std::map<unsigned int, llvm::StringRef> CUDA_SPARSE_API_SECTION_MAP {
  {4, "CUSPARSE Types References"},
  {5, "CUSPARSE Management Function Reference"},
  {6, "CUSPARSE Logging"},
  {7, "CUSPARSE Helper Function Reference"},
  {8, "CUSPARSE Level 1 Function Reference"},
  {9, "CUSPARSE Level 2 Function Reference"},
  {10, "CUSPARSE Level 3 Function Reference"},
  {11, "CUSPARSE Extra Function Reference"},
  {12, "CUSPARSE Preconditioners Reference"},
  {13, "CUSPARSE Reorderings Reference"},
  {14, "CUSPARSE Format Conversion Reference"},
  {15, "CUSPARSE Generic API Reference"},
};
