{-# LANGUAGE PatternSynonyms #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.NV.PathRenderingCompatibility
-- Copyright   :  (c) Sven Panne 2017
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Graphics.GL.NV.PathRenderingCompatibility (
  -- * Extension Support
  glGetNVPathRendering,
  gl_NV_path_rendering,
  -- * Enums
  pattern GL_2_BYTES_NV,
  pattern GL_3_BYTES_NV,
  pattern GL_4_BYTES_NV,
  pattern GL_ACCUM_ADJACENT_PAIRS_NV,
  pattern GL_ADJACENT_PAIRS_NV,
  pattern GL_AFFINE_2D_NV,
  pattern GL_AFFINE_3D_NV,
  pattern GL_ARC_TO_NV,
  pattern GL_BEVEL_NV,
  pattern GL_BOLD_BIT_NV,
  pattern GL_BOUNDING_BOX_NV,
  pattern GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV,
  pattern GL_CIRCULAR_CCW_ARC_TO_NV,
  pattern GL_CIRCULAR_CW_ARC_TO_NV,
  pattern GL_CIRCULAR_TANGENT_ARC_TO_NV,
  pattern GL_CLOSE_PATH_NV,
  pattern GL_CONIC_CURVE_TO_NV,
  pattern GL_CONSTANT_NV,
  pattern GL_CONVEX_HULL_NV,
  pattern GL_COUNT_DOWN_NV,
  pattern GL_COUNT_UP_NV,
  pattern GL_CUBIC_CURVE_TO_NV,
  pattern GL_DUP_FIRST_CUBIC_CURVE_TO_NV,
  pattern GL_DUP_LAST_CUBIC_CURVE_TO_NV,
  pattern GL_EYE_LINEAR_NV,
  pattern GL_FILE_NAME_NV,
  pattern GL_FIRST_TO_REST_NV,
  pattern GL_FONT_ASCENDER_BIT_NV,
  pattern GL_FONT_DESCENDER_BIT_NV,
  pattern GL_FONT_GLYPHS_AVAILABLE_NV,
  pattern GL_FONT_HAS_KERNING_BIT_NV,
  pattern GL_FONT_HEIGHT_BIT_NV,
  pattern GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV,
  pattern GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV,
  pattern GL_FONT_NUM_GLYPH_INDICES_BIT_NV,
  pattern GL_FONT_TARGET_UNAVAILABLE_NV,
  pattern GL_FONT_UNAVAILABLE_NV,
  pattern GL_FONT_UNDERLINE_POSITION_BIT_NV,
  pattern GL_FONT_UNDERLINE_THICKNESS_BIT_NV,
  pattern GL_FONT_UNINTELLIGIBLE_NV,
  pattern GL_FONT_UNITS_PER_EM_BIT_NV,
  pattern GL_FONT_X_MAX_BOUNDS_BIT_NV,
  pattern GL_FONT_X_MIN_BOUNDS_BIT_NV,
  pattern GL_FONT_Y_MAX_BOUNDS_BIT_NV,
  pattern GL_FONT_Y_MIN_BOUNDS_BIT_NV,
  pattern GL_FRAGMENT_INPUT_NV,
  pattern GL_GLYPH_HAS_KERNING_BIT_NV,
  pattern GL_GLYPH_HEIGHT_BIT_NV,
  pattern GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV,
  pattern GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV,
  pattern GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV,
  pattern GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV,
  pattern GL_GLYPH_VERTICAL_BEARING_X_BIT_NV,
  pattern GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV,
  pattern GL_GLYPH_WIDTH_BIT_NV,
  pattern GL_HORIZONTAL_LINE_TO_NV,
  pattern GL_ITALIC_BIT_NV,
  pattern GL_LARGE_CCW_ARC_TO_NV,
  pattern GL_LARGE_CW_ARC_TO_NV,
  pattern GL_LINE_TO_NV,
  pattern GL_MITER_REVERT_NV,
  pattern GL_MITER_TRUNCATE_NV,
  pattern GL_MOVE_TO_CONTINUES_NV,
  pattern GL_MOVE_TO_NV,
  pattern GL_MOVE_TO_RESETS_NV,
  pattern GL_OBJECT_LINEAR_NV,
  pattern GL_PATH_CLIENT_LENGTH_NV,
  pattern GL_PATH_COMMAND_COUNT_NV,
  pattern GL_PATH_COMPUTED_LENGTH_NV,
  pattern GL_PATH_COORD_COUNT_NV,
  pattern GL_PATH_COVER_DEPTH_FUNC_NV,
  pattern GL_PATH_DASH_ARRAY_COUNT_NV,
  pattern GL_PATH_DASH_CAPS_NV,
  pattern GL_PATH_DASH_OFFSET_NV,
  pattern GL_PATH_DASH_OFFSET_RESET_NV,
  pattern GL_PATH_END_CAPS_NV,
  pattern GL_PATH_ERROR_POSITION_NV,
  pattern GL_PATH_FILL_BOUNDING_BOX_NV,
  pattern GL_PATH_FILL_COVER_MODE_NV,
  pattern GL_PATH_FILL_MASK_NV,
  pattern GL_PATH_FILL_MODE_NV,
  pattern GL_PATH_FOG_GEN_MODE_NV,
  pattern GL_PATH_FORMAT_PS_NV,
  pattern GL_PATH_FORMAT_SVG_NV,
  pattern GL_PATH_GEN_COEFF_NV,
  pattern GL_PATH_GEN_COLOR_FORMAT_NV,
  pattern GL_PATH_GEN_COMPONENTS_NV,
  pattern GL_PATH_GEN_MODE_NV,
  pattern GL_PATH_INITIAL_DASH_CAP_NV,
  pattern GL_PATH_INITIAL_END_CAP_NV,
  pattern GL_PATH_JOIN_STYLE_NV,
  pattern GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV,
  pattern GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV,
  pattern GL_PATH_MITER_LIMIT_NV,
  pattern GL_PATH_MODELVIEW_MATRIX_NV,
  pattern GL_PATH_MODELVIEW_NV,
  pattern GL_PATH_MODELVIEW_STACK_DEPTH_NV,
  pattern GL_PATH_OBJECT_BOUNDING_BOX_NV,
  pattern GL_PATH_PROJECTION_MATRIX_NV,
  pattern GL_PATH_PROJECTION_NV,
  pattern GL_PATH_PROJECTION_STACK_DEPTH_NV,
  pattern GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV,
  pattern GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV,
  pattern GL_PATH_STENCIL_FUNC_NV,
  pattern GL_PATH_STENCIL_REF_NV,
  pattern GL_PATH_STENCIL_VALUE_MASK_NV,
  pattern GL_PATH_STROKE_BOUNDING_BOX_NV,
  pattern GL_PATH_STROKE_COVER_MODE_NV,
  pattern GL_PATH_STROKE_MASK_NV,
  pattern GL_PATH_STROKE_WIDTH_NV,
  pattern GL_PATH_TERMINAL_DASH_CAP_NV,
  pattern GL_PATH_TERMINAL_END_CAP_NV,
  pattern GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV,
  pattern GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV,
  pattern GL_PRIMARY_COLOR,
  pattern GL_PRIMARY_COLOR_NV,
  pattern GL_QUADRATIC_CURVE_TO_NV,
  pattern GL_RECT_NV,
  pattern GL_RELATIVE_ARC_TO_NV,
  pattern GL_RELATIVE_CONIC_CURVE_TO_NV,
  pattern GL_RELATIVE_CUBIC_CURVE_TO_NV,
  pattern GL_RELATIVE_HORIZONTAL_LINE_TO_NV,
  pattern GL_RELATIVE_LARGE_CCW_ARC_TO_NV,
  pattern GL_RELATIVE_LARGE_CW_ARC_TO_NV,
  pattern GL_RELATIVE_LINE_TO_NV,
  pattern GL_RELATIVE_MOVE_TO_NV,
  pattern GL_RELATIVE_QUADRATIC_CURVE_TO_NV,
  pattern GL_RELATIVE_RECT_NV,
  pattern GL_RELATIVE_ROUNDED_RECT2_NV,
  pattern GL_RELATIVE_ROUNDED_RECT4_NV,
  pattern GL_RELATIVE_ROUNDED_RECT8_NV,
  pattern GL_RELATIVE_ROUNDED_RECT_NV,
  pattern GL_RELATIVE_SMALL_CCW_ARC_TO_NV,
  pattern GL_RELATIVE_SMALL_CW_ARC_TO_NV,
  pattern GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV,
  pattern GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV,
  pattern GL_RELATIVE_VERTICAL_LINE_TO_NV,
  pattern GL_RESTART_PATH_NV,
  pattern GL_ROUNDED_RECT2_NV,
  pattern GL_ROUNDED_RECT4_NV,
  pattern GL_ROUNDED_RECT8_NV,
  pattern GL_ROUNDED_RECT_NV,
  pattern GL_ROUND_NV,
  pattern GL_SECONDARY_COLOR_NV,
  pattern GL_SKIP_MISSING_GLYPH_NV,
  pattern GL_SMALL_CCW_ARC_TO_NV,
  pattern GL_SMALL_CW_ARC_TO_NV,
  pattern GL_SMOOTH_CUBIC_CURVE_TO_NV,
  pattern GL_SMOOTH_QUADRATIC_CURVE_TO_NV,
  pattern GL_SQUARE_NV,
  pattern GL_STANDARD_FONT_FORMAT_NV,
  pattern GL_STANDARD_FONT_NAME_NV,
  pattern GL_SYSTEM_FONT_NAME_NV,
  pattern GL_TRANSLATE_2D_NV,
  pattern GL_TRANSLATE_3D_NV,
  pattern GL_TRANSLATE_X_NV,
  pattern GL_TRANSLATE_Y_NV,
  pattern GL_TRANSPOSE_AFFINE_2D_NV,
  pattern GL_TRANSPOSE_AFFINE_3D_NV,
  pattern GL_TRIANGULAR_NV,
  pattern GL_USE_MISSING_GLYPH_NV,
  pattern GL_UTF16_NV,
  pattern GL_UTF8_NV,
  pattern GL_VERTICAL_LINE_TO_NV,
  -- * Functions
  glCopyPathNV,
  glCoverFillPathInstancedNV,
  glCoverFillPathNV,
  glCoverStrokePathInstancedNV,
  glCoverStrokePathNV,
  glDeletePathsNV,
  glGenPathsNV,
  glGetPathColorGenfvNV,
  glGetPathColorGenivNV,
  glGetPathCommandsNV,
  glGetPathCoordsNV,
  glGetPathDashArrayNV,
  glGetPathLengthNV,
  glGetPathMetricRangeNV,
  glGetPathMetricsNV,
  glGetPathParameterfvNV,
  glGetPathParameterivNV,
  glGetPathSpacingNV,
  glGetPathTexGenfvNV,
  glGetPathTexGenivNV,
  glGetProgramResourcefvNV,
  glInterpolatePathsNV,
  glIsPathNV,
  glIsPointInFillPathNV,
  glIsPointInStrokePathNV,
  glMatrixFrustumEXT,
  glMatrixLoad3x2fNV,
  glMatrixLoad3x3fNV,
  glMatrixLoadIdentityEXT,
  glMatrixLoadTranspose3x3fNV,
  glMatrixLoadTransposedEXT,
  glMatrixLoadTransposefEXT,
  glMatrixLoaddEXT,
  glMatrixLoadfEXT,
  glMatrixMult3x2fNV,
  glMatrixMult3x3fNV,
  glMatrixMultTranspose3x3fNV,
  glMatrixMultTransposedEXT,
  glMatrixMultTransposefEXT,
  glMatrixMultdEXT,
  glMatrixMultfEXT,
  glMatrixOrthoEXT,
  glMatrixPopEXT,
  glMatrixPushEXT,
  glMatrixRotatedEXT,
  glMatrixRotatefEXT,
  glMatrixScaledEXT,
  glMatrixScalefEXT,
  glMatrixTranslatedEXT,
  glMatrixTranslatefEXT,
  glPathColorGenNV,
  glPathCommandsNV,
  glPathCoordsNV,
  glPathCoverDepthFuncNV,
  glPathDashArrayNV,
  glPathFogGenNV,
  glPathGlyphIndexArrayNV,
  glPathGlyphIndexRangeNV,
  glPathGlyphRangeNV,
  glPathGlyphsNV,
  glPathMemoryGlyphIndexArrayNV,
  glPathParameterfNV,
  glPathParameterfvNV,
  glPathParameteriNV,
  glPathParameterivNV,
  glPathStencilDepthOffsetNV,
  glPathStencilFuncNV,
  glPathStringNV,
  glPathSubCommandsNV,
  glPathSubCoordsNV,
  glPathTexGenNV,
  glPointAlongPathNV,
  glProgramPathFragmentInputGenNV,
  glStencilFillPathInstancedNV,
  glStencilFillPathNV,
  glStencilStrokePathInstancedNV,
  glStencilStrokePathNV,
  glStencilThenCoverFillPathInstancedNV,
  glStencilThenCoverFillPathNV,
  glStencilThenCoverStrokePathInstancedNV,
  glStencilThenCoverStrokePathNV,
  glTransformPathNV,
  glWeightPathsNV
) where

import Graphics.GL.ExtensionPredicates
import Graphics.GL.Tokens
import Graphics.GL.Functions
