//
// C++ Implementation: rename
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "namepartbase.h"
// #include "settings.h"

#include <klocale.h>
#include <QtGui/QDialog>
#include <QResizeEvent>


// gWen::gWen(QDialog *)
namePart::namePart(QDialog* )
	:QDialog()
{
//      ui_gwenrename.setupUi(this);
	ui_namepartbase.setupUi(this);
	
	
// 	setCaption(caption()+" - GwenRename");
	setWindowTitle(windowTitle()+" - GwenRename");
	updateLabel(startInt->value(),lengthInt->value());
	setMaximumSize(width(), height());
	setMinimumSize(width(), height());
	
	
	
	// signals and slots connections
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( buttonOkClicked() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( startInt, SIGNAL( valueChanged(int) ), this, SLOT( startCH(int) ) );
	connect( lengthInt, SIGNAL( valueChanged(int) ), this, SLOT( lengthCH(int) ) );
	connect( nameList, SIGNAL( activated(int) ), this, SLOT( fileChanged(int) ) );
}

namePart::~namePart(){

}

void namePart::resizeEvent( QResizeEvent * e ){
	setMaximumSize(width(), height());
	setMinimumSize(width(), height());
	e->ignore();
}

void namePart::startCH( int st ){
	updateLabel(st, lengthInt->value());
}


void namePart::lengthCH( int l ){
	updateLabel(startInt->value(),l);
}

void namePart::fileChanged( int id ){
	updateLabel(startInt->value(),lengthInt->value());
}


void namePart::updateLabel( int start, int length ){
	QString n1=QString::null;
	QString n2=QString::null;
	n=nameList->currentText().mid(start-1,length);
	if(start>1)
		n1=nameList->currentText().left(start-1);
//	qWarning("----");
//qWarning("n1 = %s",n1.toLocal8Bit().constData());
//qWarning("n = %s",n.toLocal8Bit().constData());
	n2=nameList->currentText().mid(start+length-1,255);
//qWarning("n2 = %s",n2.latin1());
	lblSample->setText(n1+"<b><font color=\"Black\">"+n+"</font></b>"+n2);
}

void namePart::buttonOkClicked(){
	if(chkFixed->isChecked()){
		outPattern=":S"+n+":";
	}else{
		outPattern=QString(":P%1,%2:").arg(startInt->value()).arg(lengthInt->value());
	}
//qWarning("## outPattern = %s",outPattern.toLocal8Bit().constData());
	QDialog::accept();
}

#include "namepartbase.moc"