/***************************************************************************
                          game.h  -  description
                             -------------------
    begin                : Mon Jan 21 2002
    copyright            : (C) 2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAME_H
#define GAME_H
#include <gtk/gtk.h>
#include <vector>
#include "ball.h"
#include "check_pocket.h"
#include "move_balls.h"
#include "moving.h"

/**
  *@author Brian Ashe
  */

class check_pocket;

enum turns { tplayer1, tplayer2 };				// Tell whose turn it is on
enum catagories { stripes, solids, other };				// What are they shooting at
enum player_types { human, computer, remote };	// What type of player (future use)
enum game_types { eight_ball, nine_ball, rotation, snooker, continuous14_1, no_rules };

struct player {
	char player_name [30];		// Player's name
	int category;				// Stripes or solids
	std::vector<int> sunkballs;	// What they sunk
	int ptype;					// Type of player
	int score;					// Players score
};
		
class Game {
public:
	player player_1;		// Player 1
	player player_2;		// Player 2
	bool cat_is_set;		// OK, the categories have been set
	char comment [100];	// Place a message in here to display
	int turn;			// Whose turn is it
	int winner;			// Who is the winner
	bool shot;			// A shot is active
	bool do_switch;		// OK to switch turns
	bool do_foul;		// Oops, you fouled
	bool scratched;		// Oops, you scratched
	bool hit_wrong_ball;	// Oops, you hit the wrong ball
	bool first_ball_hit;	// You have hit a ball
	bool first_ball_sunk;	// Sunk the right ball first
	
	Game();
	~Game();
	void set_category(check_pocket &cp); // Set who is stripes and who is solids
	void eight_ball_rules(check_pocket &cp, Ball *bnc); // Checks to see what happened in the shot
	void nine_ball_rules(check_pocket &cp, Ball *bnc); // Checks to see what happened in the shot
	void rotation_rules(check_pocket &cp, Ball *bnc); // Checks to see what happened in the shot
	bool switch_turns(int game);	// Determines if it should switch and who is next
	void new_shot();		// Reset for a new shot
	bool shot_over(std::vector<Ball> &balls);	// Return true if all balls have stopped moving
//	bool game_over();	// Determines if game is over
//	int is_winner();		// Determines who is the winner
	
};

#endif
