/*
 * Copyright 2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.plugins.ide.eclipse.internal

import org.gradle.plugins.ide.eclipse.model.Link
import org.gradle.plugins.ide.eclipse.model.internal.SourceFoldersCreator
import org.gradle.api.Project

/**
 * @author: Szczepan Faber, created at: 4/22/11
 */
class LinkedResourcesCreator {

    Set<Link> links(Project project) {
        def folders = new SourceFoldersCreator().getExternalSourceFolders(project.sourceSets, {project.relativePath(it)} )
        folders.collect {
            new Link(it.name, '2', it.absolutePath, null)
        } as Set
    }
}
