// +build go1.6
// +build use_codec
// +build !easyjson_nounsafe
// +build !appengine

// Code generated by codecgen - DO NOT EDIT.

package benchmark

import (
	"errors"
	codec1978 "github.com/ugorji/go/codec"
	"runtime"
	"strconv"
)

const (
	// ----- content types ----
	codecSelferCcUTF82736 = 1
	codecSelferCcRAW2736  = 255
	// ----- value types used ----
	codecSelferValueTypeArray2736     = 10
	codecSelferValueTypeMap2736       = 9
	codecSelferValueTypeString2736    = 6
	codecSelferValueTypeInt2736       = 2
	codecSelferValueTypeUint2736      = 3
	codecSelferValueTypeFloat2736     = 4
	codecSelferValueTypeNil2736       = 1
	codecSelferBitsize2736            = uint8(32 << (^uint(0) >> 63))
	codecSelferDecContainerLenNil2736 = -2147483648
)

var (
	errCodecSelferOnlyMapOrArrayEncodeToStruct2736 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer2736 struct{}

func codecSelfer2736False() bool { return false }

func init() {
	if codec1978.GenVersion != 16 {
		_, file, _, _ := runtime.Caller(0)
		ver := strconv.FormatInt(int64(codec1978.GenVersion), 10)
		panic("codecgen version mismatch: current: 16, need " + ver + ". Re-generate file: " + file)
	}
}

func (x *SearchMetadata) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(9)
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.CompletedIn))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.Count))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.MaxID))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.MaxIDStr))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.NextResults))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Query))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.RefreshURL))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.SinceID))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.SinceIDStr))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(9)
			z.EncWriteMapElemKey()
			r.EncodeString(`completed_in`)
			z.EncWriteMapElemValue()
			r.EncodeFloat64(float64(x.CompletedIn))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"count\"")
			} else {
				r.EncodeString(`count`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.Count))
			z.EncWriteMapElemKey()
			r.EncodeString(`max_id`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.MaxID))
			z.EncWriteMapElemKey()
			r.EncodeString(`max_id_str`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.MaxIDStr))
			z.EncWriteMapElemKey()
			r.EncodeString(`next_results`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.NextResults))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"query\"")
			} else {
				r.EncodeString(`query`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Query))
			z.EncWriteMapElemKey()
			r.EncodeString(`refresh_url`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.RefreshURL))
			z.EncWriteMapElemKey()
			r.EncodeString(`since_id`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.SinceID))
			z.EncWriteMapElemKey()
			r.EncodeString(`since_id_str`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.SinceIDStr))
			z.EncWriteMapEnd()
		}
	}
}

func (x *SearchMetadata) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = SearchMetadata{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *SearchMetadata) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "completed_in":
			x.CompletedIn = (float64)(r.DecodeFloat64())
		case "count":
			x.Count = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "max_id":
			x.MaxID = (int64)(r.DecodeInt64())
		case "max_id_str":
			x.MaxIDStr = (string)(string(r.DecodeStringAsBytes()))
		case "next_results":
			x.NextResults = (string)(string(r.DecodeStringAsBytes()))
		case "query":
			x.Query = (string)(string(r.DecodeStringAsBytes()))
		case "refresh_url":
			x.RefreshURL = (string)(string(r.DecodeStringAsBytes()))
		case "since_id":
			x.SinceID = (int64)(r.DecodeInt64())
		case "since_id_str":
			x.SinceIDStr = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *SearchMetadata) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.CompletedIn = (float64)(r.DecodeFloat64())
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Count = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.MaxID = (int64)(r.DecodeInt64())
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.MaxIDStr = (string)(string(r.DecodeStringAsBytes()))
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.NextResults = (string)(string(r.DecodeStringAsBytes()))
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Query = (string)(string(r.DecodeStringAsBytes()))
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.RefreshURL = (string)(string(r.DecodeStringAsBytes()))
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.SinceID = (int64)(r.DecodeInt64())
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = z.DecCheckBreak()
	}
	if yyb13 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.SinceIDStr = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = z.DecCheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj13-1, "")
	}
}

func (x *Hashtag) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			if x.Indices == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntV(x.Indices, e)
			} // end block: if x.Indices slice == nil
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Text))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"indices\"")
			} else {
				r.EncodeString(`indices`)
			}
			z.EncWriteMapElemValue()
			if x.Indices == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntV(x.Indices, e)
			} // end block: if x.Indices slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"text\"")
			} else {
				r.EncodeString(`text`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Text))
			z.EncWriteMapEnd()
		}
	}
}

func (x *Hashtag) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = Hashtag{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *Hashtag) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "indices":
			z.F.DecSliceIntX(&x.Indices, d)
		case "text":
			x.Text = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *Hashtag) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceIntX(&x.Indices, d)
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Text = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = z.DecCheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *Entities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(3)
			z.EncWriteArrayElem()
			if x.Hashtags == nil {
				r.EncodeNil()
			} else {
				h.encSliceHashtag(([]Hashtag)(x.Hashtags), e)
			} // end block: if x.Hashtags slice == nil
			z.EncWriteArrayElem()
			if x.Urls == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtostring(([]*string)(x.Urls), e)
			} // end block: if x.Urls slice == nil
			z.EncWriteArrayElem()
			if x.UserMentions == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtostring(([]*string)(x.UserMentions), e)
			} // end block: if x.UserMentions slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(3)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"hashtags\"")
			} else {
				r.EncodeString(`hashtags`)
			}
			z.EncWriteMapElemValue()
			if x.Hashtags == nil {
				r.EncodeNil()
			} else {
				h.encSliceHashtag(([]Hashtag)(x.Hashtags), e)
			} // end block: if x.Hashtags slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"urls\"")
			} else {
				r.EncodeString(`urls`)
			}
			z.EncWriteMapElemValue()
			if x.Urls == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtostring(([]*string)(x.Urls), e)
			} // end block: if x.Urls slice == nil
			z.EncWriteMapElemKey()
			r.EncodeString(`user_mentions`)
			z.EncWriteMapElemValue()
			if x.UserMentions == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtostring(([]*string)(x.UserMentions), e)
			} // end block: if x.UserMentions slice == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *Entities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = Entities{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *Entities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "hashtags":
			h.decSliceHashtag((*[]Hashtag)(&x.Hashtags), d)
		case "urls":
			h.decSlicePtrtostring((*[]*string)(&x.Urls), d)
		case "user_mentions":
			h.decSlicePtrtostring((*[]*string)(&x.UserMentions), d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *Entities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = z.DecCheckBreak()
	}
	if yyb10 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSliceHashtag((*[]Hashtag)(&x.Hashtags), d)
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = z.DecCheckBreak()
	}
	if yyb10 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtostring((*[]*string)(&x.Urls), d)
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = z.DecCheckBreak()
	}
	if yyb10 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtostring((*[]*string)(&x.UserMentions), d)
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = z.DecCheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj10-1, "")
	}
}

func (x *UserEntityDescription) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if x.Urls == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtostring(([]*string)(x.Urls), e)
			} // end block: if x.Urls slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"urls\"")
			} else {
				r.EncodeString(`urls`)
			}
			z.EncWriteMapElemValue()
			if x.Urls == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtostring(([]*string)(x.Urls), e)
			} // end block: if x.Urls slice == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *UserEntityDescription) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = UserEntityDescription{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *UserEntityDescription) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "urls":
			h.decSlicePtrtostring((*[]*string)(&x.Urls), d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *UserEntityDescription) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtostring((*[]*string)(&x.Urls), d)
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *URL) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn3 bool = x.ExpandedURL == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(3)
			if yyn3 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy6 := *x.ExpandedURL
				r.EncodeString(string(yy6))
			}
			z.EncWriteArrayElem()
			if x.Indices == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntV(x.Indices, e)
			} // end block: if x.Indices slice == nil
			z.EncWriteArrayElem()
			r.EncodeString(string(x.URL))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(3)
			z.EncWriteMapElemKey()
			r.EncodeString(`expanded_url`)
			z.EncWriteMapElemValue()
			if yyn3 {
				r.EncodeNil()
			} else {
				yy10 := *x.ExpandedURL
				r.EncodeString(string(yy10))
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"indices\"")
			} else {
				r.EncodeString(`indices`)
			}
			z.EncWriteMapElemValue()
			if x.Indices == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntV(x.Indices, e)
			} // end block: if x.Indices slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"url\"")
			} else {
				r.EncodeString(`url`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.URL))
			z.EncWriteMapEnd()
		}
	}
}

func (x *URL) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = URL{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *URL) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "expanded_url":
			if r.TryNil() {
				if x.ExpandedURL != nil { // remove the if-true
					x.ExpandedURL = nil
				}
			} else {
				if x.ExpandedURL == nil {
					x.ExpandedURL = new(string)
				}
				*x.ExpandedURL = (string)(string(r.DecodeStringAsBytes()))
			}
		case "indices":
			z.F.DecSliceIntX(&x.Indices, d)
		case "url":
			x.URL = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *URL) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj9 int
	var yyb9 bool
	var yyhl9 bool = l >= 0
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.ExpandedURL != nil { // remove the if-true
			x.ExpandedURL = nil
		}
	} else {
		if x.ExpandedURL == nil {
			x.ExpandedURL = new(string)
		}
		*x.ExpandedURL = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceIntX(&x.Indices, d)
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.URL = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj9++
		if yyhl9 {
			yyb9 = yyj9 > l
		} else {
			yyb9 = z.DecCheckBreak()
		}
		if yyb9 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj9-1, "")
	}
}

func (x *UserEntityURL) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if x.Urls == nil {
				r.EncodeNil()
			} else {
				h.encSliceURL(([]URL)(x.Urls), e)
			} // end block: if x.Urls slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"urls\"")
			} else {
				r.EncodeString(`urls`)
			}
			z.EncWriteMapElemValue()
			if x.Urls == nil {
				r.EncodeNil()
			} else {
				h.encSliceURL(([]URL)(x.Urls), e)
			} // end block: if x.Urls slice == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *UserEntityURL) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = UserEntityURL{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *UserEntityURL) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "urls":
			h.decSliceURL((*[]URL)(&x.Urls), d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *UserEntityURL) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSliceURL((*[]URL)(&x.Urls), d)
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *UserEntities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			yy5 := &x.Description
			yy5.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			yy7 := &x.URL
			yy7.CodecEncodeSelf(e)
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"description\"")
			} else {
				r.EncodeString(`description`)
			}
			z.EncWriteMapElemValue()
			yy9 := &x.Description
			yy9.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"url\"")
			} else {
				r.EncodeString(`url`)
			}
			z.EncWriteMapElemValue()
			yy11 := &x.URL
			yy11.CodecEncodeSelf(e)
			z.EncWriteMapEnd()
		}
	}
}

func (x *UserEntities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = UserEntities{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *UserEntities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "description":
			x.Description.CodecDecodeSelf(d)
		case "url":
			x.URL.CodecDecodeSelf(d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *UserEntities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Description.CodecDecodeSelf(d)
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.URL.CodecDecodeSelf(d)
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *User) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn10 bool = x.FollowRequestSent == nil
		var yyn12 bool = x.Following == nil
		var yyn22 bool = x.Notifications == nil
		var yyn39 bool = x.URL == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(39)
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.ContributorsEnabled))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.CreatedAt))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.DefaultProfile))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.DefaultProfileImage))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Description))
			z.EncWriteArrayElem()
			yy47 := &x.Entities
			yy47.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.FavouritesCount))
			if yyn10 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy50 := *x.FollowRequestSent
				r.EncodeString(string(yy50))
			}
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.FollowersCount))
			if yyn12 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy53 := *x.Following
				r.EncodeString(string(yy53))
			}
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.FriendsCount))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.GeoEnabled))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.ID))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.IDStr))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.IsTranslator))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Lang))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.ListedCount))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Location))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Name))
			if yyn22 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy64 := *x.Notifications
				r.EncodeString(string(yy64))
			}
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileBackgroundColor))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileBackgroundImageURL))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileBackgroundImageURLHTTPS))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.ProfileBackgroundTile))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileImageURL))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileImageURLHTTPS))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileLinkColor))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileSidebarBorderColor))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileSidebarFillColor))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ProfileTextColor))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.ProfileUseBackgroundImage))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.Protected))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ScreenName))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.ShowAllInlineMedia))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.StatusesCount))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.TimeZone))
			if yyn39 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy82 := *x.URL
				r.EncodeString(string(yy82))
			}
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.UtcOffset))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.Verified))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(39)
			z.EncWriteMapElemKey()
			r.EncodeString(`contributors_enabled`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.ContributorsEnabled))
			z.EncWriteMapElemKey()
			r.EncodeString(`created_at`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.CreatedAt))
			z.EncWriteMapElemKey()
			r.EncodeString(`default_profile`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.DefaultProfile))
			z.EncWriteMapElemKey()
			r.EncodeString(`default_profile_image`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.DefaultProfileImage))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"description\"")
			} else {
				r.EncodeString(`description`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Description))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"entities\"")
			} else {
				r.EncodeString(`entities`)
			}
			z.EncWriteMapElemValue()
			yy91 := &x.Entities
			yy91.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			r.EncodeString(`favourites_count`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.FavouritesCount))
			z.EncWriteMapElemKey()
			r.EncodeString(`follow_request_sent`)
			z.EncWriteMapElemValue()
			if yyn10 {
				r.EncodeNil()
			} else {
				yy94 := *x.FollowRequestSent
				r.EncodeString(string(yy94))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`followers_count`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.FollowersCount))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"following\"")
			} else {
				r.EncodeString(`following`)
			}
			z.EncWriteMapElemValue()
			if yyn12 {
				r.EncodeNil()
			} else {
				yy97 := *x.Following
				r.EncodeString(string(yy97))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`friends_count`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.FriendsCount))
			z.EncWriteMapElemKey()
			r.EncodeString(`geo_enabled`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.GeoEnabled))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"id\"")
			} else {
				r.EncodeString(`id`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.ID))
			z.EncWriteMapElemKey()
			r.EncodeString(`id_str`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.IDStr))
			z.EncWriteMapElemKey()
			r.EncodeString(`is_translator`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.IsTranslator))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"lang\"")
			} else {
				r.EncodeString(`lang`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Lang))
			z.EncWriteMapElemKey()
			r.EncodeString(`listed_count`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.ListedCount))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"location\"")
			} else {
				r.EncodeString(`location`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Location))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"name\"")
			} else {
				r.EncodeString(`name`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Name))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"notifications\"")
			} else {
				r.EncodeString(`notifications`)
			}
			z.EncWriteMapElemValue()
			if yyn22 {
				r.EncodeNil()
			} else {
				yy108 := *x.Notifications
				r.EncodeString(string(yy108))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_background_color`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileBackgroundColor))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_background_image_url`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileBackgroundImageURL))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_background_image_url_https`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileBackgroundImageURLHTTPS))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_background_tile`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.ProfileBackgroundTile))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_image_url`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileImageURL))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_image_url_https`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileImageURLHTTPS))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_link_color`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileLinkColor))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_sidebar_border_color`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileSidebarBorderColor))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_sidebar_fill_color`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileSidebarFillColor))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_text_color`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ProfileTextColor))
			z.EncWriteMapElemKey()
			r.EncodeString(`profile_use_background_image`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.ProfileUseBackgroundImage))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"protected\"")
			} else {
				r.EncodeString(`protected`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.Protected))
			z.EncWriteMapElemKey()
			r.EncodeString(`screen_name`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ScreenName))
			z.EncWriteMapElemKey()
			r.EncodeString(`show_all_inline_media`)
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.ShowAllInlineMedia))
			z.EncWriteMapElemKey()
			r.EncodeString(`statuses_count`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.StatusesCount))
			z.EncWriteMapElemKey()
			r.EncodeString(`time_zone`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.TimeZone))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"url\"")
			} else {
				r.EncodeString(`url`)
			}
			z.EncWriteMapElemValue()
			if yyn39 {
				r.EncodeNil()
			} else {
				yy126 := *x.URL
				r.EncodeString(string(yy126))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`utc_offset`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.UtcOffset))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"verified\"")
			} else {
				r.EncodeString(`verified`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.Verified))
			z.EncWriteMapEnd()
		}
	}
}

func (x *User) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = User{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *User) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "contributors_enabled":
			x.ContributorsEnabled = (bool)(r.DecodeBool())
		case "created_at":
			x.CreatedAt = (string)(string(r.DecodeStringAsBytes()))
		case "default_profile":
			x.DefaultProfile = (bool)(r.DecodeBool())
		case "default_profile_image":
			x.DefaultProfileImage = (bool)(r.DecodeBool())
		case "description":
			x.Description = (string)(string(r.DecodeStringAsBytes()))
		case "entities":
			x.Entities.CodecDecodeSelf(d)
		case "favourites_count":
			x.FavouritesCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "follow_request_sent":
			if r.TryNil() {
				if x.FollowRequestSent != nil { // remove the if-true
					x.FollowRequestSent = nil
				}
			} else {
				if x.FollowRequestSent == nil {
					x.FollowRequestSent = new(string)
				}
				*x.FollowRequestSent = (string)(string(r.DecodeStringAsBytes()))
			}
		case "followers_count":
			x.FollowersCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "following":
			if r.TryNil() {
				if x.Following != nil { // remove the if-true
					x.Following = nil
				}
			} else {
				if x.Following == nil {
					x.Following = new(string)
				}
				*x.Following = (string)(string(r.DecodeStringAsBytes()))
			}
		case "friends_count":
			x.FriendsCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "geo_enabled":
			x.GeoEnabled = (bool)(r.DecodeBool())
		case "id":
			x.ID = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "id_str":
			x.IDStr = (string)(string(r.DecodeStringAsBytes()))
		case "is_translator":
			x.IsTranslator = (bool)(r.DecodeBool())
		case "lang":
			x.Lang = (string)(string(r.DecodeStringAsBytes()))
		case "listed_count":
			x.ListedCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "location":
			x.Location = (string)(string(r.DecodeStringAsBytes()))
		case "name":
			x.Name = (string)(string(r.DecodeStringAsBytes()))
		case "notifications":
			if r.TryNil() {
				if x.Notifications != nil { // remove the if-true
					x.Notifications = nil
				}
			} else {
				if x.Notifications == nil {
					x.Notifications = new(string)
				}
				*x.Notifications = (string)(string(r.DecodeStringAsBytes()))
			}
		case "profile_background_color":
			x.ProfileBackgroundColor = (string)(string(r.DecodeStringAsBytes()))
		case "profile_background_image_url":
			x.ProfileBackgroundImageURL = (string)(string(r.DecodeStringAsBytes()))
		case "profile_background_image_url_https":
			x.ProfileBackgroundImageURLHTTPS = (string)(string(r.DecodeStringAsBytes()))
		case "profile_background_tile":
			x.ProfileBackgroundTile = (bool)(r.DecodeBool())
		case "profile_image_url":
			x.ProfileImageURL = (string)(string(r.DecodeStringAsBytes()))
		case "profile_image_url_https":
			x.ProfileImageURLHTTPS = (string)(string(r.DecodeStringAsBytes()))
		case "profile_link_color":
			x.ProfileLinkColor = (string)(string(r.DecodeStringAsBytes()))
		case "profile_sidebar_border_color":
			x.ProfileSidebarBorderColor = (string)(string(r.DecodeStringAsBytes()))
		case "profile_sidebar_fill_color":
			x.ProfileSidebarFillColor = (string)(string(r.DecodeStringAsBytes()))
		case "profile_text_color":
			x.ProfileTextColor = (string)(string(r.DecodeStringAsBytes()))
		case "profile_use_background_image":
			x.ProfileUseBackgroundImage = (bool)(r.DecodeBool())
		case "protected":
			x.Protected = (bool)(r.DecodeBool())
		case "screen_name":
			x.ScreenName = (string)(string(r.DecodeStringAsBytes()))
		case "show_all_inline_media":
			x.ShowAllInlineMedia = (bool)(r.DecodeBool())
		case "statuses_count":
			x.StatusesCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "time_zone":
			x.TimeZone = (string)(string(r.DecodeStringAsBytes()))
		case "url":
			if r.TryNil() {
				if x.URL != nil { // remove the if-true
					x.URL = nil
				}
			} else {
				if x.URL == nil {
					x.URL = new(string)
				}
				*x.URL = (string)(string(r.DecodeStringAsBytes()))
			}
		case "utc_offset":
			x.UtcOffset = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "verified":
			x.Verified = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *User) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj47 int
	var yyb47 bool
	var yyhl47 bool = l >= 0
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ContributorsEnabled = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.CreatedAt = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.DefaultProfile = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.DefaultProfileImage = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Description = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Entities.CodecDecodeSelf(d)
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.FavouritesCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.FollowRequestSent != nil { // remove the if-true
			x.FollowRequestSent = nil
		}
	} else {
		if x.FollowRequestSent == nil {
			x.FollowRequestSent = new(string)
		}
		*x.FollowRequestSent = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.FollowersCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Following != nil { // remove the if-true
			x.Following = nil
		}
	} else {
		if x.Following == nil {
			x.Following = new(string)
		}
		*x.Following = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.FriendsCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.GeoEnabled = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ID = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.IDStr = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.IsTranslator = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Lang = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ListedCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Location = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Name = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Notifications != nil { // remove the if-true
			x.Notifications = nil
		}
	} else {
		if x.Notifications == nil {
			x.Notifications = new(string)
		}
		*x.Notifications = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileBackgroundColor = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileBackgroundImageURL = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileBackgroundImageURLHTTPS = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileBackgroundTile = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileImageURL = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileImageURLHTTPS = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileLinkColor = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileSidebarBorderColor = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileSidebarFillColor = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileTextColor = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ProfileUseBackgroundImage = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Protected = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ScreenName = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ShowAllInlineMedia = (bool)(r.DecodeBool())
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.StatusesCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TimeZone = (string)(string(r.DecodeStringAsBytes()))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.URL != nil { // remove the if-true
			x.URL = nil
		}
	} else {
		if x.URL == nil {
			x.URL = new(string)
		}
		*x.URL = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.UtcOffset = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj47++
	if yyhl47 {
		yyb47 = yyj47 > l
	} else {
		yyb47 = z.DecCheckBreak()
	}
	if yyb47 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Verified = (bool)(r.DecodeBool())
	for {
		yyj47++
		if yyhl47 {
			yyb47 = yyj47 > l
		} else {
			yyb47 = z.DecCheckBreak()
		}
		if yyb47 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj47-1, "")
	}
}

func (x *StatusMetadata) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.IsoLanguageCode))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.ResultType))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			r.EncodeString(`iso_language_code`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.IsoLanguageCode))
			z.EncWriteMapElemKey()
			r.EncodeString(`result_type`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.ResultType))
			z.EncWriteMapEnd()
		}
	}
}

func (x *StatusMetadata) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = StatusMetadata{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *StatusMetadata) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "iso_language_code":
			x.IsoLanguageCode = (string)(string(r.DecodeStringAsBytes()))
		case "result_type":
			x.ResultType = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *StatusMetadata) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.IsoLanguageCode = (string)(string(r.DecodeStringAsBytes()))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ResultType = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *Status) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn3 bool = x.Contributors == nil
		var yyn4 bool = x.Coordinates == nil
		var yyn8 bool = x.Geo == nil
		var yyn11 bool = x.InReplyToScreenName == nil
		var yyn12 bool = x.InReplyToStatusID == nil
		var yyn13 bool = x.InReplyToStatusIDStr == nil
		var yyn14 bool = x.InReplyToUserID == nil
		var yyn15 bool = x.InReplyToUserIDStr == nil
		var yyn17 bool = x.Place == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(21)
			if yyn3 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy24 := *x.Contributors
				r.EncodeString(string(yy24))
			}
			if yyn4 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy26 := *x.Coordinates
				r.EncodeString(string(yy26))
			}
			z.EncWriteArrayElem()
			r.EncodeString(string(x.CreatedAt))
			z.EncWriteArrayElem()
			yy29 := &x.Entities
			yy29.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.Favorited))
			if yyn8 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy32 := *x.Geo
				r.EncodeString(string(yy32))
			}
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.ID))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.IDStr))
			if yyn11 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy36 := *x.InReplyToScreenName
				r.EncodeString(string(yy36))
			}
			if yyn12 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy38 := *x.InReplyToStatusID
				r.EncodeString(string(yy38))
			}
			if yyn13 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy40 := *x.InReplyToStatusIDStr
				r.EncodeString(string(yy40))
			}
			if yyn14 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy42 := *x.InReplyToUserID
				r.EncodeString(string(yy42))
			}
			if yyn15 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy44 := *x.InReplyToUserIDStr
				r.EncodeString(string(yy44))
			}
			z.EncWriteArrayElem()
			yy46 := &x.Metadata
			yy46.CodecEncodeSelf(e)
			if yyn17 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy48 := *x.Place
				r.EncodeString(string(yy48))
			}
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.RetweetCount))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.Retweeted))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Source))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Text))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.Truncated))
			z.EncWriteArrayElem()
			yy55 := &x.User
			yy55.CodecEncodeSelf(e)
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(21)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"contributors\"")
			} else {
				r.EncodeString(`contributors`)
			}
			z.EncWriteMapElemValue()
			if yyn3 {
				r.EncodeNil()
			} else {
				yy57 := *x.Contributors
				r.EncodeString(string(yy57))
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"coordinates\"")
			} else {
				r.EncodeString(`coordinates`)
			}
			z.EncWriteMapElemValue()
			if yyn4 {
				r.EncodeNil()
			} else {
				yy59 := *x.Coordinates
				r.EncodeString(string(yy59))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`created_at`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.CreatedAt))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"entities\"")
			} else {
				r.EncodeString(`entities`)
			}
			z.EncWriteMapElemValue()
			yy62 := &x.Entities
			yy62.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"favorited\"")
			} else {
				r.EncodeString(`favorited`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.Favorited))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"geo\"")
			} else {
				r.EncodeString(`geo`)
			}
			z.EncWriteMapElemValue()
			if yyn8 {
				r.EncodeNil()
			} else {
				yy65 := *x.Geo
				r.EncodeString(string(yy65))
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"id\"")
			} else {
				r.EncodeString(`id`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.ID))
			z.EncWriteMapElemKey()
			r.EncodeString(`id_str`)
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.IDStr))
			z.EncWriteMapElemKey()
			r.EncodeString(`in_reply_to_screen_name`)
			z.EncWriteMapElemValue()
			if yyn11 {
				r.EncodeNil()
			} else {
				yy69 := *x.InReplyToScreenName
				r.EncodeString(string(yy69))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`in_reply_to_status_id`)
			z.EncWriteMapElemValue()
			if yyn12 {
				r.EncodeNil()
			} else {
				yy71 := *x.InReplyToStatusID
				r.EncodeString(string(yy71))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`in_reply_to_status_id_str`)
			z.EncWriteMapElemValue()
			if yyn13 {
				r.EncodeNil()
			} else {
				yy73 := *x.InReplyToStatusIDStr
				r.EncodeString(string(yy73))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`in_reply_to_user_id`)
			z.EncWriteMapElemValue()
			if yyn14 {
				r.EncodeNil()
			} else {
				yy75 := *x.InReplyToUserID
				r.EncodeString(string(yy75))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`in_reply_to_user_id_str`)
			z.EncWriteMapElemValue()
			if yyn15 {
				r.EncodeNil()
			} else {
				yy77 := *x.InReplyToUserIDStr
				r.EncodeString(string(yy77))
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"metadata\"")
			} else {
				r.EncodeString(`metadata`)
			}
			z.EncWriteMapElemValue()
			yy79 := &x.Metadata
			yy79.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"place\"")
			} else {
				r.EncodeString(`place`)
			}
			z.EncWriteMapElemValue()
			if yyn17 {
				r.EncodeNil()
			} else {
				yy81 := *x.Place
				r.EncodeString(string(yy81))
			}
			z.EncWriteMapElemKey()
			r.EncodeString(`retweet_count`)
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.RetweetCount))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"retweeted\"")
			} else {
				r.EncodeString(`retweeted`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.Retweeted))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"source\"")
			} else {
				r.EncodeString(`source`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Source))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"text\"")
			} else {
				r.EncodeString(`text`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Text))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"truncated\"")
			} else {
				r.EncodeString(`truncated`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.Truncated))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"user\"")
			} else {
				r.EncodeString(`user`)
			}
			z.EncWriteMapElemValue()
			yy88 := &x.User
			yy88.CodecEncodeSelf(e)
			z.EncWriteMapEnd()
		}
	}
}

func (x *Status) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = Status{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *Status) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "contributors":
			if r.TryNil() {
				if x.Contributors != nil { // remove the if-true
					x.Contributors = nil
				}
			} else {
				if x.Contributors == nil {
					x.Contributors = new(string)
				}
				*x.Contributors = (string)(string(r.DecodeStringAsBytes()))
			}
		case "coordinates":
			if r.TryNil() {
				if x.Coordinates != nil { // remove the if-true
					x.Coordinates = nil
				}
			} else {
				if x.Coordinates == nil {
					x.Coordinates = new(string)
				}
				*x.Coordinates = (string)(string(r.DecodeStringAsBytes()))
			}
		case "created_at":
			x.CreatedAt = (string)(string(r.DecodeStringAsBytes()))
		case "entities":
			x.Entities.CodecDecodeSelf(d)
		case "favorited":
			x.Favorited = (bool)(r.DecodeBool())
		case "geo":
			if r.TryNil() {
				if x.Geo != nil { // remove the if-true
					x.Geo = nil
				}
			} else {
				if x.Geo == nil {
					x.Geo = new(string)
				}
				*x.Geo = (string)(string(r.DecodeStringAsBytes()))
			}
		case "id":
			x.ID = (int64)(r.DecodeInt64())
		case "id_str":
			x.IDStr = (string)(string(r.DecodeStringAsBytes()))
		case "in_reply_to_screen_name":
			if r.TryNil() {
				if x.InReplyToScreenName != nil { // remove the if-true
					x.InReplyToScreenName = nil
				}
			} else {
				if x.InReplyToScreenName == nil {
					x.InReplyToScreenName = new(string)
				}
				*x.InReplyToScreenName = (string)(string(r.DecodeStringAsBytes()))
			}
		case "in_reply_to_status_id":
			if r.TryNil() {
				if x.InReplyToStatusID != nil { // remove the if-true
					x.InReplyToStatusID = nil
				}
			} else {
				if x.InReplyToStatusID == nil {
					x.InReplyToStatusID = new(string)
				}
				*x.InReplyToStatusID = (string)(string(r.DecodeStringAsBytes()))
			}
		case "in_reply_to_status_id_str":
			if r.TryNil() {
				if x.InReplyToStatusIDStr != nil { // remove the if-true
					x.InReplyToStatusIDStr = nil
				}
			} else {
				if x.InReplyToStatusIDStr == nil {
					x.InReplyToStatusIDStr = new(string)
				}
				*x.InReplyToStatusIDStr = (string)(string(r.DecodeStringAsBytes()))
			}
		case "in_reply_to_user_id":
			if r.TryNil() {
				if x.InReplyToUserID != nil { // remove the if-true
					x.InReplyToUserID = nil
				}
			} else {
				if x.InReplyToUserID == nil {
					x.InReplyToUserID = new(string)
				}
				*x.InReplyToUserID = (string)(string(r.DecodeStringAsBytes()))
			}
		case "in_reply_to_user_id_str":
			if r.TryNil() {
				if x.InReplyToUserIDStr != nil { // remove the if-true
					x.InReplyToUserIDStr = nil
				}
			} else {
				if x.InReplyToUserIDStr == nil {
					x.InReplyToUserIDStr = new(string)
				}
				*x.InReplyToUserIDStr = (string)(string(r.DecodeStringAsBytes()))
			}
		case "metadata":
			x.Metadata.CodecDecodeSelf(d)
		case "place":
			if r.TryNil() {
				if x.Place != nil { // remove the if-true
					x.Place = nil
				}
			} else {
				if x.Place == nil {
					x.Place = new(string)
				}
				*x.Place = (string)(string(r.DecodeStringAsBytes()))
			}
		case "retweet_count":
			x.RetweetCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
		case "retweeted":
			x.Retweeted = (bool)(r.DecodeBool())
		case "source":
			x.Source = (string)(string(r.DecodeStringAsBytes()))
		case "text":
			x.Text = (string)(string(r.DecodeStringAsBytes()))
		case "truncated":
			x.Truncated = (bool)(r.DecodeBool())
		case "user":
			x.User.CodecDecodeSelf(d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *Status) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj34 int
	var yyb34 bool
	var yyhl34 bool = l >= 0
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Contributors != nil { // remove the if-true
			x.Contributors = nil
		}
	} else {
		if x.Contributors == nil {
			x.Contributors = new(string)
		}
		*x.Contributors = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Coordinates != nil { // remove the if-true
			x.Coordinates = nil
		}
	} else {
		if x.Coordinates == nil {
			x.Coordinates = new(string)
		}
		*x.Coordinates = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.CreatedAt = (string)(string(r.DecodeStringAsBytes()))
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Entities.CodecDecodeSelf(d)
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Favorited = (bool)(r.DecodeBool())
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Geo != nil { // remove the if-true
			x.Geo = nil
		}
	} else {
		if x.Geo == nil {
			x.Geo = new(string)
		}
		*x.Geo = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ID = (int64)(r.DecodeInt64())
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.IDStr = (string)(string(r.DecodeStringAsBytes()))
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.InReplyToScreenName != nil { // remove the if-true
			x.InReplyToScreenName = nil
		}
	} else {
		if x.InReplyToScreenName == nil {
			x.InReplyToScreenName = new(string)
		}
		*x.InReplyToScreenName = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.InReplyToStatusID != nil { // remove the if-true
			x.InReplyToStatusID = nil
		}
	} else {
		if x.InReplyToStatusID == nil {
			x.InReplyToStatusID = new(string)
		}
		*x.InReplyToStatusID = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.InReplyToStatusIDStr != nil { // remove the if-true
			x.InReplyToStatusIDStr = nil
		}
	} else {
		if x.InReplyToStatusIDStr == nil {
			x.InReplyToStatusIDStr = new(string)
		}
		*x.InReplyToStatusIDStr = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.InReplyToUserID != nil { // remove the if-true
			x.InReplyToUserID = nil
		}
	} else {
		if x.InReplyToUserID == nil {
			x.InReplyToUserID = new(string)
		}
		*x.InReplyToUserID = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.InReplyToUserIDStr != nil { // remove the if-true
			x.InReplyToUserIDStr = nil
		}
	} else {
		if x.InReplyToUserIDStr == nil {
			x.InReplyToUserIDStr = new(string)
		}
		*x.InReplyToUserIDStr = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Metadata.CodecDecodeSelf(d)
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Place != nil { // remove the if-true
			x.Place = nil
		}
	} else {
		if x.Place == nil {
			x.Place = new(string)
		}
		*x.Place = (string)(string(r.DecodeStringAsBytes()))
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.RetweetCount = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize2736))
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Retweeted = (bool)(r.DecodeBool())
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Source = (string)(string(r.DecodeStringAsBytes()))
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Text = (string)(string(r.DecodeStringAsBytes()))
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Truncated = (bool)(r.DecodeBool())
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = z.DecCheckBreak()
	}
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.User.CodecDecodeSelf(d)
	for {
		yyj34++
		if yyhl34 {
			yyb34 = yyj34 > l
		} else {
			yyb34 = z.DecCheckBreak()
		}
		if yyb34 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj34-1, "")
	}
}

func (x *LargeStruct) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			yy5 := &x.SearchMetadata
			yy5.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.Statuses == nil {
				r.EncodeNil()
			} else {
				h.encSliceStatus(([]Status)(x.Statuses), e)
			} // end block: if x.Statuses slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			r.EncodeString(`search_metadata`)
			z.EncWriteMapElemValue()
			yy8 := &x.SearchMetadata
			yy8.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"statuses\"")
			} else {
				r.EncodeString(`statuses`)
			}
			z.EncWriteMapElemValue()
			if x.Statuses == nil {
				r.EncodeNil()
			} else {
				h.encSliceStatus(([]Status)(x.Statuses), e)
			} // end block: if x.Statuses slice == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *LargeStruct) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = LargeStruct{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *LargeStruct) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "search_metadata":
			x.SearchMetadata.CodecDecodeSelf(d)
		case "statuses":
			h.decSliceStatus((*[]Status)(&x.Statuses), d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *LargeStruct) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.SearchMetadata.CodecDecodeSelf(d)
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSliceStatus((*[]Status)(&x.Statuses), d)
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = z.DecCheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *XLStruct) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if x.Data == nil {
				r.EncodeNil()
			} else {
				h.encSliceLargeStruct(([]LargeStruct)(x.Data), e)
			} // end block: if x.Data slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Data\"")
			} else {
				r.EncodeString(`Data`)
			}
			z.EncWriteMapElemValue()
			if x.Data == nil {
				r.EncodeNil()
			} else {
				h.encSliceLargeStruct(([]LargeStruct)(x.Data), e)
			} // end block: if x.Data slice == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *XLStruct) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil2736 {
		*(x) = XLStruct{}
	} else if yyct2 == codecSelferValueTypeMap2736 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray2736 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct2736)
	}
}

func (x *XLStruct) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "Data":
			h.decSliceLargeStruct((*[]LargeStruct)(&x.Data), d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *XLStruct) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSliceLargeStruct((*[]LargeStruct)(&x.Data), d)
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x codecSelfer2736) encSliceHashtag(v []Hashtag, e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer2736) decSliceHashtag(v *[]Hashtag, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []Hashtag{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 40)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]Hashtag, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 40)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]Hashtag, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, Hashtag{})
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]Hashtag, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer2736) encSlicePtrtostring(v []*string, e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yy2 := *yyv1
			r.EncodeString(string(yy2))
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer2736) decSlicePtrtostring(v *[]*string, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*string{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*string, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*string, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(string)
					}
					*yyv1[yyj1] = (string)(string(r.DecodeStringAsBytes()))
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]*string, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer2736) encSliceURL(v []URL, e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer2736) decSliceURL(v *[]URL, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []URL{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 48)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]URL, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 48)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]URL, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, URL{})
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]URL, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer2736) encSliceStatus(v []Status, e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer2736) decSliceStatus(v *[]Status, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []Status{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 752)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]Status, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 752)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]Status, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, Status{})
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]Status, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer2736) encSliceLargeStruct(v []LargeStruct, e *codec1978.Encoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer2736) decSliceLargeStruct(v *[]LargeStruct, d *codec1978.Decoder) {
	var h codecSelfer2736
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []LargeStruct{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 136)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]LargeStruct, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 136)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]LargeStruct, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, LargeStruct{})
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]LargeStruct, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}
