// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudtrail provides a client for AWS CloudTrail.
package cloudtrail

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a request for the AddTags operation.
func (c *CloudTrail) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// Adds one or more tags to a trail, up to a limit of 10. Tags must be unique
// per trail. Overwrites an existing tag's value when a new value is specified
// for an existing tag key. If you specify a key without a value, the tag will
// be created with the specified key and a value of null. You can tag a trail
// that applies to all regions only from the region in which the trail was created
// (that is, from its home region).
func (c *CloudTrail) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTrail = "CreateTrail"

// CreateTrailRequest generates a request for the CreateTrail operation.
func (c *CloudTrail) CreateTrailRequest(input *CreateTrailInput) (req *request.Request, output *CreateTrailOutput) {
	op := &request.Operation{
		Name:       opCreateTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTrailOutput{}
	req.Data = output
	return
}

// Creates a trail that specifies the settings for delivery of log data to an
// Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective
// of the region in which they were created.
func (c *CloudTrail) CreateTrail(input *CreateTrailInput) (*CreateTrailOutput, error) {
	req, out := c.CreateTrailRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTrail = "DeleteTrail"

// DeleteTrailRequest generates a request for the DeleteTrail operation.
func (c *CloudTrail) DeleteTrailRequest(input *DeleteTrailInput) (req *request.Request, output *DeleteTrailOutput) {
	op := &request.Operation{
		Name:       opDeleteTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTrailOutput{}
	req.Data = output
	return
}

// Deletes a trail. This operation must be called from the region in which the
// trail was created. DeleteTrail cannot be called on the shadow trails (replicated
// trails in other regions) of a trail that is enabled in all regions.
func (c *CloudTrail) DeleteTrail(input *DeleteTrailInput) (*DeleteTrailOutput, error) {
	req, out := c.DeleteTrailRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrails = "DescribeTrails"

// DescribeTrailsRequest generates a request for the DescribeTrails operation.
func (c *CloudTrail) DescribeTrailsRequest(input *DescribeTrailsInput) (req *request.Request, output *DescribeTrailsOutput) {
	op := &request.Operation{
		Name:       opDescribeTrails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrailsOutput{}
	req.Data = output
	return
}

// Retrieves settings for the trail associated with the current region for your
// account.
func (c *CloudTrail) DescribeTrails(input *DescribeTrailsInput) (*DescribeTrailsOutput, error) {
	req, out := c.DescribeTrailsRequest(input)
	err := req.Send()
	return out, err
}

const opGetTrailStatus = "GetTrailStatus"

// GetTrailStatusRequest generates a request for the GetTrailStatus operation.
func (c *CloudTrail) GetTrailStatusRequest(input *GetTrailStatusInput) (req *request.Request, output *GetTrailStatusOutput) {
	op := &request.Operation{
		Name:       opGetTrailStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTrailStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTrailStatusOutput{}
	req.Data = output
	return
}

// Returns a JSON-formatted list of information about the specified trail. Fields
// include information on delivery errors, Amazon SNS and Amazon S3 errors,
// and start and stop logging times for each trail. This operation returns trail
// status from a single region. To return trail status from all regions, you
// must call the operation on each region.
func (c *CloudTrail) GetTrailStatus(input *GetTrailStatusInput) (*GetTrailStatusOutput, error) {
	req, out := c.GetTrailStatusRequest(input)
	err := req.Send()
	return out, err
}

const opListPublicKeys = "ListPublicKeys"

// ListPublicKeysRequest generates a request for the ListPublicKeys operation.
func (c *CloudTrail) ListPublicKeysRequest(input *ListPublicKeysInput) (req *request.Request, output *ListPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPublicKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPublicKeysOutput{}
	req.Data = output
	return
}

// Returns all public keys whose private keys were used to sign the digest files
// within the specified time range. The public key is needed to validate digest
// files that were signed with its corresponding private key.
//
// CloudTrail uses different private/public key pairs per region. Each digest
// file is signed with a private key unique to its region. Therefore, when you
// validate a digest file from a particular region, you must look in the same
// region for its corresponding public key.
func (c *CloudTrail) ListPublicKeys(input *ListPublicKeysInput) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	err := req.Send()
	return out, err
}

const opListTags = "ListTags"

// ListTagsRequest generates a request for the ListTags operation.
func (c *CloudTrail) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsOutput{}
	req.Data = output
	return
}

// Lists the tags for the specified trail or trails in the current region.
//
// Lists the tags for the trail in the current region.
func (c *CloudTrail) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	err := req.Send()
	return out, err
}

const opLookupEvents = "LookupEvents"

// LookupEventsRequest generates a request for the LookupEvents operation.
func (c *CloudTrail) LookupEventsRequest(input *LookupEventsInput) (req *request.Request, output *LookupEventsOutput) {
	op := &request.Operation{
		Name:       opLookupEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LookupEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &LookupEventsOutput{}
	req.Data = output
	return
}

// Looks up API activity events captured by CloudTrail that create, update,
// or delete resources in your account. Events for a region can be looked up
// for the times in which you had CloudTrail turned on in that region during
// the last seven days. Lookup supports five different attributes: time range
// (defined by a start time and end time), user name, event name, resource type,
// and resource name. All attributes are optional. The maximum number of attributes
// that can be specified in any one lookup request are time range and one other
// attribute. The default number of results returned is 10, with a maximum of
// 50 possible. The response includes a token that you can use to get the next
// page of results.
//
// The rate of lookup requests is limited to one per second per account. If
// this limit is exceeded, a throttling error occurs.  Events that occurred
// during the selected time range will not be available for lookup if CloudTrail
// logging was not enabled when the events occurred.
func (c *CloudTrail) LookupEvents(input *LookupEventsInput) (*LookupEventsOutput, error) {
	req, out := c.LookupEventsRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a request for the RemoveTags operation.
func (c *CloudTrail) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// Removes the specified tags from a trail.
func (c *CloudTrail) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opStartLogging = "StartLogging"

// StartLoggingRequest generates a request for the StartLogging operation.
func (c *CloudTrail) StartLoggingRequest(input *StartLoggingInput) (req *request.Request, output *StartLoggingOutput) {
	op := &request.Operation{
		Name:       opStartLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartLoggingOutput{}
	req.Data = output
	return
}

// Starts the recording of AWS API calls and log file delivery for a trail.
// For a trail that is enabled in all regions, this operation must be called
// from the region in which the trail was created. This operation cannot be
// called on the shadow trails (replicated trails in other regions) of a trail
// that is enabled in all regions.
func (c *CloudTrail) StartLogging(input *StartLoggingInput) (*StartLoggingOutput, error) {
	req, out := c.StartLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opStopLogging = "StopLogging"

// StopLoggingRequest generates a request for the StopLogging operation.
func (c *CloudTrail) StopLoggingRequest(input *StopLoggingInput) (req *request.Request, output *StopLoggingOutput) {
	op := &request.Operation{
		Name:       opStopLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopLoggingOutput{}
	req.Data = output
	return
}

// Suspends the recording of AWS API calls and log file delivery for the specified
// trail. Under most circumstances, there is no need to use this action. You
// can update a trail without stopping it first. This action is the only way
// to stop recording. For a trail enabled in all regions, this operation must
// be called from the region in which the trail was created, or an InvalidHomeRegionException
// will occur. This operation cannot be called on the shadow trails (replicated
// trails in other regions) of a trail enabled in all regions.
func (c *CloudTrail) StopLogging(input *StopLoggingInput) (*StopLoggingOutput, error) {
	req, out := c.StopLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTrail = "UpdateTrail"

// UpdateTrailRequest generates a request for the UpdateTrail operation.
func (c *CloudTrail) UpdateTrailRequest(input *UpdateTrailInput) (req *request.Request, output *UpdateTrailOutput) {
	op := &request.Operation{
		Name:       opUpdateTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTrailOutput{}
	req.Data = output
	return
}

// Updates the settings that specify delivery of log files. Changes to a trail
// do not require stopping the CloudTrail service. Use this action to designate
// an existing bucket for log delivery. If the existing bucket has previously
// been a target for CloudTrail log files, an IAM policy exists for the bucket.
// UpdateTrail must be called from the region in which the trail was created;
// otherwise, an InvalidHomeRegionException is thrown.
func (c *CloudTrail) UpdateTrail(input *UpdateTrailInput) (*UpdateTrailOutput, error) {
	req, out := c.UpdateTrailRequest(input)
	err := req.Send()
	return out, err
}

// Specifies the tags to add to a trail.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trail to which one or more tags will be added. The
	// format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	ResourceId *string `type:"string" required:"true"`

	// Contains a list of CloudTrail tags, up to a limit of 10.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// Specifies the settings for each trail.
type CreateTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs will be
	// delivered. Not required unless you specify CloudWatchLogsRoleArn.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether log file integrity validation is enabled. The default is
	// false.
	//
	// When you disable log file integrity validation, the chain of digest files
	// is broken after one hour. CloudTrail will not create digest files for log
	// files that were delivered during a period in which log file integrity validation
	// was disabled. For example, if you enable log file integrity validation at
	// noon on January 1, disable it at noon on January 2, and re-enable it at noon
	// on January 10, digest files will not be created for the log files delivered
	// from noon on January 2 to noon on January 10. The same applies whenever you
	// stop CloudTrail logging or delete a trail.
	EnableLogFileValidation *bool `type:"boolean"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail is created in the current region or in all regions.
	// The default is false.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be a an alias name prefixed by "alias/", a fully specified
	// ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// Examples:
	//
	//  alias/MyAliasName arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// 12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies the name of the trail. The name must meet the following requirements:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-) Start with a letter or number, and end with a letter or
	// number Be between 3 and 128 characters Have no adjacent periods, underscores
	// or dashes. Names like my-_namespace and my--namespace are invalid. Not be
	// in IP address format (for example, 192.168.5.4)
	Name *string `type:"string" required:"true"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files. See Amazon S3 Bucket Naming Requirements (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string" required:"true"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery. The maximum length is 256 characters.
	SnsTopicName *string `type:"string"`
}

// String returns the string representation
func (s CreateTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrailInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type CreateTrailOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists in one region or in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the format:
	//
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Specifies the name of the trail.
	Name *string `type:"string"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files.
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery.
	SnsTopicName *string `type:"string"`

	// Specifies the ARN of the trail that was created.
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s CreateTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrailOutput) GoString() string {
	return s.String()
}

// The request that specifies the name of a trail to delete.
type DeleteTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail to be deleted. The
	// format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrailInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type DeleteTrailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrailOutput) GoString() string {
	return s.String()
}

// Returns information about the trail.
type DescribeTrailsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include shadow trails in the response. A shadow trail
	// is the replication in a region of a trail that was created in a different
	// region. The default is true.
	IncludeShadowTrails *bool `locationName:"includeShadowTrails" type:"boolean"`

	// Specifies a list of trail names, trail ARNs, or both, of the trails to describe.
	// The format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	// If an empty list is specified, information for the trail in the current region
	// is returned.
	//
	//  If an empty list is specified and IncludeShadowTrails is false, then information
	// for all trails in the current region is returned.  If an empty list is specified
	// and IncludeShadowTrails is null or true, then information for all trails
	// in the current region and any associated shadow trails in other regions is
	// returned.   If one or more trail names are specified, information is returned
	// only if the names match the names of trails belonging only to the current
	// region. To return information about a trail in another region, you must specify
	// its trail ARN.
	TrailNameList []*string `locationName:"trailNameList" type:"list"`
}

// String returns the string representation
func (s DescribeTrailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrailsInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type DescribeTrailsOutput struct {
	_ struct{} `type:"structure"`

	// The list of trail objects.
	TrailList []*Trail `locationName:"trailList" type:"list"`
}

// String returns the string representation
func (s DescribeTrailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrailsOutput) GoString() string {
	return s.String()
}

// Contains information about an event that was returned by a lookup request.
// The result includes a representation of a CloudTrail event.
type Event struct {
	_ struct{} `type:"structure"`

	// A JSON string that contains a representation of the event returned.
	CloudTrailEvent *string `type:"string"`

	// The CloudTrail ID of the event returned.
	EventId *string `type:"string"`

	// The name of the event returned.
	EventName *string `type:"string"`

	// The date and time of the event returned.
	EventTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of resources referenced by the event returned.
	Resources []*Resource `type:"list"`

	// A user name or role name of the requester that called the API in the event
	// returned.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// The name of a trail about which you want the current status.
type GetTrailStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which you are requesting
	// status. To get the status of a shadow trail (a replication of the trail in
	// another region), you must specify its ARN. The format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetTrailStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrailStatusInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type GetTrailStatusOutput struct {
	_ struct{} `type:"structure"`

	// Whether the CloudTrail is currently logging AWS API calls.
	IsLogging *bool `type:"boolean"`

	// Displays any CloudWatch Logs error that CloudTrail encountered when attempting
	// to deliver logs to CloudWatch Logs.
	LatestCloudWatchLogsDeliveryError *string `type:"string"`

	// Displays the most recent date and time when CloudTrail delivered logs to
	// CloudWatch Logs.
	LatestCloudWatchLogsDeliveryTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is deprecated.
	LatestDeliveryAttemptSucceeded *string `type:"string"`

	// This field is deprecated.
	LatestDeliveryAttemptTime *string `type:"string"`

	// Displays any Amazon S3 error that CloudTrail encountered when attempting
	// to deliver log files to the designated bucket. For more information see the
	// topic Error Responses (http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html)
	// in the Amazon S3 API Reference.
	//
	// This error occurs only when there is a problem with the destination S3 bucket
	// and will not occur for timeouts. To resolve the issue, create a new bucket
	// and call UpdateTrail to specify the new bucket, or fix the existing objects
	// so that CloudTrail can again write to the bucket.
	LatestDeliveryError *string `type:"string"`

	// Specifies the date and time that CloudTrail last delivered log files to an
	// account's Amazon S3 bucket.
	LatestDeliveryTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Displays any Amazon S3 error that CloudTrail encountered when attempting
	// to deliver a digest file to the designated bucket. For more information see
	// the topic Error Responses (http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html)
	// in the Amazon S3 API Reference.
	//
	// This error occurs only when there is a problem with the destination S3 bucket
	// and will not occur for timeouts. To resolve the issue, create a new bucket
	// and call UpdateTrail to specify the new bucket, or fix the existing objects
	// so that CloudTrail can again write to the bucket.
	LatestDigestDeliveryError *string `type:"string"`

	// Specifies the date and time that CloudTrail last delivered a digest file
	// to an account's Amazon S3 bucket.
	LatestDigestDeliveryTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is deprecated.
	LatestNotificationAttemptSucceeded *string `type:"string"`

	// This field is deprecated.
	LatestNotificationAttemptTime *string `type:"string"`

	// Displays any Amazon SNS error that CloudTrail encountered when attempting
	// to send a notification. For more information about Amazon SNS errors, see
	// the Amazon SNS Developer Guide (http://docs.aws.amazon.com/sns/latest/dg/welcome.html).
	LatestNotificationError *string `type:"string"`

	// Specifies the date and time of the most recent Amazon SNS notification that
	// CloudTrail has written a new log file to an account's Amazon S3 bucket.
	LatestNotificationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Specifies the most recent date and time when CloudTrail started recording
	// API calls for an AWS account.
	StartLoggingTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Specifies the most recent date and time when CloudTrail stopped recording
	// API calls for an AWS account.
	StopLoggingTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is deprecated.
	TimeLoggingStarted *string `type:"string"`

	// This field is deprecated.
	TimeLoggingStopped *string `type:"string"`
}

// String returns the string representation
func (s GetTrailStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrailStatusOutput) GoString() string {
	return s.String()
}

// Requests the public keys for a specified time range.
type ListPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Optionally specifies, in UTC, the end of the time range to look up public
	// keys for CloudTrail digest files. If not specified, the current time is used.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Optionally specifies, in UTC, the start of the time range to look up public
	// keys for CloudTrail digest files. If not specified, the current time is used,
	// and the current public key is returned.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ListPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type ListPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Contains an array of PublicKey objects.
	//
	// The returned public keys may have validity time ranges that overlap.
	PublicKeyList []*PublicKey `type:"list"`
}

// String returns the string representation
func (s ListPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysOutput) GoString() string {
	return s.String()
}

// Specifies a list of trail tags to return.
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Specifies a list of trail ARNs whose tags will be listed. The list has a
	// limit of 20 ARNs. The format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	ResourceIdList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// A list of resource tags.
	ResourceTagList []*ResourceTag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// Specifies an attribute and value that filter the events returned.
type LookupAttribute struct {
	_ struct{} `type:"structure"`

	// Specifies an attribute on which to filter the events returned.
	AttributeKey *string `type:"string" required:"true" enum:"LookupAttributeKey"`

	// Specifies a value for the specified AttributeKey.
	AttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LookupAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupAttribute) GoString() string {
	return s.String()
}

// Contains a request for LookupEvents.
type LookupEventsInput struct {
	_ struct{} `type:"structure"`

	// Specifies that only events that occur before or at the specified time are
	// returned. If the specified end time is before the specified start time, an
	// error is returned.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Contains a list of lookup attributes. Currently the list can contain only
	// one item.
	LookupAttributes []*LookupAttribute `type:"list"`

	// The number of events to return. Possible values are 1 through 50. The default
	// is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	// This token must be passed in with the same parameters that were specified
	// in the the original call. For example, if the original call specified an
	// AttributeKey of 'Username' with a value of 'root', the call with NextToken
	// should include those same parameters.
	NextToken *string `type:"string"`

	// Specifies that only events that occur after or at the specified time are
	// returned. If the specified start time is after the specified end time, an
	// error is returned.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s LookupEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupEventsInput) GoString() string {
	return s.String()
}

// Contains a response to a LookupEvents action.
type LookupEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of events returned based on the lookup attributes specified and the
	// CloudTrail event. The events list is sorted by time. The most recent event
	// is listed first.
	Events []*Event `type:"list"`

	// The token to use to get the next page of results after a previous API call.
	// If the token does not appear, there are no more results to return. The token
	// must be passed in with the same parameters as the previous call. For example,
	// if the original call specified an AttributeKey of 'Username' with a value
	// of 'root', the call with NextToken should include those same parameters.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s LookupEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupEventsOutput) GoString() string {
	return s.String()
}

// Contains information about a returned public key.
type PublicKey struct {
	_ struct{} `type:"structure"`

	// The fingerprint of the public key.
	Fingerprint *string `type:"string"`

	// The ending time of validity of the public key.
	ValidityEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The starting time of validity of the public key.
	ValidityStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The DER encoded public key value in PKCS#1 format.
	Value []byte `type:"blob"`
}

// String returns the string representation
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKey) GoString() string {
	return s.String()
}

// Specifies the tags to remove from a trail.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trail from which tags should be removed. The format
	// of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	ResourceId *string `type:"string" required:"true"`

	// Specifies a list of tags to be removed.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Specifies the type and name of a resource referenced by an event.
type Resource struct {
	_ struct{} `type:"structure"`

	// The name of the resource referenced by the event returned. These are user-created
	// names whose values will depend on the environment. For example, the resource
	// name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567"
	// for an EC2 Instance.
	ResourceName *string `type:"string"`

	// The type of a resource referenced by the event returned. When the resource
	// type cannot be determined, null is returned. Some examples of resource types
	// are: Instance for EC2, Trail for CloudTrail, DBInstance for RDS, and AccessKey
	// for IAM. For a list of resource types supported for event lookup, see Resource
	// Types Supported for Event Lookup (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html).
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// A resource tag.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the resource.
	ResourceId *string `type:"string"`

	// A list of tags.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// The request to CloudTrail to start logging AWS API calls for an account.
type StartLoggingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which CloudTrail
	// logs AWS API calls. The format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartLoggingInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type StartLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartLoggingOutput) GoString() string {
	return s.String()
}

// Passes the request to CloudTrail to stop logging AWS API calls for the specified
// account.
type StopLoggingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which CloudTrail
	// will stop logging AWS API calls. The format of a trail ARN is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopLoggingInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type StopLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopLoggingOutput) GoString() string {
	return s.String()
}

// A custom key-value pair associated with a resource such as a CloudTrail trail.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key in a key-value pair. The key must be must be no longer than 128 Unicode
	// characters. The key must be unique for the resource to which it applies.
	Key *string `type:"string" required:"true"`

	// The value in a key-value pair of a tag. The value must be no longer than
	// 256 Unicode characters.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The settings for a trail.
type Trail struct {
	_ struct{} `type:"structure"`

	// Specifies an Amazon Resource Name (ARN), a unique identifier that represents
	// the log group to which CloudTrail logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// The region in which the trail was created.
	HomeRegion *string `type:"string"`

	// Set to True to include AWS API calls from AWS global services such as IAM.
	// Otherwise, False.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail belongs only to one region or exists in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the format:
	//
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Name of the trail set by calling CreateTrail. The maximum length is 128 characters.
	Name *string `type:"string"`

	// Name of the Amazon S3 bucket into which CloudTrail delivers your trail files.
	// See Amazon S3 Bucket Naming Requirements (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).The
	// maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Name of the existing Amazon SNS topic that CloudTrail uses to notify the
	// account owner when new CloudTrail log files have been delivered. The maximum
	// length is 256 characters.
	SnsTopicName *string `type:"string"`

	// The Amazon Resource Name of the trail. The TrailARN format is arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s Trail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trail) GoString() string {
	return s.String()
}

// Specifies settings to update for the trail.
type UpdateTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs will be
	// delivered. Not required unless you specify CloudWatchLogsRoleArn.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether log file validation is enabled. The default is false.
	//
	// When you disable log file integrity validation, the chain of digest files
	// is broken after one hour. CloudTrail will not create digest files for log
	// files that were delivered during a period in which log file integrity validation
	// was disabled. For example, if you enable log file integrity validation at
	// noon on January 1, disable it at noon on January 2, and re-enable it at noon
	// on January 10, digest files will not be created for the log files delivered
	// from noon on January 2 to noon on January 10. The same applies whenever you
	// stop CloudTrail logging or delete a trail.
	EnableLogFileValidation *bool `type:"boolean"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail applies only to the current region or to all
	// regions. The default is false. If the trail exists only in the current region
	// and this value is set to true, shadow trails (replications of the trail)
	// will be created in the other regions. If the trail exists in all regions
	// and this value is set to false, the trail will remain in the region where
	// it was created, and its shadow trails in other regions will be deleted.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be a an alias name prefixed by "alias/", a fully specified
	// ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// Examples:
	//
	//  alias/MyAliasName arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// 12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies the name of the trail or trail ARN. If Name is a trail name, the
	// string must meet the following requirements:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-) Start with a letter or number, and end with a letter or
	// number Be between 3 and 128 characters Have no adjacent periods, underscores
	// or dashes. Names like my-_namespace and my--namespace are invalid. Not be
	// in IP address format (for example, 192.168.5.4)  If Name is a trail ARN,
	// it must be in the format arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail.
	Name *string `type:"string" required:"true"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files. See Amazon S3 Bucket Naming Requirements (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery. The maximum length is 256 characters.
	SnsTopicName *string `type:"string"`
}

// String returns the string representation
func (s UpdateTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrailInput) GoString() string {
	return s.String()
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
type UpdateTrailOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists in one region or in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the format:
	//
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Specifies the name of the trail.
	Name *string `type:"string"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files.
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery.
	SnsTopicName *string `type:"string"`

	// Specifies the ARN of the trail that was updated.
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s UpdateTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrailOutput) GoString() string {
	return s.String()
}

const (
	// @enum LookupAttributeKey
	LookupAttributeKeyEventId = "EventId"
	// @enum LookupAttributeKey
	LookupAttributeKeyEventName = "EventName"
	// @enum LookupAttributeKey
	LookupAttributeKeyUsername = "Username"
	// @enum LookupAttributeKey
	LookupAttributeKeyResourceType = "ResourceType"
	// @enum LookupAttributeKey
	LookupAttributeKeyResourceName = "ResourceName"
)
