# -*- coding: UTF-8 -*-
#
# generated by wxGlade
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade

# begin wxGlade: extracode
# end wxGlade


class wxgExportAreaSaveAsDlg(wx.Dialog):
	def __init__(self, *args, **kwds):
		# begin wxGlade: wxgExportAreaSaveAsDlg.__init__
		kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE | wx.MAXIMIZE_BOX | wx.MINIMIZE_BOX | wx.RESIZE_BORDER
		wx.Dialog.__init__(self, *args, **kwds)
		self.SetSize((600, 319))
		self._LBL_header = wx.StaticText(self, wx.ID_ANY, _("\nDescribe the intended action.\n"))
		self._BTN_select_directory = wx.Button(self, wx.ID_ANY, _("Path:"), style=wx.BU_EXACTFIT)
		self._LBL_directory = wx.StaticText(self, wx.ID_ANY, _("<shows default path computed at runtime>"), style=wx.ST_ELLIPSIZE_START)
		self._LBL_dir_is_empty = wx.StaticText(self, wx.ID_ANY, _("this path is/is not empty"))
		self._BTN_open_directory = wx.Button(self, wx.ID_ANY, _("Open"), style=wx.BU_EXACTFIT)
		self._BTN_clear_directory = wx.Button(self, wx.ID_ANY, _("Clear"), style=wx.BU_EXACTFIT)
		self._CHBOX_use_subdirectory = wx.CheckBox(self, wx.ID_ANY, _("use subdirectory"), style=wx.CHK_2STATE)
		self._CHBOX_generate_metadata = wx.CheckBox(self, wx.ID_ANY, _("generate &metadata"), style=wx.CHK_2STATE)
		self._CHBOX_encrypt = wx.CheckBox(self, wx.ID_ANY, _("en&crypt"), style=wx.CHK_2STATE)
		self._CHBOX_convert2pdf = wx.CheckBox(self, wx.ID_ANY, _("convert to PDF"), style=wx.CHK_2STATE)
		self._BTN_save_files = wx.Button(self, wx.ID_OK, _("Save Files"))
		self._BTN_save_archive = wx.Button(self, wx.ID_ANY, _("Save as Archive"))
		self._BTN_cancel = wx.Button(self, wx.ID_CANCEL, "")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self._on_select_directory_button_pressed, self._BTN_select_directory)
		self.Bind(wx.EVT_BUTTON, self._on_open_directory_button_pressed, self._BTN_open_directory)
		self.Bind(wx.EVT_BUTTON, self._on_clear_directory_button_pressed, self._BTN_clear_directory)
		self.Bind(wx.EVT_CHECKBOX, self._on_use_subdirectory_toggled, self._CHBOX_use_subdirectory)
		self.Bind(wx.EVT_CHECKBOX, self._on_generate_metadata_toggled, self._CHBOX_generate_metadata)
		self.Bind(wx.EVT_CHECKBOX, self._on_save_as_encrypted_toggled, self._CHBOX_encrypt)
		self.Bind(wx.EVT_BUTTON, self._on_save_archive_button_pressed, self._BTN_save_archive)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: wxgExportAreaSaveAsDlg.__set_properties
		self.SetTitle(_("Saving export area items"))
		self.SetSize((600, 319))
		self._BTN_select_directory.SetToolTip(_("Select target directory for files or archive."))
		self._LBL_directory.SetFont(wx.Font(9, wx.DEFAULT, wx.SLANT, wx.NORMAL, 0, ""))
		self._LBL_dir_is_empty.SetForegroundColour(wx.Colour(255, 127, 0))
		self._LBL_dir_is_empty.SetFont(wx.Font(9, wx.DEFAULT, wx.SLANT, wx.NORMAL, 0, ""))
		self._BTN_open_directory.SetToolTip(_("Open selected target directory in file browser."))
		self._BTN_clear_directory.SetToolTip(_("Clear selected target directory from any existing data."))
		self._BTN_clear_directory.Enable(False)
		self._CHBOX_use_subdirectory.SetToolTip(_("Save into patient specific subdirectory ?\n\nCheck if you want GNUmed to create a suitable subdirectory within the selected path and save to that."))
		self._CHBOX_use_subdirectory.SetValue(1)
		self._CHBOX_generate_metadata.SetToolTip(_("Generate metadata ?\n\nCheck if you want GNUmed to generate metadata describing the exported patient data and save it alongside the files.\n\nWhen saving into an archive metadata will always be included."))
		self._CHBOX_encrypt.SetToolTip(_("Use encryption ?\n\nWhen you save as files each file will be encrypted individually.\n\nWhen you save into an archive the ZIP archive itself will be encrypted rather than the files contained within. Encrypted archives will not include any patient data into the archive filename."))
		self._CHBOX_convert2pdf.SetToolTip(_("Convert files to PDF before encryption, if possible.\n\nWhen you save encrypted files GNUmed will try to convert each file to PDF first. This will typically work for any images and will ensure maximum compatibility with receiver systems not nicely set up for handling encrypted content. Files which cannot be converted will be encrypted as is.\n\nIgnored when saving into an archive."))
		self._CHBOX_convert2pdf.Enable(False)
		self._CHBOX_convert2pdf.SetValue(1)
		self._BTN_save_files.SetToolTip(_("Save entries as individual files."))
		self._BTN_save_files.SetFocus()
		self._BTN_save_files.SetDefault()
		self._BTN_save_archive.SetToolTip(_("Save entries packaged into an archive."))
		self._BTN_cancel.SetToolTip(_("Abort saving entries."))
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: wxgExportAreaSaveAsDlg.__do_layout
		__szr_main = wx.BoxSizer(wx.VERTICAL)
		__szr_buttons = wx.BoxSizer(wx.HORIZONTAL)
		_grszr_options = wx.FlexGridSizer(4, 2, 2, 5)
		__szr_encryption_options = wx.BoxSizer(wx.HORIZONTAL)
		__szr_save_as = wx.BoxSizer(wx.HORIZONTAL)
		__szr_dir_state = wx.BoxSizer(wx.HORIZONTAL)
		__szr_main.Add(self._LBL_header, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		_grszr_options.Add(self._BTN_select_directory, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		_grszr_options.Add(self._LBL_directory, 1, wx.ALIGN_CENTER_VERTICAL, 5)
		_grszr_options.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_dir_state.Add(self._LBL_dir_is_empty, 0, wx.ALIGN_CENTER | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__szr_dir_state.Add((20, 20), 2, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_dir_state.Add(self._BTN_open_directory, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_dir_state.Add(self._BTN_clear_directory, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		_grszr_options.Add(__szr_dir_state, 0, wx.EXPAND, 3)
		__lbl_save_as = wx.StaticText(self, wx.ID_ANY, _("Options:"))
		_grszr_options.Add(__lbl_save_as, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		__szr_save_as.Add(self._CHBOX_use_subdirectory, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 10)
		__szr_save_as.Add(self._CHBOX_generate_metadata, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		_grszr_options.Add(__szr_save_as, 0, wx.EXPAND, 3)
		_grszr_options.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_encryption_options.Add(self._CHBOX_encrypt, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_encryption_options.Add(self._CHBOX_convert2pdf, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		_grszr_options.Add(__szr_encryption_options, 1, wx.EXPAND, 0)
		_grszr_options.AddGrowableCol(1)
		__szr_main.Add(_grszr_options, 1, wx.EXPAND | wx.LEFT | wx.RIGHT, 3)
		__hline_bottom = wx.StaticLine(self, wx.ID_ANY)
		__szr_main.Add(__hline_bottom, 0, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 3)
		__szr_buttons.Add((20, 20), 2, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_buttons.Add(self._BTN_save_files, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 3)
		__szr_buttons.Add(self._BTN_save_archive, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		__szr_buttons.Add((20, 20), 1, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_buttons.Add(self._BTN_cancel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_buttons.Add((20, 20), 2, wx.ALIGN_CENTER_VERTICAL | wx.EXPAND, 0)
		__szr_main.Add(__szr_buttons, 0, wx.ALL | wx.EXPAND, 3)
		self.SetSizer(__szr_main)
		self.Layout()
		# end wxGlade

	def _on_select_directory_button_pressed(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_select_directory_button_pressed' not implemented!")
		event.Skip()

	def _on_open_directory_button_pressed(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_open_directory_button_pressed' not implemented!")
		event.Skip()

	def _on_clear_directory_button_pressed(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_clear_directory_button_pressed' not implemented!")
		event.Skip()

	def _on_use_subdirectory_toggled(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_use_subdirectory_toggled' not implemented!")
		event.Skip()

	def _on_generate_metadata_toggled(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_generate_metadata_toggled' not implemented!")
		event.Skip()

	def _on_save_as_encrypted_toggled(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_save_as_encrypted_toggled' not implemented!")
		event.Skip()

	def _on_save_archive_button_pressed(self, event):  # wxGlade: wxgExportAreaSaveAsDlg.<event_handler>
		print("Event handler '_on_save_archive_button_pressed' not implemented!")
		event.Skip()

# end of class wxgExportAreaSaveAsDlg
