#ifndef gm_pixbuf_H
#define gm_pixbuf_H 1

#include <gtk/gtk.h>
#include <glib.h>

typedef struct _GmPixbufInfo {
	gchar *name;
	int width;
	int height;
	GdkPixbuf *pixbuf;
} GmPixbufInfo;

/* Stock items */
#define GM_STOCK_SAVE_CLOSE "gm-stock-save-close"

void gm_pixbuf_init();
void gm_pixbuf_fini();

void gm_pixbuf_add_directory(const gchar *directory);

GdkPixbuf *gm_pixbuf_get(const gchar *filename);
GdkPixbuf *gm_pixbuf_get_at_size(const gchar *filename, int width, int height);

void gm_pixbuf_set_alpha(GdkPixbuf **pixs, guchar alpha);

#endif
