/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * file-icns-data.c
 * Copyright (C) 2004 Brion Vibber <brion@pobox.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include "file-icns-data.h"

/* Ported from Brion Vibber's icnsdata.c code, under the GPL license, version 3
 * or any later version of the license */
IconType iconTypes[] =
{
  /* 1-bit, no mask? */
  {"SICN",  16,  16,  1, 0, FALSE},
  {"ICON",  32,  32,  1, 0, FALSE},

  /* 1-bit image and hitmask */
  {"icm#",  12,  12,  1, "icm#", FALSE},
  {"ics#",  16,  16,  1, "ics#", FALSE},
  {"ICN#",  32,  32,  1, "ICN#", FALSE},
  {"ich#",  48,  48,  1, "ich#", FALSE},

  /* 4-bit. Use mask from binary. */
  {"icm4",  12,  12,  4, "icm#", FALSE},
  {"ics4",  16,  16,  4, "ics#", FALSE},
  {"icl4",  32,  32,  4, "ICN#", FALSE},
  {"ich4",  48,  48,  4, "ich#", FALSE},

  /* 8-bit. Use mask from binary. */
  {"icm8",  12,  12,  8, "icm#", FALSE},
  {"ics8",  16,  16,  8, "ics#", FALSE},
  {"icl8",  32,  32,  8, "ICN#", FALSE},
  {"ich8",  48,  48,  8, "ich#", FALSE},

  /* 32-bit color icons; separate 8-bit alpha */
  {"is32",  16,  16, 32, "s8mk", FALSE},
  {"il32",  32,  32, 32, "l8mk", FALSE},
  {"ih32",  48,  48, 32, "h8mk", FALSE},
  {"it32", 128, 128, 32, "t8mk", FALSE},

  /* Post-MacOS 10.0 ICNS formats */
  /* PNG, JPEG 2000, or 24-bit RGB */
  {"icp4",   16,   16, 32, "N/A", TRUE},
  {"icp5",   32,   32, 32, "N/A", TRUE},

  /* PNG or JPEG 2000 */
  {"icp6",   48,   48, 0, "N/A", TRUE},
  {"ic07",  128,  128, 0, "N/A", TRUE},
  {"ic08",  256,  256, 0, "N/A", TRUE},
  {"ic09",  512,  512, 0, "N/A", TRUE},
  {"sb24",   24,   24, 0, "N/A", TRUE},

  /* PNG or JPEG 2000 (Retina) */
  {"ic10", 1024, 1024, 0, "N/A", TRUE},
  {"ic11",   32,   32, 0, "N/A", TRUE},
  {"ic12",   64,   64, 0, "N/A", TRUE},
  {"ic13",  256,  256, 0, "N/A", TRUE},
  {"ic14",  512,  512, 0, "N/A", TRUE},
  {"icsB",   36,   36, 0, "N/A", TRUE},
  {"SB24",   48,   48, 0, "N/A", TRUE},

  /* ARGB, PNG, or JPEG 2000 */
  {"ic04",   16,   16, 0, "N/A", TRUE},
  {"ic05",   32,   32, 0, "N/A", TRUE},
  {"icsb",   18,   18, 0, "N/A", TRUE},

  {0, 0, 0, 0, 0}
};

IconType maskTypes[] =
{
  /* 8-bit masks */
  {"s8mk",  16,  16,  8, 0},
  {"l8mk",  32,  32,  8, 0},
  {"h8mk",  48,  48,  8, 0},
  {"t8mk", 128, 128,  8, 0},

  {0, 0, 0, 0, 0}
};

guchar icns_colormap_4[] =
{
    0xFF, 0xFF, 0xFF,
    0xFC, 0xF3, 0x05,
    0xFF, 0x64, 0x02,
    0xDD, 0x08, 0x06,
    0xF2, 0x08, 0x84,
    0x46, 0x00, 0xA5,
    0x00, 0x00, 0xD4,
    0x02, 0xAB, 0xEA,
    0x1F, 0xB7, 0x14,
    0x00, 0x64, 0x11,
    0x56, 0x2C, 0x05,
    0x90, 0x71, 0x3A,
    0xC0, 0xC0, 0xC0,
    0x80, 0x80, 0x80,
    0x40, 0x40, 0x40,
    0x00, 0x00, 0x00
};

guchar icns_colormap_8[] =
{
    0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xCC,
    0xFF, 0xFF, 0x99,
    0xFF, 0xFF, 0x66,
    0xFF, 0xFF, 0x33,
    0xFF, 0xFF, 0x00,
    0xFF, 0xCC, 0xFF,
    0xFF, 0xCC, 0xCC,
    0xFF, 0xCC, 0x99,
    0xFF, 0xCC, 0x66,
    0xFF, 0xCC, 0x33,
    0xFF, 0xCC, 0x00,
    0xFF, 0x99, 0xFF,
    0xFF, 0x99, 0xCC,
    0xFF, 0x99, 0x99,
    0xFF, 0x99, 0x66,
    0xFF, 0x99, 0x33,
    0xFF, 0x99, 0x00,
    0xFF, 0x66, 0xFF,
    0xFF, 0x66, 0xCC,
    0xFF, 0x66, 0x99,
    0xFF, 0x66, 0x66,
    0xFF, 0x66, 0x33,
    0xFF, 0x66, 0x00,
    0xFF, 0x33, 0xFF,
    0xFF, 0x33, 0xCC,
    0xFF, 0x33, 0x99,
    0xFF, 0x33, 0x66,
    0xFF, 0x33, 0x33,
    0xFF, 0x33, 0x00,
    0xFF, 0x00, 0xFF,
    0xFF, 0x00, 0xCC,
    0xFF, 0x00, 0x99,
    0xFF, 0x00, 0x66,
    0xFF, 0x00, 0x33,
    0xFF, 0x00, 0x00,
    0xCC, 0xFF, 0xFF,
    0xCC, 0xFF, 0xCC,
    0xCC, 0xFF, 0x99,
    0xCC, 0xFF, 0x66,
    0xCC, 0xFF, 0x33,
    0xCC, 0xFF, 0x00,
    0xCC, 0xCC, 0xFF,
    0xCC, 0xCC, 0xCC,
    0xCC, 0xCC, 0x99,
    0xCC, 0xCC, 0x66,
    0xCC, 0xCC, 0x33,
    0xCC, 0xCC, 0x00,
    0xCC, 0x99, 0xFF,
    0xCC, 0x99, 0xCC,
    0xCC, 0x99, 0x99,
    0xCC, 0x99, 0x66,
    0xCC, 0x99, 0x33,
    0xCC, 0x99, 0x00,
    0xCC, 0x66, 0xFF,
    0xCC, 0x66, 0xCC,
    0xCC, 0x66, 0x99,
    0xCC, 0x66, 0x66,
    0xCC, 0x66, 0x33,
    0xCC, 0x66, 0x00,
    0xCC, 0x33, 0xFF,
    0xCC, 0x33, 0xCC,
    0xCC, 0x33, 0x99,
    0xCC, 0x33, 0x66,
    0xCC, 0x33, 0x33,
    0xCC, 0x33, 0x00,
    0xCC, 0x00, 0xFF,
    0xCC, 0x00, 0xCC,
    0xCC, 0x00, 0x99,
    0xCC, 0x00, 0x66,
    0xCC, 0x00, 0x33,
    0xCC, 0x00, 0x00,
    0x99, 0xFF, 0xFF,
    0x99, 0xFF, 0xCC,
    0x99, 0xFF, 0x99,
    0x99, 0xFF, 0x66,
    0x99, 0xFF, 0x33,
    0x99, 0xFF, 0x00,
    0x99, 0xCC, 0xFF,
    0x99, 0xCC, 0xCC,
    0x99, 0xCC, 0x99,
    0x99, 0xCC, 0x66,
    0x99, 0xCC, 0x33,
    0x99, 0xCC, 0x00,
    0x99, 0x99, 0xFF,
    0x99, 0x99, 0xCC,
    0x99, 0x99, 0x99,
    0x99, 0x99, 0x66,
    0x99, 0x99, 0x33,
    0x99, 0x99, 0x00,
    0x99, 0x66, 0xFF,
    0x99, 0x66, 0xCC,
    0x99, 0x66, 0x99,
    0x99, 0x66, 0x66,
    0x99, 0x66, 0x33,
    0x99, 0x66, 0x00,
    0x99, 0x33, 0xFF,
    0x99, 0x33, 0xCC,
    0x99, 0x33, 0x99,
    0x99, 0x33, 0x66,
    0x99, 0x33, 0x33,
    0x99, 0x33, 0x00,
    0x99, 0x00, 0xFF,
    0x99, 0x00, 0xCC,
    0x99, 0x00, 0x99,
    0x99, 0x00, 0x66,
    0x99, 0x00, 0x33,
    0x99, 0x00, 0x00,
    0x66, 0xFF, 0xFF,
    0x66, 0xFF, 0xCC,
    0x66, 0xFF, 0x99,
    0x66, 0xFF, 0x66,
    0x66, 0xFF, 0x33,
    0x66, 0xFF, 0x00,
    0x66, 0xCC, 0xFF,
    0x66, 0xCC, 0xCC,
    0x66, 0xCC, 0x99,
    0x66, 0xCC, 0x66,
    0x66, 0xCC, 0x33,
    0x66, 0xCC, 0x00,
    0x66, 0x99, 0xFF,
    0x66, 0x99, 0xCC,
    0x66, 0x99, 0x99,
    0x66, 0x99, 0x66,
    0x66, 0x99, 0x33,
    0x66, 0x99, 0x00,
    0x66, 0x66, 0xFF,
    0x66, 0x66, 0xCC,
    0x66, 0x66, 0x99,
    0x66, 0x66, 0x66,
    0x66, 0x66, 0x33,
    0x66, 0x66, 0x00,
    0x66, 0x33, 0xFF,
    0x66, 0x33, 0xCC,
    0x66, 0x33, 0x99,
    0x66, 0x33, 0x66,
    0x66, 0x33, 0x33,
    0x66, 0x33, 0x00,
    0x66, 0x00, 0xFF,
    0x66, 0x00, 0xCC,
    0x66, 0x00, 0x99,
    0x66, 0x00, 0x66,
    0x66, 0x00, 0x33,
    0x66, 0x00, 0x00,
    0x33, 0xFF, 0xFF,
    0x33, 0xFF, 0xCC,
    0x33, 0xFF, 0x99,
    0x33, 0xFF, 0x66,
    0x33, 0xFF, 0x33,
    0x33, 0xFF, 0x00,
    0x33, 0xCC, 0xFF,
    0x33, 0xCC, 0xCC,
    0x33, 0xCC, 0x99,
    0x33, 0xCC, 0x66,
    0x33, 0xCC, 0x33,
    0x33, 0xCC, 0x00,
    0x33, 0x99, 0xFF,
    0x33, 0x99, 0xCC,
    0x33, 0x99, 0x99,
    0x33, 0x99, 0x66,
    0x33, 0x99, 0x33,
    0x33, 0x99, 0x00,
    0x33, 0x66, 0xFF,
    0x33, 0x66, 0xCC,
    0x33, 0x66, 0x99,
    0x33, 0x66, 0x66,
    0x33, 0x66, 0x33,
    0x33, 0x66, 0x00,
    0x33, 0x33, 0xFF,
    0x33, 0x33, 0xCC,
    0x33, 0x33, 0x99,
    0x33, 0x33, 0x66,
    0x33, 0x33, 0x33,
    0x33, 0x33, 0x00,
    0x33, 0x00, 0xFF,
    0x33, 0x00, 0xCC,
    0x33, 0x00, 0x99,
    0x33, 0x00, 0x66,
    0x33, 0x00, 0x33,
    0x33, 0x00, 0x00,
    0x00, 0xFF, 0xFF,
    0x00, 0xFF, 0xCC,
    0x00, 0xFF, 0x99,
    0x00, 0xFF, 0x66,
    0x00, 0xFF, 0x33,
    0x00, 0xFF, 0x00,
    0x00, 0xCC, 0xFF,
    0x00, 0xCC, 0xCC,
    0x00, 0xCC, 0x99,
    0x00, 0xCC, 0x66,
    0x00, 0xCC, 0x33,
    0x00, 0xCC, 0x00,
    0x00, 0x99, 0xFF,
    0x00, 0x99, 0xCC,
    0x00, 0x99, 0x99,
    0x00, 0x99, 0x66,
    0x00, 0x99, 0x33,
    0x00, 0x99, 0x00,
    0x00, 0x66, 0xFF,
    0x00, 0x66, 0xCC,
    0x00, 0x66, 0x99,
    0x00, 0x66, 0x66,
    0x00, 0x66, 0x33,
    0x00, 0x66, 0x00,
    0x00, 0x33, 0xFF,
    0x00, 0x33, 0xCC,
    0x00, 0x33, 0x99,
    0x00, 0x33, 0x66,
    0x00, 0x33, 0x33,
    0x00, 0x33, 0x00,
    0x00, 0x00, 0xFF,
    0x00, 0x00, 0xCC,
    0x00, 0x00, 0x99,
    0x00, 0x00, 0x66,
    0x00, 0x00, 0x33,
    0xEE, 0x00, 0x00,
    0xDD, 0x00, 0x00,
    0xBB, 0x00, 0x00,
    0xAA, 0x00, 0x00,
    0x88, 0x00, 0x00,
    0x77, 0x00, 0x00,
    0x55, 0x00, 0x00,
    0x44, 0x00, 0x00,
    0x22, 0x00, 0x00,
    0x11, 0x00, 0x00,
    0x00, 0xEE, 0x00,
    0x00, 0xDD, 0x00,
    0x00, 0xBB, 0x00,
    0x00, 0xAA, 0x00,
    0x00, 0x88, 0x00,
    0x00, 0x77, 0x00,
    0x00, 0x55, 0x00,
    0x00, 0x44, 0x00,
    0x00, 0x22, 0x00,
    0x00, 0x11, 0x00,
    0x00, 0x00, 0xEE,
    0x00, 0x00, 0xDD,
    0x00, 0x00, 0xBB,
    0x00, 0x00, 0xAA,
    0x00, 0x00, 0x88,
    0x00, 0x00, 0x77,
    0x00, 0x00, 0x55,
    0x00, 0x00, 0x44,
    0x00, 0x00, 0x22,
    0x00, 0x00, 0x11,
    0xEE, 0xEE, 0xEE,
    0xDD, 0xDD, 0xDD,
    0xBB, 0xBB, 0xBB,
    0xAA, 0xAA, 0xAA,
    0x88, 0x88, 0x88,
    0x77, 0x77, 0x77,
    0x55, 0x55, 0x55,
    0x44, 0x44, 0x44,
    0x22, 0x22, 0x22,
    0x11, 0x11, 0x11,
    0x00, 0x00, 0x00
};
