.\" @(#)$RCSfile: gfal_set_timeout_srm_python.man,v $ $Revision: 1.1 $ $Date: 2008/12/18 13:19:12 $ CERN Remi Mollon
.\" Copyright (C) 2009 by CERN
.\" All rights reserved
.\"
.TH GFAL_SET_TIMEOUT_* 3 "$Date: 2008/12/18 13:19:12 $" GFAL "Library Functions"

.SH NAME
gfal_set_timeout_* \- Set several timeouts

.SH SYNOPSIS
\fBimport gfal\fR
.sp
.BI "gfal_set_timeout_connect (int " value )
.sp
.BI "gfal_set_timeout_sendreceive (int " value )
.sp
.BI "gfal_set_timeout_bdii (int " value )
.sp
.BI "gfal_set_timeout_srm (int " value )

.SH DESCRIPTION
.B gfal_set_timeout_connect
Sets the connect timeout, used when connecting to a remote host. The connection will be aborted
if the remote host doesn't reply after
.I value
seconds.
.sp
.B gfal_set_timeout_sendreceive
Sets the send/receive data timeout, used when transferring data to/from a remote host. The connection will be aborted
if no data is transfered after 
.I value
seconds.
.sp
.B gfal_set_timeout_bdii
Sets the BDII timeout, used when searching information into BDII. The connection will be aborted
if the search is longer than 
.I value
seconds.
.sp
.B gfal_set_timeout_srm
Sets the SRM timeout, used when doing an asynchronous SRM request. The request will be aborted
if it is still queued after 
.I value
seconds.

.SH SEE ALSO
.BR gfal_python (3),
.BR gfal_request_new_python (3),
.BR gfal_internal_free_python (3),
.BR gfal_init_python (3),
.BR gfal_deletesurls_python (3),
.BR gfal_removedir_python (3),
.BR gfal_turlsfromsurls_python (3),
.BR gfal_ls_python (3),
.BR gfal_get_python (3),
.BR gfal_getstatus_python (3),
.BR gfal_prestage_python (3),
.BR gfal_prestagestatus_python (3),
.BR gfal_pin_python (3),
.BR gfal_release_python (3),
.BR gfal_abortrequest_python (3),
.BR gfal_abortfiles_python (3),
.BR gfal_set_xfer_done_python (3),
.BR gfal_set_xfer_running_python (3),
.BR gfal_get_ids_python (3),
.BR gfal_set_ids_python (3),
.BR gfal_get_results_python (3),
.BR gfal_access_python (3) ,
.BR gfal_chmod_python (3) ,
.BR gfal_close_python (3) ,
.BR gfal_closedir_python (3) ,
.BR gfal_creat_python (3) ,
.BR gfal_get_timeout_connect_python (3) ,
.BR gfal_get_timeout_sendreceive_python (3) ,
.BR gfal_get_timeout_bdii_python (3) ,
.BR gfal_get_timeout_srm_python (3) ,
.BR gfal_set_timeout_connect_python (3) ,
.BR gfal_set_timeout_sendreceive_python (3) ,
.BR gfal_set_timeout_bdii_python (3) ,
.BR gfal_set_timeout_srm_python (3) ,
.BR gfal_lseek_python (3) ,
.BR gfal_mkdir_python (3) ,
.BR gfal_open_python (3) ,
.BR gfal_opendir_python (3) ,
.BR gfal_read_python (3) ,
.BR gfal_rename_python (3) ,
.BR gfal_rmdir_python (3) ,
.BR gfal_stat_python (3) ,
.BR gfal_unlink_python (3) ,
.BR gfal_write_python (3) ,
.BR gfal_set_verbose_python (3) ,
.BR gfal_get_errno_python (3) ,
