static const char* op_c_source =
"/* STRESS, Spatio Temporal Retinex Envelope with Stochastic Sampling          \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Øyvind Kolås     <oeyvindk@hig.no>                        \n"
" *                Ivar Farup       <ivarf@hig.no>                             \n"
" *                Allesandro Rizzi <rizzi@dti.unimi.it>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (radius, _(\"Radius\"), 300)                                     \n"
"    description(_(\"Neighborhood taken into account, for enhancement ideal values are close to the longest side of the image, increasing this increases the runtime\"))\n"
"    value_range (2, 6000)                                                     \n"
"    ui_range    (2, 1000)                                                     \n"
"    ui_gamma    (1.6)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_int (samples, _(\"Samples\"), 5)                                     \n"
"    description(_(\"Number of samples to do per iteration looking for the range of colors\"))\n"
"    value_range (2, 500)                                                      \n"
"    ui_range    (3, 17)                                                       \n"
"                                                                              \n"
"property_int (iterations, _(\"Iterations\"), 5)                               \n"
"    description(_(\"Number of iterations, a higher number of iterations provides a less noisy rendering at a computational cost\"))\n"
"    value_range (1, 1000)                                                     \n"
"    ui_range    (1, 30)                                                       \n"
"                                                                              \n"
"/*                                                                            \n"
"                                                                              \n"
"property_double (rgamma, _(\"Radial Gamma\"), 0.0, 8.0, 2.0,                  \n"
"                _(\"Gamma applied to radial distribution\"))                  \n"
"                                                                              \n"
"*/                                                                            \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE stress.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define RGAMMA   2.0                                                          \n"
"#define GAMMA    1.0                                                          \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"#include \"envelopes.h\"                                                      \n"
"                                                                              \n"
"static void stress (GeglBuffer          *src,                                 \n"
"                    const GeglRectangle *src_rect,                            \n"
"                    GeglBuffer          *dst,                                 \n"
"                    const GeglRectangle *dst_rect,                            \n"
"                    gint                 radius,                              \n"
"                    gint                 samples,                             \n"
"                    gint                 iterations,                          \n"
"                    gdouble              rgamma,                              \n"
"                    gint                 level)                               \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  if (dst_rect->width > 0 && dst_rect->height > 0)                            \n"
"  {                                                                           \n"
"    GeglBufferIterator *i = gegl_buffer_iterator_new (dst, dst_rect, 0, babl_format(\"RaGaBaA float\"),\n"
"                                                      GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);\n"
"    GeglSampler *sampler = gegl_buffer_sampler_new_at_level (src, format, GEGL_SAMPLER_NEAREST, level);\n"
"                                                                              \n"
"    while (gegl_buffer_iterator_next (i))                                     \n"
"    {                                                                         \n"
"      gint x,y;                                                               \n"
"      gint    dst_offset=0;                                                   \n"
"      gfloat *dst_buf = i->data[0];                                           \n"
"                                                                              \n"
"      for (y=i->roi[0].y; y < i->roi[0].y + i->roi[0].height; y++)            \n"
"        {                                                                     \n"
"          for (x=i->roi[0].x; x < i->roi[0].x + i->roi[0].width; x++)         \n"
"            {                                                                 \n"
"              gfloat  min[4];                                                 \n"
"              gfloat  max[4];                                                 \n"
"              gfloat  pixel[4];                                               \n"
"                                                                              \n"
"              compute_envelopes (src, sampler,                                \n"
"                                 x, y,                                        \n"
"                                 radius, samples,                             \n"
"                                 iterations,                                  \n"
"                                 FALSE, /* same spray */                      \n"
"                                 rgamma,                                      \n"
"                                 min, max, pixel, format);                    \n"
"              {                                                               \n"
"                /* this should be replaced with a better/faster projection of \n"
"                 * pixel onto the vector spanned by min -> max, currently     \n"
"                 * computed by comparing the distance to min with the sum     \n"
"                 * of the distance to min/max.                                \n"
"                 */                                                           \n"
"                                                                              \n"
"              gint c;                                                         \n"
"              for (c=0;c<3;c++)                                               \n"
"                {                                                             \n"
"                  gfloat delta = max[c]-min[c];                               \n"
"                  if (delta != 0)                                             \n"
"                    {                                                         \n"
"                      dst_buf[dst_offset+c] =                                 \n"
"                         (pixel[c]-min[c])/delta;                             \n"
"                    }                                                         \n"
"                  else                                                        \n"
"                    {                                                         \n"
"                      dst_buf[dst_offset+c] = 0.5;                            \n"
"                    }                                                         \n"
"                }                                                             \n"
"                                                                              \n"
"                dst_buf[dst_offset+3] = pixel[3];                             \n"
"                dst_offset+=4;                                                \n"
"              }                                                               \n"
"            }                                                                 \n"
"          }                                                                   \n"
"    }                                                                         \n"
"    g_object_unref (sampler);                                                 \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  area->left = area->right = area->top = area->bottom =                       \n"
"      ceil (GEGL_PROPERTIES (operation)->radius);                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RaGaBaA float\"));                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                     \"input\");\n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle compute;                                                      \n"
"  compute = gegl_operation_get_required_for_output (operation, \"input\",result);\n"
"                                                                              \n"
"  stress (input, &compute, output, result,                                    \n"
"          o->radius,                                                          \n"
"          o->samples,                                                         \n"
"          o->iterations,                                                      \n"
"          RGAMMA /*o->rgamma,*/, level);                                      \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static const gchar *composition =                                             \n"
"    \"<?xml version='1.0'             encoding='UTF-8'?>\"                    \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:stress'>\"                                        \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='radius'>200</param>\"                                  \n"
"    \"    <param name='iterations'>30</param>\"                               \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare  = prepare;                                        \n"
"  /* we override get_bounding_box to avoid growing the size of what is defined\n"
"   * by the filter. This also allows the tricks used to treat alpha==0 pixels \n"
"   * in the image as source data not to be skipped by the stochastic sampling \n"
"   * yielding correct edge behavior.                                          \n"
"   */                                                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",                  \"gegl:stress\",                               \n"
"    \"title\",                 _(\"Spatio Temporal Retinex-like Envelope with Stochastic Sampling\"),\n"
"    \"categories\",            \"enhance:tonemapping\",                       \n"
"    \"reference-composition\", composition,                                   \n"
"    \"description\",                                                          \n"
"        _(\"Spatio Temporal Retinex-like Envelope with Stochastic Sampling\"),\n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
