/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.engine;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IStateMachineDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IConnectionPointReference;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEntryPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IExitPointPseudoState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IRegion;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;

public class StateMachineCreator {
    private IState selectedState;

    public StateMachineCreator(IState selectedElement) {
        this.selectedState = selectedElement;
    }

    public void stateMachineSmartCreation() {
        IRegion topRegion = this.selectedState.getParent();
        IStateMachine stateMachineParent = topRegion.getRepresented();
        INameSpace creationDestination = stateMachineParent.getOwner();
        IStateMachine stateMachine = null;
        IModelingSession session = Modelio.getInstance().getModelingSession();
        stateMachine = session.getModel().createStateMachine();
        creationDestination.addOwnedBehavior((IBehavior)stateMachine);
        stateMachine.setName(this.selectedState.getName());
        this.selectedState.setSubMachine(stateMachine);
        IRegion topRegionSM = stateMachine.getTop();
        ObList points = this.selectedState.getConnection();
        for (IConnectionPointReference connectionPointReference : points) {
            ObList incomingTransition = connectionPointReference.getIncoming();
            if (incomingTransition.size() != 0) {
                IEntryPointPseudoState entry = session.getModel().createEntryPointPseudoState();
                entry.setName(connectionPointReference.getName());
                topRegionSM.addSub((IStateVertex)entry);
                connectionPointReference.setEntry(entry);
                continue;
            }
            ObList outgoingTransition = connectionPointReference.getOutGoing();
            if (outgoingTransition.size() == 0) continue;
            IExitPointPseudoState exit = session.getModel().createExitPointPseudoState();
            exit.setName(connectionPointReference.getName());
            topRegionSM.addSub((IStateVertex)exit);
            connectionPointReference.setExit(exit);
        }
        this.createDiagram(stateMachine, session);
    }

    public void createDiagram(IStateMachine stateMachine, IModelingSession session) {
        ArrayList<IStateVertex> exits = new ArrayList<IStateVertex>();
        ArrayList<IStateVertex> entries = new ArrayList<IStateVertex>();
        IRegion topRegionSM = stateMachine.getTop();
        ObList subs = topRegionSM.getSub();
        for (IStateVertex vertex : subs) {
            if (vertex instanceof IExitPointPseudoState) {
                exits.add(vertex);
                continue;
            }
            if (!(vertex instanceof IEntryPointPseudoState)) continue;
            entries.add(vertex);
        }
        try {
            IStateMachineDiagram diagram = session.getModel().createStateMachineDiagram(stateMachine.getName(), (IModelElement)stateMachine, null);
            IDiagramHandle rep = Modelio.getInstance().getDiagramService().getDiagramHandle((IAbstractDiagram)diagram);
            this.unmaskInLine(entries, new Rectangle(50, 50, 0, 0), rep);
            this.unmaskInLine(exits, new Rectangle(600, 50, 0, 0), rep);
            rep.save();
        }
        catch (StereotypeNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void unmaskInLine(List<IStateVertex> vertexes, Rectangle startBox, IDiagramHandle rep) {
        Rectangle unmaskBox = new Rectangle(startBox);
        for (IStateVertex vertex : vertexes) {
            List graphics = rep.unmask((IElement)vertex, 0, 0);
            if (graphics.size() <= 0) continue;
            IDiagramNode graphic = (IDiagramNode)graphics.get(0);
            graphic.setBounds(unmaskBox);
            Rectangle box = graphic.getBounds();
            unmaskBox.y = box.y + box.height + 50;
        }
    }
}

