/* 
 * tkMacApplication.r --
 *
 *	This file creates resources for use in the Wish application.
 *
 * Copyright (c) 1996 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tkMacApplication.r 1.2 96/10/03 17:53:57
 */

#include <Types.r>
#include <SysTypes.r>
#include <AEUserTermTypes.r>

/*
 * The folowing include and defines help construct
 * the version string for Tcl.
 */

#define RESOURCE_INCLUDED
#include "tk.h"
#include "itcl.h"
/*  #include "itkPatch.h"  */

#if (TK_RELEASE_LEVEL == 0)
#   define RELEASE_LEVEL alpha
#elif (TK_RELEASE_LEVEL == 1)
#   define RELEASE_LEVEL beta
#elif (TK_RELEASE_LEVEL == 2)
#   define RELEASE_LEVEL final
#endif

#if (TK_RELEASE_LEVEL == 2)
#   define MINOR_VERSION (ITCL_MINOR_VERSION * 16) + TK_RELEASE_SERIAL
#else
#   define MINOR_VERSION ITCL_MINOR_VERSION * 16
#endif

#define RELEASE_CODE 0x00

#define ITCL_LIBRARY_RESOURCES 3000
#define ITK_LIBRARY_RESOURCES 3500

resource 'vers' (1) {
	ITCL_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	ITCL_PATCH_LEVEL,
	ITCL_PATCH_LEVEL ", by Michael McLennan  1993-1998" "\n" "Lucent Technologies, Inc."
};

resource 'vers' (2) {
	ITCL_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	ITCL_PATCH_LEVEL,
	"ItkWish " ITCL_PATCH_LEVEL "  1993-1998"
};


#define ITK_APP_RESOURCES 128
#define ITK_APP_CREATOR 'fvEd'

/*
 * The 'BNDL' resource is the primary link between a file's
 * creator/type and its icon.  This resource acts for all Tcl shared
 * libraries; other libraries will not need one and ought to use
 * custom icons rather than new file types for a different appearance.
 */

resource 'BNDL' (ITK_APP_RESOURCES, "Itk app bundle", purgeable) 
{
	ITK_APP_CREATOR,
	0,
	{
		'FREF',
		{
			0, ITK_APP_RESOURCES,
			1, ITK_APP_RESOURCES+1,
			2, ITK_APP_RESOURCES+2,
			3, ITK_APP_RESOURCES+3
		},
		'ICN#',
		{
			0, ITK_APP_RESOURCES,
			1, ITK_APP_RESOURCES+1,
			2, ITK_APP_RESOURCES+2
		}
	}
};

resource 'FREF' (ITK_APP_RESOURCES, purgeable) 
{
	'APPL', 0, ""
};
resource 'FREF' (ITK_APP_RESOURCES+1, purgeable) 
{
	'TEXT', 1, ""
};
resource 'FREF' (ITK_APP_RESOURCES+2, purgeable) 
{
	'FITS', 2, ""
};
resource 'FREF' (ITK_APP_RESOURCES+3, purgeable) 
{
	'????', 3, ""
};

type ITK_APP_CREATOR as 'STR ';
resource ITK_APP_CREATOR (0, purgeable) {
	"ItkWish " ITCL_PATCH_LEVEL "  1993-1998"
};

/*
 * The 'kind' resource works with a 'BNDL' in Macintosh Easy Open
 * to affect the text the Finder displays in the "kind" column and
 * file info dialog.  This information will be applied to all files
 * with the listed creator and type.
 */
resource 'kind' (ITK_APP_RESOURCES, "Itcl kind", purgeable) {
	ITK_APP_CREATOR,
	0, /* region = USA */
	{
		'APPL', "ItkWish",
		'TEXT', "Itcl/Itk Script",
		'FITS', "FITS File"
	}
};

/* This resource will be picked up by tkMacMenus.c, and used for the
 * "About" entry in the Apple Menu
 */
 
resource 'STR ' (2000,"AppleMenuAboutSTR") {
	"About Itkwish"
};


/*
 * The following resource define the icon used by Tcl scripts.  Any
 * TEXT file with the creator of WIsH will get this icon.
 */

data 'icl8' (ITK_APP_RESOURCES + 1, "Itk Doc", purgeable) {
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF FF00 0000 0000 0000 0000"            /* .............. */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6FF 00FF 0000 0000 0000 0000"            /* ......... */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6FF 00F6 FF00 0000 0000 0000"            /* ........ */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6FF 00F6 F6FF 0000 0000 0000"            /* ....... */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6FF F8F8 F8F8 FF00 0000 0000"            /* ..... */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6FF FFFF FFFF FFFF 0000 0000"            /* .... */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F8FF 0000 0000"            /* .... */
	$"0000 00FF 00F6 F6F6 F65F B3B3 B35F F6F6"            /* ....__ */
	$"5FB3 B3B3 B35F F6F6 F6F6 F8FF 0000 0000"            /* __.... */
	$"0000 00FF 00F6 F6F6 5F89 8989 8989 89B3"            /* ...._ */
	$"8989 8989 8989 B35F F6F6 F8FF 0000 0000"            /* _.... */
	$"0000 00FF 00F6 F65F 3489 B3B3 B389 B389"            /* ...._4ђђ */
	$"89B3 B3B3 895F 89B3 5FF6 F8FF 0000 0000"            /* ђ__.... */
	$"0000 00FF 00F6 F634 8900 0000 0034 8989"            /* ....4....4 */
	$"3400 0000 00B3 5F89 B334 F8FF 0000 0000"            /* 4...._4.... */
	$"0000 00FF 00F6 5F89 0000 0000 0000 3434"            /* ...._......44 */
	$"0000 0000 0000 B389 895F F8FF 0000 0000"            /* ......ђ_.... */
	$"0000 00FF 00F6 8934 0000 0000 F500 0000"            /* ....4....... */
	$"0000 0000 0000 34B3 89B3 F8FF 0000 0000"            /* ......4ђ.... */
	$"0000 00FF 00F6 B300 0000 F501 0100 0000"            /* ............ */
	$"0000 0000 0000 00B3 89B3 F8FF 0000 0000"            /* .......ђ.... */
	$"0000 00FF 00F6 8934 0000 00F7 0000 00F7"            /* ....4...... */
	$"0101 0100 0000 3489 89B3 F8FF 0000 0000"            /* ......4.... */
	$"0000 00FF 00F6 F6B3 3400 0000 0000 0000"            /* ....4....... */
	$"F701 F500 0034 B389 B3F6 F8FF 0000 0000"            /* ...4ђ.... */
	$"0000 00FF 00F6 F6F6 8934 0000 0000 0000"            /* ....4...... */
	$"0000 F700 3489 895F F6F6 F8FF 0000 0000"            /* ...4_.... */
	$"0000 00FF 00F6 F6F6 B334 0000 0000 0000"            /* ....4...... */
	$"0000 0000 34B3 89B3 F6F6 F8FF 0000 0000"            /* ....4ђ.... */
	$"0000 00FF 00F6 F634 8900 0000 0001 0000"            /* ....4....... */
	$"0000 0000 0089 3489 B3F6 F8FF 0000 0000"            /* .....4.... */
	$"0000 00FF 00F6 F689 0000 0000 F701 F500"            /* .......... */
	$"0000 0000 0000 8989 B3F6 F8FF 0000 0000"            /* .......... */
	$"0000 00FF 00F6 F6B3 0000 0000 00F7 0000"            /* ........... */
	$"0000 0000 0000 B389 B3F6 F8FF 0000 0000"            /* ......ђ.... */
	$"0000 00FF 00F6 F689 0000 0000 0000 0000"            /* ............ */
	$"0001 0000 0000 8989 B3F6 F8FF 0000 0000"            /* .......... */
	$"0000 00FF 00F6 F6B3 0000 0000 0101 0000"            /* ............ */
	$"F701 0101 0000 B389 B3F6 F8FF 0000 0000"            /* .....ђ.... */
	$"0000 00FF 00F6 F6B3 0000 0101 01F5 0000"            /* ........... */
	$"00F7 01F5 0000 B389 B3F6 F8FF 0000 0000"            /* ....ђ.... */
	$"0000 00FF 00F6 F689 0000 01F5 0100 0000"            /* ........... */
	$"00F5 F5F5 0000 8989 B3F6 F8FF 0000 0000"            /* ....... */
	$"0000 00FF 00F6 F6B3 0000 F7F7 0000 0000"            /* .......... */
	$"0000 0000 0000 B389 B3F6 F8FF 0000 0000"            /* ......ђ.... */
	$"0000 00FF 00F6 F634 8900 0000 0000 0000"            /* ....4....... */
	$"0000 0000 0089 5FB3 34F6 F8FF 0000 0000"            /* ....._4.... */
	$"0000 00FF 00F6 F6F6 34B3 89B3 B3B3 B3B3"            /* ....4ђ */
	$"B389 B3B3 8934 34F6 F6F6 F8FF 0000 0000"            /* ђђ44.... */
	$"0000 00FF 00F6 F6F6 F6F6 F6F6 F6F6 F6F6"            /* .... */
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F8FF 0000 0000"            /* .... */
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8"            /* ... */
	$"F8F8 F8F8 F8F8 F8F8 F8F8 F8FF 0000 0000"            /* .... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* .... */
};
data 'ics8' (ITK_APP_RESOURCES + 1, "Itk Doc", purgeable) {
	$"00FF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* ..... */
	$"00FF F6F6 F6F6 F6F6 F6F6 FFFF FF00 0000"            /* .... */
	$"00FF F6F6 F6F6 F6F6 F6F6 FFF8 FFFF 0000"            /* ... */
	$"00FF F6F6 F6F6 F6F6 F6F6 FFFF FFFF 0000"            /* ... */
	$"00FF F6F6 F6B3 B3F6 B3B3 B3F6 F6FF 0000"            /* ... */
	$"00FF F6F6 89B3 B3B3 B3B3 B3B3 F6FF 0000"            /* .℄.. */
	$"00FF F689 0000 F534 0000 00B3 B3FF 0000"            /* ...4..... */
	$"00FF F6B3 00F7 01F7 0101 0034 B3FF 0000"            /* ......4.. */
	$"00FF F6F6 8900 0000 F7F7 89B3 F6FF 0000"            /* ....№.. */
	$"00FF F6F6 B300 0100 0000 F7B3 F6FF 0000"            /* ........ */
	$"00FF F6F6 B300 F7F5 0000 00B3 F6FF 0000"            /* ....... */
	$"00FF F6F6 B300 0100 F701 00B3 F6FF 0000"            /* ........ */
	$"00FF F6F6 B3F5 F500 F7F5 00B3 F6FF 0000"            /* ..... */
	$"00FF F6F6 B3B3 B3B3 B3B3 B3B3 F6FF 0000"            /* ... */
	$"00FF F6F6 F6F6 F6F6 F6F6 F6F6 F6FF 0000"            /* ... */
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* ... */
};
data 'ICN#' (ITK_APP_RESOURCES + 1, "Itk Doc", purgeable) {
	$"1FFF FC00 1000 0600 1000 0500 1000 0480"            /* ............. */
	$"1000 0440 1000 0420 1000 07F0 1000 0010"            /* ...@... ....... */
	$"107C FC10 10FF FF10 117F FF90 1083 0790"            /* .|....... */
	$"1300 03D0 1200 01D0 1200 01D0 1200 01D0"            /* ............ */
	$"1100 0390 1080 0710 1080 0710 1080 0590"            /* ........... */
	$"1100 0390 1100 0390 1100 0390 1100 0390"            /* ............ */
	$"1100 0390 1100 0390 1100 0390 1080 0710"            /* ............ */
	$"107F F810 1000 0010 1000 0010 1FFF FFF0"            /* ............ */
	$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80"            /* ....... */
	$"1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
};
data 'ics#' (ITK_APP_RESOURCES + 1, "Itk Doc", purgeable) {
	$"7FF0 4038 402C 403C 46E4 4FF4 5014 5014"            /* .@8@,@<FOP.P. */
	$"4824 4834 5014 5014 5014 5FF4 4004 7FFC"            /* H$H4P.P.P._@.. */
	$"7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"            /* ........ */
	$"7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"            /* ........ */
};
/* 
 * The following resources define the icons for the Wish
 * application.
 */
data 'ICN#' (ITK_APP_RESOURCES, "Itk App", purgeable) {
	$"0007 E000 0018 1800 0060 0700 0380 00E0"            /* ........`.... */
	$"0C00 0018 3000 0006 4000 0001 8000 0001"            /* ....0...@...... */
	$"8000 0001 8000 0001 8000 0001 8000 FC01"            /* ........... */
	$"8001 8F01 8003 0C01 8003 1801 8003 1801"            /* ........... */
	$"8001 B001 8000 6001 8000 6001 8003 F001"            /* ...`..`... */
	$"8000 C001 8001 8CC1 8001 8CC1 8073 1CC1"            /* ....s. */
	$"80C6 39F1 80C6 19E1 818C 3301 8198 3E01"            /* Đ9Đ.3.>. */
	$"80F0 3801 8000 0001 FFFF FFFF 0000 0000"            /* ĕ8........ */
	$"0007 E000 001F F800 007F FF00 03FF FFE0"            /* .......... */
	$"0FFF FFF8 3FFF FFFE 7FFF FFFF FFFF FFFF"            /* .?. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* .... */
};
data 'ics#' (ITK_APP_RESOURCES, "Itk App", purgeable) {
	$"07E0 1C3C 6007 8001 8001 80E1 8131 8101"            /* ..<`...ķ1. */
	$"8101 8181 8101 8129 8919 9E71 8C61 FFFF"            /* ..).qa */
	$"07E0 1FFC 7FFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
};
data 'ics8' (ITK_APP_RESOURCES, "Itk App", purgeable) {
	$"0000 0000 00FF FFFF FFFF FF00 0000 0000"            /* .......... */
	$"0000 00FF FFFF 05E2 E205 FFFF FFFF 0000"            /* ....... */
	$"00FF FF05 05E2 E2E2 E2E2 E205 05FF FFFF"            /* ..... */
	$"FF05 05E2 E2E2 E2E2 E2E2 E2E2 E2E2 05FF"            /* ... */
	$"FF05 0505 0505 0505 0505 0505 0505 05FF"            /* .............. */
	$"FFE2 E205 E2E2 E205 1D1D 1D05 E2E2 E2FF"            /* ...... */
	$"FFE2 E205 E2E2 E205 1DE2 1D05 E2E2 E2FF"            /* ..... */
	$"FFE2 E205 E2E2 E21D E2E2 E205 E2E2 E2FF"            /* ... */
	$"FFE2 E205 E2E2 E21D E2E2 E205 E2E2 E2FF"            /* ... */
	$"FFE2 E205 E2E2 1D1D 1DE2 E205 E2E2 E2FF"            /* ..... */
	$"FFE2 E205 E2E2 E21D E2E2 1D05 1DE2 E2FF"            /* ..... */
	$"FFE2 E205 E2E2 E21D E2E2 1D05 1DE2 E2FF"            /* ..... */
	$"FFE2 E205 05E2 1D05 E2E2 1D05 1DE2 E2FF"            /* ....... */
	$"FF05 0505 1D1D 1D05 0505 051D 0505 05FF"            /* .............. */
	$"FF05 0505 1D1D 0505 0505 1D05 0505 05FF"            /* .............. */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
};
data 'icl8' (ITK_APP_RESOURCES, "Itk App", purgeable) {
	$"0000 0000 0000 0000 0000 0000 00FF FFFF"            /* ............. */
	$"FFFF FF00 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 0000 0000 00FF FF05 0505"            /* .............. */
	$"0505 05FF FF00 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 00FF FF05 0505 0505"            /* .............. */
	$"0505 0505 05FF FFFF 0000 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 FFFF FF05 0505 0505 E2E2"            /* ........... */
	$"E205 0505 0505 0505 FFFF FF00 0000 0000"            /* ............ */
	$"0000 0000 FFFF 0505 0505 0505 E2E2 E2E2"            /* .......... */
	$"E2E2 E205 0505 0505 0505 05FF FF00 0000"            /* ........... */
	$"0000 FFFF 0505 0505 0505 E2E2 E2E2 E2E2"            /* ........ */
	$"E2E2 E2E2 E2E2 0505 0505 0505 05FF FF00"            /* ........ */
	$"00FF 0505 0505 0505 E2E2 E2E2 E2E2 E2E2"            /* ....... */
	$"E2E2 E2E2 E2E2 E2E2 0505 0505 0505 05FF"            /* ....... */
	$"FF05 0505 0505 E2E2 E2E2 E2E2 E2E2 E2E2"            /* ..... */
	$"E2E2 E2E2 E2E2 E2E2 E2E2 E205 0505 05FF"            /* .... */
	$"FF05 0505 0505 0505 0505 0505 0505 0505"            /* ............... */
	$"0505 0505 0505 0505 0505 0505 0505 05FF"            /* ............... */
	$"FF05 0505 0505 0505 0505 0505 0505 0505"            /* ............... */
	$"0505 0505 0505 0505 0505 0505 0505 05FF"            /* ............... */
	$"FF05 0505 0505 0505 0505 0505 0505 0505"            /* ............... */
	$"0505 0505 0505 0505 0505 0505 0505 05FF"            /* ............... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 0505"            /* ....... */
	$"1D1D 1D1D 1D1D 0505 05E2 E2E2 E2E2 05FF"            /* .......... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 051D"            /* ....... */
	$"1DE2 E2E2 1D1D 1D1D 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 1D1D"            /* ....... */
	$"05E2 E2E2 1D1D 0505 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 1D1D"            /* ....... */
	$"05E2 E21D 1DE2 0505 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 1D1D"            /* ....... */
	$"05E2 E21D 1DE2 0505 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 051D"            /* ....... */
	$"1DE2 1D1D E2E2 0505 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 0505"            /* ....... */
	$"051D 1DE2 E2E2 0505 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 0505"            /* ....... */
	$"051D 1DE2 E2E2 0505 05E2 E2E2 E2E2 05FF"            /* ....... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 1D1D"            /* ....... */
	$"1D1D 1D1D E2E2 0505 05E2 E2E2 E2E2 05FF"            /* ........ */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 0505"            /* ....... */
	$"1D1D E2E2 E2E2 0505 05E2 E2E2 E2E2 05FF"            /* ...... */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 051D"            /* ....... */
	$"1DE2 E2E2 1D1D 0505 1D1D E2E2 E2E2 05FF"            /* ........ */
	$"FF05 E2E2 E205 0505 E2E2 E2E2 E205 051D"            /* ....... */
	$"1DE2 E2E2 1D1D 0505 1D1D E2E2 E2E2 05FF"            /* ........ */
	$"FF05 E2E2 E205 0505 E21D 1D1D E205 1D1D"            /* .......... */
	$"05E2 E21D 1D1D 0505 1D1D E2E2 E2E2 05FF"            /* ......... */
	$"FF05 E2E2 E205 0505 1D1D E2E2 E21D 1D05"            /* ......... */
	$"05E2 1D1D 1DE2 051D 1D1D 1D1D E2E2 05FF"            /* ........... */
	$"FF05 E2E2 E205 0505 1D1D E2E2 E21D 1D05"            /* ......... */
	$"05E2 E21D 1DE2 051D 1D1D 1DE2 E2E2 05FF"            /* ......... */
	$"FF05 0505 0505 051D 1D05 0505 1D1D 0505"            /* ............... */
	$"0505 1D1D 0505 1D1D 0505 0505 0505 05FF"            /* ............... */
	$"FF05 0505 0505 051D 1D05 051D 1D05 0505"            /* ............... */
	$"0505 1D1D 1D1D 1D05 0505 0505 0505 05FF"            /* ............... */
	$"FF05 0505 0505 0505 1D1D 1D1D 0505 0505"            /* ............... */
	$"0505 1D1D 1D05 0505 0505 0505 0505 05FF"            /* ............... */
	$"FF05 0505 0505 0505 0505 0505 0505 0505"            /* ............... */
	$"0505 0505 0505 0505 0505 0505 0505 05FF"            /* ............... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
};
/*
 * The following resource define the icon used for FITS files.  Any
 * FITS file with the creator of fvEd will get this icon.
 */

data 'icl8' (ITK_APP_RESOURCES+2, "FITS File", purgeable) {
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"            /* .......... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF FF00 0000 0000 0000 0000"            /* .............. */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF 00FF 0000 0000 0000 0000"            /* .............. */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF 0000 FF00 0000 0000 0000"            /* .............. */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF 0000 00FF 0000 0000 0000"            /* .............. */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF 0000 0000 FF00 0000 0000"            /* .............. */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 00FF FFFF FFFF FFFF 0000 0000"            /* ......... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 00D8 D8D8 D8D8 D800 D8D8 D800"            /* ...... */
	$"D8D8 D8D8 D800 D8D8 D800 00FF 0000 0000"            /* ....... */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 00D8 0000 00D8 00FF 0000 0000"            /* ............ */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 00D8 0000 0000 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 00D8 0000 0000 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 00D8 0000 0000 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 D8D8 D800 0000 00D8 0000"            /* .......... */
	$"0000 D800 00D8 0000 0000 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 0000 D8D8 D800 00FF 0000 0000"            /* ........... */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 0000 0000 00D8 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 0000 0000 00D8 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 0000 0000 00D8 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 0000 0000 00D8 00FF 0000 0000"            /* ............. */
	$"0000 00FF 00D8 0000 0000 0000 00D8 0000"            /* ............. */
	$"0000 D800 00D8 0000 00D8 00FF 0000 0000"            /* ............ */
	$"0000 00FF 00D8 0000 0000 0000 D8D8 D800"            /* ........... */
	$"0000 D800 0000 D8D8 D800 00FF 0000 0000"            /* ........... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF 0000 0000 0000 0000 0000 0000"            /* ............... */
	$"0000 0000 0000 0000 0000 00FF 0000 0000"            /* ............... */
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* .... */
};
data 'ics8' (ITK_APP_RESOURCES+2, "FITS File", purgeable) {
	$"00FF FFFF FFFF FFFF FFFF FFFF 0000 0000"            /* ..... */
	$"00FF 0000 0000 0000 0000 FFFF FF00 0000"            /* ............ */
	$"00FF 0000 0000 0000 0000 FF00 FFFF 0000"            /* ............ */
	$"00FF 0000 0000 0000 0000 FFFF FFFF 0000"            /* ........... */
	$"00FF 0000 0000 0000 0000 0000 00FF 0000"            /* .............. */
	$"00FF D8D8 D800 D8D8 D8D8 00D8 00FF 0000"            /* ...... */
	$"00FF D800 0000 D800 D800 D800 D8FF 0000"            /* ......... */
	$"00FF D800 0000 D800 D800 D800 00FF 0000"            /* .......... */
	$"00FF D8D8 D800 D800 D800 00D8 00FF 0000"            /* ........ */
	$"00FF D800 0000 D800 D800 0000 D8FF 0000"            /* .......... */
	$"00FF D800 0000 D800 D800 D800 D8FF 0000"            /* ......... */
	$"00FF D800 0000 D800 D800 00D8 00FF 0000"            /* .......... */
	$"00FF 0000 0000 0000 0000 0000 00FF 0000"            /* .............. */
	$"00FF 0000 0000 0000 0000 0000 00FF 0000"            /* .............. */
	$"00FF 0000 0000 0000 0000 0000 00FF 0000"            /* .............. */
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF 0000"            /* ... */
};
data 'ICN#' (ITK_APP_RESOURCES+2, "FITS File", purgeable) {
	$"1FFF FC00 1000 0600 1000 0500 1000 0480"            /* ............. */
	$"1000 0440 1000 0420 1000 07F0 1000 0010"            /* ...@... ....... */
	$"1000 0010 1000 0010 1000 0010 17EE FB90"            /* .............Ӛ */
	$"1404 2450 1404 2410 1404 2410 1404 2410"            /* ..$P..$...$...$. */
	$"1784 2410 1404 2390 1404 2050 1404 2050"            /* .$...#.. P.. P */
	$"1404 2050 1404 2050 1404 2450 140E 2390"            /* .. P.. P..$P..# */
	$"1000 0010 1000 0010 1000 0010 1000 0010"            /* ................ */
	$"1000 0010 1000 0010 1000 0010 1FFF FFF0"            /* ............. */
	$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80"            /* ....... */
	$"1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
	$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"            /* .... */
};
data 'ics#' (ITK_APP_RESOURCES+2, "FITS File", purgeable) {
	$"7FF0 4038 402C 403C 4004 7FFC 626C 6264"            /* .@8@,@<@..blbd */
	$"7A7C 624C 624C 637C 4004 4004 4004 7FFC"            /* z|bLbLc|@.@.@.. */
	$"7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"            /* ........ */
	$"7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"            /* ........ */
};

/*
 * The following resource is used when creating the 'env' variable in
 * the Macintosh environment.  The creation mechanisim looks for the
 * 'STR#' resource named "Tcl Environment Variables" rather than a
 * specific resource number.  (In other words, feel free to change the
 * resource id if it conflicts with your application.)  Each string in
 * the resource must be of the form "KEYWORD=SOME STRING".  See Tcl
 * documentation for futher information about the env variable.
 */
 
/* A good example of something you may want to set is:
 * "TCL_LIBRARY=My disk:etc." 
 */
		
resource 'STR#' (128, "Tcl Environment Variables") {
	{	"SCHEDULE_NAME=Agent Controller Schedule",
		"SCHEDULE_PATH=Lozoya:System Folder:Tcl Lib:Tcl-Scheduler"
	};
};
/*
 * The following resources defines the Apple Events that Tk can be
 * sent from Apple Script.
 */
resource 'aete' (0, "Wish Suite") {
    0x01, 0x00, english, roman,
    {
	"Required Suite", 
	"Events that every application should support", 
	'reqd', 1, 1,
	{},
	{},
	{},
	{},
	"Wish Suite", "Events for the Wish application", 'WIsH', 1, 1,
	{
	    "do script", "Execute a Tcl script", 'misc', 'dosc',
	    'TEXT', "Result", replyOptional, singleItem,
	    notEnumerated, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, 
	    'TEXT', "Script to execute", directParamRequired,
	    singleItem, notEnumerated, changesState, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, reserved, reserved, reserved, reserved,
	    reserved, 
	    {},
	},
	{},
	{},
	{},
    }
};

/*
 * The following two resources define the default "About Box" for Mac Tk.
 * This dialog appears if the "About Tk..." menu item is selected from
 * the Apple menu.  This dialog may be overridden by defining a Tcl procedure
 * with the name of "tkAboutDialog".  If this procedure is defined the
 * default dialog will not be shown and the Tcl procedure is expected to
 * create and manage an About Dialog box.
 */
data 'DLOG' (128, "Default About Box", purgeable) {
	$"002E 0026 011B 01E0 0001 0100 0100 0000"            
	$"0000 0081 00"                                       
};
 

resource 'DITL' (129, "About Box", purgeable) {
    {
	{198, 278, 220, 362}, Button	    {enabled, "Ok"},
	{ 21, 205, 181, 442}, StaticText    {disabled, 
	    "ItkWish" ITCL_PATCH_LEVEL " - an Object-Oriented Wish" 
	    "\n\n" "Michael McLennan" 
	     "\n" "Jim Ingham" "\n" "Lee Bernhard" "\n\n"
	    "Lucent Technologies, Inc. 1993-1998" "\n\n" "For more Info, see:" "\n" 
	    "http://www.tcltk.com/itcl"},	    
        { 37,  22, 204, 182}, Picture  {enabled, 128}
    }
};

data 'PICT' (128) {
	$"46B2 0000 0000 00A7 00A0 0011 02FF 0C00"            
	$"FFFE 0000 0048 0000 0048 0000 0000 0000"            
	$"00A7 00A0 0000 0000 001E 0001 000A 0000"            
	$"0000 00A7 00A0 0099 80A0 0000 0000 00A7"            
	$"00A0 0000 0000 0000 0000 0048 0000 0048"            
	$"0000 0000 0008 0001 0008 0000 0000 0157"            
	$"9668 0000 0000 0000 8746 8000 00FF 0004"            
	$"F800 FC00 F800 0066 F800 F800 F800 015D"            
	$"F000 F400 F000 0000 F000 F000 F000 0000"            
	$"E800 EC00 E800 01C1 E800 E800 E800 0000"            
	$"E000 E400 E000 011E E000 E000 E000 01C3"            
	$"D800 DC00 D800 0000 D800 D800 D800 0000"            
	$"D000 D400 D000 0000 D000 D000 D000 0000"            
	$"C800 C800 C800 0000 C000 C400 C000 0000"            
	$"C000 C000 C000 0000 B800 BC00 B800 0000"            
	$"B800 B800 B800 0000 B000 B400 B000 0000"            
	$"B000 B000 B000 0000 A800 AC00 A800 0000"            
	$"A800 A800 A800 0000 A000 A400 A000 0000"            
	$"A000 A000 9800 0000 A000 A000 A000 0000"            
	$"9800 9C00 9800 0000 9800 9800 9800 0000"            
	$"9000 9400 9000 0000 8800 8C00 8800 0000"            
	$"8800 8800 8800 0000 8800 8400 8000 0000"            
	$"8800 A000 5800 0000 8000 8400 8000 0000"            
	$"8000 9C00 5800 0000 7800 8C00 6000 0000"            
	$"7800 7C00 7800 0000 7800 7800 7800 0000"            
	$"7000 8000 6000 0000 7000 7400 7000 0000"            
	$"7000 7000 6800 0000 7000 7800 5800 0000"            
	$"6800 6C00 6800 0000 6800 6800 6800 0000"            
	$"6000 6400 6000 0000 6000 6C00 5000 0000"            
	$"6000 6000 6000 0000 5800 6400 5000 0000"            
	$"5800 5C00 5800 0000 5800 5800 5800 0000"            
	$"5000 5400 5000 0000 5000 9800 4000 0000"            
	$"5000 5400 4800 0000 5000 A800 4000 0000"            
	$"5000 5000 5000 0000 5000 8800 4000 0000"            
	$"5000 B400 3800 0000 4800 7C00 4000 0000"            
	$"4800 4C00 4800 0000 4800 4800 4800 0000"            
	$"4800 C000 3000 0000 4800 6C00 4000 0000"            
	$"4000 4800 4000 0000 4000 4400 4000 0000"            
	$"4000 4000 4000 0000 4000 9000 3800 0000"            
	$"4000 CC00 2800 0000 4000 8400 3800 0000"            
	$"4000 9800 3000 0000 4000 7400 3800 0000"            
	$"4000 5C00 3800 0000 3800 8000 3800 0000"            
	$"3800 3C00 3800 0000 3800 3800 3800 0000"            
	$"3800 6400 3800 0000 3800 A800 3000 0000"            
	$"3800 3800 3000 0000 3800 5000 3000 0000"            
	$"3800 C400 2800 0000 3000 D800 2000 0000"            
	$"3000 4800 3000 0000 3000 3400 3000 0000"            
	$"3000 BC00 2800 0000 3000 3000 3000 0000"            
	$"3000 4400 3000 0000 2800 2C00 2800 0000"            
	$"2800 3800 2800 0000 2800 E400 1800 0000"            
	$"2800 A800 2000 0000 2800 2800 2800 0000"            
	$"2800 CC00 2000 0000 2800 AC00 2000 4D61"            
	$"2800 7000 2000 015D 2800 3800 2000 0001"            
	$"2000 2C00 2000 015D 2000 D400 1800 0000"            
	$"2000 B000 2000 015A 2000 9C00 1800 015A"            
	$"2000 2400 2000 0000 2000 2000 2000 0003"            
	$"2000 D800 1800 0066 2000 4C00 1800 025B"            
	$"2000 B800 1800 0000 2000 A800 1800 0010"            
	$"2000 8C00 2000 015D 2000 B400 1800 0000"            
	$"1800 EC00 1000 0000 1800 E800 1000 015D"            
	$"1800 C000 1800 0000 1800 3800 1800 0000"            
	$"1800 1C00 1800 0000 1800 DC00 1800 0000"            
	$"1800 8C00 1800 7400 1800 7400 1800 0159"            
	$"1800 E000 1000 0000 1800 2C00 1000 0003"            
	$"1800 1800 1800 0066 1800 CC00 1000 015D"            
	$"1800 E400 1000 0004 1000 EC00 1000 0066"            
	$"1000 F000 0800 015D 1000 E400 1000 0000"            
	$"1000 9000 1000 0000 1000 2400 1000 01C1"            
	$"1000 EC00 0800 0000 1000 3400 1000 011E"            
	$"1000 E800 0800 01C3 1000 E000 1000 0000"            
	$"1000 4C00 1000 0000 1000 2000 1000 0000"            
	$"1000 1000 1000 0000 1000 5C00 1000 0000"            
	$"1000 5800 1000 0000 1000 1000 0800 0000"            
	$"1000 6400 1000 0000 0800 F400 0000 0000"            
	$"0800 7000 0800 0000 0800 1400 0800 0000"            
	$"0800 F400 0800 0000 0800 8000 0800 0000"            
	$"0800 8800 0800 0000 0800 EC00 0800 0000"            
	$"0800 0800 0800 0000 0000 F400 0000 0000"            
	$"0000 FC00 0000 0000 0000 F800 0000 0000"            
	$"0000 0400 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 5845"            
	$"0000 0000 0000 015C 0000 0000 0000 0001"            
	$"0000 0000 0000 015D 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 0D09"            
	$"0000 0000 0000 0000 0000 0000 0000 055E"            
	$"0000 0000 0000 0106 0000 0000 0000 0054"            
	$"0000 0000 0000 013B 0000 0000 0000 20F9"            
	$"0000 0000 0000 005C 0000 0000 0000 0002"            
	$"0000 0000 0000 20FC 0000 0000 0000 0064"            
	$"0000 0000 0000 00E5 0000 0000 0000 015D"            
	$"0000 0000 0000 0000 0000 0000 0000 067E"            
	$"0000 0000 0000 0159 0000 0000 0000 0000"            
	$"0000 0000 0000 0003 0000 0000 0000 0066"            
	$"0000 0000 0000 015D 0000 0000 0000 0004"            
	$"0000 0000 0000 0066 0000 0000 0000 015D"            
	$"0000 0000 0000 0000 0000 0000 0000 0000"            
	$"0000 0000 0000 015D 0000 0000 0000 0000"            
	$"0000 0000 0000 0000 0000 0000 0000 5400"            
	$"0000 0000 0000 6F64 0000 0000 0000 6573"            
	$"0000 0000 0000 4B65 0000 0000 0000 0000"            
	$"0000 0000 0000 5074 0000 0000 0000 4572"            
	$"0000 0000 0000 646C 0000 0000 0000 6972"            
	$"0000 0000 0000 6573 0000 0000 0000 7374"            
	$"0000 0000 0000 7400 0000 0000 0000 7200"            
	$"0000 0000 0000 7243 0000 0000 0000 6572"            
	$"0000 0000 0000 6300 0000 0000 0000 6E74"            
	$"0000 0000 0000 3064 0000 0000 0000 6F75"            
	$"0000 0000 0000 6F6D 0000 0000 0000 0002"            
	$"0000 0000 0000 6E64 0000 0000 0000 636F"            
	$"0000 0000 0000 6572 0000 0000 0000 6567"            
	$"0000 0000 0000 726F 0000 0000 0000 0720"            
	$"0000 0000 0000 6550 0000 0000 0000 7900"            
	$"0000 0000 0000 6374 0000 0000 0000 6F50"            
	$"0000 0000 0000 6B53 0000 0000 0000 6F6E"            
	$"0000 0000 0000 E86D 0000 0000 0000 6541"            
	$"0000 0000 0000 696E 0000 0000 0000 0003"            
	$"0000 0000 0000 7473 0000 0000 0000 1E74"            
	$"0000 0000 0000 6D70 0000 0000 0000 D274"            
	$"0000 0000 0000 6D00 0000 0000 0000 6F75"            
	$"0000 0000 0000 4174 0000 0000 0000 7070"            
	$"0000 0000 0000 6F6E 0000 0000 0000 CD77"            
	$"0000 0000 0000 746F 0000 0000 0000 0000"            
	$"0000 00A7 00A0 0000 0000 00A7 00A0 0000"            
	$"000A 0000 0000 00A7 00A0 0481 00E1 0004"            
	$"8100 E100 A27F 0000 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 1F01 0001 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 0001 0001 009F FE00 7F01 0001 0001"            
	$"0C22 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2018 2220 2220"            
	$"2220 2220 2220 2220 2220 2220 2220 2220"            
	$"2208 0001 01FD 0014 0200 0001 FC00 0020"            
	$"818E F28E 0408 0606 0101 FE00 15FD 0000"            
	$"01FE 0000 2281 8EF2 8E07 0C0A 0805 0101"            
	$"0000 1708 0000 0100 0001 0002 2081 8EF2"            
	$"8E07 1411 0C0A 0501 0100 16FE 0000 01FE"            
	$"0001 0222 818E F28E 071F 1912 0C05 0401"            
	$"0017 0800 0001 0001 0000 0220 818E F28E"            
	$"0728 1F19 0F08 0501 0014 FC00 0301 0002"            
	$"2281 8EF2 8E07 2F23 1B11 0905 0100 1708"            
	$"0000 0100 0100 0002 2081 8EF2 8E07 2F28"            
	$"1B11 0A05 0100 27FE 0000 01FE 0001 0222"            
	$"C58E 0F5D 6578 6F5A 5254 5254 524E 5A78"            
	$"7867 77BE 8E07 3828 1F12 0A05 0100 2B08"            
	$"0000 0100 0001 0002 20C8 8E01 584B FD6C"            
	$"0172 72FB 6C08 726C 726C 7260 4549 6DC2"            
	$"8E07 3828 1C12 0A05 0100 26FD 0004 0100"            
	$"0002 22CA 8E03 5060 6C6C F172 086C 726C"            
	$"726C 7253 4449 C68E 0738 281C 120A 0501"            
	$"0042 0200 0001 FD00 0102 20D3 8E21 5D78"            
	$"5A4B 7868 6A66 6072 6C72 6C72 6C6C 3E22"            
	$"1912 1213 141B 2547 726C 7272 6C72 6C72"            
	$"FE6C 0572 6C54 6F65 77CB 8E07 3828 1C12"            
	$"0A05 0100 3AFE 0005 0100 0100 0222 D58E"            
	$"0250 5472 FC6C FC72 046C 726C 6C0C F700"            
	$"0708 236C 6C72 6C72 6CFE 7207 6C72 6C72"            
	$"6C72 545D CD8E 0738 281C 120A 0501 0047"            
	$"0800 0001 0001 0000 0220 D98E 175D 6563"            
	$"6C6C 726C 7260 3D60 6C72 726C 726C 726C"            
	$"7272 471B 05F7 0013 081C 3872 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C4E 7877 D08E 0738"            
	$"281C 120A 0501 0049 FA00 0102 22DA 8E01"            
	$"5A72 FE6C 0E72 6C3E 0F01 0007 3E72 6C72"            
	$"6C72 6C72 FE6C 0972 610C 0100 0100 0100"            
	$"01FC 0011 1B72 6C72 6C72 6C72 281B 5172"            
	$"6C72 6C72 6C41 D18E 0738 281C 120A 0501"            
	$"0049 0800 0001 0001 0000 0220 DC8E 085D"            
	$"536C 7272 6C6C 3E0F FC00 0301 0C51 6CFE"            
	$"7200 6CFD 7203 6C72 2E03 F700 1201 1B6C"            
	$"7272 6C72 6C60 0800 2351 6C72 726C 725A"            
	$"D28E 0738 281C 120A 0501 004E FE00 0501"            
	$"0001 0002 22DE 8E08 676F 606C 7251 2A14"            
	$"04F8 0008 0419 386C 7272 6C72 6CFD 7208"            
	$"4719 0300 0100 0100 01FD 0002 1051 6CFD"            
	$"720C 6C12 0001 122E 6072 6C72 536F 75D5"            
	$"8E07 3828 1C12 0A05 0100 5202 0000 01FD"            
	$"0001 0220 DF8E 065A 6C72 6C72 1F01 FB00"            
	$"0201 0001 FB00 020C 476C FE72 026C 726C"            
	$"FE72 016C 0EFE 0002 0100 01FD 0004 012A"            
	$"6C72 6CFE 7200 11FE 0007 0138 7272 6C6C"            
	$"5377 D68E 0738 281C 120A 0501 0056 FD00"            
	$"0401 0000 0222 E28E 0776 7854 6C72 6C22"            
	$"05FB 0007 0100 0001 0001 0001 FD00 0E01"            
	$"122E 6072 726C 726C 726C 726C 1F07 FC00"            
	$"0001 FD00 131F 7272 6C72 6C72 2804 0000"            
	$"0119 3E6C 6C72 724B 73D8 8E07 3828 1C12"            
	$"0A05 0100 5608 0000 0100 0001 0002 20E2"            
	$"8E05 4B6C 6C72 2A01 FB00 0301 0000 01FD"            
	$"0000 01F9 001A 0138 7272 6C72 6C72 6C72"            
	$"7246 0100 0100 0100 0001 0000 0122 7272"            
	$"6CFE 7200 2AFD 0003 033E 7272 FE6C 0050"            
	$"D98E 0738 281C 120A 0501 0059 FE00 0001"            
	$"FE00 0102 22E3 8E05 4E6C 6C72 2801 FB00"            
	$"0701 0001 0000 0100 01FE 0002 0100 01FB"            
	$"0010 2E72 726C 726C 726C 7272 5108 0001"            
	$"0000 01FD 0008 0123 6C72 6C72 6C6C 07FD"            
	$"0007 0123 6C72 6C72 6C5D DA8E 0738 281C"            
	$"120A 0501 0061 0800 0001 0001 0000 0220"            
	$"E58E 0667 6372 6C2E 1901 FE00 0201 0001"            
	$"FD00 0E01 0000 0100 0100 0100 0100 0001"            
	$"0001 FE00 0C0F 2F6C 7272 6C72 6C72 726C"            
	$"1A01 FD00 0001 FD00 0728 6C72 6C72 6C6C"            
	$"1AFC 0007 1251 6C72 7253 7876 DC8E 0738"            
	$"281C 120A 0501 005C FC00 0301 0002 22E7"            
	$"8E05 6D60 7272 6C14 FC00 0901 0001 0001"            
	$"0001 0000 01FD 0000 01FD 0002 0100 01FB"            
	$"0006 0760 6C72 6C72 6CFE 7206 3D01 0001"            
	$"0000 01FD 0003 6072 726C FE72 000C FC00"            
	$"0203 2872 FE6C 0160 76DD 8E07 3828 1C12"            
	$"0A05 0100 6708 0000 0100 0100 0002 20EC"            
	$"8E09 4B60 6D8E 8E54 6C6C 600C FC00 0001"            
	$"FC00 0701 0001 0000 0100 01FE 0002 0100"            
	$"01FD 0000 01FC 0006 106C 7272 6C72 6CFE"            
	$"7206 4703 0000 0100 01FE 000A 076C 7272"            
	$"6C72 6C1C 0000 01FE 0006 0134 726C 726C"            
	$"5ADD 8E07 3828 1C12 0A05 0100 66FE 0000"            
	$"01FE 0001 0222 ED8E 0449 6C6C 495A FE6C"            
	$"012A 0BFD 0000 01FE 0002 0100 01FD 0012"            
	$"0100 0001 0001 0001 0001 0000 0100 0100"            
	$"0100 01FE 000B 091F 6C72 6C72 6C72 726C"            
	$"3803 F900 071F 726C 726C 7247 01FB 0002"            
	$"0422 6CFE 7201 5A6D DF8E 0738 281C 120A"            
	$"0501 006D 0800 0001 0000 0100 0220 ED8E"            
	$"0049 FD6C 0272 5108 FD00 0E01 0000 0100"            
	$"0100 0100 0100 0100 0001 FD00 0001 FD00"            
	$"0201 0001 FE00 0201 0001 FD00 1E17 6C72"            
	$"6C72 6C72 726C 6109 0000 0100 0100 0001"            
	$"516C 7272 6C6C 2300 0001 0001 FE00 061F"            
	$"726C 7272 6C5D E08E 0738 281C 120A 0501"            
	$"0065 FD00 0401 0000 0222 ED8E 0149 6CFE"            
	$"7201 380C FD00 0501 0001 0000 01FC 0007"            
	$"0100 0100 0001 0001 FE00 0201 0001 FD00"            
	$"0001 F800 0110 4FFE 7208 6C72 726C 3D05"            
	$"0000 01FD 000A 0B6C 726C 7272 6C05 0000"            
	$"01FD 0007 0119 516C 6C72 546A E18E 0738"            
	$"281C 120A 0501 0070 0200 0001 FD00 0102"            
	$"20ED 8E05 4372 6C6C 1B01 FE00 0001 FE00"            
	$"0701 0001 0000 0100 01FD 0016 0100 0001"            
	$"0001 0001 0001 0000 0100 0100 0100 0100"            
	$"0100 01FE 0005 1072 6C72 726C FE72 0160"            
	$"07FE 0000 01FE 0006 5172 726C 726C 12FD"            
	$"0000 01FD 0006 0157 726C 726C 6DE2 8E07"            
	$"3828 1C12 0A05 0100 6DFE 0005 0100 0100"            
	$"0222 EE8E 0449 6C72 722A FB00 1001 0001"            
	$"5146 1901 0000 0100 0100 0100 0001 FD00"            
	$"0001 FD00 0201 0001 FE00 0401 0001 0001"            
	$"FD00 1E01 2272 6C72 726C 726C 7247 0000"            
	$"0100 0100 0051 6C72 726C 7212 0000 0100"            
	$"0001 FD00 0019 FE72 016C 5AE2 8E07 3828"            
	$"1C12 0A05 0100 6D08 0000 0100 0100 0002"            
	$"20EF 8E05 656C 726C 7204 FD00 0901 0000"            
	$"0100 5772 6C72 0AFD 0007 0100 0100 0001"            
	$"0001 FE00 0201 0001 FD00 0001 FA00 0001"            
	$"FD00 0812 6C6C 7272 6C72 7251 FB00 0301"            
	$"5772 6CFE 7200 12FE 0000 01FE 0000 01FE"            
	$"0006 1951 6C72 725A 76E4 8E07 3828 1C12"            
	$"0A05 0100 73FA 0001 0222 F08E 0550 6C72"            
	$"6C72 6CFE 0006 0100 0001 0000 01FE 7204"            
	$"6C0C 0000 01FD 0018 0100 0001 0001 0001"            
	$"0001 0000 0100 0100 0100 0100 0100 0100"            
	$"01FD 001E 2572 726C 726C 6C57 0000 0100"            
	$"0100 016C 7272 6C72 7211 0000 0100 0100"            
	$"0100 01FE 0006 0157 6C72 7260 76E5 8E07"            
	$"3828 1C12 0A05 0100 6E08 0000 0100 0100"            
	$"0002 20F1 8E06 416C 726C 726C 72FD 000A"            
	$"0100 0001 0001 7272 6C72 0BFE 0005 0100"            
	$"0100 0001 FD00 0001 FD00 0201 0001 FE00"            
	$"0401 0001 0001 FA00 071B 726C 726C 7272"            
	$"51FE 000A 0100 0107 726C 7272 6C72 0CFC"            
	$"0000 01FA 0005 1A72 726C 7278 E58E 0738"            
	$"281C 120A 0501 0077 FE00 0501 0001 0002"            
	$"22F2 8E11 5D6C 726C 4E6A 6C6C 0A00 0001"            
	$"0001 0000 0101 FE72 0D6C 0C00 0001 0001"            
	$"0001 0000 0100 01FE 0002 0100 01FD 0000"            
	$"01FA 0010 0100 0100 0100 1072 726C 726C"            
	$"7251 0000 01FE 001B 236C 726C 7272 6C01"            
	$"0000 0100 0100 0001 0001 0001 0001 1F72"            
	$"726C 6064 E68E 0738 281C 120A 0501 0073"            
	$"0200 0001 FD00 0102 20F1 8E07 4B6C 5A8E"            
	$"8E60 720C FC00 0801 0000 0172 726C 720C"            
	$"FA00 2401 0000 0100 0100 0100 0100 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"096C 7272 6C72 6C57 FD00 0201 0047 FE72"            
	$"026C 7251 FD00 0701 0000 0100 0100 01FD"            
	$"0001 2572 FE6C 0049 E78E 0738 281C 120A"            
	$"0501 006F FD00 0401 0000 0222 F18E 1076"            
	$"7877 8E8E 606C 0B00 0001 0001 0001 0001"            
	$"FE72 0A6C 0B00 0001 0001 0001 0001 FD00"            
	$"0001 FD00 0201 0001 FE00 0401 0001 0001"            
	$"F900 1372 6C72 726C 722A 0000 0100 0005"            
	$"6C72 6C72 726C 23FE 0003 0100 0001 F800"            
	$"0005 FE72 026C 6C6A E88E 0738 281C 120A"            
	$"0501 0074 0800 0001 0000 0100 0220 EC8E"            
	$"0254 6C0F FE00 0001 FE00 0601 0172 726C"            
	$"720C FE00 0201 0001 FE00 0201 0001 FE00"            
	$"0201 0001 FD00 0001 FA00 0D01 0001 0001"            
	$"0000 7272 6C72 726C 19FE 0020 0100 1172"            
	$"6C72 6C72 7208 0000 0100 0001 0000 0100"            
	$"0100 0100 0100 1972 726C 726C 5AE8 8E07"            
	$"3828 1C12 0A05 0100 76FE 0000 01FE 0001"            
	$"0222 EC8E 0B52 6C12 0000 0100 0001 0000"            
	$"01FE 7204 6C0C 0000 01FD 0031 0100 0001"            
	$"0001 0001 0001 0000 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0001 6C72 726C 7272"            
	$"0100 0001 0000 196C 726C 726C 6C01 FD00"            
	$"1201 0000 0100 0100 0100 0100 0134 6C72"            
	$"726C 7278 E88E 0738 281C 120A 0501 006B"            
	$"0800 0001 0001 0000 0220 EC8E 1052 6C13"            
	$"0001 0000 0100 0100 0172 726C 720B FD00"            
	$"0401 0001 0001 FD00 0001 FD00 0201 0001"            
	$"FE00 0401 0001 0001 F900 0672 6C72 726C"            
	$"3801 FD00 0701 1C72 6057 473D 28FE 0000"            
	$"01FE 0000 01F9 0007 1C6C 726C 6054 5276"            
	$"E88E 0738 281C 120A 0501 006A FC00 0301"            
	$"0002 22EC 8E02 5A72 17FE 0000 01FE 0001"            
	$"0101 FE72 076C 0C00 0001 0000 01FE 0002"            
	$"0100 01FE 0002 0100 01FD 0000 01FA 000C"            
	$"0100 0100 0100 0572 726C 7272 12FE 0002"            
	$"0100 00FE 01FB 0012 0100 0100 0100 0001"            
	$"0001 0001 000C 7272 6C72 78E5 8E07 3828"            
	$"1C12 0A05 0100 7008 0000 0100 0100 0002"            
	$"20EC 8E10 4B6C 1900 0001 0000 0100 0001"            
	$"7272 6C72 0CFE 0000 01FE 0028 0100 0001"            
	$"0001 0001 0001 0000 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 000B 726C 3E2F 1201"            
	$"0000 0100 01F8 0000 01FE 000A 0100 0001"            
	$"0001 0001 0001 1FFE 7201 6C77 E58E 0738"            
	$"281C 120A 0501 005F FE00 0001 FE00 0102"            
	$"22EC 8E02 6F6C 1BFD 0004 0100 0100 01FE"            
	$"720A 6C0B 0000 0100 0100 0100 01FD 0000"            
	$"01FD 0002 0100 01FE 0004 0100 0100 01FB"            
	$"0003 0101 0001 F200 0501 0001 0000 01FE"            
	$"0000 01FB 0005 0C60 726C 545D E48E 0738"            
	$"281C 120A 0501 0066 0800 0001 0000 0100"            
	$"0220 EC8E 0578 721C 0000 01FD 0006 0101"            
	$"7272 6C72 0CFC 0000 01FE 0002 0100 01FE"            
	$"0002 0100 01FD 0000 01FA 0004 0100 0100"            
	$"01F8 001E 0100 0100 0100 0100 0100 0001"            
	$"0000 0100 0100 0100 0001 0001 0001 6072"            
	$"6C6C 6DE3 8E07 3828 1C12 0A05 0100 6DFD"            
	$"0004 0100 0002 22EC 8E02 786C 1FFE 0005"            
	$"0100 0100 0001 FE72 236C 0C00 0001 0001"            
	$"0000 0100 0001 0001 0001 0001 0000 0100"            
	$"0100 0100 0100 0100 0100 0100 01FA 000C"            
	$"0100 0100 0100 0100 0100 0100 01FE 0000"            
	$"01FE 0008 0100 0001 0001 0001 3DFE 7200"            
	$"66E2 8E07 3828 1C12 0A05 0100 6302 0000"            
	$"01FD 0001 0220 EC8E 1078 6C2E 0000 0100"            
	$"0100 0100 016C 6C72 7212 FE00 0501 0000"            
	$"0100 01FD 0000 01FD 0002 0100 01FE 0004"            
	$"0100 0100 01FB 0007 0100 0100 0100 0001"            
	$"F600 0501 0001 0000 01FE 0000 01FD 0004"            
	$"1972 726C 60E1 8E07 3828 1C12 0A05 0100"            
	$"68FE 0005 0100 0100 0222 EC8E 0278 6C2E"            
	$"FA00 0C01 0051 7272 6C12 0000 0100 0001"            
	$"FE00 0201 0001 FE00 0201 0001 FD00 0001"            
	$"FA00 0A01 0001 0001 0001 0001 0001 FE00"            
	$"1C01 0001 0001 0001 0001 0000 0100 0001"            
	$"0001 0001 0000 0100 002E 726C 7250 E18E"            
	$"0738 281C 120A 0501 006C 0800 0001 0001"            
	$"0000 0220 EC8E 1067 6C3D 0000 0100 0100"            
	$"0100 0057 726C 7212 FD00 1D01 0000 0100"            
	$"0001 0001 0001 0001 0000 0100 0100 0100"            
	$"0100 0100 0100 0100 01FA 000C 0100 0100"            
	$"0100 0100 0100 0100 01FE 0000 01FE 000A"            
	$"0100 0001 0001 106C 6C72 6FE0 8E07 3828"            
	$"1C12 0A05 0100 5FFA 0001 0222 EC8E 0267"            
	$"7246 FE00 0201 0001 FE00 0051 FE72 0312"            
	$"0000 01FE 0002 0100 01FD 0000 01FD 0002"            
	$"0100 01FE 0004 0100 0100 01FB 0007 0100"            
	$"0100 0100 0001 F600 0501 0001 0000 01FE"            
	$"0008 0100 0007 6C6C 7272 6DE0 8E07 3828"            
	$"1C12 0A05 0100 6A08 0000 0100 0100 0002"            
	$"20EC 8E05 5D6C 6000 0001 FD00 0601 0057"            
	$"6C72 7212 FE00 0201 0001 FE00 0201 0001"            
	$"FE00 0201 0001 FD00 0001 FA00 0A01 0001"            
	$"0001 0001 0001 0001 FE00 1201 0001 0001"            
	$"0001 0001 0000 0100 0001 0001 0001 FE00"            
	$"042E 7272 6C4B DF8E 0738 281C 120A 0501"            
	$"006A FE00 0501 0001 0002 22EC 8E02 5D72"            
	$"61FD 0005 0100 0100 0051 FE72 2214 0000"            
	$"0100 0100 0001 0000 0100 0100 0100 0100"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"FA00 0C01 0001 0001 0001 0001 0001 0001"            
	$"FE00 0001 FE00 0901 0000 010C 726C 724B"            
	$"76DF 8E07 3828 1C12 0A05 0100 5C02 0000"            
	$"01FD 0001 0220 EB8E 0F6C 7201 0000 0100"            
	$"0100 0001 516C 726C 19FB 0002 0100 01FD"            
	$"0000 01FD 0002 0100 01FE 0004 0100 0100"            
	$"01FB 0007 0100 0100 0100 0001 F600 0501"            
	$"0001 0000 01FE 0005 0100 2572 7253 DD8E"            
	$"0738 281C 120A 0501 0062 FD00 0401 0000"            
	$"0222 EB8E 026C 6C0B FB00 0201 0057 FE72"            
	$"0519 0000 0100 01FD 0002 0100 01FE 0002"            
	$"0100 01FD 0000 01FA 000A 0100 0100 0100"            
	$"0100 0100 01FE 0018 0100 0100 0100 0100"            
	$"0100 0001 0000 0100 0100 0100 0761 726C"            
	$"66DD 8E07 3828 1C12 0A05 0100 6908 0000"            
	$"0100 0001 0002 20EB 8E07 5472 1900 0001"            
	$"0001 FE00 0051 FE72 0019 FE00 1E01 0001"            
	$"0001 0000 0100 0100 0100 0100 0001 0001"            
	$"0001 0001 0001 0001 0001 0001 FA00 0C01"            
	$"0001 0001 0001 0001 0001 0001 FE00 0001"            
	$"FE00 0701 0001 476C 726C 76DD 8E07 3828"            
	$"1C12 0A05 0100 5EFE 0000 01FE 0001 0222"            
	$"EB8E 0253 7222 FE00 0C01 0001 0000 576C"            
	$"726C 1900 0001 FE00 0201 0001 FD00 0001"            
	$"FD00 0201 0001 FE00 0401 0001 0001 FB00"            
	$"0701 0001 0001 0000 01F6 0005 0100 0100"            
	$"0001 FE00 040B 7272 6C41 DC8E 0738 281C"            
	$"120A 0501 0065 0800 0001 0001 0000 0220"            
	$"EB8E 054B 6C2E 0000 01FE 0002 0100 51FE"            
	$"7205 1F00 0100 0001 FD00 0201 0001 FE00"            
	$"0201 0001 FD00 0001 FA00 0A01 0001 0001"            
	$"0001 0001 0001 FE00 1601 0001 0001 0001"            
	$"0001 0000 0100 0001 0001 0000 2372 725A"            
	$"DB8E 0738 281C 120A 0501 0062 FC00 0301"            
	$"0002 22EB 8E02 4872 51FD 0000 01FE 0004"            
	$"5772 6C72 1CFE 001E 0100 0100 0100 0001"            
	$"0001 0001 0001 0000 0100 0100 0100 0100"            
	$"0100 0100 0100 01FA 000C 0100 0100 0100"            
	$"0100 0100 0100 01FE 0000 01FE 0004 0101"            
	$"6172 53DA 8E07 3828 1C12 0A05 0100 5D08"            
	$"0000 0100 0100 0002 20EB 8E12 4272 5100"            
	$"0001 0000 0100 002E 7272 6C1F 0000 01FE"            
	$"0002 0100 01FD 0000 01FD 0002 0100 01FE"            
	$"0004 0100 0100 01FB 0007 0100 0100 0100"            
	$"0001 F600 0B01 0001 0000 0100 0019 6C72"            
	$"6FDA 8E07 3828 1C12 0A05 0100 62FE 0000"            
	$"01FE 0001 0222 EB8E 0B49 6C72 0100 0001"            
	$"0000 0100 2EFE 7200 1FFD 0000 01FD 0002"            
	$"0100 01FE 0002 0100 01FD 0000 01FA 000A"            
	$"0100 0100 0100 0100 0100 01FE 0015 0100"            
	$"0100 0100 0100 0100 0001 0000 0100 010C"            
	$"6072 6C73 DA8E 0738 281C 120A 0501 0064"            
	$"0800 0001 0000 0100 0220 EA8E 026C 720C"            
	$"FE00 2A01 0000 012E 7272 6C2A 0001 0001"            
	$"0001 0001 0000 0100 0100 0100 0100 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 FA00"            
	$"0C01 0001 0001 0001 0001 0001 0001 FE00"            
	$"0001 FE00 0347 726C 48D9 8E07 3828 1C12"            
	$"0A05 0100 59FD 0004 0100 0002 22EA 8E0A"            
	$"6C72 1900 0001 0001 0000 2EFE 7203 2E00"            
	$"0001 FE00 0201 0001 FD00 0001 FD00 0201"            
	$"0001 FE00 0401 0001 0001 FB00 0701 0001"            
	$"0001 0000 01F6 000A 0100 0100 0001 0E72"            
	$"7253 76D9 8E07 3828 1C12 0A05 0100 5D02"            
	$"0000 01FD 0001 0220 EA8E 0260 722F FC00"            
	$"0601 002E 7272 6C2E FD00 0001 FD00 0201"            
	$"0001 FE00 0201 0001 FD00 0001 FA00 0A01"            
	$"0001 0001 0001 0001 0001 FE00 1301 0001"            
	$"0001 0001 0001 0000 0100 0001 0025 726C"            
	$"78D8 8E07 3828 1C12 0A05 0100 62FE 0005"            
	$"0100 0100 0222 EA8E 0A60 6C2E 0000 0100"            
	$"0100 012E FE72 222E 0000 0100 0001 0001"            
	$"0000 0100 0100 0100 0100 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 FA00 0C01 0001"            
	$"0001 0001 0001 0001 0001 FE00 0601 0001"            
	$"576C 7264 D88E 0738 281C 120A 0501 0059"            
	$"0800 0001 0001 0000 0220 EA8E 0254 7251"            
	$"FE00 0001 FE00 0428 7272 6C2F FE00 0501"            
	$"0000 0100 01FD 0000 01FD 0002 0100 01FE"            
	$"0004 0100 0100 01FB 0007 0100 0100 0100"            
	$"0001 F600 0801 0001 0000 196C 724B D78E"            
	$"0738 281C 120A 0501 005A FA00 0102 22EA"            
	$"8E13 546C 7200 0001 0000 0100 196C 7272"            
	$"4700 0001 0001 FD00 0201 0001 FE00 0201"            
	$"0001 FD00 0001 FA00 0A01 0001 0001 0001"            
	$"0001 0001 FE00 1101 0001 0001 0001 0001"            
	$"0000 0100 0007 6C72 6CD6 8E07 3828 1C12"            
	$"0A05 0100 5D08 0000 0100 0100 0002 20EA"            
	$"8E02 4E6C 72FD 0007 0100 0117 726C 7246"            
	$"FC00 1C01 0001 0000 0100 0100 0100 0100"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"FA00 0C01 0001 0001 0001 0001 0001 0001"            
	$"FD00 032E 7272 41D6 8E07 3828 1C12 0A05"            
	$"0100 56FE 0005 0100 0100 0222 EA8E 065A"            
	$"7272 0800 0001 FE00 0D19 6C72 6C46 0000"            
	$"0100 0100 0100 01FD 0000 01FD 0002 0100"            
	$"01FE 0004 0100 0100 01FB 0007 0100 0100"            
	$"0100 0001 F600 0601 0001 086C 7254 D58E"            
	$"0738 281C 120A 0501 005B 0200 0001 FD00"            
	$"0102 20EA 8E03 5A72 720C FD00 0201 0017"            
	$"FE72 0446 0001 0001 FC00 0201 0001 FE00"            
	$"0201 0001 FD00 0001 FA00 0A01 0001 0001"            
	$"0001 0001 0001 FE00 1001 0001 0001 0001"            
	$"0001 0000 0100 1C72 726F D58E 0738 281C"            
	$"120A 0501 005C FD00 0401 0000 0222 EA8E"            
	$"068A 726C 1200 0001 FE00 0419 6C72 7251"            
	$"FC00 1C01 0001 0000 0100 0100 0100 0100"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"FA00 0C01 0001 0001 0001 0001 0001 0001"            
	$"FE00 033E 6C72 73D5 8E07 3828 1C12 0A05"            
	$"0100 5608 0000 0100 0001 0002 20EA 8E03"            
	$"786C 7219 FE00 1001 0000 0172 726C 6100"            
	$"0001 0001 0001 0001 FD00 0001 FD00 0201"            
	$"0001 FE00 0401 0001 0001 FB00 0701 0001"            
	$"0001 0000 01F6 0005 0100 1772 7248 D48E"            
	$"0738 281C 120A 0501 005B FE00 0001 FE00"            
	$"0102 22EA 8E0A 786C 6C19 0000 0100 0100"            
	$"01FE 7200 60FE 0000 01FC 0002 0100 01FE"            
	$"0002 0100 01FD 0000 01FA 000A 0100 0100"            
	$"0100 0100 0100 01FE 000F 0100 0100 0100"            
	$"0100 0100 0001 3D72 7270 D48E 0738 281C"            
	$"120A 0501 005C 0800 0001 0001 0000 0220"            
	$"EA8E 0378 6C72 1BFC 0027 0101 7272 6C60"            
	$"0000 0100 0001 0001 0000 0100 0100 0100"            
	$"0100 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 FA00 1101 0001 0001 0001 0001 0001"            
	$"0001 000E 7272 66D3 8E07 3828 1C12 0A05"            
	$"0100 4FFC 0003 0100 0222 EA8E 0A67 6C72"            
	$"1F00 0001 0001 0001 FE72 0060 FD00 0401"            
	$"0001 0001 FD00 0001 FD00 0201 0001 FE00"            
	$"0401 0001 0001 FB00 0701 0001 0001 0000"            
	$"01F5 0002 226C 51D2 8E07 3828 1C12 0A05"            
	$"0100 5908 0000 0100 0100 0002 20EA 8E03"            
	$"6772 6C28 FE00 0A01 0000 0172 726C 6100"            
	$"0001 FB00 0201 0001 FE00 0201 0001 FD00"            
	$"0001 FA00 0A01 0001 0001 0001 0001 0001"            
	$"FE00 0D01 0001 0001 0001 0001 0003 5772"            
	$"6ED2 8E07 3828 1C12 0A05 0100 5CFE 0000"            
	$"01FE 0001 0222 EA8E 0E64 6C72 2E00 0001"            
	$"0000 0100 6072 7260 FE00 1E01 0001 0001"            
	$"0000 0100 0100 0100 0100 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 FA00 1001 0001"            
	$"0001 0001 0001 0001 0000 236C 725D D28E"            
	$"0738 281C 120A 0501 0053 0800 0001 0000"            
	$"0100 0220 EA8E 036D 726C 38FD 000F 0100"            
	$"0060 726C 6000 0001 0001 0001 0001 FD00"            
	$"0001 FD00 0201 0001 FE00 0401 0001 0001"            
	$"FB00 0701 0001 0001 0000 01F7 0003 016C"            
	$"726C D18E 0738 281C 120A 0501 0055 FD00"            
	$"0401 0000 0222 EA8E 065D 6C72 4600 0001"            
	$"FD00 0461 6C72 6C01 FB00 0405 0B04 0001"            
	$"FE00 0201 0001 FD00 0001 FA00 0A01 0001"            
	$"0001 0001 0001 0001 FE00 0C01 0001 0001"            
	$"0001 0001 3872 6C58 D18E 0738 281C 120A"            
	$"0501 0059 0200 0001 FD00 0102 20EA 8E03"            
	$"766C 7251 FE00 0C01 0317 1961 726C 722E"            
	$"5751 5761 FD72 1819 0000 0100 0100 0100"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"FA00 0E01 0001 0001 0001 0001 0001 0E72"            
	$"6C54 D08E 0738 281C 120A 0501 0052 FE00"            
	$"0501 0001 0002 22EC 8E0E 5D49 4872 726C"            
	$"2E2E 5761 7272 6C72 6CFA 7204 6C72 6C72"            
	$"19FE 0000 01FD 0002 0100 01FE 0004 0100"            
	$"0100 01FB 0007 0100 0100 0100 0001 F800"            
	$"031A 7272 6FD0 8E07 3828 1C12 0A05 0100"            
	$"6008 0000 0100 0100 0002 20F1 8E08 785A"            
	$"5260 6C72 6C72 6CFD 721A 6C72 6C72 726C"            
	$"726C 726C 726C 726C 726C 726C 1B00 0001"            
	$"0000 0100 01FD 0000 01FA 000A 0100 0100"            
	$"0100 0100 0100 01FE 000B 0100 0100 0100"            
	$"0100 3E72 6C73 D08E 0738 281C 120A 0501"            
	$"005C FA00 0102 22F1 8E37 5472 6C72 6C72"            
	$"726C 726C 726C 7272 6C72 6C72 726C 726C"            
	$"726C 726C 726C 726C 721F 0001 0000 0100"            
	$"0100 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 FA00 0D01 0001 0001 0001 0001 0017"            
	$"7272 4ECF 8E07 3828 1C12 0A05 0100 5D08"            
	$"0000 0100 0100 0002 20F1 8E1F 5372 726C"            
	$"726C 7272 6C72 6C72 6C72 726C 726C 7272"            
	$"6C72 6C72 6C72 6C72 6C72 6C1C FE00 0001"            
	$"FD00 0201 0001 FE00 0401 0001 0001 FB00"            
	$"0701 0001 0001 0000 01FA 0004 0C61 7260"            
	$"6DCF 8E07 3828 1C12 0A05 0100 5EFE 0005"            
	$"0100 0100 0222 F18E 0054 FE72 236C 726C"            
	$"7272 6C72 6C72 6C72 726C 726C 7272 6C72"            
	$"6C72 6C72 6C72 6C72 1F00 0001 0000 0100"            
	$"01FD 0000 01FA 000A 0100 0100 0100 0100"            
	$"0100 01FE 0009 0100 0100 0100 516C 7249"            
	$"CE8E 0738 281C 120A 0501 005D 0200 0001"            
	$"FD00 0102 20F1 8E1F 4E72 6C72 726C 726C"            
	$"7272 6C72 6C72 6C72 726C 726C 7272 6C72"            
	$"6C72 6C72 6C72 6C1F FD00 1301 0001 0000"            
	$"0100 0100 0100 0100 0100 0100 0100 01FA"            
	$"000B 0100 0100 0100 0100 0772 726C CD8E"            
	$"0738 281C 120A 0501 005A FD00 0401 0000"            
	$"0222 F18E 2348 6C72 6C72 726C 726C 7272"            
	$"6C72 6C72 6C72 726C 726C 7272 6C72 6C72"            
	$"6C72 6C6C 1B00 0100 01FD 0002 0100 01FE"            
	$"0004 0100 0100 01FB 0007 0100 0100 0100"            
	$"0001 FB00 031F 6C72 5ACD 8E07 3828 1C12"            
	$"0A05 0100 5E08 0000 0100 0001 0002 20F1"            
	$"8E1E 4372 6C72 6C72 726C 726C 7272 6C72"            
	$"6C72 6C72 726C 726C 726C 513E 2E19 1901"            
	$"01FE 0005 0100 0001 0001 FD00 0001 FA00"            
	$"0A01 0001 0001 0001 0001 0001 FE00 0801"            
	$"0001 0001 516C 6C6A CD8E 0738 281C 120A"            
	$"0501 0058 FE00 0001 FE00 0102 22F1 8E17"            
	$"496C 726C 726C 7272 6C72 6C72 726C 726C"            
	$"726C 7272 6C72 0101 F800 1601 0000 0100"            
	$"0100 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 FA00 0701 0001 0001 0001 0CFE 7200"            
	$"76CD 8E07 3828 1C12 0A05 0100 5408 0000"            
	$"0100 0100 0002 20F1 8E01 7653 FB60 0E6C"            
	$"7272 2F2F 1F1B 1912 0C6C 6C72 6C01 F800"            
	$"0301 0000 01FD 0002 0100 01FE 0004 0100"            
	$"0100 01FB 0007 0100 0100 0100 0001 FD00"            
	$"0403 516C 7249 CC8E 0738 281C 120A 0501"            
	$"0068 FC00 0301 0002 22E9 8E03 496C 6C03"            
	$"FB00 0360 726C 60FD 0004 0100 0100 01FE"            
	$"0005 0100 0001 0001 FD00 0001 FA00 0A01"            
	$"0001 0001 0001 0001 0001 FE00 0601 0000"            
	$"1972 7248 FD8E 0058 FA3B 075C 648E 4D3A"            
	$"3333 36FD 4D00 55F9 8E04 7631 545C 36F1"            
	$"8E07 3828 1C12 0A05 0100 8108 0000 0100"            
	$"0100 0002 20E9 8E03 4972 7211 FB00 0360"            
	$"7272 60FE 001E 0100 0100 0100 0100 0100"            
	$"0001 0001 0000 0100 0100 0100 0100 0100"            
	$"0100 0100 01FA 0009 0100 0100 0100 3872"            
	$"6077 FD8E 245E 6C60 2E2A 2328 2F6C 5965"            
	$"462A 3E6C 303E 383E 723B 775A 484B 5A77"            
	$"8E8E 6561 2828 5366 8E8E FD6C 0371 8E68"            
	$"68FC 8E07 3828 1C12 0A05 0100 7FFE 0000"            
	$"01FE 0001 0222 E98E 1049 6C72 1900 0001"            
	$"0001 0060 726C 6100 0001 FA00 0301 0000"            
	$"01FD 0002 0100 01FE 0004 0100 0100 01FB"            
	$"0007 0100 0100 0100 0001 FE00 030C 726C"            
	$"6FFC 8E02 5E6C 0CFD 0026 0572 5E8A 1800"            
	$"1B72 304A 1900 6C4B 4E6C 6C2F 7266 8E8E"            
	$"4B22 0000 084B 8E8E 6C00 0023 6C4B 6C6C"            
	$"4DFD 8E07 3828 1C12 0A05 0100 8208 0000"            
	$"0100 0001 0002 20E9 8E03 496C 7219 FE00"            
	$"0601 0000 5772 7260 FD00 0401 0001 0001"            
	$"FE00 0501 0000 0100 01FD 0000 01FA 000A"            
	$"0100 0100 0100 0100 0100 01FE 0005 0101"            
	$"3E72 7265 FC8E 025E 6C0C FE00 1801 0C47"            
	$"5E6A 1F00 196C 304A 1500 7272 6C22 0100"            
	$"114B 8E8E 5C08 FE00 063E 768E 6C00 0023"            
	$"FD6C 005A FD8E 0738 281C 120A 0501 007F"            
	$"FD00 0401 0000 0222 E98E 0649 6C72 1F00"            
	$"0001 FE00 2546 7272 6000 0001 0000 0100"            
	$"0100 0100 0100 0001 0001 0000 0100 0100"            
	$"0100 0100 0100 0100 0100 01FA 0008 0100"            
	$"0100 1F72 7253 76FC 8E03 656C 0C00 FC72"            
	$"0C5E 8A2B 0011 8976 7E0C 0038 6012 FD00"            
	$"034B 8E3A 3EFD 000B 2C3A 8E60 0000 1B11"            
	$"0100 194B FD8E 0738 281C 120A 0501 0079"            
	$"0200 0001 FD00 0102 20E9 8E03 496C 722E"            
	$"FD00 0501 0046 7272 60FE 0000 01FB 0003"            
	$"0100 0001 FD00 0201 0001 FE00 0401 0001"            
	$"0001 FB00 0D01 0001 0001 0000 0100 0572"            
	$"726C 58FB 8E05 786C 0C0C 6C54 FE3B 0B70"            
	$"6A2E 000C 898E 7E0C 0025 09FC 0003 4E8E"            
	$"4423 FD00 0323 318E 6CFB 0001 194E FD8E"            
	$"0738 281C 120A 0501 007D FE00 0501 0001"            
	$"0002 22E9 8E06 496C 722E 0000 01FE 000C"            
	$"2857 5160 0000 0100 0100 0100 01FE 0005"            
	$"0100 0001 0001 FD00 0001 FA00 0A01 0001"            
	$"0001 0001 0001 0001 FE00 0317 7272 53FA"            
	$"8E05 786C 0C0C 6C5A FD8E 098A 5400 1A89"            
	$"8E7E 0C00 01FE 000E 0100 0052 6871 1F00"            
	$"011F 001F 3B8E 60FB 0001 194E FD8E 0738"            
	$"281C 120A 0501 007C 0800 0001 0001 0000"            
	$"0220 E98E 0349 6C72 47FE 0002 0100 01F8"            
	$"001C 0100 0100 0100 0100 0001 0001 0000"            
	$"0100 0100 0100 0100 0100 0100 0100 01FA"            
	$"0006 0100 002E 726C 6EFA 8E05 786C 0C0C"            
	$"6C78 FD8E 0764 796C 6C8A 887E 0CFE 0018"            
	$"0C0C 0001 0046 216C 0C00 2538 0017 3B8E"            
	$"5300 000B 2807 0019 52FD 8E07 3828 1C12"            
	$"0A05 0100 72FA 0001 0222 E98E 0449 6C72"            
	$"6C01 FE00 0001 FB00 0201 0001 FB00 0301"            
	$"0000 01FD 0002 0100 01FE 0004 0100 0100"            
	$"01FB 000C 0100 0100 0100 0001 0772 6C72"            
	$"77FA 8E05 786C 0C14 6C65 F88E 1E4D 6C01"            
	$"0001 3872 720E 0000 4A30 7205 0972 6100"            
	$"113B 8E3E 0000 1972 1B00 194E FD8E 0738"            
	$"281C 120A 0501 0084 0800 0001 0001 0000"            
	$"0220 FA8E 0065 F078 056C 6C72 1900 01FE"            
	$"0015 0100 0100 0100 0100 0100 0907 0001"            
	$"0000 0100 0001 0001 FD00 0001 FA00 1001"            
	$"0001 0001 0001 0001 0001 0003 4672 6C66"            
	$"F98E 0578 6C0C 196C 5EFE 8E24 3A48 4B48"            
	$"4B52 246C 0000 1272 386C 2800 053E 574A"            
	$"0022 6B81 0710 6E8E 4800 0025 7222 000E"            
	$"52FD 8E07 3828 1C12 0A05 0100 7FFE 0005"            
	$"0100 0100 0222 FA8E EE6C 0472 6C72 726C"            
	$"FE72 256C 726C 726C 726C 726C 726C 721B"            
	$"0000 0100 0001 0001 0000 0100 0100 0100"            
	$"0100 0100 0100 0100 01F9 0003 2E72 7248"            
	$"F88E 0567 7F0C 1972 58FE 8E24 336C 3E2E"            
	$"3E86 8E7E 0100 1C72 276C 2E00 0C4A 6C28"            
	$"0051 6F65 3860 6F8E 4800 002E 5125 000C"            
	$"4EFD 8E07 3828 1C12 0A05 0100 9202 0000"            
	$"01FD 0001 0220 FB8E 2950 6C72 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 6C72 726C 726C"            
	$"7272 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 22FE 0000 01FD 0002 0100 01FE 0004"            
	$"0100 0100 01FB 000A 0100 0100 0100 0372"            
	$"726C 70F8 8E05 6787 0C2E 6C58 FE8E 2433"            
	$"6C0F 001B 868E 7E01 002C 7224 722E 0011"            
	$"4672 1900 725E 8A71 4B8E 8E48 0001 462E"            
	$"2E00 0C4E FD8E 0738 281C 120A 0501 0090"            
	$"FD00 0401 0000 0222 FB8E 3154 726C 726C"            
	$"726C 726C 726C 726C 726C 726C 726C 7272"            
	$"6C72 6C72 726C 726C 726C 726C 726C 726C"            
	$"726C 726C 723D 1B03 0000 0100 01FD 0000"            
	$"01FA 000F 0100 0100 0100 0100 0100 0019"            
	$"6C72 5A88 F88E 058A 710C 2E6C 55FE 8E18"            
	$"3372 0400 1B6F 8E63 0000 3E7E 6D6C 1900"            
	$"1A46 720F 0572 4D8E 58FE 8E08 4800 0054"            
	$"3A3C 1125 52FD 8E07 3828 1C12 0A05 0100"            
	$"9108 0000 0100 0001 0002 20FC 8E2D 5D6C"            
	$"7272 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 6C72 726C 726C 7272 6C72 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 7219 FE00 1101"            
	$"0000 0100 0100 0100 0100 0100 0100 0100"            
	$"01FA 0003 3872 6C65 F78E 056A 6C0C 2E6C"            
	$"68FE 8E16 3351 0000 2351 243E 0000 7281"            
	$"736C 1400 2E46 7208 0581 76FC 8E08 4800"            
	$"006B 8E6B 6C72 5AFD 8E07 3828 1C12 0A05"            
	$"0100 97FE 0000 01FE 0001 0222 FC8E 3565"            
	$"6C6C 7272 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 6C72 6C72 726C 726C 7272 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 6C72 1400 0001"            
	$"0000 0100 01FE 0004 0100 0100 01FB 000C"            
	$"0100 0100 0101 6C72 6C77 8E8E 58FD 4908"            
	$"678E 8E8A 6C0C 3872 68FE 8E15 333E 0000"            
	$"2530 243E 0003 726C 5E6C 0C00 3D3D 6C00"            
	$"0581 FC8E 0975 4800 006B 8E7E 6C35 55FD"            
	$"8E07 3828 1C12 0A05 0100 9508 0000 0100"            
	$"0100 0002 20FC 8E2D 786C 726C 7272 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"726C 726C 7272 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 6C72 6C10 FD00 0001 FD00 0001 FA00"            
	$"0A01 0001 0001 0001 0001 0038 FE72 106C"            
	$"6C72 726C 726C 725A 8E8E 6A6C 0C6C 6C68"            
	$"FE8E 2133 3800 002A 2D27 3E00 056C 4478"            
	$"6C04 0172 3072 0005 818E 785A 5A4E 3334"            
	$"000A 4E8E 58FA 8E07 3828 1C12 0A05 0100"            
	$"91FC 0003 0100 0222 FA8E 0148 6CFE 7229"            
	$"6C72 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 726C 726C 7272 6C72 6C72 6C72 6C72"            
	$"6C72 6C72 6C72 0900 0001 FE00 0E01 0001"            
	$"0001 0001 0001 0001 0001 0001 FC00 140E"            
	$"726C 726C 7272 6C72 726C 7272 4B8E 8E8A"            
	$"710C 6C6C FD8E 1F33 2E00 002E 2432 3E00"            
	$"0C6C 316E 3E00 0572 326C 0005 818E 6319"            
	$"226C 242E 000C 4EF8 8E07 3828 1C12 0A05"            
	$"0100 9108 0000 0100 0100 0002 20F9 8E29"            
	$"7765 5A60 6C72 726C 726C 726C 726C 726C"            
	$"726C 726C 726C 7272 6C72 6C72 726C 726C"            
	$"726C 726C 726C 726C 7260 FD00 0401 0001"            
	$"0001 FE00 0401 0001 0001 FB00 1801 0001"            
	$"0023 7272 6C72 6C72 726C 7272 6C6C 4E8E"            
	$"8E64 800C 6C71 FD8E 1F33 2E00 0038 2132"            
	$"3800 0C81 7665 2500 0C6C 5A6C 0005 6B42"            
	$"2D00 1251 242E 000B 4BF8 8E07 3828 1C12"            
	$"0A05 0100 8CFE 0000 01FE 0001 0222 F58E"            
	$"0258 526C FE72 256C 726C 726C 726C 726C"            
	$"726C 726C 7272 6C72 6C72 726C 726C 726C"            
	$"726C 726C 726C 2F00 0001 0000 01FD 0000"            
	$"01FA 001E 0100 0100 0100 0100 0161 726C"            
	$"726C 726C 7272 6C72 726C 548E 8E48 6C0C"            
	$"6C6C 76FE 8E1F 332E 0000 461E 322E 0012"            
	$"818E 7818 0012 6C78 6C00 006C 6C25 001B"            
	$"3024 2E00 0C48 F88E 0738 281C 120A 0501"            
	$"008F 0800 0001 0000 0100 0220 F38E 0149"            
	$"54FE 721E 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 726C 726C 7272 6C72 6C72 6C72 6C72"            
	$"6C72 11FE 0000 01FE 000E 0100 0100 0100"            
	$"0100 0100 0100 0100 01FD 0039 1272 6C72"            
	$"6C72 6C72 6C72 726C 7272 548E 8E48 6C0C"            
	$"386C 3133 4D55 3323 0000 511E 322E 0012"            
	$"6C8E 4B0D 0014 4478 6C00 0072 7219 001C"            
	$"2B32 2E01 1148 F88E 0738 281C 120A 0501"            
	$"008A FD00 0401 0000 0222 F28E 2B88 6478"            
	$"4E6C 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"726C 726C 7272 6C72 6C72 6C72 6C72 5101"            
	$"0000 0100 0100 0100 01FE 0004 0100 0100"            
	$"01FB 0004 0100 0751 6CFE 7234 6C72 6C72"            
	$"6C72 726C 7254 8E8E 4872 0C1C 2F3E 616C"            
	$"3824 2500 016C 7671 2E00 194E 8E4E 0800"            
	$"1B37 786C 0400 2C23 0100 2A21 322E 0019"            
	$"6FF8 8E07 3828 1C12 0A05 0100 7F02 0000"            
	$"01FD 0001 0220 EE8E 1D70 416C 726C 726C"            
	$"726C 726C 726C 726C 7272 6C72 6C72 726C"            
	$"726C 726C 726C 1BFB 0000 01FD 0000 01FA"            
	$"0007 0100 0100 0100 0138 FE72 076C 7272"            
	$"6C72 6C72 6CFE 7205 658E 8E4B 6C0C FD00"            
	$"1572 3824 2500 056C 8E6C 2E00 1B37 8E60"            
	$"0000 2333 786C 0CFC 0006 5476 3B2E 0019"            
	$"5AF8 8E07 3828 1C12 0A05 0100 86FE 0005"            
	$"0100 0100 0222 EC8E 205D 536C 7272 6C72"            
	$"6C72 6C72 6C72 6C72 726C 726C 7272 6C72"            
	$"6C72 6C72 0100 0001 0001 FE00 2001 0001"            
	$"0001 0001 0001 0001 0001 0001 0000 036C"            
	$"726C 7272 6C72 726C 726C 726C 5349 FE8E"            
	$"0248 6C0C FD00 1572 6562 2500 0C4E 8E71"            
	$"2E00 2333 8E6C 0000 2533 786C 19FD 0007"            
	$"0B52 8E3B 2800 285A F88E 0738 281C 120A"            
	$"0501 0082 0800 0001 0001 0000 0220 EA8E"            
	$"236A 4B6C 6C72 726C 726C 726C 726C 7272"            
	$"6C72 6C72 726C 726C 7260 1912 0900 0100"            
	$"0001 0000 01FE 0004 0100 0100 01FA 000D"            
	$"1972 6C72 6C72 726C 7272 6C53 6F6A FC8E"            
	$"2948 7247 3E38 2E2E 6C8A 553C 1B23 523A"            
	$"602E 1038 333A 6005 0F3E 3365 6C38 0000"            
	$"010B 5766 883B 2F12 3E66 88F9 8E07 3828"            
	$"1C12 0A05 0100 79FA 0001 0222 E98E 2049"            
	$"6C72 6C72 726C 726C 726C 726C 7272 6C72"            
	$"6C72 726C 726C 726C 726C 7251 3817 0B01"            
	$"FE00 0001 FA00 1001 0001 0001 0038 7272"            
	$"6C72 6C72 726C 4E49 F98E 244E 796C 6C71"            
	$"6C6C 716A 7572 726C 484D 6C72 726C 5540"            
	$"6C72 726C 3376 446C 382C 7272 6C4D 8E3B"            
	$"FE72 0166 88F9 8E07 3828 1C12 0A05 0100"            
	$"7408 0000 0100 0100 0002 20E8 8E1B 6C6C"            
	$"726C 7272 6C72 6C72 6C72 6C72 726C 726C"            
	$"7272 6C72 6C72 6C72 726C FE72 1A6C 573C"            
	$"281C 1A12 0C01 0100 0100 0100 0100 0C6C"            
	$"6C72 726C 7254 6E6A ED8E 1E55 6868 8E68"            
	$"6258 584D 8E55 4878 6562 768E 8E73 648A"            
	$"786A 768E 8E76 625E 7873 F88E 0738 281C"            
	$"120A 0501 007A FE00 0501 0001 0002 22E8"            
	$"8E19 5472 6C72 6C72 726C 726C 726C 726C"            
	$"7272 6C72 6C72 726C 726C 726C FE72 026C"            
	$"726C F972 0E61 3C23 1701 0000 013D 7272"            
	$"6C72 7249 F58E 1C73 4E63 7F87 6C87 876C"            
	$"8787 7F87 6C87 7F87 6C7F 877F 8772 877F"            
	$"714E 6363 FE78 025A 634E FE63 0160 7FFE"            
	$"8702 6C87 6CFC 8E07 3828 1C12 0A05 0100"            
	$"5102 0000 01FD 0001 0220 E88E 2048 6C72"            
	$"6C72 6C72 726C 726C 726C 726C 7272 6C72"            
	$"6C72 726C 726C 726C 726C 726C 726C FC72"            
	$"006C FE72 0B6C 726C 5138 2E72 726C 726C"            
	$"50F4 8E00 5FD4 90FC 8E07 3828 1C12 0A05"            
	$"0100 6BFD 0004 0100 0002 22E8 8E2B 496C"            
	$"7272 6C72 6C72 726C 726C 726C 726C 7272"            
	$"6C72 6C72 726C 726C 726C 726C 726C 726C"            
	$"726C 726C 726C 726C 726C FA72 014E 73F3"            
	$"8E00 5FFE 90FB 8C09 6C72 616C 616C 616C"            
	$"616C F690 023C 3D72 FE90 056C 1F22 1F22"            
	$"4FFE 90FC 8E07 3828 1C12 0A05 0100 6608"            
	$"0000 0100 0001 0002 20E7 8E2B 6C72 6C72"            
	$"6C72 6C72 726C 726C 726C 726C 7272 6C72"            
	$"6C72 726C 726C 726C 726C 726C 726C 726C"            
	$"726C 726C 726C 726C FE72 026C 7241 F18E"            
	$"0356 9090 1FF2 0000 17F7 9003 8C00 0017"            
	$"FE90 003D FD00 0017 FE90 FC8E 0738 281C"            
	$"120A 0501 0065 FE00 0001 FE00 0102 22E7"            
	$"8E30 606C 726C 726C 726C 7272 6C72 6C72"            
	$"6C72 6C72 726C 726C 7272 6C72 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 4EF0 8E03 5F90 901F F200 001C F790"            
	$"038C 0000 17FE 9005 803D 3E3E 0E00 FE90"            
	$"FC8E 0738 281C 120A 0501 0071 0800 0001"            
	$"0001 0000 0220 E78E 3054 726C 726C 726C"            
	$"726C 7272 6C72 6C72 6C72 6C72 726C 726C"            
	$"7272 6C72 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C73 F08E 035F 9090"            
	$"3DFC 1F04 1A01 0001 19FC 1C00 38FE 9001"            
	$"5128 FE1C 053E 908C 0000 17FA 9001 1700"            
	$"FE90 FC8E 0738 281C 120A 0501 0065 FC00"            
	$"0301 0002 22E7 8E00 5AFD 722A 6C72 6C72"            
	$"6C72 726C 726C 726C 726C 7272 6C72 6C72"            
	$"726C 726C 726C 726C 726C 726C 726C 726C"            
	$"726C 726C 726C 48EF 8E00 56F9 9004 6100"            
	$"0100 8CF9 9000 22FC 0005 6090 8C00 001C"            
	$"FA90 0419 008C 9090 FC8E 0738 281C 120A"            
	$"0501 006A 0800 0001 0001 0000 0220 E78E"            
	$"2F6F 6C6C 726C 726C 726C 726C 7272 6C72"            
	$"6C72 6C72 6C72 726C 726C 7272 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 6C72 6C72 6C54"            
	$"76EF 8E00 66F9 9000 57FE 00F9 900C 3E01"            
	$"0003 388C 8C90 908C 0000 1BFA 9004 1700"            
	$"8C90 90FC 8E07 3828 1C12 0A05 0100 69FE"            
	$"0000 01FE 0001 0222 E78E 2E78 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 726C 726C 726C 726C"            
	$"7272 6C72 6C72 726C 726C 726C 726C 726C"            
	$"726C 726C 726C 726C 7270 EE8E 0063 F990"            
	$"033C 0100 00F9 9000 1CFE 0008 576C 8C90"            
	$"9061 0000 1CFA 9004 1900 8C90 90FC 8E07"            
	$"3828 1C12 0A05 0100 6908 0000 0100 0001"            
	$"0002 20E7 8E2D 656C 6C72 6C72 6C72 6C72"            
	$"6C72 6C72 726C 726C 726C 726C 7272 6C72"            
	$"6C72 726C 726C 726C 726C 726C 726C 726C"            
	$"726C 7254 ED8E 004E F990 033D 0100 00F9"            
	$"9001 6003 FE00 0701 0C90 9061 0000 1BFA"            
	$"9004 1700 8C90 90FC 8E07 3828 1C12 0A05"            
	$"0100 6BFD 0004 0100 0002 22E7 8E2D 736C"            
	$"726C 726C 726C 726C 726C 726C 7272 6C72"            
	$"6C72 6C72 6C72 726C 726C 7272 6C72 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 6C6E ED8E 0063"            
	$"F990 0357 170E 0EF8 9001 471A FE17 0623"            
	$"9090 6100 001C FE90 0938 1C19 1903 008C"            
	$"9090 88FD 8E07 3828 1C12 0A05 0100 5B02"            
	$"0000 01FD 0001 0220 E68E 2C41 4E6C 6C72"            
	$"6C72 6C72 6C72 6C72 6C72 726C 726C 726C"            
	$"726C 7272 6C72 6C72 726C 726C 726C 726C"            
	$"726C 726C 726C 725D ED8E 007F E490 038C"            
	$"3D72 8CFE 9004 383C 3E72 6CFD 9000 73FD"            
	$"8E07 3828 1C12 0A05 0100 49FE 0005 0100"            
	$"0100 0222 E48E 0476 3F4B 6C6C FE72 216C"            
	$"726C 726C 7272 6C72 6C72 6C72 6C72 726C"            
	$"726C 7272 6C72 6C72 6C72 6C72 6C72 6C72"            
	$"6CEC 8E00 87D4 9000 7DFD 8E07 3828 1C12"            
	$"0A05 0100 4D08 0000 0100 0100 0002 20E0"            
	$"8E05 5D78 785A 536C FE72 1C6C 7272 6C72"            
	$"6C72 6C72 6C72 726C 726C 7272 6C72 6C72"            
	$"6C72 6C72 6C72 6C48 EC8E 0078 ED8A F889"            
	$"F68A 0365 7873 77FB 8E07 3828 1C12 0A05"            
	$"0100 33FA 0001 0222 DA8E 1F43 6C6C 726C"            
	$"7272 6C72 6C72 6C72 6C72 726C 726C 7272"            
	$"6C72 6C72 6C72 6C72 6C72 50B9 8E07 3828"            
	$"1C12 0A05 0100 3508 0000 0100 0100 0002"            
	$"20D8 8E06 7765 6F4B 606C 6CFE 7212 6C72"            
	$"6C72 726C 726C 7272 6C72 6C72 6C72 6C72"            
	$"6CB8 8E07 3828 1C12 0A05 0100 30FE 0005"            
	$"0100 0100 0222 D48E 1876 4160 6C72 6C72"            
	$"6C72 6C72 726C 726C 7272 6C72 6C72 604B"            
	$"4277 B88E 0738 281C 120A 0501 002A 0200"            
	$"0001 FD00 0102 20D2 8E12 7748 6C72 6C72"            
	$"6C72 6C72 726C 726C 7272 5443 49B4 8E07"            
	$"3828 1C12 0A05 0100 23FD 0004 0100 0002"            
	$"22CF 8E0C 6A5A 5472 6C6C 5352 5A78 786A"            
	$"76B1 8E07 3828 1C12 0A05 0100 1A08 0000"            
	$"0100 0001 0002 20CC 8E01 7758 A98E 0738"            
	$"281C 120A 0501 0016 FE00 0001 FE00 0102"            
	$"2281 8EF2 8E07 3828 1C12 0A05 0100 1708"            
	$"0000 0100 0100 0002 2081 8EF2 8E07 3828"            
	$"1C12 0A05 0100 14FC 0003 0100 0222 818E"            
	$"F28E 0738 281C 120A 0501 00A2 7F00 0001"            
	$"0001 0000 0213 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 2022 2022"            
	$"2022 2022 2022 2022 2022 2022 201F 2220"            
	$"2220 2220 2220 2220 2220 2220 2220 2220"            
	$"2220 2220 2220 3B25 1F12 0A05 0100 16FE"            
	$"0000 01FE 0001 0208 810A F20A 072E 281F"            
	$"120A 0501 0019 0900 0001 0000 0100 0002"            
	$"0481 06F4 0608 0430 281F 120A 0501 0013"            
	$"FD00 0001 FC00 8102 F302 0738 281F 120A"            
	$"0501 0015 0200 0001 FC00 0001 8100 F200"            
	$"0738 251F 120A 0501 0038 FE00 0501 0001"            
	$"0000 01F8 0000 03FD 0002 1214 07E3 0009"            
	$"0307 080C 1214 112A 2E1F E300 0901 0A0C"            
	$"0C07 0000 1722 1FD3 0007 3828 1C12 0A05"            
	$"0100 4B07 0000 0100 0100 0001 F900 0903"            
	$"2572 2A00 0014 6C6C 11F5 0008 0519 0C00"            
	$"0003 0C0C 01FD 0005 031F 343E 6C72 FC6C"            
	$"0334 2F6C 2FE4 0001 013E FE6C 0522 0000"            
	$"6C72 2FD3 0007 3428 1F12 0A05 0100 97F9"            
	$"002E 0100 0001 0001 0001 126C 7272 0A00"            
	$"3D6C 6C1B 0001 051C 2F25 0B00 0119 6C60"            
	$"6172 1B00 1260 6C6C 470C 0000 0105 6C72"            
	$"6CFA 7261 2F47 6C34 0000 0100 0100 0B1B"            
	$"1A14 0001 0001 000A 0A05 1C1A 0B00 0100"            
	$"0100 0100 013D 6C6C 7272 2F00 056C 6C34"            
	$"0000 0100 0105 1C13 0719 1C13 0300 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0105 0C0A 0100 0100 0100 0100 0100 3828"            
	$"1C12 0A05 0100 A007 0000 0100 0100 0001"            
	$"FD00 0901 0001 0014 7272 6C51 3CFE 720A"            
	$"2500 1F72 6C6C 726C 2E08 25FE 720C 6C1F"            
	$"2F6C 5125 1B51 6C17 0000 05FE 4703 516C"            
	$"726C FE47 1923 6C6C 2A12 1F19 0500 256C"            
	$"726C 7261 2F0A 003E 7272 6C72 6C51 0EFE"            
	$"0044 0100 0019 7272 3822 2522 0007 7272"            
	$"3E23 2F2A 1701 0C6C 726C 6C72 7219 0E28"            
	$"3447 2F1B 070E 473C 1F25 1A2A 342F 0E00"            
	$"0E38 6C6C 7238 0700 0100 0100 0100 0134"            
	$"281F 120A 0501 008B FE00 0801 0001 0000"            
	$"0100 0001 FD00 0213 726C FB72 172F 036C"            
	$"7272 1414 6172 2A28 726C 3E07 1172 6C19"            
	$"0828 7272 3EFB 0008 0C72 726C 0800 0001"            
	$"6CFD 720D 6C6C 0719 382A 2A6C 726C 2E00"            
	$"726C FB72 0804 0001 0000 012A 7228 FC00"            
	$"0305 6C72 6CFE 7203 6C13 0C6C FD72 036C"            
	$"146C 72FE 6C03 726C 236C FC72 FE6C 0808"            
	$"7272 340C 1972 4701 FA00 0738 281C 120A"            
	$"0501 0096 0200 0001 FC00 0001 FD00 2601"            
	$"0000 1372 726C 726C 726C 6C60 0C72 6C19"            
	$"0000 2E72 2F28 6C72 0A00 126C 7272 6C72"            
	$"6C47 1700 0001 FE00 0B05 6C72 7205 0000"            
	$"056C 7272 6CFE 7202 1900 1FFC 720A 6101"            
	$"6C72 7247 1B47 6C72 11FE 0004 0100 2F6C"            
	$"0CFE 0002 0100 07FE 7200 6CFE 7210 280C"            
	$"7272 6C2A 0C11 1F72 380C 0C19 7272 34F8"            
	$"7217 1B72 6C0F 0528 6C6C 0500 0001 0001"            
	$"0000 3428 1F12 0A05 0100 9FFD 0003 0100"            
	$"0001 FE00 6701 0000 0100 1372 6C3E 7272"            
	$"5147 6C72 0A6C 7228 0C19 516C 2A25 7272"            
	$"0000 0E72 726C 512F 3860 1A01 0000 0100"            
	$"0100 6172 7205 0000 0772 726C 2A38 6C72"            
	$"3C08 6172 120C 1F72 6C1A 6172 6C0B 0001"            
	$"4772 1F00 0001 0000 2F6C 3813 131C 2E1F"            
	$"0A6C 726C 1911 6C6C 5101 726C 72FE 001A"            
	$"2372 1900 000B 726C 4672 6014 2E6C 720A"            
	$"2E72 2F6C 7251 7261 383C 11FE 000B 0100"            
	$"0100 3828 1C12 0A05 0100 9C08 0000 0100"            
	$"0001 0000 01FE 0010 0100 0001 1372 7212"            
	$"146C 0A34 726C 0C34 6CFE 7205 6C47 0328"            
	$"6C72 FE00 0813 7272 6C6C 7272 5101 FE00"            
	$"0E01 0000 4772 7205 0000 0B72 6C1B 0005"            
	$"FE72 1105 6C6C 1B3C 726C 723C 4772 7205"            
	$"0000 2572 2EFD 0001 0123 FA72 0C1B 726C"            
	$"2500 001A 726C 1372 7260 FE00 1D19 6C72"            
	$"382A 4F72 722E 7228 000C 726C 001B 722C"            
	$"726C 726C 4751 6C1A 0100 01FE 0008 0134"            
	$"281F 120A 0501 009D FE00 0001 FD00 1D01"            
	$"0000 0100 0100 0011 4747 1100 0300 1F34"            
	$"2F0C 0413 1B1B 1911 0300 1228 25FD 0006"            
	$"081C 2825 2319 08FE 0000 01FE 0008 232F"            
	$"3805 0000 0825 1FFE 002E 1222 1B08 0F38"            
	$"473C 2A51 5728 3838 3403 0000 1728 0B00"            
	$"0001 0000 031B 516C 7260 3823 142F 2A0C"            
	$"0000 012A 280E 4760 2FFE 001A 0314 2F3E"            
	$"4738 1F08 2F72 1900 081B 0F00 1323 0810"            
	$"2A6C 7272 6038 0CFD 000A 0100 0038 281C"            
	$"120A 0501 002F 0700 0001 0001 0000 01FB"            
	$"0000 01DD 0003 0100 0001 DE00 0201 0001"            
	$"EA00 0001 E400 0D01 0001 0001 0034 281F"            
	$"120A 0501 0038 FC00 0801 0000 0100 0001"            
	$"0001 E900 0201 0001 F800 0301 0000 01F8"            
	$"0004 0100 0100 01F9 0000 01F9 0000 01C4"            
	$"0000 01FD 0007 3828 1C12 0A05 0100 A204"            
	$"0000 0100 01FE 0000 01FE 007F 0100 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 0000 0100 0001 0001 0001 0001 0000"            
	$"0100 0100 0001 0001 0001 0001 0000 0100"            
	$"0100 0100 0100 0001 0001 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 0001 0001 0001"            
	$"0001 0001 0001 0001 0001 0001 0500 0100"            
	$"0100 01FE 000A 0100 0134 281F 120A 0501"            
	$"009C FE00 0001 FE00 0001 FE00 1901 0000"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 01FC 0014 0100 0100 0100"            
	$"0100 0001 0000 0100 0100 0100 0100 01FC"            
	$"005B 0100 0100 0100 0100 0001 0001 0001"            
	$"0001 0000 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 0100 0100 0100 0100 0100"            
	$"0100 0100 0100 3428 1C11 0A05 0100 3A08"            
	$"0000 0100 0001 0000 01FD 0000 01E9 0002"            
	$"0100 01F8 0003 0100 0001 F800 0401 0001"            
	$"0001 F900 0001 F900 0001 C400 0001 FD00"            
	$"0734 251C 110A 0501 003B FD00 0001 FE00"            
	$"0801 0405 0B0E 1112 1714 EC17 0014 F617"            
	$"0314 1717 14F8 1700 14FE 1700 14F9 1700"            
	$"14F9 1700 14C4 170C 1417 1714 142E 2319"            
	$"1108 0501 0038 0200 0001 FD00 0801 0308"            
	$"0C12 1F23 2A2E EB2F 0034 F62F 0034 F52F"            
	$"0034 FE2F 0034 F92F 0034 F92F 0034 C42F"            
	$"0034 FE2F 082E 251C 190C 0804 0100 30FE"            
	$"000C 0100 0100 0001 050A 0F14 191F 22DF"            
	$"2300 22F1 2300 22F9 2300 22F9 2300 22C4"            
	$"230C 2223 2322 1F1B 1411 0C05 0400 00A1"            
	$"0400 0001 0001 FE00 7F01 0405 0B0F 1112"            
	$"1414 1914 1714 1914 1914 1714 1914 1914"            
	$"1714 1914 1914 1714 1914 1914 1419 1419"            
	$"1414 1914 1914 1714 1914 1914 1714 1914"            
	$"1914 1419 1419 1414 1914 1914 1419 1419"            
	$"1414 1914 1914 1714 1914 1914 1419 1419"            
	$"1414 1914 1914 1419 1419 1414 1914 1914"            
	$"1419 1419 1414 1914 1914 1419 1419 1414"            
	$"1914 1914 1419 1419 140B 1419 1419 1414"            
	$"1914 1914 1419 FD14 0712 0E0C 0804 0100"            
	$"007B FB00 0B01 0001 0105 080A 0C0C 0F0F"            
	$"0EFC 0F00 0EFC 0F00 0EFC 0F00 0EFC 0F00"            
	$"0EFD 0F00 0EFD 0F00 0EFC 0F00 0EFC 0F00"            
	$"0EFD 0F00 0EFD 0F00 0EFD 0F00 0EFD 0F00"            
	$"0EFC 0F00 0EFD 0F00 0EFD 0F00 0EFD 0F00"            
	$"0EFD 0F00 0EFD 0F00 0EFD 0F00 0EFD 0F00"            
	$"0EFD 0F00 0EFD 0F00 0EFD 0F00 0EFD 0F00"            
	$"0EFB 0F08 0C0C 0A08 0501 0100 0087 0400"            
	$"0001 0001 FD00 0601 0103 0505 0807 FE08"            
	$"0207 0807 FD08 0007 FD08 0207 0807 FD08"            
	$"0007 FD08 0007 FD08 0007 FD08 0207 0807"            
	$"FD08 0007 FD08 0007 FD08 0007 FD08 0007"            
	$"FD08 0007 FD08 0207 0807 FD08 0007 FD08"            
	$"0007 FD08 0007 FD08 0007 FD08 0007 FD08"            
	$"0007 FD08 0007 FD08 0007 FD08 0007 FD08"            
	$"0007 FD08 0007 FD08 0007 FE08 0507 0505"            
	$"0401 01FE 0099 FE00 0201 0001 FC00 FD01"            
	$"7F03 0101 0301 0301 0301 0103 0103 0101"            
	$"0301 0301 0301 0103 0103 0101 0301 0301"            
	$"0103 0103 0101 0301 0301 0301 0103 0103"            
	$"0101 0301 0301 0103 0103 0101 0301 0301"            
	$"0103 0103 0101 0301 0301 0301 0103 0103"            
	$"0101 0301 0301 0103 0103 0101 0301 0301"            
	$"0103 0103 0101 0301 0301 0103 0103 0101"            
	$"0301 0301 0103 0103 0101 0301 0301 0103"            
	$"0108 0301 0103 0103 0101 04FD 01FD 0099"            
	$"0200 0001 FE00 0001 FA00 7F01 0001 0100"            
	$"0100 0100 0101 0001 0001 0100 0100 0100"            
	$"0101 0001 0001 0100 0100 0101 0001 0001"            
	$"0100 0100 0100 0101 0001 0001 0100 0100"            
	$"0101 0001 0001 0100 0100 0101 0001 0001"            
	$"0100 0100 0100 0101 0001 0001 0100 0100"            
	$"0101 0001 0001 0100 0100 0101 0001 0001"            
	$"0100 0100 0101 0001 0001 0100 0100 0101"            
	$"0001 0001 0100 0100 0101 000A 0100 0101"            
	$"0001 0001 0100 01FA 0010 FD00 0501 0000"            
	$"0100 0181 00ED 0001 0100 150B 0000 0100"            
	$"0001 0000 0100 0001 8100 F000 0201 0000"            
	$"00FF"                                               
};
/*
 * Here is the custom file open dialog. This dialog is used instead of
 * the default file dialog if the -filetypes flag is specified.
 */

resource 'DLOG' (130, purgeable) {
    {0, 0, 195, 344}, dBoxProc, invisible, noGoAway, 0,
     130, "", centerMainScreen
};

resource 'DITL' (130, "File Open Box", purgeable) {
    {
	{135, 252, 155, 332}, Button   {enabled, "Open"},
	{104, 252, 124, 332}, Button   {enabled, "Cancel"},	    
        {  0,   0,   0,   0}, HelpItem {disabled, HMScanhdlg {130}},
        {  8, 235,  24, 337}, UserItem {enabled},
        { 32, 252,  52, 332}, Button   {enabled, "Eject"},
        { 60, 252,  80, 332}, Button   {enabled, "Desktop"},    
        { 29,  12, 159, 230}, UserItem {enabled},
        {  6,  12,  25, 230}, UserItem {enabled},
        { 91, 251,  92, 333}, Picture  {disabled, 11},
        {168,  20, 187, 300}, Control  {enabled, 131} 
    }
};

resource 'CNTL' (131, "File Types menu", purgeable) {
    {168, 20, 187, 300},
    popupTitleLeftJust,
    visible,
    80,
    132,
    popupMenuCDEFProc,
    0,
    "File Type:"
};


resource 'MENU' (132, preload) {
    132,
    textMenuProc,
    0xFFFF, enabled, "", {}
};
