// Implementation file for parser generated by fsyacc
#light "off"
module Pars
#nowarn "64";; // turn off warnings that type variables used in production annotations are instantiated to concrete type
open Microsoft.FSharp.Text.Lexing
open Microsoft.FSharp.Text.Parsing.ParseHelpers
# 1 "pars.fsy"


open Ast

type StringOrList = {asstring:string; aslist:string list}


# 15 "pars.fs"
// This type is the type of tokens accepted by the parser
type token = 
  | EOF
  | LBRACE
  | RBRACE
  | SEMI
  | LPAREN
  | RPAREN
  | COLON
  | DOT
  | LANGLE
  | RANGLE
  | COMMA
  | STAR
  | PAR
  | PLUS
  | MINUS
  | DIV
  | EQUALS
  | EQEQUALS
  | NOTEQUALS
  | AND
  | OR
  | ABOVEEQUALS
  | BELOWEQUALS
  | COLONEQUALS
  | PLING
  | ACTIVITY
  | IF
  | CALL
  | EXTERNAL
  | TYPE
  | CLASS
  | ENUM
  | IMPORTANT
  | UNIMPORTANT
  | NEW
  | SIGNAL
  | THEN
  | ELSE
  | ON
  | FIRST
  | RETURN
  | EXTERN
  | BEGINREAD
  | ENDREAD
  | BEGINWRITE
  | ENDWRITE
  | BOOL of (bool)
  | STRING of (string)
  | FLOAT of (System.Double)
  | INT of (System.Int32)
  | ID of (string)
// This type is used to give symbolic names to token indexes, useful for error messages
type tokenId = 
    | TOKEN_EOF
    | TOKEN_LBRACE
    | TOKEN_RBRACE
    | TOKEN_SEMI
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_COLON
    | TOKEN_DOT
    | TOKEN_LANGLE
    | TOKEN_RANGLE
    | TOKEN_COMMA
    | TOKEN_STAR
    | TOKEN_PAR
    | TOKEN_PLUS
    | TOKEN_MINUS
    | TOKEN_DIV
    | TOKEN_EQUALS
    | TOKEN_EQEQUALS
    | TOKEN_NOTEQUALS
    | TOKEN_AND
    | TOKEN_OR
    | TOKEN_ABOVEEQUALS
    | TOKEN_BELOWEQUALS
    | TOKEN_COLONEQUALS
    | TOKEN_PLING
    | TOKEN_ACTIVITY
    | TOKEN_IF
    | TOKEN_CALL
    | TOKEN_EXTERNAL
    | TOKEN_TYPE
    | TOKEN_CLASS
    | TOKEN_ENUM
    | TOKEN_IMPORTANT
    | TOKEN_UNIMPORTANT
    | TOKEN_NEW
    | TOKEN_SIGNAL
    | TOKEN_THEN
    | TOKEN_ELSE
    | TOKEN_ON
    | TOKEN_FIRST
    | TOKEN_RETURN
    | TOKEN_EXTERN
    | TOKEN_BEGINREAD
    | TOKEN_ENDREAD
    | TOKEN_BEGINWRITE
    | TOKEN_ENDWRITE
    | TOKEN_BOOL
    | TOKEN_STRING
    | TOKEN_FLOAT
    | TOKEN_INT
    | TOKEN_ID
    | TOKEN_end_of_input
    | TOKEN_error
// This type is used to give symbolic names to token indexes, useful for error messages
type nonTerminalId = 
    | NONTERM__startstart
    | NONTERM__startExpr
    | NONTERM_start
    | NONTERM_TypeOrActivityList
    | NONTERM_TypeOrActivity
    | NONTERM_FieldList
    | NONTERM_Field
    | NONTERM_EnumList
    | NONTERM_TypeList
    | NONTERM_ImpId
    | NONTERM_StateOrHandlerList
    | NONTERM_StateOrHandler
    | NONTERM_NodeList
    | NONTERM_Node
    | NONTERM_ExprNode
    | NONTERM_OtherNode
    | NONTERM_IdList
    | NONTERM_ArgList
    | NONTERM_Arg
    | NONTERM_IdPath
    | NONTERM_Atomic
    | NONTERM_Wires
    | NONTERM_WireList
    | NONTERM_Wire
    | NONTERM_IfList
    | NONTERM_CondAndConsequence
    | NONTERM_Consequence
    | NONTERM_IfTypeList
    | NONTERM_TypeCondAndConsequence
    | NONTERM_TypeConsequence
    | NONTERM_Expr
    | NONTERM_ExprList
    | NONTERM_AssignList

// This function maps tokens to integers indexes
let tagOfToken (t:token) = 
  match t with
  | EOF  -> 0 
  | LBRACE  -> 1 
  | RBRACE  -> 2 
  | SEMI  -> 3 
  | LPAREN  -> 4 
  | RPAREN  -> 5 
  | COLON  -> 6 
  | DOT  -> 7 
  | LANGLE  -> 8 
  | RANGLE  -> 9 
  | COMMA  -> 10 
  | STAR  -> 11 
  | PAR  -> 12 
  | PLUS  -> 13 
  | MINUS  -> 14 
  | DIV  -> 15 
  | EQUALS  -> 16 
  | EQEQUALS  -> 17 
  | NOTEQUALS  -> 18 
  | AND  -> 19 
  | OR  -> 20 
  | ABOVEEQUALS  -> 21 
  | BELOWEQUALS  -> 22 
  | COLONEQUALS  -> 23 
  | PLING  -> 24 
  | ACTIVITY  -> 25 
  | IF  -> 26 
  | CALL  -> 27 
  | EXTERNAL  -> 28 
  | TYPE  -> 29 
  | CLASS  -> 30 
  | ENUM  -> 31 
  | IMPORTANT  -> 32 
  | UNIMPORTANT  -> 33 
  | NEW  -> 34 
  | SIGNAL  -> 35 
  | THEN  -> 36 
  | ELSE  -> 37 
  | ON  -> 38 
  | FIRST  -> 39 
  | RETURN  -> 40 
  | EXTERN  -> 41 
  | BEGINREAD  -> 42 
  | ENDREAD  -> 43 
  | BEGINWRITE  -> 44 
  | ENDWRITE  -> 45 
  | BOOL _ -> 46 
  | STRING _ -> 47 
  | FLOAT _ -> 48 
  | INT _ -> 49 
  | ID _ -> 50 

// This function maps integers indexes to symbolic token ids
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_EOF 
  | 1 -> TOKEN_LBRACE 
  | 2 -> TOKEN_RBRACE 
  | 3 -> TOKEN_SEMI 
  | 4 -> TOKEN_LPAREN 
  | 5 -> TOKEN_RPAREN 
  | 6 -> TOKEN_COLON 
  | 7 -> TOKEN_DOT 
  | 8 -> TOKEN_LANGLE 
  | 9 -> TOKEN_RANGLE 
  | 10 -> TOKEN_COMMA 
  | 11 -> TOKEN_STAR 
  | 12 -> TOKEN_PAR 
  | 13 -> TOKEN_PLUS 
  | 14 -> TOKEN_MINUS 
  | 15 -> TOKEN_DIV 
  | 16 -> TOKEN_EQUALS 
  | 17 -> TOKEN_EQEQUALS 
  | 18 -> TOKEN_NOTEQUALS 
  | 19 -> TOKEN_AND 
  | 20 -> TOKEN_OR 
  | 21 -> TOKEN_ABOVEEQUALS 
  | 22 -> TOKEN_BELOWEQUALS 
  | 23 -> TOKEN_COLONEQUALS 
  | 24 -> TOKEN_PLING 
  | 25 -> TOKEN_ACTIVITY 
  | 26 -> TOKEN_IF 
  | 27 -> TOKEN_CALL 
  | 28 -> TOKEN_EXTERNAL 
  | 29 -> TOKEN_TYPE 
  | 30 -> TOKEN_CLASS 
  | 31 -> TOKEN_ENUM 
  | 32 -> TOKEN_IMPORTANT 
  | 33 -> TOKEN_UNIMPORTANT 
  | 34 -> TOKEN_NEW 
  | 35 -> TOKEN_SIGNAL 
  | 36 -> TOKEN_THEN 
  | 37 -> TOKEN_ELSE 
  | 38 -> TOKEN_ON 
  | 39 -> TOKEN_FIRST 
  | 40 -> TOKEN_RETURN 
  | 41 -> TOKEN_EXTERN 
  | 42 -> TOKEN_BEGINREAD 
  | 43 -> TOKEN_ENDREAD 
  | 44 -> TOKEN_BEGINWRITE 
  | 45 -> TOKEN_ENDWRITE 
  | 46 -> TOKEN_BOOL 
  | 47 -> TOKEN_STRING 
  | 48 -> TOKEN_FLOAT 
  | 49 -> TOKEN_INT 
  | 50 -> TOKEN_ID 
  | 53 -> TOKEN_end_of_input
  | 51 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: bad token"

/// This function maps production indexes returned in syntax errors to strings representing the non terminal that would be produced by that production
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startstart 
    | 1 -> NONTERM__startExpr 
    | 2 -> NONTERM_start 
    | 3 -> NONTERM_TypeOrActivityList 
    | 4 -> NONTERM_TypeOrActivityList 
    | 5 -> NONTERM_TypeOrActivity 
    | 6 -> NONTERM_TypeOrActivity 
    | 7 -> NONTERM_TypeOrActivity 
    | 8 -> NONTERM_TypeOrActivity 
    | 9 -> NONTERM_TypeOrActivity 
    | 10 -> NONTERM_TypeOrActivity 
    | 11 -> NONTERM_TypeOrActivity 
    | 12 -> NONTERM_TypeOrActivity 
    | 13 -> NONTERM_FieldList 
    | 14 -> NONTERM_FieldList 
    | 15 -> NONTERM_Field 
    | 16 -> NONTERM_EnumList 
    | 17 -> NONTERM_EnumList 
    | 18 -> NONTERM_TypeList 
    | 19 -> NONTERM_TypeList 
    | 20 -> NONTERM_TypeList 
    | 21 -> NONTERM_ImpId 
    | 22 -> NONTERM_ImpId 
    | 23 -> NONTERM_StateOrHandlerList 
    | 24 -> NONTERM_StateOrHandlerList 
    | 25 -> NONTERM_StateOrHandler 
    | 26 -> NONTERM_StateOrHandler 
    | 27 -> NONTERM_StateOrHandler 
    | 28 -> NONTERM_NodeList 
    | 29 -> NONTERM_NodeList 
    | 30 -> NONTERM_NodeList 
    | 31 -> NONTERM_NodeList 
    | 32 -> NONTERM_Node 
    | 33 -> NONTERM_Node 
    | 34 -> NONTERM_ExprNode 
    | 35 -> NONTERM_ExprNode 
    | 36 -> NONTERM_OtherNode 
    | 37 -> NONTERM_OtherNode 
    | 38 -> NONTERM_OtherNode 
    | 39 -> NONTERM_OtherNode 
    | 40 -> NONTERM_OtherNode 
    | 41 -> NONTERM_OtherNode 
    | 42 -> NONTERM_OtherNode 
    | 43 -> NONTERM_OtherNode 
    | 44 -> NONTERM_OtherNode 
    | 45 -> NONTERM_OtherNode 
    | 46 -> NONTERM_OtherNode 
    | 47 -> NONTERM_OtherNode 
    | 48 -> NONTERM_OtherNode 
    | 49 -> NONTERM_IdList 
    | 50 -> NONTERM_IdList 
    | 51 -> NONTERM_ArgList 
    | 52 -> NONTERM_ArgList 
    | 53 -> NONTERM_ArgList 
    | 54 -> NONTERM_Arg 
    | 55 -> NONTERM_Arg 
    | 56 -> NONTERM_IdPath 
    | 57 -> NONTERM_IdPath 
    | 58 -> NONTERM_Atomic 
    | 59 -> NONTERM_Atomic 
    | 60 -> NONTERM_Atomic 
    | 61 -> NONTERM_Atomic 
    | 62 -> NONTERM_Wires 
    | 63 -> NONTERM_Wires 
    | 64 -> NONTERM_WireList 
    | 65 -> NONTERM_WireList 
    | 66 -> NONTERM_WireList 
    | 67 -> NONTERM_Wire 
    | 68 -> NONTERM_Wire 
    | 69 -> NONTERM_IfList 
    | 70 -> NONTERM_IfList 
    | 71 -> NONTERM_IfList 
    | 72 -> NONTERM_CondAndConsequence 
    | 73 -> NONTERM_Consequence 
    | 74 -> NONTERM_IfTypeList 
    | 75 -> NONTERM_IfTypeList 
    | 76 -> NONTERM_IfTypeList 
    | 77 -> NONTERM_TypeCondAndConsequence 
    | 78 -> NONTERM_TypeConsequence 
    | 79 -> NONTERM_Expr 
    | 80 -> NONTERM_Expr 
    | 81 -> NONTERM_Expr 
    | 82 -> NONTERM_Expr 
    | 83 -> NONTERM_Expr 
    | 84 -> NONTERM_Expr 
    | 85 -> NONTERM_Expr 
    | 86 -> NONTERM_Expr 
    | 87 -> NONTERM_Expr 
    | 88 -> NONTERM_Expr 
    | 89 -> NONTERM_Expr 
    | 90 -> NONTERM_Expr 
    | 91 -> NONTERM_Expr 
    | 92 -> NONTERM_Expr 
    | 93 -> NONTERM_Expr 
    | 94 -> NONTERM_Expr 
    | 95 -> NONTERM_Expr 
    | 96 -> NONTERM_Expr 
    | 97 -> NONTERM_Expr 
    | 98 -> NONTERM_Expr 
    | 99 -> NONTERM_Expr 
    | 100 -> NONTERM_Expr 
    | 101 -> NONTERM_Expr 
    | 102 -> NONTERM_ExprList 
    | 103 -> NONTERM_ExprList 
    | 104 -> NONTERM_ExprList 
    | 105 -> NONTERM_AssignList 
    | 106 -> NONTERM_AssignList 
    | 107 -> NONTERM_AssignList 
    | _ -> failwith "prodIdxToNonTerminal: bad production index"

let _fsyacc_endOfInputTag = 53 
let _fsyacc_tagOfErrorTerminal = 51

// This function gets the name of a token as a string
let token_to_string (t:token) = 
  match t with 
  | EOF  -> "EOF" 
  | LBRACE  -> "LBRACE" 
  | RBRACE  -> "RBRACE" 
  | SEMI  -> "SEMI" 
  | LPAREN  -> "LPAREN" 
  | RPAREN  -> "RPAREN" 
  | COLON  -> "COLON" 
  | DOT  -> "DOT" 
  | LANGLE  -> "LANGLE" 
  | RANGLE  -> "RANGLE" 
  | COMMA  -> "COMMA" 
  | STAR  -> "STAR" 
  | PAR  -> "PAR" 
  | PLUS  -> "PLUS" 
  | MINUS  -> "MINUS" 
  | DIV  -> "DIV" 
  | EQUALS  -> "EQUALS" 
  | EQEQUALS  -> "EQEQUALS" 
  | NOTEQUALS  -> "NOTEQUALS" 
  | AND  -> "AND" 
  | OR  -> "OR" 
  | ABOVEEQUALS  -> "ABOVEEQUALS" 
  | BELOWEQUALS  -> "BELOWEQUALS" 
  | COLONEQUALS  -> "COLONEQUALS" 
  | PLING  -> "PLING" 
  | ACTIVITY  -> "ACTIVITY" 
  | IF  -> "IF" 
  | CALL  -> "CALL" 
  | EXTERNAL  -> "EXTERNAL" 
  | TYPE  -> "TYPE" 
  | CLASS  -> "CLASS" 
  | ENUM  -> "ENUM" 
  | IMPORTANT  -> "IMPORTANT" 
  | UNIMPORTANT  -> "UNIMPORTANT" 
  | NEW  -> "NEW" 
  | SIGNAL  -> "SIGNAL" 
  | THEN  -> "THEN" 
  | ELSE  -> "ELSE" 
  | ON  -> "ON" 
  | FIRST  -> "FIRST" 
  | RETURN  -> "RETURN" 
  | EXTERN  -> "EXTERN" 
  | BEGINREAD  -> "BEGINREAD" 
  | ENDREAD  -> "ENDREAD" 
  | BEGINWRITE  -> "BEGINWRITE" 
  | ENDWRITE  -> "ENDWRITE" 
  | BOOL _ -> "BOOL" 
  | STRING _ -> "STRING" 
  | FLOAT _ -> "FLOAT" 
  | INT _ -> "INT" 
  | ID _ -> "ID" 

// This function gets the data carried by a token as an object
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | EOF  -> (null : System.Object) 
  | LBRACE  -> (null : System.Object) 
  | RBRACE  -> (null : System.Object) 
  | SEMI  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | COLON  -> (null : System.Object) 
  | DOT  -> (null : System.Object) 
  | LANGLE  -> (null : System.Object) 
  | RANGLE  -> (null : System.Object) 
  | COMMA  -> (null : System.Object) 
  | STAR  -> (null : System.Object) 
  | PAR  -> (null : System.Object) 
  | PLUS  -> (null : System.Object) 
  | MINUS  -> (null : System.Object) 
  | DIV  -> (null : System.Object) 
  | EQUALS  -> (null : System.Object) 
  | EQEQUALS  -> (null : System.Object) 
  | NOTEQUALS  -> (null : System.Object) 
  | AND  -> (null : System.Object) 
  | OR  -> (null : System.Object) 
  | ABOVEEQUALS  -> (null : System.Object) 
  | BELOWEQUALS  -> (null : System.Object) 
  | COLONEQUALS  -> (null : System.Object) 
  | PLING  -> (null : System.Object) 
  | ACTIVITY  -> (null : System.Object) 
  | IF  -> (null : System.Object) 
  | CALL  -> (null : System.Object) 
  | EXTERNAL  -> (null : System.Object) 
  | TYPE  -> (null : System.Object) 
  | CLASS  -> (null : System.Object) 
  | ENUM  -> (null : System.Object) 
  | IMPORTANT  -> (null : System.Object) 
  | UNIMPORTANT  -> (null : System.Object) 
  | NEW  -> (null : System.Object) 
  | SIGNAL  -> (null : System.Object) 
  | THEN  -> (null : System.Object) 
  | ELSE  -> (null : System.Object) 
  | ON  -> (null : System.Object) 
  | FIRST  -> (null : System.Object) 
  | RETURN  -> (null : System.Object) 
  | EXTERN  -> (null : System.Object) 
  | BEGINREAD  -> (null : System.Object) 
  | ENDREAD  -> (null : System.Object) 
  | BEGINWRITE  -> (null : System.Object) 
  | ENDWRITE  -> (null : System.Object) 
  | BOOL _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | STRING _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | FLOAT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | INT _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | ID _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us; 65535us; 0us; 65535us; 1us; 65535us; 0us; 1us; 2us; 65535us; 0us; 4us; 6us; 7us; 2us; 65535us; 0us; 6us; 6us; 6us; 2us; 65535us; 10us; 11us; 49us; 50us; 2us; 65535us; 10us; 49us; 49us; 49us; 1us; 65535us; 15us; 16us; 18us; 65535us; 20us; 21us; 31us; 70us; 34us; 35us; 36us; 70us; 41us; 70us; 44us; 45us; 46us; 70us; 58us; 59us; 60us; 61us; 68us; 70us; 81us; 82us; 83us; 96us; 86us; 96us; 91us; 96us; 192us; 95us; 200us; 95us; 204us; 95us; 212us; 95us; 19us; 65535us; 20us; 57us; 31us; 57us; 34us; 57us; 36us; 57us; 41us; 57us; 44us; 57us; 46us; 57us; 58us; 57us; 60us; 57us; 68us; 57us; 77us; 78us; 81us; 57us; 83us; 57us; 86us; 57us; 91us; 57us; 192us; 57us; 200us; 57us; 204us; 57us; 212us; 57us; 5us; 65535us; 31us; 32us; 36us; 37us; 41us; 42us; 46us; 47us; 68us; 69us; 5us; 65535us; 31us; 68us; 36us; 68us; 41us; 68us; 46us; 68us; 68us; 68us; 3us; 65535us; 83us; 84us; 86us; 87us; 91us; 92us; 3us; 65535us; 83us; 90us; 86us; 90us; 91us; 90us; 7us; 65535us; 83us; 93us; 86us; 93us; 91us; 93us; 192us; 202us; 200us; 202us; 204us; 214us; 212us; 214us; 3us; 65535us; 83us; 94us; 86us; 94us; 91us; 94us; 3us; 65535us; 152us; 153us; 156us; 157us; 210us; 164us; 2us; 65535us; 25us; 26us; 168us; 169us; 2us; 65535us; 25us; 167us; 168us; 167us; 36us; 65535us; 2us; 175us; 72us; 175us; 101us; 175us; 102us; 117us; 106us; 175us; 107us; 120us; 118us; 175us; 121us; 175us; 127us; 175us; 134us; 175us; 142us; 175us; 146us; 175us; 149us; 175us; 196us; 175us; 197us; 175us; 215us; 175us; 236us; 175us; 237us; 175us; 238us; 175us; 239us; 175us; 240us; 175us; 241us; 175us; 242us; 175us; 243us; 175us; 244us; 175us; 245us; 175us; 246us; 175us; 247us; 175us; 248us; 175us; 249us; 174us; 250us; 175us; 253us; 175us; 262us; 175us; 263us; 175us; 264us; 175us; 267us; 175us; 2us; 65535us; 102us; 109us; 107us; 113us; 10us; 65535us; 83us; 137us; 86us; 137us; 91us; 137us; 99us; 101us; 100us; 102us; 104us; 106us; 105us; 107us; 145us; 146us; 148us; 149us; 159us; 160us; 2us; 65535us; 182us; 183us; 186us; 187us; 3us; 65535us; 78us; 79us; 182us; 185us; 186us; 185us; 2us; 65535us; 160us; 161us; 193us; 194us; 2us; 65535us; 160us; 191us; 193us; 191us; 2us; 65535us; 192us; 195us; 200us; 201us; 2us; 65535us; 160us; 162us; 205us; 206us; 2us; 65535us; 160us; 203us; 205us; 203us; 2us; 65535us; 204us; 207us; 212us; 213us; 35us; 65535us; 2us; 3us; 72us; 73us; 101us; 103us; 102us; 103us; 106us; 108us; 107us; 108us; 118us; 119us; 121us; 122us; 127us; 128us; 134us; 135us; 142us; 143us; 146us; 147us; 149us; 150us; 196us; 198us; 197us; 198us; 215us; 216us; 236us; 218us; 237us; 219us; 238us; 220us; 239us; 221us; 240us; 222us; 241us; 223us; 242us; 224us; 243us; 225us; 244us; 226us; 245us; 227us; 246us; 228us; 247us; 229us; 248us; 230us; 250us; 234us; 253us; 231us; 262us; 232us; 263us; 233us; 264us; 234us; 267us; 235us; 2us; 65535us; 250us; 251us; 264us; 265us; 2us; 65535us; 259us; 260us; 268us; 269us; |]
let _fsyacc_sparseGotoTableRowOffsets = [|0us; 1us; 2us; 4us; 7us; 10us; 13us; 16us; 18us; 37us; 57us; 63us; 69us; 73us; 77us; 85us; 89us; 93us; 96us; 99us; 136us; 139us; 150us; 153us; 157us; 160us; 163us; 166us; 169us; 172us; 175us; 211us; 214us; |]
let _fsyacc_stateToProdIdxsTableElements = [| 1us; 0us; 1us; 0us; 1us; 1us; 13us; 1us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 2us; 1us; 2us; 1us; 4us; 1us; 4us; 1us; 5us; 1us; 5us; 1us; 5us; 1us; 5us; 1us; 5us; 1us; 6us; 1us; 6us; 1us; 6us; 2us; 6us; 17us; 1us; 6us; 1us; 7us; 1us; 7us; 1us; 7us; 1us; 7us; 3us; 8us; 11us; 12us; 1us; 8us; 1us; 8us; 1us; 8us; 1us; 8us; 1us; 8us; 1us; 8us; 2us; 9us; 10us; 2us; 9us; 10us; 1us; 9us; 1us; 9us; 1us; 9us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 2us; 11us; 12us; 2us; 11us; 12us; 1us; 11us; 1us; 11us; 1us; 11us; 1us; 12us; 1us; 12us; 1us; 12us; 1us; 12us; 1us; 12us; 1us; 14us; 1us; 14us; 1us; 15us; 1us; 15us; 1us; 15us; 1us; 16us; 1us; 17us; 1us; 17us; 2us; 18us; 19us; 1us; 19us; 1us; 19us; 1us; 20us; 1us; 20us; 1us; 20us; 1us; 21us; 1us; 21us; 1us; 22us; 2us; 22us; 35us; 6us; 22us; 35us; 37us; 39us; 41us; 46us; 1us; 24us; 1us; 24us; 1us; 25us; 1us; 25us; 1us; 25us; 13us; 25us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 25us; 2us; 26us; 27us; 2us; 26us; 27us; 2us; 26us; 27us; 2us; 26us; 27us; 2us; 26us; 27us; 2us; 26us; 27us; 1us; 26us; 1us; 26us; 1us; 26us; 1us; 26us; 1us; 26us; 1us; 27us; 1us; 27us; 1us; 27us; 1us; 29us; 2us; 30us; 31us; 1us; 31us; 1us; 31us; 1us; 32us; 1us; 33us; 1us; 34us; 5us; 34us; 36us; 38us; 40us; 45us; 1us; 34us; 5us; 34us; 36us; 38us; 40us; 45us; 1us; 34us; 5us; 34us; 36us; 38us; 40us; 45us; 1us; 34us; 5us; 34us; 36us; 38us; 40us; 45us; 13us; 34us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 35us; 5us; 35us; 37us; 39us; 41us; 46us; 1us; 35us; 5us; 35us; 37us; 39us; 41us; 46us; 13us; 35us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 36us; 1us; 36us; 1us; 36us; 1us; 36us; 1us; 37us; 1us; 37us; 1us; 37us; 1us; 37us; 3us; 38us; 57us; 98us; 1us; 38us; 13us; 38us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 3us; 39us; 57us; 98us; 1us; 39us; 13us; 39us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 40us; 1us; 40us; 1us; 40us; 1us; 40us; 1us; 40us; 13us; 40us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 40us; 1us; 41us; 1us; 41us; 1us; 41us; 1us; 41us; 1us; 41us; 13us; 41us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 41us; 1us; 42us; 1us; 42us; 1us; 42us; 1us; 42us; 1us; 42us; 1us; 42us; 13us; 42us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 42us; 1us; 43us; 1us; 43us; 13us; 43us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 44us; 1us; 44us; 13us; 44us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 45us; 1us; 45us; 2us; 45us; 50us; 1us; 45us; 1us; 46us; 1us; 46us; 2us; 46us; 50us; 1us; 46us; 2us; 47us; 48us; 2us; 47us; 48us; 1us; 47us; 1us; 48us; 1us; 49us; 2us; 50us; 77us; 1us; 50us; 1us; 50us; 2us; 52us; 53us; 1us; 53us; 1us; 53us; 2us; 54us; 55us; 1us; 55us; 1us; 56us; 2us; 56us; 77us; 2us; 57us; 93us; 2us; 57us; 98us; 1us; 57us; 1us; 57us; 1us; 58us; 1us; 59us; 1us; 60us; 1us; 61us; 1us; 63us; 1us; 63us; 1us; 63us; 2us; 65us; 66us; 1us; 66us; 1us; 66us; 1us; 67us; 1us; 68us; 1us; 68us; 3us; 69us; 70us; 71us; 2us; 70us; 71us; 1us; 70us; 1us; 70us; 1us; 71us; 1us; 72us; 2us; 72us; 77us; 13us; 72us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 72us; 1us; 72us; 1us; 72us; 1us; 73us; 3us; 74us; 75us; 76us; 2us; 75us; 76us; 1us; 75us; 1us; 75us; 1us; 76us; 1us; 77us; 1us; 77us; 1us; 77us; 1us; 77us; 1us; 77us; 1us; 77us; 1us; 78us; 1us; 79us; 13us; 79us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 1us; 79us; 13us; 80us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 86us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 87us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 88us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 89us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 90us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 91us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 92us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 94us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 100us; 13us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 101us; 14us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 103us; 104us; 14us; 80us; 81us; 82us; 83us; 84us; 85us; 86us; 87us; 88us; 89us; 90us; 91us; 106us; 107us; 1us; 80us; 1us; 81us; 1us; 82us; 1us; 83us; 1us; 84us; 1us; 85us; 1us; 86us; 1us; 87us; 1us; 88us; 1us; 89us; 1us; 90us; 1us; 91us; 1us; 92us; 1us; 93us; 1us; 93us; 1us; 93us; 1us; 93us; 1us; 94us; 1us; 95us; 1us; 96us; 1us; 97us; 1us; 99us; 1us; 99us; 1us; 99us; 1us; 99us; 1us; 99us; 1us; 100us; 1us; 101us; 1us; 104us; 1us; 104us; 2us; 106us; 107us; 2us; 106us; 107us; 1us; 107us; 1us; 107us; |]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us; 2us; 4us; 6us; 20us; 22us; 24us; 26us; 28us; 30us; 32us; 34us; 36us; 38us; 40us; 42us; 44us; 47us; 49us; 51us; 53us; 55us; 57us; 61us; 63us; 65us; 67us; 69us; 71us; 73us; 76us; 79us; 81us; 83us; 85us; 87us; 89us; 91us; 93us; 95us; 98us; 101us; 103us; 105us; 107us; 109us; 111us; 113us; 115us; 117us; 119us; 121us; 123us; 125us; 127us; 129us; 131us; 133us; 136us; 138us; 140us; 142us; 144us; 146us; 148us; 150us; 152us; 155us; 162us; 164us; 166us; 168us; 170us; 172us; 186us; 188us; 191us; 194us; 197us; 200us; 203us; 206us; 208us; 210us; 212us; 214us; 216us; 218us; 220us; 222us; 224us; 227us; 229us; 231us; 233us; 235us; 237us; 243us; 245us; 251us; 253us; 259us; 261us; 267us; 281us; 283us; 289us; 291us; 297us; 311us; 313us; 315us; 317us; 319us; 321us; 323us; 325us; 327us; 331us; 333us; 347us; 351us; 353us; 367us; 369us; 371us; 373us; 375us; 377us; 391us; 393us; 395us; 397us; 399us; 401us; 403us; 417us; 419us; 421us; 423us; 425us; 427us; 429us; 431us; 445us; 447us; 449us; 451us; 465us; 467us; 469us; 483us; 485us; 487us; 490us; 492us; 494us; 496us; 499us; 501us; 504us; 507us; 509us; 511us; 513us; 516us; 518us; 520us; 523us; 525us; 527us; 530us; 532us; 534us; 537us; 540us; 543us; 545us; 547us; 549us; 551us; 553us; 555us; 557us; 559us; 561us; 564us; 566us; 568us; 570us; 572us; 574us; 578us; 581us; 583us; 585us; 587us; 589us; 592us; 606us; 608us; 610us; 612us; 614us; 618us; 621us; 623us; 625us; 627us; 629us; 631us; 633us; 635us; 637us; 639us; 641us; 643us; 657us; 659us; 673us; 687us; 701us; 715us; 729us; 743us; 757us; 771us; 785us; 799us; 813us; 827us; 841us; 855us; 869us; 883us; 898us; 913us; 915us; 917us; 919us; 921us; 923us; 925us; 927us; 929us; 931us; 933us; 935us; 937us; 939us; 941us; 943us; 945us; 947us; 949us; 951us; 953us; 955us; 957us; 959us; 961us; 963us; 965us; 967us; 969us; 971us; 973us; 976us; 979us; 981us; |]
let _fsyacc_action_rows = 270
let _fsyacc_actionTableElements = [|5us; 16387us; 25us; 29us; 29us; 18us; 30us; 8us; 31us; 13us; 41us; 22us; 0us; 49152us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 49152us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 32768us; 0us; 5us; 0us; 16386us; 5us; 16387us; 25us; 29us; 29us; 18us; 30us; 8us; 31us; 13us; 41us; 22us; 0us; 16388us; 1us; 32768us; 50us; 9us; 1us; 32768us; 1us; 10us; 1us; 16397us; 50us; 51us; 1us; 32768us; 2us; 12us; 0us; 16389us; 1us; 32768us; 50us; 14us; 1us; 32768us; 1us; 15us; 1us; 32768us; 50us; 54us; 2us; 32768us; 2us; 17us; 10us; 55us; 0us; 16390us; 1us; 32768us; 50us; 19us; 1us; 32768us; 16us; 20us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 65us; 0us; 16391us; 2us; 32768us; 25us; 39us; 50us; 23us; 1us; 32768us; 50us; 24us; 1us; 32768us; 4us; 25us; 1us; 16435us; 50us; 170us; 1us; 32768us; 5us; 27us; 1us; 32768us; 3us; 28us; 0us; 16392us; 1us; 32768us; 50us; 30us; 2us; 32768us; 1us; 31us; 6us; 34us; 4us; 16407us; 4us; 60us; 32us; 63us; 38us; 75us; 50us; 65us; 1us; 32768us; 2us; 33us; 0us; 16393us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 65us; 1us; 32768us; 1us; 36us; 4us; 16407us; 4us; 60us; 32us; 63us; 38us; 75us; 50us; 65us; 1us; 32768us; 2us; 38us; 0us; 16394us; 1us; 32768us; 50us; 40us; 2us; 32768us; 1us; 41us; 6us; 44us; 4us; 16407us; 4us; 60us; 32us; 63us; 38us; 75us; 50us; 65us; 1us; 32768us; 2us; 43us; 0us; 16395us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 65us; 1us; 32768us; 1us; 46us; 4us; 16407us; 4us; 60us; 32us; 63us; 38us; 75us; 50us; 65us; 1us; 32768us; 2us; 48us; 0us; 16396us; 1us; 16397us; 50us; 51us; 0us; 16398us; 1us; 32768us; 50us; 52us; 1us; 32768us; 3us; 53us; 0us; 16399us; 0us; 16400us; 1us; 32768us; 50us; 56us; 0us; 16401us; 1us; 16402us; 13us; 58us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 65us; 0us; 16403us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 65us; 1us; 32768us; 5us; 62us; 0us; 16404us; 1us; 32768us; 50us; 64us; 0us; 16405us; 0us; 16406us; 1us; 16406us; 16us; 104us; 1us; 16406us; 16us; 105us; 4us; 16407us; 4us; 60us; 32us; 63us; 38us; 75us; 50us; 65us; 0us; 16408us; 1us; 32768us; 50us; 71us; 1us; 32768us; 16us; 72us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 13us; 32768us; 3us; 74us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 0us; 16409us; 1us; 32768us; 50us; 76us; 1us; 32768us; 4us; 77us; 2us; 32768us; 32us; 63us; 50us; 65us; 2us; 32768us; 11us; 189us; 50us; 188us; 1us; 32768us; 5us; 80us; 2us; 32768us; 1us; 86us; 6us; 81us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 65us; 1us; 32768us; 1us; 83us; 9us; 16412us; 1us; 182us; 4us; 60us; 12us; 89us; 26us; 159us; 27us; 16446us; 32us; 63us; 35us; 145us; 40us; 148us; 50us; 67us; 1us; 32768us; 2us; 85us; 0us; 16410us; 9us; 16412us; 1us; 182us; 4us; 60us; 12us; 89us; 26us; 159us; 27us; 16446us; 32us; 63us; 35us; 145us; 40us; 148us; 50us; 67us; 1us; 32768us; 2us; 88us; 0us; 16411us; 0us; 16413us; 1us; 16414us; 12us; 91us; 9us; 16412us; 1us; 182us; 4us; 60us; 12us; 89us; 26us; 159us; 27us; 16446us; 32us; 63us; 35us; 145us; 40us; 148us; 50us; 67us; 0us; 16415us; 0us; 16416us; 0us; 16417us; 1us; 32768us; 50us; 97us; 1us; 32768us; 50us; 98us; 1us; 32768us; 16us; 99us; 1us; 32768us; 16us; 100us; 1us; 16446us; 1us; 182us; 1us; 16446us; 1us; 182us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 17us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 27us; 123us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 39us; 151us; 42us; 178us; 43us; 179us; 44us; 180us; 45us; 181us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 16418us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 16446us; 1us; 182us; 1us; 16446us; 1us; 182us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 17us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 27us; 130us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 39us; 155us; 42us; 178us; 43us; 179us; 44us; 180us; 45us; 181us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 16419us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 32768us; 4us; 110us; 1us; 32768us; 50us; 111us; 1us; 32768us; 5us; 112us; 0us; 16420us; 1us; 32768us; 4us; 114us; 1us; 32768us; 50us; 115us; 1us; 32768us; 5us; 116us; 0us; 16421us; 2us; 16482us; 7us; 176us; 23us; 118us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 16422us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 2us; 16482us; 7us; 176us; 23us; 121us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 16423us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 32768us; 50us; 124us; 1us; 32768us; 7us; 125us; 1us; 32768us; 50us; 126us; 1us; 32768us; 4us; 127us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 13us; 32768us; 5us; 129us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 0us; 16424us; 1us; 32768us; 50us; 131us; 1us; 32768us; 7us; 132us; 1us; 32768us; 50us; 133us; 1us; 32768us; 4us; 134us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 13us; 32768us; 5us; 136us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 0us; 16425us; 1us; 32768us; 27us; 138us; 1us; 32768us; 50us; 139us; 1us; 32768us; 7us; 140us; 1us; 32768us; 50us; 141us; 1us; 32768us; 4us; 142us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 13us; 32768us; 5us; 144us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 0us; 16426us; 1us; 16446us; 1us; 182us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 16427us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 16446us; 1us; 182us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 12us; 16428us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 32768us; 4us; 152us; 1us; 32768us; 50us; 163us; 2us; 32768us; 5us; 154us; 10us; 165us; 0us; 16429us; 1us; 32768us; 4us; 156us; 1us; 32768us; 50us; 163us; 2us; 32768us; 5us; 158us; 10us; 165us; 0us; 16430us; 1us; 16446us; 1us; 182us; 1us; 32768us; 4us; 197us; 0us; 16431us; 0us; 16432us; 0us; 16433us; 2us; 32768us; 5us; 211us; 10us; 165us; 1us; 32768us; 50us; 166us; 0us; 16434us; 1us; 16436us; 10us; 168us; 1us; 16435us; 50us; 170us; 0us; 16437us; 1us; 16438us; 50us; 171us; 0us; 16439us; 0us; 16440us; 1us; 16440us; 6us; 210us; 2us; 32768us; 4us; 250us; 7us; 176us; 1us; 16482us; 7us; 176us; 1us; 32768us; 50us; 177us; 0us; 16441us; 0us; 16442us; 0us; 16443us; 0us; 16444us; 0us; 16445us; 2us; 16448us; 11us; 189us; 50us; 188us; 1us; 32768us; 2us; 184us; 0us; 16447us; 1us; 16449us; 10us; 186us; 2us; 16448us; 11us; 189us; 50us; 188us; 0us; 16450us; 0us; 16451us; 1us; 32768us; 50us; 190us; 0us; 16452us; 1us; 16453us; 37us; 192us; 4us; 32768us; 4us; 60us; 26us; 193us; 32us; 63us; 50us; 66us; 1us; 32768us; 4us; 196us; 0us; 16454us; 0us; 16455us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 173us; 13us; 32768us; 5us; 199us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 1us; 32768us; 36us; 200us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 66us; 0us; 16456us; 0us; 16457us; 1us; 16458us; 37us; 204us; 4us; 32768us; 4us; 60us; 26us; 205us; 32us; 63us; 50us; 66us; 1us; 32768us; 4us; 208us; 0us; 16459us; 0us; 16460us; 1us; 32768us; 50us; 209us; 1us; 32768us; 6us; 210us; 1us; 32768us; 50us; 163us; 1us; 32768us; 36us; 212us; 3us; 32768us; 4us; 60us; 32us; 63us; 50us; 66us; 0us; 16461us; 0us; 16462us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 13us; 32768us; 5us; 217us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 0us; 16463us; 2us; 16464us; 11us; 238us; 15us; 239us; 2us; 16465us; 11us; 238us; 15us; 239us; 0us; 16466us; 0us; 16467us; 4us; 16468us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 4us; 16469us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 6us; 16470us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 6us; 16471us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 6us; 16472us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 6us; 16473us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 10us; 16474us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 21us; 244us; 22us; 245us; 10us; 16475us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 21us; 244us; 22us; 245us; 0us; 16476us; 0us; 16478us; 12us; 16484us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 12us; 16485us; 8us; 240us; 9us; 241us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 13us; 16487us; 8us; 240us; 9us; 241us; 10us; 264us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 13us; 16490us; 8us; 240us; 9us; 241us; 10us; 268us; 11us; 238us; 13us; 236us; 14us; 237us; 15us; 239us; 17us; 242us; 18us; 243us; 19us; 246us; 20us; 247us; 21us; 244us; 22us; 245us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 1us; 32768us; 50us; 172us; 11us; 16486us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 1us; 32768us; 5us; 252us; 0us; 16477us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 0us; 16479us; 0us; 16480us; 0us; 16481us; 1us; 32768us; 50us; 258us; 1us; 32768us; 4us; 259us; 1us; 16489us; 50us; 266us; 1us; 32768us; 5us; 261us; 0us; 16483us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 11us; 16486us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 0us; 16488us; 1us; 32768us; 16us; 267us; 11us; 32768us; 4us; 215us; 14us; 253us; 24us; 248us; 28us; 249us; 32us; 262us; 33us; 263us; 34us; 257us; 46us; 255us; 47us; 256us; 49us; 254us; 50us; 172us; 1us; 16489us; 50us; 266us; 0us; 16491us; |]
let _fsyacc_actionTableRowOffsets = [|0us; 6us; 7us; 19us; 32us; 34us; 35us; 41us; 42us; 44us; 46us; 48us; 50us; 51us; 53us; 55us; 57us; 60us; 61us; 63us; 65us; 69us; 70us; 73us; 75us; 77us; 79us; 81us; 83us; 84us; 86us; 89us; 94us; 96us; 97us; 101us; 103us; 108us; 110us; 111us; 113us; 116us; 121us; 123us; 124us; 128us; 130us; 135us; 137us; 138us; 140us; 141us; 143us; 145us; 146us; 147us; 149us; 150us; 152us; 156us; 157us; 161us; 163us; 164us; 166us; 167us; 168us; 170us; 172us; 177us; 178us; 180us; 182us; 194us; 208us; 209us; 211us; 213us; 216us; 219us; 221us; 224us; 228us; 230us; 240us; 242us; 243us; 253us; 255us; 256us; 257us; 259us; 269us; 270us; 271us; 272us; 274us; 276us; 278us; 280us; 282us; 284us; 296us; 314us; 327us; 329us; 331us; 343us; 361us; 374us; 376us; 378us; 380us; 381us; 383us; 385us; 387us; 388us; 391us; 403us; 416us; 419us; 431us; 444us; 446us; 448us; 450us; 452us; 464us; 478us; 479us; 481us; 483us; 485us; 487us; 499us; 513us; 514us; 516us; 518us; 520us; 522us; 524us; 536us; 550us; 551us; 553us; 565us; 578us; 580us; 592us; 605us; 607us; 609us; 612us; 613us; 615us; 617us; 620us; 621us; 623us; 625us; 626us; 627us; 628us; 631us; 633us; 634us; 636us; 638us; 639us; 641us; 642us; 643us; 645us; 648us; 650us; 652us; 653us; 654us; 655us; 656us; 657us; 660us; 662us; 663us; 665us; 668us; 669us; 670us; 672us; 673us; 675us; 680us; 682us; 683us; 684us; 696us; 708us; 722us; 724us; 728us; 729us; 730us; 732us; 737us; 739us; 740us; 741us; 743us; 745us; 747us; 749us; 753us; 754us; 755us; 767us; 781us; 782us; 785us; 788us; 789us; 790us; 795us; 800us; 807us; 814us; 821us; 828us; 839us; 850us; 851us; 852us; 865us; 878us; 892us; 906us; 918us; 930us; 942us; 954us; 966us; 978us; 990us; 1002us; 1014us; 1026us; 1038us; 1050us; 1062us; 1064us; 1076us; 1078us; 1079us; 1091us; 1092us; 1093us; 1094us; 1096us; 1098us; 1100us; 1102us; 1103us; 1115us; 1127us; 1139us; 1140us; 1142us; 1154us; 1156us; |]
let _fsyacc_reductionSymbolCounts = [|1us; 1us; 2us; 0us; 2us; 5us; 5us; 4us; 7us; 5us; 7us; 6us; 8us; 0us; 2us; 3us; 1us; 3us; 1us; 3us; 3us; 2us; 1us; 0us; 2us; 5us; 11us; 9us; 0us; 1us; 1us; 3us; 1us; 1us; 5us; 4us; 8us; 7us; 7us; 6us; 11us; 10us; 8us; 3us; 3us; 8us; 7us; 3us; 3us; 1us; 3us; 0us; 1us; 3us; 1us; 2us; 1us; 3us; 1us; 1us; 1us; 1us; 0us; 3us; 0us; 1us; 3us; 1us; 2us; 1us; 4us; 3us; 5us; 1us; 1us; 4us; 3us; 7us; 1us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 2us; 5us; 2us; 1us; 1us; 1us; 1us; 5us; 2us; 2us; 0us; 1us; 3us; 0us; 3us; 5us; |]
let _fsyacc_productionToNonTerminalTable = [|0us; 1us; 2us; 3us; 3us; 4us; 4us; 4us; 4us; 4us; 4us; 4us; 4us; 5us; 5us; 6us; 7us; 7us; 8us; 8us; 8us; 9us; 9us; 10us; 10us; 11us; 11us; 11us; 12us; 12us; 12us; 12us; 13us; 13us; 14us; 14us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 16us; 16us; 17us; 17us; 17us; 18us; 18us; 19us; 19us; 20us; 20us; 20us; 20us; 21us; 21us; 22us; 22us; 22us; 23us; 23us; 24us; 24us; 24us; 25us; 26us; 27us; 27us; 27us; 28us; 29us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 30us; 31us; 31us; 31us; 32us; 32us; 32us; |]
let _fsyacc_immediateActions = [|65535us; 49152us; 65535us; 65535us; 65535us; 16386us; 65535us; 16388us; 65535us; 65535us; 65535us; 65535us; 16389us; 65535us; 65535us; 65535us; 65535us; 16390us; 65535us; 65535us; 65535us; 16391us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16392us; 65535us; 65535us; 65535us; 65535us; 16393us; 65535us; 65535us; 65535us; 65535us; 16394us; 65535us; 65535us; 65535us; 65535us; 16395us; 65535us; 65535us; 65535us; 65535us; 16396us; 65535us; 16398us; 65535us; 65535us; 16399us; 16400us; 65535us; 16401us; 65535us; 65535us; 16403us; 65535us; 65535us; 16404us; 65535us; 16405us; 16406us; 65535us; 65535us; 65535us; 16408us; 65535us; 65535us; 65535us; 65535us; 16409us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16410us; 65535us; 65535us; 16411us; 16413us; 65535us; 65535us; 16415us; 16416us; 16417us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16420us; 65535us; 65535us; 65535us; 16421us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16424us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16425us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16426us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16429us; 65535us; 65535us; 65535us; 16430us; 65535us; 65535us; 16431us; 16432us; 16433us; 65535us; 65535us; 16434us; 65535us; 65535us; 16437us; 65535us; 16439us; 16440us; 65535us; 65535us; 65535us; 65535us; 16441us; 16442us; 16443us; 16444us; 16445us; 65535us; 65535us; 16447us; 65535us; 65535us; 16450us; 16451us; 65535us; 16452us; 65535us; 65535us; 65535us; 16454us; 16455us; 65535us; 65535us; 65535us; 65535us; 65535us; 16456us; 16457us; 65535us; 65535us; 65535us; 16459us; 16460us; 65535us; 65535us; 65535us; 65535us; 65535us; 16461us; 16462us; 65535us; 65535us; 16463us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16477us; 65535us; 16479us; 16480us; 16481us; 65535us; 65535us; 65535us; 65535us; 16483us; 65535us; 65535us; 65535us; 16488us; 65535us; 65535us; 65535us; 16491us; |]
let _fsyacc_reductions ()  =    [| 
# 509 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  TDefPrim list * TDefChoice list * ExternFun list * Activity list )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startstart));
# 518 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startExpr));
# 527 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeOrActivityList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 40 "pars.fsy"
                                                     _1 
                   )
# 40 "pars.fsy"
                 :  TDefPrim list * TDefChoice list * ExternFun list * Activity list ));
# 538 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 43 "pars.fsy"
                                           ([("void",TVoid);("int",TInt);("bool",TBool);("string",TString);("readwrite",TRecord[("rcount","int");("wcount","int")])],[],[],[]) 
                   )
# 43 "pars.fsy"
                 : 'TypeOrActivityList));
# 548 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeOrActivity)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeOrActivityList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 44 "pars.fsy"
                                                             match (_1,_2) with ((tp1,tc1,ef1,a1),(tp2,tc2,ef2,a2)) -> (tp1@tp2, tc1@tc2, ef1@ef2, a1@a2) 
                   )
# 44 "pars.fsy"
                 : 'TypeOrActivityList));
# 560 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'FieldList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 45 "pars.fsy"
                                                                        let tp=(_2,TRecord(_4)) in ([tp],[],[],[]) 
                   )
# 45 "pars.fsy"
                 : 'TypeOrActivity));
# 572 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'EnumList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 46 "pars.fsy"
                                                            let tp=(_2,TEnum(_4)) in ([tp],[],[],[]) 
                   )
# 46 "pars.fsy"
                 : 'TypeOrActivity));
# 584 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 47 "pars.fsy"
                                                     let tc=(_2,_4) in ([],[tc],[],[]) 
                   )
# 47 "pars.fsy"
                 : 'TypeOrActivity));
# 596 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'ArgList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 48 "pars.fsy"
                                                                      let ef=(_3, {new ExternFunDat with ats=_5 and rt=_2}) in ([],[],[ef],[]) 
                   )
# 48 "pars.fsy"
                 : 'TypeOrActivity));
# 609 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'StateOrHandlerList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 49 "pars.fsy"
                                                                          let a = match _4 with (state,h) -> {new Ast.Activity with s=_2 and state=state and signal=[] and h=h and ext=false} in ([],[],[],[a]) 
                   )
# 49 "pars.fsy"
                 : 'TypeOrActivity));
# 621 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : 'StateOrHandlerList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 50 "pars.fsy"
                                                                                         let a = match _6 with (state,h) -> {new Ast.Activity with s=_2 and state=state and signal=_4 and h=h and ext=false} in ([],[],[],[a]) 
                   )
# 50 "pars.fsy"
                 : 'TypeOrActivity));
# 634 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'StateOrHandlerList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 51 "pars.fsy"
                                                                                 let a = match _5 with (state,h) -> {new Ast.Activity with s=_3 and state=state and signal=[] and h=h and ext=true} in ([],[],[],[a]) 
                   )
# 51 "pars.fsy"
                 : 'TypeOrActivity));
# 646 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : 'StateOrHandlerList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 52 "pars.fsy"
                                                                                                let a = match _7 with (state,h) -> {new Ast.Activity with s=_3 and state=state and signal=_5 and h=h and ext=true} in ([],[],[],[a]) 
                   )
# 52 "pars.fsy"
                 : 'TypeOrActivity));
# 659 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 54 "pars.fsy"
                                  [] 
                   )
# 54 "pars.fsy"
                 : 'FieldList));
# 669 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Field)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'FieldList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 55 "pars.fsy"
                                            _1 :: _2 
                   )
# 55 "pars.fsy"
                 : 'FieldList));
# 681 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 56 "pars.fsy"
                                         (_2,_1) 
                   )
# 56 "pars.fsy"
                 : 'Field));
# 693 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 57 "pars.fsy"
                                    [_1] 
                   )
# 57 "pars.fsy"
                 : 'EnumList));
# 704 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'EnumList)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 58 "pars.fsy"
                                             _1 @ [_3] 
                   )
# 58 "pars.fsy"
                 : 'EnumList));
# 716 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  string*Importance )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 59 "pars.fsy"
                                       [_1] 
                   )
# 59 "pars.fsy"
                 : 'TypeList));
# 727 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  string*Importance )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 60 "pars.fsy"
                                               _1 :: _3 
                   )
# 60 "pars.fsy"
                 : 'TypeList));
# 739 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 61 "pars.fsy"
                                                  _2 
                   )
# 61 "pars.fsy"
                 : 'TypeList));
# 750 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 62 "pars.fsy"
                                           (_2,Important) 
                   )
# 62 "pars.fsy"
                 :  string*Importance ));
# 761 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 63 "pars.fsy"
                              (_1,Unimportant) 
                   )
# 63 "pars.fsy"
                 :  string*Importance ));
# 772 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 65 "pars.fsy"
                                           ([],[]) 
                   )
# 65 "pars.fsy"
                 : 'StateOrHandlerList));
# 782 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  (string*Expr)list * (string*Handler)list )) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'StateOrHandlerList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 66 "pars.fsy"
                                                             match (_1,_2) with ((st1,h1),(st2,h2)) -> (st1@st2,h1@h2) 
                   )
# 66 "pars.fsy"
                 : 'StateOrHandlerList));
# 794 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 67 "pars.fsy"
                                                                    let st=(_2, {_4 with t=_1}) in ([st],[]) 
                   )
# 67 "pars.fsy"
                 :  (string*Expr)list * (string*Handler)list ));
# 807 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  string*Importance )) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wire)) in
            let _8 = (let data = parseState.GetInput(8) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _10 = (let data = parseState.GetInput(10) in (Microsoft.FSharp.Core.Operators.unbox data : 'NodeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 68 "pars.fsy"
                                                                                                match _5 with (a,q) -> let h=(_2,{new Handler with a=a and aq=q and at=_4 and outWires=[] and rt=_8 and n=_10}) in ([],[h]) 
                   )
# 68 "pars.fsy"
                 :  (string*Expr)list * (string*Handler)list ));
# 822 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  string*Importance )) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wire)) in
            let _8 = (let data = parseState.GetInput(8) in (Microsoft.FSharp.Core.Operators.unbox data : 'NodeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 69 "pars.fsy"
                                                                                 match _5 with (a,q) -> let h=(_2,{new Handler with a=a and aq=q and at=_4 and outWires=[] and rt=[] and n=_8}) in ([],[h]) 
                   )
# 69 "pars.fsy"
                 :  (string*Expr)list * (string*Handler)list ));
# 836 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 71 "pars.fsy"
                                 [] 
                   )
# 71 "pars.fsy"
                 : 'NodeList));
# 846 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 72 "pars.fsy"
                              [] 
                   )
# 72 "pars.fsy"
                 : 'NodeList));
# 856 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Node )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 73 "pars.fsy"
                               [_1] 
                   )
# 73 "pars.fsy"
                 : 'NodeList));
# 867 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Node )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'NodeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 74 "pars.fsy"
                                            _1 :: _3 
                   )
# 74 "pars.fsy"
                 : 'NodeList));
# 879 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'ExprNode)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 75 "pars.fsy"
                                      _1 
                   )
# 75 "pars.fsy"
                 :  Ast.Node ));
# 890 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'OtherNode)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 75 "pars.fsy"
                                                         _1 
                   )
# 75 "pars.fsy"
                 :  Ast.Node ));
# 901 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 78 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_2 and t=_1 and d=NExpr(_5) and inWires=_4 and outWires=[] and src=src} 
                   )
# 78 "pars.fsy"
                 : 'ExprNode));
# 915 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 80 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_1 and t=TUnk and d=NExpr(_4) and inWires=_3 and outWires=[] and src=src} 
                   )
# 80 "pars.fsy"
                 : 'ExprNode));
# 928 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data :  AtomicMode )) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 83 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_2 and t=_1 and d=NAtomic {new AtomicDat with m=_5 and rw=_7} and inWires=_4 and outWires=[] and src=src} 
                   )
# 83 "pars.fsy"
                 : 'OtherNode));
# 943 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  AtomicMode )) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 85 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_1 and t=TUnk and d=NAtomic {new AtomicDat with m=_4 and rw=_6} and inWires=_3 and outWires=[] and src=src} 
                   )
# 85 "pars.fsy"
                 : 'OtherNode));
# 957 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data :  StringOrList )) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 87 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_2 and t=_1 and d=NSet(_5.aslist,TUnk,_7) and inWires=_4 and outWires=[] and src=src} 
                   )
# 87 "pars.fsy"
                 : 'OtherNode));
# 972 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  StringOrList )) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 89 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_1 and t=TUnk and d=NSet(_4.aslist,TUnk,_6) and inWires=_3 and outWires=[] and src=src} 
                   )
# 89 "pars.fsy"
                 : 'OtherNode));
# 986 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _8 = (let data = parseState.GetInput(8) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _10 = (let data = parseState.GetInput(10) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 91 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_2 and t=_1 and d=NCall(_6,_8,NUnbounded,_10) and inWires=_4 and outWires=[] and src=src} 
                   )
# 91 "pars.fsy"
                 : 'OtherNode));
# 1002 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _9 = (let data = parseState.GetInput(9) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 93 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_1 and t=TUnk and d=NCall(_5,_7,NUnbounded,_9) and inWires=_3 and outWires=[] and src=src} 
                   )
# 93 "pars.fsy"
                 : 'OtherNode));
# 1017 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 95 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s="_t"^string(src) and t=TUnk and d=NCall(_3,_5,NUnbounded,_7) and inWires=_1 and outWires=[] and src=src} 
                   )
# 95 "pars.fsy"
                 : 'OtherNode));
# 1031 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 97 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s="_t"^string(src) and t=[] and d=NSignal(_3) and inWires=_2 and outWires=[] and src=src} 
                   )
# 97 "pars.fsy"
                 : 'OtherNode));
# 1043 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 99 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s="_t"^string(src) and t=[] and d=NReturn(_3) and inWires=_2 and outWires=[] and src=src} 
                   )
# 99 "pars.fsy"
                 : 'OtherNode));
# 1055 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeList)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : 'IdList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 101 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_2 and t=_1 and d=NFirst(_7) and inWires=_4 and outWires=[] and src=src} 
                   )
# 101 "pars.fsy"
                 : 'OtherNode));
# 1069 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : 'IdList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 103 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s=_1 and t=TUnk and d=NFirst(_6) and inWires=_3 and outWires=[] and src=src} 
                   )
# 103 "pars.fsy"
                 : 'OtherNode));
# 1082 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat list )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 105 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s="_t"^string(src) and t=[] and d=NIf(_3) and inWires=_2 and outWires=[] and src=src} 
                   )
# 105 "pars.fsy"
                 : 'OtherNode));
# 1094 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wires)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'IfTypeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 107 "pars.fsy"
                              let src = (Parsing.set_parse_state parseState; (Parsing.rhs_start_pos 1).pos_lnum+1) in {new Node with s="_t"^string(src) and t=[] and d=NIfType(_3) and inWires=_2 and outWires=[] and src=src} 
                   )
# 107 "pars.fsy"
                 : 'OtherNode));
# 1106 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 110 "pars.fsy"
                                  [(_1,TUnk)] 
                   )
# 110 "pars.fsy"
                 : 'IdList));
# 1117 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'IdList)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 111 "pars.fsy"
                                          _1 @ [(_3,TUnk)] 
                   )
# 111 "pars.fsy"
                 : 'IdList));
# 1129 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 112 "pars.fsy"
                                [] 
                   )
# 112 "pars.fsy"
                 : 'ArgList));
# 1139 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Arg)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 113 "pars.fsy"
                              [_1] 
                   )
# 113 "pars.fsy"
                 : 'ArgList));
# 1150 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Arg)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'ArgList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 114 "pars.fsy"
                                            _1 :: _3 
                   )
# 114 "pars.fsy"
                 : 'ArgList));
# 1162 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 115 "pars.fsy"
                               ("_",_1) 
                   )
# 115 "pars.fsy"
                 : 'Arg));
# 1173 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 116 "pars.fsy"
                                (_2,_1) 
                   )
# 116 "pars.fsy"
                 : 'Arg));
# 1185 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 117 "pars.fsy"
                                  {new StringOrList with asstring=_1 and aslist=[_1]} 
                   )
# 117 "pars.fsy"
                 :  StringOrList ));
# 1196 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  StringOrList )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 118 "pars.fsy"
                                         {new StringOrList with asstring=_1.asstring^"."^_3 and aslist=_1.aslist @ [_3]} 
                   )
# 118 "pars.fsy"
                 :  StringOrList ));
# 1208 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 120 "pars.fsy"
                                          BeginRead 
                   )
# 120 "pars.fsy"
                 :  AtomicMode ));
# 1218 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 121 "pars.fsy"
                                  EndRead 
                   )
# 121 "pars.fsy"
                 :  AtomicMode ));
# 1228 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 122 "pars.fsy"
                                     BeginWrite 
                   )
# 122 "pars.fsy"
                 :  AtomicMode ));
# 1238 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 123 "pars.fsy"
                                   EndWrite 
                   )
# 123 "pars.fsy"
                 :  AtomicMode ));
# 1248 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 125 "pars.fsy"
                              [] 
                   )
# 125 "pars.fsy"
                 : 'Wires));
# 1258 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : 'WireList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 126 "pars.fsy"
                                                  _2 
                   )
# 126 "pars.fsy"
                 : 'Wires));
# 1269 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 127 "pars.fsy"
                                 [] 
                   )
# 127 "pars.fsy"
                 : 'WireList));
# 1279 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wire)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 128 "pars.fsy"
                                [_1] 
                   )
# 128 "pars.fsy"
                 : 'WireList));
# 1290 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'Wire)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'WireList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 129 "pars.fsy"
                                               _1 :: _3 
                   )
# 129 "pars.fsy"
                 : 'WireList));
# 1302 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 130 "pars.fsy"
                                (_1,NBounded(1)) 
                   )
# 130 "pars.fsy"
                 : 'Wire));
# 1313 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 131 "pars.fsy"
                                   (_2,NUnbounded) 
                   )
# 131 "pars.fsy"
                 : 'Wire));
# 1324 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 133 "pars.fsy"
                                                  [_1] 
                   )
# 133 "pars.fsy"
                 :  IfDat list ));
# 1335 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat )) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat list )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 134 "pars.fsy"
                                                             _1 :: _4 
                   )
# 134 "pars.fsy"
                 :  IfDat list ));
# 1347 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 135 "pars.fsy"
                                                               [_1; _3] 
                   )
# 135 "pars.fsy"
                 :  IfDat list ));
# 1359 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data :  IfDat )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 137 "pars.fsy"
                         let ifdat = _5 in {ifdat with ife=_2} 
                   )
# 137 "pars.fsy"
                 :  IfDat ));
# 1371 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'ExprNode)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 139 "pars.fsy"
                         let n=_1 in match n.d with NExpr(e) -> {new IfDat with ife={new Expr with t=[("bool",Unimportant)] and e=EBool(true)} and thens=n.s and thent=n.t and thene=e and thenOutWires=n.outWires} | _ -> raise(new System.Exception("ERROR: then not an expr")) 
                   )
# 139 "pars.fsy"
                 :  IfDat ));
# 1382 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeCondAndConsequence)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 141 "pars.fsy"
                                                          [_1] 
                   )
# 141 "pars.fsy"
                 : 'IfTypeList));
# 1393 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeCondAndConsequence)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'IfTypeList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 142 "pars.fsy"
                                                                     _1 :: _4 
                   )
# 142 "pars.fsy"
                 : 'IfTypeList));
# 1405 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeCondAndConsequence)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeConsequence)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 143 "pars.fsy"
                                                                       [_1; _3] 
                   )
# 143 "pars.fsy"
                 : 'IfTypeList));
# 1417 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'IdList)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : 'TypeConsequence)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 145 "pars.fsy"
                         let (ift:TypeList) = List.map (fun (id,t) -> (id,Unimportant)) _4 in
                         let (ifdat:IfTypeDat) = _7 in
                         {ifdat with ifv=_2; ift=ift} 
                   )
# 145 "pars.fsy"
                 : 'TypeCondAndConsequence));
# 1432 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'ExprNode)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 149 "pars.fsy"
                         let n=_1 in match n.d with NExpr(e) -> {new IfTypeDat with ifv="" and ift=[] and tthens=n.s and tthent=n.t and tthene=e and tthenOutWires=n.outWires} | _ -> raise(new System.Exception("ERROR: then not an expr")) 
                   )
# 149 "pars.fsy"
                 : 'TypeConsequence));
# 1443 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 153 "pars.fsy"
                                                _2 
                   )
# 153 "pars.fsy"
                 :  Ast.Expr ));
# 1454 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 154 "pars.fsy"
                                          {new Expr with t=TUnk and e=EFun("+",[_1;_3])} 
                   )
# 154 "pars.fsy"
                 :  Ast.Expr ));
# 1466 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 155 "pars.fsy"
                                           {new Expr with t=TUnk and e=EFun("-",[_1;_3])} 
                   )
# 155 "pars.fsy"
                 :  Ast.Expr ));
# 1478 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 156 "pars.fsy"
                                          {new Expr with t=TUnk and e=EFun("*",[_1;_3])} 
                   )
# 156 "pars.fsy"
                 :  Ast.Expr ));
# 1490 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 157 "pars.fsy"
                                         {new Expr with t=TUnk and e=EFun("/",[_1;_3])} 
                   )
# 157 "pars.fsy"
                 :  Ast.Expr ));
# 1502 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 158 "pars.fsy"
                                            {new Expr with t=TUnk and e=EFun("<",[_1;_3])} 
                   )
# 158 "pars.fsy"
                 :  Ast.Expr ));
# 1514 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 159 "pars.fsy"
                                            {new Expr with t=TUnk and e=EFun(">",[_1;_3])} 
                   )
# 159 "pars.fsy"
                 :  Ast.Expr ));
# 1526 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 160 "pars.fsy"
                                              {new Expr with t=TUnk and e=EFun("==",[_1;_3])} 
                   )
# 160 "pars.fsy"
                 :  Ast.Expr ));
# 1538 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 161 "pars.fsy"
                                               {new Expr with t=TUnk and e=EFun("!=",[_1;_3])} 
                   )
# 161 "pars.fsy"
                 :  Ast.Expr ));
# 1550 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 162 "pars.fsy"
                                                 {new Expr with t=TUnk and e=EFun(">=",[_1;_3])} 
                   )
# 162 "pars.fsy"
                 :  Ast.Expr ));
# 1562 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 163 "pars.fsy"
                                                 {new Expr with t=TUnk and e=EFun("<=",[_1;_3])} 
                   )
# 163 "pars.fsy"
                 :  Ast.Expr ));
# 1574 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 164 "pars.fsy"
                                         {new Expr with t=TUnk and e=EFun("&&",[_1;_3])} 
                   )
# 164 "pars.fsy"
                 :  Ast.Expr ));
# 1586 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 165 "pars.fsy"
                                        {new Expr with t=TUnk and e=EFun("||",[_1;_3])} 
                   )
# 165 "pars.fsy"
                 :  Ast.Expr ));
# 1598 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 166 "pars.fsy"
                                      {new Expr with t=TUnk and e=EFun("!",[_2])} 
                   )
# 166 "pars.fsy"
                 :  Ast.Expr ));
# 1609 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  StringOrList )) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'ExprList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 167 "pars.fsy"
                                                                  {new Expr with t=TUnk and e=EExternal(_2.asstring,_4)} 
                   )
# 167 "pars.fsy"
                 :  Ast.Expr ));
# 1621 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 168 "pars.fsy"
                                                   {new Expr with t=TUnk and e=EFun("-",[{new Expr with t=TUnk and e=EInt(0)};_2])} 
                   )
# 168 "pars.fsy"
                 :  Ast.Expr ));
# 1632 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : System.Int32)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 169 "pars.fsy"
                               {new Expr with t=TUnk and e=EInt(_1)} 
                   )
# 169 "pars.fsy"
                 :  Ast.Expr ));
# 1643 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : bool)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 170 "pars.fsy"
                                {new Expr with t=TUnk and e=EBool(_1)} 
                   )
# 170 "pars.fsy"
                 :  Ast.Expr ));
# 1654 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 171 "pars.fsy"
                                  {new Expr with t=TUnk and e=EString(_1)} 
                   )
# 171 "pars.fsy"
                 :  Ast.Expr ));
# 1665 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  StringOrList )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 172 "pars.fsy"
                                  {new Expr with t=TUnk and e=if _1.asstring="void" then EVoid else EIdPath(_1.aslist)} 
                   )
# 172 "pars.fsy"
                 :  Ast.Expr ));
# 1676 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : 'AssignList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 173 "pars.fsy"
                                                           {new Expr with t=TUnk and e=EConstructor(_2,_4)} 
                   )
# 173 "pars.fsy"
                 :  Ast.Expr ));
# 1688 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 174 "pars.fsy"
                                          {new Expr with t=TUnk and e=EImportance(Important,_2)} 
                   )
# 174 "pars.fsy"
                 :  Ast.Expr ));
# 1699 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 175 "pars.fsy"
                                            {new Expr with t=TUnk and e=EImportance(Unimportant,_2)} 
                   )
# 175 "pars.fsy"
                 :  Ast.Expr ));
# 1710 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 176 "pars.fsy"
                                 [] 
                   )
# 176 "pars.fsy"
                 : 'ExprList));
# 1720 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 177 "pars.fsy"
                                [_1] 
                   )
# 177 "pars.fsy"
                 : 'ExprList));
# 1731 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'ExprList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 178 "pars.fsy"
                                               _1 :: _3 
                   )
# 178 "pars.fsy"
                 : 'ExprList));
# 1743 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 179 "pars.fsy"
                                   [] 
                   )
# 179 "pars.fsy"
                 : 'AssignList));
# 1753 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 180 "pars.fsy"
                                          [(_1,_3)] 
                   )
# 180 "pars.fsy"
                 : 'AssignList));
# 1765 "pars.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data :  Ast.Expr )) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'AssignList)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 181 "pars.fsy"
                                                           (_1,_3)::_5 
                   )
# 181 "pars.fsy"
                 : 'AssignList));
|]
# 1779 "pars.fs"
let tables () : Microsoft.FSharp.Text.Parsing.Tables<_> = 
  { reductions= _fsyacc_reductions ();
    endOfInputTag = _fsyacc_endOfInputTag;
    tagOfToken = tagOfToken;
    dataOfToken = _fsyacc_dataOfToken; 
    actionTableElements = _fsyacc_actionTableElements;
    actionTableRowOffsets = _fsyacc_actionTableRowOffsets;
    stateToProdIdxsTableElements = _fsyacc_stateToProdIdxsTableElements;
    stateToProdIdxsTableRowOffsets = _fsyacc_stateToProdIdxsTableRowOffsets;
    reductionSymbolCounts = _fsyacc_reductionSymbolCounts;
    immediateActions = _fsyacc_immediateActions;
    gotos = _fsyacc_gotos;
    sparseGotoTableRowOffsets = _fsyacc_sparseGotoTableRowOffsets;
    tagOfErrorTerminal = _fsyacc_tagOfErrorTerminal;
    parseError = (fun (ctxt:Microsoft.FSharp.Text.Parsing.ParseErrorContext<_>) -> 
                              match parse_error_rich with 
                              | Some f -> f ctxt
                              | None -> parse_error ctxt.Message);
    numTerminals = 54;
    productionToNonTerminalTable = _fsyacc_productionToNonTerminalTable  }
let engine lexer lexbuf startState = (tables ()).Interpret(lexer, lexbuf, startState)
let start lexer lexbuf :  TDefPrim list * TDefChoice list * ExternFun list * Activity list  =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 0))
let Expr lexer lexbuf :  Ast.Expr  =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 2))
