
 /****************************************************************************
 *                       THIS FILE WAS GENERATED                             *
 * Script: common/generate_packets.py                                        *
 * Input:  common/packets.def                                                *
 *                       DO NOT CHANGE THIS FILE                             *
 ****************************************************************************/


#ifdef HAVE_CONFIG_H
#include <fc_config.h>
#endif

#include <string.h>

/* utility */
#include "bitvector.h"
#include "capability.h"
#include "genhash.h"
#include "log.h"
#include "mem.h"
#include "support.h"

/* common */
#include "capstr.h"
#include "connection.h"
#include "dataio.h"
#include "game.h"

#include "packets.h"

const char *const packet_functional_capability = "techloss_forgiveness";

static genhash_val_t hash_const(const void *vkey)
{
  return 0;
}

static bool cmp_const(const void *vkey1, const void *vkey2)
{
  return TRUE;
}

void delta_stats_report(void) {}

void delta_stats_reset(void) {}

const char *packet_name(enum packet_type type)
{
  static const char *const names[PACKET_LAST] = {
    "PACKET_PROCESSING_STARTED",
    "PACKET_PROCESSING_FINISHED",
    "unknown",
    "unknown",
    "PACKET_SERVER_JOIN_REQ",
    "PACKET_SERVER_JOIN_REPLY",
    "PACKET_AUTHENTICATION_REQ",
    "PACKET_AUTHENTICATION_REPLY",
    "PACKET_SERVER_SHUTDOWN",
    "unknown",
    "PACKET_NATION_SELECT_REQ",
    "PACKET_PLAYER_READY",
    "PACKET_ENDGAME_REPORT",
    "unknown",
    "unknown",
    "PACKET_TILE_INFO",
    "PACKET_GAME_INFO",
    "PACKET_MAP_INFO",
    "PACKET_NUKE_TILE_INFO",
    "PACKET_TEAM_NAME_INFO",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_CHAT_MSG",
    "PACKET_CHAT_MSG_REQ",
    "PACKET_CONNECT_MSG",
    "PACKET_EARLY_CHAT_MSG",
    "unknown",
    "PACKET_CITY_REMOVE",
    "PACKET_CITY_INFO",
    "PACKET_CITY_SHORT_INFO",
    "PACKET_CITY_SELL",
    "PACKET_CITY_BUY",
    "PACKET_CITY_CHANGE",
    "PACKET_CITY_WORKLIST",
    "PACKET_CITY_MAKE_SPECIALIST",
    "PACKET_CITY_MAKE_WORKER",
    "PACKET_CITY_CHANGE_SPECIALIST",
    "PACKET_CITY_RENAME",
    "PACKET_CITY_OPTIONS_REQ",
    "PACKET_CITY_REFRESH",
    "PACKET_CITY_NAME_SUGGESTION_REQ",
    "PACKET_CITY_NAME_SUGGESTION_INFO",
    "PACKET_CITY_SABOTAGE_LIST",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_PLAYER_REMOVE",
    "PACKET_PLAYER_INFO",
    "PACKET_PLAYER_PHASE_DONE",
    "PACKET_PLAYER_RATES",
    "PACKET_PLAYER_CHANGE_GOVERNMENT",
    "PACKET_PLAYER_RESEARCH",
    "PACKET_PLAYER_TECH_GOAL",
    "PACKET_PLAYER_ATTRIBUTE_BLOCK",
    "PACKET_PLAYER_ATTRIBUTE_CHUNK",
    "PACKET_PLAYER_DIPLSTATE",
    "PACKET_RESEARCH_INFO",
    "unknown",
    "PACKET_UNIT_REMOVE",
    "PACKET_UNIT_INFO",
    "PACKET_UNIT_SHORT_INFO",
    "PACKET_UNIT_COMBAT_INFO",
    "unknown",
    "PACKET_UNIT_BUILD_CITY",
    "PACKET_UNIT_DISBAND",
    "PACKET_UNIT_CHANGE_HOMECITY",
    "unknown",
    "PACKET_UNIT_BATTLEGROUP",
    "unknown",
    "PACKET_UNIT_ORDERS",
    "PACKET_UNIT_AUTOSETTLERS",
    "PACKET_UNIT_LOAD",
    "PACKET_UNIT_UNLOAD",
    "PACKET_UNIT_UPGRADE",
    "unknown",
    "PACKET_UNIT_NUKE",
    "PACKET_UNIT_PARADROP_TO",
    "PACKET_UNIT_AIRLIFT",
    "PACKET_UNIT_ACTION_QUERY",
    "PACKET_UNIT_TYPE_UPGRADE",
    "PACKET_UNIT_DO_ACTION",
    "PACKET_UNIT_ACTION_ANSWER",
    "unknown",
    "PACKET_UNIT_GET_ACTIONS",
    "PACKET_CONN_PING",
    "PACKET_CONN_PONG",
    "PACKET_UNIT_ACTIONS",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_DIPLOMACY_INIT_MEETING_REQ",
    "PACKET_DIPLOMACY_INIT_MEETING",
    "PACKET_DIPLOMACY_CANCEL_MEETING_REQ",
    "PACKET_DIPLOMACY_CANCEL_MEETING",
    "PACKET_DIPLOMACY_CREATE_CLAUSE_REQ",
    "PACKET_DIPLOMACY_CREATE_CLAUSE",
    "PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ",
    "PACKET_DIPLOMACY_REMOVE_CLAUSE",
    "PACKET_DIPLOMACY_ACCEPT_TREATY_REQ",
    "PACKET_DIPLOMACY_ACCEPT_TREATY",
    "PACKET_DIPLOMACY_CANCEL_PACT",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_PAGE_MSG",
    "PACKET_REPORT_REQ",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_CONN_INFO",
    "PACKET_CONN_PING_INFO",
    "unknown",
    "unknown",
    "PACKET_CLIENT_INFO",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_END_PHASE",
    "PACKET_START_PHASE",
    "PACKET_NEW_YEAR",
    "PACKET_BEGIN_TURN",
    "PACKET_END_TURN",
    "PACKET_FREEZE_CLIENT",
    "PACKET_THAW_CLIENT",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_SPACESHIP_LAUNCH",
    "PACKET_SPACESHIP_PLACE",
    "PACKET_SPACESHIP_INFO",
    "unknown",
    "unknown",
    "PACKET_RULESET_UNIT",
    "PACKET_RULESET_GAME",
    "PACKET_RULESET_SPECIALIST",
    "PACKET_RULESET_GOVERNMENT_RULER_TITLE",
    "PACKET_RULESET_TECH",
    "PACKET_RULESET_GOVERNMENT",
    "PACKET_RULESET_TERRAIN_CONTROL",
    "PACKET_RULESET_NATION_GROUPS",
    "PACKET_RULESET_NATION",
    "PACKET_RULESET_CITY",
    "PACKET_RULESET_BUILDING",
    "PACKET_RULESET_TERRAIN",
    "PACKET_RULESET_UNIT_CLASS",
    "PACKET_RULESET_BASE",
    "unknown",
    "PACKET_RULESET_CONTROL",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_SINGLE_WANT_HACK_REQ",
    "PACKET_SINGLE_WANT_HACK_REPLY",
    "PACKET_RULESET_CHOICES",
    "PACKET_GAME_LOAD",
    "PACKET_SERVER_SETTING_CONTROL",
    "PACKET_SERVER_SETTING_CONST",
    "PACKET_SERVER_SETTING_BOOL",
    "PACKET_SERVER_SETTING_INT",
    "PACKET_SERVER_SETTING_STR",
    "PACKET_SERVER_SETTING_ENUM",
    "PACKET_SERVER_SETTING_BITWISE",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_RULESET_EFFECT",
    "unknown",
    "PACKET_RULESET_RESOURCE",
    "unknown",
    "unknown",
    "PACKET_SCENARIO_INFO",
    "PACKET_SAVE_SCENARIO",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_VOTE_NEW",
    "PACKET_VOTE_UPDATE",
    "PACKET_VOTE_REMOVE",
    "PACKET_VOTE_RESOLVE",
    "PACKET_VOTE_SUBMIT",
    "PACKET_EDIT_MODE",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "unknown",
    "PACKET_EDIT_RECALCULATE_BORDERS",
    "PACKET_EDIT_CHECK_TILES",
    "PACKET_EDIT_TOGGLE_FOGOFWAR",
    "PACKET_EDIT_TILE_TERRAIN",
    "PACKET_EDIT_TILE_RESOURCE",
    "PACKET_EDIT_TILE_EXTRA",
    "unknown",
    "PACKET_EDIT_STARTPOS",
    "PACKET_EDIT_STARTPOS_FULL",
    "PACKET_EDIT_TILE",
    "PACKET_EDIT_UNIT_CREATE",
    "PACKET_EDIT_UNIT_REMOVE",
    "PACKET_EDIT_UNIT_REMOVE_BY_ID",
    "PACKET_EDIT_UNIT",
    "PACKET_EDIT_CITY_CREATE",
    "PACKET_EDIT_CITY_REMOVE",
    "PACKET_EDIT_CITY",
    "PACKET_EDIT_PLAYER_CREATE",
    "PACKET_EDIT_PLAYER_REMOVE",
    "PACKET_EDIT_PLAYER",
    "PACKET_EDIT_PLAYER_VISION",
    "PACKET_EDIT_GAME",
    "PACKET_EDIT_OBJECT_CREATED",
    "PACKET_RULESET_ROAD",
    "unknown",
    "PACKET_UNIT_CHANGE_ACTIVITY",
    "PACKET_ENDGAME_PLAYER",
    "PACKET_RULESET_DISASTER",
    "PACKET_RULESETS_READY",
    "unknown",
    "PACKET_RULESET_TRADE",
    "PACKET_RULESET_UNIT_BONUS",
    "PACKET_RULESET_UNIT_FLAG",
    "unknown",
    "PACKET_RULESET_TERRAIN_FLAG",
    "PACKET_RULESET_EXTRA",
    "PACKET_RULESET_ACHIEVEMENT",
    "PACKET_RULESET_TECH_FLAG",
    "PACKET_RULESET_ACTION_ENABLER",
    "PACKET_RULESET_NATION_SETS",
    "PACKET_NATION_AVAILABILITY",
    "PACKET_ACHIEVEMENT_INFO",
    "PACKET_RULESET_STYLE",
    "PACKET_RULESET_MUSIC",
    "PACKET_WORKER_TASK",
    "PACKET_PLAYER_MULTIPLIER",
    "PACKET_RULESET_MULTIPLIER",
    "PACKET_TIMEOUT_INFO",
    "PACKET_PLAY_MUSIC",
    "PACKET_RULESET_ACTION",
    "PACKET_RULESET_DESCRIPTION_PART",
    "PACKET_PAGE_MSG_PART",
    "PACKET_RULESET_SUMMARY",
    "PACKET_SET_TOPOLOGY",
    "PACKET_CLIENT_HEARTBEAT",
    "PACKET_SCENARIO_DESCRIPTION",
    "PACKET_EDIT_SCENARIO_DESC",
  };

  return (type >= 0 && type < PACKET_LAST ? names[type] : "unknown");
}

bool packet_has_game_info_flag(enum packet_type type)
{
  static const bool flag[PACKET_LAST] = {
    FALSE, /* PACKET_PROCESSING_STARTED */
    FALSE, /* PACKET_PROCESSING_FINISHED */
    FALSE,
    FALSE,
    FALSE, /* PACKET_SERVER_JOIN_REQ */
    FALSE, /* PACKET_SERVER_JOIN_REPLY */
    FALSE, /* PACKET_AUTHENTICATION_REQ */
    FALSE, /* PACKET_AUTHENTICATION_REPLY */
    FALSE, /* PACKET_SERVER_SHUTDOWN */
    FALSE,
    FALSE, /* PACKET_NATION_SELECT_REQ */
    FALSE, /* PACKET_PLAYER_READY */
    FALSE, /* PACKET_ENDGAME_REPORT */
    FALSE,
    FALSE,
    TRUE, /* PACKET_TILE_INFO */
    FALSE, /* PACKET_GAME_INFO */
    FALSE, /* PACKET_MAP_INFO */
    FALSE, /* PACKET_NUKE_TILE_INFO */
    FALSE, /* PACKET_TEAM_NAME_INFO */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_CHAT_MSG */
    FALSE, /* PACKET_CHAT_MSG_REQ */
    FALSE, /* PACKET_CONNECT_MSG */
    FALSE, /* PACKET_EARLY_CHAT_MSG */
    FALSE,
    FALSE, /* PACKET_CITY_REMOVE */
    TRUE, /* PACKET_CITY_INFO */
    TRUE, /* PACKET_CITY_SHORT_INFO */
    FALSE, /* PACKET_CITY_SELL */
    FALSE, /* PACKET_CITY_BUY */
    FALSE, /* PACKET_CITY_CHANGE */
    FALSE, /* PACKET_CITY_WORKLIST */
    FALSE, /* PACKET_CITY_MAKE_SPECIALIST */
    FALSE, /* PACKET_CITY_MAKE_WORKER */
    FALSE, /* PACKET_CITY_CHANGE_SPECIALIST */
    FALSE, /* PACKET_CITY_RENAME */
    FALSE, /* PACKET_CITY_OPTIONS_REQ */
    FALSE, /* PACKET_CITY_REFRESH */
    FALSE, /* PACKET_CITY_NAME_SUGGESTION_REQ */
    FALSE, /* PACKET_CITY_NAME_SUGGESTION_INFO */
    FALSE, /* PACKET_CITY_SABOTAGE_LIST */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_PLAYER_REMOVE */
    FALSE, /* PACKET_PLAYER_INFO */
    FALSE, /* PACKET_PLAYER_PHASE_DONE */
    FALSE, /* PACKET_PLAYER_RATES */
    FALSE, /* PACKET_PLAYER_CHANGE_GOVERNMENT */
    FALSE, /* PACKET_PLAYER_RESEARCH */
    FALSE, /* PACKET_PLAYER_TECH_GOAL */
    FALSE, /* PACKET_PLAYER_ATTRIBUTE_BLOCK */
    FALSE, /* PACKET_PLAYER_ATTRIBUTE_CHUNK */
    FALSE, /* PACKET_PLAYER_DIPLSTATE */
    TRUE, /* PACKET_RESEARCH_INFO */
    FALSE,
    FALSE, /* PACKET_UNIT_REMOVE */
    TRUE, /* PACKET_UNIT_INFO */
    TRUE, /* PACKET_UNIT_SHORT_INFO */
    FALSE, /* PACKET_UNIT_COMBAT_INFO */
    FALSE,
    FALSE, /* PACKET_UNIT_BUILD_CITY */
    FALSE, /* PACKET_UNIT_DISBAND */
    FALSE, /* PACKET_UNIT_CHANGE_HOMECITY */
    FALSE,
    FALSE, /* PACKET_UNIT_BATTLEGROUP */
    FALSE,
    FALSE, /* PACKET_UNIT_ORDERS */
    FALSE, /* PACKET_UNIT_AUTOSETTLERS */
    FALSE, /* PACKET_UNIT_LOAD */
    FALSE, /* PACKET_UNIT_UNLOAD */
    FALSE, /* PACKET_UNIT_UPGRADE */
    FALSE,
    FALSE, /* PACKET_UNIT_NUKE */
    FALSE, /* PACKET_UNIT_PARADROP_TO */
    FALSE, /* PACKET_UNIT_AIRLIFT */
    FALSE, /* PACKET_UNIT_ACTION_QUERY */
    FALSE, /* PACKET_UNIT_TYPE_UPGRADE */
    FALSE, /* PACKET_UNIT_DO_ACTION */
    FALSE, /* PACKET_UNIT_ACTION_ANSWER */
    FALSE,
    FALSE, /* PACKET_UNIT_GET_ACTIONS */
    FALSE, /* PACKET_CONN_PING */
    FALSE, /* PACKET_CONN_PONG */
    FALSE, /* PACKET_UNIT_ACTIONS */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_DIPLOMACY_INIT_MEETING_REQ */
    FALSE, /* PACKET_DIPLOMACY_INIT_MEETING */
    FALSE, /* PACKET_DIPLOMACY_CANCEL_MEETING_REQ */
    FALSE, /* PACKET_DIPLOMACY_CANCEL_MEETING */
    FALSE, /* PACKET_DIPLOMACY_CREATE_CLAUSE_REQ */
    FALSE, /* PACKET_DIPLOMACY_CREATE_CLAUSE */
    FALSE, /* PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ */
    FALSE, /* PACKET_DIPLOMACY_REMOVE_CLAUSE */
    FALSE, /* PACKET_DIPLOMACY_ACCEPT_TREATY_REQ */
    FALSE, /* PACKET_DIPLOMACY_ACCEPT_TREATY */
    FALSE, /* PACKET_DIPLOMACY_CANCEL_PACT */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_PAGE_MSG */
    FALSE, /* PACKET_REPORT_REQ */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_CONN_INFO */
    FALSE, /* PACKET_CONN_PING_INFO */
    FALSE,
    FALSE,
    FALSE, /* PACKET_CLIENT_INFO */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_END_PHASE */
    FALSE, /* PACKET_START_PHASE */
    FALSE, /* PACKET_NEW_YEAR */
    FALSE, /* PACKET_BEGIN_TURN */
    FALSE, /* PACKET_END_TURN */
    FALSE, /* PACKET_FREEZE_CLIENT */
    FALSE, /* PACKET_THAW_CLIENT */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_SPACESHIP_LAUNCH */
    FALSE, /* PACKET_SPACESHIP_PLACE */
    TRUE, /* PACKET_SPACESHIP_INFO */
    FALSE,
    FALSE,
    FALSE, /* PACKET_RULESET_UNIT */
    FALSE, /* PACKET_RULESET_GAME */
    FALSE, /* PACKET_RULESET_SPECIALIST */
    FALSE, /* PACKET_RULESET_GOVERNMENT_RULER_TITLE */
    FALSE, /* PACKET_RULESET_TECH */
    FALSE, /* PACKET_RULESET_GOVERNMENT */
    FALSE, /* PACKET_RULESET_TERRAIN_CONTROL */
    FALSE, /* PACKET_RULESET_NATION_GROUPS */
    FALSE, /* PACKET_RULESET_NATION */
    FALSE, /* PACKET_RULESET_CITY */
    FALSE, /* PACKET_RULESET_BUILDING */
    FALSE, /* PACKET_RULESET_TERRAIN */
    FALSE, /* PACKET_RULESET_UNIT_CLASS */
    FALSE, /* PACKET_RULESET_BASE */
    FALSE,
    FALSE, /* PACKET_RULESET_CONTROL */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_SINGLE_WANT_HACK_REQ */
    FALSE, /* PACKET_SINGLE_WANT_HACK_REPLY */
    FALSE, /* PACKET_RULESET_CHOICES */
    FALSE, /* PACKET_GAME_LOAD */
    FALSE, /* PACKET_SERVER_SETTING_CONTROL */
    FALSE, /* PACKET_SERVER_SETTING_CONST */
    FALSE, /* PACKET_SERVER_SETTING_BOOL */
    FALSE, /* PACKET_SERVER_SETTING_INT */
    FALSE, /* PACKET_SERVER_SETTING_STR */
    FALSE, /* PACKET_SERVER_SETTING_ENUM */
    FALSE, /* PACKET_SERVER_SETTING_BITWISE */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_RULESET_EFFECT */
    FALSE,
    FALSE, /* PACKET_RULESET_RESOURCE */
    FALSE,
    FALSE,
    FALSE, /* PACKET_SCENARIO_INFO */
    FALSE, /* PACKET_SAVE_SCENARIO */
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_VOTE_NEW */
    FALSE, /* PACKET_VOTE_UPDATE */
    FALSE, /* PACKET_VOTE_REMOVE */
    FALSE, /* PACKET_VOTE_RESOLVE */
    FALSE, /* PACKET_VOTE_SUBMIT */
    FALSE, /* PACKET_EDIT_MODE */
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    FALSE, /* PACKET_EDIT_RECALCULATE_BORDERS */
    FALSE, /* PACKET_EDIT_CHECK_TILES */
    FALSE, /* PACKET_EDIT_TOGGLE_FOGOFWAR */
    FALSE, /* PACKET_EDIT_TILE_TERRAIN */
    FALSE, /* PACKET_EDIT_TILE_RESOURCE */
    FALSE, /* PACKET_EDIT_TILE_EXTRA */
    FALSE,
    FALSE, /* PACKET_EDIT_STARTPOS */
    FALSE, /* PACKET_EDIT_STARTPOS_FULL */
    FALSE, /* PACKET_EDIT_TILE */
    FALSE, /* PACKET_EDIT_UNIT_CREATE */
    FALSE, /* PACKET_EDIT_UNIT_REMOVE */
    FALSE, /* PACKET_EDIT_UNIT_REMOVE_BY_ID */
    FALSE, /* PACKET_EDIT_UNIT */
    FALSE, /* PACKET_EDIT_CITY_CREATE */
    FALSE, /* PACKET_EDIT_CITY_REMOVE */
    FALSE, /* PACKET_EDIT_CITY */
    FALSE, /* PACKET_EDIT_PLAYER_CREATE */
    FALSE, /* PACKET_EDIT_PLAYER_REMOVE */
    FALSE, /* PACKET_EDIT_PLAYER */
    FALSE, /* PACKET_EDIT_PLAYER_VISION */
    FALSE, /* PACKET_EDIT_GAME */
    FALSE, /* PACKET_EDIT_OBJECT_CREATED */
    FALSE, /* PACKET_RULESET_ROAD */
    FALSE,
    FALSE, /* PACKET_UNIT_CHANGE_ACTIVITY */
    FALSE, /* PACKET_ENDGAME_PLAYER */
    FALSE, /* PACKET_RULESET_DISASTER */
    FALSE, /* PACKET_RULESETS_READY */
    FALSE,
    FALSE, /* PACKET_RULESET_TRADE */
    FALSE, /* PACKET_RULESET_UNIT_BONUS */
    FALSE, /* PACKET_RULESET_UNIT_FLAG */
    FALSE,
    FALSE, /* PACKET_RULESET_TERRAIN_FLAG */
    FALSE, /* PACKET_RULESET_EXTRA */
    FALSE, /* PACKET_RULESET_ACHIEVEMENT */
    FALSE, /* PACKET_RULESET_TECH_FLAG */
    FALSE, /* PACKET_RULESET_ACTION_ENABLER */
    FALSE, /* PACKET_RULESET_NATION_SETS */
    FALSE, /* PACKET_NATION_AVAILABILITY */
    FALSE, /* PACKET_ACHIEVEMENT_INFO */
    FALSE, /* PACKET_RULESET_STYLE */
    FALSE, /* PACKET_RULESET_MUSIC */
    FALSE, /* PACKET_WORKER_TASK */
    FALSE, /* PACKET_PLAYER_MULTIPLIER */
    FALSE, /* PACKET_RULESET_MULTIPLIER */
    FALSE, /* PACKET_TIMEOUT_INFO */
    FALSE, /* PACKET_PLAY_MUSIC */
    FALSE, /* PACKET_RULESET_ACTION */
    FALSE, /* PACKET_RULESET_DESCRIPTION_PART */
    FALSE, /* PACKET_PAGE_MSG_PART */
    FALSE, /* PACKET_RULESET_SUMMARY */
    FALSE, /* PACKET_SET_TOPOLOGY */
    FALSE, /* PACKET_CLIENT_HEARTBEAT */
    FALSE, /* PACKET_SCENARIO_DESCRIPTION */
    FALSE, /* PACKET_EDIT_SCENARIO_DESC */
  };

  return (type >= 0 && type < PACKET_LAST ? flag[type] : FALSE);
}

static struct packet_processing_started *receive_packet_processing_started_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_processing_started, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_processing_started_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_started_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_STARTED);

  log_packet_detailed("packet_processing_started_100: sending info about ()");
  SEND_PACKET_END(PACKET_PROCESSING_STARTED);
}

int send_packet_processing_started(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PROCESSING_STARTED].no_packet != NULL, -1,
                        "Handler for PACKET_PROCESSING_STARTED not installed");
  return pc->phs.handlers->send[PACKET_PROCESSING_STARTED].no_packet(pc);
}

static struct packet_processing_finished *receive_packet_processing_finished_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_processing_finished, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_processing_finished_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_finished_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_FINISHED);

  log_packet_detailed("packet_processing_finished_100: sending info about ()");
  SEND_PACKET_END(PACKET_PROCESSING_FINISHED);
}

int send_packet_processing_finished(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PROCESSING_FINISHED].no_packet != NULL, -1,
                        "Handler for PACKET_PROCESSING_FINISHED not installed");
  return pc->phs.handlers->send[PACKET_PROCESSING_FINISHED].no_packet(pc);
}

static struct packet_server_join_req *receive_packet_server_join_req_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_join_req, real_packet);
  if (!DIO_GET(string, &din, "username", real_packet->username, sizeof(real_packet->username))) {
    RECEIVE_PACKET_FIELD_ERROR(username);
  }
  if (!DIO_GET(string, &din, "capability", real_packet->capability, sizeof(real_packet->capability))) {
    RECEIVE_PACKET_FIELD_ERROR(capability);
  }
  if (!DIO_GET(string, &din, "version_label", real_packet->version_label, sizeof(real_packet->version_label))) {
    RECEIVE_PACKET_FIELD_ERROR(version_label);
  }
  if (!DIO_GET(uint32, &din, "major_version", &real_packet->major_version)) {
    RECEIVE_PACKET_FIELD_ERROR(major_version);
  }
  if (!DIO_GET(uint32, &din, "minor_version", &real_packet->minor_version)) {
    RECEIVE_PACKET_FIELD_ERROR(minor_version);
  }
  if (!DIO_GET(uint32, &din, "patch_version", &real_packet->patch_version)) {
    RECEIVE_PACKET_FIELD_ERROR(patch_version);
  }

  log_packet_detailed("packet_server_join_req_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_req_100(struct connection *pc, const struct packet_server_join_req *packet)
{
  const struct packet_server_join_req *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REQ);

  log_packet_detailed("packet_server_join_req_100: sending info about ()");

  DIO_PUT(string, &dout, "username", real_packet->username);
  DIO_PUT(string, &dout, "capability", real_packet->capability);
  DIO_PUT(string, &dout, "version_label", real_packet->version_label);
  DIO_PUT(uint32, &dout, "major_version", real_packet->major_version);
  DIO_PUT(uint32, &dout, "minor_version", real_packet->minor_version);
  DIO_PUT(uint32, &dout, "patch_version", real_packet->patch_version);

  SEND_PACKET_END(PACKET_SERVER_JOIN_REQ);
}

int send_packet_server_join_req(struct connection *pc, const struct packet_server_join_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_JOIN_REQ].packet != NULL, -1,
                        "Handler for PACKET_SERVER_JOIN_REQ not installed");
  return pc->phs.handlers->send[PACKET_SERVER_JOIN_REQ].packet(pc, packet);
}

int dsend_packet_server_join_req(struct connection *pc, const char *username, const char *capability, const char *version_label, int major_version, int minor_version, int patch_version)
{
  struct packet_server_join_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->username, username);
  sz_strlcpy(real_packet->capability, capability);
  sz_strlcpy(real_packet->version_label, version_label);
  real_packet->major_version = major_version;
  real_packet->minor_version = minor_version;
  real_packet->patch_version = patch_version;
  
  return send_packet_server_join_req(pc, real_packet);
}

static struct packet_server_join_reply *receive_packet_server_join_reply_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_join_reply, real_packet);
  if (!DIO_GET(bool8, &din, "you_can_join", &real_packet->you_can_join)) {
    RECEIVE_PACKET_FIELD_ERROR(you_can_join);
  }
  if (!DIO_GET(string, &din, "message", real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }
  if (!DIO_GET(string, &din, "capability", real_packet->capability, sizeof(real_packet->capability))) {
    RECEIVE_PACKET_FIELD_ERROR(capability);
  }
  if (!DIO_GET(string, &din, "challenge_file", real_packet->challenge_file, sizeof(real_packet->challenge_file))) {
    RECEIVE_PACKET_FIELD_ERROR(challenge_file);
  }
  if (!DIO_GET(sint16, &din, "conn_id", &real_packet->conn_id)) {
    RECEIVE_PACKET_FIELD_ERROR(conn_id);
  }

  log_packet_detailed("packet_server_join_reply_100: got info about ()");
  post_receive_packet_server_join_reply(pc, real_packet);
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_reply_100(struct connection *pc, const struct packet_server_join_reply *packet)
{
  const struct packet_server_join_reply *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REPLY);

  log_packet_detailed("packet_server_join_reply_100: sending info about ()");

  DIO_PUT(bool8, &dout, "you_can_join", real_packet->you_can_join);
  DIO_PUT(string, &dout, "message", real_packet->message);
  DIO_PUT(string, &dout, "capability", real_packet->capability);
  DIO_PUT(string, &dout, "challenge_file", real_packet->challenge_file);
  DIO_PUT(sint16, &dout, "conn_id", real_packet->conn_id);

  post_send_packet_server_join_reply(pc, real_packet);
  SEND_PACKET_END(PACKET_SERVER_JOIN_REPLY);
}

int send_packet_server_join_reply(struct connection *pc, const struct packet_server_join_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_JOIN_REPLY].packet != NULL, -1,
                        "Handler for PACKET_SERVER_JOIN_REPLY not installed");
  return pc->phs.handlers->send[PACKET_SERVER_JOIN_REPLY].packet(pc, packet);
}

#define hash_packet_authentication_req_100 hash_const

#define cmp_packet_authentication_req_100 cmp_const

BV_DEFINE(packet_authentication_req_100_fields, 2);

static struct packet_authentication_req *receive_packet_authentication_req_100(struct connection *pc)
{
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  struct genhash **hash = pc->phs.received + PACKET_AUTHENTICATION_REQ;
  RECEIVE_PACKET_START(packet_authentication_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_authentication_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'message'");
    if (!DIO_GET(string, &din, "message", real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_req_100(struct connection *pc, const struct packet_authentication_req *packet)
{
  const struct packet_authentication_req *real_packet = packet;
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_AUTHENTICATION_REQ);

  log_packet_detailed("packet_authentication_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'message' has changed");
    DIO_PUT(string, &dout, "message", real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_AUTHENTICATION_REQ);
}

int send_packet_authentication_req(struct connection *pc, const struct packet_authentication_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_AUTHENTICATION_REQ].packet != NULL, -1,
                        "Handler for PACKET_AUTHENTICATION_REQ not installed");
  return pc->phs.handlers->send[PACKET_AUTHENTICATION_REQ].packet(pc, packet);
}

int dsend_packet_authentication_req(struct connection *pc, enum authentication_type type, const char *message)
{
  struct packet_authentication_req packet, *real_packet = &packet;

  real_packet->type = type;
  sz_strlcpy(real_packet->message, message);
  
  return send_packet_authentication_req(pc, real_packet);
}

#define hash_packet_authentication_reply_100 hash_const

#define cmp_packet_authentication_reply_100 cmp_const

BV_DEFINE(packet_authentication_reply_100_fields, 1);

static struct packet_authentication_reply *receive_packet_authentication_reply_100(struct connection *pc)
{
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  struct genhash **hash = pc->phs.received + PACKET_AUTHENTICATION_REPLY;
  RECEIVE_PACKET_START(packet_authentication_reply, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_authentication_reply_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'password'");
    if (!DIO_GET(string, &din, "password", real_packet->password, sizeof(real_packet->password))) {
      RECEIVE_PACKET_FIELD_ERROR(password);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_reply_100(struct connection *pc, const struct packet_authentication_reply *packet)
{
  const struct packet_authentication_reply *real_packet = packet;
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REPLY;
  int different = 0;
  SEND_PACKET_START(PACKET_AUTHENTICATION_REPLY);

  log_packet_detailed("packet_authentication_reply_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->password, real_packet->password) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'password' has changed");
    DIO_PUT(string, &dout, "password", real_packet->password);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_AUTHENTICATION_REPLY);
}

int send_packet_authentication_reply(struct connection *pc, const struct packet_authentication_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_AUTHENTICATION_REPLY].packet != NULL, -1,
                        "Handler for PACKET_AUTHENTICATION_REPLY not installed");
  return pc->phs.handlers->send[PACKET_AUTHENTICATION_REPLY].packet(pc, packet);
}

static struct packet_server_shutdown *receive_packet_server_shutdown_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_shutdown, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_server_shutdown_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_shutdown_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SERVER_SHUTDOWN);

  log_packet_detailed("packet_server_shutdown_100: sending info about ()");
  SEND_PACKET_END(PACKET_SERVER_SHUTDOWN);
}

int send_packet_server_shutdown(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SHUTDOWN].no_packet != NULL, -1,
                        "Handler for PACKET_SERVER_SHUTDOWN not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SHUTDOWN].no_packet(pc);
}

void lsend_packet_server_shutdown(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_server_shutdown(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_nation_select_req_100 hash_const

#define cmp_packet_nation_select_req_100 cmp_const

BV_DEFINE(packet_nation_select_req_100_fields, 5);

static struct packet_nation_select_req *receive_packet_nation_select_req_100(struct connection *pc)
{
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  struct genhash **hash = pc->phs.received + PACKET_NATION_SELECT_REQ;
  RECEIVE_PACKET_START(packet_nation_select_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nation_select_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    if (!DIO_GET(uint8, &din, "player_no", &real_packet->player_no)) {
      RECEIVE_PACKET_FIELD_ERROR(player_no);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation_no'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "nation_no", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation_no);
      }
      real_packet->nation_no = readin;
    }
  }
  real_packet->is_male = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'style'");
    if (!DIO_GET(uint8, &din, "style", &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_select_req_100(struct connection *pc, const struct packet_nation_select_req *packet)
{
  const struct packet_nation_select_req *real_packet = packet;
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_SELECT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_NATION_SELECT_REQ);

  log_packet_detailed("packet_nation_select_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nation_no != real_packet->nation_no);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
    DIO_PUT(uint8, &dout, "player_no", real_packet->player_no);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation_no' has changed");
    DIO_PUT(sint16, &dout, "nation_no", real_packet->nation_no);
  }
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'style' has changed");
    DIO_PUT(uint8, &dout, "style", real_packet->style);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NATION_SELECT_REQ);
}

int send_packet_nation_select_req(struct connection *pc, const struct packet_nation_select_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_NATION_SELECT_REQ].packet != NULL, -1,
                        "Handler for PACKET_NATION_SELECT_REQ not installed");
  return pc->phs.handlers->send[PACKET_NATION_SELECT_REQ].packet(pc, packet);
}

int dsend_packet_nation_select_req(struct connection *pc, int player_no, Nation_type_id nation_no, bool is_male, const char *name, int style)
{
  struct packet_nation_select_req packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->nation_no = nation_no;
  real_packet->is_male = is_male;
  sz_strlcpy(real_packet->name, name);
  real_packet->style = style;
  
  return send_packet_nation_select_req(pc, real_packet);
}

#define hash_packet_player_ready_100 hash_const

#define cmp_packet_player_ready_100 cmp_const

BV_DEFINE(packet_player_ready_100_fields, 2);

static struct packet_player_ready *receive_packet_player_ready_100(struct connection *pc)
{
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_READY;
  RECEIVE_PACKET_START(packet_player_ready, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_ready_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    if (!DIO_GET(uint8, &din, "player_no", &real_packet->player_no)) {
      RECEIVE_PACKET_FIELD_ERROR(player_no);
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 1);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_ready_100(struct connection *pc, const struct packet_player_ready *packet)
{
  const struct packet_player_ready *real_packet = packet;
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_READY;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_READY);

  log_packet_detailed("packet_player_ready_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
    DIO_PUT(uint8, &dout, "player_no", real_packet->player_no);
  }
  /* field 1 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_READY);
}

int send_packet_player_ready(struct connection *pc, const struct packet_player_ready *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_READY].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_READY not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_READY].packet(pc, packet);
}

int dsend_packet_player_ready(struct connection *pc, int player_no, bool is_ready)
{
  struct packet_player_ready packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->is_ready = is_ready;
  
  return send_packet_player_ready(pc, real_packet);
}

static struct packet_endgame_report *receive_packet_endgame_report_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_endgame_report, real_packet);
  if (!DIO_GET(uint8, &din, "category_num", &real_packet->category_num)) {
    RECEIVE_PACKET_FIELD_ERROR(category_num);
  }
  
  {
    int i;
  
    if (real_packet->category_num > 32) {
      RECEIVE_PACKET_FIELD_ERROR(category_name, ": truncation array");
    }
    for (i = 0; i < real_packet->category_num; i++) {
      if (!DIO_GET(string, &din, "category_name", real_packet->category_name[i], sizeof(real_packet->category_name[i]))) {
        RECEIVE_PACKET_FIELD_ERROR(category_name);
      }
    }
  }
  if (!DIO_GET(uint8, &din, "player_num", &real_packet->player_num)) {
    RECEIVE_PACKET_FIELD_ERROR(player_num);
  }

  log_packet_detailed("packet_endgame_report_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_report_100(struct connection *pc, const struct packet_endgame_report *packet)
{
  const struct packet_endgame_report *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_REPORT);

  log_packet_detailed("packet_endgame_report_100: sending info about ()");

  DIO_PUT(uint8, &dout, "category_num", real_packet->category_num);

    {
      int i;

      for (i = 0; i < real_packet->category_num; i++) {
        dio_put_string(&dout, real_packet->category_name[i]);
      }
    } 
  DIO_PUT(uint8, &dout, "player_num", real_packet->player_num);

  SEND_PACKET_END(PACKET_ENDGAME_REPORT);
}

int send_packet_endgame_report(struct connection *pc, const struct packet_endgame_report *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_ENDGAME_REPORT].packet != NULL, -1,
                        "Handler for PACKET_ENDGAME_REPORT not installed");
  return pc->phs.handlers->send[PACKET_ENDGAME_REPORT].packet(pc, packet);
}

void lsend_packet_endgame_report(struct conn_list *dest, const struct packet_endgame_report *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_report(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_endgame_player *receive_packet_endgame_player_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_endgame_player, real_packet);
  if (!DIO_GET(uint8, &din, "category_num", &real_packet->category_num)) {
    RECEIVE_PACKET_FIELD_ERROR(category_num);
  }
  if (!DIO_GET(uint8, &din, "player_id", &real_packet->player_id)) {
    RECEIVE_PACKET_FIELD_ERROR(player_id);
  }
  if (!DIO_GET(uint16, &din, "score", &real_packet->score)) {
    RECEIVE_PACKET_FIELD_ERROR(score);
  }
  
  {
    int i;
  
    if (real_packet->category_num > 32) {
      RECEIVE_PACKET_FIELD_ERROR(category_score, ": truncation array");
    }
    for (i = 0; i < real_packet->category_num; i++) {
      if (!DIO_GET(uint32, &din, "category_score", &real_packet->category_score[i])) {
        RECEIVE_PACKET_FIELD_ERROR(category_score);
      }
    }
  }
  if (!DIO_GET(bool8, &din, "winner", &real_packet->winner)) {
    RECEIVE_PACKET_FIELD_ERROR(winner);
  }

  log_packet_detailed("packet_endgame_player_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_player_100(struct connection *pc, const struct packet_endgame_player *packet)
{
  const struct packet_endgame_player *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_PLAYER);

  log_packet_detailed("packet_endgame_player_100: sending info about ()");

  DIO_PUT(uint8, &dout, "category_num", real_packet->category_num);
  DIO_PUT(uint8, &dout, "player_id", real_packet->player_id);
  DIO_PUT(uint16, &dout, "score", real_packet->score);

    {
      int i;

      for (i = 0; i < real_packet->category_num; i++) {
        dio_put_uint32(&dout, real_packet->category_score[i]);
      }
    } 
  DIO_PUT(bool8, &dout, "winner", real_packet->winner);

  SEND_PACKET_END(PACKET_ENDGAME_PLAYER);
}

int send_packet_endgame_player(struct connection *pc, const struct packet_endgame_player *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_ENDGAME_PLAYER].packet != NULL, -1,
                        "Handler for PACKET_ENDGAME_PLAYER not installed");
  return pc->phs.handlers->send[PACKET_ENDGAME_PLAYER].packet(pc, packet);
}

void lsend_packet_endgame_player(struct conn_list *dest, const struct packet_endgame_player *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_player(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_tile_info_100(const void *vkey)
{
  const struct packet_tile_info *key = (const struct packet_tile_info *) vkey;

  return key->tile;
}

static bool cmp_packet_tile_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_tile_info *key1 = (const struct packet_tile_info *) vkey1;
  const struct packet_tile_info *key2 = (const struct packet_tile_info *) vkey2;

  return key1->tile == key2->tile;
}

BV_DEFINE(packet_tile_info_100_fields, 10);

static struct packet_tile_info *receive_packet_tile_info_100(struct connection *pc)
{
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TILE_INFO;
  RECEIVE_PACKET_START(packet_tile_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }

  log_packet_detailed("packet_tile_info_100: got info about (%d)",
    real_packet->tile);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int tile = real_packet->tile;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->tile = tile;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'continent'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "continent", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(continent);
      }
      real_packet->continent = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'known'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "known", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(known);
      }
      real_packet->known = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    if (!DIO_GET(uint8, &din, "owner", &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'extras_owner'");
    if (!DIO_GET(uint8, &din, "extras_owner", &real_packet->extras_owner)) {
      RECEIVE_PACKET_FIELD_ERROR(extras_owner);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'worked'");
    if (!DIO_GET(uint16, &din, "worked", &real_packet->worked)) {
      RECEIVE_PACKET_FIELD_ERROR(worked);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'terrain'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "terrain", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(terrain);
      }
      real_packet->terrain = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'resource'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "resource", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(resource);
      }
      real_packet->resource = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'extras'");
    if (!DIO_BV_GET(&din, real_packet->extras)) {
      RECEIVE_PACKET_FIELD_ERROR(extras);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'spec_sprite'");
    if (!DIO_GET(string, &din, "spec_sprite", real_packet->spec_sprite, sizeof(real_packet->spec_sprite))) {
      RECEIVE_PACKET_FIELD_ERROR(spec_sprite);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'label'");
    if (!DIO_GET(string, &din, "label", real_packet->label, sizeof(real_packet->label))) {
      RECEIVE_PACKET_FIELD_ERROR(label);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_tile_info_100(struct connection *pc, const struct packet_tile_info *packet)
{
  const struct packet_tile_info *real_packet = packet;
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TILE_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TILE_INFO);

  log_packet_detailed("packet_tile_info_100: sending info about (%d)",
    real_packet->tile);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->continent != real_packet->continent);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->known != real_packet->known);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->extras_owner != real_packet->extras_owner);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->worked != real_packet->worked);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->terrain != real_packet->terrain);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->resource != real_packet->resource);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->extras, real_packet->extras);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->spec_sprite, real_packet->spec_sprite) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->label, real_packet->label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(sint32, &dout, "tile", real_packet->tile);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'continent' has changed");
    DIO_PUT(sint16, &dout, "continent", real_packet->continent);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'known' has changed");
    DIO_PUT(uint8, &dout, "known", real_packet->known);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
    DIO_PUT(uint8, &dout, "owner", real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'extras_owner' has changed");
    DIO_PUT(uint8, &dout, "extras_owner", real_packet->extras_owner);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'worked' has changed");
    DIO_PUT(uint16, &dout, "worked", real_packet->worked);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'terrain' has changed");
    DIO_PUT(uint8, &dout, "terrain", real_packet->terrain);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'resource' has changed");
    DIO_PUT(uint8, &dout, "resource", real_packet->resource);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'extras' has changed");
  DIO_BV_PUT(&dout, "extras", packet->extras);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'spec_sprite' has changed");
    DIO_PUT(string, &dout, "spec_sprite", real_packet->spec_sprite);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'label' has changed");
    DIO_PUT(string, &dout, "label", real_packet->label);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_TILE_INFO);
}

int send_packet_tile_info(struct connection *pc, const struct packet_tile_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TILE_INFO].packet != NULL, -1,
                        "Handler for PACKET_TILE_INFO not installed");
  return pc->phs.handlers->send[PACKET_TILE_INFO].packet(pc, packet);
}

void lsend_packet_tile_info(struct conn_list *dest, const struct packet_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_game_info_100 hash_const

#define cmp_packet_game_info_100 cmp_const

BV_DEFINE(packet_game_info_100_fields, 107);

static struct packet_game_info *receive_packet_game_info_100(struct connection *pc)
{
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  struct genhash **hash = pc->phs.received + PACKET_GAME_INFO;
  RECEIVE_PACKET_START(packet_game_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'add_to_size_limit'");
    if (!DIO_GET(uint8, &din, "add_to_size_limit", &real_packet->add_to_size_limit)) {
      RECEIVE_PACKET_FIELD_ERROR(add_to_size_limit);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'aifill'");
    if (!DIO_GET(uint8, &din, "aifill", &real_packet->aifill)) {
      RECEIVE_PACKET_FIELD_ERROR(aifill);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'persistent_ready'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "persistent_ready", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(persistent_ready);
      }
      real_packet->persistent_ready = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'airlifting_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "airlifting_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(airlifting_style);
      }
      real_packet->airlifting_style = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'angrycitizen'");
    if (!DIO_GET(uint8, &din, "angrycitizen", &real_packet->angrycitizen)) {
      RECEIVE_PACKET_FIELD_ERROR(angrycitizen);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'base_pollution'");
    if (!DIO_GET(sint16, &din, "base_pollution", &real_packet->base_pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(base_pollution);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'base_tech_cost'");
    if (!DIO_GET(uint8, &din, "base_tech_cost", &real_packet->base_tech_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_tech_cost);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'border_city_radius_sq'");
    if (!DIO_GET(uint16, &din, "border_city_radius_sq", &real_packet->border_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'border_size_effect'");
    if (!DIO_GET(uint8, &din, "border_size_effect", &real_packet->border_size_effect)) {
      RECEIVE_PACKET_FIELD_ERROR(border_size_effect);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'border_city_permanent_radius_sq'");
    if (!DIO_GET(sint16, &din, "border_city_permanent_radius_sq", &real_packet->border_city_permanent_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_permanent_radius_sq);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'borders'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "borders", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(borders);
      }
      real_packet->borders = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'base_bribe_cost'");
    if (!DIO_GET(uint32, &din, "base_bribe_cost", &real_packet->base_bribe_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_bribe_cost);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'culture_vic_points'");
    if (!DIO_GET(uint32, &din, "culture_vic_points", &real_packet->culture_vic_points)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_vic_points);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'culture_vic_lead'");
    if (!DIO_GET(uint16, &din, "culture_vic_lead", &real_packet->culture_vic_lead)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_vic_lead);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'culture_migration_pml'");
    if (!DIO_GET(uint16, &din, "culture_migration_pml", &real_packet->culture_migration_pml)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_migration_pml);
    }
  }
  real_packet->calendar_skip_0 = BV_ISSET(fields, 15);
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'celebratesize'");
    if (!DIO_GET(uint8, &din, "celebratesize", &real_packet->celebratesize)) {
      RECEIVE_PACKET_FIELD_ERROR(celebratesize);
    }
  }
  real_packet->changable_tax = BV_ISSET(fields, 17);
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'pop_report_zeroes'");
    if (!DIO_GET(uint8, &din, "pop_report_zeroes", &real_packet->pop_report_zeroes)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_report_zeroes);
    }
  }
  real_packet->citizen_nationality = BV_ISSET(fields, 19);
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'citizen_convert_speed'");
    if (!DIO_GET(uint16, &din, "citizen_convert_speed", &real_packet->citizen_convert_speed)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_convert_speed);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'citizen_partisans_pct'");
    if (!DIO_GET(uint8, &din, "citizen_partisans_pct", &real_packet->citizen_partisans_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_partisans_pct);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'citymindist'");
    if (!DIO_GET(uint8, &din, "citymindist", &real_packet->citymindist)) {
      RECEIVE_PACKET_FIELD_ERROR(citymindist);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'cooling'");
    if (!DIO_GET(uint32, &din, "cooling", &real_packet->cooling)) {
      RECEIVE_PACKET_FIELD_ERROR(cooling);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'coolinglevel'");
    if (!DIO_GET(uint32, &din, "coolinglevel", &real_packet->coolinglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(coolinglevel);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'diplomacy'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "diplomacy", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(diplomacy);
      }
      real_packet->diplomacy = readin;
    }
  }
  real_packet->fogofwar = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'food_cost'");
    if (!DIO_GET(uint8, &din, "food_cost", &real_packet->food_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(food_cost);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'foodbox'");
    if (!DIO_GET(uint32, &din, "foodbox", &real_packet->foodbox)) {
      RECEIVE_PACKET_FIELD_ERROR(foodbox);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'forced_gold'");
    if (!DIO_GET(uint8, &din, "forced_gold", &real_packet->forced_gold)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_gold);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'forced_luxury'");
    if (!DIO_GET(uint8, &din, "forced_luxury", &real_packet->forced_luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_luxury);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'forced_science'");
    if (!DIO_GET(uint8, &din, "forced_science", &real_packet->forced_science)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_science);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'fulltradesize'");
    if (!DIO_GET(uint8, &din, "fulltradesize", &real_packet->fulltradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(fulltradesize);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'global_advances'");
    
    for (;;) {
      int i;
    
      if (!DIO_GET(uint8, &din, "global_advances", &i)) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances);
      }
      if (i == 255) {
        break;
      }
      if (i > A_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances,
                                   ": unexpected value %d "
                                   "(> A_LAST) in array diff",
                                   i);
      } else {
        if (!DIO_GET(bool8, &din, "global_advances", &real_packet->global_advances[i])) {
          RECEIVE_PACKET_FIELD_ERROR(global_advances);
        }
      }
    }
  }
  real_packet->global_warming = BV_ISSET(fields, 34);
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'globalwarming'");
    if (!DIO_GET(uint32, &din, "globalwarming", &real_packet->globalwarming)) {
      RECEIVE_PACKET_FIELD_ERROR(globalwarming);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'gold'");
    if (!DIO_GET(uint32, &din, "gold", &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'gold_upkeep_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "gold_upkeep_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gold_upkeep_style);
      }
      real_packet->gold_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'revolentype'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "revolentype", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(revolentype);
      }
      real_packet->revolentype = readin;
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'default_government_id'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "default_government_id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(default_government_id);
      }
      real_packet->default_government_id = readin;
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'government_during_revolution_id'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "government_during_revolution_id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(government_during_revolution_id);
      }
      real_packet->government_during_revolution_id = readin;
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'granary_food_inc'");
    if (!DIO_GET(uint8, &din, "granary_food_inc", &real_packet->granary_food_inc)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_food_inc);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'granary_food_ini'");
    
    {
      int i;
    
      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        if (!DIO_GET(uint8, &din, "granary_food_ini", &real_packet->granary_food_ini[i])) {
          RECEIVE_PACKET_FIELD_ERROR(granary_food_ini);
        }
      }
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'granary_num_inis'");
    if (!DIO_GET(uint8, &din, "granary_num_inis", &real_packet->granary_num_inis)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_num_inis);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'great_wonder_owners'");
    
    for (;;) {
      int i;
    
      if (!DIO_GET(uint8, &din, "great_wonder_owners", &i)) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
        if (!DIO_GET(uint8, &din, "great_wonder_owners", &real_packet->great_wonder_owners[i])) {
          RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
        }
      }
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'happy_cost'");
    if (!DIO_GET(uint8, &din, "happy_cost", &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'happyborders'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "happyborders", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(happyborders);
      }
      real_packet->happyborders = readin;
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'heating'");
    if (!DIO_GET(uint32, &din, "heating", &real_packet->heating)) {
      RECEIVE_PACKET_FIELD_ERROR(heating);
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'illness_base_factor'");
    if (!DIO_GET(uint16, &din, "illness_base_factor", &real_packet->illness_base_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_base_factor);
    }
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  got field 'illness_min_size'");
    if (!DIO_GET(uint8, &din, "illness_min_size", &real_packet->illness_min_size)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_min_size);
    }
  }
  real_packet->illness_on = BV_ISSET(fields, 50);
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  got field 'illness_pollution_factor'");
    if (!DIO_GET(uint16, &din, "illness_pollution_factor", &real_packet->illness_pollution_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_pollution_factor);
    }
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  got field 'illness_trade_infection'");
    if (!DIO_GET(uint16, &din, "illness_trade_infection", &real_packet->illness_trade_infection)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade_infection);
    }
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  got field 'init_city_radius_sq'");
    if (!DIO_GET(uint8, &din, "init_city_radius_sq", &real_packet->init_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(init_city_radius_sq);
    }
  }
  real_packet->is_edit_mode = BV_ISSET(fields, 54);
  real_packet->is_new_game = BV_ISSET(fields, 55);
  real_packet->killcitizen = BV_ISSET(fields, 56);
  real_packet->killstack = BV_ISSET(fields, 57);
  if (BV_ISSET(fields, 58)) {
    log_packet_detailed("  got field 'min_city_center_output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint8, &din, "min_city_center_output", &real_packet->min_city_center_output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(min_city_center_output);
        }
      }
    }
  }
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  got field 'negative_year_label'");
    if (!DIO_GET(string, &din, "negative_year_label", real_packet->negative_year_label, sizeof(real_packet->negative_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(negative_year_label);
    }
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  got field 'notradesize'");
    if (!DIO_GET(uint8, &din, "notradesize", &real_packet->notradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(notradesize);
    }
  }
  real_packet->nuclear_winter = BV_ISSET(fields, 61);
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  got field 'nuclearwinter'");
    if (!DIO_GET(uint32, &din, "nuclearwinter", &real_packet->nuclearwinter)) {
      RECEIVE_PACKET_FIELD_ERROR(nuclearwinter);
    }
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  got field 'phase'");
    if (!DIO_GET(sint16, &din, "phase", &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  got field 'phase_mode'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "phase_mode", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(phase_mode);
      }
      real_packet->phase_mode = readin;
    }
  }
  real_packet->pillage_select = BV_ISSET(fields, 65);
  real_packet->tech_steal_allow_holes = BV_ISSET(fields, 66);
  real_packet->tech_trade_allow_holes = BV_ISSET(fields, 67);
  real_packet->tech_trade_loss_allow_holes = BV_ISSET(fields, 68);
  real_packet->tech_parasite_allow_holes = BV_ISSET(fields, 69);
  real_packet->tech_loss_allow_holes = BV_ISSET(fields, 70);
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  got field 'positive_year_label'");
    if (!DIO_GET(string, &din, "positive_year_label", real_packet->positive_year_label, sizeof(real_packet->positive_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(positive_year_label);
    }
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  got field 'rapturedelay'");
    if (!DIO_GET(uint8, &din, "rapturedelay", &real_packet->rapturedelay)) {
      RECEIVE_PACKET_FIELD_ERROR(rapturedelay);
    }
  }
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  got field 'disasters'");
    if (!DIO_GET(uint16, &din, "disasters", &real_packet->disasters)) {
      RECEIVE_PACKET_FIELD_ERROR(disasters);
    }
  }
  real_packet->restrictinfra = BV_ISSET(fields, 74);
  real_packet->unreachable_protects = BV_ISSET(fields, 75);
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  got field 'sciencebox'");
    if (!DIO_GET(uint32, &din, "sciencebox", &real_packet->sciencebox)) {
      RECEIVE_PACKET_FIELD_ERROR(sciencebox);
    }
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  got field 'shieldbox'");
    if (!DIO_GET(uint32, &din, "shieldbox", &real_packet->shieldbox)) {
      RECEIVE_PACKET_FIELD_ERROR(shieldbox);
    }
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  got field 'skill_level'");
    if (!DIO_GET(uint32, &din, "skill_level", &real_packet->skill_level)) {
      RECEIVE_PACKET_FIELD_ERROR(skill_level);
    }
  }
  real_packet->slow_invasions = BV_ISSET(fields, 79);
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  got field 'victory_conditions'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "victory_conditions", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(victory_conditions);
      }
      real_packet->victory_conditions = readin;
    }
  }
  real_packet->team_pooled_research = BV_ISSET(fields, 81);
  if (BV_ISSET(fields, 82)) {
    log_packet_detailed("  got field 'tech'");
    if (!DIO_GET(uint32, &din, "tech", &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }
  if (BV_ISSET(fields, 83)) {
    log_packet_detailed("  got field 'tech_cost_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "tech_cost_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_cost_style);
      }
      real_packet->tech_cost_style = readin;
    }
  }
  if (BV_ISSET(fields, 84)) {
    log_packet_detailed("  got field 'tech_leakage'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "tech_leakage", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_leakage);
      }
      real_packet->tech_leakage = readin;
    }
  }
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  got field 'tech_upkeep_divider'");
    if (!DIO_GET(uint16, &din, "tech_upkeep_divider", &real_packet->tech_upkeep_divider)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_divider);
    }
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  got field 'tech_upkeep_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "tech_upkeep_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_style);
      }
      real_packet->tech_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 87)) {
    log_packet_detailed("  got field 'techloss_forgiveness'");
    if (!DIO_GET(sint16, &din, "techloss_forgiveness", &real_packet->techloss_forgiveness)) {
      RECEIVE_PACKET_FIELD_ERROR(techloss_forgiveness);
    }
  }
  if (BV_ISSET(fields, 88)) {
    log_packet_detailed("  got field 'free_tech_method'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "free_tech_method", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(free_tech_method);
      }
      real_packet->free_tech_method = readin;
    }
  }
  if (BV_ISSET(fields, 89)) {
    log_packet_detailed("  got field 'gameloss_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "gameloss_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gameloss_style);
      }
      real_packet->gameloss_style = readin;
    }
  }
  if (BV_ISSET(fields, 90)) {
    log_packet_detailed("  got field 'timeout'");
    if (!DIO_GET(uint32, &din, "timeout", &real_packet->timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(timeout);
    }
  }
  if (BV_ISSET(fields, 91)) {
    log_packet_detailed("  got field 'first_timeout'");
    if (!DIO_GET(uint32, &din, "first_timeout", &real_packet->first_timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(first_timeout);
    }
  }
  real_packet->tired_attack = BV_ISSET(fields, 92);
  if (BV_ISSET(fields, 93)) {
    log_packet_detailed("  got field 'trademindist'");
    if (!DIO_GET(uint16, &din, "trademindist", &real_packet->trademindist)) {
      RECEIVE_PACKET_FIELD_ERROR(trademindist);
    }
  }
  real_packet->force_trade_route = BV_ISSET(fields, 94);
  real_packet->trading_city = BV_ISSET(fields, 95);
  real_packet->trading_gold = BV_ISSET(fields, 96);
  real_packet->trading_tech = BV_ISSET(fields, 97);
  if (BV_ISSET(fields, 98)) {
    log_packet_detailed("  got field 'turn'");
    if (!DIO_GET(sint16, &din, "turn", &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 99)) {
    log_packet_detailed("  got field 'warminglevel'");
    if (!DIO_GET(uint32, &din, "warminglevel", &real_packet->warminglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(warminglevel);
    }
  }
  if (BV_ISSET(fields, 100)) {
    log_packet_detailed("  got field 'year'");
    if (!DIO_GET(sint16, &din, "year", &real_packet->year)) {
      RECEIVE_PACKET_FIELD_ERROR(year);
    }
  }
  real_packet->year_0_hack = BV_ISSET(fields, 101);
  if (BV_ISSET(fields, 102)) {
    log_packet_detailed("  got field 'calendar_fragments'");
    if (!DIO_GET(uint16, &din, "calendar_fragments", &real_packet->calendar_fragments)) {
      RECEIVE_PACKET_FIELD_ERROR(calendar_fragments);
    }
  }
  if (BV_ISSET(fields, 103)) {
    log_packet_detailed("  got field 'fragment_count'");
    if (!DIO_GET(uint16, &din, "fragment_count", &real_packet->fragment_count)) {
      RECEIVE_PACKET_FIELD_ERROR(fragment_count);
    }
  }
  if (BV_ISSET(fields, 104)) {
    log_packet_detailed("  got field 'calendar_fragment_name'");
    
    {
      int i;
    
      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
        if (!DIO_GET(string, &din, "calendar_fragment_name", real_packet->calendar_fragment_name[i], sizeof(real_packet->calendar_fragment_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(calendar_fragment_name);
        }
      }
    }
  }
  real_packet->civil_war_enabled = BV_ISSET(fields, 105);
  real_packet->paradrop_to_transport = BV_ISSET(fields, 106);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_info_100(struct connection *pc, const struct packet_game_info *packet)
{
  const struct packet_game_info *real_packet = packet;
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_INFO);

  log_packet_detailed("packet_game_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->add_to_size_limit != real_packet->add_to_size_limit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->aifill != real_packet->aifill);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->persistent_ready != real_packet->persistent_ready);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->airlifting_style != real_packet->airlifting_style);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->angrycitizen != real_packet->angrycitizen);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->base_pollution != real_packet->base_pollution);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->base_tech_cost != real_packet->base_tech_cost);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->border_city_radius_sq != real_packet->border_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->border_size_effect != real_packet->border_size_effect);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->border_city_permanent_radius_sq != real_packet->border_city_permanent_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->borders != real_packet->borders);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->base_bribe_cost != real_packet->base_bribe_cost);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->culture_vic_points != real_packet->culture_vic_points);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->culture_vic_lead != real_packet->culture_vic_lead);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->culture_migration_pml != real_packet->culture_migration_pml);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->calendar_skip_0 != real_packet->calendar_skip_0);
  if(differ) {
    different++;
  }
  if (packet->calendar_skip_0) {
    BV_SET(fields, 15);
  }

  differ = (old->celebratesize != real_packet->celebratesize);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->changable_tax != real_packet->changable_tax);
  if(differ) {
    different++;
  }
  if (packet->changable_tax) {
    BV_SET(fields, 17);
  }

  differ = (old->pop_report_zeroes != real_packet->pop_report_zeroes);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->citizen_nationality != real_packet->citizen_nationality);
  if(differ) {
    different++;
  }
  if (packet->citizen_nationality) {
    BV_SET(fields, 19);
  }

  differ = (old->citizen_convert_speed != real_packet->citizen_convert_speed);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->citizen_partisans_pct != real_packet->citizen_partisans_pct);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->citymindist != real_packet->citymindist);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->cooling != real_packet->cooling);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->coolinglevel != real_packet->coolinglevel);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->diplomacy != real_packet->diplomacy);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->fogofwar != real_packet->fogofwar);
  if(differ) {
    different++;
  }
  if (packet->fogofwar) {
    BV_SET(fields, 26);
  }

  differ = (old->food_cost != real_packet->food_cost);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->foodbox != real_packet->foodbox);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->forced_gold != real_packet->forced_gold);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->forced_luxury != real_packet->forced_luxury);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->forced_science != real_packet->forced_science);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->fulltradesize != real_packet->fulltradesize);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (A_LAST != A_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < A_LAST; i++) {
          if (old->global_advances[i] != real_packet->global_advances[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->global_warming != real_packet->global_warming);
  if(differ) {
    different++;
  }
  if (packet->global_warming) {
    BV_SET(fields, 34);
  }

  differ = (old->globalwarming != real_packet->globalwarming);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->gold_upkeep_style != real_packet->gold_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->revolentype != real_packet->revolentype);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->default_government_id != real_packet->default_government_id);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = (old->government_during_revolution_id != real_packet->government_during_revolution_id);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (old->granary_food_inc != real_packet->granary_food_inc);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }


    {
      differ = (MAX_GRANARY_INIS != MAX_GRANARY_INIS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_GRANARY_INIS; i++) {
          if (old->granary_food_ini[i] != real_packet->granary_food_ini[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->granary_num_inis != real_packet->granary_num_inis);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = (old->happyborders != real_packet->happyborders);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (old->heating != real_packet->heating);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = (old->illness_base_factor != real_packet->illness_base_factor);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }

  differ = (old->illness_min_size != real_packet->illness_min_size);
  if (differ) {
    different++;
    BV_SET(fields, 49);
  }

  differ = (old->illness_on != real_packet->illness_on);
  if(differ) {
    different++;
  }
  if (packet->illness_on) {
    BV_SET(fields, 50);
  }

  differ = (old->illness_pollution_factor != real_packet->illness_pollution_factor);
  if (differ) {
    different++;
    BV_SET(fields, 51);
  }

  differ = (old->illness_trade_infection != real_packet->illness_trade_infection);
  if (differ) {
    different++;
    BV_SET(fields, 52);
  }

  differ = (old->init_city_radius_sq != real_packet->init_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 53);
  }

  differ = (old->is_edit_mode != real_packet->is_edit_mode);
  if(differ) {
    different++;
  }
  if (packet->is_edit_mode) {
    BV_SET(fields, 54);
  }

  differ = (old->is_new_game != real_packet->is_new_game);
  if(differ) {
    different++;
  }
  if (packet->is_new_game) {
    BV_SET(fields, 55);
  }

  differ = (old->killcitizen != real_packet->killcitizen);
  if(differ) {
    different++;
  }
  if (packet->killcitizen) {
    BV_SET(fields, 56);
  }

  differ = (old->killstack != real_packet->killstack);
  if(differ) {
    different++;
  }
  if (packet->killstack) {
    BV_SET(fields, 57);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->min_city_center_output[i] != real_packet->min_city_center_output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 58);
  }

  differ = (strcmp(old->negative_year_label, real_packet->negative_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 59);
  }

  differ = (old->notradesize != real_packet->notradesize);
  if (differ) {
    different++;
    BV_SET(fields, 60);
  }

  differ = (old->nuclear_winter != real_packet->nuclear_winter);
  if(differ) {
    different++;
  }
  if (packet->nuclear_winter) {
    BV_SET(fields, 61);
  }

  differ = (old->nuclearwinter != real_packet->nuclearwinter);
  if (differ) {
    different++;
    BV_SET(fields, 62);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 63);
  }

  differ = (old->phase_mode != real_packet->phase_mode);
  if (differ) {
    different++;
    BV_SET(fields, 64);
  }

  differ = (old->pillage_select != real_packet->pillage_select);
  if(differ) {
    different++;
  }
  if (packet->pillage_select) {
    BV_SET(fields, 65);
  }

  differ = (old->tech_steal_allow_holes != real_packet->tech_steal_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_steal_allow_holes) {
    BV_SET(fields, 66);
  }

  differ = (old->tech_trade_allow_holes != real_packet->tech_trade_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_trade_allow_holes) {
    BV_SET(fields, 67);
  }

  differ = (old->tech_trade_loss_allow_holes != real_packet->tech_trade_loss_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_trade_loss_allow_holes) {
    BV_SET(fields, 68);
  }

  differ = (old->tech_parasite_allow_holes != real_packet->tech_parasite_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_parasite_allow_holes) {
    BV_SET(fields, 69);
  }

  differ = (old->tech_loss_allow_holes != real_packet->tech_loss_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_loss_allow_holes) {
    BV_SET(fields, 70);
  }

  differ = (strcmp(old->positive_year_label, real_packet->positive_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 71);
  }

  differ = (old->rapturedelay != real_packet->rapturedelay);
  if (differ) {
    different++;
    BV_SET(fields, 72);
  }

  differ = (old->disasters != real_packet->disasters);
  if (differ) {
    different++;
    BV_SET(fields, 73);
  }

  differ = (old->restrictinfra != real_packet->restrictinfra);
  if(differ) {
    different++;
  }
  if (packet->restrictinfra) {
    BV_SET(fields, 74);
  }

  differ = (old->unreachable_protects != real_packet->unreachable_protects);
  if(differ) {
    different++;
  }
  if (packet->unreachable_protects) {
    BV_SET(fields, 75);
  }

  differ = (old->sciencebox != real_packet->sciencebox);
  if (differ) {
    different++;
    BV_SET(fields, 76);
  }

  differ = (old->shieldbox != real_packet->shieldbox);
  if (differ) {
    different++;
    BV_SET(fields, 77);
  }

  differ = (old->skill_level != real_packet->skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 78);
  }

  differ = (old->slow_invasions != real_packet->slow_invasions);
  if(differ) {
    different++;
  }
  if (packet->slow_invasions) {
    BV_SET(fields, 79);
  }

  differ = (old->victory_conditions != real_packet->victory_conditions);
  if (differ) {
    different++;
    BV_SET(fields, 80);
  }

  differ = (old->team_pooled_research != real_packet->team_pooled_research);
  if(differ) {
    different++;
  }
  if (packet->team_pooled_research) {
    BV_SET(fields, 81);
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 82);
  }

  differ = (old->tech_cost_style != real_packet->tech_cost_style);
  if (differ) {
    different++;
    BV_SET(fields, 83);
  }

  differ = (old->tech_leakage != real_packet->tech_leakage);
  if (differ) {
    different++;
    BV_SET(fields, 84);
  }

  differ = (old->tech_upkeep_divider != real_packet->tech_upkeep_divider);
  if (differ) {
    different++;
    BV_SET(fields, 85);
  }

  differ = (old->tech_upkeep_style != real_packet->tech_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 86);
  }

  differ = (old->techloss_forgiveness != real_packet->techloss_forgiveness);
  if (differ) {
    different++;
    BV_SET(fields, 87);
  }

  differ = (old->free_tech_method != real_packet->free_tech_method);
  if (differ) {
    different++;
    BV_SET(fields, 88);
  }

  differ = (old->gameloss_style != real_packet->gameloss_style);
  if (differ) {
    different++;
    BV_SET(fields, 89);
  }

  differ = (old->timeout != real_packet->timeout);
  if (differ) {
    different++;
    BV_SET(fields, 90);
  }

  differ = (old->first_timeout != real_packet->first_timeout);
  if (differ) {
    different++;
    BV_SET(fields, 91);
  }

  differ = (old->tired_attack != real_packet->tired_attack);
  if(differ) {
    different++;
  }
  if (packet->tired_attack) {
    BV_SET(fields, 92);
  }

  differ = (old->trademindist != real_packet->trademindist);
  if (differ) {
    different++;
    BV_SET(fields, 93);
  }

  differ = (old->force_trade_route != real_packet->force_trade_route);
  if(differ) {
    different++;
  }
  if (packet->force_trade_route) {
    BV_SET(fields, 94);
  }

  differ = (old->trading_city != real_packet->trading_city);
  if(differ) {
    different++;
  }
  if (packet->trading_city) {
    BV_SET(fields, 95);
  }

  differ = (old->trading_gold != real_packet->trading_gold);
  if(differ) {
    different++;
  }
  if (packet->trading_gold) {
    BV_SET(fields, 96);
  }

  differ = (old->trading_tech != real_packet->trading_tech);
  if(differ) {
    different++;
  }
  if (packet->trading_tech) {
    BV_SET(fields, 97);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 98);
  }

  differ = (old->warminglevel != real_packet->warminglevel);
  if (differ) {
    different++;
    BV_SET(fields, 99);
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 100);
  }

  differ = (old->year_0_hack != real_packet->year_0_hack);
  if(differ) {
    different++;
  }
  if (packet->year_0_hack) {
    BV_SET(fields, 101);
  }

  differ = (old->calendar_fragments != real_packet->calendar_fragments);
  if (differ) {
    different++;
    BV_SET(fields, 102);
  }

  differ = (old->fragment_count != real_packet->fragment_count);
  if (differ) {
    different++;
    BV_SET(fields, 103);
  }


    {
      differ = (MAX_CALENDAR_FRAGMENTS != MAX_CALENDAR_FRAGMENTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
          if (strcmp(old->calendar_fragment_name[i], real_packet->calendar_fragment_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 104);
  }

  differ = (old->civil_war_enabled != real_packet->civil_war_enabled);
  if(differ) {
    different++;
  }
  if (packet->civil_war_enabled) {
    BV_SET(fields, 105);
  }

  differ = (old->paradrop_to_transport != real_packet->paradrop_to_transport);
  if(differ) {
    different++;
  }
  if (packet->paradrop_to_transport) {
    BV_SET(fields, 106);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'add_to_size_limit' has changed");
    DIO_PUT(uint8, &dout, "add_to_size_limit", real_packet->add_to_size_limit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'aifill' has changed");
    DIO_PUT(uint8, &dout, "aifill", real_packet->aifill);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'persistent_ready' has changed");
    DIO_PUT(uint8, &dout, "persistent_ready", real_packet->persistent_ready);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'airlifting_style' has changed");
    DIO_PUT(uint8, &dout, "airlifting_style", real_packet->airlifting_style);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'angrycitizen' has changed");
    DIO_PUT(uint8, &dout, "angrycitizen", real_packet->angrycitizen);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'base_pollution' has changed");
    DIO_PUT(sint16, &dout, "base_pollution", real_packet->base_pollution);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'base_tech_cost' has changed");
    DIO_PUT(uint8, &dout, "base_tech_cost", real_packet->base_tech_cost);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'border_city_radius_sq' has changed");
    DIO_PUT(uint16, &dout, "border_city_radius_sq", real_packet->border_city_radius_sq);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'border_size_effect' has changed");
    DIO_PUT(uint8, &dout, "border_size_effect", real_packet->border_size_effect);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'border_city_permanent_radius_sq' has changed");
    DIO_PUT(sint16, &dout, "border_city_permanent_radius_sq", real_packet->border_city_permanent_radius_sq);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'borders' has changed");
    DIO_PUT(uint8, &dout, "borders", real_packet->borders);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'base_bribe_cost' has changed");
    DIO_PUT(uint32, &dout, "base_bribe_cost", real_packet->base_bribe_cost);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'culture_vic_points' has changed");
    DIO_PUT(uint32, &dout, "culture_vic_points", real_packet->culture_vic_points);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'culture_vic_lead' has changed");
    DIO_PUT(uint16, &dout, "culture_vic_lead", real_packet->culture_vic_lead);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'culture_migration_pml' has changed");
    DIO_PUT(uint16, &dout, "culture_migration_pml", real_packet->culture_migration_pml);
  }
  /* field 15 is folded into the header */
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'celebratesize' has changed");
    DIO_PUT(uint8, &dout, "celebratesize", real_packet->celebratesize);
  }
  /* field 17 is folded into the header */
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'pop_report_zeroes' has changed");
    DIO_PUT(uint8, &dout, "pop_report_zeroes", real_packet->pop_report_zeroes);
  }
  /* field 19 is folded into the header */
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'citizen_convert_speed' has changed");
    DIO_PUT(uint16, &dout, "citizen_convert_speed", real_packet->citizen_convert_speed);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'citizen_partisans_pct' has changed");
    DIO_PUT(uint8, &dout, "citizen_partisans_pct", real_packet->citizen_partisans_pct);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'citymindist' has changed");
    DIO_PUT(uint8, &dout, "citymindist", real_packet->citymindist);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'cooling' has changed");
    DIO_PUT(uint32, &dout, "cooling", real_packet->cooling);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'coolinglevel' has changed");
    DIO_PUT(uint32, &dout, "coolinglevel", real_packet->coolinglevel);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'diplomacy' has changed");
    DIO_PUT(uint8, &dout, "diplomacy", real_packet->diplomacy);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'food_cost' has changed");
    DIO_PUT(uint8, &dout, "food_cost", real_packet->food_cost);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'foodbox' has changed");
    DIO_PUT(uint32, &dout, "foodbox", real_packet->foodbox);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'forced_gold' has changed");
    DIO_PUT(uint8, &dout, "forced_gold", real_packet->forced_gold);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'forced_luxury' has changed");
    DIO_PUT(uint8, &dout, "forced_luxury", real_packet->forced_luxury);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'forced_science' has changed");
    DIO_PUT(uint8, &dout, "forced_science", real_packet->forced_science);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'fulltradesize' has changed");
    DIO_PUT(uint8, &dout, "fulltradesize", real_packet->fulltradesize);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'global_advances' has changed");
  
    {
      int i;

      fc_assert(A_LAST < 255);

      for (i = 0; i < A_LAST; i++) {
        if(old->global_advances[i] != real_packet->global_advances[i]) {
          dio_put_uint8(&dout, i);
          dio_put_bool8(&dout, real_packet->global_advances[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  /* field 34 is folded into the header */
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'globalwarming' has changed");
    DIO_PUT(uint32, &dout, "globalwarming", real_packet->globalwarming);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'gold' has changed");
    DIO_PUT(uint32, &dout, "gold", real_packet->gold);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'gold_upkeep_style' has changed");
    DIO_PUT(uint8, &dout, "gold_upkeep_style", real_packet->gold_upkeep_style);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'revolentype' has changed");
    DIO_PUT(uint8, &dout, "revolentype", real_packet->revolentype);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'default_government_id' has changed");
    DIO_PUT(sint8, &dout, "default_government_id", real_packet->default_government_id);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'government_during_revolution_id' has changed");
    DIO_PUT(sint8, &dout, "government_during_revolution_id", real_packet->government_during_revolution_id);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'granary_food_inc' has changed");
    DIO_PUT(uint8, &dout, "granary_food_inc", real_packet->granary_food_inc);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'granary_food_ini' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        dio_put_uint8(&dout, real_packet->granary_food_ini[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'granary_num_inis' has changed");
    DIO_PUT(uint8, &dout, "granary_num_inis", real_packet->granary_num_inis);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'great_wonder_owners' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
          dio_put_uint8(&dout, i);
          dio_put_uint8(&dout, real_packet->great_wonder_owners[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    DIO_PUT(uint8, &dout, "happy_cost", real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'happyborders' has changed");
    DIO_PUT(uint8, &dout, "happyborders", real_packet->happyborders);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'heating' has changed");
    DIO_PUT(uint32, &dout, "heating", real_packet->heating);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'illness_base_factor' has changed");
    DIO_PUT(uint16, &dout, "illness_base_factor", real_packet->illness_base_factor);
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  field 'illness_min_size' has changed");
    DIO_PUT(uint8, &dout, "illness_min_size", real_packet->illness_min_size);
  }
  /* field 50 is folded into the header */
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  field 'illness_pollution_factor' has changed");
    DIO_PUT(uint16, &dout, "illness_pollution_factor", real_packet->illness_pollution_factor);
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  field 'illness_trade_infection' has changed");
    DIO_PUT(uint16, &dout, "illness_trade_infection", real_packet->illness_trade_infection);
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  field 'init_city_radius_sq' has changed");
    DIO_PUT(uint8, &dout, "init_city_radius_sq", real_packet->init_city_radius_sq);
  }
  /* field 54 is folded into the header */
  /* field 55 is folded into the header */
  /* field 56 is folded into the header */
  /* field 57 is folded into the header */
  if (BV_ISSET(fields, 58)) {
    log_packet_detailed("  field 'min_city_center_output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->min_city_center_output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  field 'negative_year_label' has changed");
    DIO_PUT(string, &dout, "negative_year_label", real_packet->negative_year_label);
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  field 'notradesize' has changed");
    DIO_PUT(uint8, &dout, "notradesize", real_packet->notradesize);
  }
  /* field 61 is folded into the header */
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  field 'nuclearwinter' has changed");
    DIO_PUT(uint32, &dout, "nuclearwinter", real_packet->nuclearwinter);
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  field 'phase' has changed");
    DIO_PUT(sint16, &dout, "phase", real_packet->phase);
  }
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  field 'phase_mode' has changed");
    DIO_PUT(uint8, &dout, "phase_mode", real_packet->phase_mode);
  }
  /* field 65 is folded into the header */
  /* field 66 is folded into the header */
  /* field 67 is folded into the header */
  /* field 68 is folded into the header */
  /* field 69 is folded into the header */
  /* field 70 is folded into the header */
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  field 'positive_year_label' has changed");
    DIO_PUT(string, &dout, "positive_year_label", real_packet->positive_year_label);
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  field 'rapturedelay' has changed");
    DIO_PUT(uint8, &dout, "rapturedelay", real_packet->rapturedelay);
  }
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  field 'disasters' has changed");
    DIO_PUT(uint16, &dout, "disasters", real_packet->disasters);
  }
  /* field 74 is folded into the header */
  /* field 75 is folded into the header */
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  field 'sciencebox' has changed");
    DIO_PUT(uint32, &dout, "sciencebox", real_packet->sciencebox);
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  field 'shieldbox' has changed");
    DIO_PUT(uint32, &dout, "shieldbox", real_packet->shieldbox);
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  field 'skill_level' has changed");
    DIO_PUT(uint32, &dout, "skill_level", real_packet->skill_level);
  }
  /* field 79 is folded into the header */
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  field 'victory_conditions' has changed");
    DIO_PUT(uint8, &dout, "victory_conditions", real_packet->victory_conditions);
  }
  /* field 81 is folded into the header */
  if (BV_ISSET(fields, 82)) {
    log_packet_detailed("  field 'tech' has changed");
    DIO_PUT(uint32, &dout, "tech", real_packet->tech);
  }
  if (BV_ISSET(fields, 83)) {
    log_packet_detailed("  field 'tech_cost_style' has changed");
    DIO_PUT(uint8, &dout, "tech_cost_style", real_packet->tech_cost_style);
  }
  if (BV_ISSET(fields, 84)) {
    log_packet_detailed("  field 'tech_leakage' has changed");
    DIO_PUT(uint8, &dout, "tech_leakage", real_packet->tech_leakage);
  }
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  field 'tech_upkeep_divider' has changed");
    DIO_PUT(uint16, &dout, "tech_upkeep_divider", real_packet->tech_upkeep_divider);
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  field 'tech_upkeep_style' has changed");
    DIO_PUT(uint8, &dout, "tech_upkeep_style", real_packet->tech_upkeep_style);
  }
  if (BV_ISSET(fields, 87)) {
    log_packet_detailed("  field 'techloss_forgiveness' has changed");
    DIO_PUT(sint16, &dout, "techloss_forgiveness", real_packet->techloss_forgiveness);
  }
  if (BV_ISSET(fields, 88)) {
    log_packet_detailed("  field 'free_tech_method' has changed");
    DIO_PUT(uint8, &dout, "free_tech_method", real_packet->free_tech_method);
  }
  if (BV_ISSET(fields, 89)) {
    log_packet_detailed("  field 'gameloss_style' has changed");
    DIO_PUT(uint8, &dout, "gameloss_style", real_packet->gameloss_style);
  }
  if (BV_ISSET(fields, 90)) {
    log_packet_detailed("  field 'timeout' has changed");
    DIO_PUT(uint32, &dout, "timeout", real_packet->timeout);
  }
  if (BV_ISSET(fields, 91)) {
    log_packet_detailed("  field 'first_timeout' has changed");
    DIO_PUT(uint32, &dout, "first_timeout", real_packet->first_timeout);
  }
  /* field 92 is folded into the header */
  if (BV_ISSET(fields, 93)) {
    log_packet_detailed("  field 'trademindist' has changed");
    DIO_PUT(uint16, &dout, "trademindist", real_packet->trademindist);
  }
  /* field 94 is folded into the header */
  /* field 95 is folded into the header */
  /* field 96 is folded into the header */
  /* field 97 is folded into the header */
  if (BV_ISSET(fields, 98)) {
    log_packet_detailed("  field 'turn' has changed");
    DIO_PUT(sint16, &dout, "turn", real_packet->turn);
  }
  if (BV_ISSET(fields, 99)) {
    log_packet_detailed("  field 'warminglevel' has changed");
    DIO_PUT(uint32, &dout, "warminglevel", real_packet->warminglevel);
  }
  if (BV_ISSET(fields, 100)) {
    log_packet_detailed("  field 'year' has changed");
    DIO_PUT(sint16, &dout, "year", real_packet->year);
  }
  /* field 101 is folded into the header */
  if (BV_ISSET(fields, 102)) {
    log_packet_detailed("  field 'calendar_fragments' has changed");
    DIO_PUT(uint16, &dout, "calendar_fragments", real_packet->calendar_fragments);
  }
  if (BV_ISSET(fields, 103)) {
    log_packet_detailed("  field 'fragment_count' has changed");
    DIO_PUT(uint16, &dout, "fragment_count", real_packet->fragment_count);
  }
  if (BV_ISSET(fields, 104)) {
    log_packet_detailed("  field 'calendar_fragment_name' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
        dio_put_string(&dout, real_packet->calendar_fragment_name[i]);
      }
    } 
  }
  /* field 105 is folded into the header */
  /* field 106 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_GAME_INFO);
}

#define hash_packet_game_info_101 hash_const

#define cmp_packet_game_info_101 cmp_const

BV_DEFINE(packet_game_info_101_fields, 106);

static struct packet_game_info *receive_packet_game_info_101(struct connection *pc)
{
  packet_game_info_101_fields fields;
  struct packet_game_info *old;
  struct genhash **hash = pc->phs.received + PACKET_GAME_INFO;
  RECEIVE_PACKET_START(packet_game_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_info_101: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_101, cmp_packet_game_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'add_to_size_limit'");
    if (!DIO_GET(uint8, &din, "add_to_size_limit", &real_packet->add_to_size_limit)) {
      RECEIVE_PACKET_FIELD_ERROR(add_to_size_limit);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'aifill'");
    if (!DIO_GET(uint8, &din, "aifill", &real_packet->aifill)) {
      RECEIVE_PACKET_FIELD_ERROR(aifill);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'persistent_ready'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "persistent_ready", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(persistent_ready);
      }
      real_packet->persistent_ready = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'airlifting_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "airlifting_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(airlifting_style);
      }
      real_packet->airlifting_style = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'angrycitizen'");
    if (!DIO_GET(uint8, &din, "angrycitizen", &real_packet->angrycitizen)) {
      RECEIVE_PACKET_FIELD_ERROR(angrycitizen);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'base_pollution'");
    if (!DIO_GET(sint16, &din, "base_pollution", &real_packet->base_pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(base_pollution);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'base_tech_cost'");
    if (!DIO_GET(uint8, &din, "base_tech_cost", &real_packet->base_tech_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_tech_cost);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'border_city_radius_sq'");
    if (!DIO_GET(uint16, &din, "border_city_radius_sq", &real_packet->border_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'border_size_effect'");
    if (!DIO_GET(uint8, &din, "border_size_effect", &real_packet->border_size_effect)) {
      RECEIVE_PACKET_FIELD_ERROR(border_size_effect);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'border_city_permanent_radius_sq'");
    if (!DIO_GET(sint16, &din, "border_city_permanent_radius_sq", &real_packet->border_city_permanent_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_permanent_radius_sq);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'borders'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "borders", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(borders);
      }
      real_packet->borders = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'base_bribe_cost'");
    if (!DIO_GET(uint32, &din, "base_bribe_cost", &real_packet->base_bribe_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_bribe_cost);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'culture_vic_points'");
    if (!DIO_GET(uint32, &din, "culture_vic_points", &real_packet->culture_vic_points)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_vic_points);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'culture_vic_lead'");
    if (!DIO_GET(uint16, &din, "culture_vic_lead", &real_packet->culture_vic_lead)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_vic_lead);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'culture_migration_pml'");
    if (!DIO_GET(uint16, &din, "culture_migration_pml", &real_packet->culture_migration_pml)) {
      RECEIVE_PACKET_FIELD_ERROR(culture_migration_pml);
    }
  }
  real_packet->calendar_skip_0 = BV_ISSET(fields, 15);
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'celebratesize'");
    if (!DIO_GET(uint8, &din, "celebratesize", &real_packet->celebratesize)) {
      RECEIVE_PACKET_FIELD_ERROR(celebratesize);
    }
  }
  real_packet->changable_tax = BV_ISSET(fields, 17);
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'pop_report_zeroes'");
    if (!DIO_GET(uint8, &din, "pop_report_zeroes", &real_packet->pop_report_zeroes)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_report_zeroes);
    }
  }
  real_packet->citizen_nationality = BV_ISSET(fields, 19);
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'citizen_convert_speed'");
    if (!DIO_GET(uint16, &din, "citizen_convert_speed", &real_packet->citizen_convert_speed)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_convert_speed);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'citizen_partisans_pct'");
    if (!DIO_GET(uint8, &din, "citizen_partisans_pct", &real_packet->citizen_partisans_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_partisans_pct);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'citymindist'");
    if (!DIO_GET(uint8, &din, "citymindist", &real_packet->citymindist)) {
      RECEIVE_PACKET_FIELD_ERROR(citymindist);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'cooling'");
    if (!DIO_GET(uint32, &din, "cooling", &real_packet->cooling)) {
      RECEIVE_PACKET_FIELD_ERROR(cooling);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'coolinglevel'");
    if (!DIO_GET(uint32, &din, "coolinglevel", &real_packet->coolinglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(coolinglevel);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'diplomacy'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "diplomacy", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(diplomacy);
      }
      real_packet->diplomacy = readin;
    }
  }
  real_packet->fogofwar = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'food_cost'");
    if (!DIO_GET(uint8, &din, "food_cost", &real_packet->food_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(food_cost);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'foodbox'");
    if (!DIO_GET(uint32, &din, "foodbox", &real_packet->foodbox)) {
      RECEIVE_PACKET_FIELD_ERROR(foodbox);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'forced_gold'");
    if (!DIO_GET(uint8, &din, "forced_gold", &real_packet->forced_gold)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_gold);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'forced_luxury'");
    if (!DIO_GET(uint8, &din, "forced_luxury", &real_packet->forced_luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_luxury);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'forced_science'");
    if (!DIO_GET(uint8, &din, "forced_science", &real_packet->forced_science)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_science);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'fulltradesize'");
    if (!DIO_GET(uint8, &din, "fulltradesize", &real_packet->fulltradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(fulltradesize);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'global_advances'");
    
    for (;;) {
      int i;
    
      if (!DIO_GET(uint8, &din, "global_advances", &i)) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances);
      }
      if (i == 255) {
        break;
      }
      if (i > A_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances,
                                   ": unexpected value %d "
                                   "(> A_LAST) in array diff",
                                   i);
      } else {
        if (!DIO_GET(bool8, &din, "global_advances", &real_packet->global_advances[i])) {
          RECEIVE_PACKET_FIELD_ERROR(global_advances);
        }
      }
    }
  }
  real_packet->global_warming = BV_ISSET(fields, 34);
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'globalwarming'");
    if (!DIO_GET(uint32, &din, "globalwarming", &real_packet->globalwarming)) {
      RECEIVE_PACKET_FIELD_ERROR(globalwarming);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'gold'");
    if (!DIO_GET(uint32, &din, "gold", &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'gold_upkeep_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "gold_upkeep_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gold_upkeep_style);
      }
      real_packet->gold_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'revolentype'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "revolentype", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(revolentype);
      }
      real_packet->revolentype = readin;
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'default_government_id'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "default_government_id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(default_government_id);
      }
      real_packet->default_government_id = readin;
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'government_during_revolution_id'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "government_during_revolution_id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(government_during_revolution_id);
      }
      real_packet->government_during_revolution_id = readin;
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'granary_food_inc'");
    if (!DIO_GET(uint8, &din, "granary_food_inc", &real_packet->granary_food_inc)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_food_inc);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'granary_food_ini'");
    
    {
      int i;
    
      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        if (!DIO_GET(uint8, &din, "granary_food_ini", &real_packet->granary_food_ini[i])) {
          RECEIVE_PACKET_FIELD_ERROR(granary_food_ini);
        }
      }
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'granary_num_inis'");
    if (!DIO_GET(uint8, &din, "granary_num_inis", &real_packet->granary_num_inis)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_num_inis);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'great_wonder_owners'");
    
    for (;;) {
      int i;
    
      if (!DIO_GET(uint8, &din, "great_wonder_owners", &i)) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
        if (!DIO_GET(uint8, &din, "great_wonder_owners", &real_packet->great_wonder_owners[i])) {
          RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
        }
      }
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'happy_cost'");
    if (!DIO_GET(uint8, &din, "happy_cost", &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'happyborders'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "happyborders", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(happyborders);
      }
      real_packet->happyborders = readin;
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'heating'");
    if (!DIO_GET(uint32, &din, "heating", &real_packet->heating)) {
      RECEIVE_PACKET_FIELD_ERROR(heating);
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'illness_base_factor'");
    if (!DIO_GET(uint16, &din, "illness_base_factor", &real_packet->illness_base_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_base_factor);
    }
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  got field 'illness_min_size'");
    if (!DIO_GET(uint8, &din, "illness_min_size", &real_packet->illness_min_size)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_min_size);
    }
  }
  real_packet->illness_on = BV_ISSET(fields, 50);
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  got field 'illness_pollution_factor'");
    if (!DIO_GET(uint16, &din, "illness_pollution_factor", &real_packet->illness_pollution_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_pollution_factor);
    }
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  got field 'illness_trade_infection'");
    if (!DIO_GET(uint16, &din, "illness_trade_infection", &real_packet->illness_trade_infection)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade_infection);
    }
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  got field 'init_city_radius_sq'");
    if (!DIO_GET(uint8, &din, "init_city_radius_sq", &real_packet->init_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(init_city_radius_sq);
    }
  }
  real_packet->is_edit_mode = BV_ISSET(fields, 54);
  real_packet->is_new_game = BV_ISSET(fields, 55);
  real_packet->killcitizen = BV_ISSET(fields, 56);
  real_packet->killstack = BV_ISSET(fields, 57);
  if (BV_ISSET(fields, 58)) {
    log_packet_detailed("  got field 'min_city_center_output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint8, &din, "min_city_center_output", &real_packet->min_city_center_output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(min_city_center_output);
        }
      }
    }
  }
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  got field 'negative_year_label'");
    if (!DIO_GET(string, &din, "negative_year_label", real_packet->negative_year_label, sizeof(real_packet->negative_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(negative_year_label);
    }
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  got field 'notradesize'");
    if (!DIO_GET(uint8, &din, "notradesize", &real_packet->notradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(notradesize);
    }
  }
  real_packet->nuclear_winter = BV_ISSET(fields, 61);
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  got field 'nuclearwinter'");
    if (!DIO_GET(uint32, &din, "nuclearwinter", &real_packet->nuclearwinter)) {
      RECEIVE_PACKET_FIELD_ERROR(nuclearwinter);
    }
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  got field 'phase'");
    if (!DIO_GET(sint16, &din, "phase", &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  got field 'phase_mode'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "phase_mode", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(phase_mode);
      }
      real_packet->phase_mode = readin;
    }
  }
  real_packet->pillage_select = BV_ISSET(fields, 65);
  real_packet->tech_steal_allow_holes = BV_ISSET(fields, 66);
  real_packet->tech_trade_allow_holes = BV_ISSET(fields, 67);
  real_packet->tech_trade_loss_allow_holes = BV_ISSET(fields, 68);
  real_packet->tech_parasite_allow_holes = BV_ISSET(fields, 69);
  real_packet->tech_loss_allow_holes = BV_ISSET(fields, 70);
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  got field 'positive_year_label'");
    if (!DIO_GET(string, &din, "positive_year_label", real_packet->positive_year_label, sizeof(real_packet->positive_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(positive_year_label);
    }
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  got field 'rapturedelay'");
    if (!DIO_GET(uint8, &din, "rapturedelay", &real_packet->rapturedelay)) {
      RECEIVE_PACKET_FIELD_ERROR(rapturedelay);
    }
  }
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  got field 'disasters'");
    if (!DIO_GET(uint16, &din, "disasters", &real_packet->disasters)) {
      RECEIVE_PACKET_FIELD_ERROR(disasters);
    }
  }
  real_packet->restrictinfra = BV_ISSET(fields, 74);
  real_packet->unreachable_protects = BV_ISSET(fields, 75);
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  got field 'sciencebox'");
    if (!DIO_GET(uint32, &din, "sciencebox", &real_packet->sciencebox)) {
      RECEIVE_PACKET_FIELD_ERROR(sciencebox);
    }
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  got field 'shieldbox'");
    if (!DIO_GET(uint32, &din, "shieldbox", &real_packet->shieldbox)) {
      RECEIVE_PACKET_FIELD_ERROR(shieldbox);
    }
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  got field 'skill_level'");
    if (!DIO_GET(uint32, &din, "skill_level", &real_packet->skill_level)) {
      RECEIVE_PACKET_FIELD_ERROR(skill_level);
    }
  }
  real_packet->slow_invasions = BV_ISSET(fields, 79);
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  got field 'victory_conditions'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "victory_conditions", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(victory_conditions);
      }
      real_packet->victory_conditions = readin;
    }
  }
  real_packet->team_pooled_research = BV_ISSET(fields, 81);
  if (BV_ISSET(fields, 82)) {
    log_packet_detailed("  got field 'tech'");
    if (!DIO_GET(uint32, &din, "tech", &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }
  if (BV_ISSET(fields, 83)) {
    log_packet_detailed("  got field 'tech_cost_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "tech_cost_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_cost_style);
      }
      real_packet->tech_cost_style = readin;
    }
  }
  if (BV_ISSET(fields, 84)) {
    log_packet_detailed("  got field 'tech_leakage'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "tech_leakage", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_leakage);
      }
      real_packet->tech_leakage = readin;
    }
  }
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  got field 'tech_upkeep_divider'");
    if (!DIO_GET(uint16, &din, "tech_upkeep_divider", &real_packet->tech_upkeep_divider)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_divider);
    }
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  got field 'tech_upkeep_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "tech_upkeep_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_style);
      }
      real_packet->tech_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 87)) {
    log_packet_detailed("  got field 'free_tech_method'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "free_tech_method", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(free_tech_method);
      }
      real_packet->free_tech_method = readin;
    }
  }
  if (BV_ISSET(fields, 88)) {
    log_packet_detailed("  got field 'gameloss_style'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "gameloss_style", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gameloss_style);
      }
      real_packet->gameloss_style = readin;
    }
  }
  if (BV_ISSET(fields, 89)) {
    log_packet_detailed("  got field 'timeout'");
    if (!DIO_GET(uint32, &din, "timeout", &real_packet->timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(timeout);
    }
  }
  if (BV_ISSET(fields, 90)) {
    log_packet_detailed("  got field 'first_timeout'");
    if (!DIO_GET(uint32, &din, "first_timeout", &real_packet->first_timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(first_timeout);
    }
  }
  real_packet->tired_attack = BV_ISSET(fields, 91);
  if (BV_ISSET(fields, 92)) {
    log_packet_detailed("  got field 'trademindist'");
    if (!DIO_GET(uint16, &din, "trademindist", &real_packet->trademindist)) {
      RECEIVE_PACKET_FIELD_ERROR(trademindist);
    }
  }
  real_packet->force_trade_route = BV_ISSET(fields, 93);
  real_packet->trading_city = BV_ISSET(fields, 94);
  real_packet->trading_gold = BV_ISSET(fields, 95);
  real_packet->trading_tech = BV_ISSET(fields, 96);
  if (BV_ISSET(fields, 97)) {
    log_packet_detailed("  got field 'turn'");
    if (!DIO_GET(sint16, &din, "turn", &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 98)) {
    log_packet_detailed("  got field 'warminglevel'");
    if (!DIO_GET(uint32, &din, "warminglevel", &real_packet->warminglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(warminglevel);
    }
  }
  if (BV_ISSET(fields, 99)) {
    log_packet_detailed("  got field 'year'");
    if (!DIO_GET(sint16, &din, "year", &real_packet->year)) {
      RECEIVE_PACKET_FIELD_ERROR(year);
    }
  }
  real_packet->year_0_hack = BV_ISSET(fields, 100);
  if (BV_ISSET(fields, 101)) {
    log_packet_detailed("  got field 'calendar_fragments'");
    if (!DIO_GET(uint16, &din, "calendar_fragments", &real_packet->calendar_fragments)) {
      RECEIVE_PACKET_FIELD_ERROR(calendar_fragments);
    }
  }
  if (BV_ISSET(fields, 102)) {
    log_packet_detailed("  got field 'fragment_count'");
    if (!DIO_GET(uint16, &din, "fragment_count", &real_packet->fragment_count)) {
      RECEIVE_PACKET_FIELD_ERROR(fragment_count);
    }
  }
  if (BV_ISSET(fields, 103)) {
    log_packet_detailed("  got field 'calendar_fragment_name'");
    
    {
      int i;
    
      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
        if (!DIO_GET(string, &din, "calendar_fragment_name", real_packet->calendar_fragment_name[i], sizeof(real_packet->calendar_fragment_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(calendar_fragment_name);
        }
      }
    }
  }
  real_packet->civil_war_enabled = BV_ISSET(fields, 104);
  real_packet->paradrop_to_transport = BV_ISSET(fields, 105);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_info_101(struct connection *pc, const struct packet_game_info *packet)
{
  const struct packet_game_info *real_packet = packet;
  packet_game_info_101_fields fields;
  struct packet_game_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_INFO);

  log_packet_detailed("packet_game_info_101: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_101, cmp_packet_game_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->add_to_size_limit != real_packet->add_to_size_limit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->aifill != real_packet->aifill);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->persistent_ready != real_packet->persistent_ready);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->airlifting_style != real_packet->airlifting_style);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->angrycitizen != real_packet->angrycitizen);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->base_pollution != real_packet->base_pollution);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->base_tech_cost != real_packet->base_tech_cost);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->border_city_radius_sq != real_packet->border_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->border_size_effect != real_packet->border_size_effect);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->border_city_permanent_radius_sq != real_packet->border_city_permanent_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->borders != real_packet->borders);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->base_bribe_cost != real_packet->base_bribe_cost);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->culture_vic_points != real_packet->culture_vic_points);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->culture_vic_lead != real_packet->culture_vic_lead);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->culture_migration_pml != real_packet->culture_migration_pml);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->calendar_skip_0 != real_packet->calendar_skip_0);
  if(differ) {
    different++;
  }
  if (packet->calendar_skip_0) {
    BV_SET(fields, 15);
  }

  differ = (old->celebratesize != real_packet->celebratesize);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->changable_tax != real_packet->changable_tax);
  if(differ) {
    different++;
  }
  if (packet->changable_tax) {
    BV_SET(fields, 17);
  }

  differ = (old->pop_report_zeroes != real_packet->pop_report_zeroes);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->citizen_nationality != real_packet->citizen_nationality);
  if(differ) {
    different++;
  }
  if (packet->citizen_nationality) {
    BV_SET(fields, 19);
  }

  differ = (old->citizen_convert_speed != real_packet->citizen_convert_speed);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->citizen_partisans_pct != real_packet->citizen_partisans_pct);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->citymindist != real_packet->citymindist);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->cooling != real_packet->cooling);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->coolinglevel != real_packet->coolinglevel);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->diplomacy != real_packet->diplomacy);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->fogofwar != real_packet->fogofwar);
  if(differ) {
    different++;
  }
  if (packet->fogofwar) {
    BV_SET(fields, 26);
  }

  differ = (old->food_cost != real_packet->food_cost);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->foodbox != real_packet->foodbox);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->forced_gold != real_packet->forced_gold);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->forced_luxury != real_packet->forced_luxury);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->forced_science != real_packet->forced_science);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->fulltradesize != real_packet->fulltradesize);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (A_LAST != A_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < A_LAST; i++) {
          if (old->global_advances[i] != real_packet->global_advances[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->global_warming != real_packet->global_warming);
  if(differ) {
    different++;
  }
  if (packet->global_warming) {
    BV_SET(fields, 34);
  }

  differ = (old->globalwarming != real_packet->globalwarming);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->gold_upkeep_style != real_packet->gold_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->revolentype != real_packet->revolentype);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->default_government_id != real_packet->default_government_id);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = (old->government_during_revolution_id != real_packet->government_during_revolution_id);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (old->granary_food_inc != real_packet->granary_food_inc);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }


    {
      differ = (MAX_GRANARY_INIS != MAX_GRANARY_INIS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_GRANARY_INIS; i++) {
          if (old->granary_food_ini[i] != real_packet->granary_food_ini[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->granary_num_inis != real_packet->granary_num_inis);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = (old->happyborders != real_packet->happyborders);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (old->heating != real_packet->heating);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = (old->illness_base_factor != real_packet->illness_base_factor);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }

  differ = (old->illness_min_size != real_packet->illness_min_size);
  if (differ) {
    different++;
    BV_SET(fields, 49);
  }

  differ = (old->illness_on != real_packet->illness_on);
  if(differ) {
    different++;
  }
  if (packet->illness_on) {
    BV_SET(fields, 50);
  }

  differ = (old->illness_pollution_factor != real_packet->illness_pollution_factor);
  if (differ) {
    different++;
    BV_SET(fields, 51);
  }

  differ = (old->illness_trade_infection != real_packet->illness_trade_infection);
  if (differ) {
    different++;
    BV_SET(fields, 52);
  }

  differ = (old->init_city_radius_sq != real_packet->init_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 53);
  }

  differ = (old->is_edit_mode != real_packet->is_edit_mode);
  if(differ) {
    different++;
  }
  if (packet->is_edit_mode) {
    BV_SET(fields, 54);
  }

  differ = (old->is_new_game != real_packet->is_new_game);
  if(differ) {
    different++;
  }
  if (packet->is_new_game) {
    BV_SET(fields, 55);
  }

  differ = (old->killcitizen != real_packet->killcitizen);
  if(differ) {
    different++;
  }
  if (packet->killcitizen) {
    BV_SET(fields, 56);
  }

  differ = (old->killstack != real_packet->killstack);
  if(differ) {
    different++;
  }
  if (packet->killstack) {
    BV_SET(fields, 57);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->min_city_center_output[i] != real_packet->min_city_center_output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 58);
  }

  differ = (strcmp(old->negative_year_label, real_packet->negative_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 59);
  }

  differ = (old->notradesize != real_packet->notradesize);
  if (differ) {
    different++;
    BV_SET(fields, 60);
  }

  differ = (old->nuclear_winter != real_packet->nuclear_winter);
  if(differ) {
    different++;
  }
  if (packet->nuclear_winter) {
    BV_SET(fields, 61);
  }

  differ = (old->nuclearwinter != real_packet->nuclearwinter);
  if (differ) {
    different++;
    BV_SET(fields, 62);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 63);
  }

  differ = (old->phase_mode != real_packet->phase_mode);
  if (differ) {
    different++;
    BV_SET(fields, 64);
  }

  differ = (old->pillage_select != real_packet->pillage_select);
  if(differ) {
    different++;
  }
  if (packet->pillage_select) {
    BV_SET(fields, 65);
  }

  differ = (old->tech_steal_allow_holes != real_packet->tech_steal_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_steal_allow_holes) {
    BV_SET(fields, 66);
  }

  differ = (old->tech_trade_allow_holes != real_packet->tech_trade_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_trade_allow_holes) {
    BV_SET(fields, 67);
  }

  differ = (old->tech_trade_loss_allow_holes != real_packet->tech_trade_loss_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_trade_loss_allow_holes) {
    BV_SET(fields, 68);
  }

  differ = (old->tech_parasite_allow_holes != real_packet->tech_parasite_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_parasite_allow_holes) {
    BV_SET(fields, 69);
  }

  differ = (old->tech_loss_allow_holes != real_packet->tech_loss_allow_holes);
  if(differ) {
    different++;
  }
  if (packet->tech_loss_allow_holes) {
    BV_SET(fields, 70);
  }

  differ = (strcmp(old->positive_year_label, real_packet->positive_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 71);
  }

  differ = (old->rapturedelay != real_packet->rapturedelay);
  if (differ) {
    different++;
    BV_SET(fields, 72);
  }

  differ = (old->disasters != real_packet->disasters);
  if (differ) {
    different++;
    BV_SET(fields, 73);
  }

  differ = (old->restrictinfra != real_packet->restrictinfra);
  if(differ) {
    different++;
  }
  if (packet->restrictinfra) {
    BV_SET(fields, 74);
  }

  differ = (old->unreachable_protects != real_packet->unreachable_protects);
  if(differ) {
    different++;
  }
  if (packet->unreachable_protects) {
    BV_SET(fields, 75);
  }

  differ = (old->sciencebox != real_packet->sciencebox);
  if (differ) {
    different++;
    BV_SET(fields, 76);
  }

  differ = (old->shieldbox != real_packet->shieldbox);
  if (differ) {
    different++;
    BV_SET(fields, 77);
  }

  differ = (old->skill_level != real_packet->skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 78);
  }

  differ = (old->slow_invasions != real_packet->slow_invasions);
  if(differ) {
    different++;
  }
  if (packet->slow_invasions) {
    BV_SET(fields, 79);
  }

  differ = (old->victory_conditions != real_packet->victory_conditions);
  if (differ) {
    different++;
    BV_SET(fields, 80);
  }

  differ = (old->team_pooled_research != real_packet->team_pooled_research);
  if(differ) {
    different++;
  }
  if (packet->team_pooled_research) {
    BV_SET(fields, 81);
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 82);
  }

  differ = (old->tech_cost_style != real_packet->tech_cost_style);
  if (differ) {
    different++;
    BV_SET(fields, 83);
  }

  differ = (old->tech_leakage != real_packet->tech_leakage);
  if (differ) {
    different++;
    BV_SET(fields, 84);
  }

  differ = (old->tech_upkeep_divider != real_packet->tech_upkeep_divider);
  if (differ) {
    different++;
    BV_SET(fields, 85);
  }

  differ = (old->tech_upkeep_style != real_packet->tech_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 86);
  }

  differ = (old->free_tech_method != real_packet->free_tech_method);
  if (differ) {
    different++;
    BV_SET(fields, 87);
  }

  differ = (old->gameloss_style != real_packet->gameloss_style);
  if (differ) {
    different++;
    BV_SET(fields, 88);
  }

  differ = (old->timeout != real_packet->timeout);
  if (differ) {
    different++;
    BV_SET(fields, 89);
  }

  differ = (old->first_timeout != real_packet->first_timeout);
  if (differ) {
    different++;
    BV_SET(fields, 90);
  }

  differ = (old->tired_attack != real_packet->tired_attack);
  if(differ) {
    different++;
  }
  if (packet->tired_attack) {
    BV_SET(fields, 91);
  }

  differ = (old->trademindist != real_packet->trademindist);
  if (differ) {
    different++;
    BV_SET(fields, 92);
  }

  differ = (old->force_trade_route != real_packet->force_trade_route);
  if(differ) {
    different++;
  }
  if (packet->force_trade_route) {
    BV_SET(fields, 93);
  }

  differ = (old->trading_city != real_packet->trading_city);
  if(differ) {
    different++;
  }
  if (packet->trading_city) {
    BV_SET(fields, 94);
  }

  differ = (old->trading_gold != real_packet->trading_gold);
  if(differ) {
    different++;
  }
  if (packet->trading_gold) {
    BV_SET(fields, 95);
  }

  differ = (old->trading_tech != real_packet->trading_tech);
  if(differ) {
    different++;
  }
  if (packet->trading_tech) {
    BV_SET(fields, 96);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 97);
  }

  differ = (old->warminglevel != real_packet->warminglevel);
  if (differ) {
    different++;
    BV_SET(fields, 98);
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 99);
  }

  differ = (old->year_0_hack != real_packet->year_0_hack);
  if(differ) {
    different++;
  }
  if (packet->year_0_hack) {
    BV_SET(fields, 100);
  }

  differ = (old->calendar_fragments != real_packet->calendar_fragments);
  if (differ) {
    different++;
    BV_SET(fields, 101);
  }

  differ = (old->fragment_count != real_packet->fragment_count);
  if (differ) {
    different++;
    BV_SET(fields, 102);
  }


    {
      differ = (MAX_CALENDAR_FRAGMENTS != MAX_CALENDAR_FRAGMENTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
          if (strcmp(old->calendar_fragment_name[i], real_packet->calendar_fragment_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 103);
  }

  differ = (old->civil_war_enabled != real_packet->civil_war_enabled);
  if(differ) {
    different++;
  }
  if (packet->civil_war_enabled) {
    BV_SET(fields, 104);
  }

  differ = (old->paradrop_to_transport != real_packet->paradrop_to_transport);
  if(differ) {
    different++;
  }
  if (packet->paradrop_to_transport) {
    BV_SET(fields, 105);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'add_to_size_limit' has changed");
    DIO_PUT(uint8, &dout, "add_to_size_limit", real_packet->add_to_size_limit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'aifill' has changed");
    DIO_PUT(uint8, &dout, "aifill", real_packet->aifill);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'persistent_ready' has changed");
    DIO_PUT(uint8, &dout, "persistent_ready", real_packet->persistent_ready);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'airlifting_style' has changed");
    DIO_PUT(uint8, &dout, "airlifting_style", real_packet->airlifting_style);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'angrycitizen' has changed");
    DIO_PUT(uint8, &dout, "angrycitizen", real_packet->angrycitizen);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'base_pollution' has changed");
    DIO_PUT(sint16, &dout, "base_pollution", real_packet->base_pollution);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'base_tech_cost' has changed");
    DIO_PUT(uint8, &dout, "base_tech_cost", real_packet->base_tech_cost);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'border_city_radius_sq' has changed");
    DIO_PUT(uint16, &dout, "border_city_radius_sq", real_packet->border_city_radius_sq);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'border_size_effect' has changed");
    DIO_PUT(uint8, &dout, "border_size_effect", real_packet->border_size_effect);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'border_city_permanent_radius_sq' has changed");
    DIO_PUT(sint16, &dout, "border_city_permanent_radius_sq", real_packet->border_city_permanent_radius_sq);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'borders' has changed");
    DIO_PUT(uint8, &dout, "borders", real_packet->borders);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'base_bribe_cost' has changed");
    DIO_PUT(uint32, &dout, "base_bribe_cost", real_packet->base_bribe_cost);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'culture_vic_points' has changed");
    DIO_PUT(uint32, &dout, "culture_vic_points", real_packet->culture_vic_points);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'culture_vic_lead' has changed");
    DIO_PUT(uint16, &dout, "culture_vic_lead", real_packet->culture_vic_lead);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'culture_migration_pml' has changed");
    DIO_PUT(uint16, &dout, "culture_migration_pml", real_packet->culture_migration_pml);
  }
  /* field 15 is folded into the header */
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'celebratesize' has changed");
    DIO_PUT(uint8, &dout, "celebratesize", real_packet->celebratesize);
  }
  /* field 17 is folded into the header */
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'pop_report_zeroes' has changed");
    DIO_PUT(uint8, &dout, "pop_report_zeroes", real_packet->pop_report_zeroes);
  }
  /* field 19 is folded into the header */
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'citizen_convert_speed' has changed");
    DIO_PUT(uint16, &dout, "citizen_convert_speed", real_packet->citizen_convert_speed);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'citizen_partisans_pct' has changed");
    DIO_PUT(uint8, &dout, "citizen_partisans_pct", real_packet->citizen_partisans_pct);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'citymindist' has changed");
    DIO_PUT(uint8, &dout, "citymindist", real_packet->citymindist);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'cooling' has changed");
    DIO_PUT(uint32, &dout, "cooling", real_packet->cooling);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'coolinglevel' has changed");
    DIO_PUT(uint32, &dout, "coolinglevel", real_packet->coolinglevel);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'diplomacy' has changed");
    DIO_PUT(uint8, &dout, "diplomacy", real_packet->diplomacy);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'food_cost' has changed");
    DIO_PUT(uint8, &dout, "food_cost", real_packet->food_cost);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'foodbox' has changed");
    DIO_PUT(uint32, &dout, "foodbox", real_packet->foodbox);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'forced_gold' has changed");
    DIO_PUT(uint8, &dout, "forced_gold", real_packet->forced_gold);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'forced_luxury' has changed");
    DIO_PUT(uint8, &dout, "forced_luxury", real_packet->forced_luxury);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'forced_science' has changed");
    DIO_PUT(uint8, &dout, "forced_science", real_packet->forced_science);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'fulltradesize' has changed");
    DIO_PUT(uint8, &dout, "fulltradesize", real_packet->fulltradesize);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'global_advances' has changed");
  
    {
      int i;

      fc_assert(A_LAST < 255);

      for (i = 0; i < A_LAST; i++) {
        if(old->global_advances[i] != real_packet->global_advances[i]) {
          dio_put_uint8(&dout, i);
          dio_put_bool8(&dout, real_packet->global_advances[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  /* field 34 is folded into the header */
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'globalwarming' has changed");
    DIO_PUT(uint32, &dout, "globalwarming", real_packet->globalwarming);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'gold' has changed");
    DIO_PUT(uint32, &dout, "gold", real_packet->gold);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'gold_upkeep_style' has changed");
    DIO_PUT(uint8, &dout, "gold_upkeep_style", real_packet->gold_upkeep_style);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'revolentype' has changed");
    DIO_PUT(uint8, &dout, "revolentype", real_packet->revolentype);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'default_government_id' has changed");
    DIO_PUT(sint8, &dout, "default_government_id", real_packet->default_government_id);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'government_during_revolution_id' has changed");
    DIO_PUT(sint8, &dout, "government_during_revolution_id", real_packet->government_during_revolution_id);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'granary_food_inc' has changed");
    DIO_PUT(uint8, &dout, "granary_food_inc", real_packet->granary_food_inc);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'granary_food_ini' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        dio_put_uint8(&dout, real_packet->granary_food_ini[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'granary_num_inis' has changed");
    DIO_PUT(uint8, &dout, "granary_num_inis", real_packet->granary_num_inis);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'great_wonder_owners' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
          dio_put_uint8(&dout, i);
          dio_put_uint8(&dout, real_packet->great_wonder_owners[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    DIO_PUT(uint8, &dout, "happy_cost", real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'happyborders' has changed");
    DIO_PUT(uint8, &dout, "happyborders", real_packet->happyborders);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'heating' has changed");
    DIO_PUT(uint32, &dout, "heating", real_packet->heating);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'illness_base_factor' has changed");
    DIO_PUT(uint16, &dout, "illness_base_factor", real_packet->illness_base_factor);
  }
  if (BV_ISSET(fields, 49)) {
    log_packet_detailed("  field 'illness_min_size' has changed");
    DIO_PUT(uint8, &dout, "illness_min_size", real_packet->illness_min_size);
  }
  /* field 50 is folded into the header */
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  field 'illness_pollution_factor' has changed");
    DIO_PUT(uint16, &dout, "illness_pollution_factor", real_packet->illness_pollution_factor);
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  field 'illness_trade_infection' has changed");
    DIO_PUT(uint16, &dout, "illness_trade_infection", real_packet->illness_trade_infection);
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  field 'init_city_radius_sq' has changed");
    DIO_PUT(uint8, &dout, "init_city_radius_sq", real_packet->init_city_radius_sq);
  }
  /* field 54 is folded into the header */
  /* field 55 is folded into the header */
  /* field 56 is folded into the header */
  /* field 57 is folded into the header */
  if (BV_ISSET(fields, 58)) {
    log_packet_detailed("  field 'min_city_center_output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->min_city_center_output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  field 'negative_year_label' has changed");
    DIO_PUT(string, &dout, "negative_year_label", real_packet->negative_year_label);
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  field 'notradesize' has changed");
    DIO_PUT(uint8, &dout, "notradesize", real_packet->notradesize);
  }
  /* field 61 is folded into the header */
  if (BV_ISSET(fields, 62)) {
    log_packet_detailed("  field 'nuclearwinter' has changed");
    DIO_PUT(uint32, &dout, "nuclearwinter", real_packet->nuclearwinter);
  }
  if (BV_ISSET(fields, 63)) {
    log_packet_detailed("  field 'phase' has changed");
    DIO_PUT(sint16, &dout, "phase", real_packet->phase);
  }
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  field 'phase_mode' has changed");
    DIO_PUT(uint8, &dout, "phase_mode", real_packet->phase_mode);
  }
  /* field 65 is folded into the header */
  /* field 66 is folded into the header */
  /* field 67 is folded into the header */
  /* field 68 is folded into the header */
  /* field 69 is folded into the header */
  /* field 70 is folded into the header */
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  field 'positive_year_label' has changed");
    DIO_PUT(string, &dout, "positive_year_label", real_packet->positive_year_label);
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  field 'rapturedelay' has changed");
    DIO_PUT(uint8, &dout, "rapturedelay", real_packet->rapturedelay);
  }
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  field 'disasters' has changed");
    DIO_PUT(uint16, &dout, "disasters", real_packet->disasters);
  }
  /* field 74 is folded into the header */
  /* field 75 is folded into the header */
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  field 'sciencebox' has changed");
    DIO_PUT(uint32, &dout, "sciencebox", real_packet->sciencebox);
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  field 'shieldbox' has changed");
    DIO_PUT(uint32, &dout, "shieldbox", real_packet->shieldbox);
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  field 'skill_level' has changed");
    DIO_PUT(uint32, &dout, "skill_level", real_packet->skill_level);
  }
  /* field 79 is folded into the header */
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  field 'victory_conditions' has changed");
    DIO_PUT(uint8, &dout, "victory_conditions", real_packet->victory_conditions);
  }
  /* field 81 is folded into the header */
  if (BV_ISSET(fields, 82)) {
    log_packet_detailed("  field 'tech' has changed");
    DIO_PUT(uint32, &dout, "tech", real_packet->tech);
  }
  if (BV_ISSET(fields, 83)) {
    log_packet_detailed("  field 'tech_cost_style' has changed");
    DIO_PUT(uint8, &dout, "tech_cost_style", real_packet->tech_cost_style);
  }
  if (BV_ISSET(fields, 84)) {
    log_packet_detailed("  field 'tech_leakage' has changed");
    DIO_PUT(uint8, &dout, "tech_leakage", real_packet->tech_leakage);
  }
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  field 'tech_upkeep_divider' has changed");
    DIO_PUT(uint16, &dout, "tech_upkeep_divider", real_packet->tech_upkeep_divider);
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  field 'tech_upkeep_style' has changed");
    DIO_PUT(uint8, &dout, "tech_upkeep_style", real_packet->tech_upkeep_style);
  }
  if (BV_ISSET(fields, 87)) {
    log_packet_detailed("  field 'free_tech_method' has changed");
    DIO_PUT(uint8, &dout, "free_tech_method", real_packet->free_tech_method);
  }
  if (BV_ISSET(fields, 88)) {
    log_packet_detailed("  field 'gameloss_style' has changed");
    DIO_PUT(uint8, &dout, "gameloss_style", real_packet->gameloss_style);
  }
  if (BV_ISSET(fields, 89)) {
    log_packet_detailed("  field 'timeout' has changed");
    DIO_PUT(uint32, &dout, "timeout", real_packet->timeout);
  }
  if (BV_ISSET(fields, 90)) {
    log_packet_detailed("  field 'first_timeout' has changed");
    DIO_PUT(uint32, &dout, "first_timeout", real_packet->first_timeout);
  }
  /* field 91 is folded into the header */
  if (BV_ISSET(fields, 92)) {
    log_packet_detailed("  field 'trademindist' has changed");
    DIO_PUT(uint16, &dout, "trademindist", real_packet->trademindist);
  }
  /* field 93 is folded into the header */
  /* field 94 is folded into the header */
  /* field 95 is folded into the header */
  /* field 96 is folded into the header */
  if (BV_ISSET(fields, 97)) {
    log_packet_detailed("  field 'turn' has changed");
    DIO_PUT(sint16, &dout, "turn", real_packet->turn);
  }
  if (BV_ISSET(fields, 98)) {
    log_packet_detailed("  field 'warminglevel' has changed");
    DIO_PUT(uint32, &dout, "warminglevel", real_packet->warminglevel);
  }
  if (BV_ISSET(fields, 99)) {
    log_packet_detailed("  field 'year' has changed");
    DIO_PUT(sint16, &dout, "year", real_packet->year);
  }
  /* field 100 is folded into the header */
  if (BV_ISSET(fields, 101)) {
    log_packet_detailed("  field 'calendar_fragments' has changed");
    DIO_PUT(uint16, &dout, "calendar_fragments", real_packet->calendar_fragments);
  }
  if (BV_ISSET(fields, 102)) {
    log_packet_detailed("  field 'fragment_count' has changed");
    DIO_PUT(uint16, &dout, "fragment_count", real_packet->fragment_count);
  }
  if (BV_ISSET(fields, 103)) {
    log_packet_detailed("  field 'calendar_fragment_name' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_CALENDAR_FRAGMENTS; i++) {
        dio_put_string(&dout, real_packet->calendar_fragment_name[i]);
      }
    } 
  }
  /* field 104 is folded into the header */
  /* field 105 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_GAME_INFO);
}

int send_packet_game_info(struct connection *pc, const struct packet_game_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_GAME_INFO].packet != NULL, -1,
                        "Handler for PACKET_GAME_INFO not installed");
  return pc->phs.handlers->send[PACKET_GAME_INFO].packet(pc, packet);
}

#define hash_packet_timeout_info_100 hash_const

#define cmp_packet_timeout_info_100 cmp_const

BV_DEFINE(packet_timeout_info_100_fields, 2);

static struct packet_timeout_info *receive_packet_timeout_info_100(struct connection *pc)
{
  packet_timeout_info_100_fields fields;
  struct packet_timeout_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TIMEOUT_INFO;
  RECEIVE_PACKET_START(packet_timeout_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_timeout_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_timeout_info_100, cmp_packet_timeout_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'seconds_to_phasedone'");
    if (!DIO_GET(sfloat, &din, "seconds_to_phasedone", &real_packet->seconds_to_phasedone, 100)) {
      RECEIVE_PACKET_FIELD_ERROR(seconds_to_phasedone);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'last_turn_change_time'");
    if (!DIO_GET(sfloat, &din, "last_turn_change_time", &real_packet->last_turn_change_time, 100)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turn_change_time);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_timeout_info_100(struct connection *pc, const struct packet_timeout_info *packet)
{
  const struct packet_timeout_info *real_packet = packet;
  packet_timeout_info_100_fields fields;
  struct packet_timeout_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TIMEOUT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TIMEOUT_INFO);

  log_packet_detailed("packet_timeout_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_timeout_info_100, cmp_packet_timeout_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->seconds_to_phasedone != real_packet->seconds_to_phasedone);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->last_turn_change_time != real_packet->last_turn_change_time);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'seconds_to_phasedone' has changed");
    DIO_PUT(sfloat, &dout, "seconds_to_phasedone", real_packet->seconds_to_phasedone, 100);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'last_turn_change_time' has changed");
    DIO_PUT(sfloat, &dout, "last_turn_change_time", real_packet->last_turn_change_time, 100);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_TIMEOUT_INFO);
}

int send_packet_timeout_info(struct connection *pc, const struct packet_timeout_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TIMEOUT_INFO].packet != NULL, -1,
                        "Handler for PACKET_TIMEOUT_INFO not installed");
  return pc->phs.handlers->send[PACKET_TIMEOUT_INFO].packet(pc, packet);
}

#define hash_packet_map_info_100 hash_const

#define cmp_packet_map_info_100 cmp_const

BV_DEFINE(packet_map_info_100_fields, 3);

static struct packet_map_info *receive_packet_map_info_100(struct connection *pc)
{
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  struct genhash **hash = pc->phs.received + PACKET_MAP_INFO;
  RECEIVE_PACKET_START(packet_map_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_map_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'xsize'");
    if (!DIO_GET(uint16, &din, "xsize", &real_packet->xsize)) {
      RECEIVE_PACKET_FIELD_ERROR(xsize);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'ysize'");
    if (!DIO_GET(uint16, &din, "ysize", &real_packet->ysize)) {
      RECEIVE_PACKET_FIELD_ERROR(ysize);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'topology_id'");
    if (!DIO_GET(uint8, &din, "topology_id", &real_packet->topology_id)) {
      RECEIVE_PACKET_FIELD_ERROR(topology_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_map_info_100(struct connection *pc, const struct packet_map_info *packet)
{
  const struct packet_map_info *real_packet = packet;
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_MAP_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_MAP_INFO);

  log_packet_detailed("packet_map_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->xsize != real_packet->xsize);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->ysize != real_packet->ysize);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->topology_id != real_packet->topology_id);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'xsize' has changed");
    DIO_PUT(uint16, &dout, "xsize", real_packet->xsize);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'ysize' has changed");
    DIO_PUT(uint16, &dout, "ysize", real_packet->ysize);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'topology_id' has changed");
    DIO_PUT(uint8, &dout, "topology_id", real_packet->topology_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_MAP_INFO);
}

int send_packet_map_info(struct connection *pc, const struct packet_map_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_MAP_INFO].packet != NULL, -1,
                        "Handler for PACKET_MAP_INFO not installed");
  return pc->phs.handlers->send[PACKET_MAP_INFO].packet(pc, packet);
}

void lsend_packet_map_info(struct conn_list *dest, const struct packet_map_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_map_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_nuke_tile_info_100 hash_const

#define cmp_packet_nuke_tile_info_100 cmp_const

BV_DEFINE(packet_nuke_tile_info_100_fields, 1);

static struct packet_nuke_tile_info *receive_packet_nuke_tile_info_100(struct connection *pc)
{
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_NUKE_TILE_INFO;
  RECEIVE_PACKET_START(packet_nuke_tile_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nuke_tile_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nuke_tile_info_100(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  const struct packet_nuke_tile_info *real_packet = packet;
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NUKE_TILE_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_NUKE_TILE_INFO);

  log_packet_detailed("packet_nuke_tile_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NUKE_TILE_INFO);
}

int send_packet_nuke_tile_info(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_NUKE_TILE_INFO].packet != NULL, -1,
                        "Handler for PACKET_NUKE_TILE_INFO not installed");
  return pc->phs.handlers->send[PACKET_NUKE_TILE_INFO].packet(pc, packet);
}

void lsend_packet_nuke_tile_info(struct conn_list *dest, const struct packet_nuke_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_nuke_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_nuke_tile_info(struct connection *pc, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  return send_packet_nuke_tile_info(pc, real_packet);
}

void dlsend_packet_nuke_tile_info(struct conn_list *dest, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  lsend_packet_nuke_tile_info(dest, real_packet);
}

static genhash_val_t hash_packet_team_name_info_100(const void *vkey)
{
  const struct packet_team_name_info *key = (const struct packet_team_name_info *) vkey;

  return key->team_id;
}

static bool cmp_packet_team_name_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_team_name_info *key1 = (const struct packet_team_name_info *) vkey1;
  const struct packet_team_name_info *key2 = (const struct packet_team_name_info *) vkey2;

  return key1->team_id == key2->team_id;
}

BV_DEFINE(packet_team_name_info_100_fields, 1);

static struct packet_team_name_info *receive_packet_team_name_info_100(struct connection *pc)
{
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TEAM_NAME_INFO;
  RECEIVE_PACKET_START(packet_team_name_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint8, &din, "team_id", &real_packet->team_id)) {
    RECEIVE_PACKET_FIELD_ERROR(team_id);
  }

  log_packet_detailed("packet_team_name_info_100: got info about (%d)",
    real_packet->team_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int team_id = real_packet->team_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->team_id = team_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'team_name'");
    if (!DIO_GET(string, &din, "team_name", real_packet->team_name, sizeof(real_packet->team_name))) {
      RECEIVE_PACKET_FIELD_ERROR(team_name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_team_name_info_100(struct connection *pc, const struct packet_team_name_info *packet)
{
  const struct packet_team_name_info *real_packet = packet;
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TEAM_NAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TEAM_NAME_INFO);

  log_packet_detailed("packet_team_name_info_100: sending info about (%d)",
    real_packet->team_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->team_name, real_packet->team_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint8, &dout, "team_id", real_packet->team_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'team_name' has changed");
    DIO_PUT(string, &dout, "team_name", real_packet->team_name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_TEAM_NAME_INFO);
}

int send_packet_team_name_info(struct connection *pc, const struct packet_team_name_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_TEAM_NAME_INFO].packet != NULL, -1,
                        "Handler for PACKET_TEAM_NAME_INFO not installed");
  return pc->phs.handlers->send[PACKET_TEAM_NAME_INFO].packet(pc, packet);
}

void lsend_packet_team_name_info(struct conn_list *dest, const struct packet_team_name_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_team_name_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_achievement_info_100 hash_const

#define cmp_packet_achievement_info_100 cmp_const

BV_DEFINE(packet_achievement_info_100_fields, 3);

static struct packet_achievement_info *receive_packet_achievement_info_100(struct connection *pc)
{
  packet_achievement_info_100_fields fields;
  struct packet_achievement_info *old;
  struct genhash **hash = pc->phs.received + PACKET_ACHIEVEMENT_INFO;
  RECEIVE_PACKET_START(packet_achievement_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_achievement_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_achievement_info_100, cmp_packet_achievement_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  real_packet->gained = BV_ISSET(fields, 1);
  real_packet->first = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_achievement_info_100(struct connection *pc, const struct packet_achievement_info *packet)
{
  const struct packet_achievement_info *real_packet = packet;
  packet_achievement_info_100_fields fields;
  struct packet_achievement_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_ACHIEVEMENT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_ACHIEVEMENT_INFO);

  log_packet_detailed("packet_achievement_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_achievement_info_100, cmp_packet_achievement_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->gained != real_packet->gained);
  if(differ) {
    different++;
  }
  if (packet->gained) {
    BV_SET(fields, 1);
  }

  differ = (old->first != real_packet->first);
  if(differ) {
    different++;
  }
  if (packet->first) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_ACHIEVEMENT_INFO);
}

int send_packet_achievement_info(struct connection *pc, const struct packet_achievement_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_ACHIEVEMENT_INFO].packet != NULL, -1,
                        "Handler for PACKET_ACHIEVEMENT_INFO not installed");
  return pc->phs.handlers->send[PACKET_ACHIEVEMENT_INFO].packet(pc, packet);
}

void lsend_packet_achievement_info(struct conn_list *dest, const struct packet_achievement_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_achievement_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_chat_msg_100 hash_const

#define cmp_packet_chat_msg_100 cmp_const

BV_DEFINE(packet_chat_msg_100_fields, 6);

static struct packet_chat_msg *receive_packet_chat_msg_100(struct connection *pc)
{
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_CHAT_MSG;
  RECEIVE_PACKET_START(packet_chat_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_chat_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!DIO_GET(string, &din, "message", real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "event", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turn'");
    if (!DIO_GET(sint16, &din, "turn", &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'phase'");
    if (!DIO_GET(sint16, &din, "phase", &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'conn_id'");
    if (!DIO_GET(sint16, &din, "conn_id", &real_packet->conn_id)) {
      RECEIVE_PACKET_FIELD_ERROR(conn_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_100(struct connection *pc, const struct packet_chat_msg *packet)
{
  const struct packet_chat_msg *real_packet = packet;
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_CHAT_MSG);

  log_packet_detailed("packet_chat_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->conn_id != real_packet->conn_id);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    DIO_PUT(string, &dout, "message", real_packet->message);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
    DIO_PUT(sint16, &dout, "event", real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turn' has changed");
    DIO_PUT(sint16, &dout, "turn", real_packet->turn);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'phase' has changed");
    DIO_PUT(sint16, &dout, "phase", real_packet->phase);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'conn_id' has changed");
    DIO_PUT(sint16, &dout, "conn_id", real_packet->conn_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CHAT_MSG);
}

int send_packet_chat_msg(struct connection *pc, const struct packet_chat_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CHAT_MSG].packet != NULL, -1,
                        "Handler for PACKET_CHAT_MSG not installed");
  return pc->phs.handlers->send[PACKET_CHAT_MSG].packet(pc, packet);
}

void lsend_packet_chat_msg(struct conn_list *dest, const struct packet_chat_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_chat_msg(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_early_chat_msg_100 hash_const

#define cmp_packet_early_chat_msg_100 cmp_const

BV_DEFINE(packet_early_chat_msg_100_fields, 6);

static struct packet_early_chat_msg *receive_packet_early_chat_msg_100(struct connection *pc)
{
  packet_early_chat_msg_100_fields fields;
  struct packet_early_chat_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_EARLY_CHAT_MSG;
  RECEIVE_PACKET_START(packet_early_chat_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_early_chat_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_early_chat_msg_100, cmp_packet_early_chat_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!DIO_GET(string, &din, "message", real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "event", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turn'");
    if (!DIO_GET(sint16, &din, "turn", &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'phase'");
    if (!DIO_GET(sint16, &din, "phase", &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'conn_id'");
    if (!DIO_GET(sint16, &din, "conn_id", &real_packet->conn_id)) {
      RECEIVE_PACKET_FIELD_ERROR(conn_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_early_chat_msg_100(struct connection *pc, const struct packet_early_chat_msg *packet)
{
  const struct packet_early_chat_msg *real_packet = packet;
  packet_early_chat_msg_100_fields fields;
  struct packet_early_chat_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_EARLY_CHAT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_EARLY_CHAT_MSG);

  log_packet_detailed("packet_early_chat_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_early_chat_msg_100, cmp_packet_early_chat_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->conn_id != real_packet->conn_id);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    DIO_PUT(string, &dout, "message", real_packet->message);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
    DIO_PUT(sint16, &dout, "event", real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turn' has changed");
    DIO_PUT(sint16, &dout, "turn", real_packet->turn);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'phase' has changed");
    DIO_PUT(sint16, &dout, "phase", real_packet->phase);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'conn_id' has changed");
    DIO_PUT(sint16, &dout, "conn_id", real_packet->conn_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_EARLY_CHAT_MSG);
}

int send_packet_early_chat_msg(struct connection *pc, const struct packet_early_chat_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_EARLY_CHAT_MSG].packet != NULL, -1,
                        "Handler for PACKET_EARLY_CHAT_MSG not installed");
  return pc->phs.handlers->send[PACKET_EARLY_CHAT_MSG].packet(pc, packet);
}

void lsend_packet_early_chat_msg(struct conn_list *dest, const struct packet_early_chat_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_early_chat_msg(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_chat_msg_req_100 hash_const

#define cmp_packet_chat_msg_req_100 cmp_const

BV_DEFINE(packet_chat_msg_req_100_fields, 1);

static struct packet_chat_msg_req *receive_packet_chat_msg_req_100(struct connection *pc)
{
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CHAT_MSG_REQ;
  RECEIVE_PACKET_START(packet_chat_msg_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_chat_msg_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!DIO_GET(string, &din, "message", real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_req_100(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  const struct packet_chat_msg_req *real_packet = packet;
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CHAT_MSG_REQ);

  log_packet_detailed("packet_chat_msg_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    DIO_PUT(string, &dout, "message", real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CHAT_MSG_REQ);
}

int send_packet_chat_msg_req(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CHAT_MSG_REQ].packet != NULL, -1,
                        "Handler for PACKET_CHAT_MSG_REQ not installed");
  return pc->phs.handlers->send[PACKET_CHAT_MSG_REQ].packet(pc, packet);
}

int dsend_packet_chat_msg_req(struct connection *pc, const char *message)
{
  struct packet_chat_msg_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_chat_msg_req(pc, real_packet);
}

#define hash_packet_connect_msg_100 hash_const

#define cmp_packet_connect_msg_100 cmp_const

BV_DEFINE(packet_connect_msg_100_fields, 1);

static struct packet_connect_msg *receive_packet_connect_msg_100(struct connection *pc)
{
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_CONNECT_MSG;
  RECEIVE_PACKET_START(packet_connect_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_connect_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!DIO_GET(string, &din, "message", real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_connect_msg_100(struct connection *pc, const struct packet_connect_msg *packet)
{
  const struct packet_connect_msg *real_packet = packet;
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONNECT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_CONNECT_MSG);

  log_packet_detailed("packet_connect_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    DIO_PUT(string, &dout, "message", real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CONNECT_MSG);
}

int send_packet_connect_msg(struct connection *pc, const struct packet_connect_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CONNECT_MSG].packet != NULL, -1,
                        "Handler for PACKET_CONNECT_MSG not installed");
  return pc->phs.handlers->send[PACKET_CONNECT_MSG].packet(pc, packet);
}

int dsend_packet_connect_msg(struct connection *pc, const char *message)
{
  struct packet_connect_msg packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_connect_msg(pc, real_packet);
}

#define hash_packet_city_remove_100 hash_const

#define cmp_packet_city_remove_100 cmp_const

BV_DEFINE(packet_city_remove_100_fields, 1);

static struct packet_city_remove *receive_packet_city_remove_100(struct connection *pc)
{
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REMOVE;
  RECEIVE_PACKET_START(packet_city_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_remove_100(struct connection *pc, const struct packet_city_remove *packet)
{
  const struct packet_city_remove *real_packet = packet;
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_REMOVE);

  log_packet_detailed("packet_city_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_CITY_REMOVE);
}

int send_packet_city_remove(struct connection *pc, const struct packet_city_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_REMOVE].packet != NULL, -1,
                        "Handler for PACKET_CITY_REMOVE not installed");
  return pc->phs.handlers->send[PACKET_CITY_REMOVE].packet(pc, packet);
}

void lsend_packet_city_remove(struct conn_list *dest, const struct packet_city_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_remove(struct connection *pc, int city_id)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_remove(pc, real_packet);
}

void dlsend_packet_city_remove(struct conn_list *dest, int city_id)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  lsend_packet_city_remove(dest, real_packet);
}

static genhash_val_t hash_packet_city_info_100(const void *vkey)
{
  const struct packet_city_info *key = (const struct packet_city_info *) vkey;

  return key->id;
}

static bool cmp_packet_city_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_city_info *key1 = (const struct packet_city_info *) vkey1;
  const struct packet_city_info *key2 = (const struct packet_city_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_city_info_100_fields, 49);

static struct packet_city_info *receive_packet_city_info_100(struct connection *pc)
{
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_INFO;
  RECEIVE_PACKET_START(packet_city_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_city_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    if (!DIO_GET(uint8, &din, "owner", &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    if (!DIO_GET(uint8, &din, "size", &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    if (!DIO_GET(uint8, &din, "city_radius_sq", &real_packet->city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'style'");
    if (!DIO_GET(uint8, &din, "style", &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'ppl_happy'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!DIO_GET(uint8, &din, "ppl_happy", &real_packet->ppl_happy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'ppl_content'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!DIO_GET(uint8, &din, "ppl_content", &real_packet->ppl_content[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_content);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!DIO_GET(uint8, &din, "ppl_unhappy", &real_packet->ppl_unhappy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'ppl_angry'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!DIO_GET(uint8, &din, "ppl_angry", &real_packet->ppl_angry[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
        }
      }
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'specialists_size'");
    if (!DIO_GET(uint8, &din, "specialists_size", &real_packet->specialists_size)) {
      RECEIVE_PACKET_FIELD_ERROR(specialists_size);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'specialists'");
    
    {
      int i;
    
      if (real_packet->specialists_size > SP_MAX) {
        RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
        if (!DIO_GET(uint8, &din, "specialists", &real_packet->specialists[i])) {
          RECEIVE_PACKET_FIELD_ERROR(specialists);
        }
      }
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'nationalities_count'");
    if (!DIO_GET(uint8, &din, "nationalities_count", &real_packet->nationalities_count)) {
      RECEIVE_PACKET_FIELD_ERROR(nationalities_count);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'nation_id'");
    
    {
      int i;
    
      if (real_packet->nationalities_count > MAX_NUM_PLAYER_SLOTS) {
        RECEIVE_PACKET_FIELD_ERROR(nation_id, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
        if (!DIO_GET(uint8, &din, "nation_id", &real_packet->nation_id[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_id);
        }
      }
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nation_citizens'");
    
    {
      int i;
    
      if (real_packet->nationalities_count > MAX_NUM_PLAYER_SLOTS) {
        RECEIVE_PACKET_FIELD_ERROR(nation_citizens, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
        if (!DIO_GET(uint8, &din, "nation_citizens", &real_packet->nation_citizens[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_citizens);
        }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'history'");
    if (!DIO_GET(uint16, &din, "history", &real_packet->history)) {
      RECEIVE_PACKET_FIELD_ERROR(history);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'culture'");
    if (!DIO_GET(uint16, &din, "culture", &real_packet->culture)) {
      RECEIVE_PACKET_FIELD_ERROR(culture);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'surplus'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(sint16, &din, "surplus", &real_packet->surplus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(surplus);
        }
      }
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'waste'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint16, &din, "waste", &real_packet->waste[i])) {
          RECEIVE_PACKET_FIELD_ERROR(waste);
        }
      }
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(sint16, &din, "unhappy_penalty", &real_packet->unhappy_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
        }
      }
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'prod'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint16, &din, "prod", &real_packet->prod[i])) {
          RECEIVE_PACKET_FIELD_ERROR(prod);
        }
      }
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'citizen_base'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(sint16, &din, "citizen_base", &real_packet->citizen_base[i])) {
          RECEIVE_PACKET_FIELD_ERROR(citizen_base);
        }
      }
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'usage'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(sint16, &din, "usage", &real_packet->usage[i])) {
          RECEIVE_PACKET_FIELD_ERROR(usage);
        }
      }
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'food_stock'");
    if (!DIO_GET(sint16, &din, "food_stock", &real_packet->food_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(food_stock);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'shield_stock'");
    if (!DIO_GET(uint16, &din, "shield_stock", &real_packet->shield_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(shield_stock);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'trade'");
    
    {
      int i;
    
      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        if (!DIO_GET(uint16, &din, "trade", &real_packet->trade[i])) {
          RECEIVE_PACKET_FIELD_ERROR(trade);
        }
      }
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'trade_value'");
    
    {
      int i;
    
      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        if (!DIO_GET(uint8, &din, "trade_value", &real_packet->trade_value[i])) {
          RECEIVE_PACKET_FIELD_ERROR(trade_value);
        }
      }
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'pollution'");
    if (!DIO_GET(uint16, &din, "pollution", &real_packet->pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(pollution);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'illness_trade'");
    if (!DIO_GET(uint16, &din, "illness_trade", &real_packet->illness_trade)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'production_kind'");
    if (!DIO_GET(uint8, &din, "production_kind", &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'production_value'");
    if (!DIO_GET(uint8, &din, "production_value", &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'turn_founded'");
    if (!DIO_GET(sint16, &din, "turn_founded", &real_packet->turn_founded)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_founded);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'turn_last_built'");
    if (!DIO_GET(sint16, &din, "turn_last_built", &real_packet->turn_last_built)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    if (!DIO_GET(uint8, &din, "changed_from_kind", &real_packet->changed_from_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'changed_from_value'");
    if (!DIO_GET(uint8, &din, "changed_from_value", &real_packet->changed_from_value)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'before_change_shields'");
    if (!DIO_GET(uint16, &din, "before_change_shields", &real_packet->before_change_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    if (!DIO_GET(uint16, &din, "disbanded_shields", &real_packet->disbanded_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'caravan_shields'");
    if (!DIO_GET(uint16, &din, "caravan_shields", &real_packet->caravan_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    if (!DIO_GET(uint16, &din, "last_turns_shield_surplus", &real_packet->last_turns_shield_surplus)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'airlift'");
    if (!DIO_GET(uint8, &din, "airlift", &real_packet->airlift)) {
      RECEIVE_PACKET_FIELD_ERROR(airlift);
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 39);
  real_packet->did_sell = BV_ISSET(fields, 40);
  real_packet->was_happy = BV_ISSET(fields, 41);
  real_packet->diplomat_investigate = BV_ISSET(fields, 42);
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'walls'");
    if (!DIO_GET(uint8, &din, "walls", &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'city_image'");
    if (!DIO_GET(sint8, &din, "city_image", &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'worklist'");
    if (!DIO_GET(worklist, &din, "worklist", &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'improvements'");
    if (!DIO_BV_GET(&din, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  got field 'city_options'");
    if (!DIO_BV_GET(&din, real_packet->city_options)) {
      RECEIVE_PACKET_FIELD_ERROR(city_options);
    }
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_100(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
  SEND_PACKET_START(PACKET_CITY_INFO);

  log_packet_detailed("packet_city_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->nationalities_count != real_packet->nationalities_count);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_id[i] != real_packet->nation_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_citizens[i] != real_packet->nation_citizens[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->history != real_packet->history);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->culture != real_packet->culture);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }


    {
      differ = (MAX_TRADE_ROUTES != MAX_TRADE_ROUTES);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_TRADE_ROUTES; i++) {
          if (old->trade[i] != real_packet->trade[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }


    {
      differ = (MAX_TRADE_ROUTES != MAX_TRADE_ROUTES);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_TRADE_ROUTES; i++) {
          if (old->trade_value[i] != real_packet->trade_value[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if(differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 39);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if(differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 40);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if(differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 41);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if(differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 42);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 47);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 48);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
    DIO_PUT(uint8, &dout, "owner", real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
    DIO_PUT(uint8, &dout, "size", real_packet->size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
    DIO_PUT(uint8, &dout, "city_radius_sq", real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'style' has changed");
    DIO_PUT(uint8, &dout, "style", real_packet->style);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_happy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_content[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_unhappy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_angry[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'specialists_size' has changed");
    DIO_PUT(uint8, &dout, "specialists_size", real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'specialists' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->specialists_size; i++) {
        dio_put_uint8(&dout, real_packet->specialists[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'nationalities_count' has changed");
    DIO_PUT(uint8, &dout, "nationalities_count", real_packet->nationalities_count);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'nation_id' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nationalities_count; i++) {
        dio_put_uint8(&dout, real_packet->nation_id[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nation_citizens' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nationalities_count; i++) {
        dio_put_uint8(&dout, real_packet->nation_citizens[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'history' has changed");
    DIO_PUT(uint16, &dout, "history", real_packet->history);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'culture' has changed");
    DIO_PUT(uint16, &dout, "culture", real_packet->culture);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'surplus' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->surplus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'waste' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->waste[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->unhappy_penalty[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'prod' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->prod[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->citizen_base[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'usage' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->usage[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'food_stock' has changed");
    DIO_PUT(sint16, &dout, "food_stock", real_packet->food_stock);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'shield_stock' has changed");
    DIO_PUT(uint16, &dout, "shield_stock", real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'trade' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        dio_put_uint16(&dout, real_packet->trade[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'trade_value' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        dio_put_uint8(&dout, real_packet->trade_value[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'pollution' has changed");
    DIO_PUT(uint16, &dout, "pollution", real_packet->pollution);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'illness_trade' has changed");
    DIO_PUT(uint16, &dout, "illness_trade", real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'production_kind' has changed");
    DIO_PUT(uint8, &dout, "production_kind", real_packet->production_kind);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'production_value' has changed");
    DIO_PUT(uint8, &dout, "production_value", real_packet->production_value);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'turn_founded' has changed");
    DIO_PUT(sint16, &dout, "turn_founded", real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
    DIO_PUT(sint16, &dout, "turn_last_built", real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
    DIO_PUT(uint8, &dout, "changed_from_kind", real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
    DIO_PUT(uint8, &dout, "changed_from_value", real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
    DIO_PUT(uint16, &dout, "before_change_shields", real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
    DIO_PUT(uint16, &dout, "disbanded_shields", real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
    DIO_PUT(uint16, &dout, "caravan_shields", real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
    DIO_PUT(uint16, &dout, "last_turns_shield_surplus", real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'airlift' has changed");
    DIO_PUT(uint8, &dout, "airlift", real_packet->airlift);
  }
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  /* field 41 is folded into the header */
  /* field 42 is folded into the header */
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'walls' has changed");
    DIO_PUT(uint8, &dout, "walls", real_packet->walls);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'city_image' has changed");
    DIO_PUT(sint8, &dout, "city_image", real_packet->city_image);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'worklist' has changed");
    DIO_PUT(worklist, &dout, "worklist", &real_packet->worklist);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, "improvements", packet->improvements);
  }
  if (BV_ISSET(fields, 47)) {
    log_packet_detailed("  field 'city_options' has changed");
  DIO_BV_PUT(&dout, "city_options", packet->city_options);
  }
  if (BV_ISSET(fields, 48)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_CITY_INFO);
}

int send_packet_city_info(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_INFO].force_to_send != NULL, -1,
                        "Handler for PACKET_CITY_INFO not installed");
  return pc->phs.handlers->send[PACKET_CITY_INFO].force_to_send(pc, packet, force_to_send);
}

void lsend_packet_city_info(struct conn_list *dest, const struct packet_city_info *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_info(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_city_short_info_100(const void *vkey)
{
  const struct packet_city_short_info *key = (const struct packet_city_short_info *) vkey;

  return key->id;
}

static bool cmp_packet_city_short_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_city_short_info *key1 = (const struct packet_city_short_info *) vkey1;
  const struct packet_city_short_info *key2 = (const struct packet_city_short_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_city_short_info_100_fields, 11);

static struct packet_city_short_info *receive_packet_city_short_info_100(struct connection *pc)
{
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  RECEIVE_PACKET_START(packet_city_short_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_city_short_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    if (!DIO_GET(uint8, &din, "owner", &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    if (!DIO_GET(uint8, &din, "size", &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'style'");
    if (!DIO_GET(uint8, &din, "style", &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  real_packet->occupied = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'walls'");
    if (!DIO_GET(uint8, &din, "walls", &real_packet->walls)) {
      RECEIVE_PACKET_FIELD_ERROR(walls);
    }
  }
  real_packet->happy = BV_ISSET(fields, 6);
  real_packet->unhappy = BV_ISSET(fields, 7);
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'city_image'");
    if (!DIO_GET(sint8, &din, "city_image", &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'improvements'");
    if (!DIO_BV_GET(&din, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_short_info_100(struct connection *pc, const struct packet_city_short_info *packet)
{
  const struct packet_city_short_info *real_packet = packet;
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SHORT_INFO);

  log_packet_detailed("packet_city_short_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 4);
  }

  differ = (old->walls != real_packet->walls);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->happy != real_packet->happy);
  if(differ) {
    different++;
  }
  if (packet->happy) {
    BV_SET(fields, 6);
  }

  differ = (old->unhappy != real_packet->unhappy);
  if(differ) {
    different++;
  }
  if (packet->unhappy) {
    BV_SET(fields, 7);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
    DIO_PUT(uint8, &dout, "owner", real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
    DIO_PUT(uint8, &dout, "size", real_packet->size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'style' has changed");
    DIO_PUT(uint8, &dout, "style", real_packet->style);
  }
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'walls' has changed");
    DIO_PUT(uint8, &dout, "walls", real_packet->walls);
  }
  /* field 6 is folded into the header */
  /* field 7 is folded into the header */
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'city_image' has changed");
    DIO_PUT(sint8, &dout, "city_image", real_packet->city_image);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, "improvements", packet->improvements);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_CITY_SHORT_INFO);
}

int send_packet_city_short_info(struct connection *pc, const struct packet_city_short_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_SHORT_INFO].packet != NULL, -1,
                        "Handler for PACKET_CITY_SHORT_INFO not installed");
  return pc->phs.handlers->send[PACKET_CITY_SHORT_INFO].packet(pc, packet);
}

void lsend_packet_city_short_info(struct conn_list *dest, const struct packet_city_short_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_short_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_city_sell_100 hash_const

#define cmp_packet_city_sell_100 cmp_const

BV_DEFINE(packet_city_sell_100_fields, 2);

static struct packet_city_sell *receive_packet_city_sell_100(struct connection *pc)
{
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SELL;
  RECEIVE_PACKET_START(packet_city_sell, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_sell_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'build_id'");
    if (!DIO_GET(uint8, &din, "build_id", &real_packet->build_id)) {
      RECEIVE_PACKET_FIELD_ERROR(build_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sell_100(struct connection *pc, const struct packet_city_sell *packet)
{
  const struct packet_city_sell *real_packet = packet;
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SELL;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SELL);

  log_packet_detailed("packet_city_sell_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->build_id != real_packet->build_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'build_id' has changed");
    DIO_PUT(uint8, &dout, "build_id", real_packet->build_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_SELL);
}

int send_packet_city_sell(struct connection *pc, const struct packet_city_sell *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_SELL].packet != NULL, -1,
                        "Handler for PACKET_CITY_SELL not installed");
  return pc->phs.handlers->send[PACKET_CITY_SELL].packet(pc, packet);
}

int dsend_packet_city_sell(struct connection *pc, int city_id, int build_id)
{
  struct packet_city_sell packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->build_id = build_id;
  
  return send_packet_city_sell(pc, real_packet);
}

#define hash_packet_city_buy_100 hash_const

#define cmp_packet_city_buy_100 cmp_const

BV_DEFINE(packet_city_buy_100_fields, 1);

static struct packet_city_buy *receive_packet_city_buy_100(struct connection *pc)
{
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_BUY;
  RECEIVE_PACKET_START(packet_city_buy, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_buy_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_buy_100(struct connection *pc, const struct packet_city_buy *packet)
{
  const struct packet_city_buy *real_packet = packet;
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_BUY;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_BUY);

  log_packet_detailed("packet_city_buy_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_BUY);
}

int send_packet_city_buy(struct connection *pc, const struct packet_city_buy *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_BUY].packet != NULL, -1,
                        "Handler for PACKET_CITY_BUY not installed");
  return pc->phs.handlers->send[PACKET_CITY_BUY].packet(pc, packet);
}

int dsend_packet_city_buy(struct connection *pc, int city_id)
{
  struct packet_city_buy packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_buy(pc, real_packet);
}

#define hash_packet_city_change_100 hash_const

#define cmp_packet_city_change_100 cmp_const

BV_DEFINE(packet_city_change_100_fields, 3);

static struct packet_city_change *receive_packet_city_change_100(struct connection *pc)
{
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE;
  RECEIVE_PACKET_START(packet_city_change, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_change_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'production_kind'");
    if (!DIO_GET(uint8, &din, "production_kind", &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'production_value'");
    if (!DIO_GET(uint8, &din, "production_value", &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_100(struct connection *pc, const struct packet_city_change *packet)
{
  const struct packet_city_change *real_packet = packet;
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_CHANGE);

  log_packet_detailed("packet_city_change_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'production_kind' has changed");
    DIO_PUT(uint8, &dout, "production_kind", real_packet->production_kind);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'production_value' has changed");
    DIO_PUT(uint8, &dout, "production_value", real_packet->production_value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_CHANGE);
}

int send_packet_city_change(struct connection *pc, const struct packet_city_change *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_CHANGE].packet != NULL, -1,
                        "Handler for PACKET_CITY_CHANGE not installed");
  return pc->phs.handlers->send[PACKET_CITY_CHANGE].packet(pc, packet);
}

int dsend_packet_city_change(struct connection *pc, int city_id, int production_kind, int production_value)
{
  struct packet_city_change packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->production_kind = production_kind;
  real_packet->production_value = production_value;
  
  return send_packet_city_change(pc, real_packet);
}

#define hash_packet_city_worklist_100 hash_const

#define cmp_packet_city_worklist_100 cmp_const

BV_DEFINE(packet_city_worklist_100_fields, 2);

static struct packet_city_worklist *receive_packet_city_worklist_100(struct connection *pc)
{
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_WORKLIST;
  RECEIVE_PACKET_START(packet_city_worklist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_worklist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worklist'");
    if (!DIO_GET(worklist, &din, "worklist", &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_worklist_100(struct connection *pc, const struct packet_city_worklist *packet)
{
  const struct packet_city_worklist *real_packet = packet;
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_WORKLIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_WORKLIST);

  log_packet_detailed("packet_city_worklist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worklist' has changed");
    DIO_PUT(worklist, &dout, "worklist", &real_packet->worklist);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_WORKLIST);
}

int send_packet_city_worklist(struct connection *pc, const struct packet_city_worklist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_WORKLIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_WORKLIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_WORKLIST].packet(pc, packet);
}

int dsend_packet_city_worklist(struct connection *pc, int city_id, const struct worklist *worklist)
{
  struct packet_city_worklist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  worklist_copy(&real_packet->worklist, worklist);
  
  return send_packet_city_worklist(pc, real_packet);
}

#define hash_packet_city_make_specialist_100 hash_const

#define cmp_packet_city_make_specialist_100 cmp_const

BV_DEFINE(packet_city_make_specialist_100_fields, 3);

static struct packet_city_make_specialist *receive_packet_city_make_specialist_100(struct connection *pc)
{
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_SPECIALIST;
  RECEIVE_PACKET_START(packet_city_make_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_make_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worker_x'");
    if (!DIO_GET(uint8, &din, "worker_x", &real_packet->worker_x)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_x);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'worker_y'");
    if (!DIO_GET(uint8, &din, "worker_y", &real_packet->worker_y)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_y);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_specialist_100(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  const struct packet_city_make_specialist *real_packet = packet;
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_MAKE_SPECIALIST);

  log_packet_detailed("packet_city_make_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->worker_x != real_packet->worker_x);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->worker_y != real_packet->worker_y);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worker_x' has changed");
    DIO_PUT(uint8, &dout, "worker_x", real_packet->worker_x);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'worker_y' has changed");
    DIO_PUT(uint8, &dout, "worker_y", real_packet->worker_y);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_MAKE_SPECIALIST);
}

int send_packet_city_make_specialist(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_MAKE_SPECIALIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_MAKE_SPECIALIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_MAKE_SPECIALIST].packet(pc, packet);
}

int dsend_packet_city_make_specialist(struct connection *pc, int city_id, int worker_x, int worker_y)
{
  struct packet_city_make_specialist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->worker_x = worker_x;
  real_packet->worker_y = worker_y;
  
  return send_packet_city_make_specialist(pc, real_packet);
}

#define hash_packet_city_make_worker_100 hash_const

#define cmp_packet_city_make_worker_100 cmp_const

BV_DEFINE(packet_city_make_worker_100_fields, 3);

static struct packet_city_make_worker *receive_packet_city_make_worker_100(struct connection *pc)
{
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_WORKER;
  RECEIVE_PACKET_START(packet_city_make_worker, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_make_worker_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worker_x'");
    if (!DIO_GET(uint8, &din, "worker_x", &real_packet->worker_x)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_x);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'worker_y'");
    if (!DIO_GET(uint8, &din, "worker_y", &real_packet->worker_y)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_y);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_worker_100(struct connection *pc, const struct packet_city_make_worker *packet)
{
  const struct packet_city_make_worker *real_packet = packet;
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_WORKER;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_MAKE_WORKER);

  log_packet_detailed("packet_city_make_worker_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->worker_x != real_packet->worker_x);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->worker_y != real_packet->worker_y);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worker_x' has changed");
    DIO_PUT(uint8, &dout, "worker_x", real_packet->worker_x);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'worker_y' has changed");
    DIO_PUT(uint8, &dout, "worker_y", real_packet->worker_y);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_MAKE_WORKER);
}

int send_packet_city_make_worker(struct connection *pc, const struct packet_city_make_worker *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_MAKE_WORKER].packet != NULL, -1,
                        "Handler for PACKET_CITY_MAKE_WORKER not installed");
  return pc->phs.handlers->send[PACKET_CITY_MAKE_WORKER].packet(pc, packet);
}

int dsend_packet_city_make_worker(struct connection *pc, int city_id, int worker_x, int worker_y)
{
  struct packet_city_make_worker packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->worker_x = worker_x;
  real_packet->worker_y = worker_y;
  
  return send_packet_city_make_worker(pc, real_packet);
}

#define hash_packet_city_change_specialist_100 hash_const

#define cmp_packet_city_change_specialist_100 cmp_const

BV_DEFINE(packet_city_change_specialist_100_fields, 3);

static struct packet_city_change_specialist *receive_packet_city_change_specialist_100(struct connection *pc)
{
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE_SPECIALIST;
  RECEIVE_PACKET_START(packet_city_change_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_change_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'from'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "from", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(from);
      }
      real_packet->from = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'to'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "to", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(to);
      }
      real_packet->to = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_specialist_100(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  const struct packet_city_change_specialist *real_packet = packet;
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_CHANGE_SPECIALIST);

  log_packet_detailed("packet_city_change_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->from != real_packet->from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->to != real_packet->to);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'from' has changed");
    DIO_PUT(uint8, &dout, "from", real_packet->from);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'to' has changed");
    DIO_PUT(uint8, &dout, "to", real_packet->to);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_CHANGE_SPECIALIST);
}

int send_packet_city_change_specialist(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_CHANGE_SPECIALIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_CHANGE_SPECIALIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_CHANGE_SPECIALIST].packet(pc, packet);
}

int dsend_packet_city_change_specialist(struct connection *pc, int city_id, Specialist_type_id from, Specialist_type_id to)
{
  struct packet_city_change_specialist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->from = from;
  real_packet->to = to;
  
  return send_packet_city_change_specialist(pc, real_packet);
}

#define hash_packet_city_rename_100 hash_const

#define cmp_packet_city_rename_100 cmp_const

BV_DEFINE(packet_city_rename_100_fields, 2);

static struct packet_city_rename *receive_packet_city_rename_100(struct connection *pc)
{
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_RENAME;
  RECEIVE_PACKET_START(packet_city_rename, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_rename_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rename_100(struct connection *pc, const struct packet_city_rename *packet)
{
  const struct packet_city_rename *real_packet = packet;
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RENAME;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_RENAME);

  log_packet_detailed("packet_city_rename_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_RENAME);
}

int send_packet_city_rename(struct connection *pc, const struct packet_city_rename *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_RENAME].packet != NULL, -1,
                        "Handler for PACKET_CITY_RENAME not installed");
  return pc->phs.handlers->send[PACKET_CITY_RENAME].packet(pc, packet);
}

int dsend_packet_city_rename(struct connection *pc, int city_id, const char *name)
{
  struct packet_city_rename packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_rename(pc, real_packet);
}

#define hash_packet_city_options_req_100 hash_const

#define cmp_packet_city_options_req_100 cmp_const

BV_DEFINE(packet_city_options_req_100_fields, 2);

static struct packet_city_options_req *receive_packet_city_options_req_100(struct connection *pc)
{
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_OPTIONS_REQ;
  RECEIVE_PACKET_START(packet_city_options_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_options_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'options'");
    if (!DIO_BV_GET(&din, real_packet->options)) {
      RECEIVE_PACKET_FIELD_ERROR(options);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_options_req_100(struct connection *pc, const struct packet_city_options_req *packet)
{
  const struct packet_city_options_req *real_packet = packet;
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_OPTIONS_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_OPTIONS_REQ);

  log_packet_detailed("packet_city_options_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !BV_ARE_EQUAL(old->options, real_packet->options);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'options' has changed");
  DIO_BV_PUT(&dout, "options", packet->options);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_OPTIONS_REQ);
}

int send_packet_city_options_req(struct connection *pc, const struct packet_city_options_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_OPTIONS_REQ].packet != NULL, -1,
                        "Handler for PACKET_CITY_OPTIONS_REQ not installed");
  return pc->phs.handlers->send[PACKET_CITY_OPTIONS_REQ].packet(pc, packet);
}

int dsend_packet_city_options_req(struct connection *pc, int city_id, bv_city_options options)
{
  struct packet_city_options_req packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->options = options;
  
  return send_packet_city_options_req(pc, real_packet);
}

#define hash_packet_city_refresh_100 hash_const

#define cmp_packet_city_refresh_100 cmp_const

BV_DEFINE(packet_city_refresh_100_fields, 1);

static struct packet_city_refresh *receive_packet_city_refresh_100(struct connection *pc)
{
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REFRESH;
  RECEIVE_PACKET_START(packet_city_refresh, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_refresh_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_refresh_100(struct connection *pc, const struct packet_city_refresh *packet)
{
  const struct packet_city_refresh *real_packet = packet;
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REFRESH;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_REFRESH);

  log_packet_detailed("packet_city_refresh_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_REFRESH);
}

int send_packet_city_refresh(struct connection *pc, const struct packet_city_refresh *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_REFRESH].packet != NULL, -1,
                        "Handler for PACKET_CITY_REFRESH not installed");
  return pc->phs.handlers->send[PACKET_CITY_REFRESH].packet(pc, packet);
}

int dsend_packet_city_refresh(struct connection *pc, int city_id)
{
  struct packet_city_refresh packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_refresh(pc, real_packet);
}

#define hash_packet_city_name_suggestion_req_100 hash_const

#define cmp_packet_city_name_suggestion_req_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_req_100_fields, 1);

static struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req_100(struct connection *pc)
{
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_REQ;
  RECEIVE_PACKET_START(packet_city_name_suggestion_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_name_suggestion_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_req_100(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  const struct packet_city_name_suggestion_req *real_packet = packet;
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_REQ);

  log_packet_detailed("packet_city_name_suggestion_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_REQ);
}

int send_packet_city_name_suggestion_req(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_REQ].packet != NULL, -1,
                        "Handler for PACKET_CITY_NAME_SUGGESTION_REQ not installed");
  return pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_REQ].packet(pc, packet);
}

int dsend_packet_city_name_suggestion_req(struct connection *pc, int unit_id)
{
  struct packet_city_name_suggestion_req packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_city_name_suggestion_req(pc, real_packet);
}

#define hash_packet_city_name_suggestion_info_100 hash_const

#define cmp_packet_city_name_suggestion_info_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_info_100_fields, 2);

static struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info_100(struct connection *pc)
{
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_INFO;
  RECEIVE_PACKET_START(packet_city_name_suggestion_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_name_suggestion_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_info_100(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  const struct packet_city_name_suggestion_info *real_packet = packet;
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_INFO);

  log_packet_detailed("packet_city_name_suggestion_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_INFO);
}

int send_packet_city_name_suggestion_info(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_INFO].packet != NULL, -1,
                        "Handler for PACKET_CITY_NAME_SUGGESTION_INFO not installed");
  return pc->phs.handlers->send[PACKET_CITY_NAME_SUGGESTION_INFO].packet(pc, packet);
}

void lsend_packet_city_name_suggestion_info(struct conn_list *dest, const struct packet_city_name_suggestion_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_name_suggestion_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_name_suggestion_info(struct connection *pc, int unit_id, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_name_suggestion_info(pc, real_packet);
}

void dlsend_packet_city_name_suggestion_info(struct conn_list *dest, int unit_id, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  lsend_packet_city_name_suggestion_info(dest, real_packet);
}

#define hash_packet_city_sabotage_list_100 hash_const

#define cmp_packet_city_sabotage_list_100 cmp_const

BV_DEFINE(packet_city_sabotage_list_100_fields, 3);

static struct packet_city_sabotage_list *receive_packet_city_sabotage_list_100(struct connection *pc)
{
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SABOTAGE_LIST;
  RECEIVE_PACKET_START(packet_city_sabotage_list, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_sabotage_list_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!DIO_GET(uint16, &din, "diplomat_id", &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'improvements'");
    if (!DIO_BV_GET(&din, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sabotage_list_100(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  const struct packet_city_sabotage_list *real_packet = packet;
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SABOTAGE_LIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SABOTAGE_LIST);

  log_packet_detailed("packet_city_sabotage_list_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    DIO_PUT(uint16, &dout, "diplomat_id", real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, "improvements", packet->improvements);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_SABOTAGE_LIST);
}

int send_packet_city_sabotage_list(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CITY_SABOTAGE_LIST].packet != NULL, -1,
                        "Handler for PACKET_CITY_SABOTAGE_LIST not installed");
  return pc->phs.handlers->send[PACKET_CITY_SABOTAGE_LIST].packet(pc, packet);
}

void lsend_packet_city_sabotage_list(struct conn_list *dest, const struct packet_city_sabotage_list *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_sabotage_list(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_worker_task_100 hash_const

#define cmp_packet_worker_task_100 cmp_const

BV_DEFINE(packet_worker_task_100_fields, 5);

static struct packet_worker_task *receive_packet_worker_task_100(struct connection *pc)
{
  packet_worker_task_100_fields fields;
  struct packet_worker_task *old;
  struct genhash **hash = pc->phs.received + PACKET_WORKER_TASK;
  RECEIVE_PACKET_START(packet_worker_task, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_worker_task_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_worker_task_100, cmp_packet_worker_task_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile_id'");
    if (!DIO_GET(sint32, &din, "tile_id", &real_packet->tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(tile_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "activity", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'tgt'");
    if (!DIO_GET(sint8, &din, "tgt", &real_packet->tgt)) {
      RECEIVE_PACKET_FIELD_ERROR(tgt);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'want'");
    if (!DIO_GET(uint16, &din, "want", &real_packet->want)) {
      RECEIVE_PACKET_FIELD_ERROR(want);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_worker_task_100(struct connection *pc, const struct packet_worker_task *packet)
{
  const struct packet_worker_task *real_packet = packet;
  packet_worker_task_100_fields fields;
  struct packet_worker_task *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_WORKER_TASK;
  int different = 0;
  SEND_PACKET_START(PACKET_WORKER_TASK);

  log_packet_detailed("packet_worker_task_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_worker_task_100, cmp_packet_worker_task_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile_id != real_packet->tile_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->tgt != real_packet->tgt);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->want != real_packet->want);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile_id' has changed");
    DIO_PUT(sint32, &dout, "tile_id", real_packet->tile_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'activity' has changed");
    DIO_PUT(uint8, &dout, "activity", real_packet->activity);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'tgt' has changed");
    DIO_PUT(sint8, &dout, "tgt", real_packet->tgt);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'want' has changed");
    DIO_PUT(uint16, &dout, "want", real_packet->want);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_WORKER_TASK);
}

int send_packet_worker_task(struct connection *pc, const struct packet_worker_task *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_WORKER_TASK].packet != NULL, -1,
                        "Handler for PACKET_WORKER_TASK not installed");
  return pc->phs.handlers->send[PACKET_WORKER_TASK].packet(pc, packet);
}

void lsend_packet_worker_task(struct conn_list *dest, const struct packet_worker_task *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_worker_task(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_player_remove_100 hash_const

#define cmp_packet_player_remove_100 cmp_const

BV_DEFINE(packet_player_remove_100_fields, 1);

static struct packet_player_remove *receive_packet_player_remove_100(struct connection *pc)
{
  packet_player_remove_100_fields fields;
  struct packet_player_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_REMOVE;
  RECEIVE_PACKET_START(packet_player_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_remove_100, cmp_packet_player_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'playerno'");
    if (!DIO_GET(uint8, &din, "playerno", &real_packet->playerno)) {
      RECEIVE_PACKET_FIELD_ERROR(playerno);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_PLAYER_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_remove_100(struct connection *pc, const struct packet_player_remove *packet)
{
  const struct packet_player_remove *real_packet = packet;
  packet_player_remove_100_fields fields;
  struct packet_player_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_REMOVE);

  log_packet_detailed("packet_player_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_remove_100, cmp_packet_player_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->playerno != real_packet->playerno);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'playerno' has changed");
    DIO_PUT(uint8, &dout, "playerno", real_packet->playerno);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_PLAYER_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_PLAYER_REMOVE);
}

int send_packet_player_remove(struct connection *pc, const struct packet_player_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_REMOVE].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_REMOVE not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_REMOVE].packet(pc, packet);
}

int dsend_packet_player_remove(struct connection *pc, int playerno)
{
  struct packet_player_remove packet, *real_packet = &packet;

  real_packet->playerno = playerno;
  
  return send_packet_player_remove(pc, real_packet);
}

static genhash_val_t hash_packet_player_info_100(const void *vkey)
{
  const struct packet_player_info *key = (const struct packet_player_info *) vkey;

  return key->playerno;
}

static bool cmp_packet_player_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_info *key1 = (const struct packet_player_info *) vkey1;
  const struct packet_player_info *key2 = (const struct packet_player_info *) vkey2;

  return key1->playerno == key2->playerno;
}

BV_DEFINE(packet_player_info_100_fields, 42);

static struct packet_player_info *receive_packet_player_info_100(struct connection *pc)
{
  packet_player_info_100_fields fields;
  struct packet_player_info *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_INFO;
  RECEIVE_PACKET_START(packet_player_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint8, &din, "playerno", &real_packet->playerno)) {
    RECEIVE_PACKET_FIELD_ERROR(playerno);
  }

  log_packet_detailed("packet_player_info_100: got info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_100, cmp_packet_player_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int playerno = real_packet->playerno;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->playerno = playerno;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'username'");
    if (!DIO_GET(string, &din, "username", real_packet->username, sizeof(real_packet->username))) {
      RECEIVE_PACKET_FIELD_ERROR(username);
    }
  }
  real_packet->unassigned_user = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'score'");
    if (!DIO_GET(uint32, &din, "score", &real_packet->score)) {
      RECEIVE_PACKET_FIELD_ERROR(score);
    }
  }
  real_packet->is_male = BV_ISSET(fields, 4);
  real_packet->was_created = BV_ISSET(fields, 5);
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'government'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "government", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(government);
      }
      real_packet->government = readin;
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'target_government'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "target_government", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(target_government);
      }
      real_packet->target_government = readin;
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'real_embassy'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        if (!DIO_GET(bool8, &din, "real_embassy", &real_packet->real_embassy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(real_embassy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'mood'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "mood", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(mood);
      }
      real_packet->mood = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'style'");
    if (!DIO_GET(uint8, &din, "style", &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'music_style'");
    if (!DIO_GET(sint8, &din, "music_style", &real_packet->music_style)) {
      RECEIVE_PACKET_FIELD_ERROR(music_style);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "nation", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation);
      }
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'team'");
    if (!DIO_GET(uint8, &din, "team", &real_packet->team)) {
      RECEIVE_PACKET_FIELD_ERROR(team);
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 14);
  real_packet->phase_done = BV_ISSET(fields, 15);
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'nturns_idle'");
    if (!DIO_GET(sint16, &din, "nturns_idle", &real_packet->nturns_idle)) {
      RECEIVE_PACKET_FIELD_ERROR(nturns_idle);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'turns_alive'");
    if (!DIO_GET(sint16, &din, "turns_alive", &real_packet->turns_alive)) {
      RECEIVE_PACKET_FIELD_ERROR(turns_alive);
    }
  }
  real_packet->is_alive = BV_ISSET(fields, 18);
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'gold'");
    if (!DIO_GET(uint32, &din, "gold", &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'tax'");
    if (!DIO_GET(uint8, &din, "tax", &real_packet->tax)) {
      RECEIVE_PACKET_FIELD_ERROR(tax);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'science'");
    if (!DIO_GET(uint8, &din, "science", &real_packet->science)) {
      RECEIVE_PACKET_FIELD_ERROR(science);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'luxury'");
    if (!DIO_GET(uint8, &din, "luxury", &real_packet->luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(luxury);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'tech_upkeep'");
    if (!DIO_GET(uint16, &din, "tech_upkeep", &real_packet->tech_upkeep)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'science_cost'");
    if (!DIO_GET(uint16, &din, "science_cost", &real_packet->science_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(science_cost);
    }
  }
  real_packet->is_connected = BV_ISSET(fields, 25);
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'revolution_finishes'");
    if (!DIO_GET(sint16, &din, "revolution_finishes", &real_packet->revolution_finishes)) {
      RECEIVE_PACKET_FIELD_ERROR(revolution_finishes);
    }
  }
  real_packet->ai = BV_ISSET(fields, 27);
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'ai_skill_level'");
    if (!DIO_GET(uint8, &din, "ai_skill_level", &real_packet->ai_skill_level)) {
      RECEIVE_PACKET_FIELD_ERROR(ai_skill_level);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'barbarian_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "barbarian_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(barbarian_type);
      }
      real_packet->barbarian_type = readin;
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'gives_shared_vision'");
    if (!DIO_BV_GET(&din, real_packet->gives_shared_vision)) {
      RECEIVE_PACKET_FIELD_ERROR(gives_shared_vision);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'history'");
    if (!DIO_GET(uint16, &din, "history", &real_packet->history)) {
      RECEIVE_PACKET_FIELD_ERROR(history);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'love'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        if (!DIO_GET(sint16, &din, "love", &real_packet->love[i])) {
          RECEIVE_PACKET_FIELD_ERROR(love);
        }
      }
    }
  }
  real_packet->color_valid = BV_ISSET(fields, 33);
  real_packet->color_changeable = BV_ISSET(fields, 34);
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'color_red'");
    if (!DIO_GET(uint8, &din, "color_red", &real_packet->color_red)) {
      RECEIVE_PACKET_FIELD_ERROR(color_red);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'color_green'");
    if (!DIO_GET(uint8, &din, "color_green", &real_packet->color_green)) {
      RECEIVE_PACKET_FIELD_ERROR(color_green);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'color_blue'");
    if (!DIO_GET(uint8, &din, "color_blue", &real_packet->color_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(color_blue);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'wonders'");
    
    for (;;) {
      int i;
    
      if (!DIO_GET(uint8, &din, "wonders", &i)) {
        RECEIVE_PACKET_FIELD_ERROR(wonders);
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(wonders,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
        if (!DIO_GET(sint32, &din, "wonders", &real_packet->wonders[i])) {
          RECEIVE_PACKET_FIELD_ERROR(wonders);
        }
      }
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'multip_count'");
    if (!DIO_GET(uint8, &din, "multip_count", &real_packet->multip_count)) {
      RECEIVE_PACKET_FIELD_ERROR(multip_count);
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'multiplier'");
    
    {
      int i;
    
      if (real_packet->multip_count > MAX_NUM_MULTIPLIERS) {
        RECEIVE_PACKET_FIELD_ERROR(multiplier, ": truncation array");
      }
      for (i = 0; i < real_packet->multip_count; i++) {
        if (!DIO_GET(sint32, &din, "multiplier", &real_packet->multiplier[i])) {
          RECEIVE_PACKET_FIELD_ERROR(multiplier);
        }
      }
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'multiplier_target'");
    
    {
      int i;
    
      if (real_packet->multip_count > MAX_NUM_MULTIPLIERS) {
        RECEIVE_PACKET_FIELD_ERROR(multiplier_target, ": truncation array");
      }
      for (i = 0; i < real_packet->multip_count; i++) {
        if (!DIO_GET(sint32, &din, "multiplier_target", &real_packet->multiplier_target[i])) {
          RECEIVE_PACKET_FIELD_ERROR(multiplier_target);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_info_100(struct connection *pc, const struct packet_player_info *packet)
{
  const struct packet_player_info *real_packet = packet;
  packet_player_info_100_fields fields;
  struct packet_player_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_INFO);

  log_packet_detailed("packet_player_info_100: sending info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_100, cmp_packet_player_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->unassigned_user != real_packet->unassigned_user);
  if(differ) {
    different++;
  }
  if (packet->unassigned_user) {
    BV_SET(fields, 2);
  }

  differ = (old->score != real_packet->score);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 4);
  }

  differ = (old->was_created != real_packet->was_created);
  if(differ) {
    different++;
  }
  if (packet->was_created) {
    BV_SET(fields, 5);
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->target_government != real_packet->target_government);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->real_embassy[i] != real_packet->real_embassy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->mood != real_packet->mood);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->music_style != real_packet->music_style);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->team != real_packet->team);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 14);
  }

  differ = (old->phase_done != real_packet->phase_done);
  if(differ) {
    different++;
  }
  if (packet->phase_done) {
    BV_SET(fields, 15);
  }

  differ = (old->nturns_idle != real_packet->nturns_idle);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->turns_alive != real_packet->turns_alive);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->is_alive != real_packet->is_alive);
  if(differ) {
    different++;
  }
  if (packet->is_alive) {
    BV_SET(fields, 18);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->tech_upkeep != real_packet->tech_upkeep);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->science_cost != real_packet->science_cost);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->is_connected != real_packet->is_connected);
  if(differ) {
    different++;
  }
  if (packet->is_connected) {
    BV_SET(fields, 25);
  }

  differ = (old->revolution_finishes != real_packet->revolution_finishes);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 27);
  }

  differ = (old->ai_skill_level != real_packet->ai_skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = !BV_ARE_EQUAL(old->gives_shared_vision, real_packet->gives_shared_vision);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->history != real_packet->history);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->love[i] != real_packet->love[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->color_valid != real_packet->color_valid);
  if(differ) {
    different++;
  }
  if (packet->color_valid) {
    BV_SET(fields, 33);
  }

  differ = (old->color_changeable != real_packet->color_changeable);
  if(differ) {
    different++;
  }
  if (packet->color_changeable) {
    BV_SET(fields, 34);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->wonders[i] != real_packet->wonders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->multip_count != real_packet->multip_count);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }


    {
      differ = (old->multip_count != real_packet->multip_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->multip_count; i++) {
          if (old->multiplier[i] != real_packet->multiplier[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }


    {
      differ = (old->multip_count != real_packet->multip_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->multip_count; i++) {
          if (old->multiplier_target[i] != real_packet->multiplier_target[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint8, &dout, "playerno", real_packet->playerno);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'username' has changed");
    DIO_PUT(string, &dout, "username", real_packet->username);
  }
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'score' has changed");
    DIO_PUT(uint32, &dout, "score", real_packet->score);
  }
  /* field 4 is folded into the header */
  /* field 5 is folded into the header */
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'government' has changed");
    DIO_PUT(sint8, &dout, "government", real_packet->government);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'target_government' has changed");
    DIO_PUT(sint8, &dout, "target_government", real_packet->target_government);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'real_embassy' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_bool8(&dout, real_packet->real_embassy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'mood' has changed");
    DIO_PUT(uint8, &dout, "mood", real_packet->mood);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'style' has changed");
    DIO_PUT(uint8, &dout, "style", real_packet->style);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'music_style' has changed");
    DIO_PUT(sint8, &dout, "music_style", real_packet->music_style);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'nation' has changed");
    DIO_PUT(sint16, &dout, "nation", real_packet->nation);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'team' has changed");
    DIO_PUT(uint8, &dout, "team", real_packet->team);
  }
  /* field 14 is folded into the header */
  /* field 15 is folded into the header */
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'nturns_idle' has changed");
    DIO_PUT(sint16, &dout, "nturns_idle", real_packet->nturns_idle);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'turns_alive' has changed");
    DIO_PUT(sint16, &dout, "turns_alive", real_packet->turns_alive);
  }
  /* field 18 is folded into the header */
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'gold' has changed");
    DIO_PUT(uint32, &dout, "gold", real_packet->gold);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'tax' has changed");
    DIO_PUT(uint8, &dout, "tax", real_packet->tax);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'science' has changed");
    DIO_PUT(uint8, &dout, "science", real_packet->science);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'luxury' has changed");
    DIO_PUT(uint8, &dout, "luxury", real_packet->luxury);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'tech_upkeep' has changed");
    DIO_PUT(uint16, &dout, "tech_upkeep", real_packet->tech_upkeep);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'science_cost' has changed");
    DIO_PUT(uint16, &dout, "science_cost", real_packet->science_cost);
  }
  /* field 25 is folded into the header */
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'revolution_finishes' has changed");
    DIO_PUT(sint16, &dout, "revolution_finishes", real_packet->revolution_finishes);
  }
  /* field 27 is folded into the header */
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'ai_skill_level' has changed");
    DIO_PUT(uint8, &dout, "ai_skill_level", real_packet->ai_skill_level);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    DIO_PUT(uint8, &dout, "barbarian_type", real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'gives_shared_vision' has changed");
  DIO_BV_PUT(&dout, "gives_shared_vision", packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'history' has changed");
    DIO_PUT(uint16, &dout, "history", real_packet->history);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'love' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_sint16(&dout, real_packet->love[i]);
      }
    } 
  }
  /* field 33 is folded into the header */
  /* field 34 is folded into the header */
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'color_red' has changed");
    DIO_PUT(uint8, &dout, "color_red", real_packet->color_red);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'color_green' has changed");
    DIO_PUT(uint8, &dout, "color_green", real_packet->color_green);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'color_blue' has changed");
    DIO_PUT(uint8, &dout, "color_blue", real_packet->color_blue);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'wonders' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->wonders[i] != real_packet->wonders[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint32(&dout, real_packet->wonders[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'multip_count' has changed");
    DIO_PUT(uint8, &dout, "multip_count", real_packet->multip_count);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'multiplier' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->multip_count; i++) {
        dio_put_sint32(&dout, real_packet->multiplier[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'multiplier_target' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->multip_count; i++) {
        dio_put_sint32(&dout, real_packet->multiplier_target[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_INFO);
}

int send_packet_player_info(struct connection *pc, const struct packet_player_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_INFO].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_INFO not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_INFO].packet(pc, packet);
}

#define hash_packet_player_phase_done_100 hash_const

#define cmp_packet_player_phase_done_100 cmp_const

BV_DEFINE(packet_player_phase_done_100_fields, 1);

static struct packet_player_phase_done *receive_packet_player_phase_done_100(struct connection *pc)
{
  packet_player_phase_done_100_fields fields;
  struct packet_player_phase_done *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_PHASE_DONE;
  RECEIVE_PACKET_START(packet_player_phase_done, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_phase_done_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_phase_done_100, cmp_packet_player_phase_done_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'turn'");
    if (!DIO_GET(sint16, &din, "turn", &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_phase_done_100(struct connection *pc, const struct packet_player_phase_done *packet)
{
  const struct packet_player_phase_done *real_packet = packet;
  packet_player_phase_done_100_fields fields;
  struct packet_player_phase_done *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_PHASE_DONE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_PHASE_DONE);

  log_packet_detailed("packet_player_phase_done_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_phase_done_100, cmp_packet_player_phase_done_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'turn' has changed");
    DIO_PUT(sint16, &dout, "turn", real_packet->turn);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_PHASE_DONE);
}

int send_packet_player_phase_done(struct connection *pc, const struct packet_player_phase_done *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_PHASE_DONE].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_PHASE_DONE not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_PHASE_DONE].packet(pc, packet);
}

int dsend_packet_player_phase_done(struct connection *pc, int turn)
{
  struct packet_player_phase_done packet, *real_packet = &packet;

  real_packet->turn = turn;
  
  return send_packet_player_phase_done(pc, real_packet);
}

#define hash_packet_player_rates_100 hash_const

#define cmp_packet_player_rates_100 cmp_const

BV_DEFINE(packet_player_rates_100_fields, 3);

static struct packet_player_rates *receive_packet_player_rates_100(struct connection *pc)
{
  packet_player_rates_100_fields fields;
  struct packet_player_rates *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_RATES;
  RECEIVE_PACKET_START(packet_player_rates, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_rates_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_rates_100, cmp_packet_player_rates_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tax'");
    if (!DIO_GET(uint8, &din, "tax", &real_packet->tax)) {
      RECEIVE_PACKET_FIELD_ERROR(tax);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'luxury'");
    if (!DIO_GET(uint8, &din, "luxury", &real_packet->luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(luxury);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'science'");
    if (!DIO_GET(uint8, &din, "science", &real_packet->science)) {
      RECEIVE_PACKET_FIELD_ERROR(science);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_rates_100(struct connection *pc, const struct packet_player_rates *packet)
{
  const struct packet_player_rates *real_packet = packet;
  packet_player_rates_100_fields fields;
  struct packet_player_rates *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_RATES;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_RATES);

  log_packet_detailed("packet_player_rates_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_rates_100, cmp_packet_player_rates_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tax' has changed");
    DIO_PUT(uint8, &dout, "tax", real_packet->tax);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'luxury' has changed");
    DIO_PUT(uint8, &dout, "luxury", real_packet->luxury);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'science' has changed");
    DIO_PUT(uint8, &dout, "science", real_packet->science);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_RATES);
}

int send_packet_player_rates(struct connection *pc, const struct packet_player_rates *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_RATES].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_RATES not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_RATES].packet(pc, packet);
}

int dsend_packet_player_rates(struct connection *pc, int tax, int luxury, int science)
{
  struct packet_player_rates packet, *real_packet = &packet;

  real_packet->tax = tax;
  real_packet->luxury = luxury;
  real_packet->science = science;
  
  return send_packet_player_rates(pc, real_packet);
}

#define hash_packet_player_change_government_100 hash_const

#define cmp_packet_player_change_government_100 cmp_const

BV_DEFINE(packet_player_change_government_100_fields, 1);

static struct packet_player_change_government *receive_packet_player_change_government_100(struct connection *pc)
{
  packet_player_change_government_100_fields fields;
  struct packet_player_change_government *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_CHANGE_GOVERNMENT;
  RECEIVE_PACKET_START(packet_player_change_government, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_change_government_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_change_government_100, cmp_packet_player_change_government_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'government'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "government", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(government);
      }
      real_packet->government = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_change_government_100(struct connection *pc, const struct packet_player_change_government *packet)
{
  const struct packet_player_change_government *real_packet = packet;
  packet_player_change_government_100_fields fields;
  struct packet_player_change_government *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_CHANGE_GOVERNMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_CHANGE_GOVERNMENT);

  log_packet_detailed("packet_player_change_government_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_change_government_100, cmp_packet_player_change_government_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'government' has changed");
    DIO_PUT(sint8, &dout, "government", real_packet->government);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_CHANGE_GOVERNMENT);
}

int send_packet_player_change_government(struct connection *pc, const struct packet_player_change_government *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_CHANGE_GOVERNMENT].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_CHANGE_GOVERNMENT not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_CHANGE_GOVERNMENT].packet(pc, packet);
}

int dsend_packet_player_change_government(struct connection *pc, Government_type_id government)
{
  struct packet_player_change_government packet, *real_packet = &packet;

  real_packet->government = government;
  
  return send_packet_player_change_government(pc, real_packet);
}

static struct packet_player_attribute_block *receive_packet_player_attribute_block_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_player_attribute_block, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_player_attribute_block_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_attribute_block_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PLAYER_ATTRIBUTE_BLOCK);

  log_packet_detailed("packet_player_attribute_block_100: sending info about ()");
  SEND_PACKET_END(PACKET_PLAYER_ATTRIBUTE_BLOCK);
}

int send_packet_player_attribute_block(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_ATTRIBUTE_BLOCK].no_packet != NULL, -1,
                        "Handler for PACKET_PLAYER_ATTRIBUTE_BLOCK not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_ATTRIBUTE_BLOCK].no_packet(pc);
}

static genhash_val_t hash_packet_player_attribute_chunk_100(const void *vkey)
{
  const struct packet_player_attribute_chunk *key = (const struct packet_player_attribute_chunk *) vkey;

  return key->offset;
}

static bool cmp_packet_player_attribute_chunk_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_attribute_chunk *key1 = (const struct packet_player_attribute_chunk *) vkey1;
  const struct packet_player_attribute_chunk *key2 = (const struct packet_player_attribute_chunk *) vkey2;

  return key1->offset == key2->offset;
}

BV_DEFINE(packet_player_attribute_chunk_100_fields, 3);

static struct packet_player_attribute_chunk *receive_packet_player_attribute_chunk_100(struct connection *pc)
{
  packet_player_attribute_chunk_100_fields fields;
  struct packet_player_attribute_chunk *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_ATTRIBUTE_CHUNK;
  RECEIVE_PACKET_START(packet_player_attribute_chunk, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint32, &din, "offset", &real_packet->offset)) {
    RECEIVE_PACKET_FIELD_ERROR(offset);
  }

  log_packet_detailed("packet_player_attribute_chunk_100: got info about (%d)",
    real_packet->offset);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_attribute_chunk_100, cmp_packet_player_attribute_chunk_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int offset = real_packet->offset;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->offset = offset;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'total_length'");
    if (!DIO_GET(uint32, &din, "total_length", &real_packet->total_length)) {
      RECEIVE_PACKET_FIELD_ERROR(total_length);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'chunk_length'");
    if (!DIO_GET(uint16, &din, "chunk_length", &real_packet->chunk_length)) {
      RECEIVE_PACKET_FIELD_ERROR(chunk_length);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'data'");
    
      if (real_packet->chunk_length > ATTRIBUTE_CHUNK_SIZE) {
        RECEIVE_PACKET_FIELD_ERROR(data, ": truncation array");
      }
      if (!dio_get_memory(&din, real_packet->data, real_packet->chunk_length)){
        RECEIVE_PACKET_FIELD_ERROR(data);
      }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_attribute_chunk_100(struct connection *pc, const struct packet_player_attribute_chunk *packet)
{
  const struct packet_player_attribute_chunk *real_packet = packet;
  packet_player_attribute_chunk_100_fields fields;
  struct packet_player_attribute_chunk *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_ATTRIBUTE_CHUNK;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_ATTRIBUTE_CHUNK);

  log_packet_detailed("packet_player_attribute_chunk_100: sending info about (%d)",
    real_packet->offset);

  {
    struct packet_player_attribute_chunk *tmp = fc_malloc(sizeof(*tmp));

    *tmp = *packet;
    pre_send_packet_player_attribute_chunk(pc, tmp);
    real_packet = tmp;
  }

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_attribute_chunk_100, cmp_packet_player_attribute_chunk_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->total_length != real_packet->total_length);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->chunk_length != real_packet->chunk_length);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (memcmp(old->data, real_packet->data, ATTRIBUTE_CHUNK_SIZE) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint32, &dout, "offset", real_packet->offset);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'total_length' has changed");
    DIO_PUT(uint32, &dout, "total_length", real_packet->total_length);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'chunk_length' has changed");
    DIO_PUT(uint16, &dout, "chunk_length", real_packet->chunk_length);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'data' has changed");
    DIO_PUT(memory, &dout, "data", &real_packet->data, real_packet->chunk_length);
  }

  *old = *real_packet;

  if (real_packet != packet) {
    free((void *) real_packet);
  }
  SEND_PACKET_END(PACKET_PLAYER_ATTRIBUTE_CHUNK);
}

int send_packet_player_attribute_chunk(struct connection *pc, const struct packet_player_attribute_chunk *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_ATTRIBUTE_CHUNK].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_ATTRIBUTE_CHUNK not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_ATTRIBUTE_CHUNK].packet(pc, packet);
}

static genhash_val_t hash_packet_player_diplstate_100(const void *vkey)
{
  const struct packet_player_diplstate *key = (const struct packet_player_diplstate *) vkey;

  return key->diplstate_id;
}

static bool cmp_packet_player_diplstate_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_diplstate *key1 = (const struct packet_player_diplstate *) vkey1;
  const struct packet_player_diplstate *key2 = (const struct packet_player_diplstate *) vkey2;

  return key1->diplstate_id == key2->diplstate_id;
}

BV_DEFINE(packet_player_diplstate_100_fields, 6);

static struct packet_player_diplstate *receive_packet_player_diplstate_100(struct connection *pc)
{
  packet_player_diplstate_100_fields fields;
  struct packet_player_diplstate *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_DIPLSTATE;
  RECEIVE_PACKET_START(packet_player_diplstate, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint32, &din, "diplstate_id", &real_packet->diplstate_id)) {
    RECEIVE_PACKET_FIELD_ERROR(diplstate_id);
  }

  log_packet_detailed("packet_player_diplstate_100: got info about (%d)",
    real_packet->diplstate_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_diplstate_100, cmp_packet_player_diplstate_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int diplstate_id = real_packet->diplstate_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->diplstate_id = diplstate_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'plr1'");
    if (!DIO_GET(uint8, &din, "plr1", &real_packet->plr1)) {
      RECEIVE_PACKET_FIELD_ERROR(plr1);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'plr2'");
    if (!DIO_GET(uint8, &din, "plr2", &real_packet->plr2)) {
      RECEIVE_PACKET_FIELD_ERROR(plr2);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turns_left'");
    if (!DIO_GET(uint16, &din, "turns_left", &real_packet->turns_left)) {
      RECEIVE_PACKET_FIELD_ERROR(turns_left);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'has_reason_to_cancel'");
    if (!DIO_GET(uint8, &din, "has_reason_to_cancel", &real_packet->has_reason_to_cancel)) {
      RECEIVE_PACKET_FIELD_ERROR(has_reason_to_cancel);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'contact_turns_left'");
    if (!DIO_GET(uint16, &din, "contact_turns_left", &real_packet->contact_turns_left)) {
      RECEIVE_PACKET_FIELD_ERROR(contact_turns_left);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_diplstate_100(struct connection *pc, const struct packet_player_diplstate *packet)
{
  const struct packet_player_diplstate *real_packet = packet;
  packet_player_diplstate_100_fields fields;
  struct packet_player_diplstate *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_DIPLSTATE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_DIPLSTATE);

  log_packet_detailed("packet_player_diplstate_100: sending info about (%d)",
    real_packet->diplstate_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_diplstate_100, cmp_packet_player_diplstate_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->plr1 != real_packet->plr1);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->plr2 != real_packet->plr2);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->turns_left != real_packet->turns_left);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->has_reason_to_cancel != real_packet->has_reason_to_cancel);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->contact_turns_left != real_packet->contact_turns_left);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint32, &dout, "diplstate_id", real_packet->diplstate_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'plr1' has changed");
    DIO_PUT(uint8, &dout, "plr1", real_packet->plr1);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'plr2' has changed");
    DIO_PUT(uint8, &dout, "plr2", real_packet->plr2);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turns_left' has changed");
    DIO_PUT(uint16, &dout, "turns_left", real_packet->turns_left);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'has_reason_to_cancel' has changed");
    DIO_PUT(uint8, &dout, "has_reason_to_cancel", real_packet->has_reason_to_cancel);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'contact_turns_left' has changed");
    DIO_PUT(uint16, &dout, "contact_turns_left", real_packet->contact_turns_left);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_DIPLSTATE);
}

int send_packet_player_diplstate(struct connection *pc, const struct packet_player_diplstate *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_DIPLSTATE].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_DIPLSTATE not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_DIPLSTATE].packet(pc, packet);
}

#define hash_packet_player_multiplier_100 hash_const

#define cmp_packet_player_multiplier_100 cmp_const

BV_DEFINE(packet_player_multiplier_100_fields, 2);

static struct packet_player_multiplier *receive_packet_player_multiplier_100(struct connection *pc)
{
  packet_player_multiplier_100_fields fields;
  struct packet_player_multiplier *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_MULTIPLIER;
  RECEIVE_PACKET_START(packet_player_multiplier, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_multiplier_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_multiplier_100, cmp_packet_player_multiplier_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'count'");
    if (!DIO_GET(uint16, &din, "count", &real_packet->count)) {
      RECEIVE_PACKET_FIELD_ERROR(count);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'multipliers'");
    
    {
      int i;
    
      if (real_packet->count > MAX_NUM_MULTIPLIERS) {
        RECEIVE_PACKET_FIELD_ERROR(multipliers, ": truncation array");
      }
      for (i = 0; i < real_packet->count; i++) {
        if (!DIO_GET(sint32, &din, "multipliers", &real_packet->multipliers[i])) {
          RECEIVE_PACKET_FIELD_ERROR(multipliers);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_multiplier_100(struct connection *pc, const struct packet_player_multiplier *packet)
{
  const struct packet_player_multiplier *real_packet = packet;
  packet_player_multiplier_100_fields fields;
  struct packet_player_multiplier *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_MULTIPLIER;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_MULTIPLIER);

  log_packet_detailed("packet_player_multiplier_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_multiplier_100, cmp_packet_player_multiplier_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->count != real_packet->count);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->count != real_packet->count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->count; i++) {
          if (old->multipliers[i] != real_packet->multipliers[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'count' has changed");
    DIO_PUT(uint16, &dout, "count", real_packet->count);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'multipliers' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->count; i++) {
        dio_put_sint32(&dout, real_packet->multipliers[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_MULTIPLIER);
}

int send_packet_player_multiplier(struct connection *pc, const struct packet_player_multiplier *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_MULTIPLIER].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_MULTIPLIER not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_MULTIPLIER].packet(pc, packet);
}

static genhash_val_t hash_packet_research_info_100(const void *vkey)
{
  const struct packet_research_info *key = (const struct packet_research_info *) vkey;

  return key->id;
}

static bool cmp_packet_research_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_research_info *key1 = (const struct packet_research_info *) vkey1;
  const struct packet_research_info *key2 = (const struct packet_research_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_research_info_100_fields, 8);

static struct packet_research_info *receive_packet_research_info_100(struct connection *pc)
{
  packet_research_info_100_fields fields;
  struct packet_research_info *old;
  struct genhash **hash = pc->phs.received + PACKET_RESEARCH_INFO;
  RECEIVE_PACKET_START(packet_research_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_research_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_research_info_100, cmp_packet_research_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'techs_researched'");
    if (!DIO_GET(uint32, &din, "techs_researched", &real_packet->techs_researched)) {
      RECEIVE_PACKET_FIELD_ERROR(techs_researched);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'future_tech'");
    if (!DIO_GET(uint16, &din, "future_tech", &real_packet->future_tech)) {
      RECEIVE_PACKET_FIELD_ERROR(future_tech);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'researching'");
    if (!DIO_GET(uint8, &din, "researching", &real_packet->researching)) {
      RECEIVE_PACKET_FIELD_ERROR(researching);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'researching_cost'");
    if (!DIO_GET(uint32, &din, "researching_cost", &real_packet->researching_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(researching_cost);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'bulbs_researched'");
    if (!DIO_GET(uint32, &din, "bulbs_researched", &real_packet->bulbs_researched)) {
      RECEIVE_PACKET_FIELD_ERROR(bulbs_researched);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'tech_goal'");
    if (!DIO_GET(uint8, &din, "tech_goal", &real_packet->tech_goal)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_goal);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'total_bulbs_prod'");
    if (!DIO_GET(sint32, &din, "total_bulbs_prod", &real_packet->total_bulbs_prod)) {
      RECEIVE_PACKET_FIELD_ERROR(total_bulbs_prod);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'inventions'");
    if (!DIO_GET(string, &din, "inventions", real_packet->inventions, sizeof(real_packet->inventions))) {
      RECEIVE_PACKET_FIELD_ERROR(inventions);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_research_info_100(struct connection *pc, const struct packet_research_info *packet)
{
  const struct packet_research_info *real_packet = packet;
  packet_research_info_100_fields fields;
  struct packet_research_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RESEARCH_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_RESEARCH_INFO);

  log_packet_detailed("packet_research_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_research_info_100, cmp_packet_research_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->techs_researched != real_packet->techs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->future_tech != real_packet->future_tech);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->researching != real_packet->researching);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->researching_cost != real_packet->researching_cost);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->bulbs_researched != real_packet->bulbs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->tech_goal != real_packet->tech_goal);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->total_bulbs_prod != real_packet->total_bulbs_prod);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->inventions, real_packet->inventions) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint8, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'techs_researched' has changed");
    DIO_PUT(uint32, &dout, "techs_researched", real_packet->techs_researched);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'future_tech' has changed");
    DIO_PUT(uint16, &dout, "future_tech", real_packet->future_tech);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'researching' has changed");
    DIO_PUT(uint8, &dout, "researching", real_packet->researching);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'researching_cost' has changed");
    DIO_PUT(uint32, &dout, "researching_cost", real_packet->researching_cost);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'bulbs_researched' has changed");
    DIO_PUT(uint32, &dout, "bulbs_researched", real_packet->bulbs_researched);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'tech_goal' has changed");
    DIO_PUT(uint8, &dout, "tech_goal", real_packet->tech_goal);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'total_bulbs_prod' has changed");
    DIO_PUT(sint32, &dout, "total_bulbs_prod", real_packet->total_bulbs_prod);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'inventions' has changed");
    DIO_PUT(string, &dout, "inventions", real_packet->inventions);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RESEARCH_INFO);
}

int send_packet_research_info(struct connection *pc, const struct packet_research_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RESEARCH_INFO].packet != NULL, -1,
                        "Handler for PACKET_RESEARCH_INFO not installed");
  return pc->phs.handlers->send[PACKET_RESEARCH_INFO].packet(pc, packet);
}

void lsend_packet_research_info(struct conn_list *dest, const struct packet_research_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_research_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_player_research_100 hash_const

#define cmp_packet_player_research_100 cmp_const

BV_DEFINE(packet_player_research_100_fields, 1);

static struct packet_player_research *receive_packet_player_research_100(struct connection *pc)
{
  packet_player_research_100_fields fields;
  struct packet_player_research *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_RESEARCH;
  RECEIVE_PACKET_START(packet_player_research, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_research_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_research_100, cmp_packet_player_research_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    if (!DIO_GET(uint8, &din, "tech", &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_research_100(struct connection *pc, const struct packet_player_research *packet)
{
  const struct packet_player_research *real_packet = packet;
  packet_player_research_100_fields fields;
  struct packet_player_research *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_RESEARCH;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_RESEARCH);

  log_packet_detailed("packet_player_research_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_research_100, cmp_packet_player_research_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    DIO_PUT(uint8, &dout, "tech", real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_RESEARCH);
}

int send_packet_player_research(struct connection *pc, const struct packet_player_research *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_RESEARCH].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_RESEARCH not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_RESEARCH].packet(pc, packet);
}

int dsend_packet_player_research(struct connection *pc, int tech)
{
  struct packet_player_research packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_player_research(pc, real_packet);
}

#define hash_packet_player_tech_goal_100 hash_const

#define cmp_packet_player_tech_goal_100 cmp_const

BV_DEFINE(packet_player_tech_goal_100_fields, 1);

static struct packet_player_tech_goal *receive_packet_player_tech_goal_100(struct connection *pc)
{
  packet_player_tech_goal_100_fields fields;
  struct packet_player_tech_goal *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_TECH_GOAL;
  RECEIVE_PACKET_START(packet_player_tech_goal, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_tech_goal_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_tech_goal_100, cmp_packet_player_tech_goal_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    if (!DIO_GET(uint8, &din, "tech", &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_tech_goal_100(struct connection *pc, const struct packet_player_tech_goal *packet)
{
  const struct packet_player_tech_goal *real_packet = packet;
  packet_player_tech_goal_100_fields fields;
  struct packet_player_tech_goal *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_TECH_GOAL;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_TECH_GOAL);

  log_packet_detailed("packet_player_tech_goal_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_tech_goal_100, cmp_packet_player_tech_goal_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    DIO_PUT(uint8, &dout, "tech", real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_TECH_GOAL);
}

int send_packet_player_tech_goal(struct connection *pc, const struct packet_player_tech_goal *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PLAYER_TECH_GOAL].packet != NULL, -1,
                        "Handler for PACKET_PLAYER_TECH_GOAL not installed");
  return pc->phs.handlers->send[PACKET_PLAYER_TECH_GOAL].packet(pc, packet);
}

int dsend_packet_player_tech_goal(struct connection *pc, int tech)
{
  struct packet_player_tech_goal packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_player_tech_goal(pc, real_packet);
}

#define hash_packet_unit_remove_100 hash_const

#define cmp_packet_unit_remove_100 cmp_const

BV_DEFINE(packet_unit_remove_100_fields, 1);

static struct packet_unit_remove *receive_packet_unit_remove_100(struct connection *pc)
{
  packet_unit_remove_100_fields fields;
  struct packet_unit_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_REMOVE;
  RECEIVE_PACKET_START(packet_unit_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_remove_100, cmp_packet_unit_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_remove_100(struct connection *pc, const struct packet_unit_remove *packet)
{
  const struct packet_unit_remove *real_packet = packet;
  packet_unit_remove_100_fields fields;
  struct packet_unit_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_REMOVE);

  log_packet_detailed("packet_unit_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_remove_100, cmp_packet_unit_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_REMOVE);
}

int send_packet_unit_remove(struct connection *pc, const struct packet_unit_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_REMOVE].packet != NULL, -1,
                        "Handler for PACKET_UNIT_REMOVE not installed");
  return pc->phs.handlers->send[PACKET_UNIT_REMOVE].packet(pc, packet);
}

void lsend_packet_unit_remove(struct conn_list *dest, const struct packet_unit_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_unit_remove(struct connection *pc, int unit_id)
{
  struct packet_unit_remove packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_remove(pc, real_packet);
}

void dlsend_packet_unit_remove(struct conn_list *dest, int unit_id)
{
  struct packet_unit_remove packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  lsend_packet_unit_remove(dest, real_packet);
}

static genhash_val_t hash_packet_unit_info_100(const void *vkey)
{
  const struct packet_unit_info *key = (const struct packet_unit_info *) vkey;

  return key->id;
}

static bool cmp_packet_unit_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_info *key1 = (const struct packet_unit_info *) vkey1;
  const struct packet_unit_info *key2 = (const struct packet_unit_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_info_100_fields, 36);

static struct packet_unit_info *receive_packet_unit_info_100(struct connection *pc)
{
  packet_unit_info_100_fields fields;
  struct packet_unit_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_INFO;
  RECEIVE_PACKET_START(packet_unit_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_unit_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_100, cmp_packet_unit_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    if (!DIO_GET(uint8, &din, "owner", &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nationality'");
    if (!DIO_GET(uint8, &din, "nationality", &real_packet->nationality)) {
      RECEIVE_PACKET_FIELD_ERROR(nationality);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "facing", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(facing);
      }
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'homecity'");
    if (!DIO_GET(uint16, &din, "homecity", &real_packet->homecity)) {
      RECEIVE_PACKET_FIELD_ERROR(homecity);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint8, &din, "upkeep", &real_packet->upkeep[i])) {
          RECEIVE_PACKET_FIELD_ERROR(upkeep);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'veteran'");
    if (!DIO_GET(uint8, &din, "veteran", &real_packet->veteran)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran);
    }
  }
  real_packet->ai = BV_ISSET(fields, 7);
  real_packet->paradropped = BV_ISSET(fields, 8);
  real_packet->occupied = BV_ISSET(fields, 9);
  real_packet->transported = BV_ISSET(fields, 10);
  real_packet->done_moving = BV_ISSET(fields, 11);
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'transported_by'");
    if (!DIO_GET(uint16, &din, "transported_by", &real_packet->transported_by)) {
      RECEIVE_PACKET_FIELD_ERROR(transported_by);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'movesleft'");
    if (!DIO_GET(uint16, &din, "movesleft", &real_packet->movesleft)) {
      RECEIVE_PACKET_FIELD_ERROR(movesleft);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'hp'");
    if (!DIO_GET(uint8, &din, "hp", &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'fuel'");
    if (!DIO_GET(uint8, &din, "fuel", &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'activity_count'");
    if (!DIO_GET(uint16, &din, "activity_count", &real_packet->activity_count)) {
      RECEIVE_PACKET_FIELD_ERROR(activity_count);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'changed_from_count'");
    if (!DIO_GET(uint16, &din, "changed_from_count", &real_packet->changed_from_count)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_count);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'goto_tile'");
    if (!DIO_GET(sint32, &din, "goto_tile", &real_packet->goto_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(goto_tile);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "activity", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'activity_tgt'");
    if (!DIO_GET(sint8, &din, "activity_tgt", &real_packet->activity_tgt)) {
      RECEIVE_PACKET_FIELD_ERROR(activity_tgt);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'changed_from'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "changed_from", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from);
      }
      real_packet->changed_from = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'changed_from_tgt'");
    if (!DIO_GET(sint8, &din, "changed_from_tgt", &real_packet->changed_from_tgt)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'battlegroup'");
    if (!DIO_GET(sint8, &din, "battlegroup", &real_packet->battlegroup)) {
      RECEIVE_PACKET_FIELD_ERROR(battlegroup);
    }
  }
  real_packet->has_orders = BV_ISSET(fields, 25);
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'orders_length'");
    if (!DIO_GET(uint16, &din, "orders_length", &real_packet->orders_length)) {
      RECEIVE_PACKET_FIELD_ERROR(orders_length);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'orders_index'");
    if (!DIO_GET(uint16, &din, "orders_index", &real_packet->orders_index)) {
      RECEIVE_PACKET_FIELD_ERROR(orders_index);
    }
  }
  real_packet->orders_repeat = BV_ISSET(fields, 28);
  real_packet->orders_vigilant = BV_ISSET(fields, 29);
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!DIO_GET(uint8, &din, "orders", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders);
          }
          real_packet->orders[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'orders_dirs'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_dirs, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!DIO_GET(sint8, &din, "orders_dirs", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_dirs);
          }
          real_packet->orders_dirs[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'orders_activities'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_activities, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!DIO_GET(uint8, &din, "orders_activities", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_activities);
          }
          real_packet->orders_activities[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'orders_targets'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_targets, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        if (!DIO_GET(sint8, &din, "orders_targets", &real_packet->orders_targets[i])) {
          RECEIVE_PACKET_FIELD_ERROR(orders_targets);
        }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'action_decision_want'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "action_decision_want", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_decision_want);
      }
      real_packet->action_decision_want = readin;
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'action_decision_tile'");
    if (!DIO_GET(sint32, &din, "action_decision_tile", &real_packet->action_decision_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(action_decision_tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_info_100(struct connection *pc, const struct packet_unit_info *packet)
{
  const struct packet_unit_info *real_packet = packet;
  packet_unit_info_100_fields fields;
  struct packet_unit_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_INFO);

  log_packet_detailed("packet_unit_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_100, cmp_packet_unit_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nationality != real_packet->nationality);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->homecity != real_packet->homecity);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 7);
  }

  differ = (old->paradropped != real_packet->paradropped);
  if(differ) {
    different++;
  }
  if (packet->paradropped) {
    BV_SET(fields, 8);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 9);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 10);
  }

  differ = (old->done_moving != real_packet->done_moving);
  if(differ) {
    different++;
  }
  if (packet->done_moving) {
    BV_SET(fields, 11);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->movesleft != real_packet->movesleft);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->activity_count != real_packet->activity_count);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->changed_from_count != real_packet->changed_from_count);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->goto_tile != real_packet->goto_tile);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->activity_tgt != real_packet->activity_tgt);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->changed_from != real_packet->changed_from);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->changed_from_tgt != real_packet->changed_from_tgt);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->has_orders != real_packet->has_orders);
  if(differ) {
    different++;
  }
  if (packet->has_orders) {
    BV_SET(fields, 25);
  }

  differ = (old->orders_length != real_packet->orders_length);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->orders_index != real_packet->orders_index);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->orders_repeat != real_packet->orders_repeat);
  if(differ) {
    different++;
  }
  if (packet->orders_repeat) {
    BV_SET(fields, 28);
  }

  differ = (old->orders_vigilant != real_packet->orders_vigilant);
  if(differ) {
    different++;
  }
  if (packet->orders_vigilant) {
    BV_SET(fields, 29);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_dirs[i] != real_packet->orders_dirs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_activities[i] != real_packet->orders_activities[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_targets[i] != real_packet->orders_targets[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->action_decision_want != real_packet->action_decision_want);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->action_decision_tile != real_packet->action_decision_tile);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    DIO_PUT(uint8, &dout, "owner", real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nationality' has changed");
    DIO_PUT(uint8, &dout, "nationality", real_packet->nationality);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'facing' has changed");
    DIO_PUT(sint8, &dout, "facing", real_packet->facing);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'homecity' has changed");
    DIO_PUT(uint16, &dout, "homecity", real_packet->homecity);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'veteran' has changed");
    DIO_PUT(uint8, &dout, "veteran", real_packet->veteran);
  }
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  /* field 10 is folded into the header */
  /* field 11 is folded into the header */
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'transported_by' has changed");
    DIO_PUT(uint16, &dout, "transported_by", real_packet->transported_by);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'movesleft' has changed");
    DIO_PUT(uint16, &dout, "movesleft", real_packet->movesleft);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'hp' has changed");
    DIO_PUT(uint8, &dout, "hp", real_packet->hp);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'fuel' has changed");
    DIO_PUT(uint8, &dout, "fuel", real_packet->fuel);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'activity_count' has changed");
    DIO_PUT(uint16, &dout, "activity_count", real_packet->activity_count);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'changed_from_count' has changed");
    DIO_PUT(uint16, &dout, "changed_from_count", real_packet->changed_from_count);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'goto_tile' has changed");
    DIO_PUT(sint32, &dout, "goto_tile", real_packet->goto_tile);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'activity' has changed");
    DIO_PUT(uint8, &dout, "activity", real_packet->activity);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'activity_tgt' has changed");
    DIO_PUT(sint8, &dout, "activity_tgt", real_packet->activity_tgt);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'changed_from' has changed");
    DIO_PUT(uint8, &dout, "changed_from", real_packet->changed_from);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'changed_from_tgt' has changed");
    DIO_PUT(sint8, &dout, "changed_from_tgt", real_packet->changed_from_tgt);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    DIO_PUT(sint8, &dout, "battlegroup", real_packet->battlegroup);
  }
  /* field 25 is folded into the header */
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'orders_length' has changed");
    DIO_PUT(uint16, &dout, "orders_length", real_packet->orders_length);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'orders_index' has changed");
    DIO_PUT(uint16, &dout, "orders_index", real_packet->orders_index);
  }
  /* field 28 is folded into the header */
  /* field 29 is folded into the header */
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'orders_dirs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_dirs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'orders_activities' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_activities[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'orders_targets' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_targets[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'action_decision_want' has changed");
    DIO_PUT(uint8, &dout, "action_decision_want", real_packet->action_decision_want);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'action_decision_tile' has changed");
    DIO_PUT(sint32, &dout, "action_decision_tile", real_packet->action_decision_tile);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_INFO);
}

int send_packet_unit_info(struct connection *pc, const struct packet_unit_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_INFO].packet != NULL, -1,
                        "Handler for PACKET_UNIT_INFO not installed");
  return pc->phs.handlers->send[PACKET_UNIT_INFO].packet(pc, packet);
}

void lsend_packet_unit_info(struct conn_list *dest, const struct packet_unit_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_info(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_unit_short_info_100(const void *vkey)
{
  const struct packet_unit_short_info *key = (const struct packet_unit_short_info *) vkey;

  return key->id;
}

static bool cmp_packet_unit_short_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_short_info *key1 = (const struct packet_unit_short_info *) vkey1;
  const struct packet_unit_short_info *key2 = (const struct packet_unit_short_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_short_info_100_fields, 13);

static struct packet_unit_short_info *receive_packet_unit_short_info_100(struct connection *pc)
{
  packet_unit_short_info_100_fields fields;
  struct packet_unit_short_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  RECEIVE_PACKET_START(packet_unit_short_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_unit_short_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_short_info_100, cmp_packet_unit_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    if (!DIO_GET(uint8, &din, "owner", &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "facing", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(facing);
      }
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran'");
    if (!DIO_GET(uint8, &din, "veteran", &real_packet->veteran)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran);
    }
  }
  real_packet->occupied = BV_ISSET(fields, 5);
  real_packet->transported = BV_ISSET(fields, 6);
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'hp'");
    if (!DIO_GET(uint8, &din, "hp", &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'activity'");
    if (!DIO_GET(uint8, &din, "activity", &real_packet->activity)) {
      RECEIVE_PACKET_FIELD_ERROR(activity);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'activity_tgt'");
    if (!DIO_GET(sint8, &din, "activity_tgt", &real_packet->activity_tgt)) {
      RECEIVE_PACKET_FIELD_ERROR(activity_tgt);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'transported_by'");
    if (!DIO_GET(uint16, &din, "transported_by", &real_packet->transported_by)) {
      RECEIVE_PACKET_FIELD_ERROR(transported_by);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'packet_use'");
    if (!DIO_GET(uint8, &din, "packet_use", &real_packet->packet_use)) {
      RECEIVE_PACKET_FIELD_ERROR(packet_use);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'info_city_id'");
    if (!DIO_GET(uint16, &din, "info_city_id", &real_packet->info_city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(info_city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_short_info_100(struct connection *pc, const struct packet_unit_short_info *packet, bool force_to_send)
{
  const struct packet_unit_short_info *real_packet = packet;
  packet_unit_short_info_100_fields fields;
  struct packet_unit_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  int different = force_to_send;
  SEND_PACKET_START(PACKET_UNIT_SHORT_INFO);

  log_packet_detailed("packet_unit_short_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_short_info_100, cmp_packet_unit_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 5);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 6);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->activity_tgt != real_packet->activity_tgt);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->packet_use != real_packet->packet_use);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->info_city_id != real_packet->info_city_id);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    DIO_PUT(uint8, &dout, "owner", real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'facing' has changed");
    DIO_PUT(sint8, &dout, "facing", real_packet->facing);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran' has changed");
    DIO_PUT(uint8, &dout, "veteran", real_packet->veteran);
  }
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'hp' has changed");
    DIO_PUT(uint8, &dout, "hp", real_packet->hp);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'activity' has changed");
    DIO_PUT(uint8, &dout, "activity", real_packet->activity);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'activity_tgt' has changed");
    DIO_PUT(sint8, &dout, "activity_tgt", real_packet->activity_tgt);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'transported_by' has changed");
    DIO_PUT(uint16, &dout, "transported_by", real_packet->transported_by);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'packet_use' has changed");
    DIO_PUT(uint8, &dout, "packet_use", real_packet->packet_use);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'info_city_id' has changed");
    DIO_PUT(uint16, &dout, "info_city_id", real_packet->info_city_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_SHORT_INFO);
}

int send_packet_unit_short_info(struct connection *pc, const struct packet_unit_short_info *packet, bool force_to_send)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_SHORT_INFO].force_to_send != NULL, -1,
                        "Handler for PACKET_UNIT_SHORT_INFO not installed");
  return pc->phs.handlers->send[PACKET_UNIT_SHORT_INFO].force_to_send(pc, packet, force_to_send);
}

void lsend_packet_unit_short_info(struct conn_list *dest, const struct packet_unit_short_info *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_short_info(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

#define hash_packet_unit_combat_info_100 hash_const

#define cmp_packet_unit_combat_info_100 cmp_const

BV_DEFINE(packet_unit_combat_info_100_fields, 5);

static struct packet_unit_combat_info *receive_packet_unit_combat_info_100(struct connection *pc)
{
  packet_unit_combat_info_100_fields fields;
  struct packet_unit_combat_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_COMBAT_INFO;
  RECEIVE_PACKET_START(packet_unit_combat_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_combat_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_combat_info_100, cmp_packet_unit_combat_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'attacker_unit_id'");
    if (!DIO_GET(uint16, &din, "attacker_unit_id", &real_packet->attacker_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(attacker_unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'defender_unit_id'");
    if (!DIO_GET(uint16, &din, "defender_unit_id", &real_packet->defender_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(defender_unit_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'attacker_hp'");
    if (!DIO_GET(uint8, &din, "attacker_hp", &real_packet->attacker_hp)) {
      RECEIVE_PACKET_FIELD_ERROR(attacker_hp);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'defender_hp'");
    if (!DIO_GET(uint8, &din, "defender_hp", &real_packet->defender_hp)) {
      RECEIVE_PACKET_FIELD_ERROR(defender_hp);
    }
  }
  real_packet->make_winner_veteran = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_combat_info_100(struct connection *pc, const struct packet_unit_combat_info *packet)
{
  const struct packet_unit_combat_info *real_packet = packet;
  packet_unit_combat_info_100_fields fields;
  struct packet_unit_combat_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_COMBAT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_COMBAT_INFO);

  log_packet_detailed("packet_unit_combat_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_combat_info_100, cmp_packet_unit_combat_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->attacker_unit_id != real_packet->attacker_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->defender_unit_id != real_packet->defender_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->attacker_hp != real_packet->attacker_hp);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->defender_hp != real_packet->defender_hp);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->make_winner_veteran != real_packet->make_winner_veteran);
  if(differ) {
    different++;
  }
  if (packet->make_winner_veteran) {
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'attacker_unit_id' has changed");
    DIO_PUT(uint16, &dout, "attacker_unit_id", real_packet->attacker_unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'defender_unit_id' has changed");
    DIO_PUT(uint16, &dout, "defender_unit_id", real_packet->defender_unit_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'attacker_hp' has changed");
    DIO_PUT(uint8, &dout, "attacker_hp", real_packet->attacker_hp);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'defender_hp' has changed");
    DIO_PUT(uint8, &dout, "defender_hp", real_packet->defender_hp);
  }
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_COMBAT_INFO);
}

int send_packet_unit_combat_info(struct connection *pc, const struct packet_unit_combat_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_COMBAT_INFO].packet != NULL, -1,
                        "Handler for PACKET_UNIT_COMBAT_INFO not installed");
  return pc->phs.handlers->send[PACKET_UNIT_COMBAT_INFO].packet(pc, packet);
}

void lsend_packet_unit_combat_info(struct conn_list *dest, const struct packet_unit_combat_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_combat_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_unit_build_city_100 hash_const

#define cmp_packet_unit_build_city_100 cmp_const

BV_DEFINE(packet_unit_build_city_100_fields, 2);

static struct packet_unit_build_city *receive_packet_unit_build_city_100(struct connection *pc)
{
  packet_unit_build_city_100_fields fields;
  struct packet_unit_build_city *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_BUILD_CITY;
  RECEIVE_PACKET_START(packet_unit_build_city, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_build_city_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_build_city_100, cmp_packet_unit_build_city_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_build_city_100(struct connection *pc, const struct packet_unit_build_city *packet)
{
  const struct packet_unit_build_city *real_packet = packet;
  packet_unit_build_city_100_fields fields;
  struct packet_unit_build_city *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_BUILD_CITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_BUILD_CITY);

  log_packet_detailed("packet_unit_build_city_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_build_city_100, cmp_packet_unit_build_city_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_BUILD_CITY);
}

int send_packet_unit_build_city(struct connection *pc, const struct packet_unit_build_city *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_BUILD_CITY].packet != NULL, -1,
                        "Handler for PACKET_UNIT_BUILD_CITY not installed");
  return pc->phs.handlers->send[PACKET_UNIT_BUILD_CITY].packet(pc, packet);
}

int dsend_packet_unit_build_city(struct connection *pc, int unit_id, const char *name)
{
  struct packet_unit_build_city packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_unit_build_city(pc, real_packet);
}

#define hash_packet_unit_disband_100 hash_const

#define cmp_packet_unit_disband_100 cmp_const

BV_DEFINE(packet_unit_disband_100_fields, 1);

static struct packet_unit_disband *receive_packet_unit_disband_100(struct connection *pc)
{
  packet_unit_disband_100_fields fields;
  struct packet_unit_disband *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_DISBAND;
  RECEIVE_PACKET_START(packet_unit_disband, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_disband_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_disband_100, cmp_packet_unit_disband_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_disband_100(struct connection *pc, const struct packet_unit_disband *packet)
{
  const struct packet_unit_disband *real_packet = packet;
  packet_unit_disband_100_fields fields;
  struct packet_unit_disband *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DISBAND;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DISBAND);

  log_packet_detailed("packet_unit_disband_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_disband_100, cmp_packet_unit_disband_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_DISBAND);
}

int send_packet_unit_disband(struct connection *pc, const struct packet_unit_disband *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_DISBAND].packet != NULL, -1,
                        "Handler for PACKET_UNIT_DISBAND not installed");
  return pc->phs.handlers->send[PACKET_UNIT_DISBAND].packet(pc, packet);
}

int dsend_packet_unit_disband(struct connection *pc, int unit_id)
{
  struct packet_unit_disband packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_disband(pc, real_packet);
}

#define hash_packet_unit_change_homecity_100 hash_const

#define cmp_packet_unit_change_homecity_100 cmp_const

BV_DEFINE(packet_unit_change_homecity_100_fields, 2);

static struct packet_unit_change_homecity *receive_packet_unit_change_homecity_100(struct connection *pc)
{
  packet_unit_change_homecity_100_fields fields;
  struct packet_unit_change_homecity *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_CHANGE_HOMECITY;
  RECEIVE_PACKET_START(packet_unit_change_homecity, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_homecity_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_homecity_100, cmp_packet_unit_change_homecity_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_homecity_100(struct connection *pc, const struct packet_unit_change_homecity *packet)
{
  const struct packet_unit_change_homecity *real_packet = packet;
  packet_unit_change_homecity_100_fields fields;
  struct packet_unit_change_homecity *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_HOMECITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_HOMECITY);

  log_packet_detailed("packet_unit_change_homecity_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_homecity_100, cmp_packet_unit_change_homecity_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_CHANGE_HOMECITY);
}

int send_packet_unit_change_homecity(struct connection *pc, const struct packet_unit_change_homecity *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_CHANGE_HOMECITY].packet != NULL, -1,
                        "Handler for PACKET_UNIT_CHANGE_HOMECITY not installed");
  return pc->phs.handlers->send[PACKET_UNIT_CHANGE_HOMECITY].packet(pc, packet);
}

int dsend_packet_unit_change_homecity(struct connection *pc, int unit_id, int city_id)
{
  struct packet_unit_change_homecity packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->city_id = city_id;
  
  return send_packet_unit_change_homecity(pc, real_packet);
}

#define hash_packet_unit_battlegroup_100 hash_const

#define cmp_packet_unit_battlegroup_100 cmp_const

BV_DEFINE(packet_unit_battlegroup_100_fields, 2);

static struct packet_unit_battlegroup *receive_packet_unit_battlegroup_100(struct connection *pc)
{
  packet_unit_battlegroup_100_fields fields;
  struct packet_unit_battlegroup *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_BATTLEGROUP;
  RECEIVE_PACKET_START(packet_unit_battlegroup, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_battlegroup_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_battlegroup_100, cmp_packet_unit_battlegroup_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'battlegroup'");
    if (!DIO_GET(sint8, &din, "battlegroup", &real_packet->battlegroup)) {
      RECEIVE_PACKET_FIELD_ERROR(battlegroup);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_battlegroup_100(struct connection *pc, const struct packet_unit_battlegroup *packet)
{
  const struct packet_unit_battlegroup *real_packet = packet;
  packet_unit_battlegroup_100_fields fields;
  struct packet_unit_battlegroup *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_BATTLEGROUP;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_BATTLEGROUP);

  log_packet_detailed("packet_unit_battlegroup_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_battlegroup_100, cmp_packet_unit_battlegroup_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    DIO_PUT(sint8, &dout, "battlegroup", real_packet->battlegroup);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_BATTLEGROUP);
}

int send_packet_unit_battlegroup(struct connection *pc, const struct packet_unit_battlegroup *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_BATTLEGROUP].packet != NULL, -1,
                        "Handler for PACKET_UNIT_BATTLEGROUP not installed");
  return pc->phs.handlers->send[PACKET_UNIT_BATTLEGROUP].packet(pc, packet);
}

int dsend_packet_unit_battlegroup(struct connection *pc, int unit_id, int battlegroup)
{
  struct packet_unit_battlegroup packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->battlegroup = battlegroup;
  
  return send_packet_unit_battlegroup(pc, real_packet);
}

#define hash_packet_unit_orders_100 hash_const

#define cmp_packet_unit_orders_100 cmp_const

BV_DEFINE(packet_unit_orders_100_fields, 10);

static struct packet_unit_orders *receive_packet_unit_orders_100(struct connection *pc)
{
  packet_unit_orders_100_fields fields;
  struct packet_unit_orders *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_ORDERS;
  RECEIVE_PACKET_START(packet_unit_orders, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_orders_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_orders_100, cmp_packet_unit_orders_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'src_tile'");
    if (!DIO_GET(sint32, &din, "src_tile", &real_packet->src_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(src_tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'length'");
    if (!DIO_GET(uint16, &din, "length", &real_packet->length)) {
      RECEIVE_PACKET_FIELD_ERROR(length);
    }
  }
  real_packet->repeat = BV_ISSET(fields, 3);
  real_packet->vigilant = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!DIO_GET(uint8, &din, "orders", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders);
          }
          real_packet->orders[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'dir'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(dir, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!DIO_GET(sint8, &din, "dir", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(dir);
          }
          real_packet->dir[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'activity'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(activity, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!DIO_GET(uint8, &din, "activity", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(activity);
          }
          real_packet->activity[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'target'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(target, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        if (!DIO_GET(sint8, &din, "target", &real_packet->target[i])) {
          RECEIVE_PACKET_FIELD_ERROR(target);
        }
      }
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'dest_tile'");
    if (!DIO_GET(sint32, &din, "dest_tile", &real_packet->dest_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(dest_tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_orders_100(struct connection *pc, const struct packet_unit_orders *packet)
{
  const struct packet_unit_orders *real_packet = packet;
  packet_unit_orders_100_fields fields;
  struct packet_unit_orders *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ORDERS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ORDERS);

  log_packet_detailed("packet_unit_orders_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_orders_100, cmp_packet_unit_orders_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->src_tile != real_packet->src_tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->length != real_packet->length);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->repeat != real_packet->repeat);
  if(differ) {
    different++;
  }
  if (packet->repeat) {
    BV_SET(fields, 3);
  }

  differ = (old->vigilant != real_packet->vigilant);
  if(differ) {
    different++;
  }
  if (packet->vigilant) {
    BV_SET(fields, 4);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->dir[i] != real_packet->dir[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->activity[i] != real_packet->activity[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->target[i] != real_packet->target[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->dest_tile != real_packet->dest_tile);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'src_tile' has changed");
    DIO_PUT(sint32, &dout, "src_tile", real_packet->src_tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'length' has changed");
    DIO_PUT(uint16, &dout, "length", real_packet->length);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'dir' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_sint8(&dout, real_packet->dir[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'activity' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->activity[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'target' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_sint8(&dout, real_packet->target[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'dest_tile' has changed");
    DIO_PUT(sint32, &dout, "dest_tile", real_packet->dest_tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_ORDERS);
}

int send_packet_unit_orders(struct connection *pc, const struct packet_unit_orders *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_ORDERS].packet != NULL, -1,
                        "Handler for PACKET_UNIT_ORDERS not installed");
  return pc->phs.handlers->send[PACKET_UNIT_ORDERS].packet(pc, packet);
}

#define hash_packet_unit_autosettlers_100 hash_const

#define cmp_packet_unit_autosettlers_100 cmp_const

BV_DEFINE(packet_unit_autosettlers_100_fields, 1);

static struct packet_unit_autosettlers *receive_packet_unit_autosettlers_100(struct connection *pc)
{
  packet_unit_autosettlers_100_fields fields;
  struct packet_unit_autosettlers *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_AUTOSETTLERS;
  RECEIVE_PACKET_START(packet_unit_autosettlers, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_autosettlers_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_autosettlers_100, cmp_packet_unit_autosettlers_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_autosettlers_100(struct connection *pc, const struct packet_unit_autosettlers *packet)
{
  const struct packet_unit_autosettlers *real_packet = packet;
  packet_unit_autosettlers_100_fields fields;
  struct packet_unit_autosettlers *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_AUTOSETTLERS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_AUTOSETTLERS);

  log_packet_detailed("packet_unit_autosettlers_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_autosettlers_100, cmp_packet_unit_autosettlers_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_AUTOSETTLERS);
}

int send_packet_unit_autosettlers(struct connection *pc, const struct packet_unit_autosettlers *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_AUTOSETTLERS].packet != NULL, -1,
                        "Handler for PACKET_UNIT_AUTOSETTLERS not installed");
  return pc->phs.handlers->send[PACKET_UNIT_AUTOSETTLERS].packet(pc, packet);
}

int dsend_packet_unit_autosettlers(struct connection *pc, int unit_id)
{
  struct packet_unit_autosettlers packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_autosettlers(pc, real_packet);
}

#define hash_packet_unit_load_100 hash_const

#define cmp_packet_unit_load_100 cmp_const

BV_DEFINE(packet_unit_load_100_fields, 3);

static struct packet_unit_load *receive_packet_unit_load_100(struct connection *pc)
{
  packet_unit_load_100_fields fields;
  struct packet_unit_load *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_LOAD;
  RECEIVE_PACKET_START(packet_unit_load, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_load_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_load_100, cmp_packet_unit_load_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'cargo_id'");
    if (!DIO_GET(uint16, &din, "cargo_id", &real_packet->cargo_id)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'transporter_id'");
    if (!DIO_GET(uint16, &din, "transporter_id", &real_packet->transporter_id)) {
      RECEIVE_PACKET_FIELD_ERROR(transporter_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'transporter_tile'");
    if (!DIO_GET(sint32, &din, "transporter_tile", &real_packet->transporter_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(transporter_tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_load_100(struct connection *pc, const struct packet_unit_load *packet)
{
  const struct packet_unit_load *real_packet = packet;
  packet_unit_load_100_fields fields;
  struct packet_unit_load *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_LOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_LOAD);

  log_packet_detailed("packet_unit_load_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_load_100, cmp_packet_unit_load_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->cargo_id != real_packet->cargo_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->transporter_id != real_packet->transporter_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->transporter_tile != real_packet->transporter_tile);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'cargo_id' has changed");
    DIO_PUT(uint16, &dout, "cargo_id", real_packet->cargo_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'transporter_id' has changed");
    DIO_PUT(uint16, &dout, "transporter_id", real_packet->transporter_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'transporter_tile' has changed");
    DIO_PUT(sint32, &dout, "transporter_tile", real_packet->transporter_tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_LOAD);
}

int send_packet_unit_load(struct connection *pc, const struct packet_unit_load *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_LOAD].packet != NULL, -1,
                        "Handler for PACKET_UNIT_LOAD not installed");
  return pc->phs.handlers->send[PACKET_UNIT_LOAD].packet(pc, packet);
}

int dsend_packet_unit_load(struct connection *pc, int cargo_id, int transporter_id, int transporter_tile)
{
  struct packet_unit_load packet, *real_packet = &packet;

  real_packet->cargo_id = cargo_id;
  real_packet->transporter_id = transporter_id;
  real_packet->transporter_tile = transporter_tile;
  
  return send_packet_unit_load(pc, real_packet);
}

#define hash_packet_unit_unload_100 hash_const

#define cmp_packet_unit_unload_100 cmp_const

BV_DEFINE(packet_unit_unload_100_fields, 2);

static struct packet_unit_unload *receive_packet_unit_unload_100(struct connection *pc)
{
  packet_unit_unload_100_fields fields;
  struct packet_unit_unload *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_UNLOAD;
  RECEIVE_PACKET_START(packet_unit_unload, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_unload_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_unload_100, cmp_packet_unit_unload_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'cargo_id'");
    if (!DIO_GET(uint16, &din, "cargo_id", &real_packet->cargo_id)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'transporter_id'");
    if (!DIO_GET(uint16, &din, "transporter_id", &real_packet->transporter_id)) {
      RECEIVE_PACKET_FIELD_ERROR(transporter_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_unload_100(struct connection *pc, const struct packet_unit_unload *packet)
{
  const struct packet_unit_unload *real_packet = packet;
  packet_unit_unload_100_fields fields;
  struct packet_unit_unload *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_UNLOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_UNLOAD);

  log_packet_detailed("packet_unit_unload_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_unload_100, cmp_packet_unit_unload_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->cargo_id != real_packet->cargo_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->transporter_id != real_packet->transporter_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'cargo_id' has changed");
    DIO_PUT(uint16, &dout, "cargo_id", real_packet->cargo_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'transporter_id' has changed");
    DIO_PUT(uint16, &dout, "transporter_id", real_packet->transporter_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_UNLOAD);
}

int send_packet_unit_unload(struct connection *pc, const struct packet_unit_unload *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_UNLOAD].packet != NULL, -1,
                        "Handler for PACKET_UNIT_UNLOAD not installed");
  return pc->phs.handlers->send[PACKET_UNIT_UNLOAD].packet(pc, packet);
}

int dsend_packet_unit_unload(struct connection *pc, int cargo_id, int transporter_id)
{
  struct packet_unit_unload packet, *real_packet = &packet;

  real_packet->cargo_id = cargo_id;
  real_packet->transporter_id = transporter_id;
  
  return send_packet_unit_unload(pc, real_packet);
}

#define hash_packet_unit_upgrade_100 hash_const

#define cmp_packet_unit_upgrade_100 cmp_const

BV_DEFINE(packet_unit_upgrade_100_fields, 1);

static struct packet_unit_upgrade *receive_packet_unit_upgrade_100(struct connection *pc)
{
  packet_unit_upgrade_100_fields fields;
  struct packet_unit_upgrade *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_UPGRADE;
  RECEIVE_PACKET_START(packet_unit_upgrade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_upgrade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_upgrade_100, cmp_packet_unit_upgrade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_upgrade_100(struct connection *pc, const struct packet_unit_upgrade *packet)
{
  const struct packet_unit_upgrade *real_packet = packet;
  packet_unit_upgrade_100_fields fields;
  struct packet_unit_upgrade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_UPGRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_UPGRADE);

  log_packet_detailed("packet_unit_upgrade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_upgrade_100, cmp_packet_unit_upgrade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_UPGRADE);
}

int send_packet_unit_upgrade(struct connection *pc, const struct packet_unit_upgrade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_UPGRADE].packet != NULL, -1,
                        "Handler for PACKET_UNIT_UPGRADE not installed");
  return pc->phs.handlers->send[PACKET_UNIT_UPGRADE].packet(pc, packet);
}

int dsend_packet_unit_upgrade(struct connection *pc, int unit_id)
{
  struct packet_unit_upgrade packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_upgrade(pc, real_packet);
}

#define hash_packet_unit_nuke_100 hash_const

#define cmp_packet_unit_nuke_100 cmp_const

BV_DEFINE(packet_unit_nuke_100_fields, 1);

static struct packet_unit_nuke *receive_packet_unit_nuke_100(struct connection *pc)
{
  packet_unit_nuke_100_fields fields;
  struct packet_unit_nuke *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_NUKE;
  RECEIVE_PACKET_START(packet_unit_nuke, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_nuke_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_nuke_100, cmp_packet_unit_nuke_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_nuke_100(struct connection *pc, const struct packet_unit_nuke *packet)
{
  const struct packet_unit_nuke *real_packet = packet;
  packet_unit_nuke_100_fields fields;
  struct packet_unit_nuke *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_NUKE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_NUKE);

  log_packet_detailed("packet_unit_nuke_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_nuke_100, cmp_packet_unit_nuke_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_NUKE);
}

int send_packet_unit_nuke(struct connection *pc, const struct packet_unit_nuke *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_NUKE].packet != NULL, -1,
                        "Handler for PACKET_UNIT_NUKE not installed");
  return pc->phs.handlers->send[PACKET_UNIT_NUKE].packet(pc, packet);
}

int dsend_packet_unit_nuke(struct connection *pc, int unit_id)
{
  struct packet_unit_nuke packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_nuke(pc, real_packet);
}

#define hash_packet_unit_paradrop_to_100 hash_const

#define cmp_packet_unit_paradrop_to_100 cmp_const

BV_DEFINE(packet_unit_paradrop_to_100_fields, 2);

static struct packet_unit_paradrop_to *receive_packet_unit_paradrop_to_100(struct connection *pc)
{
  packet_unit_paradrop_to_100_fields fields;
  struct packet_unit_paradrop_to *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_PARADROP_TO;
  RECEIVE_PACKET_START(packet_unit_paradrop_to, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_paradrop_to_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_paradrop_to_100, cmp_packet_unit_paradrop_to_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!DIO_GET(sint32, &din, "tile", &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_paradrop_to_100(struct connection *pc, const struct packet_unit_paradrop_to *packet)
{
  const struct packet_unit_paradrop_to *real_packet = packet;
  packet_unit_paradrop_to_100_fields fields;
  struct packet_unit_paradrop_to *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_PARADROP_TO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_PARADROP_TO);

  log_packet_detailed("packet_unit_paradrop_to_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_paradrop_to_100, cmp_packet_unit_paradrop_to_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    DIO_PUT(sint32, &dout, "tile", real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_PARADROP_TO);
}

int send_packet_unit_paradrop_to(struct connection *pc, const struct packet_unit_paradrop_to *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_PARADROP_TO].packet != NULL, -1,
                        "Handler for PACKET_UNIT_PARADROP_TO not installed");
  return pc->phs.handlers->send[PACKET_UNIT_PARADROP_TO].packet(pc, packet);
}

int dsend_packet_unit_paradrop_to(struct connection *pc, int unit_id, int tile)
{
  struct packet_unit_paradrop_to packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->tile = tile;
  
  return send_packet_unit_paradrop_to(pc, real_packet);
}

#define hash_packet_unit_airlift_100 hash_const

#define cmp_packet_unit_airlift_100 cmp_const

BV_DEFINE(packet_unit_airlift_100_fields, 2);

static struct packet_unit_airlift *receive_packet_unit_airlift_100(struct connection *pc)
{
  packet_unit_airlift_100_fields fields;
  struct packet_unit_airlift *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_AIRLIFT;
  RECEIVE_PACKET_START(packet_unit_airlift, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_airlift_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_airlift_100, cmp_packet_unit_airlift_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    if (!DIO_GET(uint16, &din, "city_id", &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_airlift_100(struct connection *pc, const struct packet_unit_airlift *packet)
{
  const struct packet_unit_airlift *real_packet = packet;
  packet_unit_airlift_100_fields fields;
  struct packet_unit_airlift *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_AIRLIFT;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_AIRLIFT);

  log_packet_detailed("packet_unit_airlift_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_airlift_100, cmp_packet_unit_airlift_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    DIO_PUT(uint16, &dout, "city_id", real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_AIRLIFT);
}

int send_packet_unit_airlift(struct connection *pc, const struct packet_unit_airlift *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_AIRLIFT].packet != NULL, -1,
                        "Handler for PACKET_UNIT_AIRLIFT not installed");
  return pc->phs.handlers->send[PACKET_UNIT_AIRLIFT].packet(pc, packet);
}

int dsend_packet_unit_airlift(struct connection *pc, int unit_id, int city_id)
{
  struct packet_unit_airlift packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->city_id = city_id;
  
  return send_packet_unit_airlift(pc, real_packet);
}

#define hash_packet_unit_action_query_100 hash_const

#define cmp_packet_unit_action_query_100 cmp_const

BV_DEFINE(packet_unit_action_query_100_fields, 3);

static struct packet_unit_action_query *receive_packet_unit_action_query_100(struct connection *pc)
{
  packet_unit_action_query_100_fields fields;
  struct packet_unit_action_query *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_ACTION_QUERY;
  RECEIVE_PACKET_START(packet_unit_action_query, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_action_query_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_action_query_100, cmp_packet_unit_action_query_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!DIO_GET(uint16, &din, "diplomat_id", &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    if (!DIO_GET(uint16, &din, "target_id", &real_packet->target_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "action_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_type);
      }
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_action_query_100(struct connection *pc, const struct packet_unit_action_query *packet)
{
  const struct packet_unit_action_query *real_packet = packet;
  packet_unit_action_query_100_fields fields;
  struct packet_unit_action_query *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ACTION_QUERY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ACTION_QUERY);

  log_packet_detailed("packet_unit_action_query_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_action_query_100, cmp_packet_unit_action_query_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    DIO_PUT(uint16, &dout, "diplomat_id", real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    DIO_PUT(uint16, &dout, "target_id", real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'action_type' has changed");
    DIO_PUT(uint8, &dout, "action_type", real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_ACTION_QUERY);
}

int send_packet_unit_action_query(struct connection *pc, const struct packet_unit_action_query *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_ACTION_QUERY].packet != NULL, -1,
                        "Handler for PACKET_UNIT_ACTION_QUERY not installed");
  return pc->phs.handlers->send[PACKET_UNIT_ACTION_QUERY].packet(pc, packet);
}

int dsend_packet_unit_action_query(struct connection *pc, int diplomat_id, int target_id, enum gen_action action_type)
{
  struct packet_unit_action_query packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->action_type = action_type;
  
  return send_packet_unit_action_query(pc, real_packet);
}

#define hash_packet_unit_type_upgrade_100 hash_const

#define cmp_packet_unit_type_upgrade_100 cmp_const

BV_DEFINE(packet_unit_type_upgrade_100_fields, 1);

static struct packet_unit_type_upgrade *receive_packet_unit_type_upgrade_100(struct connection *pc)
{
  packet_unit_type_upgrade_100_fields fields;
  struct packet_unit_type_upgrade *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_TYPE_UPGRADE;
  RECEIVE_PACKET_START(packet_unit_type_upgrade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_type_upgrade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_type_upgrade_100, cmp_packet_unit_type_upgrade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_type_upgrade_100(struct connection *pc, const struct packet_unit_type_upgrade *packet)
{
  const struct packet_unit_type_upgrade *real_packet = packet;
  packet_unit_type_upgrade_100_fields fields;
  struct packet_unit_type_upgrade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_TYPE_UPGRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_TYPE_UPGRADE);

  log_packet_detailed("packet_unit_type_upgrade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_type_upgrade_100, cmp_packet_unit_type_upgrade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_TYPE_UPGRADE);
}

int send_packet_unit_type_upgrade(struct connection *pc, const struct packet_unit_type_upgrade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_TYPE_UPGRADE].packet != NULL, -1,
                        "Handler for PACKET_UNIT_TYPE_UPGRADE not installed");
  return pc->phs.handlers->send[PACKET_UNIT_TYPE_UPGRADE].packet(pc, packet);
}

int dsend_packet_unit_type_upgrade(struct connection *pc, Unit_type_id type)
{
  struct packet_unit_type_upgrade packet, *real_packet = &packet;

  real_packet->type = type;
  
  return send_packet_unit_type_upgrade(pc, real_packet);
}

#define hash_packet_unit_do_action_100 hash_const

#define cmp_packet_unit_do_action_100 cmp_const

BV_DEFINE(packet_unit_do_action_100_fields, 4);

static struct packet_unit_do_action *receive_packet_unit_do_action_100(struct connection *pc)
{
  packet_unit_do_action_100_fields fields;
  struct packet_unit_do_action *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_DO_ACTION;
  RECEIVE_PACKET_START(packet_unit_do_action, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_do_action_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_do_action_100, cmp_packet_unit_do_action_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'actor_id'");
    if (!DIO_GET(uint16, &din, "actor_id", &real_packet->actor_id)) {
      RECEIVE_PACKET_FIELD_ERROR(actor_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    if (!DIO_GET(sint32, &din, "target_id", &real_packet->target_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(sint16, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "action_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_type);
      }
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_do_action_100(struct connection *pc, const struct packet_unit_do_action *packet)
{
  const struct packet_unit_do_action *real_packet = packet;
  packet_unit_do_action_100_fields fields;
  struct packet_unit_do_action *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DO_ACTION;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DO_ACTION);

  log_packet_detailed("packet_unit_do_action_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_do_action_100, cmp_packet_unit_do_action_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->actor_id != real_packet->actor_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'actor_id' has changed");
    DIO_PUT(uint16, &dout, "actor_id", real_packet->actor_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    DIO_PUT(sint32, &dout, "target_id", real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(sint16, &dout, "value", real_packet->value);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    DIO_PUT(uint8, &dout, "action_type", real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_DO_ACTION);
}

int send_packet_unit_do_action(struct connection *pc, const struct packet_unit_do_action *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_DO_ACTION].packet != NULL, -1,
                        "Handler for PACKET_UNIT_DO_ACTION not installed");
  return pc->phs.handlers->send[PACKET_UNIT_DO_ACTION].packet(pc, packet);
}

int dsend_packet_unit_do_action(struct connection *pc, int actor_id, int target_id, int value, enum gen_action action_type)
{
  struct packet_unit_do_action packet, *real_packet = &packet;

  real_packet->actor_id = actor_id;
  real_packet->target_id = target_id;
  real_packet->value = value;
  real_packet->action_type = action_type;
  
  return send_packet_unit_do_action(pc, real_packet);
}

#define hash_packet_unit_action_answer_100 hash_const

#define cmp_packet_unit_action_answer_100 cmp_const

BV_DEFINE(packet_unit_action_answer_100_fields, 4);

static struct packet_unit_action_answer *receive_packet_unit_action_answer_100(struct connection *pc)
{
  packet_unit_action_answer_100_fields fields;
  struct packet_unit_action_answer *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_ACTION_ANSWER;
  RECEIVE_PACKET_START(packet_unit_action_answer, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_action_answer_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_action_answer_100, cmp_packet_unit_action_answer_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!DIO_GET(uint16, &din, "diplomat_id", &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    if (!DIO_GET(uint16, &din, "target_id", &real_packet->target_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'cost'");
    if (!DIO_GET(uint32, &din, "cost", &real_packet->cost)) {
      RECEIVE_PACKET_FIELD_ERROR(cost);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "action_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_type);
      }
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_action_answer_100(struct connection *pc, const struct packet_unit_action_answer *packet)
{
  const struct packet_unit_action_answer *real_packet = packet;
  packet_unit_action_answer_100_fields fields;
  struct packet_unit_action_answer *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ACTION_ANSWER;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ACTION_ANSWER);

  log_packet_detailed("packet_unit_action_answer_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_action_answer_100, cmp_packet_unit_action_answer_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->cost != real_packet->cost);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    DIO_PUT(uint16, &dout, "diplomat_id", real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    DIO_PUT(uint16, &dout, "target_id", real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'cost' has changed");
    DIO_PUT(uint32, &dout, "cost", real_packet->cost);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    DIO_PUT(uint8, &dout, "action_type", real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_ACTION_ANSWER);
}

int send_packet_unit_action_answer(struct connection *pc, const struct packet_unit_action_answer *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_ACTION_ANSWER].packet != NULL, -1,
                        "Handler for PACKET_UNIT_ACTION_ANSWER not installed");
  return pc->phs.handlers->send[PACKET_UNIT_ACTION_ANSWER].packet(pc, packet);
}

int dsend_packet_unit_action_answer(struct connection *pc, int diplomat_id, int target_id, int cost, enum gen_action action_type)
{
  struct packet_unit_action_answer packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->cost = cost;
  real_packet->action_type = action_type;
  
  return send_packet_unit_action_answer(pc, real_packet);
}

#define hash_packet_unit_get_actions_100 hash_const

#define cmp_packet_unit_get_actions_100 cmp_const

BV_DEFINE(packet_unit_get_actions_100_fields, 5);

static struct packet_unit_get_actions *receive_packet_unit_get_actions_100(struct connection *pc)
{
  packet_unit_get_actions_100_fields fields;
  struct packet_unit_get_actions *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_GET_ACTIONS;
  RECEIVE_PACKET_START(packet_unit_get_actions, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_get_actions_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_get_actions_100, cmp_packet_unit_get_actions_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'actor_unit_id'");
    if (!DIO_GET(uint16, &din, "actor_unit_id", &real_packet->actor_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(actor_unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_unit_id'");
    if (!DIO_GET(uint16, &din, "target_unit_id", &real_packet->target_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_unit_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'target_city_id'");
    if (!DIO_GET(uint16, &din, "target_city_id", &real_packet->target_city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_city_id);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'target_tile_id'");
    if (!DIO_GET(sint32, &din, "target_tile_id", &real_packet->target_tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_tile_id);
    }
  }
  real_packet->disturb_player = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_get_actions_100(struct connection *pc, const struct packet_unit_get_actions *packet)
{
  const struct packet_unit_get_actions *real_packet = packet;
  packet_unit_get_actions_100_fields fields;
  struct packet_unit_get_actions *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_GET_ACTIONS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_GET_ACTIONS);

  log_packet_detailed("packet_unit_get_actions_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_get_actions_100, cmp_packet_unit_get_actions_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->actor_unit_id != real_packet->actor_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_unit_id != real_packet->target_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->target_city_id != real_packet->target_city_id);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->target_tile_id != real_packet->target_tile_id);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->disturb_player != real_packet->disturb_player);
  if(differ) {
    different++;
  }
  if (packet->disturb_player) {
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'actor_unit_id' has changed");
    DIO_PUT(uint16, &dout, "actor_unit_id", real_packet->actor_unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_unit_id' has changed");
    DIO_PUT(uint16, &dout, "target_unit_id", real_packet->target_unit_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'target_city_id' has changed");
    DIO_PUT(uint16, &dout, "target_city_id", real_packet->target_city_id);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'target_tile_id' has changed");
    DIO_PUT(sint32, &dout, "target_tile_id", real_packet->target_tile_id);
  }
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_GET_ACTIONS);
}

int send_packet_unit_get_actions(struct connection *pc, const struct packet_unit_get_actions *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_GET_ACTIONS].packet != NULL, -1,
                        "Handler for PACKET_UNIT_GET_ACTIONS not installed");
  return pc->phs.handlers->send[PACKET_UNIT_GET_ACTIONS].packet(pc, packet);
}

int dsend_packet_unit_get_actions(struct connection *pc, int actor_unit_id, int target_unit_id, int target_city_id, int target_tile_id, bool disturb_player)
{
  struct packet_unit_get_actions packet, *real_packet = &packet;

  real_packet->actor_unit_id = actor_unit_id;
  real_packet->target_unit_id = target_unit_id;
  real_packet->target_city_id = target_city_id;
  real_packet->target_tile_id = target_tile_id;
  real_packet->disturb_player = disturb_player;
  
  return send_packet_unit_get_actions(pc, real_packet);
}

#define hash_packet_unit_actions_100 hash_const

#define cmp_packet_unit_actions_100 cmp_const

BV_DEFINE(packet_unit_actions_100_fields, 6);

static struct packet_unit_actions *receive_packet_unit_actions_100(struct connection *pc)
{
  packet_unit_actions_100_fields fields;
  struct packet_unit_actions *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_ACTIONS;
  RECEIVE_PACKET_START(packet_unit_actions, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_actions_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_actions_100, cmp_packet_unit_actions_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'actor_unit_id'");
    if (!DIO_GET(uint16, &din, "actor_unit_id", &real_packet->actor_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(actor_unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_unit_id'");
    if (!DIO_GET(uint16, &din, "target_unit_id", &real_packet->target_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_unit_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'target_city_id'");
    if (!DIO_GET(uint16, &din, "target_city_id", &real_packet->target_city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_city_id);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'target_tile_id'");
    if (!DIO_GET(sint32, &din, "target_tile_id", &real_packet->target_tile_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_tile_id);
    }
  }
  real_packet->disturb_player = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'action_probabilities'");
    
    {
      int i;
    
      for (i = 0; i < ACTION_COUNT; i++) {
        if (!DIO_GET(action_probability, &din, "action_probabilities", &real_packet->action_probabilities[i])) {
          RECEIVE_PACKET_FIELD_ERROR(action_probabilities);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_actions_100(struct connection *pc, const struct packet_unit_actions *packet)
{
  const struct packet_unit_actions *real_packet = packet;
  packet_unit_actions_100_fields fields;
  struct packet_unit_actions *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ACTIONS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ACTIONS);

  log_packet_detailed("packet_unit_actions_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_actions_100, cmp_packet_unit_actions_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->actor_unit_id != real_packet->actor_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_unit_id != real_packet->target_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->target_city_id != real_packet->target_city_id);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->target_tile_id != real_packet->target_tile_id);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->disturb_player != real_packet->disturb_player);
  if(differ) {
    different++;
  }
  if (packet->disturb_player) {
    BV_SET(fields, 4);
  }


    {
      differ = (ACTION_COUNT != ACTION_COUNT);
      if(!differ) {
        int i;
        for (i = 0; i < ACTION_COUNT; i++) {
          if (!are_action_probabilitys_equal(&old->action_probabilities[i], &real_packet->action_probabilities[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'actor_unit_id' has changed");
    DIO_PUT(uint16, &dout, "actor_unit_id", real_packet->actor_unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_unit_id' has changed");
    DIO_PUT(uint16, &dout, "target_unit_id", real_packet->target_unit_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'target_city_id' has changed");
    DIO_PUT(uint16, &dout, "target_city_id", real_packet->target_city_id);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'target_tile_id' has changed");
    DIO_PUT(sint32, &dout, "target_tile_id", real_packet->target_tile_id);
  }
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'action_probabilities' has changed");
  
    {
      int i;

      for (i = 0; i < ACTION_COUNT; i++) {
        dio_put_action_probability(&dout, &real_packet->action_probabilities[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_ACTIONS);
}

int send_packet_unit_actions(struct connection *pc, const struct packet_unit_actions *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_ACTIONS].packet != NULL, -1,
                        "Handler for PACKET_UNIT_ACTIONS not installed");
  return pc->phs.handlers->send[PACKET_UNIT_ACTIONS].packet(pc, packet);
}

int dsend_packet_unit_actions(struct connection *pc, int actor_unit_id, int target_unit_id, int target_city_id, int target_tile_id, bool disturb_player, const struct act_prob *action_probabilities)
{
  struct packet_unit_actions packet, *real_packet = &packet;

  real_packet->actor_unit_id = actor_unit_id;
  real_packet->target_unit_id = target_unit_id;
  real_packet->target_city_id = target_city_id;
  real_packet->target_tile_id = target_tile_id;
  real_packet->disturb_player = disturb_player;
  {
    int i;

    for (i = 0; i < ACTION_COUNT; i++) {
      real_packet->action_probabilities[i] = action_probabilities[i];
    }
  }
  
  return send_packet_unit_actions(pc, real_packet);
}

#define hash_packet_unit_change_activity_100 hash_const

#define cmp_packet_unit_change_activity_100 cmp_const

BV_DEFINE(packet_unit_change_activity_100_fields, 3);

static struct packet_unit_change_activity *receive_packet_unit_change_activity_100(struct connection *pc)
{
  packet_unit_change_activity_100_fields fields;
  struct packet_unit_change_activity *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_CHANGE_ACTIVITY;
  RECEIVE_PACKET_START(packet_unit_change_activity, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_activity_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_100, cmp_packet_unit_change_activity_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!DIO_GET(uint16, &din, "unit_id", &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "activity", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'target'");
    if (!DIO_GET(sint8, &din, "target", &real_packet->target)) {
      RECEIVE_PACKET_FIELD_ERROR(target);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_activity_100(struct connection *pc, const struct packet_unit_change_activity *packet)
{
  const struct packet_unit_change_activity *real_packet = packet;
  packet_unit_change_activity_100_fields fields;
  struct packet_unit_change_activity *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_ACTIVITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_ACTIVITY);

  log_packet_detailed("packet_unit_change_activity_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_100, cmp_packet_unit_change_activity_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->target != real_packet->target);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    DIO_PUT(uint16, &dout, "unit_id", real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'activity' has changed");
    DIO_PUT(uint8, &dout, "activity", real_packet->activity);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'target' has changed");
    DIO_PUT(sint8, &dout, "target", real_packet->target);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_CHANGE_ACTIVITY);
}

int send_packet_unit_change_activity(struct connection *pc, const struct packet_unit_change_activity *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_UNIT_CHANGE_ACTIVITY].packet != NULL, -1,
                        "Handler for PACKET_UNIT_CHANGE_ACTIVITY not installed");
  return pc->phs.handlers->send[PACKET_UNIT_CHANGE_ACTIVITY].packet(pc, packet);
}

int dsend_packet_unit_change_activity(struct connection *pc, int unit_id, enum unit_activity activity, int target)
{
  struct packet_unit_change_activity packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->activity = activity;
  real_packet->target = target;
  
  return send_packet_unit_change_activity(pc, real_packet);
}

#define hash_packet_diplomacy_init_meeting_req_100 hash_const

#define cmp_packet_diplomacy_init_meeting_req_100 cmp_const

BV_DEFINE(packet_diplomacy_init_meeting_req_100_fields, 1);

static struct packet_diplomacy_init_meeting_req *receive_packet_diplomacy_init_meeting_req_100(struct connection *pc)
{
  packet_diplomacy_init_meeting_req_100_fields fields;
  struct packet_diplomacy_init_meeting_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_INIT_MEETING_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_init_meeting_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_init_meeting_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_req_100, cmp_packet_diplomacy_init_meeting_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_init_meeting_req_100(struct connection *pc, const struct packet_diplomacy_init_meeting_req *packet)
{
  const struct packet_diplomacy_init_meeting_req *real_packet = packet;
  packet_diplomacy_init_meeting_req_100_fields fields;
  struct packet_diplomacy_init_meeting_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_INIT_MEETING_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_INIT_MEETING_REQ);

  log_packet_detailed("packet_diplomacy_init_meeting_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_req_100, cmp_packet_diplomacy_init_meeting_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_INIT_MEETING_REQ);
}

int send_packet_diplomacy_init_meeting_req(struct connection *pc, const struct packet_diplomacy_init_meeting_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_INIT_MEETING_REQ].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_INIT_MEETING_REQ not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_INIT_MEETING_REQ].packet(pc, packet);
}

int dsend_packet_diplomacy_init_meeting_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_init_meeting_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_init_meeting_req(pc, real_packet);
}

#define hash_packet_diplomacy_init_meeting_100 hash_const

#define cmp_packet_diplomacy_init_meeting_100 cmp_const

BV_DEFINE(packet_diplomacy_init_meeting_100_fields, 2);

static struct packet_diplomacy_init_meeting *receive_packet_diplomacy_init_meeting_100(struct connection *pc)
{
  packet_diplomacy_init_meeting_100_fields fields;
  struct packet_diplomacy_init_meeting *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_INIT_MEETING;
  RECEIVE_PACKET_START(packet_diplomacy_init_meeting, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_init_meeting_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_100, cmp_packet_diplomacy_init_meeting_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'initiated_from'");
    if (!DIO_GET(uint8, &din, "initiated_from", &real_packet->initiated_from)) {
      RECEIVE_PACKET_FIELD_ERROR(initiated_from);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_init_meeting_100(struct connection *pc, const struct packet_diplomacy_init_meeting *packet)
{
  const struct packet_diplomacy_init_meeting *real_packet = packet;
  packet_diplomacy_init_meeting_100_fields fields;
  struct packet_diplomacy_init_meeting *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_INIT_MEETING;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_INIT_MEETING);

  log_packet_detailed("packet_diplomacy_init_meeting_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_100, cmp_packet_diplomacy_init_meeting_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->initiated_from != real_packet->initiated_from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'initiated_from' has changed");
    DIO_PUT(uint8, &dout, "initiated_from", real_packet->initiated_from);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_INIT_MEETING);
}

int send_packet_diplomacy_init_meeting(struct connection *pc, const struct packet_diplomacy_init_meeting *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_INIT_MEETING].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_INIT_MEETING not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_INIT_MEETING].packet(pc, packet);
}

void lsend_packet_diplomacy_init_meeting(struct conn_list *dest, const struct packet_diplomacy_init_meeting *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_init_meeting(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_init_meeting(struct connection *pc, int counterpart, int initiated_from)
{
  struct packet_diplomacy_init_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  return send_packet_diplomacy_init_meeting(pc, real_packet);
}

void dlsend_packet_diplomacy_init_meeting(struct conn_list *dest, int counterpart, int initiated_from)
{
  struct packet_diplomacy_init_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  lsend_packet_diplomacy_init_meeting(dest, real_packet);
}

#define hash_packet_diplomacy_cancel_meeting_req_100 hash_const

#define cmp_packet_diplomacy_cancel_meeting_req_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_meeting_req_100_fields, 1);

static struct packet_diplomacy_cancel_meeting_req *receive_packet_diplomacy_cancel_meeting_req_100(struct connection *pc)
{
  packet_diplomacy_cancel_meeting_req_100_fields fields;
  struct packet_diplomacy_cancel_meeting_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CANCEL_MEETING_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_meeting_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_meeting_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_req_100, cmp_packet_diplomacy_cancel_meeting_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_meeting_req_100(struct connection *pc, const struct packet_diplomacy_cancel_meeting_req *packet)
{
  const struct packet_diplomacy_cancel_meeting_req *real_packet = packet;
  packet_diplomacy_cancel_meeting_req_100_fields fields;
  struct packet_diplomacy_cancel_meeting_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_MEETING_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_MEETING_REQ);

  log_packet_detailed("packet_diplomacy_cancel_meeting_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_req_100, cmp_packet_diplomacy_cancel_meeting_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CANCEL_MEETING_REQ);
}

int send_packet_diplomacy_cancel_meeting_req(struct connection *pc, const struct packet_diplomacy_cancel_meeting_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_CANCEL_MEETING_REQ].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_CANCEL_MEETING_REQ not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_CANCEL_MEETING_REQ].packet(pc, packet);
}

int dsend_packet_diplomacy_cancel_meeting_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_cancel_meeting_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_cancel_meeting_req(pc, real_packet);
}

#define hash_packet_diplomacy_cancel_meeting_100 hash_const

#define cmp_packet_diplomacy_cancel_meeting_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_meeting_100_fields, 2);

static struct packet_diplomacy_cancel_meeting *receive_packet_diplomacy_cancel_meeting_100(struct connection *pc)
{
  packet_diplomacy_cancel_meeting_100_fields fields;
  struct packet_diplomacy_cancel_meeting *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CANCEL_MEETING;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_meeting, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_meeting_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_100, cmp_packet_diplomacy_cancel_meeting_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'initiated_from'");
    if (!DIO_GET(uint8, &din, "initiated_from", &real_packet->initiated_from)) {
      RECEIVE_PACKET_FIELD_ERROR(initiated_from);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_meeting_100(struct connection *pc, const struct packet_diplomacy_cancel_meeting *packet)
{
  const struct packet_diplomacy_cancel_meeting *real_packet = packet;
  packet_diplomacy_cancel_meeting_100_fields fields;
  struct packet_diplomacy_cancel_meeting *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_MEETING;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_MEETING);

  log_packet_detailed("packet_diplomacy_cancel_meeting_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_100, cmp_packet_diplomacy_cancel_meeting_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->initiated_from != real_packet->initiated_from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'initiated_from' has changed");
    DIO_PUT(uint8, &dout, "initiated_from", real_packet->initiated_from);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CANCEL_MEETING);
}

int send_packet_diplomacy_cancel_meeting(struct connection *pc, const struct packet_diplomacy_cancel_meeting *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_CANCEL_MEETING].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_CANCEL_MEETING not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_CANCEL_MEETING].packet(pc, packet);
}

void lsend_packet_diplomacy_cancel_meeting(struct conn_list *dest, const struct packet_diplomacy_cancel_meeting *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_cancel_meeting(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_cancel_meeting(struct connection *pc, int counterpart, int initiated_from)
{
  struct packet_diplomacy_cancel_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  return send_packet_diplomacy_cancel_meeting(pc, real_packet);
}

void dlsend_packet_diplomacy_cancel_meeting(struct conn_list *dest, int counterpart, int initiated_from)
{
  struct packet_diplomacy_cancel_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  lsend_packet_diplomacy_cancel_meeting(dest, real_packet);
}

#define hash_packet_diplomacy_create_clause_req_100 hash_const

#define cmp_packet_diplomacy_create_clause_req_100 cmp_const

BV_DEFINE(packet_diplomacy_create_clause_req_100_fields, 4);

static struct packet_diplomacy_create_clause_req *receive_packet_diplomacy_create_clause_req_100(struct connection *pc)
{
  packet_diplomacy_create_clause_req_100_fields fields;
  struct packet_diplomacy_create_clause_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CREATE_CLAUSE_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_create_clause_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_create_clause_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_req_100, cmp_packet_diplomacy_create_clause_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!DIO_GET(uint8, &din, "giver", &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(uint32, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_create_clause_req_100(struct connection *pc, const struct packet_diplomacy_create_clause_req *packet)
{
  const struct packet_diplomacy_create_clause_req *real_packet = packet;
  packet_diplomacy_create_clause_req_100_fields fields;
  struct packet_diplomacy_create_clause_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CREATE_CLAUSE_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CREATE_CLAUSE_REQ);

  log_packet_detailed("packet_diplomacy_create_clause_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_req_100, cmp_packet_diplomacy_create_clause_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    DIO_PUT(uint8, &dout, "giver", real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(uint32, &dout, "value", real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CREATE_CLAUSE_REQ);
}

int send_packet_diplomacy_create_clause_req(struct connection *pc, const struct packet_diplomacy_create_clause_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_CREATE_CLAUSE_REQ not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ].packet(pc, packet);
}

int dsend_packet_diplomacy_create_clause_req(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_create_clause_req(pc, real_packet);
}

#define hash_packet_diplomacy_create_clause_100 hash_const

#define cmp_packet_diplomacy_create_clause_100 cmp_const

BV_DEFINE(packet_diplomacy_create_clause_100_fields, 4);

static struct packet_diplomacy_create_clause *receive_packet_diplomacy_create_clause_100(struct connection *pc)
{
  packet_diplomacy_create_clause_100_fields fields;
  struct packet_diplomacy_create_clause *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CREATE_CLAUSE;
  RECEIVE_PACKET_START(packet_diplomacy_create_clause, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_create_clause_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_100, cmp_packet_diplomacy_create_clause_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!DIO_GET(uint8, &din, "giver", &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(uint32, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_create_clause_100(struct connection *pc, const struct packet_diplomacy_create_clause *packet)
{
  const struct packet_diplomacy_create_clause *real_packet = packet;
  packet_diplomacy_create_clause_100_fields fields;
  struct packet_diplomacy_create_clause *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CREATE_CLAUSE;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CREATE_CLAUSE);

  log_packet_detailed("packet_diplomacy_create_clause_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_100, cmp_packet_diplomacy_create_clause_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    DIO_PUT(uint8, &dout, "giver", real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(uint32, &dout, "value", real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CREATE_CLAUSE);
}

int send_packet_diplomacy_create_clause(struct connection *pc, const struct packet_diplomacy_create_clause *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_CREATE_CLAUSE].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_CREATE_CLAUSE not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_CREATE_CLAUSE].packet(pc, packet);
}

void lsend_packet_diplomacy_create_clause(struct conn_list *dest, const struct packet_diplomacy_create_clause *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_create_clause(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_create_clause(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_create_clause(pc, real_packet);
}

void dlsend_packet_diplomacy_create_clause(struct conn_list *dest, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  lsend_packet_diplomacy_create_clause(dest, real_packet);
}

#define hash_packet_diplomacy_remove_clause_req_100 hash_const

#define cmp_packet_diplomacy_remove_clause_req_100 cmp_const

BV_DEFINE(packet_diplomacy_remove_clause_req_100_fields, 4);

static struct packet_diplomacy_remove_clause_req *receive_packet_diplomacy_remove_clause_req_100(struct connection *pc)
{
  packet_diplomacy_remove_clause_req_100_fields fields;
  struct packet_diplomacy_remove_clause_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_remove_clause_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_remove_clause_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_req_100, cmp_packet_diplomacy_remove_clause_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!DIO_GET(uint8, &din, "giver", &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(uint32, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_remove_clause_req_100(struct connection *pc, const struct packet_diplomacy_remove_clause_req *packet)
{
  const struct packet_diplomacy_remove_clause_req *real_packet = packet;
  packet_diplomacy_remove_clause_req_100_fields fields;
  struct packet_diplomacy_remove_clause_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ);

  log_packet_detailed("packet_diplomacy_remove_clause_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_req_100, cmp_packet_diplomacy_remove_clause_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    DIO_PUT(uint8, &dout, "giver", real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(uint32, &dout, "value", real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ);
}

int send_packet_diplomacy_remove_clause_req(struct connection *pc, const struct packet_diplomacy_remove_clause_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ].packet(pc, packet);
}

int dsend_packet_diplomacy_remove_clause_req(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_remove_clause_req(pc, real_packet);
}

#define hash_packet_diplomacy_remove_clause_100 hash_const

#define cmp_packet_diplomacy_remove_clause_100 cmp_const

BV_DEFINE(packet_diplomacy_remove_clause_100_fields, 4);

static struct packet_diplomacy_remove_clause *receive_packet_diplomacy_remove_clause_100(struct connection *pc)
{
  packet_diplomacy_remove_clause_100_fields fields;
  struct packet_diplomacy_remove_clause *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_REMOVE_CLAUSE;
  RECEIVE_PACKET_START(packet_diplomacy_remove_clause, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_remove_clause_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_100, cmp_packet_diplomacy_remove_clause_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!DIO_GET(uint8, &din, "giver", &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(uint32, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_remove_clause_100(struct connection *pc, const struct packet_diplomacy_remove_clause *packet)
{
  const struct packet_diplomacy_remove_clause *real_packet = packet;
  packet_diplomacy_remove_clause_100_fields fields;
  struct packet_diplomacy_remove_clause *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_REMOVE_CLAUSE;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_REMOVE_CLAUSE);

  log_packet_detailed("packet_diplomacy_remove_clause_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_100, cmp_packet_diplomacy_remove_clause_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    DIO_PUT(uint8, &dout, "giver", real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(uint32, &dout, "value", real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_REMOVE_CLAUSE);
}

int send_packet_diplomacy_remove_clause(struct connection *pc, const struct packet_diplomacy_remove_clause *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_REMOVE_CLAUSE].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_REMOVE_CLAUSE not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_REMOVE_CLAUSE].packet(pc, packet);
}

void lsend_packet_diplomacy_remove_clause(struct conn_list *dest, const struct packet_diplomacy_remove_clause *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_remove_clause(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_remove_clause(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_remove_clause(pc, real_packet);
}

void dlsend_packet_diplomacy_remove_clause(struct conn_list *dest, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  lsend_packet_diplomacy_remove_clause(dest, real_packet);
}

#define hash_packet_diplomacy_accept_treaty_req_100 hash_const

#define cmp_packet_diplomacy_accept_treaty_req_100 cmp_const

BV_DEFINE(packet_diplomacy_accept_treaty_req_100_fields, 1);

static struct packet_diplomacy_accept_treaty_req *receive_packet_diplomacy_accept_treaty_req_100(struct connection *pc)
{
  packet_diplomacy_accept_treaty_req_100_fields fields;
  struct packet_diplomacy_accept_treaty_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_ACCEPT_TREATY_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_accept_treaty_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_accept_treaty_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_req_100, cmp_packet_diplomacy_accept_treaty_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_accept_treaty_req_100(struct connection *pc, const struct packet_diplomacy_accept_treaty_req *packet)
{
  const struct packet_diplomacy_accept_treaty_req *real_packet = packet;
  packet_diplomacy_accept_treaty_req_100_fields fields;
  struct packet_diplomacy_accept_treaty_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_ACCEPT_TREATY_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_ACCEPT_TREATY_REQ);

  log_packet_detailed("packet_diplomacy_accept_treaty_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_req_100, cmp_packet_diplomacy_accept_treaty_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_ACCEPT_TREATY_REQ);
}

int send_packet_diplomacy_accept_treaty_req(struct connection *pc, const struct packet_diplomacy_accept_treaty_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_ACCEPT_TREATY_REQ not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ].packet(pc, packet);
}

int dsend_packet_diplomacy_accept_treaty_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_accept_treaty_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_accept_treaty_req(pc, real_packet);
}

#define hash_packet_diplomacy_accept_treaty_100 hash_const

#define cmp_packet_diplomacy_accept_treaty_100 cmp_const

BV_DEFINE(packet_diplomacy_accept_treaty_100_fields, 3);

static struct packet_diplomacy_accept_treaty *receive_packet_diplomacy_accept_treaty_100(struct connection *pc)
{
  packet_diplomacy_accept_treaty_100_fields fields;
  struct packet_diplomacy_accept_treaty *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_ACCEPT_TREATY;
  RECEIVE_PACKET_START(packet_diplomacy_accept_treaty, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_accept_treaty_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_100, cmp_packet_diplomacy_accept_treaty_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!DIO_GET(uint8, &din, "counterpart", &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  real_packet->I_accepted = BV_ISSET(fields, 1);
  real_packet->other_accepted = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_accept_treaty_100(struct connection *pc, const struct packet_diplomacy_accept_treaty *packet)
{
  const struct packet_diplomacy_accept_treaty *real_packet = packet;
  packet_diplomacy_accept_treaty_100_fields fields;
  struct packet_diplomacy_accept_treaty *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_ACCEPT_TREATY;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_ACCEPT_TREATY);

  log_packet_detailed("packet_diplomacy_accept_treaty_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_100, cmp_packet_diplomacy_accept_treaty_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->I_accepted != real_packet->I_accepted);
  if(differ) {
    different++;
  }
  if (packet->I_accepted) {
    BV_SET(fields, 1);
  }

  differ = (old->other_accepted != real_packet->other_accepted);
  if(differ) {
    different++;
  }
  if (packet->other_accepted) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    DIO_PUT(uint8, &dout, "counterpart", real_packet->counterpart);
  }
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_ACCEPT_TREATY);
}

int send_packet_diplomacy_accept_treaty(struct connection *pc, const struct packet_diplomacy_accept_treaty *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_ACCEPT_TREATY].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_ACCEPT_TREATY not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_ACCEPT_TREATY].packet(pc, packet);
}

void lsend_packet_diplomacy_accept_treaty(struct conn_list *dest, const struct packet_diplomacy_accept_treaty *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_accept_treaty(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_accept_treaty(struct connection *pc, int counterpart, bool I_accepted, bool other_accepted)
{
  struct packet_diplomacy_accept_treaty packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->I_accepted = I_accepted;
  real_packet->other_accepted = other_accepted;
  
  return send_packet_diplomacy_accept_treaty(pc, real_packet);
}

void dlsend_packet_diplomacy_accept_treaty(struct conn_list *dest, int counterpart, bool I_accepted, bool other_accepted)
{
  struct packet_diplomacy_accept_treaty packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->I_accepted = I_accepted;
  real_packet->other_accepted = other_accepted;
  
  lsend_packet_diplomacy_accept_treaty(dest, real_packet);
}

#define hash_packet_diplomacy_cancel_pact_100 hash_const

#define cmp_packet_diplomacy_cancel_pact_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_pact_100_fields, 2);

static struct packet_diplomacy_cancel_pact *receive_packet_diplomacy_cancel_pact_100(struct connection *pc)
{
  packet_diplomacy_cancel_pact_100_fields fields;
  struct packet_diplomacy_cancel_pact *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CANCEL_PACT;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_pact, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_pact_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_pact_100, cmp_packet_diplomacy_cancel_pact_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'other_player_id'");
    if (!DIO_GET(uint8, &din, "other_player_id", &real_packet->other_player_id)) {
      RECEIVE_PACKET_FIELD_ERROR(other_player_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'clause'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "clause", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(clause);
      }
      real_packet->clause = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_pact_100(struct connection *pc, const struct packet_diplomacy_cancel_pact *packet)
{
  const struct packet_diplomacy_cancel_pact *real_packet = packet;
  packet_diplomacy_cancel_pact_100_fields fields;
  struct packet_diplomacy_cancel_pact *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_PACT;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_PACT);

  log_packet_detailed("packet_diplomacy_cancel_pact_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_pact_100, cmp_packet_diplomacy_cancel_pact_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->other_player_id != real_packet->other_player_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->clause != real_packet->clause);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'other_player_id' has changed");
    DIO_PUT(uint8, &dout, "other_player_id", real_packet->other_player_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'clause' has changed");
    DIO_PUT(uint8, &dout, "clause", real_packet->clause);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CANCEL_PACT);
}

int send_packet_diplomacy_cancel_pact(struct connection *pc, const struct packet_diplomacy_cancel_pact *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_DIPLOMACY_CANCEL_PACT].packet != NULL, -1,
                        "Handler for PACKET_DIPLOMACY_CANCEL_PACT not installed");
  return pc->phs.handlers->send[PACKET_DIPLOMACY_CANCEL_PACT].packet(pc, packet);
}

int dsend_packet_diplomacy_cancel_pact(struct connection *pc, int other_player_id, enum clause_type clause)
{
  struct packet_diplomacy_cancel_pact packet, *real_packet = &packet;

  real_packet->other_player_id = other_player_id;
  real_packet->clause = clause;
  
  return send_packet_diplomacy_cancel_pact(pc, real_packet);
}

#define hash_packet_page_msg_100 hash_const

#define cmp_packet_page_msg_100 cmp_const

BV_DEFINE(packet_page_msg_100_fields, 5);

static struct packet_page_msg *receive_packet_page_msg_100(struct connection *pc)
{
  packet_page_msg_100_fields fields;
  struct packet_page_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_PAGE_MSG;
  RECEIVE_PACKET_START(packet_page_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_page_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_100, cmp_packet_page_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'caption'");
    if (!DIO_GET(string, &din, "caption", real_packet->caption, sizeof(real_packet->caption))) {
      RECEIVE_PACKET_FIELD_ERROR(caption);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'headline'");
    if (!DIO_GET(string, &din, "headline", real_packet->headline, sizeof(real_packet->headline))) {
      RECEIVE_PACKET_FIELD_ERROR(headline);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "event", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'len'");
    if (!DIO_GET(uint32, &din, "len", &real_packet->len)) {
      RECEIVE_PACKET_FIELD_ERROR(len);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'parts'");
    if (!DIO_GET(uint16, &din, "parts", &real_packet->parts)) {
      RECEIVE_PACKET_FIELD_ERROR(parts);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_page_msg_100(struct connection *pc, const struct packet_page_msg *packet)
{
  const struct packet_page_msg *real_packet = packet;
  packet_page_msg_100_fields fields;
  struct packet_page_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PAGE_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_PAGE_MSG);

  log_packet_detailed("packet_page_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_100, cmp_packet_page_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->caption, real_packet->caption) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->headline, real_packet->headline) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->len != real_packet->len);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->parts != real_packet->parts);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'caption' has changed");
    DIO_PUT(string, &dout, "caption", real_packet->caption);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'headline' has changed");
    DIO_PUT(string, &dout, "headline", real_packet->headline);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
    DIO_PUT(sint16, &dout, "event", real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'len' has changed");
    DIO_PUT(uint32, &dout, "len", real_packet->len);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'parts' has changed");
    DIO_PUT(uint16, &dout, "parts", real_packet->parts);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PAGE_MSG);
}

int send_packet_page_msg(struct connection *pc, const struct packet_page_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PAGE_MSG].packet != NULL, -1,
                        "Handler for PACKET_PAGE_MSG not installed");
  return pc->phs.handlers->send[PACKET_PAGE_MSG].packet(pc, packet);
}

void lsend_packet_page_msg(struct conn_list *dest, const struct packet_page_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_page_msg(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_page_msg_part_100 hash_const

#define cmp_packet_page_msg_part_100 cmp_const

BV_DEFINE(packet_page_msg_part_100_fields, 1);

static struct packet_page_msg_part *receive_packet_page_msg_part_100(struct connection *pc)
{
  packet_page_msg_part_100_fields fields;
  struct packet_page_msg_part *old;
  struct genhash **hash = pc->phs.received + PACKET_PAGE_MSG_PART;
  RECEIVE_PACKET_START(packet_page_msg_part, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_page_msg_part_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_part_100, cmp_packet_page_msg_part_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'lines'");
    if (!DIO_GET(string, &din, "lines", real_packet->lines, sizeof(real_packet->lines))) {
      RECEIVE_PACKET_FIELD_ERROR(lines);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_page_msg_part_100(struct connection *pc, const struct packet_page_msg_part *packet)
{
  const struct packet_page_msg_part *real_packet = packet;
  packet_page_msg_part_100_fields fields;
  struct packet_page_msg_part *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PAGE_MSG_PART;
  int different = 0;
  SEND_PACKET_START(PACKET_PAGE_MSG_PART);

  log_packet_detailed("packet_page_msg_part_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_part_100, cmp_packet_page_msg_part_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->lines, real_packet->lines) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'lines' has changed");
    DIO_PUT(string, &dout, "lines", real_packet->lines);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PAGE_MSG_PART);
}

int send_packet_page_msg_part(struct connection *pc, const struct packet_page_msg_part *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_PAGE_MSG_PART].packet != NULL, -1,
                        "Handler for PACKET_PAGE_MSG_PART not installed");
  return pc->phs.handlers->send[PACKET_PAGE_MSG_PART].packet(pc, packet);
}

void lsend_packet_page_msg_part(struct conn_list *dest, const struct packet_page_msg_part *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_page_msg_part(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_report_req_100 hash_const

#define cmp_packet_report_req_100 cmp_const

BV_DEFINE(packet_report_req_100_fields, 1);

static struct packet_report_req *receive_packet_report_req_100(struct connection *pc)
{
  packet_report_req_100_fields fields;
  struct packet_report_req *old;
  struct genhash **hash = pc->phs.received + PACKET_REPORT_REQ;
  RECEIVE_PACKET_START(packet_report_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_report_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_report_req_100, cmp_packet_report_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_report_req_100(struct connection *pc, const struct packet_report_req *packet)
{
  const struct packet_report_req *real_packet = packet;
  packet_report_req_100_fields fields;
  struct packet_report_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_REPORT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_REPORT_REQ);

  log_packet_detailed("packet_report_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_report_req_100, cmp_packet_report_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_REPORT_REQ);
}

int send_packet_report_req(struct connection *pc, const struct packet_report_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_REPORT_REQ].packet != NULL, -1,
                        "Handler for PACKET_REPORT_REQ not installed");
  return pc->phs.handlers->send[PACKET_REPORT_REQ].packet(pc, packet);
}

int dsend_packet_report_req(struct connection *pc, enum report_type type)
{
  struct packet_report_req packet, *real_packet = &packet;

  real_packet->type = type;
  
  return send_packet_report_req(pc, real_packet);
}

static genhash_val_t hash_packet_conn_info_100(const void *vkey)
{
  const struct packet_conn_info *key = (const struct packet_conn_info *) vkey;

  return key->id;
}

static bool cmp_packet_conn_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_conn_info *key1 = (const struct packet_conn_info *) vkey1;
  const struct packet_conn_info *key2 = (const struct packet_conn_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_conn_info_100_fields, 8);

static struct packet_conn_info *receive_packet_conn_info_100(struct connection *pc)
{
  packet_conn_info_100_fields fields;
  struct packet_conn_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CONN_INFO;
  RECEIVE_PACKET_START(packet_conn_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(sint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_conn_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_info_100, cmp_packet_conn_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->used = BV_ISSET(fields, 0);
  real_packet->established = BV_ISSET(fields, 1);
  real_packet->observer = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'player_num'");
    if (!DIO_GET(uint8, &din, "player_num", &real_packet->player_num)) {
      RECEIVE_PACKET_FIELD_ERROR(player_num);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'access_level'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "access_level", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(access_level);
      }
      real_packet->access_level = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'username'");
    if (!DIO_GET(string, &din, "username", real_packet->username, sizeof(real_packet->username))) {
      RECEIVE_PACKET_FIELD_ERROR(username);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'addr'");
    if (!DIO_GET(string, &din, "addr", real_packet->addr, sizeof(real_packet->addr))) {
      RECEIVE_PACKET_FIELD_ERROR(addr);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'capability'");
    if (!DIO_GET(string, &din, "capability", real_packet->capability, sizeof(real_packet->capability))) {
      RECEIVE_PACKET_FIELD_ERROR(capability);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_info_100(struct connection *pc, const struct packet_conn_info *packet)
{
  const struct packet_conn_info *real_packet = packet;
  packet_conn_info_100_fields fields;
  struct packet_conn_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONN_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CONN_INFO);

  log_packet_detailed("packet_conn_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_info_100, cmp_packet_conn_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->used != real_packet->used);
  if(differ) {
    different++;
  }
  if (packet->used) {
    BV_SET(fields, 0);
  }

  differ = (old->established != real_packet->established);
  if(differ) {
    different++;
  }
  if (packet->established) {
    BV_SET(fields, 1);
  }

  differ = (old->observer != real_packet->observer);
  if(differ) {
    different++;
  }
  if (packet->observer) {
    BV_SET(fields, 2);
  }

  differ = (old->player_num != real_packet->player_num);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->access_level != real_packet->access_level);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->addr, real_packet->addr) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->capability, real_packet->capability) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(sint16, &dout, "id", real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'player_num' has changed");
    DIO_PUT(uint8, &dout, "player_num", real_packet->player_num);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'access_level' has changed");
    DIO_PUT(uint8, &dout, "access_level", real_packet->access_level);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'username' has changed");
    DIO_PUT(string, &dout, "username", real_packet->username);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'addr' has changed");
    DIO_PUT(string, &dout, "addr", real_packet->addr);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'capability' has changed");
    DIO_PUT(string, &dout, "capability", real_packet->capability);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CONN_INFO);
}

int send_packet_conn_info(struct connection *pc, const struct packet_conn_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CONN_INFO].packet != NULL, -1,
                        "Handler for PACKET_CONN_INFO not installed");
  return pc->phs.handlers->send[PACKET_CONN_INFO].packet(pc, packet);
}

void lsend_packet_conn_info(struct conn_list *dest, const struct packet_conn_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_conn_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_conn_ping_info_100 hash_const

#define cmp_packet_conn_ping_info_100 cmp_const

BV_DEFINE(packet_conn_ping_info_100_fields, 3);

static struct packet_conn_ping_info *receive_packet_conn_ping_info_100(struct connection *pc)
{
  packet_conn_ping_info_100_fields fields;
  struct packet_conn_ping_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CONN_PING_INFO;
  RECEIVE_PACKET_START(packet_conn_ping_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_conn_ping_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_ping_info_100, cmp_packet_conn_ping_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'connections'");
    if (!DIO_GET(uint8, &din, "connections", &real_packet->connections)) {
      RECEIVE_PACKET_FIELD_ERROR(connections);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'conn_id'");
    
    {
      int i;
    
      if (real_packet->connections > MAX_NUM_CONNECTIONS) {
        RECEIVE_PACKET_FIELD_ERROR(conn_id, ": truncation array");
      }
      for (i = 0; i < real_packet->connections; i++) {
        if (!DIO_GET(sint16, &din, "conn_id", &real_packet->conn_id[i])) {
          RECEIVE_PACKET_FIELD_ERROR(conn_id);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'ping_time'");
    
    {
      int i;
    
      if (real_packet->connections > MAX_NUM_CONNECTIONS) {
        RECEIVE_PACKET_FIELD_ERROR(ping_time, ": truncation array");
      }
      for (i = 0; i < real_packet->connections; i++) {
        if (!DIO_GET(sfloat, &din, "ping_time", &real_packet->ping_time[i], 1000000)) {
          RECEIVE_PACKET_FIELD_ERROR(ping_time);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_ping_info_100(struct connection *pc, const struct packet_conn_ping_info *packet)
{
  const struct packet_conn_ping_info *real_packet = packet;
  packet_conn_ping_info_100_fields fields;
  struct packet_conn_ping_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONN_PING_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CONN_PING_INFO);

  log_packet_detailed("packet_conn_ping_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_ping_info_100, cmp_packet_conn_ping_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->connections != real_packet->connections);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->connections != real_packet->connections);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->connections; i++) {
          if (old->conn_id[i] != real_packet->conn_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->connections != real_packet->connections);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->connections; i++) {
          if (old->ping_time[i] != real_packet->ping_time[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'connections' has changed");
    DIO_PUT(uint8, &dout, "connections", real_packet->connections);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'conn_id' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->connections; i++) {
        dio_put_sint16(&dout, real_packet->conn_id[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'ping_time' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->connections; i++) {
          dio_put_sfloat(&dout, real_packet->ping_time[i], 1000000);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CONN_PING_INFO);
}

int send_packet_conn_ping_info(struct connection *pc, const struct packet_conn_ping_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CONN_PING_INFO].packet != NULL, -1,
                        "Handler for PACKET_CONN_PING_INFO not installed");
  return pc->phs.handlers->send[PACKET_CONN_PING_INFO].packet(pc, packet);
}

void lsend_packet_conn_ping_info(struct conn_list *dest, const struct packet_conn_ping_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_conn_ping_info(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_conn_ping *receive_packet_conn_ping_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_conn_ping, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_conn_ping_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_ping_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CONN_PING);

  log_packet_detailed("packet_conn_ping_100: sending info about ()");
  SEND_PACKET_END(PACKET_CONN_PING);
}

int send_packet_conn_ping(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CONN_PING].no_packet != NULL, -1,
                        "Handler for PACKET_CONN_PING not installed");
  return pc->phs.handlers->send[PACKET_CONN_PING].no_packet(pc);
}

static struct packet_conn_pong *receive_packet_conn_pong_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_conn_pong, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_conn_pong_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_pong_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CONN_PONG);

  log_packet_detailed("packet_conn_pong_100: sending info about ()");
  SEND_PACKET_END(PACKET_CONN_PONG);
}

int send_packet_conn_pong(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CONN_PONG].no_packet != NULL, -1,
                        "Handler for PACKET_CONN_PONG not installed");
  return pc->phs.handlers->send[PACKET_CONN_PONG].no_packet(pc);
}

static struct packet_client_heartbeat *receive_packet_client_heartbeat_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_client_heartbeat, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_client_heartbeat_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_client_heartbeat_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CLIENT_HEARTBEAT);

  log_packet_detailed("packet_client_heartbeat_100: sending info about ()");
  SEND_PACKET_END(PACKET_CLIENT_HEARTBEAT);
}

int send_packet_client_heartbeat(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CLIENT_HEARTBEAT].no_packet != NULL, -1,
                        "Handler for PACKET_CLIENT_HEARTBEAT not installed");
  return pc->phs.handlers->send[PACKET_CLIENT_HEARTBEAT].no_packet(pc);
}

#define hash_packet_client_info_100 hash_const

#define cmp_packet_client_info_100 cmp_const

BV_DEFINE(packet_client_info_100_fields, 2);

static struct packet_client_info *receive_packet_client_info_100(struct connection *pc)
{
  packet_client_info_100_fields fields;
  struct packet_client_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CLIENT_INFO;
  RECEIVE_PACKET_START(packet_client_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_client_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_client_info_100, cmp_packet_client_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'gui'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "gui", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gui);
      }
      real_packet->gui = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'distribution'");
    if (!DIO_GET(string, &din, "distribution", real_packet->distribution, sizeof(real_packet->distribution))) {
      RECEIVE_PACKET_FIELD_ERROR(distribution);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_client_info_100(struct connection *pc, const struct packet_client_info *packet)
{
  const struct packet_client_info *real_packet = packet;
  packet_client_info_100_fields fields;
  struct packet_client_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CLIENT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CLIENT_INFO);

  log_packet_detailed("packet_client_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_client_info_100, cmp_packet_client_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->gui != real_packet->gui);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->distribution, real_packet->distribution) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'gui' has changed");
    DIO_PUT(uint8, &dout, "gui", real_packet->gui);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'distribution' has changed");
    DIO_PUT(string, &dout, "distribution", real_packet->distribution);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CLIENT_INFO);
}

int send_packet_client_info(struct connection *pc, const struct packet_client_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_CLIENT_INFO].packet != NULL, -1,
                        "Handler for PACKET_CLIENT_INFO not installed");
  return pc->phs.handlers->send[PACKET_CLIENT_INFO].packet(pc, packet);
}

static struct packet_end_phase *receive_packet_end_phase_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_end_phase, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_end_phase_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_end_phase_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_END_PHASE);

  log_packet_detailed("packet_end_phase_100: sending info about ()");
  SEND_PACKET_END(PACKET_END_PHASE);
}

int send_packet_end_phase(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_END_PHASE].no_packet != NULL, -1,
                        "Handler for PACKET_END_PHASE not installed");
  return pc->phs.handlers->send[PACKET_END_PHASE].no_packet(pc);
}

void lsend_packet_end_phase(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_end_phase(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_start_phase_100 hash_const

#define cmp_packet_start_phase_100 cmp_const

BV_DEFINE(packet_start_phase_100_fields, 1);

static struct packet_start_phase *receive_packet_start_phase_100(struct connection *pc)
{
  packet_start_phase_100_fields fields;
  struct packet_start_phase *old;
  struct genhash **hash = pc->phs.received + PACKET_START_PHASE;
  RECEIVE_PACKET_START(packet_start_phase, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_start_phase_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_start_phase_100, cmp_packet_start_phase_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'phase'");
    if (!DIO_GET(sint16, &din, "phase", &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_start_phase_100(struct connection *pc, const struct packet_start_phase *packet)
{
  const struct packet_start_phase *real_packet = packet;
  packet_start_phase_100_fields fields;
  struct packet_start_phase *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_START_PHASE;
  int different = 0;
  SEND_PACKET_START(PACKET_START_PHASE);

  log_packet_detailed("packet_start_phase_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_start_phase_100, cmp_packet_start_phase_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'phase' has changed");
    DIO_PUT(sint16, &dout, "phase", real_packet->phase);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_START_PHASE);
}

int send_packet_start_phase(struct connection *pc, const struct packet_start_phase *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_START_PHASE].packet != NULL, -1,
                        "Handler for PACKET_START_PHASE not installed");
  return pc->phs.handlers->send[PACKET_START_PHASE].packet(pc, packet);
}

void lsend_packet_start_phase(struct conn_list *dest, const struct packet_start_phase *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_start_phase(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_start_phase(struct connection *pc, int phase)
{
  struct packet_start_phase packet, *real_packet = &packet;

  real_packet->phase = phase;
  
  return send_packet_start_phase(pc, real_packet);
}

void dlsend_packet_start_phase(struct conn_list *dest, int phase)
{
  struct packet_start_phase packet, *real_packet = &packet;

  real_packet->phase = phase;
  
  lsend_packet_start_phase(dest, real_packet);
}

#define hash_packet_new_year_100 hash_const

#define cmp_packet_new_year_100 cmp_const

BV_DEFINE(packet_new_year_100_fields, 3);

static struct packet_new_year *receive_packet_new_year_100(struct connection *pc)
{
  packet_new_year_100_fields fields;
  struct packet_new_year *old;
  struct genhash **hash = pc->phs.received + PACKET_NEW_YEAR;
  RECEIVE_PACKET_START(packet_new_year, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_new_year_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_new_year_100, cmp_packet_new_year_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'year'");
    if (!DIO_GET(sint16, &din, "year", &real_packet->year)) {
      RECEIVE_PACKET_FIELD_ERROR(year);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'fragments'");
    if (!DIO_GET(uint16, &din, "fragments", &real_packet->fragments)) {
      RECEIVE_PACKET_FIELD_ERROR(fragments);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'turn'");
    if (!DIO_GET(sint16, &din, "turn", &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_new_year_100(struct connection *pc, const struct packet_new_year *packet)
{
  const struct packet_new_year *real_packet = packet;
  packet_new_year_100_fields fields;
  struct packet_new_year *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NEW_YEAR;
  int different = 0;
  SEND_PACKET_START(PACKET_NEW_YEAR);

  log_packet_detailed("packet_new_year_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_new_year_100, cmp_packet_new_year_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->fragments != real_packet->fragments);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'year' has changed");
    DIO_PUT(sint16, &dout, "year", real_packet->year);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'fragments' has changed");
    DIO_PUT(uint16, &dout, "fragments", real_packet->fragments);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'turn' has changed");
    DIO_PUT(sint16, &dout, "turn", real_packet->turn);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NEW_YEAR);
}

int send_packet_new_year(struct connection *pc, const struct packet_new_year *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_NEW_YEAR].packet != NULL, -1,
                        "Handler for PACKET_NEW_YEAR not installed");
  return pc->phs.handlers->send[PACKET_NEW_YEAR].packet(pc, packet);
}

void lsend_packet_new_year(struct conn_list *dest, const struct packet_new_year *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_new_year(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_begin_turn *receive_packet_begin_turn_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_begin_turn, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_begin_turn_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_begin_turn_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_BEGIN_TURN);

  log_packet_detailed("packet_begin_turn_100: sending info about ()");
  SEND_PACKET_END(PACKET_BEGIN_TURN);
}

int send_packet_begin_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_BEGIN_TURN].no_packet != NULL, -1,
                        "Handler for PACKET_BEGIN_TURN not installed");
  return pc->phs.handlers->send[PACKET_BEGIN_TURN].no_packet(pc);
}

void lsend_packet_begin_turn(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_begin_turn(pconn);
  } conn_list_iterate_end;
}

static struct packet_end_turn *receive_packet_end_turn_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_end_turn, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_end_turn_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_end_turn_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_END_TURN);

  log_packet_detailed("packet_end_turn_100: sending info about ()");
  SEND_PACKET_END(PACKET_END_TURN);
}

int send_packet_end_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_END_TURN].no_packet != NULL, -1,
                        "Handler for PACKET_END_TURN not installed");
  return pc->phs.handlers->send[PACKET_END_TURN].no_packet(pc);
}

void lsend_packet_end_turn(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_end_turn(pconn);
  } conn_list_iterate_end;
}

static struct packet_freeze_client *receive_packet_freeze_client_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_freeze_client, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_freeze_client_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_freeze_client_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_FREEZE_CLIENT);

  log_packet_detailed("packet_freeze_client_100: sending info about ()");
  SEND_PACKET_END(PACKET_FREEZE_CLIENT);
}

int send_packet_freeze_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_FREEZE_CLIENT].no_packet != NULL, -1,
                        "Handler for PACKET_FREEZE_CLIENT not installed");
  return pc->phs.handlers->send[PACKET_FREEZE_CLIENT].no_packet(pc);
}

void lsend_packet_freeze_client(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_freeze_client(pconn);
  } conn_list_iterate_end;
}

static struct packet_thaw_client *receive_packet_thaw_client_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_thaw_client, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_thaw_client_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_thaw_client_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_THAW_CLIENT);

  log_packet_detailed("packet_thaw_client_100: sending info about ()");
  SEND_PACKET_END(PACKET_THAW_CLIENT);
}

int send_packet_thaw_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_THAW_CLIENT].no_packet != NULL, -1,
                        "Handler for PACKET_THAW_CLIENT not installed");
  return pc->phs.handlers->send[PACKET_THAW_CLIENT].no_packet(pc);
}

void lsend_packet_thaw_client(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_thaw_client(pconn);
  } conn_list_iterate_end;
}

static struct packet_spaceship_launch *receive_packet_spaceship_launch_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_spaceship_launch, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_spaceship_launch_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_launch_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SPACESHIP_LAUNCH);

  log_packet_detailed("packet_spaceship_launch_100: sending info about ()");
  SEND_PACKET_END(PACKET_SPACESHIP_LAUNCH);
}

int send_packet_spaceship_launch(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SPACESHIP_LAUNCH].no_packet != NULL, -1,
                        "Handler for PACKET_SPACESHIP_LAUNCH not installed");
  return pc->phs.handlers->send[PACKET_SPACESHIP_LAUNCH].no_packet(pc);
}

#define hash_packet_spaceship_place_100 hash_const

#define cmp_packet_spaceship_place_100 cmp_const

BV_DEFINE(packet_spaceship_place_100_fields, 2);

static struct packet_spaceship_place *receive_packet_spaceship_place_100(struct connection *pc)
{
  packet_spaceship_place_100_fields fields;
  struct packet_spaceship_place *old;
  struct genhash **hash = pc->phs.received + PACKET_SPACESHIP_PLACE;
  RECEIVE_PACKET_START(packet_spaceship_place, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_spaceship_place_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_place_100, cmp_packet_spaceship_place_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'num'");
    if (!DIO_GET(uint8, &din, "num", &real_packet->num)) {
      RECEIVE_PACKET_FIELD_ERROR(num);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_place_100(struct connection *pc, const struct packet_spaceship_place *packet)
{
  const struct packet_spaceship_place *real_packet = packet;
  packet_spaceship_place_100_fields fields;
  struct packet_spaceship_place *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SPACESHIP_PLACE;
  int different = 0;
  SEND_PACKET_START(PACKET_SPACESHIP_PLACE);

  log_packet_detailed("packet_spaceship_place_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_place_100, cmp_packet_spaceship_place_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->num != real_packet->num);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'num' has changed");
    DIO_PUT(uint8, &dout, "num", real_packet->num);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SPACESHIP_PLACE);
}

int send_packet_spaceship_place(struct connection *pc, const struct packet_spaceship_place *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SPACESHIP_PLACE].packet != NULL, -1,
                        "Handler for PACKET_SPACESHIP_PLACE not installed");
  return pc->phs.handlers->send[PACKET_SPACESHIP_PLACE].packet(pc, packet);
}

int dsend_packet_spaceship_place(struct connection *pc, enum spaceship_place_type type, int num)
{
  struct packet_spaceship_place packet, *real_packet = &packet;

  real_packet->type = type;
  real_packet->num = num;
  
  return send_packet_spaceship_place(pc, real_packet);
}

static genhash_val_t hash_packet_spaceship_info_100(const void *vkey)
{
  const struct packet_spaceship_info *key = (const struct packet_spaceship_info *) vkey;

  return key->player_num;
}

static bool cmp_packet_spaceship_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_spaceship_info *key1 = (const struct packet_spaceship_info *) vkey1;
  const struct packet_spaceship_info *key2 = (const struct packet_spaceship_info *) vkey2;

  return key1->player_num == key2->player_num;
}

BV_DEFINE(packet_spaceship_info_100_fields, 17);

static struct packet_spaceship_info *receive_packet_spaceship_info_100(struct connection *pc)
{
  packet_spaceship_info_100_fields fields;
  struct packet_spaceship_info *old;
  struct genhash **hash = pc->phs.received + PACKET_SPACESHIP_INFO;
  RECEIVE_PACKET_START(packet_spaceship_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint8, &din, "player_num", &real_packet->player_num)) {
    RECEIVE_PACKET_FIELD_ERROR(player_num);
  }

  log_packet_detailed("packet_spaceship_info_100: got info about (%d)",
    real_packet->player_num);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_info_100, cmp_packet_spaceship_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int player_num = real_packet->player_num;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->player_num = player_num;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'sship_state'");
    if (!DIO_GET(uint8, &din, "sship_state", &real_packet->sship_state)) {
      RECEIVE_PACKET_FIELD_ERROR(sship_state);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'structurals'");
    if (!DIO_GET(uint8, &din, "structurals", &real_packet->structurals)) {
      RECEIVE_PACKET_FIELD_ERROR(structurals);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'components'");
    if (!DIO_GET(uint8, &din, "components", &real_packet->components)) {
      RECEIVE_PACKET_FIELD_ERROR(components);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'modules'");
    if (!DIO_GET(uint8, &din, "modules", &real_packet->modules)) {
      RECEIVE_PACKET_FIELD_ERROR(modules);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'fuel'");
    if (!DIO_GET(uint8, &din, "fuel", &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'propulsion'");
    if (!DIO_GET(uint8, &din, "propulsion", &real_packet->propulsion)) {
      RECEIVE_PACKET_FIELD_ERROR(propulsion);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'habitation'");
    if (!DIO_GET(uint8, &din, "habitation", &real_packet->habitation)) {
      RECEIVE_PACKET_FIELD_ERROR(habitation);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'life_support'");
    if (!DIO_GET(uint8, &din, "life_support", &real_packet->life_support)) {
      RECEIVE_PACKET_FIELD_ERROR(life_support);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'solar_panels'");
    if (!DIO_GET(uint8, &din, "solar_panels", &real_packet->solar_panels)) {
      RECEIVE_PACKET_FIELD_ERROR(solar_panels);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'launch_year'");
    if (!DIO_GET(sint16, &din, "launch_year", &real_packet->launch_year)) {
      RECEIVE_PACKET_FIELD_ERROR(launch_year);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'population'");
    if (!DIO_GET(uint32, &din, "population", &real_packet->population)) {
      RECEIVE_PACKET_FIELD_ERROR(population);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'mass'");
    if (!DIO_GET(uint32, &din, "mass", &real_packet->mass)) {
      RECEIVE_PACKET_FIELD_ERROR(mass);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'structure'");
    if (!DIO_BV_GET(&din, real_packet->structure)) {
      RECEIVE_PACKET_FIELD_ERROR(structure);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'support_rate'");
    if (!DIO_GET(ufloat, &din, "support_rate", &real_packet->support_rate, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(support_rate);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'energy_rate'");
    if (!DIO_GET(ufloat, &din, "energy_rate", &real_packet->energy_rate, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(energy_rate);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'success_rate'");
    if (!DIO_GET(ufloat, &din, "success_rate", &real_packet->success_rate, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(success_rate);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'travel_time'");
    if (!DIO_GET(ufloat, &din, "travel_time", &real_packet->travel_time, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(travel_time);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_info_100(struct connection *pc, const struct packet_spaceship_info *packet)
{
  const struct packet_spaceship_info *real_packet = packet;
  packet_spaceship_info_100_fields fields;
  struct packet_spaceship_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SPACESHIP_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_SPACESHIP_INFO);

  log_packet_detailed("packet_spaceship_info_100: sending info about (%d)",
    real_packet->player_num);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_info_100, cmp_packet_spaceship_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->sship_state != real_packet->sship_state);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->structurals != real_packet->structurals);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->components != real_packet->components);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->modules != real_packet->modules);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->propulsion != real_packet->propulsion);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->habitation != real_packet->habitation);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->life_support != real_packet->life_support);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->solar_panels != real_packet->solar_panels);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->launch_year != real_packet->launch_year);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->population != real_packet->population);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->mass != real_packet->mass);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = !BV_ARE_EQUAL(old->structure, real_packet->structure);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->support_rate != real_packet->support_rate);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->energy_rate != real_packet->energy_rate);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->success_rate != real_packet->success_rate);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->travel_time != real_packet->travel_time);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint8, &dout, "player_num", real_packet->player_num);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'sship_state' has changed");
    DIO_PUT(uint8, &dout, "sship_state", real_packet->sship_state);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'structurals' has changed");
    DIO_PUT(uint8, &dout, "structurals", real_packet->structurals);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'components' has changed");
    DIO_PUT(uint8, &dout, "components", real_packet->components);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'modules' has changed");
    DIO_PUT(uint8, &dout, "modules", real_packet->modules);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'fuel' has changed");
    DIO_PUT(uint8, &dout, "fuel", real_packet->fuel);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'propulsion' has changed");
    DIO_PUT(uint8, &dout, "propulsion", real_packet->propulsion);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'habitation' has changed");
    DIO_PUT(uint8, &dout, "habitation", real_packet->habitation);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'life_support' has changed");
    DIO_PUT(uint8, &dout, "life_support", real_packet->life_support);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'solar_panels' has changed");
    DIO_PUT(uint8, &dout, "solar_panels", real_packet->solar_panels);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'launch_year' has changed");
    DIO_PUT(sint16, &dout, "launch_year", real_packet->launch_year);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'population' has changed");
    DIO_PUT(uint32, &dout, "population", real_packet->population);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'mass' has changed");
    DIO_PUT(uint32, &dout, "mass", real_packet->mass);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'structure' has changed");
  DIO_BV_PUT(&dout, "structure", packet->structure);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'support_rate' has changed");
    DIO_PUT(ufloat, &dout, "support_rate", real_packet->support_rate, 10000);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'energy_rate' has changed");
    DIO_PUT(ufloat, &dout, "energy_rate", real_packet->energy_rate, 10000);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'success_rate' has changed");
    DIO_PUT(ufloat, &dout, "success_rate", real_packet->success_rate, 10000);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'travel_time' has changed");
    DIO_PUT(ufloat, &dout, "travel_time", real_packet->travel_time, 10000);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SPACESHIP_INFO);
}

int send_packet_spaceship_info(struct connection *pc, const struct packet_spaceship_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SPACESHIP_INFO].packet != NULL, -1,
                        "Handler for PACKET_SPACESHIP_INFO not installed");
  return pc->phs.handlers->send[PACKET_SPACESHIP_INFO].packet(pc, packet);
}

void lsend_packet_spaceship_info(struct conn_list *dest, const struct packet_spaceship_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_spaceship_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_100 hash_const

#define cmp_packet_ruleset_unit_100 cmp_const

BV_DEFINE(packet_ruleset_unit_100_fields, 44);

static struct packet_ruleset_unit *receive_packet_ruleset_unit_100(struct connection *pc)
{
  packet_ruleset_unit_100_fields fields;
  struct packet_ruleset_unit *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT;
  RECEIVE_PACKET_START(packet_ruleset_unit, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_100, cmp_packet_ruleset_unit_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'sound_move'");
    if (!DIO_GET(string, &din, "sound_move", real_packet->sound_move, sizeof(real_packet->sound_move))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_move);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'sound_move_alt'");
    if (!DIO_GET(string, &din, "sound_move_alt", real_packet->sound_move_alt, sizeof(real_packet->sound_move_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_move_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'sound_fight'");
    if (!DIO_GET(string, &din, "sound_fight", real_packet->sound_fight, sizeof(real_packet->sound_fight))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_fight);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'sound_fight_alt'");
    if (!DIO_GET(string, &din, "sound_fight_alt", real_packet->sound_fight_alt, sizeof(real_packet->sound_fight_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_fight_alt);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'unit_class_id'");
    if (!DIO_GET(uint8, &din, "unit_class_id", &real_packet->unit_class_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_class_id);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    if (!DIO_GET(uint16, &din, "build_cost", &real_packet->build_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(build_cost);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'pop_cost'");
    if (!DIO_GET(uint8, &din, "pop_cost", &real_packet->pop_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_cost);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'attack_strength'");
    if (!DIO_GET(uint8, &din, "attack_strength", &real_packet->attack_strength)) {
      RECEIVE_PACKET_FIELD_ERROR(attack_strength);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'defense_strength'");
    if (!DIO_GET(uint8, &din, "defense_strength", &real_packet->defense_strength)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_strength);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'move_rate'");
    if (!DIO_GET(uint16, &din, "move_rate", &real_packet->move_rate)) {
      RECEIVE_PACKET_FIELD_ERROR(move_rate);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'tech_requirement'");
    if (!DIO_GET(uint8, &din, "tech_requirement", &real_packet->tech_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_requirement);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'impr_requirement'");
    if (!DIO_GET(uint8, &din, "impr_requirement", &real_packet->impr_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(impr_requirement);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'gov_requirement'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "gov_requirement", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gov_requirement);
      }
      real_packet->gov_requirement = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'vision_radius_sq'");
    if (!DIO_GET(uint16, &din, "vision_radius_sq", &real_packet->vision_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_radius_sq);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'transport_capacity'");
    if (!DIO_GET(uint8, &din, "transport_capacity", &real_packet->transport_capacity)) {
      RECEIVE_PACKET_FIELD_ERROR(transport_capacity);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'hp'");
    if (!DIO_GET(uint8, &din, "hp", &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'firepower'");
    if (!DIO_GET(uint8, &din, "firepower", &real_packet->firepower)) {
      RECEIVE_PACKET_FIELD_ERROR(firepower);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'obsoleted_by'");
    if (!DIO_GET(uint8, &din, "obsoleted_by", &real_packet->obsoleted_by)) {
      RECEIVE_PACKET_FIELD_ERROR(obsoleted_by);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'converted_to'");
    if (!DIO_GET(uint8, &din, "converted_to", &real_packet->converted_to)) {
      RECEIVE_PACKET_FIELD_ERROR(converted_to);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'convert_time'");
    if (!DIO_GET(uint8, &din, "convert_time", &real_packet->convert_time)) {
      RECEIVE_PACKET_FIELD_ERROR(convert_time);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'fuel'");
    if (!DIO_GET(uint8, &din, "fuel", &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'happy_cost'");
    if (!DIO_GET(uint8, &din, "happy_cost", &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint8, &din, "upkeep", &real_packet->upkeep[i])) {
          RECEIVE_PACKET_FIELD_ERROR(upkeep);
        }
      }
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'paratroopers_range'");
    if (!DIO_GET(uint16, &din, "paratroopers_range", &real_packet->paratroopers_range)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_range);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'paratroopers_mr_req'");
    if (!DIO_GET(uint8, &din, "paratroopers_mr_req", &real_packet->paratroopers_mr_req)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_mr_req);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'paratroopers_mr_sub'");
    if (!DIO_GET(uint8, &din, "paratroopers_mr_sub", &real_packet->paratroopers_mr_sub)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_mr_sub);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'veteran_levels'");
    if (!DIO_GET(uint8, &din, "veteran_levels", &real_packet->veteran_levels)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran_levels);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(veteran_name, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!DIO_GET(string, &din, "veteran_name", real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(veteran_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(power_fact, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!DIO_GET(uint16, &din, "power_fact", &real_packet->power_fact[i])) {
          RECEIVE_PACKET_FIELD_ERROR(power_fact);
        }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'move_bonus'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(move_bonus, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!DIO_GET(uint16, &din, "move_bonus", &real_packet->move_bonus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(move_bonus);
        }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'bombard_rate'");
    if (!DIO_GET(uint8, &din, "bombard_rate", &real_packet->bombard_rate)) {
      RECEIVE_PACKET_FIELD_ERROR(bombard_rate);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'city_size'");
    if (!DIO_GET(uint8, &din, "city_size", &real_packet->city_size)) {
      RECEIVE_PACKET_FIELD_ERROR(city_size);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'cargo'");
    if (!DIO_BV_GET(&din, real_packet->cargo)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'targets'");
    if (!DIO_BV_GET(&din, real_packet->targets)) {
      RECEIVE_PACKET_FIELD_ERROR(targets);
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'embarks'");
    if (!DIO_BV_GET(&din, real_packet->embarks)) {
      RECEIVE_PACKET_FIELD_ERROR(embarks);
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'disembarks'");
    if (!DIO_BV_GET(&din, real_packet->disembarks)) {
      RECEIVE_PACKET_FIELD_ERROR(disembarks);
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'roles'");
    if (!DIO_BV_GET(&din, real_packet->roles)) {
      RECEIVE_PACKET_FIELD_ERROR(roles);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_100(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  const struct packet_ruleset_unit *real_packet = packet;
  packet_ruleset_unit_100_fields fields;
  struct packet_ruleset_unit *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT);

  log_packet_detailed("packet_ruleset_unit_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_100, cmp_packet_ruleset_unit_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->sound_move, real_packet->sound_move) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->sound_move_alt, real_packet->sound_move_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->sound_fight, real_packet->sound_fight) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->sound_fight_alt, real_packet->sound_fight_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->unit_class_id != real_packet->unit_class_id);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->pop_cost != real_packet->pop_cost);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->attack_strength != real_packet->attack_strength);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->defense_strength != real_packet->defense_strength);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->move_rate != real_packet->move_rate);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->tech_requirement != real_packet->tech_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->impr_requirement != real_packet->impr_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->gov_requirement != real_packet->gov_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->vision_radius_sq != real_packet->vision_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->transport_capacity != real_packet->transport_capacity);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->firepower != real_packet->firepower);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->obsoleted_by != real_packet->obsoleted_by);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->converted_to != real_packet->converted_to);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->convert_time != real_packet->convert_time);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->paratroopers_range != real_packet->paratroopers_range);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->paratroopers_mr_req != real_packet->paratroopers_mr_req);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->paratroopers_mr_sub != real_packet->paratroopers_mr_sub);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus[i] != real_packet->move_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->bombard_rate != real_packet->bombard_rate);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->city_size != real_packet->city_size);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = !BV_ARE_EQUAL(old->cargo, real_packet->cargo);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = !BV_ARE_EQUAL(old->targets, real_packet->targets);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = !BV_ARE_EQUAL(old->embarks, real_packet->embarks);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = !BV_ARE_EQUAL(old->disembarks, real_packet->disembarks);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = !BV_ARE_EQUAL(old->roles, real_packet->roles);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'sound_move' has changed");
    DIO_PUT(string, &dout, "sound_move", real_packet->sound_move);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'sound_move_alt' has changed");
    DIO_PUT(string, &dout, "sound_move_alt", real_packet->sound_move_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'sound_fight' has changed");
    DIO_PUT(string, &dout, "sound_fight", real_packet->sound_fight);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'sound_fight_alt' has changed");
    DIO_PUT(string, &dout, "sound_fight_alt", real_packet->sound_fight_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'unit_class_id' has changed");
    DIO_PUT(uint8, &dout, "unit_class_id", real_packet->unit_class_id);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    DIO_PUT(uint16, &dout, "build_cost", real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'pop_cost' has changed");
    DIO_PUT(uint8, &dout, "pop_cost", real_packet->pop_cost);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'attack_strength' has changed");
    DIO_PUT(uint8, &dout, "attack_strength", real_packet->attack_strength);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'defense_strength' has changed");
    DIO_PUT(uint8, &dout, "defense_strength", real_packet->defense_strength);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'move_rate' has changed");
    DIO_PUT(uint16, &dout, "move_rate", real_packet->move_rate);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'tech_requirement' has changed");
    DIO_PUT(uint8, &dout, "tech_requirement", real_packet->tech_requirement);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'impr_requirement' has changed");
    DIO_PUT(uint8, &dout, "impr_requirement", real_packet->impr_requirement);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'gov_requirement' has changed");
    DIO_PUT(sint8, &dout, "gov_requirement", real_packet->gov_requirement);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'vision_radius_sq' has changed");
    DIO_PUT(uint16, &dout, "vision_radius_sq", real_packet->vision_radius_sq);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'transport_capacity' has changed");
    DIO_PUT(uint8, &dout, "transport_capacity", real_packet->transport_capacity);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'hp' has changed");
    DIO_PUT(uint8, &dout, "hp", real_packet->hp);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'firepower' has changed");
    DIO_PUT(uint8, &dout, "firepower", real_packet->firepower);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'obsoleted_by' has changed");
    DIO_PUT(uint8, &dout, "obsoleted_by", real_packet->obsoleted_by);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'converted_to' has changed");
    DIO_PUT(uint8, &dout, "converted_to", real_packet->converted_to);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'convert_time' has changed");
    DIO_PUT(uint8, &dout, "convert_time", real_packet->convert_time);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'fuel' has changed");
    DIO_PUT(uint8, &dout, "fuel", real_packet->fuel);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    DIO_PUT(uint8, &dout, "happy_cost", real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'paratroopers_range' has changed");
    DIO_PUT(uint16, &dout, "paratroopers_range", real_packet->paratroopers_range);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'paratroopers_mr_req' has changed");
    DIO_PUT(uint8, &dout, "paratroopers_mr_req", real_packet->paratroopers_mr_req);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'paratroopers_mr_sub' has changed");
    DIO_PUT(uint8, &dout, "paratroopers_mr_sub", real_packet->paratroopers_mr_sub);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    DIO_PUT(uint8, &dout, "veteran_levels", real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'move_bonus' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->move_bonus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'bombard_rate' has changed");
    DIO_PUT(uint8, &dout, "bombard_rate", real_packet->bombard_rate);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'city_size' has changed");
    DIO_PUT(uint8, &dout, "city_size", real_packet->city_size);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'cargo' has changed");
  DIO_BV_PUT(&dout, "cargo", packet->cargo);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'targets' has changed");
  DIO_BV_PUT(&dout, "targets", packet->targets);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'embarks' has changed");
  DIO_BV_PUT(&dout, "embarks", packet->embarks);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'disembarks' has changed");
  DIO_BV_PUT(&dout, "disembarks", packet->disembarks);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'roles' has changed");
  DIO_BV_PUT(&dout, "roles", packet->roles);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT);
}

int send_packet_ruleset_unit(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_UNIT].packet != NULL, -1,
                        "Handler for PACKET_RULESET_UNIT not installed");
  return pc->phs.handlers->send[PACKET_RULESET_UNIT].packet(pc, packet);
}

void lsend_packet_ruleset_unit(struct conn_list *dest, const struct packet_ruleset_unit *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_bonus_100 hash_const

#define cmp_packet_ruleset_unit_bonus_100 cmp_const

BV_DEFINE(packet_ruleset_unit_bonus_100_fields, 5);

static struct packet_ruleset_unit_bonus *receive_packet_ruleset_unit_bonus_100(struct connection *pc)
{
  packet_ruleset_unit_bonus_100_fields fields;
  struct packet_ruleset_unit_bonus *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_BONUS;
  RECEIVE_PACKET_START(packet_ruleset_unit_bonus, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_bonus_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_bonus_100, cmp_packet_ruleset_unit_bonus_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "unit", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(unit);
      }
      real_packet->unit = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'flag'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "flag", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(flag);
      }
      real_packet->flag = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(uint8, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }
  real_packet->quiet = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_bonus_100(struct connection *pc, const struct packet_ruleset_unit_bonus *packet)
{
  const struct packet_ruleset_unit_bonus *real_packet = packet;
  packet_ruleset_unit_bonus_100_fields fields;
  struct packet_ruleset_unit_bonus *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_BONUS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_BONUS);

  log_packet_detailed("packet_ruleset_unit_bonus_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_bonus_100, cmp_packet_ruleset_unit_bonus_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit != real_packet->unit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->flag != real_packet->flag);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->quiet != real_packet->quiet);
  if(differ) {
    different++;
  }
  if (packet->quiet) {
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit' has changed");
    DIO_PUT(uint8, &dout, "unit", real_packet->unit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'flag' has changed");
    DIO_PUT(uint8, &dout, "flag", real_packet->flag);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(uint8, &dout, "value", real_packet->value);
  }
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_BONUS);
}

int send_packet_ruleset_unit_bonus(struct connection *pc, const struct packet_ruleset_unit_bonus *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_UNIT_BONUS].packet != NULL, -1,
                        "Handler for PACKET_RULESET_UNIT_BONUS not installed");
  return pc->phs.handlers->send[PACKET_RULESET_UNIT_BONUS].packet(pc, packet);
}

void lsend_packet_ruleset_unit_bonus(struct conn_list *dest, const struct packet_ruleset_unit_bonus *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_bonus(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_flag_100 hash_const

#define cmp_packet_ruleset_unit_flag_100 cmp_const

BV_DEFINE(packet_ruleset_unit_flag_100_fields, 3);

static struct packet_ruleset_unit_flag *receive_packet_ruleset_unit_flag_100(struct connection *pc)
{
  packet_ruleset_unit_flag_100_fields fields;
  struct packet_ruleset_unit_flag *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_FLAG;
  RECEIVE_PACKET_START(packet_ruleset_unit_flag, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_flag_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_flag_100, cmp_packet_ruleset_unit_flag_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'helptxt'");
    if (!DIO_GET(string, &din, "helptxt", real_packet->helptxt, sizeof(real_packet->helptxt))) {
      RECEIVE_PACKET_FIELD_ERROR(helptxt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_flag_100(struct connection *pc, const struct packet_ruleset_unit_flag *packet)
{
  const struct packet_ruleset_unit_flag *real_packet = packet;
  packet_ruleset_unit_flag_100_fields fields;
  struct packet_ruleset_unit_flag *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_FLAG;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_FLAG);

  log_packet_detailed("packet_ruleset_unit_flag_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_flag_100, cmp_packet_ruleset_unit_flag_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->helptxt, real_packet->helptxt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'helptxt' has changed");
    DIO_PUT(string, &dout, "helptxt", real_packet->helptxt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_FLAG);
}

int send_packet_ruleset_unit_flag(struct connection *pc, const struct packet_ruleset_unit_flag *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_UNIT_FLAG].packet != NULL, -1,
                        "Handler for PACKET_RULESET_UNIT_FLAG not installed");
  return pc->phs.handlers->send[PACKET_RULESET_UNIT_FLAG].packet(pc, packet);
}

void lsend_packet_ruleset_unit_flag(struct conn_list *dest, const struct packet_ruleset_unit_flag *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_flag(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_game_100 hash_const

#define cmp_packet_ruleset_game_100 cmp_const

BV_DEFINE(packet_ruleset_game_100_fields, 10);

static struct packet_ruleset_game *receive_packet_ruleset_game_100(struct connection *pc)
{
  packet_ruleset_game_100_fields fields;
  struct packet_ruleset_game *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GAME;
  RECEIVE_PACKET_START(packet_ruleset_game, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_game_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_100, cmp_packet_ruleset_game_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'default_specialist'");
    if (!DIO_GET(uint8, &din, "default_specialist", &real_packet->default_specialist)) {
      RECEIVE_PACKET_FIELD_ERROR(default_specialist);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'global_init_techs'");
    if (!DIO_GET(tech_list, &din, "global_init_techs", real_packet->global_init_techs)) {
      RECEIVE_PACKET_FIELD_ERROR(global_init_techs);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'global_init_buildings'");
    if (!DIO_GET(building_list, &din, "global_init_buildings", real_packet->global_init_buildings)) {
      RECEIVE_PACKET_FIELD_ERROR(global_init_buildings);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'veteran_levels'");
    if (!DIO_GET(uint8, &din, "veteran_levels", &real_packet->veteran_levels)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran_levels);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(veteran_name, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!DIO_GET(string, &din, "veteran_name", real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(veteran_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(power_fact, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!DIO_GET(uint16, &din, "power_fact", &real_packet->power_fact[i])) {
          RECEIVE_PACKET_FIELD_ERROR(power_fact);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'move_bonus'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(move_bonus, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!DIO_GET(uint16, &din, "move_bonus", &real_packet->move_bonus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(move_bonus);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'background_red'");
    if (!DIO_GET(uint8, &din, "background_red", &real_packet->background_red)) {
      RECEIVE_PACKET_FIELD_ERROR(background_red);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'background_green'");
    if (!DIO_GET(uint8, &din, "background_green", &real_packet->background_green)) {
      RECEIVE_PACKET_FIELD_ERROR(background_green);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'background_blue'");
    if (!DIO_GET(uint8, &din, "background_blue", &real_packet->background_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(background_blue);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_game_100(struct connection *pc, const struct packet_ruleset_game *packet)
{
  const struct packet_ruleset_game *real_packet = packet;
  packet_ruleset_game_100_fields fields;
  struct packet_ruleset_game *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GAME;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GAME);

  log_packet_detailed("packet_ruleset_game_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_100, cmp_packet_ruleset_game_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->default_specialist != real_packet->default_specialist);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->global_init_techs[i] != real_packet->global_init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->global_init_buildings[i] != real_packet->global_init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus[i] != real_packet->move_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->background_red != real_packet->background_red);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->background_green != real_packet->background_green);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->background_blue != real_packet->background_blue);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'default_specialist' has changed");
    DIO_PUT(uint8, &dout, "default_specialist", real_packet->default_specialist);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'global_init_techs' has changed");
    DIO_PUT(tech_list, &dout, "global_init_techs", real_packet->global_init_techs);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'global_init_buildings' has changed");
    DIO_PUT(building_list, &dout, "global_init_buildings", real_packet->global_init_buildings);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    DIO_PUT(uint8, &dout, "veteran_levels", real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'move_bonus' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->move_bonus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'background_red' has changed");
    DIO_PUT(uint8, &dout, "background_red", real_packet->background_red);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'background_green' has changed");
    DIO_PUT(uint8, &dout, "background_green", real_packet->background_green);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'background_blue' has changed");
    DIO_PUT(uint8, &dout, "background_blue", real_packet->background_blue);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GAME);
}

int send_packet_ruleset_game(struct connection *pc, const struct packet_ruleset_game *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_GAME].packet != NULL, -1,
                        "Handler for PACKET_RULESET_GAME not installed");
  return pc->phs.handlers->send[PACKET_RULESET_GAME].packet(pc, packet);
}

void lsend_packet_ruleset_game(struct conn_list *dest, const struct packet_ruleset_game *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_game(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_specialist_100 hash_const

#define cmp_packet_ruleset_specialist_100 cmp_const

BV_DEFINE(packet_ruleset_specialist_100_fields, 8);

static struct packet_ruleset_specialist *receive_packet_ruleset_specialist_100(struct connection *pc)
{
  packet_ruleset_specialist_100_fields fields;
  struct packet_ruleset_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_SPECIALIST;
  RECEIVE_PACKET_START(packet_ruleset_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_specialist_100, cmp_packet_ruleset_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'plural_name'");
    if (!DIO_GET(string, &din, "plural_name", real_packet->plural_name, sizeof(real_packet->plural_name))) {
      RECEIVE_PACKET_FIELD_ERROR(plural_name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'short_name'");
    if (!DIO_GET(string, &din, "short_name", real_packet->short_name, sizeof(real_packet->short_name))) {
      RECEIVE_PACKET_FIELD_ERROR(short_name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_specialist_100(struct connection *pc, const struct packet_ruleset_specialist *packet)
{
  const struct packet_ruleset_specialist *real_packet = packet;
  packet_ruleset_specialist_100_fields fields;
  struct packet_ruleset_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_SPECIALIST);

  log_packet_detailed("packet_ruleset_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_specialist_100, cmp_packet_ruleset_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->plural_name, real_packet->plural_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->short_name, real_packet->short_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'plural_name' has changed");
    DIO_PUT(string, &dout, "plural_name", real_packet->plural_name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'short_name' has changed");
    DIO_PUT(string, &dout, "short_name", real_packet->short_name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_SPECIALIST);
}

int send_packet_ruleset_specialist(struct connection *pc, const struct packet_ruleset_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_SPECIALIST].packet != NULL, -1,
                        "Handler for PACKET_RULESET_SPECIALIST not installed");
  return pc->phs.handlers->send[PACKET_RULESET_SPECIALIST].packet(pc, packet);
}

void lsend_packet_ruleset_specialist(struct conn_list *dest, const struct packet_ruleset_specialist *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_specialist(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_government_ruler_title_100 hash_const

#define cmp_packet_ruleset_government_ruler_title_100 cmp_const

BV_DEFINE(packet_ruleset_government_ruler_title_100_fields, 4);

static struct packet_ruleset_government_ruler_title *receive_packet_ruleset_government_ruler_title_100(struct connection *pc)
{
  packet_ruleset_government_ruler_title_100_fields fields;
  struct packet_ruleset_government_ruler_title *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GOVERNMENT_RULER_TITLE;
  RECEIVE_PACKET_START(packet_ruleset_government_ruler_title, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_government_ruler_title_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_ruler_title_100, cmp_packet_ruleset_government_ruler_title_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'gov'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "gov", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gov);
      }
      real_packet->gov = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
      
      if (!DIO_GET(sint16, &din, "nation", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation);
      }
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'male_title'");
    if (!DIO_GET(string, &din, "male_title", real_packet->male_title, sizeof(real_packet->male_title))) {
      RECEIVE_PACKET_FIELD_ERROR(male_title);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'female_title'");
    if (!DIO_GET(string, &din, "female_title", real_packet->female_title, sizeof(real_packet->female_title))) {
      RECEIVE_PACKET_FIELD_ERROR(female_title);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_government_ruler_title_100(struct connection *pc, const struct packet_ruleset_government_ruler_title *packet)
{
  const struct packet_ruleset_government_ruler_title *real_packet = packet;
  packet_ruleset_government_ruler_title_100_fields fields;
  struct packet_ruleset_government_ruler_title *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GOVERNMENT_RULER_TITLE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GOVERNMENT_RULER_TITLE);

  log_packet_detailed("packet_ruleset_government_ruler_title_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_ruler_title_100, cmp_packet_ruleset_government_ruler_title_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->gov != real_packet->gov);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->male_title, real_packet->male_title) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->female_title, real_packet->female_title) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'gov' has changed");
    DIO_PUT(sint8, &dout, "gov", real_packet->gov);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation' has changed");
    DIO_PUT(sint16, &dout, "nation", real_packet->nation);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'male_title' has changed");
    DIO_PUT(string, &dout, "male_title", real_packet->male_title);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'female_title' has changed");
    DIO_PUT(string, &dout, "female_title", real_packet->female_title);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GOVERNMENT_RULER_TITLE);
}

int send_packet_ruleset_government_ruler_title(struct connection *pc, const struct packet_ruleset_government_ruler_title *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_GOVERNMENT_RULER_TITLE].packet != NULL, -1,
                        "Handler for PACKET_RULESET_GOVERNMENT_RULER_TITLE not installed");
  return pc->phs.handlers->send[PACKET_RULESET_GOVERNMENT_RULER_TITLE].packet(pc, packet);
}

void lsend_packet_ruleset_government_ruler_title(struct conn_list *dest, const struct packet_ruleset_government_ruler_title *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_government_ruler_title(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_tech_100 hash_const

#define cmp_packet_ruleset_tech_100 cmp_const

BV_DEFINE(packet_ruleset_tech_100_fields, 11);

static struct packet_ruleset_tech *receive_packet_ruleset_tech_100(struct connection *pc)
{
  packet_ruleset_tech_100_fields fields;
  struct packet_ruleset_tech *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TECH;
  RECEIVE_PACKET_START(packet_ruleset_tech, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_tech_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_100, cmp_packet_ruleset_tech_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'req'");
    
    {
      int i;
    
      for (i = 0; i < 2; i++) {
        if (!DIO_GET(uint8, &din, "req", &real_packet->req[i])) {
          RECEIVE_PACKET_FIELD_ERROR(req);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'root_req'");
    if (!DIO_GET(uint8, &din, "root_req", &real_packet->root_req)) {
      RECEIVE_PACKET_FIELD_ERROR(root_req);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'cost'");
    if (!DIO_GET(ufloat, &din, "cost", &real_packet->cost, 100)) {
      RECEIVE_PACKET_FIELD_ERROR(cost);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'num_reqs'");
    if (!DIO_GET(uint32, &din, "num_reqs", &real_packet->num_reqs)) {
      RECEIVE_PACKET_FIELD_ERROR(num_reqs);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_tech_100(struct connection *pc, const struct packet_ruleset_tech *packet)
{
  const struct packet_ruleset_tech *real_packet = packet;
  packet_ruleset_tech_100_fields fields;
  struct packet_ruleset_tech *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TECH;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TECH);

  log_packet_detailed("packet_ruleset_tech_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_100, cmp_packet_ruleset_tech_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (2 != 2);
      if(!differ) {
        int i;
        for (i = 0; i < 2; i++) {
          if (old->req[i] != real_packet->req[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->root_req != real_packet->root_req);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->cost != real_packet->cost);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->num_reqs != real_packet->num_reqs);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'req' has changed");
  
    {
      int i;

      for (i = 0; i < 2; i++) {
        dio_put_uint8(&dout, real_packet->req[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'root_req' has changed");
    DIO_PUT(uint8, &dout, "root_req", real_packet->root_req);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'cost' has changed");
    DIO_PUT(ufloat, &dout, "cost", real_packet->cost, 100);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'num_reqs' has changed");
    DIO_PUT(uint32, &dout, "num_reqs", real_packet->num_reqs);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TECH);
}

int send_packet_ruleset_tech(struct connection *pc, const struct packet_ruleset_tech *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_TECH].packet != NULL, -1,
                        "Handler for PACKET_RULESET_TECH not installed");
  return pc->phs.handlers->send[PACKET_RULESET_TECH].packet(pc, packet);
}

void lsend_packet_ruleset_tech(struct conn_list *dest, const struct packet_ruleset_tech *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_tech(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_tech_flag_100 hash_const

#define cmp_packet_ruleset_tech_flag_100 cmp_const

BV_DEFINE(packet_ruleset_tech_flag_100_fields, 3);

static struct packet_ruleset_tech_flag *receive_packet_ruleset_tech_flag_100(struct connection *pc)
{
  packet_ruleset_tech_flag_100_fields fields;
  struct packet_ruleset_tech_flag *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TECH_FLAG;
  RECEIVE_PACKET_START(packet_ruleset_tech_flag, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_tech_flag_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_flag_100, cmp_packet_ruleset_tech_flag_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'helptxt'");
    if (!DIO_GET(string, &din, "helptxt", real_packet->helptxt, sizeof(real_packet->helptxt))) {
      RECEIVE_PACKET_FIELD_ERROR(helptxt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_tech_flag_100(struct connection *pc, const struct packet_ruleset_tech_flag *packet)
{
  const struct packet_ruleset_tech_flag *real_packet = packet;
  packet_ruleset_tech_flag_100_fields fields;
  struct packet_ruleset_tech_flag *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TECH_FLAG;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TECH_FLAG);

  log_packet_detailed("packet_ruleset_tech_flag_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_flag_100, cmp_packet_ruleset_tech_flag_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->helptxt, real_packet->helptxt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'helptxt' has changed");
    DIO_PUT(string, &dout, "helptxt", real_packet->helptxt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TECH_FLAG);
}

int send_packet_ruleset_tech_flag(struct connection *pc, const struct packet_ruleset_tech_flag *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_TECH_FLAG].packet != NULL, -1,
                        "Handler for PACKET_RULESET_TECH_FLAG not installed");
  return pc->phs.handlers->send[PACKET_RULESET_TECH_FLAG].packet(pc, packet);
}

void lsend_packet_ruleset_tech_flag(struct conn_list *dest, const struct packet_ruleset_tech_flag *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_tech_flag(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_government_100 hash_const

#define cmp_packet_ruleset_government_100 cmp_const

BV_DEFINE(packet_ruleset_government_100_fields, 8);

static struct packet_ruleset_government *receive_packet_ruleset_government_100(struct connection *pc)
{
  packet_ruleset_government_100_fields fields;
  struct packet_ruleset_government *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GOVERNMENT;
  RECEIVE_PACKET_START(packet_ruleset_government, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_government_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_100, cmp_packet_ruleset_government_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_government_100(struct connection *pc, const struct packet_ruleset_government *packet)
{
  const struct packet_ruleset_government *real_packet = packet;
  packet_ruleset_government_100_fields fields;
  struct packet_ruleset_government *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GOVERNMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GOVERNMENT);

  log_packet_detailed("packet_ruleset_government_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_100, cmp_packet_ruleset_government_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(sint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GOVERNMENT);
}

int send_packet_ruleset_government(struct connection *pc, const struct packet_ruleset_government *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_GOVERNMENT].packet != NULL, -1,
                        "Handler for PACKET_RULESET_GOVERNMENT not installed");
  return pc->phs.handlers->send[PACKET_RULESET_GOVERNMENT].packet(pc, packet);
}

void lsend_packet_ruleset_government(struct conn_list *dest, const struct packet_ruleset_government *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_government(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_control_100 hash_const

#define cmp_packet_ruleset_terrain_control_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_control_100_fields, 11);

static struct packet_ruleset_terrain_control *receive_packet_ruleset_terrain_control_100(struct connection *pc)
{
  packet_ruleset_terrain_control_100_fields fields;
  struct packet_ruleset_terrain_control *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TERRAIN_CONTROL;
  RECEIVE_PACKET_START(packet_ruleset_terrain_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_control_100, cmp_packet_ruleset_terrain_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ocean_reclaim_requirement_pct'");
    if (!DIO_GET(uint8, &din, "ocean_reclaim_requirement_pct", &real_packet->ocean_reclaim_requirement_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(ocean_reclaim_requirement_pct);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'land_channel_requirement_pct'");
    if (!DIO_GET(uint8, &din, "land_channel_requirement_pct", &real_packet->land_channel_requirement_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(land_channel_requirement_pct);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'terrain_thaw_requirement_pct'");
    if (!DIO_GET(uint8, &din, "terrain_thaw_requirement_pct", &real_packet->terrain_thaw_requirement_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(terrain_thaw_requirement_pct);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'terrain_freeze_requirement_pct'");
    if (!DIO_GET(uint8, &din, "terrain_freeze_requirement_pct", &real_packet->terrain_freeze_requirement_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(terrain_freeze_requirement_pct);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'lake_max_size'");
    if (!DIO_GET(uint8, &din, "lake_max_size", &real_packet->lake_max_size)) {
      RECEIVE_PACKET_FIELD_ERROR(lake_max_size);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'min_start_native_area'");
    if (!DIO_GET(uint8, &din, "min_start_native_area", &real_packet->min_start_native_area)) {
      RECEIVE_PACKET_FIELD_ERROR(min_start_native_area);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'move_fragments'");
    if (!DIO_GET(uint16, &din, "move_fragments", &real_packet->move_fragments)) {
      RECEIVE_PACKET_FIELD_ERROR(move_fragments);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'igter_cost'");
    if (!DIO_GET(uint16, &din, "igter_cost", &real_packet->igter_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(igter_cost);
    }
  }
  real_packet->pythagorean_diagonal = BV_ISSET(fields, 8);
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'gui_type_base0'");
    if (!DIO_GET(string, &din, "gui_type_base0", real_packet->gui_type_base0, sizeof(real_packet->gui_type_base0))) {
      RECEIVE_PACKET_FIELD_ERROR(gui_type_base0);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'gui_type_base1'");
    if (!DIO_GET(string, &din, "gui_type_base1", real_packet->gui_type_base1, sizeof(real_packet->gui_type_base1))) {
      RECEIVE_PACKET_FIELD_ERROR(gui_type_base1);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_control_100(struct connection *pc, const struct packet_ruleset_terrain_control *packet)
{
  const struct packet_ruleset_terrain_control *real_packet = packet;
  packet_ruleset_terrain_control_100_fields fields;
  struct packet_ruleset_terrain_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN_CONTROL);

  log_packet_detailed("packet_ruleset_terrain_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_control_100, cmp_packet_ruleset_terrain_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ocean_reclaim_requirement_pct != real_packet->ocean_reclaim_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->land_channel_requirement_pct != real_packet->land_channel_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->terrain_thaw_requirement_pct != real_packet->terrain_thaw_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->terrain_freeze_requirement_pct != real_packet->terrain_freeze_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->lake_max_size != real_packet->lake_max_size);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->min_start_native_area != real_packet->min_start_native_area);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->move_fragments != real_packet->move_fragments);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->igter_cost != real_packet->igter_cost);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->pythagorean_diagonal != real_packet->pythagorean_diagonal);
  if(differ) {
    different++;
  }
  if (packet->pythagorean_diagonal) {
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->gui_type_base0, real_packet->gui_type_base0) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->gui_type_base1, real_packet->gui_type_base1) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ocean_reclaim_requirement_pct' has changed");
    DIO_PUT(uint8, &dout, "ocean_reclaim_requirement_pct", real_packet->ocean_reclaim_requirement_pct);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'land_channel_requirement_pct' has changed");
    DIO_PUT(uint8, &dout, "land_channel_requirement_pct", real_packet->land_channel_requirement_pct);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'terrain_thaw_requirement_pct' has changed");
    DIO_PUT(uint8, &dout, "terrain_thaw_requirement_pct", real_packet->terrain_thaw_requirement_pct);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'terrain_freeze_requirement_pct' has changed");
    DIO_PUT(uint8, &dout, "terrain_freeze_requirement_pct", real_packet->terrain_freeze_requirement_pct);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'lake_max_size' has changed");
    DIO_PUT(uint8, &dout, "lake_max_size", real_packet->lake_max_size);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'min_start_native_area' has changed");
    DIO_PUT(uint8, &dout, "min_start_native_area", real_packet->min_start_native_area);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'move_fragments' has changed");
    DIO_PUT(uint16, &dout, "move_fragments", real_packet->move_fragments);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'igter_cost' has changed");
    DIO_PUT(uint16, &dout, "igter_cost", real_packet->igter_cost);
  }
  /* field 8 is folded into the header */
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'gui_type_base0' has changed");
    DIO_PUT(string, &dout, "gui_type_base0", real_packet->gui_type_base0);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'gui_type_base1' has changed");
    DIO_PUT(string, &dout, "gui_type_base1", real_packet->gui_type_base1);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TERRAIN_CONTROL);
}

int send_packet_ruleset_terrain_control(struct connection *pc, const struct packet_ruleset_terrain_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_TERRAIN_CONTROL].packet != NULL, -1,
                        "Handler for PACKET_RULESET_TERRAIN_CONTROL not installed");
  return pc->phs.handlers->send[PACKET_RULESET_TERRAIN_CONTROL].packet(pc, packet);
}

void lsend_packet_ruleset_terrain_control(struct conn_list *dest, const struct packet_ruleset_terrain_control *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain_control(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_rulesets_ready *receive_packet_rulesets_ready_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_rulesets_ready, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_rulesets_ready_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_rulesets_ready_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_RULESETS_READY);

  log_packet_detailed("packet_rulesets_ready_100: sending info about ()");
  SEND_PACKET_END(PACKET_RULESETS_READY);
}

int send_packet_rulesets_ready(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESETS_READY].no_packet != NULL, -1,
                        "Handler for PACKET_RULESETS_READY not installed");
  return pc->phs.handlers->send[PACKET_RULESETS_READY].no_packet(pc);
}

void lsend_packet_rulesets_ready(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_rulesets_ready(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_nation_sets_100 hash_const

#define cmp_packet_ruleset_nation_sets_100 cmp_const

BV_DEFINE(packet_ruleset_nation_sets_100_fields, 4);

static struct packet_ruleset_nation_sets *receive_packet_ruleset_nation_sets_100(struct connection *pc)
{
  packet_ruleset_nation_sets_100_fields fields;
  struct packet_ruleset_nation_sets *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_NATION_SETS;
  RECEIVE_PACKET_START(packet_ruleset_nation_sets, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_nation_sets_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_sets_100, cmp_packet_ruleset_nation_sets_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'nsets'");
    if (!DIO_GET(uint8, &din, "nsets", &real_packet->nsets)) {
      RECEIVE_PACKET_FIELD_ERROR(nsets);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'names'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(names, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!DIO_GET(string, &din, "names", real_packet->names[i], sizeof(real_packet->names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(names);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_names'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(rule_names, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!DIO_GET(string, &din, "rule_names", real_packet->rule_names[i], sizeof(real_packet->rule_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(rule_names);
        }
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'descriptions'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(descriptions, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!DIO_GET(string, &din, "descriptions", real_packet->descriptions[i], sizeof(real_packet->descriptions[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(descriptions);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_sets_100(struct connection *pc, const struct packet_ruleset_nation_sets *packet)
{
  const struct packet_ruleset_nation_sets *real_packet = packet;
  packet_ruleset_nation_sets_100_fields fields;
  struct packet_ruleset_nation_sets *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION_SETS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION_SETS);

  log_packet_detailed("packet_ruleset_nation_sets_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_sets_100, cmp_packet_ruleset_nation_sets_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->nsets != real_packet->nsets);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (strcmp(old->names[i], real_packet->names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (strcmp(old->rule_names[i], real_packet->rule_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (strcmp(old->descriptions[i], real_packet->descriptions[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'nsets' has changed");
    DIO_PUT(uint8, &dout, "nsets", real_packet->nsets);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_string(&dout, real_packet->names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_string(&dout, real_packet->rule_names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'descriptions' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_string(&dout, real_packet->descriptions[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_NATION_SETS);
}

int send_packet_ruleset_nation_sets(struct connection *pc, const struct packet_ruleset_nation_sets *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_NATION_SETS].packet != NULL, -1,
                        "Handler for PACKET_RULESET_NATION_SETS not installed");
  return pc->phs.handlers->send[PACKET_RULESET_NATION_SETS].packet(pc, packet);
}

void lsend_packet_ruleset_nation_sets(struct conn_list *dest, const struct packet_ruleset_nation_sets *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation_sets(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_nation_groups_100 hash_const

#define cmp_packet_ruleset_nation_groups_100 cmp_const

BV_DEFINE(packet_ruleset_nation_groups_100_fields, 3);

static struct packet_ruleset_nation_groups *receive_packet_ruleset_nation_groups_100(struct connection *pc)
{
  packet_ruleset_nation_groups_100_fields fields;
  struct packet_ruleset_nation_groups *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_NATION_GROUPS;
  RECEIVE_PACKET_START(packet_ruleset_nation_groups, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_nation_groups_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_groups_100, cmp_packet_ruleset_nation_groups_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ngroups'");
    if (!DIO_GET(uint8, &din, "ngroups", &real_packet->ngroups)) {
      RECEIVE_PACKET_FIELD_ERROR(ngroups);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'groups'");
    
    {
      int i;
    
      if (real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        RECEIVE_PACKET_FIELD_ERROR(groups, ": truncation array");
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        if (!DIO_GET(string, &din, "groups", real_packet->groups[i], sizeof(real_packet->groups[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(groups);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'hidden'");
    
    {
      int i;
    
      if (real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        RECEIVE_PACKET_FIELD_ERROR(hidden, ": truncation array");
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        if (!DIO_GET(bool8, &din, "hidden", &real_packet->hidden[i])) {
          RECEIVE_PACKET_FIELD_ERROR(hidden);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_groups_100(struct connection *pc, const struct packet_ruleset_nation_groups *packet)
{
  const struct packet_ruleset_nation_groups *real_packet = packet;
  packet_ruleset_nation_groups_100_fields fields;
  struct packet_ruleset_nation_groups *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION_GROUPS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION_GROUPS);

  log_packet_detailed("packet_ruleset_nation_groups_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_groups_100, cmp_packet_ruleset_nation_groups_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ngroups != real_packet->ngroups);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (strcmp(old->groups[i], real_packet->groups[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (old->hidden[i] != real_packet->hidden[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ngroups' has changed");
    DIO_PUT(uint8, &dout, "ngroups", real_packet->ngroups);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'groups' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_string(&dout, real_packet->groups[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'hidden' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_bool8(&dout, real_packet->hidden[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_NATION_GROUPS);
}

int send_packet_ruleset_nation_groups(struct connection *pc, const struct packet_ruleset_nation_groups *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_NATION_GROUPS].packet != NULL, -1,
                        "Handler for PACKET_RULESET_NATION_GROUPS not installed");
  return pc->phs.handlers->send[PACKET_RULESET_NATION_GROUPS].packet(pc, packet);
}

void lsend_packet_ruleset_nation_groups(struct conn_list *dest, const struct packet_ruleset_nation_groups *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation_groups(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_ruleset_nation_100(const void *vkey)
{
  const struct packet_ruleset_nation *key = (const struct packet_ruleset_nation *) vkey;

  return key->id;
}

static bool cmp_packet_ruleset_nation_100(const void *vkey1, const void *vkey2)
{
  const struct packet_ruleset_nation *key1 = (const struct packet_ruleset_nation *) vkey1;
  const struct packet_ruleset_nation *key2 = (const struct packet_ruleset_nation *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_ruleset_nation_100_fields, 21);

static struct packet_ruleset_nation *receive_packet_ruleset_nation_100(struct connection *pc)
{
  packet_ruleset_nation_100_fields fields;
  struct packet_ruleset_nation *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_NATION;
  RECEIVE_PACKET_START(packet_ruleset_nation, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
    
    if (!DIO_GET(sint16, &din, "id", &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
    real_packet->id = readin;
  }

  log_packet_detailed("packet_ruleset_nation_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_100, cmp_packet_ruleset_nation_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    Nation_type_id id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'translation_domain'");
    if (!DIO_GET(string, &din, "translation_domain", real_packet->translation_domain, sizeof(real_packet->translation_domain))) {
      RECEIVE_PACKET_FIELD_ERROR(translation_domain);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'adjective'");
    if (!DIO_GET(string, &din, "adjective", real_packet->adjective, sizeof(real_packet->adjective))) {
      RECEIVE_PACKET_FIELD_ERROR(adjective);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'noun_plural'");
    if (!DIO_GET(string, &din, "noun_plural", real_packet->noun_plural, sizeof(real_packet->noun_plural))) {
      RECEIVE_PACKET_FIELD_ERROR(noun_plural);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'legend'");
    if (!DIO_GET(string, &din, "legend", real_packet->legend, sizeof(real_packet->legend))) {
      RECEIVE_PACKET_FIELD_ERROR(legend);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'style'");
    if (!DIO_GET(uint8, &din, "style", &real_packet->style)) {
      RECEIVE_PACKET_FIELD_ERROR(style);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'leader_count'");
    if (!DIO_GET(uint8, &din, "leader_count", &real_packet->leader_count)) {
      RECEIVE_PACKET_FIELD_ERROR(leader_count);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'leader_name'");
    
    {
      int i;
    
      if (real_packet->leader_count > MAX_NUM_LEADERS) {
        RECEIVE_PACKET_FIELD_ERROR(leader_name, ": truncation array");
      }
      for (i = 0; i < real_packet->leader_count; i++) {
        if (!DIO_GET(string, &din, "leader_name", real_packet->leader_name[i], sizeof(real_packet->leader_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(leader_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'leader_is_male'");
    
    {
      int i;
    
      if (real_packet->leader_count > MAX_NUM_LEADERS) {
        RECEIVE_PACKET_FIELD_ERROR(leader_is_male, ": truncation array");
      }
      for (i = 0; i < real_packet->leader_count; i++) {
        if (!DIO_GET(bool8, &din, "leader_is_male", &real_packet->leader_is_male[i])) {
          RECEIVE_PACKET_FIELD_ERROR(leader_is_male);
        }
      }
    }
  }
  real_packet->is_playable = BV_ISSET(fields, 11);
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'barbarian_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "barbarian_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(barbarian_type);
      }
      real_packet->barbarian_type = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nsets'");
    if (!DIO_GET(uint8, &din, "nsets", &real_packet->nsets)) {
      RECEIVE_PACKET_FIELD_ERROR(nsets);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'sets'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(sets, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!DIO_GET(uint8, &din, "sets", &real_packet->sets[i])) {
          RECEIVE_PACKET_FIELD_ERROR(sets);
        }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'ngroups'");
    if (!DIO_GET(uint8, &din, "ngroups", &real_packet->ngroups)) {
      RECEIVE_PACKET_FIELD_ERROR(ngroups);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'groups'");
    
    {
      int i;
    
      if (real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        RECEIVE_PACKET_FIELD_ERROR(groups, ": truncation array");
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        if (!DIO_GET(uint8, &din, "groups", &real_packet->groups[i])) {
          RECEIVE_PACKET_FIELD_ERROR(groups);
        }
      }
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'init_government_id'");
    {
      int readin;
      
      if (!DIO_GET(sint8, &din, "init_government_id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(init_government_id);
      }
      real_packet->init_government_id = readin;
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'init_techs'");
    if (!DIO_GET(tech_list, &din, "init_techs", real_packet->init_techs)) {
      RECEIVE_PACKET_FIELD_ERROR(init_techs);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'init_units'");
    if (!DIO_GET(unit_list, &din, "init_units", real_packet->init_units)) {
      RECEIVE_PACKET_FIELD_ERROR(init_units);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'init_buildings'");
    if (!DIO_GET(building_list, &din, "init_buildings", real_packet->init_buildings)) {
      RECEIVE_PACKET_FIELD_ERROR(init_buildings);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_100(struct connection *pc, const struct packet_ruleset_nation *packet)
{
  const struct packet_ruleset_nation *real_packet = packet;
  packet_ruleset_nation_100_fields fields;
  struct packet_ruleset_nation *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION);

  log_packet_detailed("packet_ruleset_nation_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_100, cmp_packet_ruleset_nation_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->translation_domain, real_packet->translation_domain) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->adjective, real_packet->adjective) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->noun_plural, real_packet->noun_plural) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->legend, real_packet->legend) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->style != real_packet->style);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->leader_count != real_packet->leader_count);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->leader_count != real_packet->leader_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->leader_count; i++) {
          if (strcmp(old->leader_name[i], real_packet->leader_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = (old->leader_count != real_packet->leader_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->leader_count; i++) {
          if (old->leader_is_male[i] != real_packet->leader_is_male[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->is_playable != real_packet->is_playable);
  if(differ) {
    different++;
  }
  if (packet->is_playable) {
    BV_SET(fields, 11);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->nsets != real_packet->nsets);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (old->sets[i] != real_packet->sets[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->ngroups != real_packet->ngroups);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (old->groups[i] != real_packet->groups[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->init_government_id != real_packet->init_government_id);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->init_techs[i] != real_packet->init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = (MAX_NUM_UNIT_LIST != MAX_NUM_UNIT_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_UNIT_LIST; i++) {
          if (old->init_units[i] != real_packet->init_units[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->init_buildings[i] != real_packet->init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(sint16, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'translation_domain' has changed");
    DIO_PUT(string, &dout, "translation_domain", real_packet->translation_domain);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'adjective' has changed");
    DIO_PUT(string, &dout, "adjective", real_packet->adjective);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'noun_plural' has changed");
    DIO_PUT(string, &dout, "noun_plural", real_packet->noun_plural);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'legend' has changed");
    DIO_PUT(string, &dout, "legend", real_packet->legend);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'style' has changed");
    DIO_PUT(uint8, &dout, "style", real_packet->style);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'leader_count' has changed");
    DIO_PUT(uint8, &dout, "leader_count", real_packet->leader_count);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'leader_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->leader_count; i++) {
        dio_put_string(&dout, real_packet->leader_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'leader_is_male' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->leader_count; i++) {
        dio_put_bool8(&dout, real_packet->leader_is_male[i]);
      }
    } 
  }
  /* field 11 is folded into the header */
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    DIO_PUT(uint8, &dout, "barbarian_type", real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nsets' has changed");
    DIO_PUT(uint8, &dout, "nsets", real_packet->nsets);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'sets' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_uint8(&dout, real_packet->sets[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'ngroups' has changed");
    DIO_PUT(uint8, &dout, "ngroups", real_packet->ngroups);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'groups' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_uint8(&dout, real_packet->groups[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'init_government_id' has changed");
    DIO_PUT(sint8, &dout, "init_government_id", real_packet->init_government_id);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'init_techs' has changed");
    DIO_PUT(tech_list, &dout, "init_techs", real_packet->init_techs);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'init_units' has changed");
    DIO_PUT(unit_list, &dout, "init_units", real_packet->init_units);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'init_buildings' has changed");
    DIO_PUT(building_list, &dout, "init_buildings", real_packet->init_buildings);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_NATION);
}

int send_packet_ruleset_nation(struct connection *pc, const struct packet_ruleset_nation *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_NATION].packet != NULL, -1,
                        "Handler for PACKET_RULESET_NATION not installed");
  return pc->phs.handlers->send[PACKET_RULESET_NATION].packet(pc, packet);
}

void lsend_packet_ruleset_nation(struct conn_list *dest, const struct packet_ruleset_nation *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_nation_availability_100 hash_const

#define cmp_packet_nation_availability_100 cmp_const

BV_DEFINE(packet_nation_availability_100_fields, 3);

static struct packet_nation_availability *receive_packet_nation_availability_100(struct connection *pc)
{
  packet_nation_availability_100_fields fields;
  struct packet_nation_availability *old;
  struct genhash **hash = pc->phs.received + PACKET_NATION_AVAILABILITY;
  RECEIVE_PACKET_START(packet_nation_availability, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nation_availability_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_availability_100, cmp_packet_nation_availability_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ncount'");
    if (!DIO_GET(uint16, &din, "ncount", &real_packet->ncount)) {
      RECEIVE_PACKET_FIELD_ERROR(ncount);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'is_pickable'");
    
    {
      int i;
    
      if (real_packet->ncount > MAX_NUM_NATIONS) {
        RECEIVE_PACKET_FIELD_ERROR(is_pickable, ": truncation array");
      }
      for (i = 0; i < real_packet->ncount; i++) {
        if (!DIO_GET(bool8, &din, "is_pickable", &real_packet->is_pickable[i])) {
          RECEIVE_PACKET_FIELD_ERROR(is_pickable);
        }
      }
    }
  }
  real_packet->nationset_change = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_availability_100(struct connection *pc, const struct packet_nation_availability *packet)
{
  const struct packet_nation_availability *real_packet = packet;
  packet_nation_availability_100_fields fields;
  struct packet_nation_availability *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_AVAILABILITY;
  int different = 0;
  SEND_PACKET_START(PACKET_NATION_AVAILABILITY);

  log_packet_detailed("packet_nation_availability_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_availability_100, cmp_packet_nation_availability_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ncount != real_packet->ncount);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ncount != real_packet->ncount);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ncount; i++) {
          if (old->is_pickable[i] != real_packet->is_pickable[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->nationset_change != real_packet->nationset_change);
  if(differ) {
    different++;
  }
  if (packet->nationset_change) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ncount' has changed");
    DIO_PUT(uint16, &dout, "ncount", real_packet->ncount);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'is_pickable' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ncount; i++) {
        dio_put_bool8(&dout, real_packet->is_pickable[i]);
      }
    } 
  }
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NATION_AVAILABILITY);
}

int send_packet_nation_availability(struct connection *pc, const struct packet_nation_availability *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_NATION_AVAILABILITY].packet != NULL, -1,
                        "Handler for PACKET_NATION_AVAILABILITY not installed");
  return pc->phs.handlers->send[PACKET_NATION_AVAILABILITY].packet(pc, packet);
}

void lsend_packet_nation_availability(struct conn_list *dest, const struct packet_nation_availability *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_nation_availability(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_style_100 hash_const

#define cmp_packet_ruleset_style_100 cmp_const

BV_DEFINE(packet_ruleset_style_100_fields, 3);

static struct packet_ruleset_style *receive_packet_ruleset_style_100(struct connection *pc)
{
  packet_ruleset_style_100_fields fields;
  struct packet_ruleset_style *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_STYLE;
  RECEIVE_PACKET_START(packet_ruleset_style, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_style_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_style_100, cmp_packet_ruleset_style_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_style_100(struct connection *pc, const struct packet_ruleset_style *packet)
{
  const struct packet_ruleset_style *real_packet = packet;
  packet_ruleset_style_100_fields fields;
  struct packet_ruleset_style *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_STYLE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_STYLE);

  log_packet_detailed("packet_ruleset_style_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_style_100, cmp_packet_ruleset_style_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_STYLE);
}

int send_packet_ruleset_style(struct connection *pc, const struct packet_ruleset_style *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_STYLE].packet != NULL, -1,
                        "Handler for PACKET_RULESET_STYLE not installed");
  return pc->phs.handlers->send[PACKET_RULESET_STYLE].packet(pc, packet);
}

void lsend_packet_ruleset_style(struct conn_list *dest, const struct packet_ruleset_style *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_style(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_city_100 hash_const

#define cmp_packet_ruleset_city_100 cmp_const

BV_DEFINE(packet_ruleset_city_100_fields, 9);

static struct packet_ruleset_city *receive_packet_ruleset_city_100(struct connection *pc)
{
  packet_ruleset_city_100_fields fields;
  struct packet_ruleset_city *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_CITY;
  RECEIVE_PACKET_START(packet_ruleset_city, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_city_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_city_100, cmp_packet_ruleset_city_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'style_id'");
    if (!DIO_GET(uint8, &din, "style_id", &real_packet->style_id)) {
      RECEIVE_PACKET_FIELD_ERROR(style_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'citizens_graphic'");
    if (!DIO_GET(string, &din, "citizens_graphic", real_packet->citizens_graphic, sizeof(real_packet->citizens_graphic))) {
      RECEIVE_PACKET_FIELD_ERROR(citizens_graphic);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'citizens_graphic_alt'");
    if (!DIO_GET(string, &din, "citizens_graphic_alt", real_packet->citizens_graphic_alt, sizeof(real_packet->citizens_graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(citizens_graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'graphic'");
    if (!DIO_GET(string, &din, "graphic", real_packet->graphic, sizeof(real_packet->graphic))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_city_100(struct connection *pc, const struct packet_ruleset_city *packet)
{
  const struct packet_ruleset_city *real_packet = packet;
  packet_ruleset_city_100_fields fields;
  struct packet_ruleset_city *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CITY;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CITY);

  log_packet_detailed("packet_ruleset_city_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_city_100, cmp_packet_ruleset_city_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->style_id != real_packet->style_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->citizens_graphic, real_packet->citizens_graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->citizens_graphic_alt, real_packet->citizens_graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->graphic, real_packet->graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'style_id' has changed");
    DIO_PUT(uint8, &dout, "style_id", real_packet->style_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'citizens_graphic' has changed");
    DIO_PUT(string, &dout, "citizens_graphic", real_packet->citizens_graphic);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'citizens_graphic_alt' has changed");
    DIO_PUT(string, &dout, "citizens_graphic_alt", real_packet->citizens_graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'graphic' has changed");
    DIO_PUT(string, &dout, "graphic", real_packet->graphic);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_CITY);
}

int send_packet_ruleset_city(struct connection *pc, const struct packet_ruleset_city *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_CITY].packet != NULL, -1,
                        "Handler for PACKET_RULESET_CITY not installed");
  return pc->phs.handlers->send[PACKET_RULESET_CITY].packet(pc, packet);
}

void lsend_packet_ruleset_city(struct conn_list *dest, const struct packet_ruleset_city *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_city(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_building_100 hash_const

#define cmp_packet_ruleset_building_100 cmp_const

BV_DEFINE(packet_ruleset_building_100_fields, 17);

static struct packet_ruleset_building *receive_packet_ruleset_building_100(struct connection *pc)
{
  packet_ruleset_building_100_fields fields;
  struct packet_ruleset_building *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_BUILDING;
  RECEIVE_PACKET_START(packet_ruleset_building, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_building_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_building_100, cmp_packet_ruleset_building_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'genus'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "genus", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(genus);
      }
      real_packet->genus = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'obs_count'");
    if (!DIO_GET(uint8, &din, "obs_count", &real_packet->obs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(obs_count);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'obs_reqs'");
    
    {
      int i;
    
      if (real_packet->obs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(obs_reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->obs_count; i++) {
        if (!DIO_GET(requirement, &din, "obs_reqs", &real_packet->obs_reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(obs_reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    if (!DIO_GET(uint16, &din, "build_cost", &real_packet->build_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(build_cost);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'upkeep'");
    if (!DIO_GET(uint8, &din, "upkeep", &real_packet->upkeep)) {
      RECEIVE_PACKET_FIELD_ERROR(upkeep);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'sabotage'");
    if (!DIO_GET(uint8, &din, "sabotage", &real_packet->sabotage)) {
      RECEIVE_PACKET_FIELD_ERROR(sabotage);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'soundtag'");
    if (!DIO_GET(string, &din, "soundtag", real_packet->soundtag, sizeof(real_packet->soundtag))) {
      RECEIVE_PACKET_FIELD_ERROR(soundtag);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'soundtag_alt'");
    if (!DIO_GET(string, &din, "soundtag_alt", real_packet->soundtag_alt, sizeof(real_packet->soundtag_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(soundtag_alt);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_building_100(struct connection *pc, const struct packet_ruleset_building *packet)
{
  const struct packet_ruleset_building *real_packet = packet;
  packet_ruleset_building_100_fields fields;
  struct packet_ruleset_building *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_BUILDING;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_BUILDING);

  log_packet_detailed("packet_ruleset_building_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_building_100, cmp_packet_ruleset_building_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->genus != real_packet->genus);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->obs_count != real_packet->obs_count);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->obs_count != real_packet->obs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->obs_count; i++) {
          if (!are_requirements_equal(&old->obs_reqs[i], &real_packet->obs_reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->upkeep != real_packet->upkeep);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->sabotage != real_packet->sabotage);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (strcmp(old->soundtag, real_packet->soundtag) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (strcmp(old->soundtag_alt, real_packet->soundtag_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'genus' has changed");
    DIO_PUT(uint8, &dout, "genus", real_packet->genus);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'obs_count' has changed");
    DIO_PUT(uint8, &dout, "obs_count", real_packet->obs_count);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'obs_reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->obs_count; i++) {
        dio_put_requirement(&dout, &real_packet->obs_reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    DIO_PUT(uint16, &dout, "build_cost", real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'upkeep' has changed");
    DIO_PUT(uint8, &dout, "upkeep", real_packet->upkeep);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'sabotage' has changed");
    DIO_PUT(uint8, &dout, "sabotage", real_packet->sabotage);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'soundtag' has changed");
    DIO_PUT(string, &dout, "soundtag", real_packet->soundtag);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'soundtag_alt' has changed");
    DIO_PUT(string, &dout, "soundtag_alt", real_packet->soundtag_alt);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_BUILDING);
}

int send_packet_ruleset_building(struct connection *pc, const struct packet_ruleset_building *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_BUILDING].packet != NULL, -1,
                        "Handler for PACKET_RULESET_BUILDING not installed");
  return pc->phs.handlers->send[PACKET_RULESET_BUILDING].packet(pc, packet);
}

void lsend_packet_ruleset_building(struct conn_list *dest, const struct packet_ruleset_building *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_building(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_100 hash_const

#define cmp_packet_ruleset_terrain_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_100_fields, 32);

static struct packet_ruleset_terrain *receive_packet_ruleset_terrain_100(struct connection *pc)
{
  packet_ruleset_terrain_100_fields fields;
  struct packet_ruleset_terrain *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TERRAIN;
  RECEIVE_PACKET_START(packet_ruleset_terrain, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_100, cmp_packet_ruleset_terrain_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tclass'");
    if (!DIO_GET(uint8, &din, "tclass", &real_packet->tclass)) {
      RECEIVE_PACKET_FIELD_ERROR(tclass);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'native_to'");
    if (!DIO_BV_GET(&din, real_packet->native_to)) {
      RECEIVE_PACKET_FIELD_ERROR(native_to);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'movement_cost'");
    if (!DIO_GET(uint8, &din, "movement_cost", &real_packet->movement_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(movement_cost);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'defense_bonus'");
    if (!DIO_GET(sint16, &din, "defense_bonus", &real_packet->defense_bonus)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_bonus);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint8, &din, "output", &real_packet->output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(output);
        }
      }
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'num_resources'");
    if (!DIO_GET(uint8, &din, "num_resources", &real_packet->num_resources)) {
      RECEIVE_PACKET_FIELD_ERROR(num_resources);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'resources'");
    
    {
      int i;
    
      if (real_packet->num_resources > MAX_NUM_RESOURCES) {
        RECEIVE_PACKET_FIELD_ERROR(resources, ": truncation array");
      }
      for (i = 0; i < real_packet->num_resources; i++) {
        {
          int readin;
      
          if (!DIO_GET(uint8, &din, "resources", &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(resources);
          }
          real_packet->resources[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'road_output_incr_pct'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint16, &din, "road_output_incr_pct", &real_packet->road_output_incr_pct[i])) {
          RECEIVE_PACKET_FIELD_ERROR(road_output_incr_pct);
        }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'base_time'");
    if (!DIO_GET(uint8, &din, "base_time", &real_packet->base_time)) {
      RECEIVE_PACKET_FIELD_ERROR(base_time);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'road_time'");
    if (!DIO_GET(uint8, &din, "road_time", &real_packet->road_time)) {
      RECEIVE_PACKET_FIELD_ERROR(road_time);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'irrigation_result'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "irrigation_result", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(irrigation_result);
      }
      real_packet->irrigation_result = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'irrigation_food_incr'");
    if (!DIO_GET(uint8, &din, "irrigation_food_incr", &real_packet->irrigation_food_incr)) {
      RECEIVE_PACKET_FIELD_ERROR(irrigation_food_incr);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'irrigation_time'");
    if (!DIO_GET(uint8, &din, "irrigation_time", &real_packet->irrigation_time)) {
      RECEIVE_PACKET_FIELD_ERROR(irrigation_time);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'mining_result'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "mining_result", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(mining_result);
      }
      real_packet->mining_result = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'mining_shield_incr'");
    if (!DIO_GET(uint8, &din, "mining_shield_incr", &real_packet->mining_shield_incr)) {
      RECEIVE_PACKET_FIELD_ERROR(mining_shield_incr);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'mining_time'");
    if (!DIO_GET(uint8, &din, "mining_time", &real_packet->mining_time)) {
      RECEIVE_PACKET_FIELD_ERROR(mining_time);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'animal'");
    if (!DIO_GET(sint16, &din, "animal", &real_packet->animal)) {
      RECEIVE_PACKET_FIELD_ERROR(animal);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'transform_result'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "transform_result", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(transform_result);
      }
      real_packet->transform_result = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'transform_time'");
    if (!DIO_GET(uint8, &din, "transform_time", &real_packet->transform_time)) {
      RECEIVE_PACKET_FIELD_ERROR(transform_time);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'clean_pollution_time'");
    if (!DIO_GET(uint8, &din, "clean_pollution_time", &real_packet->clean_pollution_time)) {
      RECEIVE_PACKET_FIELD_ERROR(clean_pollution_time);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'clean_fallout_time'");
    if (!DIO_GET(uint8, &din, "clean_fallout_time", &real_packet->clean_fallout_time)) {
      RECEIVE_PACKET_FIELD_ERROR(clean_fallout_time);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'pillage_time'");
    if (!DIO_GET(uint8, &din, "pillage_time", &real_packet->pillage_time)) {
      RECEIVE_PACKET_FIELD_ERROR(pillage_time);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'color_red'");
    if (!DIO_GET(uint8, &din, "color_red", &real_packet->color_red)) {
      RECEIVE_PACKET_FIELD_ERROR(color_red);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'color_green'");
    if (!DIO_GET(uint8, &din, "color_green", &real_packet->color_green)) {
      RECEIVE_PACKET_FIELD_ERROR(color_green);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'color_blue'");
    if (!DIO_GET(uint8, &din, "color_blue", &real_packet->color_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(color_blue);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_100(struct connection *pc, const struct packet_ruleset_terrain *packet)
{
  const struct packet_ruleset_terrain *real_packet = packet;
  packet_ruleset_terrain_100_fields fields;
  struct packet_ruleset_terrain *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN);

  log_packet_detailed("packet_ruleset_terrain_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_100, cmp_packet_ruleset_terrain_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tclass != real_packet->tclass);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->movement_cost != real_packet->movement_cost);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->output[i] != real_packet->output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->num_resources != real_packet->num_resources);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->num_resources != real_packet->num_resources);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->num_resources; i++) {
          if (old->resources[i] != real_packet->resources[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->road_output_incr_pct[i] != real_packet->road_output_incr_pct[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->base_time != real_packet->base_time);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->road_time != real_packet->road_time);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->irrigation_result != real_packet->irrigation_result);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->irrigation_food_incr != real_packet->irrigation_food_incr);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->irrigation_time != real_packet->irrigation_time);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->mining_result != real_packet->mining_result);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->mining_shield_incr != real_packet->mining_shield_incr);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->mining_time != real_packet->mining_time);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->animal != real_packet->animal);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->transform_result != real_packet->transform_result);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->transform_time != real_packet->transform_time);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->clean_pollution_time != real_packet->clean_pollution_time);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->clean_fallout_time != real_packet->clean_fallout_time);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->pillage_time != real_packet->pillage_time);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tclass' has changed");
    DIO_PUT(uint8, &dout, "tclass", real_packet->tclass);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'native_to' has changed");
  DIO_BV_PUT(&dout, "native_to", packet->native_to);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'movement_cost' has changed");
    DIO_PUT(uint8, &dout, "movement_cost", real_packet->movement_cost);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'defense_bonus' has changed");
    DIO_PUT(sint16, &dout, "defense_bonus", real_packet->defense_bonus);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'num_resources' has changed");
    DIO_PUT(uint8, &dout, "num_resources", real_packet->num_resources);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'resources' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->num_resources; i++) {
        dio_put_uint8(&dout, real_packet->resources[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'road_output_incr_pct' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->road_output_incr_pct[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'base_time' has changed");
    DIO_PUT(uint8, &dout, "base_time", real_packet->base_time);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'road_time' has changed");
    DIO_PUT(uint8, &dout, "road_time", real_packet->road_time);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'irrigation_result' has changed");
    DIO_PUT(uint8, &dout, "irrigation_result", real_packet->irrigation_result);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'irrigation_food_incr' has changed");
    DIO_PUT(uint8, &dout, "irrigation_food_incr", real_packet->irrigation_food_incr);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'irrigation_time' has changed");
    DIO_PUT(uint8, &dout, "irrigation_time", real_packet->irrigation_time);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'mining_result' has changed");
    DIO_PUT(uint8, &dout, "mining_result", real_packet->mining_result);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'mining_shield_incr' has changed");
    DIO_PUT(uint8, &dout, "mining_shield_incr", real_packet->mining_shield_incr);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'mining_time' has changed");
    DIO_PUT(uint8, &dout, "mining_time", real_packet->mining_time);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'animal' has changed");
    DIO_PUT(sint16, &dout, "animal", real_packet->animal);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'transform_result' has changed");
    DIO_PUT(uint8, &dout, "transform_result", real_packet->transform_result);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'transform_time' has changed");
    DIO_PUT(uint8, &dout, "transform_time", real_packet->transform_time);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'clean_pollution_time' has changed");
    DIO_PUT(uint8, &dout, "clean_pollution_time", real_packet->clean_pollution_time);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'clean_fallout_time' has changed");
    DIO_PUT(uint8, &dout, "clean_fallout_time", real_packet->clean_fallout_time);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'pillage_time' has changed");
    DIO_PUT(uint8, &dout, "pillage_time", real_packet->pillage_time);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'color_red' has changed");
    DIO_PUT(uint8, &dout, "color_red", real_packet->color_red);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'color_green' has changed");
    DIO_PUT(uint8, &dout, "color_green", real_packet->color_green);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'color_blue' has changed");
    DIO_PUT(uint8, &dout, "color_blue", real_packet->color_blue);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TERRAIN);
}

int send_packet_ruleset_terrain(struct connection *pc, const struct packet_ruleset_terrain *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_TERRAIN].packet != NULL, -1,
                        "Handler for PACKET_RULESET_TERRAIN not installed");
  return pc->phs.handlers->send[PACKET_RULESET_TERRAIN].packet(pc, packet);
}

void lsend_packet_ruleset_terrain(struct conn_list *dest, const struct packet_ruleset_terrain *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_flag_100 hash_const

#define cmp_packet_ruleset_terrain_flag_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_flag_100_fields, 3);

static struct packet_ruleset_terrain_flag *receive_packet_ruleset_terrain_flag_100(struct connection *pc)
{
  packet_ruleset_terrain_flag_100_fields fields;
  struct packet_ruleset_terrain_flag *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TERRAIN_FLAG;
  RECEIVE_PACKET_START(packet_ruleset_terrain_flag, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_flag_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_flag_100, cmp_packet_ruleset_terrain_flag_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'helptxt'");
    if (!DIO_GET(string, &din, "helptxt", real_packet->helptxt, sizeof(real_packet->helptxt))) {
      RECEIVE_PACKET_FIELD_ERROR(helptxt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_flag_100(struct connection *pc, const struct packet_ruleset_terrain_flag *packet)
{
  const struct packet_ruleset_terrain_flag *real_packet = packet;
  packet_ruleset_terrain_flag_100_fields fields;
  struct packet_ruleset_terrain_flag *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN_FLAG;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN_FLAG);

  log_packet_detailed("packet_ruleset_terrain_flag_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_flag_100, cmp_packet_ruleset_terrain_flag_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->helptxt, real_packet->helptxt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'helptxt' has changed");
    DIO_PUT(string, &dout, "helptxt", real_packet->helptxt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TERRAIN_FLAG);
}

int send_packet_ruleset_terrain_flag(struct connection *pc, const struct packet_ruleset_terrain_flag *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_TERRAIN_FLAG].packet != NULL, -1,
                        "Handler for PACKET_RULESET_TERRAIN_FLAG not installed");
  return pc->phs.handlers->send[PACKET_RULESET_TERRAIN_FLAG].packet(pc, packet);
}

void lsend_packet_ruleset_terrain_flag(struct conn_list *dest, const struct packet_ruleset_terrain_flag *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain_flag(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_class_100 hash_const

#define cmp_packet_ruleset_unit_class_100 cmp_const

BV_DEFINE(packet_ruleset_unit_class_100_fields, 9);

static struct packet_ruleset_unit_class *receive_packet_ruleset_unit_class_100(struct connection *pc)
{
  packet_ruleset_unit_class_100_fields fields;
  struct packet_ruleset_unit_class *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_CLASS;
  RECEIVE_PACKET_START(packet_ruleset_unit_class, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_class_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_100, cmp_packet_ruleset_unit_class_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'min_speed'");
    if (!DIO_GET(uint16, &din, "min_speed", &real_packet->min_speed)) {
      RECEIVE_PACKET_FIELD_ERROR(min_speed);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'hp_loss_pct'");
    if (!DIO_GET(uint8, &din, "hp_loss_pct", &real_packet->hp_loss_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(hp_loss_pct);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'hut_behavior'");
    if (!DIO_GET(uint8, &din, "hut_behavior", &real_packet->hut_behavior)) {
      RECEIVE_PACKET_FIELD_ERROR(hut_behavior);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'non_native_def_pct'");
    if (!DIO_GET(uint16, &din, "non_native_def_pct", &real_packet->non_native_def_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(non_native_def_pct);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_class_100(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  const struct packet_ruleset_unit_class *real_packet = packet;
  packet_ruleset_unit_class_100_fields fields;
  struct packet_ruleset_unit_class *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_CLASS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_CLASS);

  log_packet_detailed("packet_ruleset_unit_class_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_100, cmp_packet_ruleset_unit_class_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->min_speed != real_packet->min_speed);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->hp_loss_pct != real_packet->hp_loss_pct);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->hut_behavior != real_packet->hut_behavior);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->non_native_def_pct != real_packet->non_native_def_pct);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'min_speed' has changed");
    DIO_PUT(uint16, &dout, "min_speed", real_packet->min_speed);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'hp_loss_pct' has changed");
    DIO_PUT(uint8, &dout, "hp_loss_pct", real_packet->hp_loss_pct);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'hut_behavior' has changed");
    DIO_PUT(uint8, &dout, "hut_behavior", real_packet->hut_behavior);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'non_native_def_pct' has changed");
    DIO_PUT(uint16, &dout, "non_native_def_pct", real_packet->non_native_def_pct);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_CLASS);
}

int send_packet_ruleset_unit_class(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_UNIT_CLASS].packet != NULL, -1,
                        "Handler for PACKET_RULESET_UNIT_CLASS not installed");
  return pc->phs.handlers->send[PACKET_RULESET_UNIT_CLASS].packet(pc, packet);
}

void lsend_packet_ruleset_unit_class(struct conn_list *dest, const struct packet_ruleset_unit_class *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_class(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_extra_100 hash_const

#define cmp_packet_ruleset_extra_100 cmp_const

BV_DEFINE(packet_ruleset_extra_100_fields, 28);

static struct packet_ruleset_extra *receive_packet_ruleset_extra_100(struct connection *pc)
{
  packet_ruleset_extra_100_fields fields;
  struct packet_ruleset_extra *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_EXTRA;
  RECEIVE_PACKET_START(packet_ruleset_extra, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_extra_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_extra_100, cmp_packet_ruleset_extra_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'category'");
    if (!DIO_GET(uint8, &din, "category", &real_packet->category)) {
      RECEIVE_PACKET_FIELD_ERROR(category);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'causes'");
    if (!DIO_GET(uint8, &din, "causes", &real_packet->causes)) {
      RECEIVE_PACKET_FIELD_ERROR(causes);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'rmcauses'");
    if (!DIO_GET(uint8, &din, "rmcauses", &real_packet->rmcauses)) {
      RECEIVE_PACKET_FIELD_ERROR(rmcauses);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'activity_gfx'");
    if (!DIO_GET(string, &din, "activity_gfx", real_packet->activity_gfx, sizeof(real_packet->activity_gfx))) {
      RECEIVE_PACKET_FIELD_ERROR(activity_gfx);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'act_gfx_alt'");
    if (!DIO_GET(string, &din, "act_gfx_alt", real_packet->act_gfx_alt, sizeof(real_packet->act_gfx_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(act_gfx_alt);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'act_gfx_alt2'");
    if (!DIO_GET(string, &din, "act_gfx_alt2", real_packet->act_gfx_alt2, sizeof(real_packet->act_gfx_alt2))) {
      RECEIVE_PACKET_FIELD_ERROR(act_gfx_alt2);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'rmact_gfx'");
    if (!DIO_GET(string, &din, "rmact_gfx", real_packet->rmact_gfx, sizeof(real_packet->rmact_gfx))) {
      RECEIVE_PACKET_FIELD_ERROR(rmact_gfx);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'rmact_gfx_alt'");
    if (!DIO_GET(string, &din, "rmact_gfx_alt", real_packet->rmact_gfx_alt, sizeof(real_packet->rmact_gfx_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(rmact_gfx_alt);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'rmreqs_count'");
    if (!DIO_GET(uint8, &din, "rmreqs_count", &real_packet->rmreqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(rmreqs_count);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'rmreqs'");
    
    {
      int i;
    
      if (real_packet->rmreqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(rmreqs, ": truncation array");
      }
      for (i = 0; i < real_packet->rmreqs_count; i++) {
        if (!DIO_GET(requirement, &din, "rmreqs", &real_packet->rmreqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(rmreqs);
        }
      }
    }
  }
  real_packet->buildable = BV_ISSET(fields, 17);
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'build_time'");
    if (!DIO_GET(uint8, &din, "build_time", &real_packet->build_time)) {
      RECEIVE_PACKET_FIELD_ERROR(build_time);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'build_time_factor'");
    if (!DIO_GET(uint8, &din, "build_time_factor", &real_packet->build_time_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(build_time_factor);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'removal_time'");
    if (!DIO_GET(uint8, &din, "removal_time", &real_packet->removal_time)) {
      RECEIVE_PACKET_FIELD_ERROR(removal_time);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'removal_time_factor'");
    if (!DIO_GET(uint8, &din, "removal_time_factor", &real_packet->removal_time_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(removal_time_factor);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'defense_bonus'");
    if (!DIO_GET(uint8, &din, "defense_bonus", &real_packet->defense_bonus)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_bonus);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'native_to'");
    if (!DIO_BV_GET(&din, real_packet->native_to)) {
      RECEIVE_PACKET_FIELD_ERROR(native_to);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'hidden_by'");
    if (!DIO_BV_GET(&din, real_packet->hidden_by)) {
      RECEIVE_PACKET_FIELD_ERROR(hidden_by);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'conflicts'");
    if (!DIO_BV_GET(&din, real_packet->conflicts)) {
      RECEIVE_PACKET_FIELD_ERROR(conflicts);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_extra_100(struct connection *pc, const struct packet_ruleset_extra *packet)
{
  const struct packet_ruleset_extra *real_packet = packet;
  packet_ruleset_extra_100_fields fields;
  struct packet_ruleset_extra *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_EXTRA;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_EXTRA);

  log_packet_detailed("packet_ruleset_extra_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_extra_100, cmp_packet_ruleset_extra_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->category != real_packet->category);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->causes != real_packet->causes);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->rmcauses != real_packet->rmcauses);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->activity_gfx, real_packet->activity_gfx) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->act_gfx_alt, real_packet->act_gfx_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->act_gfx_alt2, real_packet->act_gfx_alt2) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->rmact_gfx, real_packet->rmact_gfx) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->rmact_gfx_alt, real_packet->rmact_gfx_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->rmreqs_count != real_packet->rmreqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (old->rmreqs_count != real_packet->rmreqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->rmreqs_count; i++) {
          if (!are_requirements_equal(&old->rmreqs[i], &real_packet->rmreqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->buildable != real_packet->buildable);
  if(differ) {
    different++;
  }
  if (packet->buildable) {
    BV_SET(fields, 17);
  }

  differ = (old->build_time != real_packet->build_time);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->build_time_factor != real_packet->build_time_factor);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->removal_time != real_packet->removal_time);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->removal_time_factor != real_packet->removal_time_factor);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = !BV_ARE_EQUAL(old->hidden_by, real_packet->hidden_by);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = !BV_ARE_EQUAL(old->conflicts, real_packet->conflicts);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'category' has changed");
    DIO_PUT(uint8, &dout, "category", real_packet->category);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'causes' has changed");
    DIO_PUT(uint8, &dout, "causes", real_packet->causes);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'rmcauses' has changed");
    DIO_PUT(uint8, &dout, "rmcauses", real_packet->rmcauses);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'activity_gfx' has changed");
    DIO_PUT(string, &dout, "activity_gfx", real_packet->activity_gfx);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'act_gfx_alt' has changed");
    DIO_PUT(string, &dout, "act_gfx_alt", real_packet->act_gfx_alt);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'act_gfx_alt2' has changed");
    DIO_PUT(string, &dout, "act_gfx_alt2", real_packet->act_gfx_alt2);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'rmact_gfx' has changed");
    DIO_PUT(string, &dout, "rmact_gfx", real_packet->rmact_gfx);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'rmact_gfx_alt' has changed");
    DIO_PUT(string, &dout, "rmact_gfx_alt", real_packet->rmact_gfx_alt);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'rmreqs_count' has changed");
    DIO_PUT(uint8, &dout, "rmreqs_count", real_packet->rmreqs_count);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'rmreqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->rmreqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->rmreqs[i]);
      }
    } 
  }
  /* field 17 is folded into the header */
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'build_time' has changed");
    DIO_PUT(uint8, &dout, "build_time", real_packet->build_time);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'build_time_factor' has changed");
    DIO_PUT(uint8, &dout, "build_time_factor", real_packet->build_time_factor);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'removal_time' has changed");
    DIO_PUT(uint8, &dout, "removal_time", real_packet->removal_time);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'removal_time_factor' has changed");
    DIO_PUT(uint8, &dout, "removal_time_factor", real_packet->removal_time_factor);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'defense_bonus' has changed");
    DIO_PUT(uint8, &dout, "defense_bonus", real_packet->defense_bonus);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'native_to' has changed");
  DIO_BV_PUT(&dout, "native_to", packet->native_to);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'hidden_by' has changed");
  DIO_BV_PUT(&dout, "hidden_by", packet->hidden_by);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'conflicts' has changed");
  DIO_BV_PUT(&dout, "conflicts", packet->conflicts);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_EXTRA);
}

int send_packet_ruleset_extra(struct connection *pc, const struct packet_ruleset_extra *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_EXTRA].packet != NULL, -1,
                        "Handler for PACKET_RULESET_EXTRA not installed");
  return pc->phs.handlers->send[PACKET_RULESET_EXTRA].packet(pc, packet);
}

void lsend_packet_ruleset_extra(struct conn_list *dest, const struct packet_ruleset_extra *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_extra(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_base_100 hash_const

#define cmp_packet_ruleset_base_100 cmp_const

BV_DEFINE(packet_ruleset_base_100_fields, 6);

static struct packet_ruleset_base *receive_packet_ruleset_base_100(struct connection *pc)
{
  packet_ruleset_base_100_fields fields;
  struct packet_ruleset_base *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_BASE;
  RECEIVE_PACKET_START(packet_ruleset_base, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_base_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_base_100, cmp_packet_ruleset_base_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'gui_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "gui_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gui_type);
      }
      real_packet->gui_type = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'border_sq'");
    if (!DIO_GET(sint8, &din, "border_sq", &real_packet->border_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_sq);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'vision_main_sq'");
    if (!DIO_GET(sint8, &din, "vision_main_sq", &real_packet->vision_main_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_main_sq);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'vision_invis_sq'");
    if (!DIO_GET(sint8, &din, "vision_invis_sq", &real_packet->vision_invis_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_invis_sq);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_base_100(struct connection *pc, const struct packet_ruleset_base *packet)
{
  const struct packet_ruleset_base *real_packet = packet;
  packet_ruleset_base_100_fields fields;
  struct packet_ruleset_base *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_BASE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_BASE);

  log_packet_detailed("packet_ruleset_base_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_base_100, cmp_packet_ruleset_base_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->gui_type != real_packet->gui_type);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->border_sq != real_packet->border_sq);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->vision_main_sq != real_packet->vision_main_sq);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->vision_invis_sq != real_packet->vision_invis_sq);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'gui_type' has changed");
    DIO_PUT(uint8, &dout, "gui_type", real_packet->gui_type);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'border_sq' has changed");
    DIO_PUT(sint8, &dout, "border_sq", real_packet->border_sq);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'vision_main_sq' has changed");
    DIO_PUT(sint8, &dout, "vision_main_sq", real_packet->vision_main_sq);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'vision_invis_sq' has changed");
    DIO_PUT(sint8, &dout, "vision_invis_sq", real_packet->vision_invis_sq);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_BASE);
}

int send_packet_ruleset_base(struct connection *pc, const struct packet_ruleset_base *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_BASE].packet != NULL, -1,
                        "Handler for PACKET_RULESET_BASE not installed");
  return pc->phs.handlers->send[PACKET_RULESET_BASE].packet(pc, packet);
}

void lsend_packet_ruleset_base(struct conn_list *dest, const struct packet_ruleset_base *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_base(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_road_100 hash_const

#define cmp_packet_ruleset_road_100 cmp_const

BV_DEFINE(packet_ruleset_road_100_fields, 11);

static struct packet_ruleset_road *receive_packet_ruleset_road_100(struct connection *pc)
{
  packet_ruleset_road_100_fields fields;
  struct packet_ruleset_road *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_ROAD;
  RECEIVE_PACKET_START(packet_ruleset_road, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_road_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_road_100, cmp_packet_ruleset_road_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'first_reqs_count'");
    if (!DIO_GET(uint8, &din, "first_reqs_count", &real_packet->first_reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(first_reqs_count);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'first_reqs'");
    
    {
      int i;
    
      if (real_packet->first_reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(first_reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->first_reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "first_reqs", &real_packet->first_reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(first_reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'move_cost'");
    if (!DIO_GET(sint16, &din, "move_cost", &real_packet->move_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(move_cost);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'move_mode'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "move_mode", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(move_mode);
      }
      real_packet->move_mode = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'tile_incr_const'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint16, &din, "tile_incr_const", &real_packet->tile_incr_const[i])) {
          RECEIVE_PACKET_FIELD_ERROR(tile_incr_const);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'tile_incr'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint16, &din, "tile_incr", &real_packet->tile_incr[i])) {
          RECEIVE_PACKET_FIELD_ERROR(tile_incr);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'tile_bonus'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint16, &din, "tile_bonus", &real_packet->tile_bonus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(tile_bonus);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'compat'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "compat", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(compat);
      }
      real_packet->compat = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'integrates'");
    if (!DIO_BV_GET(&din, real_packet->integrates)) {
      RECEIVE_PACKET_FIELD_ERROR(integrates);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_road_100(struct connection *pc, const struct packet_ruleset_road *packet)
{
  const struct packet_ruleset_road *real_packet = packet;
  packet_ruleset_road_100_fields fields;
  struct packet_ruleset_road *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_ROAD;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_ROAD);

  log_packet_detailed("packet_ruleset_road_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_road_100, cmp_packet_ruleset_road_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->first_reqs_count != real_packet->first_reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->first_reqs_count != real_packet->first_reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->first_reqs_count; i++) {
          if (!are_requirements_equal(&old->first_reqs[i], &real_packet->first_reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->move_cost != real_packet->move_cost);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->move_mode != real_packet->move_mode);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->tile_incr_const[i] != real_packet->tile_incr_const[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->tile_incr[i] != real_packet->tile_incr[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->tile_bonus[i] != real_packet->tile_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->compat != real_packet->compat);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = !BV_ARE_EQUAL(old->integrates, real_packet->integrates);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'first_reqs_count' has changed");
    DIO_PUT(uint8, &dout, "first_reqs_count", real_packet->first_reqs_count);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'first_reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->first_reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->first_reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'move_cost' has changed");
    DIO_PUT(sint16, &dout, "move_cost", real_packet->move_cost);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'move_mode' has changed");
    DIO_PUT(uint8, &dout, "move_mode", real_packet->move_mode);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'tile_incr_const' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->tile_incr_const[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'tile_incr' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->tile_incr[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'tile_bonus' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->tile_bonus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'compat' has changed");
    DIO_PUT(uint8, &dout, "compat", real_packet->compat);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'integrates' has changed");
  DIO_BV_PUT(&dout, "integrates", packet->integrates);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, "flags", packet->flags);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_ROAD);
}

int send_packet_ruleset_road(struct connection *pc, const struct packet_ruleset_road *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_ROAD].packet != NULL, -1,
                        "Handler for PACKET_RULESET_ROAD not installed");
  return pc->phs.handlers->send[PACKET_RULESET_ROAD].packet(pc, packet);
}

void lsend_packet_ruleset_road(struct conn_list *dest, const struct packet_ruleset_road *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_road(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_disaster_100 hash_const

#define cmp_packet_ruleset_disaster_100 cmp_const

BV_DEFINE(packet_ruleset_disaster_100_fields, 7);

static struct packet_ruleset_disaster *receive_packet_ruleset_disaster_100(struct connection *pc)
{
  packet_ruleset_disaster_100_fields fields;
  struct packet_ruleset_disaster *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_DISASTER;
  RECEIVE_PACKET_START(packet_ruleset_disaster, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_disaster_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_disaster_100, cmp_packet_ruleset_disaster_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'frequency'");
    if (!DIO_GET(uint8, &din, "frequency", &real_packet->frequency)) {
      RECEIVE_PACKET_FIELD_ERROR(frequency);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'effects'");
    if (!DIO_BV_GET(&din, real_packet->effects)) {
      RECEIVE_PACKET_FIELD_ERROR(effects);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_disaster_100(struct connection *pc, const struct packet_ruleset_disaster *packet)
{
  const struct packet_ruleset_disaster *real_packet = packet;
  packet_ruleset_disaster_100_fields fields;
  struct packet_ruleset_disaster *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_DISASTER;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_DISASTER);

  log_packet_detailed("packet_ruleset_disaster_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_disaster_100, cmp_packet_ruleset_disaster_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->frequency != real_packet->frequency);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = !BV_ARE_EQUAL(old->effects, real_packet->effects);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'frequency' has changed");
    DIO_PUT(uint8, &dout, "frequency", real_packet->frequency);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'effects' has changed");
  DIO_BV_PUT(&dout, "effects", packet->effects);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_DISASTER);
}

int send_packet_ruleset_disaster(struct connection *pc, const struct packet_ruleset_disaster *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_DISASTER].packet != NULL, -1,
                        "Handler for PACKET_RULESET_DISASTER not installed");
  return pc->phs.handlers->send[PACKET_RULESET_DISASTER].packet(pc, packet);
}

void lsend_packet_ruleset_disaster(struct conn_list *dest, const struct packet_ruleset_disaster *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_disaster(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_achievement_100 hash_const

#define cmp_packet_ruleset_achievement_100 cmp_const

BV_DEFINE(packet_ruleset_achievement_100_fields, 6);

static struct packet_ruleset_achievement *receive_packet_ruleset_achievement_100(struct connection *pc)
{
  packet_ruleset_achievement_100_fields fields;
  struct packet_ruleset_achievement *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_ACHIEVEMENT;
  RECEIVE_PACKET_START(packet_ruleset_achievement, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_achievement_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_achievement_100, cmp_packet_ruleset_achievement_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  real_packet->unique = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'value'");
    if (!DIO_GET(uint16, &din, "value", &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_achievement_100(struct connection *pc, const struct packet_ruleset_achievement *packet)
{
  const struct packet_ruleset_achievement *real_packet = packet;
  packet_ruleset_achievement_100_fields fields;
  struct packet_ruleset_achievement *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_ACHIEVEMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_ACHIEVEMENT);

  log_packet_detailed("packet_ruleset_achievement_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_achievement_100, cmp_packet_ruleset_achievement_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->unique != real_packet->unique);
  if(differ) {
    different++;
  }
  if (packet->unique) {
    BV_SET(fields, 4);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'type' has changed");
    DIO_PUT(uint8, &dout, "type", real_packet->type);
  }
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'value' has changed");
    DIO_PUT(uint16, &dout, "value", real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_ACHIEVEMENT);
}

int send_packet_ruleset_achievement(struct connection *pc, const struct packet_ruleset_achievement *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_ACHIEVEMENT].packet != NULL, -1,
                        "Handler for PACKET_RULESET_ACHIEVEMENT not installed");
  return pc->phs.handlers->send[PACKET_RULESET_ACHIEVEMENT].packet(pc, packet);
}

void lsend_packet_ruleset_achievement(struct conn_list *dest, const struct packet_ruleset_achievement *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_achievement(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_trade_100 hash_const

#define cmp_packet_ruleset_trade_100 cmp_const

BV_DEFINE(packet_ruleset_trade_100_fields, 4);

static struct packet_ruleset_trade *receive_packet_ruleset_trade_100(struct connection *pc)
{
  packet_ruleset_trade_100_fields fields;
  struct packet_ruleset_trade *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TRADE;
  RECEIVE_PACKET_START(packet_ruleset_trade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_trade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_trade_100, cmp_packet_ruleset_trade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'trade_pct'");
    if (!DIO_GET(uint16, &din, "trade_pct", &real_packet->trade_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(trade_pct);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'cancelling'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "cancelling", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(cancelling);
      }
      real_packet->cancelling = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'bonus_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "bonus_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(bonus_type);
      }
      real_packet->bonus_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_trade_100(struct connection *pc, const struct packet_ruleset_trade *packet)
{
  const struct packet_ruleset_trade *real_packet = packet;
  packet_ruleset_trade_100_fields fields;
  struct packet_ruleset_trade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TRADE);

  log_packet_detailed("packet_ruleset_trade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_trade_100, cmp_packet_ruleset_trade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->trade_pct != real_packet->trade_pct);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->cancelling != real_packet->cancelling);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->bonus_type != real_packet->bonus_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'trade_pct' has changed");
    DIO_PUT(uint16, &dout, "trade_pct", real_packet->trade_pct);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'cancelling' has changed");
    DIO_PUT(uint8, &dout, "cancelling", real_packet->cancelling);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'bonus_type' has changed");
    DIO_PUT(uint8, &dout, "bonus_type", real_packet->bonus_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TRADE);
}

int send_packet_ruleset_trade(struct connection *pc, const struct packet_ruleset_trade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_TRADE].packet != NULL, -1,
                        "Handler for PACKET_RULESET_TRADE not installed");
  return pc->phs.handlers->send[PACKET_RULESET_TRADE].packet(pc, packet);
}

void lsend_packet_ruleset_trade(struct conn_list *dest, const struct packet_ruleset_trade *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_trade(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_action_100 hash_const

#define cmp_packet_ruleset_action_100 cmp_const

BV_DEFINE(packet_ruleset_action_100_fields, 3);

static struct packet_ruleset_action *receive_packet_ruleset_action_100(struct connection *pc)
{
  packet_ruleset_action_100_fields fields;
  struct packet_ruleset_action *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_ACTION;
  RECEIVE_PACKET_START(packet_ruleset_action, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_action_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_action_100, cmp_packet_ruleset_action_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'ui_name'");
    if (!DIO_GET(string, &din, "ui_name", real_packet->ui_name, sizeof(real_packet->ui_name))) {
      RECEIVE_PACKET_FIELD_ERROR(ui_name);
    }
  }
  real_packet->quiet = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_action_100(struct connection *pc, const struct packet_ruleset_action *packet)
{
  const struct packet_ruleset_action *real_packet = packet;
  packet_ruleset_action_100_fields fields;
  struct packet_ruleset_action *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_ACTION;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_ACTION);

  log_packet_detailed("packet_ruleset_action_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_action_100, cmp_packet_ruleset_action_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->ui_name, real_packet->ui_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->quiet != real_packet->quiet);
  if(differ) {
    different++;
  }
  if (packet->quiet) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'ui_name' has changed");
    DIO_PUT(string, &dout, "ui_name", real_packet->ui_name);
  }
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_ACTION);
}

int send_packet_ruleset_action(struct connection *pc, const struct packet_ruleset_action *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_ACTION].packet != NULL, -1,
                        "Handler for PACKET_RULESET_ACTION not installed");
  return pc->phs.handlers->send[PACKET_RULESET_ACTION].packet(pc, packet);
}

void lsend_packet_ruleset_action(struct conn_list *dest, const struct packet_ruleset_action *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_action(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_action_enabler_100 hash_const

#define cmp_packet_ruleset_action_enabler_100 cmp_const

BV_DEFINE(packet_ruleset_action_enabler_100_fields, 5);

static struct packet_ruleset_action_enabler *receive_packet_ruleset_action_enabler_100(struct connection *pc)
{
  packet_ruleset_action_enabler_100_fields fields;
  struct packet_ruleset_action_enabler *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_ACTION_ENABLER;
  RECEIVE_PACKET_START(packet_ruleset_action_enabler, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_action_enabler_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_action_enabler_100, cmp_packet_ruleset_action_enabler_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'enabled_action'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "enabled_action", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(enabled_action);
      }
      real_packet->enabled_action = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'actor_reqs_count'");
    if (!DIO_GET(uint8, &din, "actor_reqs_count", &real_packet->actor_reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(actor_reqs_count);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'actor_reqs'");
    
    {
      int i;
    
      if (real_packet->actor_reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(actor_reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->actor_reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "actor_reqs", &real_packet->actor_reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(actor_reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'target_reqs_count'");
    if (!DIO_GET(uint8, &din, "target_reqs_count", &real_packet->target_reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(target_reqs_count);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'target_reqs'");
    
    {
      int i;
    
      if (real_packet->target_reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(target_reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->target_reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "target_reqs", &real_packet->target_reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(target_reqs);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_action_enabler_100(struct connection *pc, const struct packet_ruleset_action_enabler *packet)
{
  const struct packet_ruleset_action_enabler *real_packet = packet;
  packet_ruleset_action_enabler_100_fields fields;
  struct packet_ruleset_action_enabler *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_ACTION_ENABLER;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_ACTION_ENABLER);

  log_packet_detailed("packet_ruleset_action_enabler_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_action_enabler_100, cmp_packet_ruleset_action_enabler_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->enabled_action != real_packet->enabled_action);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->actor_reqs_count != real_packet->actor_reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->actor_reqs_count != real_packet->actor_reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->actor_reqs_count; i++) {
          if (!are_requirements_equal(&old->actor_reqs[i], &real_packet->actor_reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->target_reqs_count != real_packet->target_reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->target_reqs_count != real_packet->target_reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->target_reqs_count; i++) {
          if (!are_requirements_equal(&old->target_reqs[i], &real_packet->target_reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'enabled_action' has changed");
    DIO_PUT(uint8, &dout, "enabled_action", real_packet->enabled_action);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'actor_reqs_count' has changed");
    DIO_PUT(uint8, &dout, "actor_reqs_count", real_packet->actor_reqs_count);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'actor_reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->actor_reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->actor_reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'target_reqs_count' has changed");
    DIO_PUT(uint8, &dout, "target_reqs_count", real_packet->target_reqs_count);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'target_reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->target_reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->target_reqs[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_ACTION_ENABLER);
}

int send_packet_ruleset_action_enabler(struct connection *pc, const struct packet_ruleset_action_enabler *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_ACTION_ENABLER].packet != NULL, -1,
                        "Handler for PACKET_RULESET_ACTION_ENABLER not installed");
  return pc->phs.handlers->send[PACKET_RULESET_ACTION_ENABLER].packet(pc, packet);
}

void lsend_packet_ruleset_action_enabler(struct conn_list *dest, const struct packet_ruleset_action_enabler *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_action_enabler(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_music_100 hash_const

#define cmp_packet_ruleset_music_100 cmp_const

BV_DEFINE(packet_ruleset_music_100_fields, 5);

static struct packet_ruleset_music *receive_packet_ruleset_music_100(struct connection *pc)
{
  packet_ruleset_music_100_fields fields;
  struct packet_ruleset_music *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_MUSIC;
  RECEIVE_PACKET_START(packet_ruleset_music, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_music_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_music_100, cmp_packet_ruleset_music_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!DIO_GET(uint8, &din, "id", &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'music_peaceful'");
    if (!DIO_GET(string, &din, "music_peaceful", real_packet->music_peaceful, sizeof(real_packet->music_peaceful))) {
      RECEIVE_PACKET_FIELD_ERROR(music_peaceful);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'music_combat'");
    if (!DIO_GET(string, &din, "music_combat", real_packet->music_combat, sizeof(real_packet->music_combat))) {
      RECEIVE_PACKET_FIELD_ERROR(music_combat);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_music_100(struct connection *pc, const struct packet_ruleset_music *packet)
{
  const struct packet_ruleset_music *real_packet = packet;
  packet_ruleset_music_100_fields fields;
  struct packet_ruleset_music *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_MUSIC;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_MUSIC);

  log_packet_detailed("packet_ruleset_music_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_music_100, cmp_packet_ruleset_music_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->music_peaceful, real_packet->music_peaceful) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->music_combat, real_packet->music_combat) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'music_peaceful' has changed");
    DIO_PUT(string, &dout, "music_peaceful", real_packet->music_peaceful);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'music_combat' has changed");
    DIO_PUT(string, &dout, "music_combat", real_packet->music_combat);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_MUSIC);
}

int send_packet_ruleset_music(struct connection *pc, const struct packet_ruleset_music *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_MUSIC].packet != NULL, -1,
                        "Handler for PACKET_RULESET_MUSIC not installed");
  return pc->phs.handlers->send[PACKET_RULESET_MUSIC].packet(pc, packet);
}

void lsend_packet_ruleset_music(struct conn_list *dest, const struct packet_ruleset_music *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_music(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_multiplier_100 hash_const

#define cmp_packet_ruleset_multiplier_100 cmp_const

BV_DEFINE(packet_ruleset_multiplier_100_fields, 10);

static struct packet_ruleset_multiplier *receive_packet_ruleset_multiplier_100(struct connection *pc)
{
  packet_ruleset_multiplier_100_fields fields;
  struct packet_ruleset_multiplier *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_MULTIPLIER;
  RECEIVE_PACKET_START(packet_ruleset_multiplier, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_multiplier_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_multiplier_100, cmp_packet_ruleset_multiplier_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'start'");
    if (!DIO_GET(sint32, &din, "start", &real_packet->start)) {
      RECEIVE_PACKET_FIELD_ERROR(start);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'stop'");
    if (!DIO_GET(sint32, &din, "stop", &real_packet->stop)) {
      RECEIVE_PACKET_FIELD_ERROR(stop);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'step'");
    if (!DIO_GET(uint32, &din, "step", &real_packet->step)) {
      RECEIVE_PACKET_FIELD_ERROR(step);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'def'");
    if (!DIO_GET(sint32, &din, "def", &real_packet->def)) {
      RECEIVE_PACKET_FIELD_ERROR(def);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'offset'");
    if (!DIO_GET(sint32, &din, "offset", &real_packet->offset)) {
      RECEIVE_PACKET_FIELD_ERROR(offset);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'factor'");
    if (!DIO_GET(sint32, &din, "factor", &real_packet->factor)) {
      RECEIVE_PACKET_FIELD_ERROR(factor);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'helptext'");
    if (!DIO_GET(string, &din, "helptext", real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_multiplier_100(struct connection *pc, const struct packet_ruleset_multiplier *packet)
{
  const struct packet_ruleset_multiplier *real_packet = packet;
  packet_ruleset_multiplier_100_fields fields;
  struct packet_ruleset_multiplier *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_MULTIPLIER;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_MULTIPLIER);

  log_packet_detailed("packet_ruleset_multiplier_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_multiplier_100, cmp_packet_ruleset_multiplier_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->start != real_packet->start);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->stop != real_packet->stop);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->step != real_packet->step);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->def != real_packet->def);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->offset != real_packet->offset);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->factor != real_packet->factor);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'start' has changed");
    DIO_PUT(sint32, &dout, "start", real_packet->start);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'stop' has changed");
    DIO_PUT(sint32, &dout, "stop", real_packet->stop);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'step' has changed");
    DIO_PUT(uint32, &dout, "step", real_packet->step);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'def' has changed");
    DIO_PUT(sint32, &dout, "def", real_packet->def);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'offset' has changed");
    DIO_PUT(sint32, &dout, "offset", real_packet->offset);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'factor' has changed");
    DIO_PUT(sint32, &dout, "factor", real_packet->factor);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'helptext' has changed");
    DIO_PUT(string, &dout, "helptext", real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_MULTIPLIER);
}

int send_packet_ruleset_multiplier(struct connection *pc, const struct packet_ruleset_multiplier *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_MULTIPLIER].packet != NULL, -1,
                        "Handler for PACKET_RULESET_MULTIPLIER not installed");
  return pc->phs.handlers->send[PACKET_RULESET_MULTIPLIER].packet(pc, packet);
}

void lsend_packet_ruleset_multiplier(struct conn_list *dest, const struct packet_ruleset_multiplier *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_multiplier(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_ruleset_multiplier(struct connection *pc, Multiplier_type_id id, int start, int stop, int step, int def, int offset, int factor, const char *name, const char *rule_name, const char *helptext)
{
  struct packet_ruleset_multiplier packet, *real_packet = &packet;

  real_packet->id = id;
  real_packet->start = start;
  real_packet->stop = stop;
  real_packet->step = step;
  real_packet->def = def;
  real_packet->offset = offset;
  real_packet->factor = factor;
  sz_strlcpy(real_packet->name, name);
  sz_strlcpy(real_packet->rule_name, rule_name);
  sz_strlcpy(real_packet->helptext, helptext);
  
  return send_packet_ruleset_multiplier(pc, real_packet);
}

void dlsend_packet_ruleset_multiplier(struct conn_list *dest, Multiplier_type_id id, int start, int stop, int step, int def, int offset, int factor, const char *name, const char *rule_name, const char *helptext)
{
  struct packet_ruleset_multiplier packet, *real_packet = &packet;

  real_packet->id = id;
  real_packet->start = start;
  real_packet->stop = stop;
  real_packet->step = step;
  real_packet->def = def;
  real_packet->offset = offset;
  real_packet->factor = factor;
  sz_strlcpy(real_packet->name, name);
  sz_strlcpy(real_packet->rule_name, rule_name);
  sz_strlcpy(real_packet->helptext, helptext);
  
  lsend_packet_ruleset_multiplier(dest, real_packet);
}

#define hash_packet_ruleset_control_100 hash_const

#define cmp_packet_ruleset_control_100 cmp_const

BV_DEFINE(packet_ruleset_control_100_fields, 25);

static struct packet_ruleset_control *receive_packet_ruleset_control_100(struct connection *pc)
{
  packet_ruleset_control_100_fields fields;
  struct packet_ruleset_control *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_CONTROL;
  RECEIVE_PACKET_START(packet_ruleset_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_control_100, cmp_packet_ruleset_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'num_unit_classes'");
    if (!DIO_GET(uint16, &din, "num_unit_classes", &real_packet->num_unit_classes)) {
      RECEIVE_PACKET_FIELD_ERROR(num_unit_classes);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'num_unit_types'");
    if (!DIO_GET(uint16, &din, "num_unit_types", &real_packet->num_unit_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_unit_types);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'num_impr_types'");
    if (!DIO_GET(uint16, &din, "num_impr_types", &real_packet->num_impr_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_impr_types);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'num_tech_types'");
    if (!DIO_GET(uint16, &din, "num_tech_types", &real_packet->num_tech_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_tech_types);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'num_extra_types'");
    if (!DIO_GET(uint16, &din, "num_extra_types", &real_packet->num_extra_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_extra_types);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'num_base_types'");
    if (!DIO_GET(uint16, &din, "num_base_types", &real_packet->num_base_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_base_types);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'num_road_types'");
    if (!DIO_GET(uint16, &din, "num_road_types", &real_packet->num_road_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_road_types);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'num_disaster_types'");
    if (!DIO_GET(uint16, &din, "num_disaster_types", &real_packet->num_disaster_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_disaster_types);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'num_achievement_types'");
    if (!DIO_GET(uint16, &din, "num_achievement_types", &real_packet->num_achievement_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_achievement_types);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'num_multipliers'");
    if (!DIO_GET(uint16, &din, "num_multipliers", &real_packet->num_multipliers)) {
      RECEIVE_PACKET_FIELD_ERROR(num_multipliers);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'num_styles'");
    if (!DIO_GET(uint16, &din, "num_styles", &real_packet->num_styles)) {
      RECEIVE_PACKET_FIELD_ERROR(num_styles);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'num_music_styles'");
    if (!DIO_GET(uint16, &din, "num_music_styles", &real_packet->num_music_styles)) {
      RECEIVE_PACKET_FIELD_ERROR(num_music_styles);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'government_count'");
    if (!DIO_GET(uint16, &din, "government_count", &real_packet->government_count)) {
      RECEIVE_PACKET_FIELD_ERROR(government_count);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nation_count'");
    if (!DIO_GET(uint16, &din, "nation_count", &real_packet->nation_count)) {
      RECEIVE_PACKET_FIELD_ERROR(nation_count);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'styles_count'");
    if (!DIO_GET(uint16, &din, "styles_count", &real_packet->styles_count)) {
      RECEIVE_PACKET_FIELD_ERROR(styles_count);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'terrain_count'");
    if (!DIO_GET(uint16, &din, "terrain_count", &real_packet->terrain_count)) {
      RECEIVE_PACKET_FIELD_ERROR(terrain_count);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'resource_count'");
    if (!DIO_GET(uint16, &din, "resource_count", &real_packet->resource_count)) {
      RECEIVE_PACKET_FIELD_ERROR(resource_count);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'num_specialist_types'");
    if (!DIO_GET(uint16, &din, "num_specialist_types", &real_packet->num_specialist_types)) {
      RECEIVE_PACKET_FIELD_ERROR(num_specialist_types);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'preferred_tileset'");
    if (!DIO_GET(string, &din, "preferred_tileset", real_packet->preferred_tileset, sizeof(real_packet->preferred_tileset))) {
      RECEIVE_PACKET_FIELD_ERROR(preferred_tileset);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'preferred_soundset'");
    if (!DIO_GET(string, &din, "preferred_soundset", real_packet->preferred_soundset, sizeof(real_packet->preferred_soundset))) {
      RECEIVE_PACKET_FIELD_ERROR(preferred_soundset);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'preferred_musicset'");
    if (!DIO_GET(string, &din, "preferred_musicset", real_packet->preferred_musicset, sizeof(real_packet->preferred_musicset))) {
      RECEIVE_PACKET_FIELD_ERROR(preferred_musicset);
    }
  }
  real_packet->popup_tech_help = BV_ISSET(fields, 21);
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'version'");
    if (!DIO_GET(string, &din, "version", real_packet->version, sizeof(real_packet->version))) {
      RECEIVE_PACKET_FIELD_ERROR(version);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'desc_length'");
    if (!DIO_GET(uint16, &din, "desc_length", &real_packet->desc_length)) {
      RECEIVE_PACKET_FIELD_ERROR(desc_length);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_control_100(struct connection *pc, const struct packet_ruleset_control *packet)
{
  const struct packet_ruleset_control *real_packet = packet;
  packet_ruleset_control_100_fields fields;
  struct packet_ruleset_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CONTROL);

  log_packet_detailed("packet_ruleset_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_control_100, cmp_packet_ruleset_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->num_unit_classes != real_packet->num_unit_classes);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->num_unit_types != real_packet->num_unit_types);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->num_impr_types != real_packet->num_impr_types);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->num_tech_types != real_packet->num_tech_types);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->num_extra_types != real_packet->num_extra_types);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->num_base_types != real_packet->num_base_types);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->num_road_types != real_packet->num_road_types);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->num_disaster_types != real_packet->num_disaster_types);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->num_achievement_types != real_packet->num_achievement_types);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->num_multipliers != real_packet->num_multipliers);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->num_styles != real_packet->num_styles);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->num_music_styles != real_packet->num_music_styles);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->government_count != real_packet->government_count);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->nation_count != real_packet->nation_count);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->styles_count != real_packet->styles_count);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->terrain_count != real_packet->terrain_count);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->resource_count != real_packet->resource_count);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->num_specialist_types != real_packet->num_specialist_types);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (strcmp(old->preferred_tileset, real_packet->preferred_tileset) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (strcmp(old->preferred_soundset, real_packet->preferred_soundset) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (strcmp(old->preferred_musicset, real_packet->preferred_musicset) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->popup_tech_help != real_packet->popup_tech_help);
  if(differ) {
    different++;
  }
  if (packet->popup_tech_help) {
    BV_SET(fields, 21);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (strcmp(old->version, real_packet->version) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->desc_length != real_packet->desc_length);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'num_unit_classes' has changed");
    DIO_PUT(uint16, &dout, "num_unit_classes", real_packet->num_unit_classes);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'num_unit_types' has changed");
    DIO_PUT(uint16, &dout, "num_unit_types", real_packet->num_unit_types);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'num_impr_types' has changed");
    DIO_PUT(uint16, &dout, "num_impr_types", real_packet->num_impr_types);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'num_tech_types' has changed");
    DIO_PUT(uint16, &dout, "num_tech_types", real_packet->num_tech_types);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'num_extra_types' has changed");
    DIO_PUT(uint16, &dout, "num_extra_types", real_packet->num_extra_types);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'num_base_types' has changed");
    DIO_PUT(uint16, &dout, "num_base_types", real_packet->num_base_types);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'num_road_types' has changed");
    DIO_PUT(uint16, &dout, "num_road_types", real_packet->num_road_types);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'num_disaster_types' has changed");
    DIO_PUT(uint16, &dout, "num_disaster_types", real_packet->num_disaster_types);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'num_achievement_types' has changed");
    DIO_PUT(uint16, &dout, "num_achievement_types", real_packet->num_achievement_types);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'num_multipliers' has changed");
    DIO_PUT(uint16, &dout, "num_multipliers", real_packet->num_multipliers);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'num_styles' has changed");
    DIO_PUT(uint16, &dout, "num_styles", real_packet->num_styles);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'num_music_styles' has changed");
    DIO_PUT(uint16, &dout, "num_music_styles", real_packet->num_music_styles);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'government_count' has changed");
    DIO_PUT(uint16, &dout, "government_count", real_packet->government_count);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nation_count' has changed");
    DIO_PUT(uint16, &dout, "nation_count", real_packet->nation_count);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'styles_count' has changed");
    DIO_PUT(uint16, &dout, "styles_count", real_packet->styles_count);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'terrain_count' has changed");
    DIO_PUT(uint16, &dout, "terrain_count", real_packet->terrain_count);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'resource_count' has changed");
    DIO_PUT(uint16, &dout, "resource_count", real_packet->resource_count);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'num_specialist_types' has changed");
    DIO_PUT(uint16, &dout, "num_specialist_types", real_packet->num_specialist_types);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'preferred_tileset' has changed");
    DIO_PUT(string, &dout, "preferred_tileset", real_packet->preferred_tileset);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'preferred_soundset' has changed");
    DIO_PUT(string, &dout, "preferred_soundset", real_packet->preferred_soundset);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'preferred_musicset' has changed");
    DIO_PUT(string, &dout, "preferred_musicset", real_packet->preferred_musicset);
  }
  /* field 21 is folded into the header */
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'version' has changed");
    DIO_PUT(string, &dout, "version", real_packet->version);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'desc_length' has changed");
    DIO_PUT(uint16, &dout, "desc_length", real_packet->desc_length);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_CONTROL);
}

int send_packet_ruleset_control(struct connection *pc, const struct packet_ruleset_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_CONTROL].packet != NULL, -1,
                        "Handler for PACKET_RULESET_CONTROL not installed");
  return pc->phs.handlers->send[PACKET_RULESET_CONTROL].packet(pc, packet);
}

void lsend_packet_ruleset_control(struct conn_list *dest, const struct packet_ruleset_control *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_control(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_summary_100 hash_const

#define cmp_packet_ruleset_summary_100 cmp_const

BV_DEFINE(packet_ruleset_summary_100_fields, 1);

static struct packet_ruleset_summary *receive_packet_ruleset_summary_100(struct connection *pc)
{
  packet_ruleset_summary_100_fields fields;
  struct packet_ruleset_summary *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_SUMMARY;
  RECEIVE_PACKET_START(packet_ruleset_summary, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_summary_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_summary_100, cmp_packet_ruleset_summary_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'text'");
    if (!DIO_GET(string, &din, "text", real_packet->text, sizeof(real_packet->text))) {
      RECEIVE_PACKET_FIELD_ERROR(text);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_summary_100(struct connection *pc, const struct packet_ruleset_summary *packet)
{
  const struct packet_ruleset_summary *real_packet = packet;
  packet_ruleset_summary_100_fields fields;
  struct packet_ruleset_summary *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_SUMMARY;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_SUMMARY);

  log_packet_detailed("packet_ruleset_summary_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_summary_100, cmp_packet_ruleset_summary_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->text, real_packet->text) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'text' has changed");
    DIO_PUT(string, &dout, "text", real_packet->text);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_SUMMARY);
}

int send_packet_ruleset_summary(struct connection *pc, const struct packet_ruleset_summary *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_SUMMARY].packet != NULL, -1,
                        "Handler for PACKET_RULESET_SUMMARY not installed");
  return pc->phs.handlers->send[PACKET_RULESET_SUMMARY].packet(pc, packet);
}

void lsend_packet_ruleset_summary(struct conn_list *dest, const struct packet_ruleset_summary *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_summary(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_description_part_100 hash_const

#define cmp_packet_ruleset_description_part_100 cmp_const

BV_DEFINE(packet_ruleset_description_part_100_fields, 1);

static struct packet_ruleset_description_part *receive_packet_ruleset_description_part_100(struct connection *pc)
{
  packet_ruleset_description_part_100_fields fields;
  struct packet_ruleset_description_part *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_DESCRIPTION_PART;
  RECEIVE_PACKET_START(packet_ruleset_description_part, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_description_part_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_description_part_100, cmp_packet_ruleset_description_part_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'text'");
    if (!DIO_GET(string, &din, "text", real_packet->text, sizeof(real_packet->text))) {
      RECEIVE_PACKET_FIELD_ERROR(text);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_description_part_100(struct connection *pc, const struct packet_ruleset_description_part *packet)
{
  const struct packet_ruleset_description_part *real_packet = packet;
  packet_ruleset_description_part_100_fields fields;
  struct packet_ruleset_description_part *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_DESCRIPTION_PART;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_DESCRIPTION_PART);

  log_packet_detailed("packet_ruleset_description_part_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_description_part_100, cmp_packet_ruleset_description_part_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->text, real_packet->text) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'text' has changed");
    DIO_PUT(string, &dout, "text", real_packet->text);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_DESCRIPTION_PART);
}

int send_packet_ruleset_description_part(struct connection *pc, const struct packet_ruleset_description_part *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_DESCRIPTION_PART].packet != NULL, -1,
                        "Handler for PACKET_RULESET_DESCRIPTION_PART not installed");
  return pc->phs.handlers->send[PACKET_RULESET_DESCRIPTION_PART].packet(pc, packet);
}

void lsend_packet_ruleset_description_part(struct conn_list *dest, const struct packet_ruleset_description_part *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_description_part(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_single_want_hack_req_100 hash_const

#define cmp_packet_single_want_hack_req_100 cmp_const

BV_DEFINE(packet_single_want_hack_req_100_fields, 1);

static struct packet_single_want_hack_req *receive_packet_single_want_hack_req_100(struct connection *pc)
{
  packet_single_want_hack_req_100_fields fields;
  struct packet_single_want_hack_req *old;
  struct genhash **hash = pc->phs.received + PACKET_SINGLE_WANT_HACK_REQ;
  RECEIVE_PACKET_START(packet_single_want_hack_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_single_want_hack_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_req_100, cmp_packet_single_want_hack_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'token'");
    if (!DIO_GET(string, &din, "token", real_packet->token, sizeof(real_packet->token))) {
      RECEIVE_PACKET_FIELD_ERROR(token);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_single_want_hack_req_100(struct connection *pc, const struct packet_single_want_hack_req *packet)
{
  const struct packet_single_want_hack_req *real_packet = packet;
  packet_single_want_hack_req_100_fields fields;
  struct packet_single_want_hack_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SINGLE_WANT_HACK_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_SINGLE_WANT_HACK_REQ);

  log_packet_detailed("packet_single_want_hack_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_req_100, cmp_packet_single_want_hack_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->token, real_packet->token) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'token' has changed");
    DIO_PUT(string, &dout, "token", real_packet->token);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SINGLE_WANT_HACK_REQ);
}

int send_packet_single_want_hack_req(struct connection *pc, const struct packet_single_want_hack_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SINGLE_WANT_HACK_REQ].packet != NULL, -1,
                        "Handler for PACKET_SINGLE_WANT_HACK_REQ not installed");
  return pc->phs.handlers->send[PACKET_SINGLE_WANT_HACK_REQ].packet(pc, packet);
}

#define hash_packet_single_want_hack_reply_100 hash_const

#define cmp_packet_single_want_hack_reply_100 cmp_const

BV_DEFINE(packet_single_want_hack_reply_100_fields, 1);

static struct packet_single_want_hack_reply *receive_packet_single_want_hack_reply_100(struct connection *pc)
{
  packet_single_want_hack_reply_100_fields fields;
  struct packet_single_want_hack_reply *old;
  struct genhash **hash = pc->phs.received + PACKET_SINGLE_WANT_HACK_REPLY;
  RECEIVE_PACKET_START(packet_single_want_hack_reply, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_single_want_hack_reply_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_reply_100, cmp_packet_single_want_hack_reply_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->you_have_hack = BV_ISSET(fields, 0);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_single_want_hack_reply_100(struct connection *pc, const struct packet_single_want_hack_reply *packet)
{
  const struct packet_single_want_hack_reply *real_packet = packet;
  packet_single_want_hack_reply_100_fields fields;
  struct packet_single_want_hack_reply *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SINGLE_WANT_HACK_REPLY;
  int different = 0;
  SEND_PACKET_START(PACKET_SINGLE_WANT_HACK_REPLY);

  log_packet_detailed("packet_single_want_hack_reply_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_single_want_hack_reply_100, cmp_packet_single_want_hack_reply_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->you_have_hack != real_packet->you_have_hack);
  if(differ) {
    different++;
  }
  if (packet->you_have_hack) {
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  /* field 0 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SINGLE_WANT_HACK_REPLY);
}

int send_packet_single_want_hack_reply(struct connection *pc, const struct packet_single_want_hack_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SINGLE_WANT_HACK_REPLY].packet != NULL, -1,
                        "Handler for PACKET_SINGLE_WANT_HACK_REPLY not installed");
  return pc->phs.handlers->send[PACKET_SINGLE_WANT_HACK_REPLY].packet(pc, packet);
}

int dsend_packet_single_want_hack_reply(struct connection *pc, bool you_have_hack)
{
  struct packet_single_want_hack_reply packet, *real_packet = &packet;

  real_packet->you_have_hack = you_have_hack;
  
  return send_packet_single_want_hack_reply(pc, real_packet);
}

#define hash_packet_ruleset_choices_100 hash_const

#define cmp_packet_ruleset_choices_100 cmp_const

BV_DEFINE(packet_ruleset_choices_100_fields, 2);

static struct packet_ruleset_choices *receive_packet_ruleset_choices_100(struct connection *pc)
{
  packet_ruleset_choices_100_fields fields;
  struct packet_ruleset_choices *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_CHOICES;
  RECEIVE_PACKET_START(packet_ruleset_choices, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_choices_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_choices_100, cmp_packet_ruleset_choices_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ruleset_count'");
    if (!DIO_GET(uint8, &din, "ruleset_count", &real_packet->ruleset_count)) {
      RECEIVE_PACKET_FIELD_ERROR(ruleset_count);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'rulesets'");
    
    {
      int i;
    
      if (real_packet->ruleset_count > MAX_NUM_RULESETS) {
        RECEIVE_PACKET_FIELD_ERROR(rulesets, ": truncation array");
      }
      for (i = 0; i < real_packet->ruleset_count; i++) {
        if (!DIO_GET(string, &din, "rulesets", real_packet->rulesets[i], sizeof(real_packet->rulesets[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(rulesets);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_choices_100(struct connection *pc, const struct packet_ruleset_choices *packet)
{
  const struct packet_ruleset_choices *real_packet = packet;
  packet_ruleset_choices_100_fields fields;
  struct packet_ruleset_choices *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CHOICES;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CHOICES);

  log_packet_detailed("packet_ruleset_choices_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_choices_100, cmp_packet_ruleset_choices_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ruleset_count != real_packet->ruleset_count);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ruleset_count != real_packet->ruleset_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ruleset_count; i++) {
          if (strcmp(old->rulesets[i], real_packet->rulesets[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ruleset_count' has changed");
    DIO_PUT(uint8, &dout, "ruleset_count", real_packet->ruleset_count);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'rulesets' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ruleset_count; i++) {
        dio_put_string(&dout, real_packet->rulesets[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_CHOICES);
}

int send_packet_ruleset_choices(struct connection *pc, const struct packet_ruleset_choices *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_CHOICES].packet != NULL, -1,
                        "Handler for PACKET_RULESET_CHOICES not installed");
  return pc->phs.handlers->send[PACKET_RULESET_CHOICES].packet(pc, packet);
}

#define hash_packet_game_load_100 hash_const

#define cmp_packet_game_load_100 cmp_const

BV_DEFINE(packet_game_load_100_fields, 2);

static struct packet_game_load *receive_packet_game_load_100(struct connection *pc)
{
  packet_game_load_100_fields fields;
  struct packet_game_load *old;
  struct genhash **hash = pc->phs.received + PACKET_GAME_LOAD;
  RECEIVE_PACKET_START(packet_game_load, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_load_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_load_100, cmp_packet_game_load_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->load_successful = BV_ISSET(fields, 0);
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'load_filename'");
    if (!DIO_GET(string, &din, "load_filename", real_packet->load_filename, sizeof(real_packet->load_filename))) {
      RECEIVE_PACKET_FIELD_ERROR(load_filename);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_load_100(struct connection *pc, const struct packet_game_load *packet)
{
  const struct packet_game_load *real_packet = packet;
  packet_game_load_100_fields fields;
  struct packet_game_load *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_LOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_LOAD);

  log_packet_detailed("packet_game_load_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_load_100, cmp_packet_game_load_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->load_successful != real_packet->load_successful);
  if(differ) {
    different++;
  }
  if (packet->load_successful) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->load_filename, real_packet->load_filename) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  /* field 0 is folded into the header */
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'load_filename' has changed");
    DIO_PUT(string, &dout, "load_filename", real_packet->load_filename);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_GAME_LOAD);
}

int send_packet_game_load(struct connection *pc, const struct packet_game_load *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_GAME_LOAD].packet != NULL, -1,
                        "Handler for PACKET_GAME_LOAD not installed");
  return pc->phs.handlers->send[PACKET_GAME_LOAD].packet(pc, packet);
}

void lsend_packet_game_load(struct conn_list *dest, const struct packet_game_load *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_game_load(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_game_load(struct connection *pc, bool load_successful, const char *load_filename)
{
  struct packet_game_load packet, *real_packet = &packet;

  real_packet->load_successful = load_successful;
  sz_strlcpy(real_packet->load_filename, load_filename);
  
  return send_packet_game_load(pc, real_packet);
}

void dlsend_packet_game_load(struct conn_list *dest, bool load_successful, const char *load_filename)
{
  struct packet_game_load packet, *real_packet = &packet;

  real_packet->load_successful = load_successful;
  sz_strlcpy(real_packet->load_filename, load_filename);
  
  lsend_packet_game_load(dest, real_packet);
}

#define hash_packet_server_setting_control_100 hash_const

#define cmp_packet_server_setting_control_100 cmp_const

BV_DEFINE(packet_server_setting_control_100_fields, 3);

static struct packet_server_setting_control *receive_packet_server_setting_control_100(struct connection *pc)
{
  packet_server_setting_control_100_fields fields;
  struct packet_server_setting_control *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_CONTROL;
  RECEIVE_PACKET_START(packet_server_setting_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_server_setting_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_control_100, cmp_packet_server_setting_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'settings_num'");
    if (!DIO_GET(uint16, &din, "settings_num", &real_packet->settings_num)) {
      RECEIVE_PACKET_FIELD_ERROR(settings_num);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'categories_num'");
    if (!DIO_GET(uint8, &din, "categories_num", &real_packet->categories_num)) {
      RECEIVE_PACKET_FIELD_ERROR(categories_num);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'category_names'");
    
    {
      int i;
    
      if (real_packet->categories_num > 256) {
        RECEIVE_PACKET_FIELD_ERROR(category_names, ": truncation array");
      }
      for (i = 0; i < real_packet->categories_num; i++) {
        if (!DIO_GET(string, &din, "category_names", real_packet->category_names[i], sizeof(real_packet->category_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(category_names);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_control_100(struct connection *pc, const struct packet_server_setting_control *packet)
{
  const struct packet_server_setting_control *real_packet = packet;
  packet_server_setting_control_100_fields fields;
  struct packet_server_setting_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_CONTROL);

  log_packet_detailed("packet_server_setting_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_control_100, cmp_packet_server_setting_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->settings_num != real_packet->settings_num);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->categories_num != real_packet->categories_num);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->categories_num != real_packet->categories_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->categories_num; i++) {
          if (strcmp(old->category_names[i], real_packet->category_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'settings_num' has changed");
    DIO_PUT(uint16, &dout, "settings_num", real_packet->settings_num);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'categories_num' has changed");
    DIO_PUT(uint8, &dout, "categories_num", real_packet->categories_num);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'category_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->categories_num; i++) {
        dio_put_string(&dout, real_packet->category_names[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_CONTROL);
}

int send_packet_server_setting_control(struct connection *pc, const struct packet_server_setting_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_CONTROL].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_CONTROL not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_CONTROL].packet(pc, packet);
}

static genhash_val_t hash_packet_server_setting_const_100(const void *vkey)
{
  const struct packet_server_setting_const *key = (const struct packet_server_setting_const *) vkey;

  return key->id;
}

static bool cmp_packet_server_setting_const_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_const *key1 = (const struct packet_server_setting_const *) vkey1;
  const struct packet_server_setting_const *key2 = (const struct packet_server_setting_const *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_const_100_fields, 4);

static struct packet_server_setting_const *receive_packet_server_setting_const_100(struct connection *pc)
{
  packet_server_setting_const_100_fields fields;
  struct packet_server_setting_const *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_CONST;
  RECEIVE_PACKET_START(packet_server_setting_const, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_server_setting_const_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_const_100, cmp_packet_server_setting_const_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'short_help'");
    if (!DIO_GET(string, &din, "short_help", real_packet->short_help, sizeof(real_packet->short_help))) {
      RECEIVE_PACKET_FIELD_ERROR(short_help);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'extra_help'");
    if (!DIO_GET(string, &din, "extra_help", real_packet->extra_help, sizeof(real_packet->extra_help))) {
      RECEIVE_PACKET_FIELD_ERROR(extra_help);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'category'");
    if (!DIO_GET(uint8, &din, "category", &real_packet->category)) {
      RECEIVE_PACKET_FIELD_ERROR(category);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_const_100(struct connection *pc, const struct packet_server_setting_const *packet)
{
  const struct packet_server_setting_const *real_packet = packet;
  packet_server_setting_const_100_fields fields;
  struct packet_server_setting_const *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_CONST;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_CONST);

  log_packet_detailed("packet_server_setting_const_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_const_100, cmp_packet_server_setting_const_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->short_help, real_packet->short_help) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->extra_help, real_packet->extra_help) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->category != real_packet->category);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'short_help' has changed");
    DIO_PUT(string, &dout, "short_help", real_packet->short_help);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'extra_help' has changed");
    DIO_PUT(string, &dout, "extra_help", real_packet->extra_help);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'category' has changed");
    DIO_PUT(uint8, &dout, "category", real_packet->category);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_CONST);
}

int send_packet_server_setting_const(struct connection *pc, const struct packet_server_setting_const *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_CONST].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_CONST not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_CONST].packet(pc, packet);
}

static genhash_val_t hash_packet_server_setting_bool_100(const void *vkey)
{
  const struct packet_server_setting_bool *key = (const struct packet_server_setting_bool *) vkey;

  return key->id;
}

static bool cmp_packet_server_setting_bool_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_bool *key1 = (const struct packet_server_setting_bool *) vkey1;
  const struct packet_server_setting_bool *key2 = (const struct packet_server_setting_bool *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_bool_100_fields, 5);

static struct packet_server_setting_bool *receive_packet_server_setting_bool_100(struct connection *pc)
{
  packet_server_setting_bool_100_fields fields;
  struct packet_server_setting_bool *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_BOOL;
  RECEIVE_PACKET_START(packet_server_setting_bool, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_server_setting_bool_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bool_100, cmp_packet_server_setting_bool_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  real_packet->val = BV_ISSET(fields, 3);
  real_packet->default_val = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_bool_100(struct connection *pc, const struct packet_server_setting_bool *packet)
{
  const struct packet_server_setting_bool *real_packet = packet;
  packet_server_setting_bool_100_fields fields;
  struct packet_server_setting_bool *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_BOOL;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_BOOL);

  log_packet_detailed("packet_server_setting_bool_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bool_100, cmp_packet_server_setting_bool_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if(differ) {
    different++;
  }
  if (packet->val) {
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if(differ) {
    different++;
  }
  if (packet->default_val) {
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_BOOL);
}

int send_packet_server_setting_bool(struct connection *pc, const struct packet_server_setting_bool *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_BOOL].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_BOOL not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_BOOL].packet(pc, packet);
}

static genhash_val_t hash_packet_server_setting_int_100(const void *vkey)
{
  const struct packet_server_setting_int *key = (const struct packet_server_setting_int *) vkey;

  return key->id;
}

static bool cmp_packet_server_setting_int_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_int *key1 = (const struct packet_server_setting_int *) vkey1;
  const struct packet_server_setting_int *key2 = (const struct packet_server_setting_int *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_int_100_fields, 7);

static struct packet_server_setting_int *receive_packet_server_setting_int_100(struct connection *pc)
{
  packet_server_setting_int_100_fields fields;
  struct packet_server_setting_int *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_INT;
  RECEIVE_PACKET_START(packet_server_setting_int, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_server_setting_int_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_int_100, cmp_packet_server_setting_int_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    if (!DIO_GET(sint32, &din, "val", &real_packet->val)) {
      RECEIVE_PACKET_FIELD_ERROR(val);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    if (!DIO_GET(sint32, &din, "default_val", &real_packet->default_val)) {
      RECEIVE_PACKET_FIELD_ERROR(default_val);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'min_val'");
    if (!DIO_GET(sint32, &din, "min_val", &real_packet->min_val)) {
      RECEIVE_PACKET_FIELD_ERROR(min_val);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'max_val'");
    if (!DIO_GET(sint32, &din, "max_val", &real_packet->max_val)) {
      RECEIVE_PACKET_FIELD_ERROR(max_val);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_int_100(struct connection *pc, const struct packet_server_setting_int *packet)
{
  const struct packet_server_setting_int *real_packet = packet;
  packet_server_setting_int_100_fields fields;
  struct packet_server_setting_int *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_INT;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_INT);

  log_packet_detailed("packet_server_setting_int_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_int_100, cmp_packet_server_setting_int_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->min_val != real_packet->min_val);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->max_val != real_packet->max_val);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    DIO_PUT(sint32, &dout, "val", real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    DIO_PUT(sint32, &dout, "default_val", real_packet->default_val);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'min_val' has changed");
    DIO_PUT(sint32, &dout, "min_val", real_packet->min_val);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'max_val' has changed");
    DIO_PUT(sint32, &dout, "max_val", real_packet->max_val);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_INT);
}

int send_packet_server_setting_int(struct connection *pc, const struct packet_server_setting_int *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_INT].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_INT not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_INT].packet(pc, packet);
}

static genhash_val_t hash_packet_server_setting_str_100(const void *vkey)
{
  const struct packet_server_setting_str *key = (const struct packet_server_setting_str *) vkey;

  return key->id;
}

static bool cmp_packet_server_setting_str_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_str *key1 = (const struct packet_server_setting_str *) vkey1;
  const struct packet_server_setting_str *key2 = (const struct packet_server_setting_str *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_str_100_fields, 5);

static struct packet_server_setting_str *receive_packet_server_setting_str_100(struct connection *pc)
{
  packet_server_setting_str_100_fields fields;
  struct packet_server_setting_str *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_STR;
  RECEIVE_PACKET_START(packet_server_setting_str, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_server_setting_str_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_str_100, cmp_packet_server_setting_str_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    if (!DIO_GET(string, &din, "val", real_packet->val, sizeof(real_packet->val))) {
      RECEIVE_PACKET_FIELD_ERROR(val);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    if (!DIO_GET(string, &din, "default_val", real_packet->default_val, sizeof(real_packet->default_val))) {
      RECEIVE_PACKET_FIELD_ERROR(default_val);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_str_100(struct connection *pc, const struct packet_server_setting_str *packet)
{
  const struct packet_server_setting_str *real_packet = packet;
  packet_server_setting_str_100_fields fields;
  struct packet_server_setting_str *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_STR;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_STR);

  log_packet_detailed("packet_server_setting_str_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_str_100, cmp_packet_server_setting_str_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->val, real_packet->val) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->default_val, real_packet->default_val) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    DIO_PUT(string, &dout, "val", real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    DIO_PUT(string, &dout, "default_val", real_packet->default_val);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_STR);
}

int send_packet_server_setting_str(struct connection *pc, const struct packet_server_setting_str *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_STR].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_STR not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_STR].packet(pc, packet);
}

static genhash_val_t hash_packet_server_setting_enum_100(const void *vkey)
{
  const struct packet_server_setting_enum *key = (const struct packet_server_setting_enum *) vkey;

  return key->id;
}

static bool cmp_packet_server_setting_enum_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_enum *key1 = (const struct packet_server_setting_enum *) vkey1;
  const struct packet_server_setting_enum *key2 = (const struct packet_server_setting_enum *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_enum_100_fields, 8);

static struct packet_server_setting_enum *receive_packet_server_setting_enum_100(struct connection *pc)
{
  packet_server_setting_enum_100_fields fields;
  struct packet_server_setting_enum *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_ENUM;
  RECEIVE_PACKET_START(packet_server_setting_enum, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_server_setting_enum_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_enum_100, cmp_packet_server_setting_enum_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    if (!DIO_GET(sint8, &din, "val", &real_packet->val)) {
      RECEIVE_PACKET_FIELD_ERROR(val);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    if (!DIO_GET(sint8, &din, "default_val", &real_packet->default_val)) {
      RECEIVE_PACKET_FIELD_ERROR(default_val);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'values_num'");
    if (!DIO_GET(sint8, &din, "values_num", &real_packet->values_num)) {
      RECEIVE_PACKET_FIELD_ERROR(values_num);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'support_names'");
    
    {
      int i;
    
      if (real_packet->values_num > 64) {
        RECEIVE_PACKET_FIELD_ERROR(support_names, ": truncation array");
      }
      for (i = 0; i < real_packet->values_num; i++) {
        if (!DIO_GET(string, &din, "support_names", real_packet->support_names[i], sizeof(real_packet->support_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(support_names);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'pretty_names'");
    
    {
      int i;
    
      if (real_packet->values_num > 64) {
        RECEIVE_PACKET_FIELD_ERROR(pretty_names, ": truncation array");
      }
      for (i = 0; i < real_packet->values_num; i++) {
        if (!DIO_GET(string, &din, "pretty_names", real_packet->pretty_names[i], sizeof(real_packet->pretty_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(pretty_names);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_enum_100(struct connection *pc, const struct packet_server_setting_enum *packet)
{
  const struct packet_server_setting_enum *real_packet = packet;
  packet_server_setting_enum_100_fields fields;
  struct packet_server_setting_enum *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_ENUM;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_ENUM);

  log_packet_detailed("packet_server_setting_enum_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_enum_100, cmp_packet_server_setting_enum_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->values_num != real_packet->values_num);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->values_num != real_packet->values_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->values_num; i++) {
          if (strcmp(old->support_names[i], real_packet->support_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->values_num != real_packet->values_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->values_num; i++) {
          if (strcmp(old->pretty_names[i], real_packet->pretty_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    DIO_PUT(sint8, &dout, "val", real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    DIO_PUT(sint8, &dout, "default_val", real_packet->default_val);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'values_num' has changed");
    DIO_PUT(sint8, &dout, "values_num", real_packet->values_num);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'support_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->values_num; i++) {
        dio_put_string(&dout, real_packet->support_names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'pretty_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->values_num; i++) {
        dio_put_string(&dout, real_packet->pretty_names[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_ENUM);
}

int send_packet_server_setting_enum(struct connection *pc, const struct packet_server_setting_enum *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_ENUM].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_ENUM not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_ENUM].packet(pc, packet);
}

static genhash_val_t hash_packet_server_setting_bitwise_100(const void *vkey)
{
  const struct packet_server_setting_bitwise *key = (const struct packet_server_setting_bitwise *) vkey;

  return key->id;
}

static bool cmp_packet_server_setting_bitwise_100(const void *vkey1, const void *vkey2)
{
  const struct packet_server_setting_bitwise *key1 = (const struct packet_server_setting_bitwise *) vkey1;
  const struct packet_server_setting_bitwise *key2 = (const struct packet_server_setting_bitwise *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_server_setting_bitwise_100_fields, 8);

static struct packet_server_setting_bitwise *receive_packet_server_setting_bitwise_100(struct connection *pc)
{
  packet_server_setting_bitwise_100_fields fields;
  struct packet_server_setting_bitwise *old;
  struct genhash **hash = pc->phs.received + PACKET_SERVER_SETTING_BITWISE;
  RECEIVE_PACKET_START(packet_server_setting_bitwise, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint16, &din, "id", &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_server_setting_bitwise_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bitwise_100, cmp_packet_server_setting_bitwise_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->is_visible = BV_ISSET(fields, 0);
  real_packet->is_changeable = BV_ISSET(fields, 1);
  real_packet->initial_setting = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'val'");
    if (!DIO_GET(uint16, &din, "val", &real_packet->val)) {
      RECEIVE_PACKET_FIELD_ERROR(val);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'default_val'");
    if (!DIO_GET(uint16, &din, "default_val", &real_packet->default_val)) {
      RECEIVE_PACKET_FIELD_ERROR(default_val);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'bits_num'");
    if (!DIO_GET(uint8, &din, "bits_num", &real_packet->bits_num)) {
      RECEIVE_PACKET_FIELD_ERROR(bits_num);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'support_names'");
    
    {
      int i;
    
      if (real_packet->bits_num > 64) {
        RECEIVE_PACKET_FIELD_ERROR(support_names, ": truncation array");
      }
      for (i = 0; i < real_packet->bits_num; i++) {
        if (!DIO_GET(string, &din, "support_names", real_packet->support_names[i], sizeof(real_packet->support_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(support_names);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'pretty_names'");
    
    {
      int i;
    
      if (real_packet->bits_num > 64) {
        RECEIVE_PACKET_FIELD_ERROR(pretty_names, ": truncation array");
      }
      for (i = 0; i < real_packet->bits_num; i++) {
        if (!DIO_GET(string, &din, "pretty_names", real_packet->pretty_names[i], sizeof(real_packet->pretty_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(pretty_names);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_setting_bitwise_100(struct connection *pc, const struct packet_server_setting_bitwise *packet)
{
  const struct packet_server_setting_bitwise *real_packet = packet;
  packet_server_setting_bitwise_100_fields fields;
  struct packet_server_setting_bitwise *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SERVER_SETTING_BITWISE;
  int different = 0;
  SEND_PACKET_START(PACKET_SERVER_SETTING_BITWISE);

  log_packet_detailed("packet_server_setting_bitwise_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_server_setting_bitwise_100, cmp_packet_server_setting_bitwise_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_visible != real_packet->is_visible);
  if(differ) {
    different++;
  }
  if (packet->is_visible) {
    BV_SET(fields, 0);
  }

  differ = (old->is_changeable != real_packet->is_changeable);
  if(differ) {
    different++;
  }
  if (packet->is_changeable) {
    BV_SET(fields, 1);
  }

  differ = (old->initial_setting != real_packet->initial_setting);
  if(differ) {
    different++;
  }
  if (packet->initial_setting) {
    BV_SET(fields, 2);
  }

  differ = (old->val != real_packet->val);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->default_val != real_packet->default_val);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->bits_num != real_packet->bits_num);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->bits_num != real_packet->bits_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->bits_num; i++) {
          if (strcmp(old->support_names[i], real_packet->support_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->bits_num != real_packet->bits_num);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->bits_num; i++) {
          if (strcmp(old->pretty_names[i], real_packet->pretty_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint16, &dout, "id", real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'val' has changed");
    DIO_PUT(uint16, &dout, "val", real_packet->val);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'default_val' has changed");
    DIO_PUT(uint16, &dout, "default_val", real_packet->default_val);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'bits_num' has changed");
    DIO_PUT(uint8, &dout, "bits_num", real_packet->bits_num);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'support_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->bits_num; i++) {
        dio_put_string(&dout, real_packet->support_names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'pretty_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->bits_num; i++) {
        dio_put_string(&dout, real_packet->pretty_names[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SERVER_SETTING_BITWISE);
}

int send_packet_server_setting_bitwise(struct connection *pc, const struct packet_server_setting_bitwise *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SERVER_SETTING_BITWISE].packet != NULL, -1,
                        "Handler for PACKET_SERVER_SETTING_BITWISE not installed");
  return pc->phs.handlers->send[PACKET_SERVER_SETTING_BITWISE].packet(pc, packet);
}

#define hash_packet_set_topology_100 hash_const

#define cmp_packet_set_topology_100 cmp_const

BV_DEFINE(packet_set_topology_100_fields, 1);

static struct packet_set_topology *receive_packet_set_topology_100(struct connection *pc)
{
  packet_set_topology_100_fields fields;
  struct packet_set_topology *old;
  struct genhash **hash = pc->phs.received + PACKET_SET_TOPOLOGY;
  RECEIVE_PACKET_START(packet_set_topology, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_set_topology_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_set_topology_100, cmp_packet_set_topology_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'topology_id'");
    if (!DIO_GET(uint8, &din, "topology_id", &real_packet->topology_id)) {
      RECEIVE_PACKET_FIELD_ERROR(topology_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_set_topology_100(struct connection *pc, const struct packet_set_topology *packet)
{
  const struct packet_set_topology *real_packet = packet;
  packet_set_topology_100_fields fields;
  struct packet_set_topology *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SET_TOPOLOGY;
  int different = 0;
  SEND_PACKET_START(PACKET_SET_TOPOLOGY);

  log_packet_detailed("packet_set_topology_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_set_topology_100, cmp_packet_set_topology_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->topology_id != real_packet->topology_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'topology_id' has changed");
    DIO_PUT(uint8, &dout, "topology_id", real_packet->topology_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SET_TOPOLOGY);
}

int send_packet_set_topology(struct connection *pc, const struct packet_set_topology *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SET_TOPOLOGY].packet != NULL, -1,
                        "Handler for PACKET_SET_TOPOLOGY not installed");
  return pc->phs.handlers->send[PACKET_SET_TOPOLOGY].packet(pc, packet);
}

#define hash_packet_ruleset_effect_100 hash_const

#define cmp_packet_ruleset_effect_100 cmp_const

BV_DEFINE(packet_ruleset_effect_100_fields, 6);

static struct packet_ruleset_effect *receive_packet_ruleset_effect_100(struct connection *pc)
{
  packet_ruleset_effect_100_fields fields;
  struct packet_ruleset_effect *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_EFFECT;
  RECEIVE_PACKET_START(packet_ruleset_effect, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_effect_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_effect_100, cmp_packet_ruleset_effect_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'effect_type'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "effect_type", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(effect_type);
      }
      real_packet->effect_type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'effect_value'");
    if (!DIO_GET(sint32, &din, "effect_value", &real_packet->effect_value)) {
      RECEIVE_PACKET_FIELD_ERROR(effect_value);
    }
  }
  real_packet->has_multiplier = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'multiplier'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "multiplier", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(multiplier);
      }
      real_packet->multiplier = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!DIO_GET(uint8, &din, "reqs_count", &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!DIO_GET(requirement, &din, "reqs", &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_effect_100(struct connection *pc, const struct packet_ruleset_effect *packet)
{
  const struct packet_ruleset_effect *real_packet = packet;
  packet_ruleset_effect_100_fields fields;
  struct packet_ruleset_effect *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_EFFECT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_EFFECT);

  log_packet_detailed("packet_ruleset_effect_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_effect_100, cmp_packet_ruleset_effect_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->effect_type != real_packet->effect_type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->effect_value != real_packet->effect_value);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->has_multiplier != real_packet->has_multiplier);
  if(differ) {
    different++;
  }
  if (packet->has_multiplier) {
    BV_SET(fields, 2);
  }

  differ = (old->multiplier != real_packet->multiplier);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'effect_type' has changed");
    DIO_PUT(uint8, &dout, "effect_type", real_packet->effect_type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'effect_value' has changed");
    DIO_PUT(sint32, &dout, "effect_value", real_packet->effect_value);
  }
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'multiplier' has changed");
    DIO_PUT(uint8, &dout, "multiplier", real_packet->multiplier);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    DIO_PUT(uint8, &dout, "reqs_count", real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_EFFECT);
}

int send_packet_ruleset_effect(struct connection *pc, const struct packet_ruleset_effect *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_EFFECT].packet != NULL, -1,
                        "Handler for PACKET_RULESET_EFFECT not installed");
  return pc->phs.handlers->send[PACKET_RULESET_EFFECT].packet(pc, packet);
}

void lsend_packet_ruleset_effect(struct conn_list *dest, const struct packet_ruleset_effect *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_effect(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_resource_100 hash_const

#define cmp_packet_ruleset_resource_100 cmp_const

BV_DEFINE(packet_ruleset_resource_100_fields, 6);

static struct packet_ruleset_resource *receive_packet_ruleset_resource_100(struct connection *pc)
{
  packet_ruleset_resource_100_fields fields;
  struct packet_ruleset_resource *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_RESOURCE;
  RECEIVE_PACKET_START(packet_ruleset_resource, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_resource_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_resource_100, cmp_packet_ruleset_resource_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!DIO_GET(uint8, &din, "id", &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!DIO_GET(string, &din, "rule_name", real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!DIO_GET(uint8, &din, "output", &real_packet->output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(output);
        }
      }
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!DIO_GET(string, &din, "graphic_str", real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!DIO_GET(string, &din, "graphic_alt", real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_resource_100(struct connection *pc, const struct packet_ruleset_resource *packet)
{
  const struct packet_ruleset_resource *real_packet = packet;
  packet_ruleset_resource_100_fields fields;
  struct packet_ruleset_resource *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_RESOURCE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_RESOURCE);

  log_packet_detailed("packet_ruleset_resource_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_resource_100, cmp_packet_ruleset_resource_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->output[i] != real_packet->output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    DIO_PUT(uint8, &dout, "id", real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    DIO_PUT(string, &dout, "rule_name", real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    DIO_PUT(string, &dout, "graphic_str", real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    DIO_PUT(string, &dout, "graphic_alt", real_packet->graphic_alt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_RESOURCE);
}

int send_packet_ruleset_resource(struct connection *pc, const struct packet_ruleset_resource *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_RULESET_RESOURCE].packet != NULL, -1,
                        "Handler for PACKET_RULESET_RESOURCE not installed");
  return pc->phs.handlers->send[PACKET_RULESET_RESOURCE].packet(pc, packet);
}

void lsend_packet_ruleset_resource(struct conn_list *dest, const struct packet_ruleset_resource *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_resource(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_scenario_info_100 hash_const

#define cmp_packet_scenario_info_100 cmp_const

BV_DEFINE(packet_scenario_info_100_fields, 11);

static struct packet_scenario_info *receive_packet_scenario_info_100(struct connection *pc)
{
  packet_scenario_info_100_fields fields;
  struct packet_scenario_info *old;
  struct genhash **hash = pc->phs.received + PACKET_SCENARIO_INFO;
  RECEIVE_PACKET_START(packet_scenario_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_scenario_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_scenario_info_100, cmp_packet_scenario_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  real_packet->is_scenario = BV_ISSET(fields, 0);
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'authors'");
    if (!DIO_GET(string, &din, "authors", real_packet->authors, sizeof(real_packet->authors))) {
      RECEIVE_PACKET_FIELD_ERROR(authors);
    }
  }
  real_packet->players = BV_ISSET(fields, 3);
  real_packet->startpos_nations = BV_ISSET(fields, 4);
  real_packet->save_random = BV_ISSET(fields, 5);
  real_packet->prevent_new_cities = BV_ISSET(fields, 6);
  real_packet->lake_flooding = BV_ISSET(fields, 7);
  real_packet->handmade = BV_ISSET(fields, 8);
  real_packet->allow_ai_type_fallback = BV_ISSET(fields, 9);
  real_packet->have_resources = BV_ISSET(fields, 10);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_scenario_info_100(struct connection *pc, const struct packet_scenario_info *packet)
{
  const struct packet_scenario_info *real_packet = packet;
  packet_scenario_info_100_fields fields;
  struct packet_scenario_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SCENARIO_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_SCENARIO_INFO);

  log_packet_detailed("packet_scenario_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_scenario_info_100, cmp_packet_scenario_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->is_scenario != real_packet->is_scenario);
  if(differ) {
    different++;
  }
  if (packet->is_scenario) {
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->authors, real_packet->authors) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->players != real_packet->players);
  if(differ) {
    different++;
  }
  if (packet->players) {
    BV_SET(fields, 3);
  }

  differ = (old->startpos_nations != real_packet->startpos_nations);
  if(differ) {
    different++;
  }
  if (packet->startpos_nations) {
    BV_SET(fields, 4);
  }

  differ = (old->save_random != real_packet->save_random);
  if(differ) {
    different++;
  }
  if (packet->save_random) {
    BV_SET(fields, 5);
  }

  differ = (old->prevent_new_cities != real_packet->prevent_new_cities);
  if(differ) {
    different++;
  }
  if (packet->prevent_new_cities) {
    BV_SET(fields, 6);
  }

  differ = (old->lake_flooding != real_packet->lake_flooding);
  if(differ) {
    different++;
  }
  if (packet->lake_flooding) {
    BV_SET(fields, 7);
  }

  differ = (old->handmade != real_packet->handmade);
  if(differ) {
    different++;
  }
  if (packet->handmade) {
    BV_SET(fields, 8);
  }

  differ = (old->allow_ai_type_fallback != real_packet->allow_ai_type_fallback);
  if(differ) {
    different++;
  }
  if (packet->allow_ai_type_fallback) {
    BV_SET(fields, 9);
  }

  differ = (old->have_resources != real_packet->have_resources);
  if(differ) {
    different++;
  }
  if (packet->have_resources) {
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  /* field 0 is folded into the header */
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'authors' has changed");
    DIO_PUT(string, &dout, "authors", real_packet->authors);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  /* field 10 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SCENARIO_INFO);
}

int send_packet_scenario_info(struct connection *pc, const struct packet_scenario_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SCENARIO_INFO].packet != NULL, -1,
                        "Handler for PACKET_SCENARIO_INFO not installed");
  return pc->phs.handlers->send[PACKET_SCENARIO_INFO].packet(pc, packet);
}

#define hash_packet_scenario_description_100 hash_const

#define cmp_packet_scenario_description_100 cmp_const

BV_DEFINE(packet_scenario_description_100_fields, 1);

static struct packet_scenario_description *receive_packet_scenario_description_100(struct connection *pc)
{
  packet_scenario_description_100_fields fields;
  struct packet_scenario_description *old;
  struct genhash **hash = pc->phs.received + PACKET_SCENARIO_DESCRIPTION;
  RECEIVE_PACKET_START(packet_scenario_description, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_scenario_description_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_scenario_description_100, cmp_packet_scenario_description_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'description'");
    if (!DIO_GET(string, &din, "description", real_packet->description, sizeof(real_packet->description))) {
      RECEIVE_PACKET_FIELD_ERROR(description);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_scenario_description_100(struct connection *pc, const struct packet_scenario_description *packet)
{
  const struct packet_scenario_description *real_packet = packet;
  packet_scenario_description_100_fields fields;
  struct packet_scenario_description *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SCENARIO_DESCRIPTION;
  int different = 0;
  SEND_PACKET_START(PACKET_SCENARIO_DESCRIPTION);

  log_packet_detailed("packet_scenario_description_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_scenario_description_100, cmp_packet_scenario_description_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->description, real_packet->description) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'description' has changed");
    DIO_PUT(string, &dout, "description", real_packet->description);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SCENARIO_DESCRIPTION);
}

int send_packet_scenario_description(struct connection *pc, const struct packet_scenario_description *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SCENARIO_DESCRIPTION].packet != NULL, -1,
                        "Handler for PACKET_SCENARIO_DESCRIPTION not installed");
  return pc->phs.handlers->send[PACKET_SCENARIO_DESCRIPTION].packet(pc, packet);
}

#define hash_packet_save_scenario_100 hash_const

#define cmp_packet_save_scenario_100 cmp_const

BV_DEFINE(packet_save_scenario_100_fields, 1);

static struct packet_save_scenario *receive_packet_save_scenario_100(struct connection *pc)
{
  packet_save_scenario_100_fields fields;
  struct packet_save_scenario *old;
  struct genhash **hash = pc->phs.received + PACKET_SAVE_SCENARIO;
  RECEIVE_PACKET_START(packet_save_scenario, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_save_scenario_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_save_scenario_100, cmp_packet_save_scenario_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    if (!DIO_GET(string, &din, "name", real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_save_scenario_100(struct connection *pc, const struct packet_save_scenario *packet)
{
  const struct packet_save_scenario *real_packet = packet;
  packet_save_scenario_100_fields fields;
  struct packet_save_scenario *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SAVE_SCENARIO;
  int different = 0;
  SEND_PACKET_START(PACKET_SAVE_SCENARIO);

  log_packet_detailed("packet_save_scenario_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_save_scenario_100, cmp_packet_save_scenario_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    DIO_PUT(string, &dout, "name", real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SAVE_SCENARIO);
}

int send_packet_save_scenario(struct connection *pc, const struct packet_save_scenario *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_SAVE_SCENARIO].packet != NULL, -1,
                        "Handler for PACKET_SAVE_SCENARIO not installed");
  return pc->phs.handlers->send[PACKET_SAVE_SCENARIO].packet(pc, packet);
}

int dsend_packet_save_scenario(struct connection *pc, const char *name)
{
  struct packet_save_scenario packet, *real_packet = &packet;

  sz_strlcpy(real_packet->name, name);
  
  return send_packet_save_scenario(pc, real_packet);
}

#define hash_packet_vote_new_100 hash_const

#define cmp_packet_vote_new_100 cmp_const

BV_DEFINE(packet_vote_new_100_fields, 5);

static struct packet_vote_new *receive_packet_vote_new_100(struct connection *pc)
{
  packet_vote_new_100_fields fields;
  struct packet_vote_new *old;
  struct genhash **hash = pc->phs.received + PACKET_VOTE_NEW;
  RECEIVE_PACKET_START(packet_vote_new, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_vote_new_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_new_100, cmp_packet_vote_new_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'vote_no'");
    if (!DIO_GET(uint32, &din, "vote_no", &real_packet->vote_no)) {
      RECEIVE_PACKET_FIELD_ERROR(vote_no);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'user'");
    if (!DIO_GET(string, &din, "user", real_packet->user, sizeof(real_packet->user))) {
      RECEIVE_PACKET_FIELD_ERROR(user);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'desc'");
    if (!DIO_GET(string, &din, "desc", real_packet->desc, sizeof(real_packet->desc))) {
      RECEIVE_PACKET_FIELD_ERROR(desc);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'percent_required'");
    if (!DIO_GET(uint8, &din, "percent_required", &real_packet->percent_required)) {
      RECEIVE_PACKET_FIELD_ERROR(percent_required);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_GET(uint32, &din, "flags", &real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_vote_new_100(struct connection *pc, const struct packet_vote_new *packet)
{
  const struct packet_vote_new *real_packet = packet;
  packet_vote_new_100_fields fields;
  struct packet_vote_new *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_VOTE_NEW;
  int different = 0;
  SEND_PACKET_START(PACKET_VOTE_NEW);

  log_packet_detailed("packet_vote_new_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_new_100, cmp_packet_vote_new_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->vote_no != real_packet->vote_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->user, real_packet->user) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->desc, real_packet->desc) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->percent_required != real_packet->percent_required);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->flags != real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'vote_no' has changed");
    DIO_PUT(uint32, &dout, "vote_no", real_packet->vote_no);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'user' has changed");
    DIO_PUT(string, &dout, "user", real_packet->user);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'desc' has changed");
    DIO_PUT(string, &dout, "desc", real_packet->desc);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'percent_required' has changed");
    DIO_PUT(uint8, &dout, "percent_required", real_packet->percent_required);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'flags' has changed");
    DIO_PUT(uint32, &dout, "flags", real_packet->flags);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_VOTE_NEW);
}

int send_packet_vote_new(struct connection *pc, const struct packet_vote_new *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_VOTE_NEW].packet != NULL, -1,
                        "Handler for PACKET_VOTE_NEW not installed");
  return pc->phs.handlers->send[PACKET_VOTE_NEW].packet(pc, packet);
}

static genhash_val_t hash_packet_vote_update_100(const void *vkey)
{
  const struct packet_vote_update *key = (const struct packet_vote_update *) vkey;

  return key->vote_no;
}

static bool cmp_packet_vote_update_100(const void *vkey1, const void *vkey2)
{
  const struct packet_vote_update *key1 = (const struct packet_vote_update *) vkey1;
  const struct packet_vote_update *key2 = (const struct packet_vote_update *) vkey2;

  return key1->vote_no == key2->vote_no;
}

BV_DEFINE(packet_vote_update_100_fields, 4);

static struct packet_vote_update *receive_packet_vote_update_100(struct connection *pc)
{
  packet_vote_update_100_fields fields;
  struct packet_vote_update *old;
  struct genhash **hash = pc->phs.received + PACKET_VOTE_UPDATE;
  RECEIVE_PACKET_START(packet_vote_update, real_packet);

  DIO_BV_GET(&din, fields);
  if (!DIO_GET(uint32, &din, "vote_no", &real_packet->vote_no)) {
    RECEIVE_PACKET_FIELD_ERROR(vote_no);
  }

  log_packet_detailed("packet_vote_update_100: got info about (%d)",
    real_packet->vote_no);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_update_100, cmp_packet_vote_update_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int vote_no = real_packet->vote_no;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->vote_no = vote_no;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'yes'");
    if (!DIO_GET(uint8, &din, "yes", &real_packet->yes)) {
      RECEIVE_PACKET_FIELD_ERROR(yes);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'no'");
    if (!DIO_GET(uint8, &din, "no", &real_packet->no)) {
      RECEIVE_PACKET_FIELD_ERROR(no);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'abstain'");
    if (!DIO_GET(uint8, &din, "abstain", &real_packet->abstain)) {
      RECEIVE_PACKET_FIELD_ERROR(abstain);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'num_voters'");
    if (!DIO_GET(uint8, &din, "num_voters", &real_packet->num_voters)) {
      RECEIVE_PACKET_FIELD_ERROR(num_voters);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_vote_update_100(struct connection *pc, const struct packet_vote_update *packet)
{
  const struct packet_vote_update *real_packet = packet;
  packet_vote_update_100_fields fields;
  struct packet_vote_update *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_VOTE_UPDATE;
  int different = 0;
  SEND_PACKET_START(PACKET_VOTE_UPDATE);

  log_packet_detailed("packet_vote_update_100: sending info about (%d)",
    real_packet->vote_no);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_update_100, cmp_packet_vote_update_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->yes != real_packet->yes);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->no != real_packet->no);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->abstain != real_packet->abstain);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->num_voters != real_packet->num_voters);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, "fields", fields);
  DIO_PUT(uint32, &dout, "vote_no", real_packet->vote_no);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'yes' has changed");
    DIO_PUT(uint8, &dout, "yes", real_packet->yes);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'no' has changed");
    DIO_PUT(uint8, &dout, "no", real_packet->no);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'abstain' has changed");
    DIO_PUT(uint8, &dout, "abstain", real_packet->abstain);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'num_voters' has changed");
    DIO_PUT(uint8, &dout, "num_voters", real_packet->num_voters);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_VOTE_UPDATE);
}

int send_packet_vote_update(struct connection *pc, const struct packet_vote_update *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_VOTE_UPDATE].packet != NULL, -1,
                        "Handler for PACKET_VOTE_UPDATE not installed");
  return pc->phs.handlers->send[PACKET_VOTE_UPDATE].packet(pc, packet);
}

#define hash_packet_vote_remove_100 hash_const

#define cmp_packet_vote_remove_100 cmp_const

BV_DEFINE(packet_vote_remove_100_fields, 1);

static struct packet_vote_remove *receive_packet_vote_remove_100(struct connection *pc)
{
  packet_vote_remove_100_fields fields;
  struct packet_vote_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_VOTE_REMOVE;
  RECEIVE_PACKET_START(packet_vote_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_vote_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_remove_100, cmp_packet_vote_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'vote_no'");
    if (!DIO_GET(uint32, &din, "vote_no", &real_packet->vote_no)) {
      RECEIVE_PACKET_FIELD_ERROR(vote_no);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_vote_remove_100(struct connection *pc, const struct packet_vote_remove *packet)
{
  const struct packet_vote_remove *real_packet = packet;
  packet_vote_remove_100_fields fields;
  struct packet_vote_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_VOTE_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_VOTE_REMOVE);

  log_packet_detailed("packet_vote_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_remove_100, cmp_packet_vote_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->vote_no != real_packet->vote_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, "fields", fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'vote_no' has changed");
    DIO_PUT(uint32, &dout, "vote_no", real_packet->vote_no);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_VOTE_REMOVE);
}

int send_packet_vote_remove(struct connection *pc, const struct packet_vote_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val_msg(pc->phs.handlers->send[PACKET_VOTE_REMOVE].packet != NULL, -1,
                        "Handler for PACKET_VOTE_REMOVE not installed");
  return pc->phs.handlers->send[PACKET_VOTE_REMOVE].packet(pc, packet);
}

#define hash_packet_vote_resolve_100 hash_const

#define cmp_packet_vote_resolve_100 cmp_const

BV_DEFINE(packet_vote_resolve_100_fields, 2);

static struct packet_vote_resolve *receive_packet_vote_resolve_100(struct connection *pc)
{
  packet_vote_resolve_100_fields fields;
  struct packet_vote_resolve *old;
  struct genhash **hash = pc->phs.received + PACKET_VOTE_RESOLVE;
  RECEIVE_PACKET_START(packet_vote_resolve, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_vote_resolve_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_vote_resolve_100, cmp_packet_vote_resolve_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'vote_no'");
    if (!DIO_GET(uint32, &din, "vote_no", &real_packet->vote_no)) {
      RECEIVE_PACKET_FIELD_ERROR(vote_no);
    }
  }
  real_packet->passed = BV_ISSET(fields, 1);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_vote_resolve_100(struct connection *pc, const struct packet_vote_resolve *pac