/*
 * $Id: simnodes.c,v 1.7 2009-05-14 06:48:49 vrsieh Exp $
 * 
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "glue-dist.h"
#include "simnodes.h"

static void
simnodes_add(const char *name, char *user_host_path)
{
	char *user;
	char *host;
	char *path;

	if (strchr(user_host_path, ':')) {
		path = strchr(user_host_path, ':');
		*path++ = '\0';

		if (strchr(user_host_path, '@')) {
			user = user_host_path;
			host = strchr(user_host_path, '@');
			*host++ = '\0';
		} else {
			user = NULL;
			host = user_host_path;
		}
	} else {
		user = NULL;
		host = NULL;
		path = user_host_path;
	}

	dist_node_create(name, user, host, path);
}

void
simnodes_create(void)
{
	int fd;
	int ret;

	/*
	 * Read List of Nodes
	 */
	fd = open("simulation.nodes", O_RDONLY);
	if (fd < 0) {
		/*
		 * No "simulation.nodes" file.
		 * Use localhost as the only node.
		 */
		dist_node_create("default", NULL, NULL, NULL);

	} else {
		/*
		 * "simulation.nodes" file exists.
		 * Read entries and create nodes.
		 */
		char buffer[16*1024];
		char name[32];
		char user_host_path[32 + 1 + 64 + 1 + 1024];
		unsigned int x;
		const char *p;

		ret = read(fd, buffer, sizeof(buffer) - 1);
		assert(0 <= ret);
		buffer[ret] = '\0';

		for (p = buffer; *p; ) {
			switch (*p) {
			case '\n':
				/* Skip return. */
				p++;
				break;
			case '\t':
			case ' ':
				/* Skip white space. */
				p++;
				break;
			case '#':
				/* Skip comment. */
				while (*p != '\0'
				    && *p != '\n') {
					p++;
				}
				break;
			default:
				/*
				 * Entry Found
				 */
				/* Read node name. */
				x = 0;
				while (*p != '\0'
				    && *p != '\t'
				    && *p != '\n'
				    && *p != '\r'
				    && *p != ' '
				    && *p != '=') {
					name[x++] = *p++;
				}
				name[x] = '\0';

				/* Skip white space. */
				while (*p == '\t'
				    || *p == ' ') {
					p++;
				}

				/* Skip '=' (if present). */
				if (*p == '=') {
					p++;
				}

				/* Skip white space. */
				while (*p == '\t'
				    || *p == ' ') {
					p++;
				}

				/* Read user@host:path. */
				x = 0;
				while (*p != '\0'
				    && *p != '\t'
				    && *p != '\n'
				    && *p != '\r'
				    && *p != ' ') {
					user_host_path[x++] = *p++;
				}
				user_host_path[x] = '\0';

				simnodes_add(name, user_host_path);
			}
		}

		ret = close(fd);
		assert(0 <= ret);
	}
}

void
simnodes_destroy(void)
{
	unsigned int id;

	/* FIXME */
	for (id = 0; id < 1000; id++) {
		(void) dist_node_destroy(id);
	}
}
