/*
 * $Id: cim_telephone.h,v 1.9 2009-05-21 09:19:22 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CIM_TELEPHONE_H_INCLUDED
#define __CIM_TELEPHONE_H_INCLUDED

#include "bridge.h"
#include "sig_telephone.h"

/** telephone cim connection struct */
struct cim_telephone {
	/** associated bridge */
	struct bridge bridge;
	/** telephone signal object */
	struct sig_telephone *sig_telephone;
};

/** connect signal to cim 
 *  @param css cim_telephone object with preconfigured bridge.
 *  @param sig_telephone sig_telephone object.
 */
extern void
cim_telephone_init(struct cim_telephone *css, 
		   struct sig_telephone *sig_telephone);

/** create cim_telephone object (and thus the bridge).
 *  @param css cim_telephone object.
 */
extern void
cim_telephone_create(struct cim_telephone *css);

/** destroy cim_telephone object (and thus the bridge).
 *  @param css cim_telephone object.
 */
extern void
cim_telephone_destroy(struct cim_telephone *css);

#endif /* __CIM_TELEPHONE_H_INCLUDED */
