/* $Id$ 
 *
 * Call: Call a subroutine (intermediate opcode).
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CALL_HPP_INCLUDED
#define __CALL_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Reference.hpp"

namespace intermediate {

//! call given subprogram
/** This class will call a given subprogram.
 *  The destination of a call must be the name of a code container. This code
 *  container must be in the same nesting level as the current code container,
 *  or above the current code container.
 *
 *  Read operands: target (pointer referencing the target code container)
 *  Write operands: implicit stack pointer, stack, 
 *  		    implicit instruction pointer
 *
 *  Operation:
 *  	push instruction pointer
 *  	push target stack segment to stack
 *	instruction pointer = target
 */
class Call : public OpCode {
public:
	//! c'tor
	/** @param target called subprogram
	 */
	Call(Reference *destination) : dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! target (name) of the subprogram.
	Reference *dst;

protected:
	virtual ~Call() {
		util::MiscUtil::terminate(this->dst);
	}
};


}; /* namespace intermediate */

#endif /* __CALL_HPP_INCLUDED */
