/* $Id: TypeElement.hpp 4442 2009-03-30 15:07:36Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_ELEMENT_HPP_INCLUDED
#define __TYPE_ELEMENT_HPP_INCLUDED

#include <string>
#include <cassert>
#include <list>
#include "frontend/ast/Types.hpp"
#include "intermediate/operands/ImmediateOperand.hpp"


namespace intermediate {

//! element of a type 
class TypeElement : public Node {
public:
	//! c'tor
	/** @param typeName element is of this type.
	 *  @param initV initial value(s) of the type/or of the data instance.
	 *  @param upperBound: upper bound for arrays (0-based, excl. u.b.)
	 */
	TypeElement(
		std::string typeName, 
		std::list<ImmediateOperand*> initV,
		universal_integer upperBound
		) :	name(typeName),
			init(initV),
			ubound(upperBound) {
	}

	//! alternate c'tor
	/** 
	 *  This constructor can be used for elements wich are
	 *  not array (i.e. upper bound 1).
	 *  @param typeName element is of this type.
	 *  @param initV initial value(s)
	 */
	TypeElement(
		std::string typeName,
		std::list<ImmediateOperand*> initV
		) : 	name(typeName),
			init(initV),
			ubound(1) {
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	/** name of the type that the element refers to. */
	std::string name;
	/** initial values (may be empty, for uninitialized types) */
	std::list<ImmediateOperand *> init;
	/** upper bound for arrays. > 0, 1 means that it is no array.
	 *  The array has the bounds [0, ubound[.
	 */
	universal_integer ubound;

protected:
	virtual ~TypeElement() {}
};

}; /* namespace intermediate */

#endif /* __TYPE_ELEMENT_HPP_INCLUDED */
