% This file is part of Jiffy released under the MIT license.
% See the LICENSE file for more information.

-module(jiffy_09_reg_issue_24_tests).


-include_lib("eunit/include/eunit.hrl").
-include("jiffy_util.hrl").


no_segfault_test_() ->
    {"no segfault", [
        ?_assert(begin jiffy:encode(big_doc(), [uescape]), true end)
    ]}.


big_doc() ->
    {[{<<"_id">>,<<"_design/bookmarks">>},
      {<<"_rev">>,<<"1-1794a8236590d2fc6c288115dc539a3d">>},
      {<<"lib">>,
       {[{<<"app">>,
          <<"\nmodule.exports = {\n\n    views: require('./views'),\n    shows : require('./shows'),\n    rewrites: require('./rewrites'),\n    updates: require('./updates')\n};\n\n// Bind event handlers\n// require('./events')\n">>},
         {<<"rewrites">>,
          <<"/**\n * Rewrite settings to be exported from the design doc\n */\n\nmodule.exports = [\n    {from: '/static/*', to: 'static/*'},\n    {from: '/bootstrap/*', to: 'bootstrap/*'},\n    {from: '/modules.js', to: 'modules.js' },\n    {\"from\": \"/_db/*\", \"to\": \"../../*\" },\n    {\"from\": \"/_db\", \"to\": \"../..\" },\n    {\"from\": \"/bookmark_lite\", \"to\" : \"_show/bookmark_lite\"},\n    {\"from\": \"/bookmark\", \"to\" : \"_show/bookmark\"},\n    {\"from\": \"/save\", \"to\" : \"_update/bookmark\"},\n    {\"from\": \"/click/*\", \"to\" : \"_update/click/*\"},\n    {\"from\": \"/archive/*\", \"to\" : \"_update/archive/*\"},\n    {from: '/', to: 'index.html'}\n];">>},
         {<<"shows">>,
          <<"var templates = require('handlebars').templates;\n\nexports.bookmark_lite = function(doc, req) {\n\n    return {\n        code: 200,\n        headers: {'content-type' : 'text/html'},\n        body: templates['newBookmark.html']({\n            title : req.query.title,\n            url  : req.query.url\n        })\n    };\n\n}\n\nexports.bookmark = function(doc, req) {\n    return {\n        code: 200,\n        headers: {'content-type' : 'text/html'},\n        body: '<h2>Hellp</h2>'\n    };\n}\n\n">>},
         {<<"updates">>,
          <<"\nvar md5 = require('md5');\nvar querystring = require('querystring');\n\nexports.bookmark = function(doc, req) {\n\n    var details = {};\n    if (req.body && req.body.length > 0) {\n        details = querystring.parse(req.body);\n    }\n    if (req.query.title) details.title = req.query.title;\n    if (req.query.url)   details.url = req.query.url;\n\n    if (!doc) {\n        var id = md5.hex(details.url);\n        var doc = {\n            _id : id,\n            type: 'com.eckoit.bookmark',\n            title : decodeURIComponent(details.title),\n            url : decodeURIComponent(details.url),\n            timestamp: new Date().getTime()\n        };\n        if (details.short_text) doc.short_text = details.short_text;\n        log(doc);\n        return [doc, 'SUCCESS']\n\n    } else {\n\n    }\n}\n\nexports.click = function(doc, req) {\n    if (!doc.clicks) doc.clicks = 0;\n    doc.clicks++;\n    return [doc, 'SUCCESS'];\n}\n\nexports.archive = function(doc, req) {\n    doc.archive = true;\n    return [doc, 'SUCCESS'];\n}">>},
         {<<"views">>,
          <<"\n\nexports.by_date = {\n    map : function(doc) {\n\n        if (doc.archive) return;\n\n        if (doc.type && doc.type === 'com.eckoit.bookmark' ) {\n            var timestamp = doc.timestamp;\n            if (!timestamp) timestamp = new Date(0);\n            emit(timestamp, null);\n        }\n    }\n}\n\nexports.by_views = {\n    map : function(doc) {\n\n        if (doc.archive) return;\n\n        if (doc.type && doc.type === 'com.eckoit.bookmark' ) {\n            var clicks = doc.clicks;\n            if (!clicks) clicks = 0;\n\n            var timestamp = doc.timestamp;\n            if (!timestamp) timestamp = new Date(0);\n\n            emit([clicks, timestamp], null);\n        }\n    }\n}\n\nexports.all_tags = {\n    map : function(doc) {\n        if (doc.type && doc.type == 'garden.tag') {\n            emit(doc.hash, null);\n        }\n    }\n}\n">>}]}},
      {<<"underscore">>,
       <<"//     Underscore.js 1.3.1\n//     (c) 2009-2012 Jeremy Ashkenas, DocumentCloud Inc.\n//     Underscore is freely distributable under the MIT license.\n//     Portions of Underscore are inspired or borrowed from Prototype,\n//     Oliver Steele's Functional, and John Resig's Micro-Templating.\n//     For all details and documentation:\n//     http://documentcloud.github.com/underscore\n\n(function() {\n\n  // Baseline setup\n  // --------------\n\n  // Establish the root object, `window` in the browser, or `global` on the server.\n  var root = this;\n\n  // Save the previous value of the `_` variable.\n  var previousUnderscore = root._;\n\n  // Establish the object that gets returned to break out of a loop iteration.\n  var breaker = {};\n\n  // Save bytes in the minified (but not gzipped) version:\n  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;\n\n  // Create quick reference variables for speed access to core prototypes.\n  var slice            = ArrayProto.slice,\n      unshift          = ArrayProto.unshift,\n      toString         = ObjProto.toString,\n      hasOwnProperty   = ObjProto.hasOwnProperty;\n\n  // All **ECMAScript 5** native function implementations that we hope to use\n  // are declared here.\n  var\n    nativeForEach      = ArrayProto.forEach,\n    nativeMap          = ArrayProto.map,\n    nativeReduce       = ArrayProto.reduce,\n    nativeReduceRight  = ArrayProto.reduceRight,\n    nativeFilter       = ArrayProto.filter,\n    nativeEvery        = ArrayProto.every,\n    nativeSome         = ArrayProto.some,\n    nativeIndexOf      = ArrayProto.indexOf,\n    nativeLastIndexOf  = ArrayProto.lastIndexOf,\n    nativeIsArray      = Array.isArray,\n    nativeKeys         = Object.keys,\n    nativeBind         = FuncProto.bind;\n\n  // Create a safe reference to the Underscore object for use below.\n  var _ = function(obj) { return new wrapper(obj); };\n\n  // Export the Underscore object for **Node.js**, with\n  // backwards-compatibility for the old `require()` API. If we're in\n  // the browser, add `_` as a global object via a string identifier,\n  // for Closure Compiler \"advanced\" mode.\n  if (typeof exports !== 'undefined') {\n    if (typeof module !== 'undefined' && module.exports) {\n      exports = module.exports = _;\n    }\n    exports._ = _;\n  } else {\n    root['_'] = _;\n  }\n\n  // Current version.\n  _.VERSION = '1.3.1';\n\n  // Collection Functions\n  // --------------------\n\n  // The cornerstone, an `each` implementation, aka `forEach`.\n  // Handles objects with the built-in `forEach`, arrays, and raw objects.\n  // Delegates to **ECMAScript 5**'s native `forEach` if available.\n  var each = _.each = _.forEach = function(obj, iterator, context) {\n    if (obj == null) return;\n    if (nativeForEach && obj.forEach === nativeForEach) {\n      obj.forEach(iterator, context);\n    } else if (obj.length === +obj.length) {\n      for (var i = 0, l = obj.length; i < l; i++) {\n        if (i in obj && iterator.call(context, obj[i], i, obj) === breaker) return;\n      }\n    } else {\n      for (var key in obj) {\n        if (_.has(obj, key)) {\n          if (iterator.call(context, obj[key], key, obj) === breaker) return;\n        }\n      }\n    }\n  };\n\n  // Return the results of applying the iterator to each element.\n  // Delegates to **ECMAScript 5**'s native `map` if available.\n  _.map = _.collect = function(obj, iterator, context) {\n    var results = [];\n    if (obj == null) return results;\n    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);\n    each(obj, function(value, index, list) {\n      results[results.length] = iterator.call(context, value, index, list);\n    });\n    if (obj.length === +obj.length) results.length = obj.length;\n    return results;\n  };\n\n  // **Reduce** builds up a single result from a list of values, aka `inject`,\n  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.\n  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {\n    var initial = arguments.length > 2;\n    if (obj == null) obj = [];\n    if (nativeReduce && obj.reduce === nativeReduce) {\n      if (context) iterator = _.bind(iterator, context);\n      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);\n    }\n    each(obj, function(value, index, list) {\n      if (!initial) {\n        memo = value;\n        initial = true;\n      } else {\n        memo = iterator.call(context, memo, value, index, list);\n      }\n    });\n    if (!initial) throw new TypeError('Reduce of empty array with no initial value');\n    return memo;\n  };\n\n  // The right-associative version of reduce, also known as `foldr`.\n  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.\n  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {\n    var initial = arguments.length > 2;\n    if (obj == null) obj = [];\n    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {\n      if (context) iterator = _.bind(iterator, context);\n      return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);\n    }\n    var reversed = _.toArray(obj).reverse();\n    if (context && !initial) iterator = _.bind(iterator, context);\n    return initial ? _.reduce(reversed, iterator, memo, context) : _.reduce(reversed, iterator);\n  };\n\n  // Return the first value which passes a truth test. Aliased as `detect`.\n  _.find = _.detect = function(obj, iterator, context) {\n    var result;\n    any(obj, function(value, index, list) {\n      if (iterator.call(context, value, index, list)) {\n        result = value;\n        return true;\n      }\n    });\n    return result;\n  };\n\n  // Return all the elements that pass a truth test.\n  // Delegates to **ECMAScript 5**'s native `filter` if available.\n  // Aliased as `select`.\n  _.filter = _.select = function(obj, iterator, context) {\n    var results = [];\n    if (obj == null) return results;\n    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);\n    each(obj, function(value, index, list) {\n      if (iterator.call(context, value, index, list)) results[results.length] = value;\n    });\n    return results;\n  };\n\n  // Return all the elements for which a truth test fails.\n  _.reject = function(obj, iterator, context) {\n    var results = [];\n    if (obj == null) return results;\n    each(obj, function(value, index, list) {\n      if (!iterator.call(context, value, index, list)) results[results.length] = value;\n    });\n    return results;\n  };\n\n  // Determine whether all of the elements match a truth test.\n  // Delegates to **ECMAScript 5**'s native `every` if available.\n  // Aliased as `all`.\n  _.every = _.all = function(obj, iterator, context) {\n    var result = true;\n    if (obj == null) return result;\n    if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);\n    each(obj, function(value, index, list) {\n      if (!(result = result && iterator.call(context, value, index, list))) return breaker;\n    });\n    return result;\n  };\n\n  // Determine if at least one element in the object matches a truth test.\n  // Delegates to **ECMAScript 5**'s native `some` if available.\n  // Aliased as `any`.\n  var any = _.some = _.any = function(obj, iterator, context) {\n    iterator || (iterator = _.identity);\n    var result = false;\n    if (obj == null) return result;\n    if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);\n    each(obj, function(value, index, list) {\n      if (result || (result = iterator.call(context, value, index, list))) return breaker;\n    });\n    return !!result;\n  };\n\n  // Determine if a given value is included in the array or object using `===`.\n  // Aliased as `contains`.\n  _.include = _.contains = function(obj, target) {\n    var found = false;\n    if (obj == null) return found;\n    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;\n    found = any(obj, function(value) {\n      return value === target;\n    });\n    return found;\n  };\n\n  // Invoke a method (with arguments) on every item in a collection.\n  _.invoke = function(obj, method) {\n    var args = slice.call(arguments, 2);\n    return _.map(obj, function(value) {\n      return (_.isFunction(method) ? method || value : value[method]).apply(value, args);\n    });\n  };\n\n  // Convenience version of a common use case of `map`: fetching a property.\n  _.pluck = function(obj, key) {\n    return _.map(obj, function(value){ return value[key]; });\n  };\n\n  // Return the maximum element or (element-based computation).\n  _.max = function(obj, iterator, context) {\n    if (!iterator && _.isArray(obj)) return Math.max.apply(Math, obj);\n    if (!iterator && _.isEmpty(obj)) return -Infinity;\n    var result = {computed : -Infinity};\n    each(obj, function(value, index, list) {\n      var computed = iterator ? iterator.call(context, value, index, list) : value;\n      computed >= result.computed && (result = {value : value, computed : computed});\n    });\n    return result.value;\n  };\n\n  // Return the minimum element (or element-based computation).\n  _.min = function(obj, iterator, context) {\n    if (!iterator && _.isArray(obj)) return Math.min.apply(Math, obj);\n    if (!iterator && _.isEmpty(obj)) return Infinity;\n    var result = {computed : Infinity};\n    each(obj, function(value, index, list) {\n      var computed = iterator ? iterator.call(context, value, index, list) : value;\n      computed < result.computed && (result = {value : value, computed : computed});\n    });\n    return result.value;\n  };\n\n  // Shuffle an array.\n  _.shuffle = function(obj) {\n    var shuffled = [], rand;\n    each(obj, function(value, index, list) {\n      if (index == 0) {\n        shuffled[0] = value;\n      } else {\n        rand = Math.floor(Math.random() * (index + 1));\n        shuffled[index] = shuffled[rand];\n        shuffled[rand] = value;\n      }\n    });\n    return shuffled;\n  };\n\n  // Sort the object's values by a criterion produced by an iterator.\n  _.sortBy = function(obj, iterator, context) {\n    return _.pluck(_.map(obj, function(value, index, list) {\n      return {\n        value : value,\n        criteria : iterator.call(context, value, index, list)\n      };\n    }).sort(function(left, right) {\n      var a = left.criteria, b = right.criteria;\n      return a < b ? -1 : a > b ? 1 : 0;\n    }), 'value');\n  };\n\n  // Groups the object's values by a criterion. Pass either a string attribute\n  // to group by, or a function that returns the criterion.\n  _.groupBy = function(obj, val) {\n    var result = {};\n    var iterator = _.isFunction(val) ? val : function(obj) { return obj[val]; };\n    each(obj, function(value, index) {\n      var key = iterator(value, index);\n      (result[key] || (result[key] = [])).push(value);\n    });\n    return result;\n  };\n\n  // Use a comparator function to figure out at what index an object should\n  // be inserted so as to maintain order. Uses binary search.\n  _.sortedIndex = function(array, obj, iterator) {\n    iterator || (iterator = _.identity);\n    var low = 0, high = array.length;\n    while (low < high) {\n      var mid = (low + high) >> 1;\n      iterator(array[mid]) < iterator(obj) ? low = mid + 1 : high = mid;\n    }\n    return low;\n  };\n\n  // Safely convert anything iterable into a real, live array.\n  _.toArray = function(iterable) {\n    if (!iterable)                return [];\n    if (iterable.toArray)         return iterable.toArray();\n    if (_.isArray(iterable))      return slice.call(iterable);\n    if (_.isArguments(iterable))  return slice.call(iterable);\n    return _.values(iterable);\n  };\n\n  // Return the number of elements in an object.\n  _.size = function(obj) {\n    return _.toArray(obj).length;\n  };\n\n  // Array Functions\n  // ---------------\n\n  // Get the first element of an array. Passing **n** will return the first N\n  // values in the array. Aliased as `head`. The **guard** check allows it to work\n  // with `_.map`.\n  _.first = _.head = function(array, n, guard) {\n    return (n != null) && !guard ? slice.call(array, 0, n) : array[0];\n  };\n\n  // Returns everything but the last entry of the array. Especcialy useful on\n  // the arguments object. Passing **n** will return all the values in\n  // the array, excluding the last N. The **guard** check allows it to work with\n  // `_.map`.\n  _.initial = function(array, n, guard) {\n    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));\n  };\n\n  // Get the last element of an array. Passing **n** will return the last N\n  // values in the array. The **guard** check allows it to work with `_.map`.\n  _.last = function(array, n, guard) {\n    if ((n != null) && !guard) {\n      return slice.call(array, Math.max(array.length - n, 0));\n    } else {\n      return array[array.length - 1];\n    }\n  };\n\n  // Returns everything but the first entry of the array. Aliased as `tail`.\n  // Especially useful on the arguments object. Passing an **index** will return\n  // the rest of the values in the array from that index onward. The **guard**\n  // check allows it to work with `_.map`.\n  _.rest = _.tail = function(array, index, guard) {\n    return slice.call(array, (index == null) || guard ? 1 : index);\n  };\n\n  // Trim out all falsy values from an array.\n  _.compact = function(array) {\n    return _.filter(array, function(value){ return !!value; });\n  };\n\n  // Return a completely flattened version of an array.\n  _.flatten = function(array, shallow) {\n    return _.reduce(array, function(memo, value) {\n      if (_.isArray(value)) return memo.concat(shallow ? value : _.flatten(value));\n      memo[memo.length] = value;\n      return memo;\n    }, []);\n  };\n\n  // Return a version of the array that does not contain the specified value(s).\n  _.without = function(array) {\n    return _.difference(array, slice.call(arguments, 1));\n  };\n\n  // Produce a duplicate-free version of the array. If the array has already\n  // been sorted, you have the option of using a faster algorithm.\n  // Aliased as `unique`.\n  _.uniq = _.unique = function(array, isSorted, iterator) {\n    var initial = iterator ? _.map(array, iterator) : array;\n    var result = [];\n    _.reduce(initial, function(memo, el, i) {\n      if (0 == i || (isSorted === true ? _.last(memo) != el : !_.include(memo, el))) {\n        memo[memo.length] = el;\n        result[result.length] = array[i];\n      }\n      return memo;\n    }, []);\n    return result;\n  };\n\n  // Produce an array that contains the union: each distinct element from all of\n  // the passed-in arrays.\n  _.union = function() {\n    return _.uniq(_.flatten(arguments, true));\n  };\n\n  // Produce an array that contains every item shared between all the\n  // passed-in arrays. (Aliased as \"intersect\" for back-compat.)\n  _.intersection = _.intersect = function(array) {\n    var rest = slice.call(arguments, 1);\n    return _.filter(_.uniq(array), function(item) {\n      return _.every(rest, function(other) {\n        return _.indexOf(other, item) >= 0;\n      });\n    });\n  };\n\n  // Take the difference between one array and a number of other arrays.\n  // Only the elements present in just the first array will remain.\n  _.difference = function(array) {\n    var rest = _.flatten(slice.call(arguments, 1));\n    return _.filter(array, function(value){ return !_.include(rest, value); });\n  };\n\n  // Zip together multiple lists into a single array -- elements that share\n  // an index go together.\n  _.zip = function() {\n    var args = slice.call(arguments);\n    var length = _.max(_.pluck(args, 'length'));\n    var results = new Array(length);\n    for (var i = 0; i < length; i++) results[i] = _.pluck(args, \"\" + i);\n    return results;\n  };\n\n  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),\n  // we need this function. Return the position of the first occurrence of an\n  // item in an array, or -1 if the item is not included in the array.\n  // Delegates to **ECMAScript 5**'s native `indexOf` if available.\n  // If the array is large and already in sort order, pass `true`\n  // for **isSorted** to use binary search.\n  _.indexOf = function(array, item, isSorted) {\n    if (array == null) return -1;\n    var i, l;\n    if (isSorted) {\n      i = _.sortedIndex(array, item);\n      return array[i] === item ? i : -1;\n    }\n    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item);\n    for (i = 0, l = array.length; i < l; i++) if (i in array && array[i] === item) return i;\n    return -1;\n  };\n\n  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.\n  _.lastIndexOf = function(array, item) {\n    if (array == null) return -1;\n    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) return array.lastIndexOf(item);\n    var i = array.length;\n    while (i--) if (i in array && array[i] === item) return i;\n    return -1;\n  };\n\n  // Generate an integer Array containing an arithmetic progression. A port of\n  // the native Python `range()` function. See\n  // [the Python documentation](http://docs.python.org/library/functions.html#range).\n  _.range = function(start, stop, step) {\n    if (arguments.length <= 1) {\n      stop = start || 0;\n      start = 0;\n    }\n    step = arguments[2] || 1;\n\n    var len = Math.max(Math.ceil((stop - start) / step), 0);\n    var idx = 0;\n    var range = new Array(len);\n\n    while(idx < len) {\n      range[idx++] = start;\n      start += step;\n    }\n\n    return range;\n  };\n\n  // Function (ahem) Functions\n  // ------------------\n\n  // Reusable constructor function for prototype setting.\n  var ctor = function(){};\n\n  // Create a function bound to a given object (assigning `this`, and arguments,\n  // optionally). Binding with arguments is also known as `curry`.\n  // Delegates to **ECMAScript 5**'s native `Function.bind` if available.\n  // We check for `func.bind` first, to fail fast when `func` is undefined.\n  _.bind = function bind(func, context) {\n    var bound, args;\n    if (func.bind === nativeBind && nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));\n    if (!_.isFunction(func)) throw new TypeError;\n    args = slice.call(arguments, 2);\n    return bound = function() {\n      if (!(this instanceof bound)) return func.apply(context, args.concat(slice.call(arguments)));\n      ctor.prototype = func.prototype;\n      var self = new ctor;\n      var result = func.apply(self, args.concat(slice.call(arguments)));\n      if (Object(result) === result) return result;\n      return self;\n    };\n  };\n\n  // Bind all of an object's methods to that object. Useful for ensuring that\n  // all callbacks defined on an object belong to it.\n  _.bindAll = function(obj) {\n    var funcs = slice.call(arguments, 1);\n    if (funcs.length == 0) funcs = _.functions(obj);\n    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });\n    return obj;\n  };\n\n  // Memoize an expensive function by storing its results.\n  _.memoize = function(func, hasher) {\n    var memo = {};\n    hasher || (hasher = _.identity);\n    return function() {\n      var key = hasher.apply(this, arguments);\n      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));\n    };\n  };\n\n  // Delays a function for the given number of milliseconds, and then calls\n  // it with the arguments supplied.\n  _.delay = function(func, wait) {\n    var args = slice.call(arguments, 2);\n    return setTimeout(function(){ return func.apply(func, args); }, wait);\n  };\n\n  // Defers a function, scheduling it to run after the current call stack has\n  // cleared.\n  _.defer = function(func) {\n    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));\n  };\n\n  // Returns a function, that, when invoked, will only be triggered at most once\n  // during a given window of time.\n  _.throttle = function(func, wait) {\n    var context, args, timeout, throttling, more;\n    var whenDone = _.debounce(function(){ more = throttling = false; }, wait);\n    return function() {\n      context = this; args = arguments;\n      var later = function() {\n        timeout = null;\n        if (more) func.apply(context, args);\n        whenDone();\n      };\n      if (!timeout) timeout = setTimeout(later, wait);\n      if (throttling) {\n        more = true;\n      } else {\n        func.apply(context, args);\n      }\n      whenDone();\n      throttling = true;\n    };\n  };\n\n  // Returns a function, that, as long as it continues to be invoked, will not\n  // be triggered. The function will be called after it stops being called for\n  // N milliseconds.\n  _.debounce = function(func, wait) {\n    var timeout;\n    return function() {\n      var context = this, args = arguments;\n      var later = function() {\n        timeout = null;\n        func.apply(context, args);\n      };\n      clearTimeout(timeout);\n      timeout = setTimeout(later, wait);\n    };\n  };\n\n  // Returns a function that will be executed at most one time, no matter how\n  // often you call it. Useful for lazy initialization.\n  _.once = function(func) {\n    var ran = false, memo;\n    return function() {\n      if (ran) return memo;\n      ran = true;\n      return memo = func.apply(this, arguments);\n    };\n  };\n\n  // Returns the first function passed as an argument to the second,\n  // allowing you to adjust arguments, run code before and after, and\n  // conditionally execute the original function.\n  _.wrap = function(func, wrapper) {\n    return function() {\n      var args = [func].concat(slice.call(arguments, 0));\n      return wrapper.apply(this, args);\n    };\n  };\n\n  // Returns a function that is the composition of a list of functions, each\n  // consuming the return value of the function that follows.\n  _.compose = function() {\n    var funcs = arguments;\n    return function() {\n      var args = arguments;\n      for (var i = funcs.length - 1; i >= 0; i--) {\n        args = [funcs[i].apply(this, args)];\n      }\n      return args[0];\n    };\n  };\n\n  // Returns a function that will only be executed after being called N times.\n  _.after = function(times, func) {\n    if (times <= 0) return func();\n    return function() {\n      if (--times < 1) { return func.apply(this, arguments); }\n    };\n  };\n\n  // Object Functions\n  // ----------------\n\n  // Retrieve the names of an object's properties.\n  // Delegates to **ECMAScript 5**'s native `Object.keys`\n  _.keys = nativeKeys || function(obj) {\n    if (obj !== Object(obj)) throw new TypeError('Invalid object');\n    var keys = [];\n    for (var key in obj) if (_.has(obj, key)) keys[keys.length] = key;\n    return keys;\n  };\n\n  // Retrieve the values of an object's properties.\n  _.values = function(obj) {\n    return _.map(obj, _.identity);\n  };\n\n  // Return a sorted list of the function names available on the object.\n  // Aliased as `methods`\n  _.functions = _.methods = function(obj) {\n    var names = [];\n    for (var key in obj) {\n      if (_.isFunction(obj[key])) names.push(key);\n    }\n    return names.sort();\n  };\n\n  // Extend a given object with all the properties in passed-in object(s).\n  _.extend = function(obj) {\n    each(slice.call(arguments, 1), function(source) {\n      for (var prop in source) {\n        obj[prop] = source[prop];\n      }\n    });\n    return obj;\n  };\n\n  // Fill in a given object with default properties.\n  _.defaults = function(obj) {\n    each(slice.call(arguments, 1), function(source) {\n      for (var prop in source) {\n        if (obj[prop] == null) obj[prop] = source[prop];\n      }\n    });\n    return obj;\n  };\n\n  // Create a (shallow-cloned) duplicate of an object.\n  _.clone = function(obj) {\n    if (!_.isObject(obj)) return obj;\n    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);\n  };\n\n  // Invokes interceptor with the obj, and then returns obj.\n  // The primary purpose of this method is to \"tap into\" a method chain, in\n  // order to perform operations on intermediate results within the chain.\n  _.tap = function(obj, interceptor) {\n    interceptor(obj);\n    return obj;\n  };\n\n  // Internal recursive comparison function.\n  function eq(a, b, stack) {\n    // Identical objects are equal. `0 === -0`, but they aren't identical.\n    // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.\n    if (a === b) return a !== 0 || 1 / a == 1 / b;\n    // A strict comparison is necessary because `null == undefined`.\n    if (a == null || b == null) return a === b;\n    // Unwrap any wrapped objects.\n    if (a._chain) a = a._wrapped;\n    if (b._chain) b = b._wrapped;\n    // Invoke a custom `isEqual` method if one is provided.\n    if (a.isEqual && _.isFunction(a.isEqual)) return a.isEqual(b);\n    if (b.isEqual && _.isFunction(b.isEqual)) return b.isEqual(a);\n    // Compare `[[Class]]` names.\n    var className = toString.call(a);\n    if (className != toString.call(b)) return false;\n    switch (className) {\n      // Strings, numbers, dates, and booleans are compared by value.\n      case '[object String]':\n        // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n        // equivalent to `new String(\"5\")`.\n        return a == String(b);\n      case '[object Number]':\n        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for\n        // other numeric values.\n        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);\n      case '[object Date]':\n      case '[object Boolean]':\n        // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n        // millisecond representations. Note that invalid dates with millisecond representations\n        // of `NaN` are not equivalent.\n        return +a == +b;\n      // RegExps are compared by their source patterns and flags.\n      case '[object RegExp]':\n        return a.source == b.source &&\n               a.global == b.global &&\n               a.multiline == b.multiline &&\n               a.ignoreCase == b.ignoreCase;\n    }\n    if (typeof a != 'object' || typeof b != 'object') return false;\n    // Assume equality for cyclic structures. The algorithm for detecting cyclic\n    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n    var length = stack.length;\n    while (length--) {\n      // Linear search. Performance is inversely proportional to the number of\n      // unique nested structures.\n      if (stack[length] == a) return true;\n    }\n    // Add the first object to the stack of traversed objects.\n    stack.push(a);\n    var size = 0, result = true;\n    // Recursively compare objects and arrays.\n    if (className == '[object Array]') {\n      // Compare array lengths to determine if a deep comparison is necessary.\n      size = a.length;\n      result = size == b.length;\n      if (result) {\n        // Deep compare the contents, ignoring non-numeric properties.\n        while (size--) {\n          // Ensure commutative equality for sparse arrays.\n          if (!(result = size in a == size in b && eq(a[size], b[size], stack))) break;\n        }\n      }\n    } else {\n      // Objects with different constructors are not equivalent.\n      if ('constructor' in a != 'constructor' in b || a.constructor != b.constructor) return false;\n      // Deep compare objects.\n      for (var key in a) {\n        if (_.has(a, key)) {\n          // Count the expected number of properties.\n          size++;\n          // Deep compare each member.\n          if (!(result = _.has(b, key) && eq(a[key], b[key], stack))) break;\n        }\n      }\n      // Ensure that both objects contain the same number of properties.\n      if (result) {\n        for (key in b) {\n          if (_.has(b, key) && !(size--)) break;\n        }\n        result = !size;\n      }\n    }\n    // Remove the first object from the stack of traversed objects.\n    stack.pop();\n    return result;\n  }\n\n  // Perform a deep comparison to check if two objects are equal.\n  _.isEqual = function(a, b) {\n    return eq(a, b, []);\n  };\n\n  // Is a given array, string, or object empty?\n  // An \"empty\" object has no enumerable own-properties.\n  _.isEmpty = function(obj) {\n    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;\n    for (var key in obj) if (_.has(obj, key)) return false;\n    return true;\n  };\n\n  // Is a given value a DOM element?\n  _.isElement = function(obj) {\n    return !!(obj && obj.nodeType == 1);\n  };\n\n  // Is a given value an array?\n  // Delegates to ECMA5's native Array.isArray\n  _.isArray = nativeIsArray || function(obj) {\n    return toString.call(obj) == '[object Array]';\n  };\n\n  // Is a given variable an object?\n  _.isObject = function(obj) {\n    return obj === Object(obj);\n  };\n\n  // Is a given variable an arguments object?\n  _.isArguments = function(obj) {\n    return toString.call(obj) == '[object Arguments]';\n  };\n  if (!_.isArguments(arguments)) {\n    _.isArguments = function(obj) {\n      return !!(obj && _.has(obj, 'callee'));\n    };\n  }\n\n  // Is a given value a function?\n  _.isFunction = function(obj) {\n    return toString.call(obj) == '[object Function]';\n  };\n\n  // Is a given value a string?\n  _.isString = function(obj) {\n    return toString.call(obj) == '[object String]';\n  };\n\n  // Is a given value a number?\n  _.isNumber = function(obj) {\n    return toString.call(obj) == '[object Number]';\n  };\n\n  // Is the given value `NaN`?\n  _.isNaN = function(obj) {\n    // `NaN` is the only value for which `===` is not reflexive.\n    return obj !== obj;\n  };\n\n  // Is a given value a boolean?\n  _.isBoolean = function(obj) {\n    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';\n  };\n\n  // Is a given value a date?\n  _.isDate = function(obj) {\n    return toString.call(obj) == '[object Date]';\n  };\n\n  // Is the given value a regular expression?\n  _.isRegExp = function(obj) {\n    return toString.call(obj) == '[object RegExp]';\n  };\n\n  // Is a given value equal to null?\n  _.isNull = function(obj) {\n    return obj === null;\n  };\n\n  // Is a given variable undefined?\n  _.isUndefined = function(obj) {\n    return obj === void 0;\n  };\n\n  // Has own property?\n  _.has = function(obj, key) {\n    return hasOwnProperty.call(obj, key);\n  };\n\n  // Utility Functions\n  // -----------------\n\n  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its\n  // previous owner. Returns a reference to the Underscore object.\n  _.noConflict = function() {\n    root._ = previousUnderscore;\n    return this;\n  };\n\n  // Keep the identity function around for default iterators.\n  _.identity = function(value) {\n    return value;\n  };\n\n  // Run a function **n** times.\n  _.times = function (n, iterator, context) {\n    for (var i = 0; i < n; i++) iterator.call(context, i);\n  };\n\n  // Escape a string for HTML interpolation.\n  _.escape = function(string) {\n    return (''+string).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\"/g, '&quot;').replace(/'/g, '&#x27;').replace(/\\//g,'&#x2F;');\n  };\n\n  // Add your own custom functions to the Underscore object, ensuring that\n  // they're correctly added to the OOP wrapper as well.\n  _.mixin = function(obj) {\n    each(_.functions(obj), function(name){\n      addToWrapper(name, _[name] = obj[name]);\n    });\n  };\n\n  // Generate a unique integer id (unique within the entire client session).\n  // Useful for temporary DOM ids.\n  var idCounter = 0;\n  _.uniqueId = function(prefix) {\n    var id = idCounter++;\n    return prefix ? prefix + id : id;\n  };\n\n  // By default, Underscore uses ERB-style template delimiters, change the\n  // following template settings to use alternative delimiters.\n  _.templateSettings = {\n    evaluate    : /<%([\\s\\S]+?)%>/g,\n    interpolate : /<%=([\\s\\S]+?)%>/g,\n    escape      : /<%-([\\s\\S]+?)%>/g\n  };\n\n  // When customizing `templateSettings`, if you don't want to define an\n  // interpolation, evaluation or escaping regex, we need one that is\n  // guaranteed not to match.\n  var noMatch = /.^/;\n\n  // Within an interpolation, evaluation, or escaping, remove HTML escaping\n  // that had been previously added.\n  var unescape = function(code) {\n    return code.replace(/\\\\\\\\/g, '\\\\').replace(/\\\\'/g, \"'\");\n  };\n\n  // JavaScript micro-templating, similar to John Resig's implementation.\n  // Underscore templating handles arbitrary delimiters, preserves whitespace,\n  // and correctly escapes quotes within interpolated code.\n  _.template = function(str, data) {\n    var c  = _.templateSettings;\n    var tmpl = 'var __p=[],print=function(){__p.push.apply(__p,arguments);};' +\n      'with(obj||{}){__p.push(\\'' +\n      str.replace(/\\\\/g, '\\\\\\\\')\n         .replace(/'/g, \"\\\\'\")\n         .replace(c.escape || noMatch, function(match, code) {\n           return \"',_.escape(\" + unescape(code) + \"),'\";\n         })\n         .replace(c.interpolate || noMatch, function(match, code) {\n           return \"',\" + unescape(code) + \",'\";\n         })\n         .replace(c.evaluate || noMatch, function(match, code) {\n           return \"');\" + unescape(code).replace(/[\\r\\n\\t]/g, ' ') + \";__p.push('\";\n         })\n         .replace(/\\r/g, '\\\\r')\n         .replace(/\\n/g, '\\\\n')\n         .replace(/\\t/g, '\\\\t')\n         + \"');}return __p.join('');\";\n    var func = new Function('obj', '_', tmpl);\n    if (data) return func(data, _);\n    return function(data) {\n      return func.call(this, data, _);\n    };\n  };\n\n  // Add a \"chain\" function, which will delegate to the wrapper.\n  _.chain = function(obj) {\n    return _(obj).chain();\n  };\n\n  // The OOP Wrapper\n  // ---------------\n\n  // If Underscore is called as a function, it returns a wrapped object that\n  // can be used OO-style. This wrapper holds altered versions of all the\n  // underscore functions. Wrapped objects may be chained.\n  var wrapper = function(obj) { this._wrapped = obj; };\n\n  // Expose `wrapper.prototype` as `_.prototype`\n  _.prototype = wrapper.prototype;\n\n  // Helper function to continue chaining intermediate results.\n  var result = function(obj, chain) {\n    return chain ? _(obj).chain() : obj;\n  };\n\n  // A method to easily add functions to the OOP wrapper.\n  var addToWrapper = function(name, func) {\n    wrapper.prototype[name] = function() {\n      var args = slice.call(arguments);\n      unshift.call(args, this._wrapped);\n      return result(func.apply(_, args), this._chain);\n    };\n  };\n\n  // Add all of the Underscore functions to the wrapper object.\n  _.mixin(_);\n\n  // Add all mutator Array functions to the wrapper.\n  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n    var method = ArrayProto[name];\n    wrapper.prototype[name] = function() {\n      var wrapped = this._wrapped;\n      method.apply(wrapped, arguments);\n      var length = wrapped.length;\n      if ((name == 'shift' || name == 'splice') && length === 0) delete wrapped[0];\n      return result(wrapped, this._chain);\n    };\n  });\n\n  // Add all accessor Array functions to the wrapper.\n  each(['concat', 'join', 'slice'], function(name) {\n    var method = ArrayProto[name];\n    wrapper.prototype[name] = function() {\n      return result(method.apply(this._wrapped, arguments), this._chain);\n    };\n  });\n\n  // Start chaining a wrapped Underscore object.\n  wrapper.prototype.chain = function() {\n    this._chain = true;\n    return this;\n  };\n\n  // Extracts the result from a wrapped and chained object.\n  wrapper.prototype.value = function() {\n    return this._wrapped;\n  };\n\n}).call(this);\n">>},
      {<<"async">>,
       <<"/*global setTimeout: false, console: false */\n(function () {\n\n    var async = {};\n\n    // global on the server, window in the browser\n    var root = this,\n        previous_async = root.async;\n\n    if (typeof module !== 'undefined' && module.exports) {\n        module.exports = async;\n    }\n    else {\n        root.async = async;\n    }\n\n    async.noConflict = function () {\n        root.async = previous_async;\n        return async;\n    };\n\n    //// cross-browser compatiblity functions ////\n\n    var _forEach = function (arr, iterator) {\n        if (arr.forEach) {\n            return arr.forEach(iterator);\n        }\n        for (var i = 0; i < arr.length; i += 1) {\n            iterator(arr[i], i, arr);\n        }\n    };\n\n    var _map = function (arr, iterator) {\n        if (arr.map) {\n            return arr.map(iterator);\n        }\n        var results = [];\n        _forEach(arr, function (x, i, a) {\n            results.push(iterator(x, i, a));\n        });\n        return results;\n    };\n\n    var _reduce = function (arr, iterator, memo) {\n        if (arr.reduce) {\n            return arr.reduce(iterator, memo);\n        }\n        _forEach(arr, function (x, i, a) {\n            memo = iterator(memo, x, i, a);\n        });\n        return memo;\n    };\n\n    var _keys = function (obj) {\n        if (Object.keys) {\n            return Object.keys(obj);\n        }\n        var keys = [];\n        for (var k in obj) {\n            if (obj.hasOwnProperty(k)) {\n                keys.push(k);\n            }\n        }\n        return keys;\n    };\n\n    var _indexOf = function (arr, item) {\n        if (arr.indexOf) {\n            return arr.indexOf(item);\n        }\n        for (var i = 0; i < arr.length; i += 1) {\n            if (arr[i] === item) {\n                return i;\n            }\n        }\n        return -1;\n    };\n\n    //// exported async module functions ////\n\n    //// nextTick implementation with browser-compatible fallback ////\n    if (typeof process === 'undefined' || !(process.nextTick)) {\n        async.nextTick = function (fn) {\n            setTimeout(fn, 0);\n        };\n    }\n    else {\n        async.nextTick = process.nextTick;\n    }\n\n    async.forEach = function (arr, iterator, callback) {\n        if (!arr.length) {\n            return callback();\n        }\n        var completed = 0;\n        _forEach(arr, function (x) {\n            iterator(x, function (err) {\n                if (err) {\n                    callback(err);\n                    callback = function () {};\n                }\n                else {\n                    completed += 1;\n                    if (completed === arr.length) {\n                        callback();\n                    }\n                }\n            });\n        });\n    };\n\n    async.forEachSeries = function (arr, iterator, callback) {\n        if (!arr.length) {\n            return callback();\n        }\n        var completed = 0;\n        var iterate = function () {\n            iterator(arr[completed], function (err) {\n                if (err) {\n                    callback(err);\n                    callback = function () {};\n                }\n                else {\n                    completed += 1;\n                    if (completed === arr.length) {\n                        callback();\n                    }\n                    else {\n                        iterate();\n                    }\n                }\n            });\n        };\n        iterate();\n    };\n    \n    async.forEachLimit = function (arr, limit, iterator, callback) {\n        if (!arr.length || limit <= 0) {\n            return callback(); \n        }\n        var completed = 0;\n        var started = 0;\n        var running = 0;\n        \n        (function replenish () {\n          if (completed === arr.length) {\n              return callback();\n          }\n          \n          while (running < limit && started < arr.length) {\n            iterator(arr[started], function (err) {\n              if (err) {\n                  callback(err);\n                  callback = function () {};\n              }\n              else {\n                  completed += 1;\n                  running -= 1;\n                  if (completed === arr.length) {\n                      callback();\n                  }\n                  else {\n                      replenish();\n                  }\n              }\n            });\n            started += 1;\n            running += 1;\n          }\n        })();\n    };\n\n\n    var doParallel = function (fn) {\n        return function () {\n            var args = Array.prototype.slice.call(arguments);\n            return fn.apply(null, [async.forEach].concat(args));\n        };\n    };\n    var doSeries = function (fn) {\n        return function () {\n            var args = Array.prototype.slice.call(arguments);\n            return fn.apply(null, [async.forEachSeries].concat(args));\n        };\n    };\n\n\n    var _asyncMap = function (eachfn, arr, iterator, callback) {\n        var results = [];\n        arr = _map(arr, function (x, i) {\n            return {index: i, value: x};\n        });\n        eachfn(arr, function (x, callback) {\n            iterator(x.value, function (err, v) {\n                results[x.index] = v;\n                callback(err);\n            });\n        }, function (err) {\n            callback(err, results);\n        });\n    };\n    async.map = doParallel(_asyncMap);\n    async.mapSeries = doSeries(_asyncMap);\n\n\n    // reduce only has a series version, as doing reduce in parallel won't\n    // work in many situations.\n    async.reduce = function (arr, memo, iterator, callback) {\n        async.forEachSeries(arr, function (x, callback) {\n            iterator(memo, x, function (err, v) {\n                memo = v;\n                callback(err);\n            });\n        }, function (err) {\n            callback(err, memo);\n        });\n    };\n    // inject alias\n    async.inject = async.reduce;\n    // foldl alias\n    async.foldl = async.reduce;\n\n    async.reduceRight = function (arr, memo, iterator, callback) {\n        var reversed = _map(arr, function (x) {\n            return x;\n        }).reverse();\n        async.reduce(reversed, memo, iterator, callback);\n    };\n    // foldr alias\n    async.foldr = async.reduceRight;\n\n    var _filter = function (eachfn, arr, iterator, callback) {\n        var results = [];\n        arr = _map(arr, function (x, i) {\n            return {index: i, value: x};\n        });\n        eachfn(arr, function (x, callback) {\n            iterator(x.value, function (v) {\n                if (v) {\n                    results.push(x);\n                }\n                callback();\n            });\n        }, function (err) {\n            callback(_map(results.sort(function (a, b) {\n                return a.index - b.index;\n            }), function (x) {\n                return x.value;\n            }));\n        });\n    };\n    async.filter = doParallel(_filter);\n    async.filterSeries = doSeries(_filter);\n    // select alias\n    async.select = async.filter;\n    async.selectSeries = async.filterSeries;\n\n    var _reject = function (eachfn, arr, iterator, callback) {\n        var results = [];\n        arr = _map(arr, function (x, i) {\n            return {index: i, value: x};\n        });\n        eachfn(arr, function (x, callback) {\n            iterator(x.value, function (v) {\n                if (!v) {\n                    results.push(x);\n                }\n                callback();\n            });\n        }, function (err) {\n            callback(_map(results.sort(function (a, b) {\n                return a.index - b.index;\n            }), function (x) {\n                return x.value;\n            }));\n        });\n    };\n    async.reject = doParallel(_reject);\n    async.rejectSeries = doSeries(_reject);\n\n    var _detect = function (eachfn, arr, iterator, main_callback) {\n        eachfn(arr, function (x, callback) {\n            iterator(x, function (result) {\n                if (result) {\n                    main_callback(x);\n                    main_callback = function () {};\n                }\n                else {\n                    callback();\n                }\n            });\n        }, function (err) {\n            main_callback();\n        });\n    };\n    async.detect = doParallel(_detect);\n    async.detectSeries = doSeries(_detect);\n\n    async.some = function (arr, iterator, main_callback) {\n        async.forEach(arr, function (x, callback) {\n            iterator(x, function (v) {\n                if (v) {\n                    main_callback(true);\n                    main_callback = function () {};\n                }\n                callback();\n            });\n        }, function (err) {\n            main_callback(false);\n        });\n    };\n    // any alias\n    async.any = async.some;\n\n    async.every = function (arr, iterator, main_callback) {\n        async.forEach(arr, function (x, callback) {\n            iterator(x, function (v) {\n                if (!v) {\n                    main_callback(false);\n                    main_callback = function () {};\n                }\n                callback();\n            });\n        }, function (err) {\n            main_callback(true);\n        });\n    };\n    // all alias\n    async.all = async.every;\n\n    async.sortBy = function (arr, iterator, callback) {\n        async.map(arr, function (x, callback) {\n            iterator(x, function (err, criteria) {\n                if (err) {\n                    callback(err);\n                }\n                else {\n                    callback(null, {value: x, criteria: criteria});\n                }\n            });\n        }, function (err, results) {\n            if (err) {\n                return callback(err);\n            }\n            else {\n                var fn = function (left, right) {\n                    var a = left.criteria, b = right.criteria;\n                    return a < b ? -1 : a > b ? 1 : 0;\n                };\n                callback(null, _map(results.sort(fn), function (x) {\n                    return x.value;\n                }));\n            }\n        });\n    };\n\n    async.auto = function (tasks, callback) {\n        callback = callback || function () {};\n        var keys = _keys(tasks);\n        if (!keys.length) {\n            return callback(null);\n        }\n\n        var results = {};\n\n        var listeners = [];\n        var addListener = function (fn) {\n            listeners.unshift(fn);\n        };\n        var removeListener = function (fn) {\n            for (var i = 0; i < listeners.length; i += 1) {\n                if (listeners[i] === fn) {\n                    listeners.splice(i, 1);\n                    return;\n                }\n            }\n        };\n        var taskComplete = function () {\n            _forEach(listeners, function (fn) {\n                fn();\n            });\n        };\n\n        addListener(function () {\n            if (_keys(results).length === keys.length) {\n                callback(null, results);\n            }\n        });\n\n        _forEach(keys, function (k) {\n            var task = (tasks[k] instanceof Function) ? [tasks[k]]: tasks[k];\n            var taskCallback = function (err) {\n                if (err) {\n                    callback(err);\n                    // stop subsequent errors hitting callback multiple times\n                    callback = function () {};\n                }\n                else {\n                    var args = Array.prototype.slice.call(arguments, 1);\n                    if (args.length <= 1) {\n                        args = args[0];\n                    }\n                    results[k] = args;\n                    taskComplete();\n                }\n            };\n            var requires = task.slice(0, Math.abs(task.length - 1)) || [];\n            var ready = function () {\n                return _reduce(requires, function (a, x) {\n                    return (a && results.hasOwnProperty(x));\n                }, true);\n            };\n            if (ready()) {\n                task[task.length - 1](taskCallback, results);\n            }\n            else {\n                var listener = function () {\n                    if (ready()) {\n                        removeListener(listener);\n                        task[task.length - 1](taskCallback, results);\n                    }\n                };\n                addListener(listener);\n            }\n        });\n    };\n\n    async.waterfall = function (tasks, callback) {\n        if (!tasks.length) {\n            return callback();\n        }\n        callback = callback || function () {};\n        var wrapIterator = function (iterator) {\n            return function (err) {\n                if (err) {\n                    callback(err);\n                    callback = function () {};\n                }\n                else {\n                    var args = Array.prototype.slice.call(arguments, 1);\n                    var next = iterator.next();\n                    if (next) {\n                        args.push(wrapIterator(next));\n                    }\n                    else {\n                        args.push(callback);\n                    }\n                    async.nextTick(function () {\n                        iterator.apply(null, args);\n                    });\n                }\n            };\n        };\n        wrapIterator(async.iterator(tasks))();\n    };\n\n    async.parallel = function (tasks, callback) {\n        callback = callback || function () {};\n        if (tasks.constructor === Array) {\n            async.map(tasks, function (fn, callback) {\n                if (fn) {\n                    fn(function (err) {\n                        var args = Array.prototype.slice.call(arguments, 1);\n                        if (args.length <= 1) {\n                            args = args[0];\n                        }\n                        callback.call(null, err, args);\n                    });\n                }\n            }, callback);\n        }\n        else {\n            var results = {};\n            async.forEach(_keys(tasks), function (k, callback) {\n                tasks[k](function (err) {\n                    var args = Array.prototype.slice.call(arguments, 1);\n                    if (args.length <= 1) {\n                        args = args[0];\n                    }\n                    results[k] = args;\n                    callback(err);\n                });\n            }, function (err) {\n                callback(err, results);\n            });\n        }\n    };\n\n    async.series = function (tasks, callback) {\n        callback = callback || function () {};\n        if (tasks.constructor === Array) {\n            async.mapSeries(tasks, function (fn, callback) {\n                if (fn) {\n                    fn(function (err) {\n                        var args = Array.prototype.slice.call(arguments, 1);\n                        if (args.length <= 1) {\n                            args = args[0];\n                        }\n                        callback.call(null, err, args);\n                    });\n                }\n            }, callback);\n        }\n        else {\n            var results = {};\n            async.forEachSeries(_keys(tasks), function (k, callback) {\n                tasks[k](function (err) {\n                    var args = Array.prototype.slice.call(arguments, 1);\n                    if (args.length <= 1) {\n                        args = args[0];\n                    }\n                    results[k] = args;\n                    callback(err);\n                });\n            }, function (err) {\n                callback(err, results);\n            });\n        }\n    };\n\n    async.iterator = function (tasks) {\n        var makeCallback = function (index) {\n            var fn = function () {\n                if (tasks.length) {\n                    tasks[index].apply(null, arguments);\n                }\n                return fn.next();\n            };\n            fn.next = function () {\n                return (index < tasks.length - 1) ? makeCallback(index + 1): null;\n            };\n            return fn;\n        };\n        return makeCallback(0);\n    };\n\n    async.apply = function (fn) {\n        var args = Array.prototype.slice.call(arguments, 1);\n        return function () {\n            return fn.apply(\n                null, args.concat(Array.prototype.slice.call(arguments))\n            );\n        };\n    };\n\n    var _concat = function (eachfn, arr, fn, callback) {\n        var r = [];\n        eachfn(arr, function (x, cb) {\n            fn(x, function (err, y) {\n                r = r.concat(y || []);\n                cb(err);\n            });\n        }, function (err) {\n            callback(err, r);\n        });\n    };\n    async.concat = doParallel(_concat);\n    async.concatSeries = doSeries(_concat);\n\n    async.whilst = function (test, iterator, callback) {\n        if (test()) {\n            iterator(function (err) {\n                if (err) {\n                    return callback(err);\n                }\n                async.whilst(test, iterator, callback);\n            });\n        }\n        else {\n            callback();\n        }\n    };\n\n    async.until = function (test, iterator, callback) {\n        if (!test()) {\n            iterator(function (err) {\n                if (err) {\n                    return callback(err);\n                }\n                async.until(test, iterator, callback);\n            });\n        }\n        else {\n            callback();\n        }\n    };\n\n    async.queue = function (worker, concurrency) {\n        var workers = 0;\n        var q = {\n            tasks: [],\n            concurrency: concurrency,\n            saturated: null,\n            empty: null,\n            drain: null,\n            push: function (data, callback) {\n                q.tasks.push({data: data, callback: callback});\n                if(q.saturated && q.tasks.length == concurrency) q.saturated();\n                async.nextTick(q.process);\n            },\n            process: function () {\n                if (workers < q.concurrency && q.tasks.length) {\n                    var task = q.tasks.shift();\n                    if(q.empty && q.tasks.length == 0) q.empty();\n                    workers += 1;\n                    worker(task.data, function () {\n                        workers -= 1;\n                        if (task.callback) {\n                            task.callback.apply(task, arguments);\n                        }\n                        if(q.drain && q.tasks.length + workers == 0) q.drain();\n                        q.process();\n                    });\n                }\n            },\n            length: function () {\n                return q.tasks.length;\n            },\n            running: function () {\n                return workers;\n            }\n        };\n        return q;\n    };\n\n    var _console_fn = function (name) {\n        return function (fn) {\n            var args = Array.prototype.slice.call(arguments, 1);\n            fn.apply(null, args.concat([function (err) {\n                var args = Array.prototype.slice.call(arguments, 1);\n                if (typeof console !== 'undefined') {\n                    if (err) {\n                        if (console.error) {\n                            console.error(err);\n                        }\n                    }\n                    else if (console[name]) {\n                        _forEach(args, function (x) {\n                            console[name](x);\n                        });\n                    }\n                }\n            }]));\n        };\n    };\n    async.log = _console_fn('log');\n    async.dir = _console_fn('dir');\n    /*async.info = _console_fn('info');\n    async.warn = _console_fn('warn');\n    async.error = _console_fn('error');*/\n\n    async.memoize = function (fn, hasher) {\n        var memo = {};\n        var queues = {};\n        hasher = hasher || function (x) {\n            return x;\n        };\n        var memoized = function () {\n            var args = Array.prototype.slice.call(arguments);\n            var callback = args.pop();\n            var key = hasher.apply(null, args);\n            if (key in memo) {\n                callback.apply(null, memo[key]);\n            }\n            else if (key in queues) {\n                queues[key].push(callback);\n            }\n            else {\n                queues[key] = [callback];\n                fn.apply(null, args.concat([function () {\n                    memo[key] = arguments;\n                    var q = queues[key];\n                    delete queues[key];\n                    for (var i = 0, l = q.length; i < l; i++) {\n                      q[i].apply(null, arguments);\n                    }\n                }]));\n            }\n        };\n        memoized.unmemoized = fn;\n        return memoized;\n    };\n\n    async.unmemoize = function (fn) {\n      return function () {\n        return (fn.unmemoized || fn).apply(null, arguments);\n      }\n    };\n\n}());\n">>},
      {<<"handlebars">>,
       <<47,47,32,108,105,98,47,104,97,110,100,108,101,98,97,114,115,47,98,97,115,
         101,46,106,115,10,118,97,114,32,72,97,110,100,108,101,98,97,114,115,32,
         61,32,123,125,59,10,10,72,97,110,100,108,101,98,97,114,115,46,86,69,82,
         83,73,79,78,32,61,32,34,49,46,48,46,98,101,116,97,46,50,34,59,10,10,72,
         97,110,100,108,101,98,97,114,115,46,104,101,108,112,101,114,115,32,32,61,
         32,123,125,59,10,72,97,110,100,108,101,98,97,114,115,46,112,97,114,116,
         105,97,108,115,32,61,32,123,125,59,10,10,72,97,110,100,108,101,98,97,114,
         115,46,114,101,103,105,115,116,101,114,72,101,108,112,101,114,32,61,32,
         102,117,110,99,116,105,111,110,40,110,97,109,101,44,32,102,110,44,32,105,
         110,118,101,114,115,101,41,32,123,10,32,32,105,102,40,105,110,118,101,
         114,115,101,41,32,123,32,102,110,46,110,111,116,32,61,32,105,110,118,101,
         114,115,101,59,32,125,10,32,32,116,104,105,115,46,104,101,108,112,101,
         114,115,91,110,97,109,101,93,32,61,32,102,110,59,10,125,59,10,10,72,97,
         110,100,108,101,98,97,114,115,46,114,101,103,105,115,116,101,114,80,97,
         114,116,105,97,108,32,61,32,102,117,110,99,116,105,111,110,40,110,97,109,
         101,44,32,115,116,114,41,32,123,10,32,32,116,104,105,115,46,112,97,114,
         116,105,97,108,115,91,110,97,109,101,93,32,61,32,115,116,114,59,10,125,
         59,10,10,72,97,110,100,108,101,98,97,114,115,46,114,101,103,105,115,116,
         101,114,72,101,108,112,101,114,40,39,104,101,108,112,101,114,77,105,115,
         115,105,110,103,39,44,32,102,117,110,99,116,105,111,110,40,97,114,103,41,
         32,123,10,32,32,105,102,40,97,114,103,117,109,101,110,116,115,46,108,101,
         110,103,116,104,32,61,61,61,32,50,41,32,123,10,32,32,32,32,114,101,116,
         117,114,110,32,117,110,100,101,102,105,110,101,100,59,10,32,32,125,32,
         101,108,115,101,32,123,10,32,32,32,32,116,104,114,111,119,32,110,101,119,
         32,69,114,114,111,114,40,34,67,111,117,108,100,32,110,111,116,32,102,105,
         110,100,32,112,114,111,112,101,114,116,121,32,39,34,32,43,32,97,114,103,
         32,43,32,34,39,34,41,59,10,32,32,125,10,125,41,59,10,10,72,97,110,100,
         108,101,98,97,114,115,46,114,101,103,105,115,116,101,114,72,101,108,112,
         101,114,40,39,98,108,111,99,107,72,101,108,112,101,114,77,105,115,115,
         105,110,103,39,44,32,102,117,110,99,116,105,111,110,40,99,111,110,116,
         101,120,116,44,32,111,112,116,105,111,110,115,41,32,123,10,32,32,118,97,
         114,32,105,110,118,101,114,115,101,32,61,32,111,112,116,105,111,110,115,
         46,105,110,118,101,114,115,101,32,124,124,32,102,117,110,99,116,105,111,
         110,40,41,32,123,125,44,32,102,110,32,61,32,111,112,116,105,111,110,115,
         46,102,110,59,10,10,10,32,32,118,97,114,32,114,101,116,32,61,32,34,34,59,
         10,32,32,118,97,114,32,116,121,112,101,32,61,32,79,98,106,101,99,116,46,
         112,114,111,116,111,116,121,112,101,46,116,111,83,116,114,105,110,103,46,
         99,97,108,108,40,99,111,110,116,101,120,116,41,59,10,10,32,32,105,102,40,
         116,121,112,101,32,61,61,61,32,34,91,111,98,106,101,99,116,32,70,117,110,
         99,116,105,111,110,93,34,41,32,123,10,32,32,32,32,99,111,110,116,101,120,
         116,32,61,32,99,111,110,116,101,120,116,40,41,59,10,32,32,125,10,10,32,
         32,105,102,40,99,111,110,116,101,120,116,32,61,61,61,32,116,114,117,101,
         41,32,123,10,32,32,32,32,114,101,116,117,114,110,32,102,110,40,116,104,
         105,115,41,59,10,32,32,125,32,101,108,115,101,32,105,102,40,99,111,110,
         116,101,120,116,32,61,61,61,32,102,97,108,115,101,32,124,124,32,99,111,
         110,116,101,120,116,32,61,61,32,110,117,108,108,41,32,123,10,32,32,32,32,
         114,101,116,117,114,110,32,105,110,118,101,114,115,101,40,116,104,105,
         115,41,59,10,32,32,125,32,101,108,115,101,32,105,102,40,116,121,112,101,
         32,61,61,61,32,34,91,111,98,106,101,99,116,32,65,114,114,97,121,93,34,41,
         32,123,10,32,32,32,32,105,102,40,99,111,110,116,101,120,116,46,108,101,
         110,103,116,104,32,62,32,48,41,32,123,10,32,32,32,32,32,32,102,111,114,
         40,118,97,114,32,105,61,48,44,32,106,61,99,111,110,116,101,120,116,46,
         108,101,110,103,116,104,59,32,105,60,106,59,32,105,43,43,41,32,123,10,32,
         32,32,32,32,32,32,32,114,101,116,32,61,32,114,101,116,32,43,32,102,110,
         40,99,111,110,116,101,120,116,91,105,93,41,59,10,32,32,32,32,32,32,125,
         10,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,114,
         101,116,32,61,32,105,110,118,101,114,115,101,40,116,104,105,115,41,59,10,
         32,32,32,32,125,10,32,32,32,32,114,101,116,117,114,110,32,114,101,116,59,
         10,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,114,101,116,117,
         114,110,32,102,110,40,99,111,110,116,101,120,116,41,59,10,32,32,125,10,
         125,41,59,10,10,72,97,110,100,108,101,98,97,114,115,46,114,101,103,105,
         115,116,101,114,72,101,108,112,101,114,40,39,101,97,99,104,39,44,32,102,
         117,110,99,116,105,111,110,40,99,111,110,116,101,120,116,44,32,111,112,
         116,105,111,110,115,41,32,123,10,32,32,118,97,114,32,102,110,32,61,32,
         111,112,116,105,111,110,115,46,102,110,44,32,105,110,118,101,114,115,101,
         32,61,32,111,112,116,105,111,110,115,46,105,110,118,101,114,115,101,59,
         10,32,32,118,97,114,32,114,101,116,32,61,32,34,34,59,10,10,32,32,105,102,
         40,99,111,110,116,101,120,116,32,38,38,32,99,111,110,116,101,120,116,46,
         108,101,110,103,116,104,32,62,32,48,41,32,123,10,32,32,32,32,102,111,114,
         40,118,97,114,32,105,61,48,44,32,106,61,99,111,110,116,101,120,116,46,
         108,101,110,103,116,104,59,32,105,60,106,59,32,105,43,43,41,32,123,10,32,
         32,32,32,32,32,114,101,116,32,61,32,114,101,116,32,43,32,102,110,40,99,
         111,110,116,101,120,116,91,105,93,41,59,10,32,32,32,32,125,10,32,32,125,
         32,101,108,115,101,32,123,10,32,32,32,32,114,101,116,32,61,32,105,110,
         118,101,114,115,101,40,116,104,105,115,41,59,10,32,32,125,10,32,32,114,
         101,116,117,114,110,32,114,101,116,59,10,125,41,59,10,10,72,97,110,100,
         108,101,98,97,114,115,46,114,101,103,105,115,116,101,114,72,101,108,112,
         101,114,40,39,105,102,39,44,32,102,117,110,99,116,105,111,110,40,99,111,
         110,116,101,120,116,44,32,111,112,116,105,111,110,115,41,32,123,10,32,32,
         105,102,40,33,99,111,110,116,101,120,116,32,124,124,32,72,97,110,100,108,
         101,98,97,114,115,46,85,116,105,108,115,46,105,115,69,109,112,116,121,40,
         99,111,110,116,101,120,116,41,41,32,123,10,32,32,32,32,114,101,116,117,
         114,110,32,111,112,116,105,111,110,115,46,105,110,118,101,114,115,101,40,
         116,104,105,115,41,59,10,32,32,125,32,101,108,115,101,32,123,10,32,32,32,
         32,114,101,116,117,114,110,32,111,112,116,105,111,110,115,46,102,110,40,
         116,104,105,115,41,59,10,32,32,125,10,125,41,59,10,10,72,97,110,100,108,
         101,98,97,114,115,46,114,101,103,105,115,116,101,114,72,101,108,112,101,
         114,40,39,117,110,108,101,115,115,39,44,32,102,117,110,99,116,105,111,
         110,40,99,111,110,116,101,120,116,44,32,111,112,116,105,111,110,115,41,
         32,123,10,32,32,118,97,114,32,102,110,32,61,32,111,112,116,105,111,110,
         115,46,102,110,44,32,105,110,118,101,114,115,101,32,61,32,111,112,116,
         105,111,110,115,46,105,110,118,101,114,115,101,59,10,32,32,111,112,116,
         105,111,110,115,46,102,110,32,61,32,105,110,118,101,114,115,101,59,10,32,
         32,111,112,116,105,111,110,115,46,105,110,118,101,114,115,101,32,61,32,
         102,110,59,10,10,32,32,114,101,116,117,114,110,32,72,97,110,100,108,101,
         98,97,114,115,46,104,101,108,112,101,114,115,91,39,105,102,39,93,46,99,
         97,108,108,40,116,104,105,115,44,32,99,111,110,116,101,120,116,44,32,111,
         112,116,105,111,110,115,41,59,10,125,41,59,10,10,72,97,110,100,108,101,
         98,97,114,115,46,114,101,103,105,115,116,101,114,72,101,108,112,101,114,
         40,39,119,105,116,104,39,44,32,102,117,110,99,116,105,111,110,40,99,111,
         110,116,101,120,116,44,32,111,112,116,105,111,110,115,41,32,123,10,32,32,
         114,101,116,117,114,110,32,111,112,116,105,111,110,115,46,102,110,40,99,
         111,110,116,101,120,116,41,59,10,125,41,59,10,59,10,47,47,32,108,105,98,
         47,104,97,110,100,108,101,98,97,114,115,47,99,111,109,112,105,108,101,
         114,47,112,97,114,115,101,114,46,106,115,10,47,42,32,74,105,115,111,110,
         32,103,101,110,101,114,97,116,101,100,32,112,97,114,115,101,114,32,42,47,
         10,118,97,114,32,104,97,110,100,108,101,98,97,114,115,32,61,32,40,102,
         117,110,99,116,105,111,110,40,41,123,10,10,118,97,114,32,112,97,114,115,
         101,114,32,61,32,123,116,114,97,99,101,58,32,102,117,110,99,116,105,111,
         110,32,116,114,97,99,101,40,41,32,123,32,125,44,10,121,121,58,32,123,125,
         44,10,115,121,109,98,111,108,115,95,58,32,123,34,101,114,114,111,114,34,
         58,50,44,34,114,111,111,116,34,58,51,44,34,112,114,111,103,114,97,109,34,
         58,52,44,34,69,79,70,34,58,53,44,34,115,116,97,116,101,109,101,110,116,
         115,34,58,54,44,34,115,105,109,112,108,101,73,110,118,101,114,115,101,34,
         58,55,44,34,115,116,97,116,101,109,101,110,116,34,58,56,44,34,111,112,
         101,110,73,110,118,101,114,115,101,34,58,57,44,34,99,108,111,115,101,66,
         108,111,99,107,34,58,49,48,44,34,111,112,101,110,66,108,111,99,107,34,58,
         49,49,44,34,109,117,115,116,97,99,104,101,34,58,49,50,44,34,112,97,114,
         116,105,97,108,34,58,49,51,44,34,67,79,78,84,69,78,84,34,58,49,52,44,34,
         67,79,77,77,69,78,84,34,58,49,53,44,34,79,80,69,78,95,66,76,79,67,75,34,
         58,49,54,44,34,105,110,77,117,115,116,97,99,104,101,34,58,49,55,44,34,67,
         76,79,83,69,34,58,49,56,44,34,79,80,69,78,95,73,78,86,69,82,83,69,34,58,
         49,57,44,34,79,80,69,78,95,69,78,68,66,76,79,67,75,34,58,50,48,44,34,112,
         97,116,104,34,58,50,49,44,34,79,80,69,78,34,58,50,50,44,34,79,80,69,78,
         95,85,78,69,83,67,65,80,69,68,34,58,50,51,44,34,79,80,69,78,95,80,65,82,
         84,73,65,76,34,58,50,52,44,34,112,97,114,97,109,115,34,58,50,53,44,34,
         104,97,115,104,34,58,50,54,44,34,112,97,114,97,109,34,58,50,55,44,34,83,
         84,82,73,78,71,34,58,50,56,44,34,73,78,84,69,71,69,82,34,58,50,57,44,34,
         66,79,79,76,69,65,78,34,58,51,48,44,34,104,97,115,104,83,101,103,109,101,
         110,116,115,34,58,51,49,44,34,104,97,115,104,83,101,103,109,101,110,116,
         34,58,51,50,44,34,73,68,34,58,51,51,44,34,69,81,85,65,76,83,34,58,51,52,
         44,34,112,97,116,104,83,101,103,109,101,110,116,115,34,58,51,53,44,34,83,
         69,80,34,58,51,54,44,34,36,97,99,99,101,112,116,34,58,48,44,34,36,101,
         110,100,34,58,49,125,44,10,116,101,114,109,105,110,97,108,115,95,58,32,
         123,50,58,34,101,114,114,111,114,34,44,53,58,34,69,79,70,34,44,49,52,58,
         34,67,79,78,84,69,78,84,34,44,49,53,58,34,67,79,77,77,69,78,84,34,44,49,
         54,58,34,79,80,69,78,95,66,76,79,67,75,34,44,49,56,58,34,67,76,79,83,69,
         34,44,49,57,58,34,79,80,69,78,95,73,78,86,69,82,83,69,34,44,50,48,58,34,
         79,80,69,78,95,69,78,68,66,76,79,67,75,34,44,50,50,58,34,79,80,69,78,34,
         44,50,51,58,34,79,80,69,78,95,85,78,69,83,67,65,80,69,68,34,44,50,52,58,
         34,79,80,69,78,95,80,65,82,84,73,65,76,34,44,50,56,58,34,83,84,82,73,78,
         71,34,44,50,57,58,34,73,78,84,69,71,69,82,34,44,51,48,58,34,66,79,79,76,
         69,65,78,34,44,51,51,58,34,73,68,34,44,51,52,58,34,69,81,85,65,76,83,34,
         44,51,54,58,34,83,69,80,34,125,44,10,112,114,111,100,117,99,116,105,111,
         110,115,95,58,32,91,48,44,91,51,44,50,93,44,91,52,44,51,93,44,91,52,44,
         49,93,44,91,52,44,48,93,44,91,54,44,49,93,44,91,54,44,50,93,44,91,56,44,
         51,93,44,91,56,44,51,93,44,91,56,44,49,93,44,91,56,44,49,93,44,91,56,44,
         49,93,44,91,56,44,49,93,44,91,49,49,44,51,93,44,91,57,44,51,93,44,91,49,
         48,44,51,93,44,91,49,50,44,51,93,44,91,49,50,44,51,93,44,91,49,51,44,51,
         93,44,91,49,51,44,52,93,44,91,55,44,50,93,44,91,49,55,44,51,93,44,91,49,
         55,44,50,93,44,91,49,55,44,50,93,44,91,49,55,44,49,93,44,91,50,53,44,50,
         93,44,91,50,53,44,49,93,44,91,50,55,44,49,93,44,91,50,55,44,49,93,44,91,
         50,55,44,49,93,44,91,50,55,44,49,93,44,91,50,54,44,49,93,44,91,51,49,44,
         50,93,44,91,51,49,44,49,93,44,91,51,50,44,51,93,44,91,51,50,44,51,93,44,
         91,51,50,44,51,93,44,91,51,50,44,51,93,44,91,50,49,44,49,93,44,91,51,53,
         44,51,93,44,91,51,53,44,49,93,93,44,10,112,101,114,102,111,114,109,65,99,
         116,105,111,110,58,32,102,117,110,99,116,105,111,110,32,97,110,111,110,
         121,109,111,117,115,40,121,121,116,101,120,116,44,121,121,108,101,110,
         103,44,121,121,108,105,110,101,110,111,44,121,121,44,121,121,115,116,97,
         116,101,44,36,36,44,95,36,41,32,123,10,10,118,97,114,32,36,48,32,61,32,
         36,36,46,108,101,110,103,116,104,32,45,32,49,59,10,115,119,105,116,99,
         104,32,40,121,121,115,116,97,116,101,41,32,123,10,99,97,115,101,32,49,58,
         32,114,101,116,117,114,110,32,36,36,91,36,48,45,49,93,32,10,98,114,101,
         97,107,59,10,99,97,115,101,32,50,58,32,116,104,105,115,46,36,32,61,32,
         110,101,119,32,121,121,46,80,114,111,103,114,97,109,78,111,100,101,40,36,
         36,91,36,48,45,50,93,44,32,36,36,91,36,48,93,41,32,10,98,114,101,97,107,
         59,10,99,97,115,101,32,51,58,32,116,104,105,115,46,36,32,61,32,110,101,
         119,32,121,121,46,80,114,111,103,114,97,109,78,111,100,101,40,36,36,91,
         36,48,93,41,32,10,98,114,101,97,107,59,10,99,97,115,101,32,52,58,32,116,
         104,105,115,46,36,32,61,32,110,101,119,32,121,121,46,80,114,111,103,114,
         97,109,78,111,100,101,40,91,93,41,32,10,98,114,101,97,107,59,10,99,97,
         115,101,32,53,58,32,116,104,105,115,46,36,32,61,32,91,36,36,91,36,48,93,
         93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,54,58,32,36,36,91,36,
         48,45,49,93,46,112,117,115,104,40,36,36,91,36,48,93,41,59,32,116,104,105,
         115,46,36,32,61,32,36,36,91,36,48,45,49,93,32,10,98,114,101,97,107,59,10,
         99,97,115,101,32,55,58,32,116,104,105,115,46,36,32,61,32,110,101,119,32,
         121,121,46,73,110,118,101,114,115,101,78,111,100,101,40,36,36,91,36,48,
         45,50,93,44,32,36,36,91,36,48,45,49,93,44,32,36,36,91,36,48,93,41,32,10,
         98,114,101,97,107,59,10,99,97,115,101,32,56,58,32,116,104,105,115,46,36,
         32,61,32,110,101,119,32,121,121,46,66,108,111,99,107,78,111,100,101,40,
         36,36,91,36,48,45,50,93,44,32,36,36,91,36,48,45,49,93,44,32,36,36,91,36,
         48,93,41,32,10,98,114,101,97,107,59,10,99,97,115,101,32,57,58,32,116,104,
         105,115,46,36,32,61,32,36,36,91,36,48,93,32,10,98,114,101,97,107,59,10,
         99,97,115,101,32,49,48,58,32,116,104,105,115,46,36,32,61,32,36,36,91,36,
         48,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,49,58,32,116,104,
         105,115,46,36,32,61,32,110,101,119,32,121,121,46,67,111,110,116,101,110,
         116,78,111,100,101,40,36,36,91,36,48,93,41,32,10,98,114,101,97,107,59,10,
         99,97,115,101,32,49,50,58,32,116,104,105,115,46,36,32,61,32,110,101,119,
         32,121,121,46,67,111,109,109,101,110,116,78,111,100,101,40,36,36,91,36,
         48,93,41,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,51,58,32,116,
         104,105,115,46,36,32,61,32,110,101,119,32,121,121,46,77,117,115,116,97,
         99,104,101,78,111,100,101,40,36,36,91,36,48,45,49,93,91,48,93,44,32,36,
         36,91,36,48,45,49,93,91,49,93,41,32,10,98,114,101,97,107,59,10,99,97,115,
         101,32,49,52,58,32,116,104,105,115,46,36,32,61,32,110,101,119,32,121,121,
         46,77,117,115,116,97,99,104,101,78,111,100,101,40,36,36,91,36,48,45,49,
         93,91,48,93,44,32,36,36,91,36,48,45,49,93,91,49,93,41,32,10,98,114,101,
         97,107,59,10,99,97,115,101,32,49,53,58,32,116,104,105,115,46,36,32,61,32,
         36,36,91,36,48,45,49,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,
         49,54,58,32,116,104,105,115,46,36,32,61,32,110,101,119,32,121,121,46,77,
         117,115,116,97,99,104,101,78,111,100,101,40,36,36,91,36,48,45,49,93,91,
         48,93,44,32,36,36,91,36,48,45,49,93,91,49,93,41,32,10,98,114,101,97,107,
         59,10,99,97,115,101,32,49,55,58,32,116,104,105,115,46,36,32,61,32,110,
         101,119,32,121,121,46,77,117,115,116,97,99,104,101,78,111,100,101,40,36,
         36,91,36,48,45,49,93,91,48,93,44,32,36,36,91,36,48,45,49,93,91,49,93,44,
         32,116,114,117,101,41,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,
         56,58,32,116,104,105,115,46,36,32,61,32,110,101,119,32,121,121,46,80,97,
         114,116,105,97,108,78,111,100,101,40,36,36,91,36,48,45,49,93,41,32,10,98,
         114,101,97,107,59,10,99,97,115,101,32,49,57,58,32,116,104,105,115,46,36,
         32,61,32,110,101,119,32,121,121,46,80,97,114,116,105,97,108,78,111,100,
         101,40,36,36,91,36,48,45,50,93,44,32,36,36,91,36,48,45,49,93,41,32,10,98,
         114,101,97,107,59,10,99,97,115,101,32,50,48,58,32,10,98,114,101,97,107,
         59,10,99,97,115,101,32,50,49,58,32,116,104,105,115,46,36,32,61,32,91,91,
         36,36,91,36,48,45,50,93,93,46,99,111,110,99,97,116,40,36,36,91,36,48,45,
         49,93,41,44,32,36,36,91,36,48,93,93,32,10,98,114,101,97,107,59,10,99,97,
         115,101,32,50,50,58,32,116,104,105,115,46,36,32,61,32,91,91,36,36,91,36,
         48,45,49,93,93,46,99,111,110,99,97,116,40,36,36,91,36,48,93,41,44,32,110,
         117,108,108,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,50,51,58,
         32,116,104,105,115,46,36,32,61,32,91,91,36,36,91,36,48,45,49,93,93,44,32,
         36,36,91,36,48,93,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,50,
         52,58,32,116,104,105,115,46,36,32,61,32,91,91,36,36,91,36,48,93,93,44,32,
         110,117,108,108,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,50,53,
         58,32,36,36,91,36,48,45,49,93,46,112,117,115,104,40,36,36,91,36,48,93,41,
         59,32,116,104,105,115,46,36,32,61,32,36,36,91,36,48,45,49,93,59,32,10,98,
         114,101,97,107,59,10,99,97,115,101,32,50,54,58,32,116,104,105,115,46,36,
         32,61,32,91,36,36,91,36,48,93,93,32,10,98,114,101,97,107,59,10,99,97,115,
         101,32,50,55,58,32,116,104,105,115,46,36,32,61,32,36,36,91,36,48,93,32,
         10,98,114,101,97,107,59,10,99,97,115,101,32,50,56,58,32,116,104,105,115,
         46,36,32,61,32,110,101,119,32,121,121,46,83,116,114,105,110,103,78,111,
         100,101,40,36,36,91,36,48,93,41,32,10,98,114,101,97,107,59,10,99,97,115,
         101,32,50,57,58,32,116,104,105,115,46,36,32,61,32,110,101,119,32,121,121,
         46,73,110,116,101,103,101,114,78,111,100,101,40,36,36,91,36,48,93,41,32,
         10,98,114,101,97,107,59,10,99,97,115,101,32,51,48,58,32,116,104,105,115,
         46,36,32,61,32,110,101,119,32,121,121,46,66,111,111,108,101,97,110,78,
         111,100,101,40,36,36,91,36,48,93,41,32,10,98,114,101,97,107,59,10,99,97,
         115,101,32,51,49,58,32,116,104,105,115,46,36,32,61,32,110,101,119,32,121,
         121,46,72,97,115,104,78,111,100,101,40,36,36,91,36,48,93,41,32,10,98,114,
         101,97,107,59,10,99,97,115,101,32,51,50,58,32,36,36,91,36,48,45,49,93,46,
         112,117,115,104,40,36,36,91,36,48,93,41,59,32,116,104,105,115,46,36,32,
         61,32,36,36,91,36,48,45,49,93,32,10,98,114,101,97,107,59,10,99,97,115,
         101,32,51,51,58,32,116,104,105,115,46,36,32,61,32,91,36,36,91,36,48,93,
         93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,51,52,58,32,116,104,
         105,115,46,36,32,61,32,91,36,36,91,36,48,45,50,93,44,32,36,36,91,36,48,
         93,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,51,53,58,32,116,104,
         105,115,46,36,32,61,32,91,36,36,91,36,48,45,50,93,44,32,110,101,119,32,
         121,121,46,83,116,114,105,110,103,78,111,100,101,40,36,36,91,36,48,93,41,
         93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,51,54,58,32,116,104,
         105,115,46,36,32,61,32,91,36,36,91,36,48,45,50,93,44,32,110,101,119,32,
         121,121,46,73,110,116,101,103,101,114,78,111,100,101,40,36,36,91,36,48,
         93,41,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,51,55,58,32,116,
         104,105,115,46,36,32,61,32,91,36,36,91,36,48,45,50,93,44,32,110,101,119,
         32,121,121,46,66,111,111,108,101,97,110,78,111,100,101,40,36,36,91,36,48,
         93,41,93,32,10,98,114,101,97,107,59,10,99,97,115,101,32,51,56,58,32,116,
         104,105,115,46,36,32,61,32,110,101,119,32,121,121,46,73,100,78,111,100,
         101,40,36,36,91,36,48,93,41,32,10,98,114,101,97,107,59,10,99,97,115,101,
         32,51,57,58,32,36,36,91,36,48,45,50,93,46,112,117,115,104,40,36,36,91,36,
         48,93,41,59,32,116,104,105,115,46,36,32,61,32,36,36,91,36,48,45,50,93,59,
         32,10,98,114,101,97,107,59,10,99,97,115,101,32,52,48,58,32,116,104,105,
         115,46,36,32,61,32,91,36,36,91,36,48,93,93,32,10,98,114,101,97,107,59,10,
         125,10,125,44,10,116,97,98,108,101,58,32,91,123,51,58,49,44,52,58,50,44,
         53,58,91,50,44,52,93,44,54,58,51,44,56,58,52,44,57,58,53,44,49,49,58,54,
         44,49,50,58,55,44,49,51,58,56,44,49,52,58,91,49,44,57,93,44,49,53,58,91,
         49,44,49,48,93,44,49,54,58,91,49,44,49,50,93,44,49,57,58,91,49,44,49,49,
         93,44,50,50,58,91,49,44,49,51,93,44,50,51,58,91,49,44,49,52,93,44,50,52,
         58,91,49,44,49,53,93,125,44,123,49,58,91,51,93,125,44,123,53,58,91,49,44,
         49,54,93,125,44,123,53,58,91,50,44,51,93,44,55,58,49,55,44,56,58,49,56,
         44,57,58,53,44,49,49,58,54,44,49,50,58,55,44,49,51,58,56,44,49,52,58,91,
         49,44,57,93,44,49,53,58,91,49,44,49,48,93,44,49,54,58,91,49,44,49,50,93,
         44,49,57,58,91,49,44,49,57,93,44,50,48,58,91,50,44,51,93,44,50,50,58,91,
         49,44,49,51,93,44,50,51,58,91,49,44,49,52,93,44,50,52,58,91,49,44,49,53,
         93,125,44,123,53,58,91,50,44,53,93,44,49,52,58,91,50,44,53,93,44,49,53,
         58,91,50,44,53,93,44,49,54,58,91,50,44,53,93,44,49,57,58,91,50,44,53,93,
         44,50,48,58,91,50,44,53,93,44,50,50,58,91,50,44,53,93,44,50,51,58,91,50,
         44,53,93,44,50,52,58,91,50,44,53,93,125,44,123,52,58,50,48,44,54,58,51,
         44,56,58,52,44,57,58,53,44,49,49,58,54,44,49,50,58,55,44,49,51,58,56,44,
         49,52,58,91,49,44,57,93,44,49,53,58,91,49,44,49,48,93,44,49,54,58,91,49,
         44,49,50,93,44,49,57,58,91,49,44,49,49,93,44,50,48,58,91,50,44,52,93,44,
         50,50,58,91,49,44,49,51,93,44,50,51,58,91,49,44,49,52,93,44,50,52,58,91,
         49,44,49,53,93,125,44,123,52,58,50,49,44,54,58,51,44,56,58,52,44,57,58,
         53,44,49,49,58,54,44,49,50,58,55,44,49,51,58,56,44,49,52,58,91,49,44,57,
         93,44,49,53,58,91,49,44,49,48,93,44,49,54,58,91,49,44,49,50,93,44,49,57,
         58,91,49,44,49,49,93,44,50,48,58,91,50,44,52,93,44,50,50,58,91,49,44,49,
         51,93,44,50,51,58,91,49,44,49,52,93,44,50,52,58,91,49,44,49,53,93,125,44,
         123,53,58,91,50,44,57,93,44,49,52,58,91,50,44,57,93,44,49,53,58,91,50,44,
         57,93,44,49,54,58,91,50,44,57,93,44,49,57,58,91,50,44,57,93,44,50,48,58,
         91,50,44,57,93,44,50,50,58,91,50,44,57,93,44,50,51,58,91,50,44,57,93,44,
         50,52,58,91,50,44,57,93,125,44,123,53,58,91,50,44,49,48,93,44,49,52,58,
         91,50,44,49,48,93,44,49,53,58,91,50,44,49,48,93,44,49,54,58,91,50,44,49,
         48,93,44,49,57,58,91,50,44,49,48,93,44,50,48,58,91,50,44,49,48,93,44,50,
         50,58,91,50,44,49,48,93,44,50,51,58,91,50,44,49,48,93,44,50,52,58,91,50,
         44,49,48,93,125,44,123,53,58,91,50,44,49,49,93,44,49,52,58,91,50,44,49,
         49,93,44,49,53,58,91,50,44,49,49,93,44,49,54,58,91,50,44,49,49,93,44,49,
         57,58,91,50,44,49,49,93,44,50,48,58,91,50,44,49,49,93,44,50,50,58,91,50,
         44,49,49,93,44,50,51,58,91,50,44,49,49,93,44,50,52,58,91,50,44,49,49,93,
         125,44,123,53,58,91,50,44,49,50,93,44,49,52,58,91,50,44,49,50,93,44,49,
         53,58,91,50,44,49,50,93,44,49,54,58,91,50,44,49,50,93,44,49,57,58,91,50,
         44,49,50,93,44,50,48,58,91,50,44,49,50,93,44,50,50,58,91,50,44,49,50,93,
         44,50,51,58,91,50,44,49,50,93,44,50,52,58,91,50,44,49,50,93,125,44,123,
         49,55,58,50,50,44,50,49,58,50,51,44,51,51,58,91,49,44,50,53,93,44,51,53,
         58,50,52,125,44,123,49,55,58,50,54,44,50,49,58,50,51,44,51,51,58,91,49,
         44,50,53,93,44,51,53,58,50,52,125,44,123,49,55,58,50,55,44,50,49,58,50,
         51,44,51,51,58,91,49,44,50,53,93,44,51,53,58,50,52,125,44,123,49,55,58,
         50,56,44,50,49,58,50,51,44,51,51,58,91,49,44,50,53,93,44,51,53,58,50,52,
         125,44,123,50,49,58,50,57,44,51,51,58,91,49,44,50,53,93,44,51,53,58,50,
         52,125,44,123,49,58,91,50,44,49,93,125,44,123,54,58,51,48,44,56,58,52,44,
         57,58,53,44,49,49,58,54,44,49,50,58,55,44,49,51,58,56,44,49,52,58,91,49,
         44,57,93,44,49,53,58,91,49,44,49,48,93,44,49,54,58,91,49,44,49,50,93,44,
         49,57,58,91,49,44,49,49,93,44,50,50,58,91,49,44,49,51,93,44,50,51,58,91,
         49,44,49,52,93,44,50,52,58,91,49,44,49,53,93,125,44,123,53,58,91,50,44,
         54,93,44,49,52,58,91,50,44,54,93,44,49,53,58,91,50,44,54,93,44,49,54,58,
         91,50,44,54,93,44,49,57,58,91,50,44,54,93,44,50,48,58,91,50,44,54,93,44,
         50,50,58,91,50,44,54,93,44,50,51,58,91,50,44,54,93,44,50,52,58,91,50,44,
         54,93,125,44,123,49,55,58,50,50,44,49,56,58,91,49,44,51,49,93,44,50,49,
         58,50,51,44,51,51,58,91,49,44,50,53,93,44,51,53,58,50,52,125,44,123,49,
         48,58,51,50,44,50,48,58,91,49,44,51,51,93,125,44,123,49,48,58,51,52,44,
         50,48,58,91,49,44,51,51,93,125,44,123,49,56,58,91,49,44,51,53,93,125,44,
         123,49,56,58,91,50,44,50,52,93,44,50,49,58,52,48,44,50,53,58,51,54,44,50,
         54,58,51,55,44,50,55,58,51,56,44,50,56,58,91,49,44,52,49,93,44,50,57,58,
         91,49,44,52,50,93,44,51,48,58,91,49,44,52,51,93,44,51,49,58,51,57,44,51,
         50,58,52,52,44,51,51,58,91,49,44,52,53,93,44,51,53,58,50,52,125,44,123,
         49,56,58,91,50,44,51,56,93,44,50,56,58,91,50,44,51,56,93,44,50,57,58,91,
         50,44,51,56,93,44,51,48,58,91,50,44,51,56,93,44,51,51,58,91,50,44,51,56,
         93,44,51,54,58,91,49,44,52,54,93,125,44,123,49,56,58,91,50,44,52,48,93,
         44,50,56,58,91,50,44,52,48,93,44,50,57,58,91,50,44,52,48,93,44,51,48,58,
         91,50,44,52,48,93,44,51,51,58,91,50,44,52,48,93,44,51,54,58,91,50,44,52,
         48,93,125,44,123,49,56,58,91,49,44,52,55,93,125,44,123,49,56,58,91,49,44,
         52,56,93,125,44,123,49,56,58,91,49,44,52,57,93,125,44,123,49,56,58,91,49,
         44,53,48,93,44,50,49,58,53,49,44,51,51,58,91,49,44,50,53,93,44,51,53,58,
         50,52,125,44,123,53,58,91,50,44,50,93,44,56,58,49,56,44,57,58,53,44,49,
         49,58,54,44,49,50,58,55,44,49,51,58,56,44,49,52,58,91,49,44,57,93,44,49,
         53,58,91,49,44,49,48,93,44,49,54,58,91,49,44,49,50,93,44,49,57,58,91,49,
         44,49,49,93,44,50,48,58,91,50,44,50,93,44,50,50,58,91,49,44,49,51,93,44,
         50,51,58,91,49,44,49,52,93,44,50,52,58,91,49,44,49,53,93,125,44,123,49,
         52,58,91,50,44,50,48,93,44,49,53,58,91,50,44,50,48,93,44,49,54,58,91,50,
         44,50,48,93,44,49,57,58,91,50,44,50,48,93,44,50,50,58,91,50,44,50,48,93,
         44,50,51,58,91,50,44,50,48,93,44,50,52,58,91,50,44,50,48,93,125,44,123,
         53,58,91,50,44,55,93,44,49,52,58,91,50,44,55,93,44,49,53,58,91,50,44,55,
         93,44,49,54,58,91,50,44,55,93,44,49,57,58,91,50,44,55,93,44,50,48,58,91,
         50,44,55,93,44,50,50,58,91,50,44,55,93,44,50,51,58,91,50,44,55,93,44,50,
         52,58,91,50,44,55,93,125,44,123,50,49,58,53,50,44,51,51,58,91,49,44,50,
         53,93,44,51,53,58,50,52,125,44,123,53,58,91,50,44,56,93,44,49,52,58,91,
         50,44,56,93,44,49,53,58,91,50,44,56,93,44,49,54,58,91,50,44,56,93,44,49,
         57,58,91,50,44,56,93,44,50,48,58,91,50,44,56,93,44,50,50,58,91,50,44,56,
         93,44,50,51,58,91,50,44,56,93,44,50,52,58,91,50,44,56,93,125,44,123,49,
         52,58,91,50,44,49,52,93,44,49,53,58,91,50,44,49,52,93,44,49,54,58,91,50,
         44,49,52,93,44,49,57,58,91,50,44,49,52,93,44,50,48,58,91,50,44,49,52,93,
         44,50,50,58,91,50,44,49,52,93,44,50,51,58,91,50,44,49,52,93,44,50,52,58,
         91,50,44,49,52,93,125,44,123,49,56,58,91,50,44,50,50,93,44,50,49,58,52,
         48,44,50,54,58,53,51,44,50,55,58,53,52,44,50,56,58,91,49,44,52,49,93,44,
         50,57,58,91,49,44,52,50,93,44,51,48,58,91,49,44,52,51,93,44,51,49,58,51,
         57,44,51,50,58,52,52,44,51,51,58,91,49,44,52,53,93,44,51,53,58,50,52,125,
         44,123,49,56,58,91,50,44,50,51,93,125,44,123,49,56,58,91,50,44,50,54,93,
         44,50,56,58,91,50,44,50,54,93,44,50,57,58,91,50,44,50,54,93,44,51,48,58,
         91,50,44,50,54,93,44,51,51,58,91,50,44,50,54,93,125,44,123,49,56,58,91,
         50,44,51,49,93,44,51,50,58,53,53,44,51,51,58,91,49,44,53,54,93,125,44,
         123,49,56,58,91,50,44,50,55,93,44,50,56,58,91,50,44,50,55,93,44,50,57,58,
         91,50,44,50,55,93,44,51,48,58,91,50,44,50,55,93,44,51,51,58,91,50,44,50,
         55,93,125,44,123,49,56,58,91,50,44,50,56,93,44,50,56,58,91,50,44,50,56,
         93,44,50,57,58,91,50,44,50,56,93,44,51,48,58,91,50,44,50,56,93,44,51,51,
         58,91,50,44,50,56,93,125,44,123,49,56,58,91,50,44,50,57,93,44,50,56,58,
         91,50,44,50,57,93,44,50,57,58,91,50,44,50,57,93,44,51,48,58,91,50,44,50,
         57,93,44,51,51,58,91,50,44,50,57,93,125,44,123,49,56,58,91,50,44,51,48,
         93,44,50,56,58,91,50,44,51,48,93,44,50,57,58,91,50,44,51,48,93,44,51,48,
         58,91,50,44,51,48,93,44,51,51,58,91,50,44,51,48,93,125,44,123,49,56,58,
         91,50,44,51,51,93,44,51,51,58,91,50,44,51,51,93,125,44,123,49,56,58,91,
         50,44,52,48,93,44,50,56,58,91,50,44,52,48,93,44,50,57,58,91,50,44,52,48,
         93,44,51,48,58,91,50,44,52,48,93,44,51,51,58,91,50,44,52,48,93,44,51,52,
         58,91,49,44,53,55,93,44,51,54,58,91,50,44,52,48,93,125,44,123,51,51,58,
         91,49,44,53,56,93,125,44,123,49,52,58,91,50,44,49,51,93,44,49,53,58,91,
         50,44,49,51,93,44,49,54,58,91,50,44,49,51,93,44,49,57,58,91,50,44,49,51,
         93,44,50,48,58,91,50,44,49,51,93,44,50,50,58,91,50,44,49,51,93,44,50,51,
         58,91,50,44,49,51,93,44,50,52,58,91,50,44,49,51,93,125,44,123,53,58,91,
         50,44,49,54,93,44,49,52,58,91,50,44,49,54,93,44,49,53,58,91,50,44,49,54,
         93,44,49,54,58,91,50,44,49,54,93,44,49,57,58,91,50,44,49,54,93,44,50,48,
         58,91,50,44,49,54,93,44,50,50,58,91,50,44,49,54,93,44,50,51,58,91,50,44,
         49,54,93,44,50,52,58,91,50,44,49,54,93,125,44,123,53,58,91,50,44,49,55,
         93,44,49,52,58,91,50,44,49,55,93,44,49,53,58,91,50,44,49,55,93,44,49,54,
         58,91,50,44,49,55,93,44,49,57,58,91,50,44,49,55,93,44,50,48,58,91,50,44,
         49,55,93,44,50,50,58,91,50,44,49,55,93,44,50,51,58,91,50,44,49,55,93,44,
         50,52,58,91,50,44,49,55,93,125,44,123,53,58,91,50,44,49,56,93,44,49,52,
         58,91,50,44,49,56,93,44,49,53,58,91,50,44,49,56,93,44,49,54,58,91,50,44,
         49,56,93,44,49,57,58,91,50,44,49,56,93,44,50,48,58,91,50,44,49,56,93,44,
         50,50,58,91,50,44,49,56,93,44,50,51,58,91,50,44,49,56,93,44,50,52,58,91,
         50,44,49,56,93,125,44,123,49,56,58,91,49,44,53,57,93,125,44,123,49,56,58,
         91,49,44,54,48,93,125,44,123,49,56,58,91,50,44,50,49,93,125,44,123,49,56,
         58,91,50,44,50,53,93,44,50,56,58,91,50,44,50,53,93,44,50,57,58,91,50,44,
         50,53,93,44,51,48,58,91,50,44,50,53,93,44,51,51,58,91,50,44,50,53,93,125,
         44,123,49,56,58,91,50,44,51,50,93,44,51,51,58,91,50,44,51,50,93,125,44,
         123,51,52,58,91,49,44,53,55,93,125,44,123,50,49,58,54,49,44,50,56,58,91,
         49,44,54,50,93,44,50,57,58,91,49,44,54,51,93,44,51,48,58,91,49,44,54,52,
         93,44,51,51,58,91,49,44,50,53,93,44,51,53,58,50,52,125,44,123,49,56,58,
         91,50,44,51,57,93,44,50,56,58,91,50,44,51,57,93,44,50,57,58,91,50,44,51,
         57,93,44,51,48,58,91,50,44,51,57,93,44,51,51,58,91,50,44,51,57,93,44,51,
         54,58,91,50,44,51,57,93,125,44,123,53,58,91,50,44,49,57,93,44,49,52,58,
         91,50,44,49,57,93,44,49,53,58,91,50,44,49,57,93,44,49,54,58,91,50,44,49,
         57,93,44,49,57,58,91,50,44,49,57,93,44,50,48,58,91,50,44,49,57,93,44,50,
         50,58,91,50,44,49,57,93,44,50,51,58,91,50,44,49,57,93,44,50,52,58,91,50,
         44,49,57,93,125,44,123,53,58,91,50,44,49,53,93,44,49,52,58,91,50,44,49,
         53,93,44,49,53,58,91,50,44,49,53,93,44,49,54,58,91,50,44,49,53,93,44,49,
         57,58,91,50,44,49,53,93,44,50,48,58,91,50,44,49,53,93,44,50,50,58,91,50,
         44,49,53,93,44,50,51,58,91,50,44,49,53,93,44,50,52,58,91,50,44,49,53,93,
         125,44,123,49,56,58,91,50,44,51,52,93,44,51,51,58,91,50,44,51,52,93,125,
         44,123,49,56,58,91,50,44,51,53,93,44,51,51,58,91,50,44,51,53,93,125,44,
         123,49,56,58,91,50,44,51,54,93,44,51,51,58,91,50,44,51,54,93,125,44,123,
         49,56,58,91,50,44,51,55,93,44,51,51,58,91,50,44,51,55,93,125,93,44,10,
         100,101,102,97,117,108,116,65,99,116,105,111,110,115,58,32,123,49,54,58,
         91,50,44,49,93,44,51,55,58,91,50,44,50,51,93,44,53,51,58,91,50,44,50,49,
         93,125,44,10,112,97,114,115,101,69,114,114,111,114,58,32,102,117,110,99,
         116,105,111,110,32,112,97,114,115,101,69,114,114,111,114,40,115,116,114,
         44,32,104,97,115,104,41,32,123,10,32,32,32,32,116,104,114,111,119,32,110,
         101,119,32,69,114,114,111,114,40,115,116,114,41,59,10,125,44,10,112,97,
         114,115,101,58,32,102,117,110,99,116,105,111,110,32,112,97,114,115,101,
         40,105,110,112,117,116,41,32,123,10,32,32,32,32,118,97,114,32,115,101,
         108,102,32,61,32,116,104,105,115,44,10,32,32,32,32,32,32,32,32,115,116,
         97,99,107,32,61,32,91,48,93,44,10,32,32,32,32,32,32,32,32,118,115,116,97,
         99,107,32,61,32,91,110,117,108,108,93,44,32,47,47,32,115,101,109,97,110,
         116,105,99,32,118,97,108,117,101,32,115,116,97,99,107,10,32,32,32,32,32,
         32,32,32,108,115,116,97,99,107,32,61,32,91,93,44,32,47,47,32,108,111,99,
         97,116,105,111,110,32,115,116,97,99,107,10,32,32,32,32,32,32,32,32,116,
         97,98,108,101,32,61,32,116,104,105,115,46,116,97,98,108,101,44,10,32,32,
         32,32,32,32,32,32,121,121,116,101,120,116,32,61,32,39,39,44,10,32,32,32,
         32,32,32,32,32,121,121,108,105,110,101,110,111,32,61,32,48,44,10,32,32,
         32,32,32,32,32,32,121,121,108,101,110,103,32,61,32,48,44,10,32,32,32,32,
         32,32,32,32,114,101,99,111,118,101,114,105,110,103,32,61,32,48,44,10,32,
         32,32,32,32,32,32,32,84,69,82,82,79,82,32,61,32,50,44,10,32,32,32,32,32,
         32,32,32,69,79,70,32,61,32,49,59,10,10,32,32,32,32,47,47,116,104,105,115,
         46,114,101,100,117,99,116,105,111,110,67,111,117,110,116,32,61,32,116,
         104,105,115,46,115,104,105,102,116,67,111,117,110,116,32,61,32,48,59,10,
         10,32,32,32,32,116,104,105,115,46,108,101,120,101,114,46,115,101,116,73,
         110,112,117,116,40,105,110,112,117,116,41,59,10,32,32,32,32,116,104,105,
         115,46,108,101,120,101,114,46,121,121,32,61,32,116,104,105,115,46,121,
         121,59,10,32,32,32,32,116,104,105,115,46,121,121,46,108,101,120,101,114,
         32,61,32,116,104,105,115,46,108,101,120,101,114,59,10,32,32,32,32,105,
         102,32,40,116,121,112,101,111,102,32,116,104,105,115,46,108,101,120,101,
         114,46,121,121,108,108,111,99,32,61,61,32,39,117,110,100,101,102,105,110,
         101,100,39,41,10,32,32,32,32,32,32,32,32,116,104,105,115,46,108,101,120,
         101,114,46,121,121,108,108,111,99,32,61,32,123,125,59,10,32,32,32,32,118,
         97,114,32,121,121,108,111,99,32,61,32,116,104,105,115,46,108,101,120,101,
         114,46,121,121,108,108,111,99,59,10,32,32,32,32,108,115,116,97,99,107,46,
         112,117,115,104,40,121,121,108,111,99,41,59,10,10,32,32,32,32,105,102,32,
         40,116,121,112,101,111,102,32,116,104,105,115,46,121,121,46,112,97,114,
         115,101,69,114,114,111,114,32,61,61,61,32,39,102,117,110,99,116,105,111,
         110,39,41,10,32,32,32,32,32,32,32,32,116,104,105,115,46,112,97,114,115,
         101,69,114,114,111,114,32,61,32,116,104,105,115,46,121,121,46,112,97,114,
         115,101,69,114,114,111,114,59,10,10,32,32,32,32,102,117,110,99,116,105,
         111,110,32,112,111,112,83,116,97,99,107,32,40,110,41,32,123,10,32,32,32,
         32,32,32,32,32,115,116,97,99,107,46,108,101,110,103,116,104,32,61,32,115,
         116,97,99,107,46,108,101,110,103,116,104,32,45,32,50,42,110,59,10,32,32,
         32,32,32,32,32,32,118,115,116,97,99,107,46,108,101,110,103,116,104,32,61,
         32,118,115,116,97,99,107,46,108,101,110,103,116,104,32,45,32,110,59,10,
         32,32,32,32,32,32,32,32,108,115,116,97,99,107,46,108,101,110,103,116,104,
         32,61,32,108,115,116,97,99,107,46,108,101,110,103,116,104,32,45,32,110,
         59,10,32,32,32,32,125,10,10,32,32,32,32,102,117,110,99,116,105,111,110,
         32,108,101,120,40,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,116,
         111,107,101,110,59,10,32,32,32,32,32,32,32,32,116,111,107,101,110,32,61,
         32,115,101,108,102,46,108,101,120,101,114,46,108,101,120,40,41,32,124,
         124,32,49,59,32,47,47,32,36,101,110,100,32,61,32,49,10,32,32,32,32,32,32,
         32,32,47,47,32,105,102,32,116,111,107,101,110,32,105,115,110,39,116,32,
         105,116,115,32,110,117,109,101,114,105,99,32,118,97,108,117,101,44,32,99,
         111,110,118,101,114,116,10,32,32,32,32,32,32,32,32,105,102,32,40,116,121,
         112,101,111,102,32,116,111,107,101,110,32,33,61,61,32,39,110,117,109,98,
         101,114,39,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,116,111,107,
         101,110,32,61,32,115,101,108,102,46,115,121,109,98,111,108,115,95,91,116,
         111,107,101,110,93,32,124,124,32,116,111,107,101,110,59,10,32,32,32,32,
         32,32,32,32,125,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,
         116,111,107,101,110,59,10,32,32,32,32,125,59,10,10,32,32,32,32,118,97,
         114,32,115,121,109,98,111,108,44,32,112,114,101,69,114,114,111,114,83,
         121,109,98,111,108,44,32,115,116,97,116,101,44,32,97,99,116,105,111,110,
         44,32,97,44,32,114,44,32,121,121,118,97,108,61,123,125,44,112,44,108,101,
         110,44,110,101,119,83,116,97,116,101,44,32,101,120,112,101,99,116,101,
         100,59,10,32,32,32,32,119,104,105,108,101,32,40,116,114,117,101,41,32,
         123,10,32,32,32,32,32,32,32,32,47,47,32,114,101,116,114,101,105,118,101,
         32,115,116,97,116,101,32,110,117,109,98,101,114,32,102,114,111,109,32,
         116,111,112,32,111,102,32,115,116,97,99,107,10,32,32,32,32,32,32,32,32,
         115,116,97,116,101,32,61,32,115,116,97,99,107,91,115,116,97,99,107,46,
         108,101,110,103,116,104,45,49,93,59,10,10,32,32,32,32,32,32,32,32,47,47,
         32,117,115,101,32,100,101,102,97,117,108,116,32,97,99,116,105,111,110,
         115,32,105,102,32,97,118,97,105,108,97,98,108,101,10,32,32,32,32,32,32,
         32,32,105,102,32,40,116,104,105,115,46,100,101,102,97,117,108,116,65,99,
         116,105,111,110,115,91,115,116,97,116,101,93,41,32,123,10,32,32,32,32,32,
         32,32,32,32,32,32,32,97,99,116,105,111,110,32,61,32,116,104,105,115,46,
         100,101,102,97,117,108,116,65,99,116,105,111,110,115,91,115,116,97,116,
         101,93,59,10,32,32,32,32,32,32,32,32,125,32,101,108,115,101,32,123,10,32,
         32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,115,121,109,98,111,108,32,
         61,61,32,110,117,108,108,41,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,115,121,109,98,111,108,32,61,32,108,101,120,40,41,59,10,32,32,32,
         32,32,32,32,32,32,32,32,32,47,47,32,114,101,97,100,32,97,99,116,105,111,
         110,32,102,111,114,32,99,117,114,114,101,110,116,32,115,116,97,116,101,
         32,97,110,100,32,102,105,114,115,116,32,105,110,112,117,116,10,32,32,32,
         32,32,32,32,32,32,32,32,32,97,99,116,105,111,110,32,61,32,116,97,98,108,
         101,91,115,116,97,116,101,93,32,38,38,32,116,97,98,108,101,91,115,116,97,
         116,101,93,91,115,121,109,98,111,108,93,59,10,32,32,32,32,32,32,32,32,
         125,10,10,32,32,32,32,32,32,32,32,47,47,32,104,97,110,100,108,101,32,112,
         97,114,115,101,32,101,114,114,111,114,10,32,32,32,32,32,32,32,32,105,102,
         32,40,116,121,112,101,111,102,32,97,99,116,105,111,110,32,61,61,61,32,39,
         117,110,100,101,102,105,110,101,100,39,32,124,124,32,33,97,99,116,105,
         111,110,46,108,101,110,103,116,104,32,124,124,32,33,97,99,116,105,111,
         110,91,48,93,41,32,123,10,10,32,32,32,32,32,32,32,32,32,32,32,32,105,102,
         32,40,33,114,101,99,111,118,101,114,105,110,103,41,32,123,10,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,47,47,32,82,101,112,111,114,116,32,
         101,114,114,111,114,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         101,120,112,101,99,116,101,100,32,61,32,91,93,59,10,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,102,111,114,32,40,112,32,105,110,32,116,97,98,
         108,101,91,115,116,97,116,101,93,41,32,105,102,32,40,116,104,105,115,46,
         116,101,114,109,105,110,97,108,115,95,91,112,93,32,38,38,32,112,32,62,32,
         50,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,101,120,112,101,99,116,101,100,46,112,117,115,104,40,34,39,34,43,116,
         104,105,115,46,116,101,114,109,105,110,97,108,115,95,91,112,93,43,34,39,
         34,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,125,10,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,118,97,114,32,101,114,114,83,
         116,114,32,61,32,39,39,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,105,102,32,40,116,104,105,115,46,108,101,120,101,114,46,115,104,
         111,119,80,111,115,105,116,105,111,110,41,32,123,10,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,101,114,114,83,116,114,32,61,32,
         39,80,97,114,115,101,32,101,114,114,111,114,32,111,110,32,108,105,110,
         101,32,39,43,40,121,121,108,105,110,101,110,111,43,49,41,43,34,58,92,110,
         34,43,116,104,105,115,46,108,101,120,101,114,46,115,104,111,119,80,111,
         115,105,116,105,111,110,40,41,43,39,92,110,69,120,112,101,99,116,105,110,
         103,32,39,43,101,120,112,101,99,116,101,100,46,106,111,105,110,40,39,44,
         32,39,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,125,32,
         101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,101,114,114,83,116,114,32,61,32,39,80,97,114,115,101,32,
         101,114,114,111,114,32,111,110,32,108,105,110,101,32,39,43,40,121,121,
         108,105,110,101,110,111,43,49,41,43,34,58,32,85,110,101,120,112,101,99,
         116,101,100,32,34,32,43,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,40,115,121,109,
         98,111,108,32,61,61,32,49,32,47,42,69,79,70,42,47,32,63,32,34,101,110,
         100,32,111,102,32,105,110,112,117,116,34,32,58,10,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,40,34,39,34,43,40,116,104,
         105,115,46,116,101,114,109,105,110,97,108,115,95,91,115,121,109,98,111,
         108,93,32,124,124,32,115,121,109,98,111,108,41,43,34,39,34,41,41,59,10,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,112,97,114,115,101,69,
         114,114,111,114,40,101,114,114,83,116,114,44,10,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,123,116,101,120,116,58,32,116,104,
         105,115,46,108,101,120,101,114,46,109,97,116,99,104,44,32,116,111,107,
         101,110,58,32,116,104,105,115,46,116,101,114,109,105,110,97,108,115,95,
         91,115,121,109,98,111,108,93,32,124,124,32,115,121,109,98,111,108,44,32,
         108,105,110,101,58,32,116,104,105,115,46,108,101,120,101,114,46,121,121,
         108,105,110,101,110,111,44,32,108,111,99,58,32,121,121,108,111,99,44,32,
         101,120,112,101,99,116,101,100,58,32,101,120,112,101,99,116,101,100,125,
         41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,
         32,32,32,32,32,32,47,47,32,106,117,115,116,32,114,101,99,111,118,101,114,
         101,100,32,102,114,111,109,32,97,110,111,116,104,101,114,32,101,114,114,
         111,114,10,32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,114,101,99,
         111,118,101,114,105,110,103,32,61,61,32,51,41,32,123,10,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,115,121,109,98,111,108,32,
         61,61,32,69,79,70,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,116,104,114,111,119,32,110,101,119,32,69,114,114,111,
         114,40,101,114,114,83,116,114,32,124,124,32,39,80,97,114,115,105,110,103,
         32,104,97,108,116,101,100,46,39,41,59,10,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,47,47,32,100,105,115,99,97,114,100,32,99,117,114,114,101,110,116,32,
         108,111,111,107,97,104,101,97,100,32,97,110,100,32,103,114,97,98,32,97,
         110,111,116,104,101,114,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,121,121,108,101,110,103,32,61,32,116,104,105,115,46,108,101,120,101,
         114,46,121,121,108,101,110,103,59,10,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,121,121,116,101,120,116,32,61,32,116,104,105,115,46,108,101,
         120,101,114,46,121,121,116,101,120,116,59,10,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,121,121,108,105,110,101,110,111,32,61,32,116,104,
         105,115,46,108,101,120,101,114,46,121,121,108,105,110,101,110,111,59,10,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,121,121,108,111,99,32,61,
         32,116,104,105,115,46,108,101,120,101,114,46,121,121,108,108,111,99,59,
         10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,121,109,98,111,
         108,32,61,32,108,101,120,40,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,
         125,10,10,32,32,32,32,32,32,32,32,32,32,32,32,47,47,32,116,114,121,32,
         116,111,32,114,101,99,111,118,101,114,32,102,114,111,109,32,101,114,114,
         111,114,10,32,32,32,32,32,32,32,32,32,32,32,32,119,104,105,108,101,32,40,
         49,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,47,47,32,
         99,104,101,99,107,32,102,111,114,32,101,114,114,111,114,32,114,101,99,
         111,118,101,114,121,32,114,117,108,101,32,105,110,32,116,104,105,115,32,
         115,116,97,116,101,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         105,102,32,40,40,84,69,82,82,79,82,46,116,111,83,116,114,105,110,103,40,
         41,41,32,105,110,32,116,97,98,108,101,91,115,116,97,116,101,93,41,32,123,
         10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,98,114,
         101,97,107,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,125,10,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,115,116,97,
         116,101,32,61,61,32,48,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,116,104,114,111,119,32,110,101,119,32,69,114,114,
         111,114,40,101,114,114,83,116,114,32,124,124,32,39,80,97,114,115,105,110,
         103,32,104,97,108,116,101,100,46,39,41,59,10,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,112,111,112,83,116,97,99,107,40,49,41,59,10,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,115,116,97,116,101,32,61,32,115,116,97,99,107,91,
         115,116,97,99,107,46,108,101,110,103,116,104,45,49,93,59,10,32,32,32,32,
         32,32,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,32,32,32,32,32,32,
         112,114,101,69,114,114,111,114,83,121,109,98,111,108,32,61,32,115,121,
         109,98,111,108,59,32,47,47,32,115,97,118,101,32,116,104,101,32,108,111,
         111,107,97,104,101,97,100,32,116,111,107,101,110,10,32,32,32,32,32,32,32,
         32,32,32,32,32,115,121,109,98,111,108,32,61,32,84,69,82,82,79,82,59,32,
         32,32,32,32,32,32,32,32,47,47,32,105,110,115,101,114,116,32,103,101,110,
         101,114,105,99,32,101,114,114,111,114,32,115,121,109,98,111,108,32,97,
         115,32,110,101,119,32,108,111,111,107,97,104,101,97,100,10,32,32,32,32,
         32,32,32,32,32,32,32,32,115,116,97,116,101,32,61,32,115,116,97,99,107,91,
         115,116,97,99,107,46,108,101,110,103,116,104,45,49,93,59,10,32,32,32,32,
         32,32,32,32,32,32,32,32,97,99,116,105,111,110,32,61,32,116,97,98,108,101,
         91,115,116,97,116,101,93,32,38,38,32,116,97,98,108,101,91,115,116,97,116,
         101,93,91,84,69,82,82,79,82,93,59,10,32,32,32,32,32,32,32,32,32,32,32,32,
         114,101,99,111,118,101,114,105,110,103,32,61,32,51,59,32,47,47,32,97,108,
         108,111,119,32,51,32,114,101,97,108,32,115,121,109,98,111,108,115,32,116,
         111,32,98,101,32,115,104,105,102,116,101,100,32,98,101,102,111,114,101,
         32,114,101,112,111,114,116,105,110,103,32,97,32,110,101,119,32,101,114,
         114,111,114,10,32,32,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,32,32,
         47,47,32,116,104,105,115,32,115,104,111,117,108,100,110,39,116,32,104,97,
         112,112,101,110,44,32,117,110,108,101,115,115,32,114,101,115,111,108,118,
         101,32,100,101,102,97,117,108,116,115,32,97,114,101,32,111,102,102,10,32,
         32,32,32,32,32,32,32,105,102,32,40,97,99,116,105,111,110,91,48,93,32,105,
         110,115,116,97,110,99,101,111,102,32,65,114,114,97,121,32,38,38,32,97,99,
         116,105,111,110,46,108,101,110,103,116,104,32,62,32,49,41,32,123,10,32,
         32,32,32,32,32,32,32,32,32,32,32,116,104,114,111,119,32,110,101,119,32,
         69,114,114,111,114,40,39,80,97,114,115,101,32,69,114,114,111,114,58,32,
         109,117,108,116,105,112,108,101,32,97,99,116,105,111,110,115,32,112,111,
         115,115,105,98,108,101,32,97,116,32,115,116,97,116,101,58,32,39,43,115,
         116,97,116,101,43,39,44,32,116,111,107,101,110,58,32,39,43,115,121,109,
         98,111,108,41,59,10,32,32,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,
         32,32,115,119,105,116,99,104,32,40,97,99,116,105,111,110,91,48,93,41,32,
         123,10,10,32,32,32,32,32,32,32,32,32,32,32,32,99,97,115,101,32,49,58,32,
         47,47,32,115,104,105,102,116,10,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,47,47,116,104,105,115,46,115,104,105,102,116,67,111,117,110,116,
         43,43,59,10,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,116,
         97,99,107,46,112,117,115,104,40,115,121,109,98,111,108,41,59,10,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,118,115,116,97,99,107,46,112,117,
         115,104,40,116,104,105,115,46,108,101,120,101,114,46,121,121,116,101,120,
         116,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,115,116,
         97,99,107,46,112,117,115,104,40,116,104,105,115,46,108,101,120,101,114,
         46,121,121,108,108,111,99,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,115,116,97,99,107,46,112,117,115,104,40,97,99,116,105,111,
         110,91,49,93,41,59,32,47,47,32,112,117,115,104,32,115,116,97,116,101,10,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,121,109,98,111,108,
         32,61,32,110,117,108,108,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,105,102,32,40,33,112,114,101,69,114,114,111,114,83,121,109,98,111,
         108,41,32,123,32,47,47,32,110,111,114,109,97,108,32,101,120,101,99,117,
         116,105,111,110,47,110,111,32,101,114,114,111,114,10,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,121,121,108,101,110,103,32,61,
         32,116,104,105,115,46,108,101,120,101,114,46,121,121,108,101,110,103,59,
         10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,121,121,
         116,101,120,116,32,61,32,116,104,105,115,46,108,101,120,101,114,46,121,
         121,116,101,120,116,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,121,121,108,105,110,101,110,111,32,61,32,116,104,105,115,
         46,108,101,120,101,114,46,121,121,108,105,110,101,110,111,59,10,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,121,121,108,111,99,32,
         61,32,116,104,105,115,46,108,101,120,101,114,46,121,121,108,108,111,99,
         59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,105,
         102,32,40,114,101,99,111,118,101,114,105,110,103,32,62,32,48,41,10,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,114,
         101,99,111,118,101,114,105,110,103,45,45,59,10,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,125,32,101,108,115,101,32,123,32,47,47,32,101,
         114,114,111,114,32,106,117,115,116,32,111,99,99,117,114,114,101,100,44,
         32,114,101,115,117,109,101,32,111,108,100,32,108,111,111,107,97,104,101,
         97,100,32,102,47,32,98,101,102,111,114,101,32,101,114,114,111,114,10,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,121,109,98,
         111,108,32,61,32,112,114,101,69,114,114,111,114,83,121,109,98,111,108,59,
         10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,112,114,
         101,69,114,114,111,114,83,121,109,98,111,108,32,61,32,110,117,108,108,59,
         10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,98,114,101,97,107,59,10,10,32,32,32,32,
         32,32,32,32,32,32,32,32,99,97,115,101,32,50,58,32,47,47,32,114,101,100,
         117,99,101,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,47,47,116,
         104,105,115,46,114,101,100,117,99,116,105,111,110,67,111,117,110,116,43,
         43,59,10,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,101,110,
         32,61,32,116,104,105,115,46,112,114,111,100,117,99,116,105,111,110,115,
         95,91,97,99,116,105,111,110,91,49,93,93,91,49,93,59,10,10,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,47,47,32,112,101,114,102,111,114,109,32,
         115,101,109,97,110,116,105,99,32,97,99,116,105,111,110,10,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,121,121,118,97,108,46,36,32,61,32,118,
         115,116,97,99,107,91,118,115,116,97,99,107,46,108,101,110,103,116,104,45,
         108,101,110,93,59,32,47,47,32,100,101,102,97,117,108,116,32,116,111,32,
         36,36,32,61,32,36,49,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         47,47,32,100,101,102,97,117,108,116,32,108,111,99,97,116,105,111,110,44,
         32,117,115,101,115,32,102,105,114,115,116,32,116,111,107,101,110,32,102,
         111,114,32,102,105,114,115,116,115,44,32,108,97,115,116,32,102,111,114,
         32,108,97,115,116,115,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         121,121,118,97,108,46,95,36,32,61,32,123,10,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,102,105,114,115,116,95,108,105,110,101,
         58,32,108,115,116,97,99,107,91,108,115,116,97,99,107,46,108,101,110,103,
         116,104,45,40,108,101,110,124,124,49,41,93,46,102,105,114,115,116,95,108,
         105,110,101,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,108,97,115,116,95,108,105,110,101,58,32,108,115,116,97,99,107,91,
         108,115,116,97,99,107,46,108,101,110,103,116,104,45,49,93,46,108,97,115,
         116,95,108,105,110,101,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,102,105,114,115,116,95,99,111,108,117,109,110,58,32,
         108,115,116,97,99,107,91,108,115,116,97,99,107,46,108,101,110,103,116,
         104,45,40,108,101,110,124,124,49,41,93,46,102,105,114,115,116,95,99,111,
         108,117,109,110,44,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,108,97,115,116,95,99,111,108,117,109,110,58,32,108,115,116,97,
         99,107,91,108,115,116,97,99,107,46,108,101,110,103,116,104,45,49,93,46,
         108,97,115,116,95,99,111,108,117,109,110,10,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,125,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,114,32,61,32,116,104,105,115,46,112,101,114,102,111,114,109,65,99,
         116,105,111,110,46,99,97,108,108,40,121,121,118,97,108,44,32,121,121,116,
         101,120,116,44,32,121,121,108,101,110,103,44,32,121,121,108,105,110,101,
         110,111,44,32,116,104,105,115,46,121,121,44,32,97,99,116,105,111,110,91,
         49,93,44,32,118,115,116,97,99,107,44,32,108,115,116,97,99,107,41,59,10,
         10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,116,121,
         112,101,111,102,32,114,32,33,61,61,32,39,117,110,100,101,102,105,110,101,
         100,39,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,114,101,116,117,114,110,32,114,59,10,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,47,47,32,112,111,112,32,111,102,102,32,115,116,97,99,107,10,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,108,101,110,41,
         32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         115,116,97,99,107,32,61,32,115,116,97,99,107,46,115,108,105,99,101,40,48,
         44,45,49,42,108,101,110,42,50,41,59,10,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,118,115,116,97,99,107,32,61,32,118,115,116,97,
         99,107,46,115,108,105,99,101,40,48,44,32,45,49,42,108,101,110,41,59,10,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,108,115,116,
         97,99,107,32,61,32,108,115,116,97,99,107,46,115,108,105,99,101,40,48,44,
         32,45,49,42,108,101,110,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,125,10,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,115,
         116,97,99,107,46,112,117,115,104,40,116,104,105,115,46,112,114,111,100,
         117,99,116,105,111,110,115,95,91,97,99,116,105,111,110,91,49,93,93,91,48,
         93,41,59,32,32,32,32,47,47,32,112,117,115,104,32,110,111,110,116,101,114,
         109,105,110,97,108,32,40,114,101,100,117,99,101,41,10,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,118,115,116,97,99,107,46,112,117,115,104,
         40,121,121,118,97,108,46,36,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,108,115,116,97,99,107,46,112,117,115,104,40,121,121,118,97,
         108,46,95,36,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,47,
         47,32,103,111,116,111,32,110,101,119,32,115,116,97,116,101,32,61,32,116,
         97,98,108,101,91,83,84,65,84,69,93,91,78,79,78,84,69,82,77,73,78,65,76,
         93,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,110,101,119,83,116,
         97,116,101,32,61,32,116,97,98,108,101,91,115,116,97,99,107,91,115,116,97,
         99,107,46,108,101,110,103,116,104,45,50,93,93,91,115,116,97,99,107,91,
         115,116,97,99,107,46,108,101,110,103,116,104,45,49,93,93,59,10,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,115,116,97,99,107,46,112,117,115,
         104,40,110,101,119,83,116,97,116,101,41,59,10,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,98,114,101,97,107,59,10,10,32,32,32,32,32,32,32,32,
         32,32,32,32,99,97,115,101,32,51,58,32,47,47,32,97,99,99,101,112,116,10,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,117,114,110,
         32,116,114,117,101,59,10,32,32,32,32,32,32,32,32,125,10,10,32,32,32,32,
         125,10,10,32,32,32,32,114,101,116,117,114,110,32,116,114,117,101,59,10,
         125,125,59,47,42,32,74,105,115,111,110,32,103,101,110,101,114,97,116,101,
         100,32,108,101,120,101,114,32,42,47,10,118,97,114,32,108,101,120,101,114,
         32,61,32,40,102,117,110,99,116,105,111,110,40,41,123,10,10,118,97,114,32,
         108,101,120,101,114,32,61,32,40,123,69,79,70,58,49,44,10,112,97,114,115,
         101,69,114,114,111,114,58,102,117,110,99,116,105,111,110,32,112,97,114,
         115,101,69,114,114,111,114,40,115,116,114,44,32,104,97,115,104,41,32,123,
         10,32,32,32,32,32,32,32,32,105,102,32,40,116,104,105,115,46,121,121,46,
         112,97,114,115,101,69,114,114,111,114,41,32,123,10,32,32,32,32,32,32,32,
         32,32,32,32,32,116,104,105,115,46,121,121,46,112,97,114,115,101,69,114,
         114,111,114,40,115,116,114,44,32,104,97,115,104,41,59,10,32,32,32,32,32,
         32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,32,32,
         32,32,116,104,114,111,119,32,110,101,119,32,69,114,114,111,114,40,115,
         116,114,41,59,10,32,32,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,
         115,101,116,73,110,112,117,116,58,102,117,110,99,116,105,111,110,32,40,
         105,110,112,117,116,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,
         46,95,105,110,112,117,116,32,61,32,105,110,112,117,116,59,10,32,32,32,32,
         32,32,32,32,116,104,105,115,46,95,109,111,114,101,32,61,32,116,104,105,
         115,46,95,108,101,115,115,32,61,32,116,104,105,115,46,100,111,110,101,32,
         61,32,102,97,108,115,101,59,10,32,32,32,32,32,32,32,32,116,104,105,115,
         46,121,121,108,105,110,101,110,111,32,61,32,116,104,105,115,46,121,121,
         108,101,110,103,32,61,32,48,59,10,32,32,32,32,32,32,32,32,116,104,105,
         115,46,121,121,116,101,120,116,32,61,32,116,104,105,115,46,109,97,116,99,
         104,101,100,32,61,32,116,104,105,115,46,109,97,116,99,104,32,61,32,39,39,
         59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,100,105,116,
         105,111,110,83,116,97,99,107,32,61,32,91,39,73,78,73,84,73,65,76,39,93,
         59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,121,121,108,108,111,99,
         32,61,32,123,102,105,114,115,116,95,108,105,110,101,58,49,44,102,105,114,
         115,116,95,99,111,108,117,109,110,58,48,44,108,97,115,116,95,108,105,110,
         101,58,49,44,108,97,115,116,95,99,111,108,117,109,110,58,48,125,59,10,32,
         32,32,32,32,32,32,32,114,101,116,117,114,110,32,116,104,105,115,59,10,32,
         32,32,32,125,44,10,105,110,112,117,116,58,102,117,110,99,116,105,111,110,
         32,40,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,99,104,32,61,32,
         116,104,105,115,46,95,105,110,112,117,116,91,48,93,59,10,32,32,32,32,32,
         32,32,32,116,104,105,115,46,121,121,116,101,120,116,43,61,99,104,59,10,
         32,32,32,32,32,32,32,32,116,104,105,115,46,121,121,108,101,110,103,43,43,
         59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,109,97,116,99,104,43,61,
         99,104,59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,109,97,116,99,
         104,101,100,43,61,99,104,59,10,32,32,32,32,32,32,32,32,118,97,114,32,108,
         105,110,101,115,32,61,32,99,104,46,109,97,116,99,104,40,47,92,110,47,41,
         59,10,32,32,32,32,32,32,32,32,105,102,32,40,108,105,110,101,115,41,32,
         116,104,105,115,46,121,121,108,105,110,101,110,111,43,43,59,10,32,32,32,
         32,32,32,32,32,116,104,105,115,46,95,105,110,112,117,116,32,61,32,116,
         104,105,115,46,95,105,110,112,117,116,46,115,108,105,99,101,40,49,41,59,
         10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,99,104,59,10,32,32,
         32,32,125,44,10,117,110,112,117,116,58,102,117,110,99,116,105,111,110,32,
         40,99,104,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,95,105,
         110,112,117,116,32,61,32,99,104,32,43,32,116,104,105,115,46,95,105,110,
         112,117,116,59,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,116,
         104,105,115,59,10,32,32,32,32,125,44,10,109,111,114,101,58,102,117,110,
         99,116,105,111,110,32,40,41,32,123,10,32,32,32,32,32,32,32,32,116,104,
         105,115,46,95,109,111,114,101,32,61,32,116,114,117,101,59,10,32,32,32,32,
         32,32,32,32,114,101,116,117,114,110,32,116,104,105,115,59,10,32,32,32,32,
         125,44,10,112,97,115,116,73,110,112,117,116,58,102,117,110,99,116,105,
         111,110,32,40,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,112,97,
         115,116,32,61,32,116,104,105,115,46,109,97,116,99,104,101,100,46,115,117,
         98,115,116,114,40,48,44,32,116,104,105,115,46,109,97,116,99,104,101,100,
         46,108,101,110,103,116,104,32,45,32,116,104,105,115,46,109,97,116,99,104,
         46,108,101,110,103,116,104,41,59,10,32,32,32,32,32,32,32,32,114,101,116,
         117,114,110,32,40,112,97,115,116,46,108,101,110,103,116,104,32,62,32,50,
         48,32,63,32,39,46,46,46,39,58,39,39,41,32,43,32,112,97,115,116,46,115,
         117,98,115,116,114,40,45,50,48,41,46,114,101,112,108,97,99,101,40,47,92,
         110,47,103,44,32,34,34,41,59,10,32,32,32,32,125,44,10,117,112,99,111,109,
         105,110,103,73,110,112,117,116,58,102,117,110,99,116,105,111,110,32,40,
         41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,110,101,120,116,32,61,
         32,116,104,105,115,46,109,97,116,99,104,59,10,32,32,32,32,32,32,32,32,
         105,102,32,40,110,101,120,116,46,108,101,110,103,116,104,32,60,32,50,48,
         41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,110,101,120,116,32,43,
         61,32,116,104,105,115,46,95,105,110,112,117,116,46,115,117,98,115,116,
         114,40,48,44,32,50,48,45,110,101,120,116,46,108,101,110,103,116,104,41,
         59,10,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,114,101,116,
         117,114,110,32,40,110,101,120,116,46,115,117,98,115,116,114,40,48,44,50,
         48,41,43,40,110,101,120,116,46,108,101,110,103,116,104,32,62,32,50,48,32,
         63,32,39,46,46,46,39,58,39,39,41,41,46,114,101,112,108,97,99,101,40,47,
         92,110,47,103,44,32,34,34,41,59,10,32,32,32,32,125,44,10,115,104,111,119,
         80,111,115,105,116,105,111,110,58,102,117,110,99,116,105,111,110,32,40,
         41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,112,114,101,32,61,32,
         116,104,105,115,46,112,97,115,116,73,110,112,117,116,40,41,59,10,32,32,
         32,32,32,32,32,32,118,97,114,32,99,32,61,32,110,101,119,32,65,114,114,97,
         121,40,112,114,101,46,108,101,110,103,116,104,32,43,32,49,41,46,106,111,
         105,110,40,34,45,34,41,59,10,32,32,32,32,32,32,32,32,114,101,116,117,114,
         110,32,112,114,101,32,43,32,116,104,105,115,46,117,112,99,111,109,105,
         110,103,73,110,112,117,116,40,41,32,43,32,34,92,110,34,32,43,32,99,43,34,
         94,34,59,10,32,32,32,32,125,44,10,110,101,120,116,58,102,117,110,99,116,
         105,111,110,32,40,41,32,123,10,32,32,32,32,32,32,32,32,105,102,32,40,116,
         104,105,115,46,100,111,110,101,41,32,123,10,32,32,32,32,32,32,32,32,32,
         32,32,32,114,101,116,117,114,110,32,116,104,105,115,46,69,79,70,59,10,32,
         32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,105,102,32,40,33,116,
         104,105,115,46,95,105,110,112,117,116,41,32,116,104,105,115,46,100,111,
         110,101,32,61,32,116,114,117,101,59,10,10,32,32,32,32,32,32,32,32,118,97,
         114,32,116,111,107,101,110,44,10,32,32,32,32,32,32,32,32,32,32,32,32,109,
         97,116,99,104,44,10,32,32,32,32,32,32,32,32,32,32,32,32,99,111,108,44,10,
         32,32,32,32,32,32,32,32,32,32,32,32,108,105,110,101,115,59,10,32,32,32,
         32,32,32,32,32,105,102,32,40,33,116,104,105,115,46,95,109,111,114,101,41,
         32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,121,121,
         116,101,120,116,32,61,32,39,39,59,10,32,32,32,32,32,32,32,32,32,32,32,32,
         116,104,105,115,46,109,97,116,99,104,32,61,32,39,39,59,10,32,32,32,32,32,
         32,32,32,125,10,32,32,32,32,32,32,32,32,118,97,114,32,114,117,108,101,
         115,32,61,32,116,104,105,115,46,95,99,117,114,114,101,110,116,82,117,108,
         101,115,40,41,59,10,32,32,32,32,32,32,32,32,102,111,114,32,40,118,97,114,
         32,105,61,48,59,105,32,60,32,114,117,108,101,115,46,108,101,110,103,116,
         104,59,32,105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,109,
         97,116,99,104,32,61,32,116,104,105,115,46,95,105,110,112,117,116,46,109,
         97,116,99,104,40,116,104,105,115,46,114,117,108,101,115,91,114,117,108,
         101,115,91,105,93,93,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,105,
         102,32,40,109,97,116,99,104,41,32,123,10,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,108,105,110,101,115,32,61,32,109,97,116,99,104,91,48,
         93,46,109,97,116,99,104,40,47,92,110,46,42,47,103,41,59,10,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,105,102,32,40,108,105,110,101,115,41,
         32,116,104,105,115,46,121,121,108,105,110,101,110,111,32,43,61,32,108,
         105,110,101,115,46,108,101,110,103,116,104,59,10,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,116,104,105,115,46,121,121,108,108,111,99,32,61,
         32,123,102,105,114,115,116,95,108,105,110,101,58,32,116,104,105,115,46,
         121,121,108,108,111,99,46,108,97,115,116,95,108,105,110,101,44,10,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,108,97,115,116,95,108,105,110,101,58,32,116,104,105,115,
         46,121,121,108,105,110,101,110,111,43,49,44,10,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,102,
         105,114,115,116,95,99,111,108,117,109,110,58,32,116,104,105,115,46,121,
         121,108,108,111,99,46,108,97,115,116,95,99,111,108,117,109,110,44,10,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,108,97,115,116,95,99,111,108,117,109,110,58,32,108,105,
         110,101,115,32,63,32,108,105,110,101,115,91,108,105,110,101,115,46,108,
         101,110,103,116,104,45,49,93,46,108,101,110,103,116,104,45,49,32,58,32,
         116,104,105,115,46,121,121,108,108,111,99,46,108,97,115,116,95,99,111,
         108,117,109,110,32,43,32,109,97,116,99,104,91,48,93,46,108,101,110,103,
         116,104,125,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,104,
         105,115,46,121,121,116,101,120,116,32,43,61,32,109,97,116,99,104,91,48,
         93,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,104,105,115,
         46,109,97,116,99,104,32,43,61,32,109,97,116,99,104,91,48,93,59,10,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,109,97,116,
         99,104,101,115,32,61,32,109,97,116,99,104,59,10,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,116,104,105,115,46,121,121,108,101,110,103,32,61,
         32,116,104,105,115,46,121,121,116,101,120,116,46,108,101,110,103,116,104,
         59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,
         95,109,111,114,101,32,61,32,102,97,108,115,101,59,10,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,95,105,110,112,117,116,
         32,61,32,116,104,105,115,46,95,105,110,112,117,116,46,115,108,105,99,101,
         40,109,97,116,99,104,91,48,93,46,108,101,110,103,116,104,41,59,10,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,109,97,116,
         99,104,101,100,32,43,61,32,109,97,116,99,104,91,48,93,59,10,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,116,111,107,101,110,32,61,32,116,104,
         105,115,46,112,101,114,102,111,114,109,65,99,116,105,111,110,46,99,97,
         108,108,40,116,104,105,115,44,32,116,104,105,115,46,121,121,44,32,116,
         104,105,115,44,32,114,117,108,101,115,91,105,93,44,116,104,105,115,46,99,
         111,110,100,105,116,105,111,110,83,116,97,99,107,91,116,104,105,115,46,
         99,111,110,100,105,116,105,111,110,83,116,97,99,107,46,108,101,110,103,
         116,104,45,49,93,41,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,105,102,32,40,116,111,107,101,110,41,32,114,101,116,117,114,110,32,
         116,111,107,101,110,59,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,101,108,115,101,32,114,101,116,117,114,110,59,10,32,32,32,32,32,32,32,
         32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,
         32,32,105,102,32,40,116,104,105,115,46,95,105,110,112,117,116,32,61,61,
         61,32,34,34,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,114,101,116,
         117,114,110,32,116,104,105,115,46,69,79,70,59,10,32,32,32,32,32,32,32,32,
         125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,116,
         104,105,115,46,112,97,114,115,101,69,114,114,111,114,40,39,76,101,120,
         105,99,97,108,32,101,114,114,111,114,32,111,110,32,108,105,110,101,32,39,
         43,40,116,104,105,115,46,121,121,108,105,110,101,110,111,43,49,41,43,39,
         46,32,85,110,114,101,99,111,103,110,105,122,101,100,32,116,101,120,116,
         46,92,110,39,43,116,104,105,115,46,115,104,111,119,80,111,115,105,116,
         105,111,110,40,41,44,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,123,116,101,120,116,58,32,34,34,44,32,116,111,107,101,110,
         58,32,110,117,108,108,44,32,108,105,110,101,58,32,116,104,105,115,46,121,
         121,108,105,110,101,110,111,125,41,59,10,32,32,32,32,32,32,32,32,125,10,
         32,32,32,32,125,44,10,108,101,120,58,102,117,110,99,116,105,111,110,32,
         108,101,120,40,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,114,32,
         61,32,116,104,105,115,46,110,101,120,116,40,41,59,10,32,32,32,32,32,32,
         32,32,105,102,32,40,116,121,112,101,111,102,32,114,32,33,61,61,32,39,117,
         110,100,101,102,105,110,101,100,39,41,32,123,10,32,32,32,32,32,32,32,32,
         32,32,32,32,114,101,116,117,114,110,32,114,59,10,32,32,32,32,32,32,32,32,
         125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,114,
         101,116,117,114,110,32,116,104,105,115,46,108,101,120,40,41,59,10,32,32,
         32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,98,101,103,105,110,58,102,
         117,110,99,116,105,111,110,32,98,101,103,105,110,40,99,111,110,100,105,
         116,105,111,110,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,
         99,111,110,100,105,116,105,111,110,83,116,97,99,107,46,112,117,115,104,
         40,99,111,110,100,105,116,105,111,110,41,59,10,32,32,32,32,125,44,10,112,
         111,112,83,116,97,116,101,58,102,117,110,99,116,105,111,110,32,112,111,
         112,83,116,97,116,101,40,41,32,123,10,32,32,32,32,32,32,32,32,114,101,
         116,117,114,110,32,116,104,105,115,46,99,111,110,100,105,116,105,111,110,
         83,116,97,99,107,46,112,111,112,40,41,59,10,32,32,32,32,125,44,10,95,99,
         117,114,114,101,110,116,82,117,108,101,115,58,102,117,110,99,116,105,111,
         110,32,95,99,117,114,114,101,110,116,82,117,108,101,115,40,41,32,123,10,
         32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,116,104,105,115,46,99,
         111,110,100,105,116,105,111,110,115,91,116,104,105,115,46,99,111,110,100,
         105,116,105,111,110,83,116,97,99,107,91,116,104,105,115,46,99,111,110,
         100,105,116,105,111,110,83,116,97,99,107,46,108,101,110,103,116,104,45,
         49,93,93,46,114,117,108,101,115,59,10,32,32,32,32,125,125,41,59,10,108,
         101,120,101,114,46,112,101,114,102,111,114,109,65,99,116,105,111,110,32,
         61,32,102,117,110,99,116,105,111,110,32,97,110,111,110,121,109,111,117,
         115,40,121,121,44,121,121,95,44,36,97,118,111,105,100,105,110,103,95,110,
         97,109,101,95,99,111,108,108,105,115,105,111,110,115,44,89,89,95,83,84,
         65,82,84,41,32,123,10,10,118,97,114,32,89,89,83,84,65,84,69,61,89,89,95,
         83,84,65,82,84,10,115,119,105,116,99,104,40,36,97,118,111,105,100,105,
         110,103,95,110,97,109,101,95,99,111,108,108,105,115,105,111,110,115,41,
         32,123,10,99,97,115,101,32,48,58,32,116,104,105,115,46,98,101,103,105,
         110,40,34,109,117,34,41,59,32,105,102,32,40,121,121,95,46,121,121,116,
         101,120,116,41,32,114,101,116,117,114,110,32,49,52,59,32,10,98,114,101,
         97,107,59,10,99,97,115,101,32,49,58,32,114,101,116,117,114,110,32,49,52,
         59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,50,58,32,114,101,116,
         117,114,110,32,50,52,59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,
         51,58,32,114,101,116,117,114,110,32,49,54,59,32,10,98,114,101,97,107,59,
         10,99,97,115,101,32,52,58,32,114,101,116,117,114,110,32,50,48,59,32,10,
         98,114,101,97,107,59,10,99,97,115,101,32,53,58,32,114,101,116,117,114,
         110,32,49,57,59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,54,58,32,
         114,101,116,117,114,110,32,49,57,59,32,10,98,114,101,97,107,59,10,99,97,
         115,101,32,55,58,32,114,101,116,117,114,110,32,50,51,59,32,10,98,114,101,
         97,107,59,10,99,97,115,101,32,56,58,32,114,101,116,117,114,110,32,50,51,
         59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,57,58,32,121,121,95,46,
         121,121,116,101,120,116,32,61,32,121,121,95,46,121,121,116,101,120,116,
         46,115,117,98,115,116,114,40,51,44,121,121,95,46,121,121,108,101,110,103,
         45,53,41,59,32,116,104,105,115,46,98,101,103,105,110,40,34,73,78,73,84,
         73,65,76,34,41,59,32,114,101,116,117,114,110,32,49,53,59,32,10,98,114,
         101,97,107,59,10,99,97,115,101,32,49,48,58,32,114,101,116,117,114,110,32,
         50,50,59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,49,58,32,114,
         101,116,117,114,110,32,51,52,59,32,10,98,114,101,97,107,59,10,99,97,115,
         101,32,49,50,58,32,114,101,116,117,114,110,32,51,51,59,32,10,98,114,101,
         97,107,59,10,99,97,115,101,32,49,51,58,32,114,101,116,117,114,110,32,51,
         51,59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,52,58,32,114,101,
         116,117,114,110,32,51,54,59,32,10,98,114,101,97,107,59,10,99,97,115,101,
         32,49,53,58,32,47,42,105,103,110,111,114,101,32,119,104,105,116,101,115,
         112,97,99,101,42,47,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,54,
         58,32,116,104,105,115,46,98,101,103,105,110,40,34,73,78,73,84,73,65,76,
         34,41,59,32,114,101,116,117,114,110,32,49,56,59,32,10,98,114,101,97,107,
         59,10,99,97,115,101,32,49,55,58,32,116,104,105,115,46,98,101,103,105,110,
         40,34,73,78,73,84,73,65,76,34,41,59,32,114,101,116,117,114,110,32,49,56,
         59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,49,56,58,32,121,121,95,
         46,121,121,116,101,120,116,32,61,32,121,121,95,46,121,121,116,101,120,
         116,46,115,117,98,115,116,114,40,49,44,121,121,95,46,121,121,108,101,110,
         103,45,50,41,46,114,101,112,108,97,99,101,40,47,92,92,34,47,103,44,39,34,
         39,41,59,32,114,101,116,117,114,110,32,50,56,59,32,10,98,114,101,97,107,
         59,10,99,97,115,101,32,49,57,58,32,114,101,116,117,114,110,32,51,48,59,
         32,10,98,114,101,97,107,59,10,99,97,115,101,32,50,48,58,32,114,101,116,
         117,114,110,32,51,48,59,32,10,98,114,101,97,107,59,10,99,97,115,101,32,
         50,49,58,32,114,101,116,117,114,110,32,50,57,59,32,10,98,114,101,97,107,
         59,10,99,97,115,101,32,50,50,58,32,114,101,116,117,114,110,32,51,51,59,
         32,10,98,114,101,97,107,59,10,99,97,115,101,32,50,51,58,32,121,121,95,46,
         121,121,116,101,120,116,32,61,32,121,121,95,46,121,121,116,101,120,116,
         46,115,117,98,115,116,114,40,49,44,32,121,121,95,46,121,121,108,101,110,
         103,45,50,41,59,32,114,101,116,117,114,110,32,51,51,59,32,10,98,114,101,
         97,107,59,10,99,97,115,101,32,50,52,58,32,114,101,116,117,114,110,32,39,
         73,78,86,65,76,73,68,39,59,32,10,98,114,101,97,107,59,10,99,97,115,101,
         32,50,53,58,32,114,101,116,117,114,110,32,53,59,32,10,98,114,101,97,107,
         59,10,125,10,125,59,10,108,101,120,101,114,46,114,117,108,101,115,32,61,
         32,91,47,94,91,94,92,120,48,48,93,42,63,40,63,61,40,92,123,92,123,41,41,
         47,44,47,94,91,94,92,120,48,48,93,43,47,44,47,94,92,123,92,123,62,47,44,
         47,94,92,123,92,123,35,47,44,47,94,92,123,92,123,92,47,47,44,47,94,92,
         123,92,123,92,94,47,44,47,94,92,123,92,123,92,115,42,101,108,115,101,92,
         98,47,44,47,94,92,123,92,123,92,123,47,44,47,94,92,123,92,123,38,47,44,
         47,94,92,123,92,123,33,91,92,115,92,83,93,42,63,92,125,92,125,47,44,47,
         94,92,123,92,123,47,44,47,94,61,47,44,47,94,92,46,40,63,61,91,125,32,93,
         41,47,44,47,94,92,46,92,46,47,44,47,94,91,47,46,93,47,44,47,94,92,115,43,
         47,44,47,94,92,125,92,125,92,125,47,44,47,94,92,125,92,125,47,44,47,94,
         34,40,92,92,91,34,93,124,91,94,34,93,41,42,34,47,44,47,94,116,114,117,
         101,40,63,61,91,125,92,115,93,41,47,44,47,94,102,97,108,115,101,40,63,61,
         91,125,92,115,93,41,47,44,47,94,91,48,45,57,93,43,40,63,61,91,125,92,115,
         93,41,47,44,47,94,91,97,45,122,65,45,90,48,45,57,95,36,45,93,43,40,63,61,
         91,61,125,92,115,47,46,93,41,47,44,47,94,92,91,46,42,92,93,47,44,47,94,
         46,47,44,47,94,36,47,93,59,10,108,101,120,101,114,46,99,111,110,100,105,
         116,105,111,110,115,32,61,32,123,34,109,117,34,58,123,34,114,117,108,101,
         115,34,58,91,50,44,51,44,52,44,53,44,54,44,55,44,56,44,57,44,49,48,44,49,
         49,44,49,50,44,49,51,44,49,52,44,49,53,44,49,54,44,49,55,44,49,56,44,49,
         57,44,50,48,44,50,49,44,50,50,44,50,51,44,50,52,44,50,53,93,44,34,105,
         110,99,108,117,115,105,118,101,34,58,102,97,108,115,101,125,44,34,73,78,
         73,84,73,65,76,34,58,123,34,114,117,108,101,115,34,58,91,48,44,49,44,50,
         53,93,44,34,105,110,99,108,117,115,105,118,101,34,58,116,114,117,101,125,
         125,59,114,101,116,117,114,110,32,108,101,120,101,114,59,125,41,40,41,10,
         112,97,114,115,101,114,46,108,101,120,101,114,32,61,32,108,101,120,101,
         114,59,10,114,101,116,117,114,110,32,112,97,114,115,101,114,59,10,125,41,
         40,41,59,10,105,102,32,40,116,121,112,101,111,102,32,114,101,113,117,105,
         114,101,32,33,61,61,32,39,117,110,100,101,102,105,110,101,100,39,32,38,
         38,32,116,121,112,101,111,102,32,101,120,112,111,114,116,115,32,33,61,61,
         32,39,117,110,100,101,102,105,110,101,100,39,41,32,123,10,101,120,112,
         111,114,116,115,46,112,97,114,115,101,114,32,61,32,104,97,110,100,108,
         101,98,97,114,115,59,10,101,120,112,111,114,116,115,46,112,97,114,115,
         101,32,61,32,102,117,110,99,116,105,111,110,32,40,41,32,123,32,114,101,
         116,117,114,110,32,104,97,110,100,108,101,98,97,114,115,46,112,97,114,
         115,101,46,97,112,112,108,121,40,104,97,110,100,108,101,98,97,114,115,44,
         32,97,114,103,117,109,101,110,116,115,41,59,32,125,10,101,120,112,111,
         114,116,115,46,109,97,105,110,32,61,32,102,117,110,99,116,105,111,110,32,
         99,111,109,109,111,110,106,115,77,97,105,110,40,97,114,103,115,41,32,123,
         10,32,32,32,32,105,102,32,40,33,97,114,103,115,91,49,93,41,10,32,32,32,
         32,32,32,32,32,116,104,114,111,119,32,110,101,119,32,69,114,114,111,114,
         40,39,85,115,97,103,101,58,32,39,43,97,114,103,115,91,48,93,43,39,32,70,
         73,76,69,39,41,59,10,32,32,32,32,105,102,32,40,116,121,112,101,111,102,
         32,112,114,111,99,101,115,115,32,33,61,61,32,39,117,110,100,101,102,105,
         110,101,100,39,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,115,
         111,117,114,99,101,32,61,32,114,101,113,117,105,114,101,40,39,102,115,39,
         41,46,114,101,97,100,70,105,108,101,83,121,110,99,40,114,101,113,117,105,
         114,101,40,39,112,97,116,104,39,41,46,106,111,105,110,40,112,114,111,99,
         101,115,115,46,99,119,100,40,41,44,32,97,114,103,115,91,49,93,41,44,32,
         34,117,116,102,56,34,41,59,10,32,32,32,32,125,32,101,108,115,101,32,123,
         10,32,32,32,32,32,32,32,32,118,97,114,32,99,119,100,32,61,32,114,101,113,
         117,105,114,101,40,34,102,105,108,101,34,41,46,112,97,116,104,40,114,101,
         113,117,105,114,101,40,34,102,105,108,101,34,41,46,99,119,100,40,41,41,
         59,10,32,32,32,32,32,32,32,32,118,97,114,32,115,111,117,114,99,101,32,61,
         32,99,119,100,46,106,111,105,110,40,97,114,103,115,91,49,93,41,46,114,
         101,97,100,40,123,99,104,97,114,115,101,116,58,32,34,117,116,102,45,56,
         34,125,41,59,10,32,32,32,32,125,10,32,32,32,32,114,101,116,117,114,110,
         32,101,120,112,111,114,116,115,46,112,97,114,115,101,114,46,112,97,114,
         115,101,40,115,111,117,114,99,101,41,59,10,125,10,105,102,32,40,116,121,
         112,101,111,102,32,109,111,100,117,108,101,32,33,61,61,32,39,117,110,100,
         101,102,105,110,101,100,39,32,38,38,32,114,101,113,117,105,114,101,46,
         109,97,105,110,32,61,61,61,32,109,111,100,117,108,101,41,32,123,10,32,32,
         101,120,112,111,114,116,115,46,109,97,105,110,40,116,121,112,101,111,102,
         32,112,114,111,99,101,115,115,32,33,61,61,32,39,117,110,100,101,102,105,
         110,101,100,39,32,63,32,112,114,111,99,101,115,115,46,97,114,103,118,46,
         115,108,105,99,101,40,49,41,32,58,32,114,101,113,117,105,114,101,40,34,
         115,121,115,116,101,109,34,41,46,97,114,103,115,41,59,10,125,10,125,59,
         10,59,10,47,47,32,108,105,98,47,104,97,110,100,108,101,98,97,114,115,47,
         99,111,109,112,105,108,101,114,47,98,97,115,101,46,106,115,10,72,97,110,
         100,108,101,98,97,114,115,46,80,97,114,115,101,114,32,61,32,104,97,110,
         100,108,101,98,97,114,115,59,10,10,72,97,110,100,108,101,98,97,114,115,
         46,112,97,114,115,101,32,61,32,102,117,110,99,116,105,111,110,40,115,116,
         114,105,110,103,41,32,123,10,32,32,72,97,110,100,108,101,98,97,114,115,
         46,80,97,114,115,101,114,46,121,121,32,61,32,72,97,110,100,108,101,98,97,
         114,115,46,65,83,84,59,10,32,32,114,101,116,117,114,110,32,72,97,110,100,
         108,101,98,97,114,115,46,80,97,114,115,101,114,46,112,97,114,115,101,40,
         115,116,114,105,110,103,41,59,10,125,59,10,10,72,97,110,100,108,101,98,
         97,114,115,46,112,114,105,110,116,32,61,32,102,117,110,99,116,105,111,
         110,40,97,115,116,41,32,123,10,32,32,114,101,116,117,114,110,32,110,101,
         119,32,72,97,110,100,108,101,98,97,114,115,46,80,114,105,110,116,86,105,
         115,105,116,111,114,40,41,46,97,99,99,101,112,116,40,97,115,116,41,59,10,
         125,59,10,10,72,97,110,100,108,101,98,97,114,115,46,108,111,103,103,101,
         114,32,61,32,123,10,32,32,68,69,66,85,71,58,32,48,44,32,73,78,70,79,58,
         32,49,44,32,87,65,82,78,58,32,50,44,32,69,82,82,79,82,58,32,51,44,32,108,
         101,118,101,108,58,32,51,44,10,10,32,32,47,47,32,111,118,101,114,114,105,
         100,101,32,105,110,32,116,104,101,32,104,111,115,116,32,101,110,118,105,
         114,111,110,109,101,110,116,10,32,32,108,111,103,58,32,102,117,110,99,
         116,105,111,110,40,108,101,118,101,108,44,32,115,116,114,41,32,123,125,
         10,125,59,10,10,72,97,110,100,108,101,98,97,114,115,46,108,111,103,32,61,
         32,102,117,110,99,116,105,111,110,40,108,101,118,101,108,44,32,115,116,
         114,41,32,123,32,72,97,110,100,108,101,98,97,114,115,46,108,111,103,103,
         101,114,46,108,111,103,40,108,101,118,101,108,44,32,115,116,114,41,59,32,
         125,59,10,59,10,47,47,32,108,105,98,47,104,97,110,100,108,101,98,97,114,
         115,47,99,111,109,112,105,108,101,114,47,97,115,116,46,106,115,10,40,102,
         117,110,99,116,105,111,110,40,41,32,123,10,10,32,32,72,97,110,100,108,
         101,98,97,114,115,46,65,83,84,32,61,32,123,125,59,10,10,32,32,72,97,110,
         100,108,101,98,97,114,115,46,65,83,84,46,80,114,111,103,114,97,109,78,
         111,100,101,32,61,32,102,117,110,99,116,105,111,110,40,115,116,97,116,
         101,109,101,110,116,115,44,32,105,110,118,101,114,115,101,41,32,123,10,
         32,32,32,32,116,104,105,115,46,116,121,112,101,32,61,32,34,112,114,111,
         103,114,97,109,34,59,10,32,32,32,32,116,104,105,115,46,115,116,97,116,
         101,109,101,110,116,115,32,61,32,115,116,97,116,101,109,101,110,116,115,
         59,10,32,32,32,32,105,102,40,105,110,118,101,114,115,101,41,32,123,32,
         116,104,105,115,46,105,110,118,101,114,115,101,32,61,32,110,101,119,32,
         72,97,110,100,108,101,98,97,114,115,46,65,83,84,46,80,114,111,103,114,97,
         109,78,111,100,101,40,105,110,118,101,114,115,101,41,59,32,125,10,32,32,
         125,59,10,10,32,32,72,97,110,100,108,101,98,97,114,115,46,65,83,84,46,77,
         117,115,116,97,99,104,101,78,111,100,101,32,61,32,102,117,110,99,116,105,
         111,110,40,112,97,114,97,109,115,44,32,104,97,115,104,44,32,117,110,101,
         115,99,97,112,101,100,41,32,123,10,32,32,32,32,116,104,105,115,46,116,
         121,112,101,32,61,32,34,109,117,115,116,97,99,104,101,34,59,10,32,32,32,
         32,116,104,105,115,46,105,100,32,61,32,112,97,114,97,109,115,91,48,93,59,
         10,32,32,32,32,116,104,105,115,46,112,97,114,97,109,115,32,61,32,112,97,
         114,97,109,115,46,115,108,105,99,101,40,49,41,59,10,32,32,32,32,116,104,
         105,115,46,104,97,115,104,32,61,32,104,97,115,104,59,10,32,32,32,32,116,
         104,105,115,46,101,115,99,97,112,101,100,32,61,32,33,117,110,101,115,99,
         97,112,101,100,59,10,32,32,125,59,10,10,32,32,72,97,110,100,108,101,98,
         97,114,115,46,65,83,84,46,80,97,114,116,105,97,108,78,111,100,101,32,61,
         32,102,117,110,99,116,105,111,110,40,105,100,44,32,99,111,110,116,101,
         120,116,41,32,123,10,32,32,32,32,116,104,105,115,46,116,121,112,101,32,
         32,32,32,61,32,34,112,97,114,116,105,97,108,34,59,10,10,32,32,32,32,47,
         47,32,84,79,68,79,58,32,100,105,115,97,108,108,111,119,32,99,111,109,112,
         108,101,120,32,73,68,115,10,10,32,32,32,32,116,104,105,115,46,105,100,32,
         32,32,32,32,32,61,32,105,100,59,10,32,32,32,32,116,104,105,115,46,99,111,
         110,116,101,120,116,32,61,32,99,111,110,116,101,120,116,59,10,32,32,125,
         59,10,10,32,32,118,97,114,32,118,101,114,105,102,121,77,97,116,99,104,32,
         61,32,102,117,110,99,116,105,111,110,40,111,112,101,110,44,32,99,108,111,
         115,101,41,32,123,10,32,32,32,32,105,102,40,111,112,101,110,46,111,114,
         105,103,105,110,97,108,32,33,61,61,32,99,108,111,115,101,46,111,114,105,
         103,105,110,97,108,41,32,123,10,32,32,32,32,32,32,116,104,114,111,119,32,
         110,101,119,32,72,97,110,100,108,101,98,97,114,115,46,69,120,99,101,112,
         116,105,111,110,40,111,112,101,110,46,111,114,105,103,105,110,97,108,32,
         43,32,34,32,100,111,101,115,110,39,116,32,109,97,116,99,104,32,34,32,43,
         32,99,108,111,115,101,46,111,114,105,103,105,110,97,108,41,59,10,32,32,
         32,32,125,10,32,32,125,59,10,10,32,32,72,97,110,100,108,101,98,97,114,
         115,46,65,83,84,46,66,108,111,99,107,78,111,100,101,32,61,32,102,117,110,
         99,116,105,111,110,40,109,117,115,116,97,99,104,101,44,32,112,114,111,
         103,114,97,109,44,32,99,108,111,115,101,41,32,123,10,32,32,32,32,118,101,
         114,105,102,121,77,97,116,99,104,40,109,117,115,116,97,99,104,101,46,105,
         100,44,32,99,108,111,115,101,41,59,10,32,32,32,32,116,104,105,115,46,116,
         121,112,101,32,61,32,34,98,108,111,99,107,34,59,10,32,32,32,32,116,104,
         105,115,46,109,117,115,116,97,99,104,101,32,61,32,109,117,115,116,97,99,
         104,101,59,10,32,32,32,32,116,104,105,115,46,112,114,111,103,114,97,109,
         32,32,61,32,112,114,111,103,114,97,109,59,10,32,32,125,59,10,10,32,32,72,
         97,110,100,108,101,98,97,114,115,46,65,83,84,46,73,110,118,101,114,115,
         101,78,111,100,101,32,61,32,102,117,110,99,116,105,111,110,40,109,117,
         115,116,97,99,104,101,44,32,112,114,111,103,114,97,109,44,32,99,108,111,
         115,101,41,32,123,10,32,32,32,32,118,101,114,105,102,121,77,97,116,99,
         104,40,109,117,115,116,97,99,104,101,46,105,100,44,32,99,108,111,115,101,
         41,59,10,32,32,32,32,116,104,105,115,46,116,121,112,101,32,61,32,34,105,
         110,118,101,114,115,101,34,59,10,32,32,32,32,116,104,105,115,46,109,117,
         115,116,97,99,104,101,32,61,32,109,117,115,116,97,99,104,101,59,10,32,32,
         32,32,116,104,105,115,46,112,114,111,103,114,97,109,32,32,61,32,112,114,
         111,103,114,97,109,59,10,32,32,125,59,10,10,32,32,72,97,110,100,108,101,
         98,97,114,115,46,65,83,84,46,67,111,110,116,101,110,116,78,111,100,101,
         32,61,32,102,117,110,99,116,105,111,110,40,115,116,114,105,110,103,41,32,
         123,10,32,32,32,32,116,104,105,115,46,116,121,112,101,32,61,32,34,99,111,
         110,116,101,110,116,34,59,10,32,32,32,32,116,104,105,115,46,115,116,114,
         105,110,103,32,61,32,115,116,114,105,110,103,59,10,32,32,125,59,10,10,32,
         32,72,97,110,100,108,101,98,97,114,115,46,65,83,84,46,72,97,115,104,78,
         111,100,101,32,61,32,102,117,110,99,116,105,111,110,40,112,97,105,114,
         115,41,32,123,10,32,32,32,32,116,104,105,115,46,116,121,112,101,32,61,32,
         34,104,97,115,104,34,59,10,32,32,32,32,116,104,105,115,46,112,97,105,114,
         115,32,61,32,112,97,105,114,115,59,10,32,32,125,59,10,10,32,32,72,97,110,
         100,108,101,98,97,114,115,46,65,83,84,46,73,100,78,111,100,101,32,61,32,
         102,117,110,99,116,105,111,110,40,112,97,114,116,115,41,32,123,10,32,32,
         32,32,116,104,105,115,46,116,121,112,101,32,61,32,34,73,68,34,59,10,32,
         32,32,32,116,104,105,115,46,111,114,105,103,105,110,97,108,32,61,32,112,
         97,114,116,115,46,106,111,105,110,40,34,46,34,41,59,10,10,32,32,32,32,
         118,97,114,32,100,105,103,32,61,32,91,93,44,32,100,101,112,116,104,32,61,
         32,48,59,10,10,32,32,32,32,102,111,114,40,118,97,114,32,105,61,48,44,108,
         61,112,97,114,116,115,46,108,101,110,103,116,104,59,32,105,60,108,59,32,
         105,43,43,41,32,123,10,32,32,32,32,32,32,118,97,114,32,112,97,114,116,32,
         61,32,112,97,114,116,115,91,105,93,59,10,10,32,32,32,32,32,32,105,102,40,
         112,97,114,116,32,61,61,61,32,34,46,46,34,41,32,123,32,100,101,112,116,
         104,43,43,59,32,125,10,32,32,32,32,32,32,101,108,115,101,32,105,102,40,
         112,97,114,116,32,61,61,61,32,34,46,34,32,124,124,32,112,97,114,116,32,
         61,61,61,32,34,116,104,105,115,34,41,32,123,32,116,104,105,115,46,105,
         115,83,99,111,112,101,100,32,61,32,116,114,117,101,59,32,125,10,32,32,32,
         32,32,32,101,108,115,101,32,123,32,100,105,103,46,112,117,115,104,40,112,
         97,114,116,41,59,32,125,10,32,32,32,32,125,10,10,32,32,32,32,116,104,105,
         115,46,112,97,114,116,115,32,32,32,32,61,32,100,105,103,59,10,32,32,32,
         32,116,104,105,115,46,115,116,114,105,110,103,32,32,32,61,32,100,105,103,
         46,106,111,105,110,40,39,46,39,41,59,10,32,32,32,32,116,104,105,115,46,
         100,101,112,116,104,32,32,32,32,61,32,100,101,112,116,104,59,10,32,32,32,
         32,116,104,105,115,46,105,115,83,105,109,112,108,101,32,61,32,40,100,105,
         103,46,108,101,110,103,116,104,32,61,61,61,32,49,41,32,38,38,32,40,100,
         101,112,116,104,32,61,61,61,32,48,41,59,10,32,32,125,59,10,10,32,32,72,
         97,110,100,108,101,98,97,114,115,46,65,83,84,46,83,116,114,105,110,103,
         78,111,100,101,32,61,32,102,117,110,99,116,105,111,110,40,115,116,114,
         105,110,103,41,32,123,10,32,32,32,32,116,104,105,115,46,116,121,112,101,
         32,61,32,34,83,84,82,73,78,71,34,59,10,32,32,32,32,116,104,105,115,46,
         115,116,114,105,110,103,32,61,32,115,116,114,105,110,103,59,10,32,32,125,
         59,10,10,32,32,72,97,110,100,108,101,98,97,114,115,46,65,83,84,46,73,110,
         116,101,103,101,114,78,111,100,101,32,61,32,102,117,110,99,116,105,111,
         110,40,105,110,116,101,103,101,114,41,32,123,10,32,32,32,32,116,104,105,
         115,46,116,121,112,101,32,61,32,34,73,78,84,69,71,69,82,34,59,10,32,32,
         32,32,116,104,105,115,46,105,110,116,101,103,101,114,32,61,32,105,110,
         116,101,103,101,114,59,10,32,32,125,59,10,10,32,32,72,97,110,100,108,101,
         98,97,114,115,46,65,83,84,46,66,111,111,108,101,97,110,78,111,100,101,32,
         61,32,102,117,110,99,116,105,111,110,40,98,111,111,108,41,32,123,10,32,
         32,32,32,116,104,105,115,46,116,121,112,101,32,61,32,34,66,79,79,76,69,
         65,78,34,59,10,32,32,32,32,116,104,105,115,46,98,111,111,108,32,61,32,98,
         111,111,108,59,10,32,32,125,59,10,10,32,32,72,97,110,100,108,101,98,97,
         114,115,46,65,83,84,46,67,111,109,109,101,110,116,78,111,100,101,32,61,
         32,102,117,110,99,116,105,111,110,40,99,111,109,109,101,110,116,41,32,
         123,10,32,32,32,32,116,104,105,115,46,116,121,112,101,32,61,32,34,99,111,
         109,109,101,110,116,34,59,10,32,32,32,32,116,104,105,115,46,99,111,109,
         109,101,110,116,32,61,32,99,111,109,109,101,110,116,59,10,32,32,125,59,
         10,10,125,41,40,41,59,59,10,47,47,32,108,105,98,47,104,97,110,100,108,
         101,98,97,114,115,47,117,116,105,108,115,46,106,115,10,72,97,110,100,108,
         101,98,97,114,115,46,69,120,99,101,112,116,105,111,110,32,61,32,102,117,
         110,99,116,105,111,110,40,109,101,115,115,97,103,101,41,32,123,10,32,32,
         118,97,114,32,116,109,112,32,61,32,69,114,114,111,114,46,112,114,111,116,
         111,116,121,112,101,46,99,111,110,115,116,114,117,99,116,111,114,46,97,
         112,112,108,121,40,116,104,105,115,44,32,97,114,103,117,109,101,110,116,
         115,41,59,10,10,32,32,102,111,114,32,40,118,97,114,32,112,32,105,110,32,
         116,109,112,41,32,123,10,32,32,32,32,105,102,32,40,116,109,112,46,104,97,
         115,79,119,110,80,114,111,112,101,114,116,121,40,112,41,41,32,123,32,116,
         104,105,115,91,112,93,32,61,32,116,109,112,91,112,93,59,32,125,10,32,32,
         125,10,125,59,10,72,97,110,100,108,101,98,97,114,115,46,69,120,99,101,
         112,116,105,111,110,46,112,114,111,116,111,116,121,112,101,32,61,32,110,
         101,119,32,69,114,114,111,114,59,10,10,47,47,32,66,117,105,108,100,32,
         111,117,116,32,111,117,114,32,98,97,115,105,99,32,83,97,102,101,83,116,
         114,105,110,103,32,116,121,112,101,10,72,97,110,100,108,101,98,97,114,
         115,46,83,97,102,101,83,116,114,105,110,103,32,61,32,102,117,110,99,116,
         105,111,110,40,115,116,114,105,110,103,41,32,123,10,32,32,116,104,105,
         115,46,115,116,114,105,110,103,32,61,32,115,116,114,105,110,103,59,10,
         125,59,10,72,97,110,100,108,101,98,97,114,115,46,83,97,102,101,83,116,
         114,105,110,103,46,112,114,111,116,111,116,121,112,101,46,116,111,83,116,
         114,105,110,103,32,61,32,102,117,110,99,116,105,111,110,40,41,32,123,10,
         32,32,114,101,116,117,114,110,32,116,104,105,115,46,115,116,114,105,110,
         103,46,116,111,83,116,114,105,110,103,40,41,59,10,125,59,10,10,40,102,
         117,110,99,116,105,111,110,40,41,32,123,10,32,32,118,97,114,32,101,115,
         99,97,112,101,32,61,32,123,10,32,32,32,32,34,60,34,58,32,34,38,108,116,
         59,34,44,10,32,32,32,32,34,62,34,58,32,34,38,103,116,59,34,44,10,32,32,
         32,32,39,34,39,58,32,34,38,113,117,111,116,59,34,44,10,32,32,32,32,34,39,
         34,58,32,34,38,35,120,50,55,59,34,44,10,32,32,32,32,34,96,34,58,32,34,38,
         35,120,54,48,59,34,10,32,32,125,59,10,10,32,32,118,97,114,32,98,97,100,
         67,104,97,114,115,32,61,32,47,38,40,63,33,92,119,43,59,41,124,91,60,62,
         34,39,96,93,47,103,59,10,32,32,118,97,114,32,112,111,115,115,105,98,108,
         101,32,61,32,47,91,38,60,62,34,39,96,93,47,59,10,10,32,32,118,97,114,32,
         101,115,99,97,112,101,67,104,97,114,32,61,32,102,117,110,99,116,105,111,
         110,40,99,104,114,41,32,123,10,32,32,32,32,114,101,116,117,114,110,32,
         101,115,99,97,112,101,91,99,104,114,93,32,124,124,32,34,38,97,109,112,59,
         34,59,10,32,32,125,59,10,10,32,32,72,97,110,100,108,101,98,97,114,115,46,
         85,116,105,108,115,32,61,32,123,10,32,32,32,32,101,115,99,97,112,101,69,
         120,112,114,101,115,115,105,111,110,58,32,102,117,110,99,116,105,111,110,
         40,115,116,114,105,110,103,41,32,123,10,32,32,32,32,32,32,47,47,32,100,
         111,110,39,116,32,101,115,99,97,112,101,32,83,97,102,101,83,116,114,105,
         110,103,115,44,32,115,105,110,99,101,32,116,104,101,121,39,114,101,32,97,
         108,114,101,97,100,121,32,115,97,102,101,10,32,32,32,32,32,32,105,102,32,
         40,115,116,114,105,110,103,32,105,110,115,116,97,110,99,101,111,102,32,
         72,97,110,100,108,101,98,97,114,115,46,83,97,102,101,83,116,114,105,110,
         103,41,32,123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,115,
         116,114,105,110,103,46,116,111,83,116,114,105,110,103,40,41,59,10,32,32,
         32,32,32,32,125,32,101,108,115,101,32,105,102,32,40,115,116,114,105,110,
         103,32,61,61,32,110,117,108,108,32,124,124,32,115,116,114,105,110,103,32,
         61,61,61,32,102,97,108,115,101,41,32,123,10,32,32,32,32,32,32,32,32,114,
         101,116,117,114,110,32,34,34,59,10,32,32,32,32,32,32,125,10,10,32,32,32,
         32,32,32,105,102,40,33,112,111,115,115,105,98,108,101,46,116,101,115,116,
         40,115,116,114,105,110,103,41,41,32,123,32,114,101,116,117,114,110,32,
         115,116,114,105,110,103,59,32,125,10,32,32,32,32,32,32,114,101,116,117,
         114,110,32,115,116,114,105,110,103,46,114,101,112,108,97,99,101,40,98,97,
         100,67,104,97,114,115,44,32,101,115,99,97,112,101,67,104,97,114,41,59,10,
         32,32,32,32,125,44,10,10,32,32,32,32,105,115,69,109,112,116,121,58,32,
         102,117,110,99,116,105,111,110,40,118,97,108,117,101,41,32,123,10,32,32,
         32,32,32,32,105,102,32,40,116,121,112,101,111,102,32,118,97,108,117,101,
         32,61,61,61,32,34,117,110,100,101,102,105,110,101,100,34,41,32,123,10,32,
         32,32,32,32,32,32,32,114,101,116,117,114,110,32,116,114,117,101,59,10,32,
         32,32,32,32,32,125,32,101,108,115,101,32,105,102,32,40,118,97,108,117,
         101,32,61,61,61,32,110,117,108,108,41,32,123,10,32,32,32,32,32,32,32,32,
         114,101,116,117,114,110,32,116,114,117,101,59,10,32,32,32,32,32,32,125,
         32,101,108,115,101,32,105,102,32,40,118,97,108,117,101,32,61,61,61,32,
         102,97,108,115,101,41,32,123,10,32,32,32,32,32,32,32,32,114,101,116,117,
         114,110,32,116,114,117,101,59,10,32,32,32,32,32,32,125,32,101,108,115,
         101,32,105,102,40,79,98,106,101,99,116,46,112,114,111,116,111,116,121,
         112,101,46,116,111,83,116,114,105,110,103,46,99,97,108,108,40,118,97,108,
         117,101,41,32,61,61,61,32,34,91,111,98,106,101,99,116,32,65,114,114,97,
         121,93,34,32,38,38,32,118,97,108,117,101,46,108,101,110,103,116,104,32,
         61,61,61,32,48,41,32,123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,
         110,32,116,114,117,101,59,10,32,32,32,32,32,32,125,32,101,108,115,101,32,
         123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,102,97,108,115,
         101,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,10,32,32,125,59,10,
         125,41,40,41,59,59,10,47,47,32,108,105,98,47,104,97,110,100,108,101,98,
         97,114,115,47,99,111,109,112,105,108,101,114,47,99,111,109,112,105,108,
         101,114,46,106,115,10,72,97,110,100,108,101,98,97,114,115,46,67,111,109,
         112,105,108,101,114,32,61,32,102,117,110,99,116,105,111,110,40,41,32,123,
         125,59,10,72,97,110,100,108,101,98,97,114,115,46,74,97,118,97,83,99,114,
         105,112,116,67,111,109,112,105,108,101,114,32,61,32,102,117,110,99,116,
         105,111,110,40,41,32,123,125,59,10,10,40,102,117,110,99,116,105,111,110,
         40,67,111,109,112,105,108,101,114,44,32,74,97,118,97,83,99,114,105,112,
         116,67,111,109,112,105,108,101,114,41,32,123,10,32,32,67,111,109,112,105,
         108,101,114,46,79,80,67,79,68,69,95,77,65,80,32,61,32,123,10,32,32,32,32,
         97,112,112,101,110,100,67,111,110,116,101,110,116,58,32,49,44,10,32,32,
         32,32,103,101,116,67,111,110,116,101,120,116,58,32,50,44,10,32,32,32,32,
         108,111,111,107,117,112,87,105,116,104,72,101,108,112,101,114,115,58,32,
         51,44,10,32,32,32,32,108,111,111,107,117,112,58,32,52,44,10,32,32,32,32,
         97,112,112,101,110,100,58,32,53,44,10,32,32,32,32,105,110,118,111,107,
         101,77,117,115,116,97,99,104,101,58,32,54,44,10,32,32,32,32,97,112,112,
         101,110,100,69,115,99,97,112,101,100,58,32,55,44,10,32,32,32,32,112,117,
         115,104,83,116,114,105,110,103,58,32,56,44,10,32,32,32,32,116,114,117,
         116,104,121,79,114,70,97,108,108,98,97,99,107,58,32,57,44,10,32,32,32,32,
         102,117,110,99,116,105,111,110,79,114,70,97,108,108,98,97,99,107,58,32,
         49,48,44,10,32,32,32,32,105,110,118,111,107,101,80,114,111,103,114,97,
         109,58,32,49,49,44,10,32,32,32,32,105,110,118,111,107,101,80,97,114,116,
         105,97,108,58,32,49,50,44,10,32,32,32,32,112,117,115,104,58,32,49,51,44,
         10,32,32,32,32,97,115,115,105,103,110,84,111,72,97,115,104,58,32,49,53,
         44,10,32,32,32,32,112,117,115,104,83,116,114,105,110,103,80,97,114,97,
         109,58,32,49,54,10,32,32,125,59,10,10,32,32,67,111,109,112,105,108,101,
         114,46,77,85,76,84,73,95,80,65,82,65,77,95,79,80,67,79,68,69,83,32,61,32,
         123,10,32,32,32,32,97,112,112,101,110,100,67,111,110,116,101,110,116,58,
         32,49,44,10,32,32,32,32,103,101,116,67,111,110,116,101,120,116,58,32,49,
         44,10,32,32,32,32,108,111,111,107,117,112,87,105,116,104,72,101,108,112,
         101,114,115,58,32,50,44,10,32,32,32,32,108,111,111,107,117,112,58,32,49,
         44,10,32,32,32,32,105,110,118,111,107,101,77,117,115,116,97,99,104,101,
         58,32,51,44,10,32,32,32,32,112,117,115,104,83,116,114,105,110,103,58,32,
         49,44,10,32,32,32,32,116,114,117,116,104,121,79,114,70,97,108,108,98,97,
         99,107,58,32,49,44,10,32,32,32,32,102,117,110,99,116,105,111,110,79,114,
         70,97,108,108,98,97,99,107,58,32,49,44,10,32,32,32,32,105,110,118,111,
         107,101,80,114,111,103,114,97,109,58,32,51,44,10,32,32,32,32,105,110,118,
         111,107,101,80,97,114,116,105,97,108,58,32,49,44,10,32,32,32,32,112,117,
         115,104,58,32,49,44,10,32,32,32,32,97,115,115,105,103,110,84,111,72,97,
         115,104,58,32,49,44,10,32,32,32,32,112,117,115,104,83,116,114,105,110,
         103,80,97,114,97,109,58,32,49,10,32,32,125,59,10,10,32,32,67,111,109,112,
         105,108,101,114,46,68,73,83,65,83,83,69,77,66,76,69,95,77,65,80,32,61,32,
         123,125,59,10,10,32,32,102,111,114,40,118,97,114,32,112,114,111,112,32,
         105,110,32,67,111,109,112,105,108,101,114,46,79,80,67,79,68,69,95,77,65,
         80,41,32,123,10,32,32,32,32,118,97,114,32,118,97,108,117,101,32,61,32,67,
         111,109,112,105,108,101,114,46,79,80,67,79,68,69,95,77,65,80,91,112,114,
         111,112,93,59,10,32,32,32,32,67,111,109,112,105,108,101,114,46,68,73,83,
         65,83,83,69,77,66,76,69,95,77,65,80,91,118,97,108,117,101,93,32,61,32,
         112,114,111,112,59,10,32,32,125,10,10,32,32,67,111,109,112,105,108,101,
         114,46,109,117,108,116,105,80,97,114,97,109,83,105,122,101,32,61,32,102,
         117,110,99,116,105,111,110,40,99,111,100,101,41,32,123,10,32,32,32,32,
         114,101,116,117,114,110,32,67,111,109,112,105,108,101,114,46,77,85,76,84,
         73,95,80,65,82,65,77,95,79,80,67,79,68,69,83,91,67,111,109,112,105,108,
         101,114,46,68,73,83,65,83,83,69,77,66,76,69,95,77,65,80,91,99,111,100,
         101,93,93,59,10,32,32,125,59,10,10,32,32,67,111,109,112,105,108,101,114,
         46,112,114,111,116,111,116,121,112,101,32,61,32,123,10,32,32,32,32,99,
         111,109,112,105,108,101,114,58,32,67,111,109,112,105,108,101,114,44,10,
         10,32,32,32,32,100,105,115,97,115,115,101,109,98,108,101,58,32,102,117,
         110,99,116,105,111,110,40,41,32,123,10,32,32,32,32,32,32,118,97,114,32,
         111,112,99,111,100,101,115,32,61,32,116,104,105,115,46,111,112,99,111,
         100,101,115,44,32,111,112,99,111,100,101,44,32,110,101,120,116,67,111,
         100,101,59,10,32,32,32,32,32,32,118,97,114,32,111,117,116,32,61,32,91,93,
         44,32,115,116,114,44,32,110,97,109,101,44,32,118,97,108,117,101,59,10,10,
         32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,48,44,32,108,61,
         111,112,99,111,100,101,115,46,108,101,110,103,116,104,59,32,105,60,108,
         59,32,105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,111,112,99,111,100,
         101,32,61,32,111,112,99,111,100,101,115,91,105,93,59,10,10,32,32,32,32,
         32,32,32,32,105,102,40,111,112,99,111,100,101,32,61,61,61,32,39,68,69,67,
         76,65,82,69,39,41,32,123,10,32,32,32,32,32,32,32,32,32,32,110,97,109,101,
         32,61,32,111,112,99,111,100,101,115,91,43,43,105,93,59,10,32,32,32,32,32,
         32,32,32,32,32,118,97,108,117,101,32,61,32,111,112,99,111,100,101,115,91,
         43,43,105,93,59,10,32,32,32,32,32,32,32,32,32,32,111,117,116,46,112,117,
         115,104,40,34,68,69,67,76,65,82,69,32,34,32,43,32,110,97,109,101,32,43,
         32,34,32,61,32,34,32,43,32,118,97,108,117,101,41,59,10,32,32,32,32,32,32,
         32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,32,32,115,
         116,114,32,61,32,67,111,109,112,105,108,101,114,46,68,73,83,65,83,83,69,
         77,66,76,69,95,77,65,80,91,111,112,99,111,100,101,93,59,10,10,32,32,32,
         32,32,32,32,32,32,32,118,97,114,32,101,120,116,114,97,80,97,114,97,109,
         115,32,61,32,67,111,109,112,105,108,101,114,46,109,117,108,116,105,80,97,
         114,97,109,83,105,122,101,40,111,112,99,111,100,101,41,59,10,32,32,32,32,
         32,32,32,32,32,32,118,97,114,32,99,111,100,101,115,32,61,32,91,93,59,10,
         10,32,32,32,32,32,32,32,32,32,32,102,111,114,40,118,97,114,32,106,61,48,
         59,32,106,60,101,120,116,114,97,80,97,114,97,109,115,59,32,106,43,43,41,
         32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,110,101,120,116,67,111,100,
         101,32,61,32,111,112,99,111,100,101,115,91,43,43,105,93,59,10,10,32,32,
         32,32,32,32,32,32,32,32,32,32,105,102,40,116,121,112,101,111,102,32,110,
         101,120,116,67,111,100,101,32,61,61,61,32,34,115,116,114,105,110,103,34,
         41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,110,101,120,116,
         67,111,100,101,32,61,32,34,92,34,34,32,43,32,110,101,120,116,67,111,100,
         101,46,114,101,112,108,97,99,101,40,34,92,110,34,44,32,34,92,92,110,34,
         41,32,43,32,34,92,34,34,59,10,32,32,32,32,32,32,32,32,32,32,32,32,125,10,
         10,32,32,32,32,32,32,32,32,32,32,32,32,99,111,100,101,115,46,112,117,115,
         104,40,110,101,120,116,67,111,100,101,41,59,10,32,32,32,32,32,32,32,32,
         32,32,125,10,10,32,32,32,32,32,32,32,32,32,32,115,116,114,32,61,32,115,
         116,114,32,43,32,34,32,34,32,43,32,99,111,100,101,115,46,106,111,105,110,
         40,34,32,34,41,59,10,10,32,32,32,32,32,32,32,32,32,32,111,117,116,46,112,
         117,115,104,40,115,116,114,41,59,10,32,32,32,32,32,32,32,32,125,10,32,32,
         32,32,32,32,125,10,10,32,32,32,32,32,32,114,101,116,117,114,110,32,111,
         117,116,46,106,111,105,110,40,34,92,110,34,41,59,10,32,32,32,32,125,44,
         10,10,32,32,32,32,103,117,105,100,58,32,48,44,10,10,32,32,32,32,99,111,
         109,112,105,108,101,58,32,102,117,110,99,116,105,111,110,40,112,114,111,
         103,114,97,109,44,32,111,112,116,105,111,110,115,41,32,123,10,32,32,32,
         32,32,32,116,104,105,115,46,99,104,105,108,100,114,101,110,32,61,32,91,
         93,59,10,32,32,32,32,32,32,116,104,105,115,46,100,101,112,116,104,115,32,
         61,32,123,108,105,115,116,58,32,91,93,125,59,10,32,32,32,32,32,32,116,
         104,105,115,46,111,112,116,105,111,110,115,32,61,32,111,112,116,105,111,
         110,115,59,10,10,32,32,32,32,32,32,47,47,32,84,104,101,115,101,32,99,104,
         97,110,103,101,115,32,119,105,108,108,32,112,114,111,112,97,103,97,116,
         101,32,116,111,32,116,104,101,32,111,116,104,101,114,32,99,111,109,112,
         105,108,101,114,32,99,111,109,112,111,110,101,110,116,115,10,32,32,32,32,
         32,32,118,97,114,32,107,110,111,119,110,72,101,108,112,101,114,115,32,61,
         32,116,104,105,115,46,111,112,116,105,111,110,115,46,107,110,111,119,110,
         72,101,108,112,101,114,115,59,10,32,32,32,32,32,32,116,104,105,115,46,
         111,112,116,105,111,110,115,46,107,110,111,119,110,72,101,108,112,101,
         114,115,32,61,32,123,10,32,32,32,32,32,32,32,32,39,104,101,108,112,101,
         114,77,105,115,115,105,110,103,39,58,32,116,114,117,101,44,10,32,32,32,
         32,32,32,32,32,39,98,108,111,99,107,72,101,108,112,101,114,77,105,115,
         115,105,110,103,39,58,32,116,114,117,101,44,10,32,32,32,32,32,32,32,32,
         39,101,97,99,104,39,58,32,116,114,117,101,44,10,32,32,32,32,32,32,32,32,
         39,105,102,39,58,32,116,114,117,101,44,10,32,32,32,32,32,32,32,32,39,117,
         110,108,101,115,115,39,58,32,116,114,117,101,44,10,32,32,32,32,32,32,32,
         32,39,119,105,116,104,39,58,32,116,114,117,101,10,32,32,32,32,32,32,125,
         59,10,32,32,32,32,32,32,105,102,32,40,107,110,111,119,110,72,101,108,112,
         101,114,115,41,32,123,10,32,32,32,32,32,32,32,32,102,111,114,32,40,118,
         97,114,32,110,97,109,101,32,105,110,32,107,110,111,119,110,72,101,108,
         112,101,114,115,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,
         115,46,111,112,116,105,111,110,115,46,107,110,111,119,110,72,101,108,112,
         101,114,115,91,110,97,109,101,93,32,61,32,107,110,111,119,110,72,101,108,
         112,101,114,115,91,110,97,109,101,93,59,10,32,32,32,32,32,32,32,32,125,
         10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,114,101,116,117,114,110,
         32,116,104,105,115,46,112,114,111,103,114,97,109,40,112,114,111,103,114,
         97,109,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,97,99,99,101,112,
         116,58,32,102,117,110,99,116,105,111,110,40,110,111,100,101,41,32,123,10,
         32,32,32,32,32,32,114,101,116,117,114,110,32,116,104,105,115,91,110,111,
         100,101,46,116,121,112,101,93,40,110,111,100,101,41,59,10,32,32,32,32,
         125,44,10,10,32,32,32,32,112,114,111,103,114,97,109,58,32,102,117,110,99,
         116,105,111,110,40,112,114,111,103,114,97,109,41,32,123,10,32,32,32,32,
         32,32,118,97,114,32,115,116,97,116,101,109,101,110,116,115,32,61,32,112,
         114,111,103,114,97,109,46,115,116,97,116,101,109,101,110,116,115,44,32,
         115,116,97,116,101,109,101,110,116,59,10,32,32,32,32,32,32,116,104,105,
         115,46,111,112,99,111,100,101,115,32,61,32,91,93,59,10,10,32,32,32,32,32,
         32,102,111,114,40,118,97,114,32,105,61,48,44,32,108,61,115,116,97,116,
         101,109,101,110,116,115,46,108,101,110,103,116,104,59,32,105,60,108,59,
         32,105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,115,116,97,116,101,109,
         101,110,116,32,61,32,115,116,97,116,101,109,101,110,116,115,91,105,93,59,
         10,32,32,32,32,32,32,32,32,116,104,105,115,91,115,116,97,116,101,109,101,
         110,116,46,116,121,112,101,93,40,115,116,97,116,101,109,101,110,116,41,
         59,10,32,32,32,32,32,32,125,10,32,32,32,32,32,32,116,104,105,115,46,105,
         115,83,105,109,112,108,101,32,61,32,108,32,61,61,61,32,49,59,10,10,32,32,
         32,32,32,32,116,104,105,115,46,100,101,112,116,104,115,46,108,105,115,
         116,32,61,32,116,104,105,115,46,100,101,112,116,104,115,46,108,105,115,
         116,46,115,111,114,116,40,102,117,110,99,116,105,111,110,40,97,44,32,98,
         41,32,123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,97,32,45,
         32,98,59,10,32,32,32,32,32,32,125,41,59,10,10,32,32,32,32,32,32,114,101,
         116,117,114,110,32,116,104,105,115,59,10,32,32,32,32,125,44,10,10,32,32,
         32,32,99,111,109,112,105,108,101,80,114,111,103,114,97,109,58,32,102,117,
         110,99,116,105,111,110,40,112,114,111,103,114,97,109,41,32,123,10,32,32,
         32,32,32,32,118,97,114,32,114,101,115,117,108,116,32,61,32,110,101,119,
         32,116,104,105,115,46,99,111,109,112,105,108,101,114,40,41,46,99,111,109,
         112,105,108,101,40,112,114,111,103,114,97,109,44,32,116,104,105,115,46,
         111,112,116,105,111,110,115,41,59,10,32,32,32,32,32,32,118,97,114,32,103,
         117,105,100,32,61,32,116,104,105,115,46,103,117,105,100,43,43,59,10,10,
         32,32,32,32,32,32,116,104,105,115,46,117,115,101,80,97,114,116,105,97,
         108,32,61,32,116,104,105,115,46,117,115,101,80,97,114,116,105,97,108,32,
         124,124,32,114,101,115,117,108,116,46,117,115,101,80,97,114,116,105,97,
         108,59,10,10,32,32,32,32,32,32,116,104,105,115,46,99,104,105,108,100,114,
         101,110,91,103,117,105,100,93,32,61,32,114,101,115,117,108,116,59,10,10,
         32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,48,44,32,108,61,
         114,101,115,117,108,116,46,100,101,112,116,104,115,46,108,105,115,116,46,
         108,101,110,103,116,104,59,32,105,60,108,59,32,105,43,43,41,32,123,10,32,
         32,32,32,32,32,32,32,100,101,112,116,104,32,61,32,114,101,115,117,108,
         116,46,100,101,112,116,104,115,46,108,105,115,116,91,105,93,59,10,10,32,
         32,32,32,32,32,32,32,105,102,40,100,101,112,116,104,32,60,32,50,41,32,
         123,32,99,111,110,116,105,110,117,101,59,32,125,10,32,32,32,32,32,32,32,
         32,101,108,115,101,32,123,32,116,104,105,115,46,97,100,100,68,101,112,
         116,104,40,100,101,112,116,104,32,45,32,49,41,59,32,125,10,32,32,32,32,
         32,32,125,10,10,32,32,32,32,32,32,114,101,116,117,114,110,32,103,117,105,
         100,59,10,32,32,32,32,125,44,10,10,32,32,32,32,98,108,111,99,107,58,32,
         102,117,110,99,116,105,111,110,40,98,108,111,99,107,41,32,123,10,32,32,
         32,32,32,32,118,97,114,32,109,117,115,116,97,99,104,101,32,61,32,98,108,
         111,99,107,46,109,117,115,116,97,99,104,101,59,10,32,32,32,32,32,32,118,
         97,114,32,100,101,112,116,104,44,32,99,104,105,108,100,44,32,105,110,118,
         101,114,115,101,44,32,105,110,118,101,114,115,101,71,117,105,100,59,10,
         10,32,32,32,32,32,32,118,97,114,32,112,97,114,97,109,115,32,61,32,116,
         104,105,115,46,115,101,116,117,112,83,116,97,99,107,70,111,114,77,117,
         115,116,97,99,104,101,40,109,117,115,116,97,99,104,101,41,59,10,10,32,32,
         32,32,32,32,118,97,114,32,112,114,111,103,114,97,109,71,117,105,100,32,
         61,32,116,104,105,115,46,99,111,109,112,105,108,101,80,114,111,103,114,
         97,109,40,98,108,111,99,107,46,112,114,111,103,114,97,109,41,59,10,10,32,
         32,32,32,32,32,105,102,40,98,108,111,99,107,46,112,114,111,103,114,97,
         109,46,105,110,118,101,114,115,101,41,32,123,10,32,32,32,32,32,32,32,32,
         105,110,118,101,114,115,101,71,117,105,100,32,61,32,116,104,105,115,46,
         99,111,109,112,105,108,101,80,114,111,103,114,97,109,40,98,108,111,99,
         107,46,112,114,111,103,114,97,109,46,105,110,118,101,114,115,101,41,59,
         10,32,32,32,32,32,32,32,32,116,104,105,115,46,100,101,99,108,97,114,101,
         40,39,105,110,118,101,114,115,101,39,44,32,105,110,118,101,114,115,101,
         71,117,105,100,41,59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,
         116,104,105,115,46,111,112,99,111,100,101,40,39,105,110,118,111,107,101,
         80,114,111,103,114,97,109,39,44,32,112,114,111,103,114,97,109,71,117,105,
         100,44,32,112,97,114,97,109,115,46,108,101,110,103,116,104,44,32,33,33,
         109,117,115,116,97,99,104,101,46,104,97,115,104,41,59,10,32,32,32,32,32,
         32,116,104,105,115,46,100,101,99,108,97,114,101,40,39,105,110,118,101,
         114,115,101,39,44,32,110,117,108,108,41,59,10,32,32,32,32,32,32,116,104,
         105,115,46,111,112,99,111,100,101,40,39,97,112,112,101,110,100,39,41,59,
         10,32,32,32,32,125,44,10,10,32,32,32,32,105,110,118,101,114,115,101,58,
         32,102,117,110,99,116,105,111,110,40,98,108,111,99,107,41,32,123,10,32,
         32,32,32,32,32,118,97,114,32,112,97,114,97,109,115,32,61,32,116,104,105,
         115,46,115,101,116,117,112,83,116,97,99,107,70,111,114,77,117,115,116,97,
         99,104,101,40,98,108,111,99,107,46,109,117,115,116,97,99,104,101,41,59,
         10,10,32,32,32,32,32,32,118,97,114,32,112,114,111,103,114,97,109,71,117,
         105,100,32,61,32,116,104,105,115,46,99,111,109,112,105,108,101,80,114,
         111,103,114,97,109,40,98,108,111,99,107,46,112,114,111,103,114,97,109,41,
         59,10,10,32,32,32,32,32,32,116,104,105,115,46,100,101,99,108,97,114,101,
         40,39,105,110,118,101,114,115,101,39,44,32,112,114,111,103,114,97,109,71,
         117,105,100,41,59,10,10,32,32,32,32,32,32,116,104,105,115,46,111,112,99,
         111,100,101,40,39,105,110,118,111,107,101,80,114,111,103,114,97,109,39,
         44,32,110,117,108,108,44,32,112,97,114,97,109,115,46,108,101,110,103,116,
         104,44,32,33,33,98,108,111,99,107,46,109,117,115,116,97,99,104,101,46,
         104,97,115,104,41,59,10,32,32,32,32,32,32,116,104,105,115,46,111,112,99,
         111,100,101,40,39,97,112,112,101,110,100,39,41,59,10,32,32,32,32,125,44,
         10,10,32,32,32,32,104,97,115,104,58,32,102,117,110,99,116,105,111,110,40,
         104,97,115,104,41,32,123,10,32,32,32,32,32,32,118,97,114,32,112,97,105,
         114,115,32,61,32,104,97,115,104,46,112,97,105,114,115,44,32,112,97,105,
         114,44,32,118,97,108,59,10,10,32,32,32,32,32,32,116,104,105,115,46,111,
         112,99,111,100,101,40,39,112,117,115,104,39,44,32,39,123,125,39,41,59,10,
         10,32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,48,44,32,108,61,
         112,97,105,114,115,46,108,101,110,103,116,104,59,32,105,60,108,59,32,105,
         43,43,41,32,123,10,32,32,32,32,32,32,32,32,112,97,105,114,32,61,32,112,
         97,105,114,115,91,105,93,59,10,32,32,32,32,32,32,32,32,118,97,108,32,32,
         61,32,112,97,105,114,91,49,93,59,10,10,32,32,32,32,32,32,32,32,116,104,
         105,115,46,97,99,99,101,112,116,40,118,97,108,41,59,10,32,32,32,32,32,32,
         32,32,116,104,105,115,46,111,112,99,111,100,101,40,39,97,115,115,105,103,
         110,84,111,72,97,115,104,39,44,32,112,97,105,114,91,48,93,41,59,10,32,32,
         32,32,32,32,125,10,32,32,32,32,125,44,10,10,32,32,32,32,112,97,114,116,
         105,97,108,58,32,102,117,110,99,116,105,111,110,40,112,97,114,116,105,97,
         108,41,32,123,10,32,32,32,32,32,32,118,97,114,32,105,100,32,61,32,112,97,
         114,116,105,97,108,46,105,100,59,10,32,32,32,32,32,32,116,104,105,115,46,
         117,115,101,80,97,114,116,105,97,108,32,61,32,116,114,117,101,59,10,10,
         32,32,32,32,32,32,105,102,40,112,97,114,116,105,97,108,46,99,111,110,116,
         101,120,116,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,73,
         68,40,112,97,114,116,105,97,108,46,99,111,110,116,101,120,116,41,59,10,
         32,32,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,
         32,116,104,105,115,46,111,112,99,111,100,101,40,39,112,117,115,104,39,44,
         32,39,100,101,112,116,104,48,39,41,59,10,32,32,32,32,32,32,125,10,10,32,
         32,32,32,32,32,116,104,105,115,46,111,112,99,111,100,101,40,39,105,110,
         118,111,107,101,80,97,114,116,105,97,108,39,44,32,105,100,46,111,114,105,
         103,105,110,97,108,41,59,10,32,32,32,32,32,32,116,104,105,115,46,111,112,
         99,111,100,101,40,39,97,112,112,101,110,100,39,41,59,10,32,32,32,32,125,
         44,10,10,32,32,32,32,99,111,110,116,101,110,116,58,32,102,117,110,99,116,
         105,111,110,40,99,111,110,116,101,110,116,41,32,123,10,32,32,32,32,32,32,
         116,104,105,115,46,111,112,99,111,100,101,40,39,97,112,112,101,110,100,
         67,111,110,116,101,110,116,39,44,32,99,111,110,116,101,110,116,46,115,
         116,114,105,110,103,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,109,
         117,115,116,97,99,104,101,58,32,102,117,110,99,116,105,111,110,40,109,
         117,115,116,97,99,104,101,41,32,123,10,32,32,32,32,32,32,118,97,114,32,
         112,97,114,97,109,115,32,61,32,116,104,105,115,46,115,101,116,117,112,83,
         116,97,99,107,70,111,114,77,117,115,116,97,99,104,101,40,109,117,115,116,
         97,99,104,101,41,59,10,10,32,32,32,32,32,32,116,104,105,115,46,111,112,
         99,111,100,101,40,39,105,110,118,111,107,101,77,117,115,116,97,99,104,
         101,39,44,32,112,97,114,97,109,115,46,108,101,110,103,116,104,44,32,109,
         117,115,116,97,99,104,101,46,105,100,46,111,114,105,103,105,110,97,108,
         44,32,33,33,109,117,115,116,97,99,104,101,46,104,97,115,104,41,59,10,10,
         32,32,32,32,32,32,105,102,40,109,117,115,116,97,99,104,101,46,101,115,99,
         97,112,101,100,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,
         111,112,99,111,100,101,40,39,97,112,112,101,110,100,69,115,99,97,112,101,
         100,39,41,59,10,32,32,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,
         32,32,32,32,32,32,116,104,105,115,46,111,112,99,111,100,101,40,39,97,112,
         112,101,110,100,39,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,
         10,10,32,32,32,32,73,68,58,32,102,117,110,99,116,105,111,110,40,105,100,
         41,32,123,10,32,32,32,32,32,32,116,104,105,115,46,97,100,100,68,101,112,
         116,104,40,105,100,46,100,101,112,116,104,41,59,10,10,32,32,32,32,32,32,
         116,104,105,115,46,111,112,99,111,100,101,40,39,103,101,116,67,111,110,
         116,101,120,116,39,44,32,105,100,46,100,101,112,116,104,41,59,10,10,32,
         32,32,32,32,32,116,104,105,115,46,111,112,99,111,100,101,40,39,108,111,
         111,107,117,112,87,105,116,104,72,101,108,112,101,114,115,39,44,32,105,
         100,46,112,97,114,116,115,91,48,93,32,124,124,32,110,117,108,108,44,32,
         105,100,46,105,115,83,99,111,112,101,100,32,124,124,32,102,97,108,115,
         101,41,59,10,10,32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,49,
         44,32,108,61,105,100,46,112,97,114,116,115,46,108,101,110,103,116,104,59,
         32,105,60,108,59,32,105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,116,
         104,105,115,46,111,112,99,111,100,101,40,39,108,111,111,107,117,112,39,
         44,32,105,100,46,112,97,114,116,115,91,105,93,41,59,10,32,32,32,32,32,32,
         125,10,32,32,32,32,125,44,10,10,32,32,32,32,83,84,82,73,78,71,58,32,102,
         117,110,99,116,105,111,110,40,115,116,114,105,110,103,41,32,123,10,32,32,
         32,32,32,32,116,104,105,115,46,111,112,99,111,100,101,40,39,112,117,115,
         104,83,116,114,105,110,103,39,44,32,115,116,114,105,110,103,46,115,116,
         114,105,110,103,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,73,78,84,
         69,71,69,82,58,32,102,117,110,99,116,105,111,110,40,105,110,116,101,103,
         101,114,41,32,123,10,32,32,32,32,32,32,116,104,105,115,46,111,112,99,111,
         100,101,40,39,112,117,115,104,39,44,32,105,110,116,101,103,101,114,46,
         105,110,116,101,103,101,114,41,59,10,32,32,32,32,125,44,10,10,32,32,32,
         32,66,79,79,76,69,65,78,58,32,102,117,110,99,116,105,111,110,40,98,111,
         111,108,41,32,123,10,32,32,32,32,32,32,116,104,105,115,46,111,112,99,111,
         100,101,40,39,112,117,115,104,39,44,32,98,111,111,108,46,98,111,111,108,
         41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,99,111,109,109,101,110,116,
         58,32,102,117,110,99,116,105,111,110,40,41,32,123,125,44,10,10,32,32,32,
         32,47,47,32,72,69,76,80,69,82,83,10,32,32,32,32,112,117,115,104,80,97,
         114,97,109,115,58,32,102,117,110,99,116,105,111,110,40,112,97,114,97,109,
         115,41,32,123,10,32,32,32,32,32,32,118,97,114,32,105,32,61,32,112,97,114,
         97,109,115,46,108,101,110,103,116,104,44,32,112,97,114,97,109,59,10,10,
         32,32,32,32,32,32,119,104,105,108,101,40,105,45,45,41,32,123,10,32,32,32,
         32,32,32,32,32,112,97,114,97,109,32,61,32,112,97,114,97,109,115,91,105,
         93,59,10,10,32,32,32,32,32,32,32,32,105,102,40,116,104,105,115,46,111,
         112,116,105,111,110,115,46,115,116,114,105,110,103,80,97,114,97,109,115,
         41,32,123,10,32,32,32,32,32,32,32,32,32,32,105,102,40,112,97,114,97,109,
         46,100,101,112,116,104,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,
         116,104,105,115,46,97,100,100,68,101,112,116,104,40,112,97,114,97,109,46,
         100,101,112,116,104,41,59,10,32,32,32,32,32,32,32,32,32,32,125,10,10,32,
         32,32,32,32,32,32,32,32,32,116,104,105,115,46,111,112,99,111,100,101,40,
         39,103,101,116,67,111,110,116,101,120,116,39,44,32,112,97,114,97,109,46,
         100,101,112,116,104,32,124,124,32,48,41,59,10,32,32,32,32,32,32,32,32,32,
         32,116,104,105,115,46,111,112,99,111,100,101,40,39,112,117,115,104,83,
         116,114,105,110,103,80,97,114,97,109,39,44,32,112,97,114,97,109,46,115,
         116,114,105,110,103,41,59,10,32,32,32,32,32,32,32,32,125,32,101,108,115,
         101,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,91,112,97,
         114,97,109,46,116,121,112,101,93,40,112,97,114,97,109,41,59,10,32,32,32,
         32,32,32,32,32,125,10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,10,
         32,32,32,32,111,112,99,111,100,101,58,32,102,117,110,99,116,105,111,110,
         40,110,97,109,101,44,32,118,97,108,49,44,32,118,97,108,50,44,32,118,97,
         108,51,41,32,123,10,32,32,32,32,32,32,116,104,105,115,46,111,112,99,111,
         100,101,115,46,112,117,115,104,40,67,111,109,112,105,108,101,114,46,79,
         80,67,79,68,69,95,77,65,80,91,110,97,109,101,93,41,59,10,32,32,32,32,32,
         32,105,102,40,118,97,108,49,32,33,61,61,32,117,110,100,101,102,105,110,
         101,100,41,32,123,32,116,104,105,115,46,111,112,99,111,100,101,115,46,
         112,117,115,104,40,118,97,108,49,41,59,32,125,10,32,32,32,32,32,32,105,
         102,40,118,97,108,50,32,33,61,61,32,117,110,100,101,102,105,110,101,100,
         41,32,123,32,116,104,105,115,46,111,112,99,111,100,101,115,46,112,117,
         115,104,40,118,97,108,50,41,59,32,125,10,32,32,32,32,32,32,105,102,40,
         118,97,108,51,32,33,61,61,32,117,110,100,101,102,105,110,101,100,41,32,
         123,32,116,104,105,115,46,111,112,99,111,100,101,115,46,112,117,115,104,
         40,118,97,108,51,41,59,32,125,10,32,32,32,32,125,44,10,10,32,32,32,32,
         100,101,99,108,97,114,101,58,32,102,117,110,99,116,105,111,110,40,110,97,
         109,101,44,32,118,97,108,117,101,41,32,123,10,32,32,32,32,32,32,116,104,
         105,115,46,111,112,99,111,100,101,115,46,112,117,115,104,40,39,68,69,67,
         76,65,82,69,39,41,59,10,32,32,32,32,32,32,116,104,105,115,46,111,112,99,
         111,100,101,115,46,112,117,115,104,40,110,97,109,101,41,59,10,32,32,32,
         32,32,32,116,104,105,115,46,111,112,99,111,100,101,115,46,112,117,115,
         104,40,118,97,108,117,101,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,
         97,100,100,68,101,112,116,104,58,32,102,117,110,99,116,105,111,110,40,
         100,101,112,116,104,41,32,123,10,32,32,32,32,32,32,105,102,40,100,101,
         112,116,104,32,61,61,61,32,48,41,32,123,32,114,101,116,117,114,110,59,32,
         125,10,10,32,32,32,32,32,32,105,102,40,33,116,104,105,115,46,100,101,112,
         116,104,115,91,100,101,112,116,104,93,41,32,123,10,32,32,32,32,32,32,32,
         32,116,104,105,115,46,100,101,112,116,104,115,91,100,101,112,116,104,93,
         32,61,32,116,114,117,101,59,10,32,32,32,32,32,32,32,32,116,104,105,115,
         46,100,101,112,116,104,115,46,108,105,115,116,46,112,117,115,104,40,100,
         101,112,116,104,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,
         10,32,32,32,32,115,101,116,117,112,83,116,97,99,107,70,111,114,77,117,
         115,116,97,99,104,101,58,32,102,117,110,99,116,105,111,110,40,109,117,
         115,116,97,99,104,101,41,32,123,10,32,32,32,32,32,32,118,97,114,32,112,
         97,114,97,109,115,32,61,32,109,117,115,116,97,99,104,101,46,112,97,114,
         97,109,115,59,10,10,32,32,32,32,32,32,116,104,105,115,46,112,117,115,104,
         80,97,114,97,109,115,40,112,97,114,97,109,115,41,59,10,10,32,32,32,32,32,
         32,105,102,40,109,117,115,116,97,99,104,101,46,104,97,115,104,41,32,123,
         10,32,32,32,32,32,32,32,32,116,104,105,115,46,104,97,115,104,40,109,117,
         115,116,97,99,104,101,46,104,97,115,104,41,59,10,32,32,32,32,32,32,125,
         10,10,32,32,32,32,32,32,116,104,105,115,46,73,68,40,109,117,115,116,97,
         99,104,101,46,105,100,41,59,10,10,32,32,32,32,32,32,114,101,116,117,114,
         110,32,112,97,114,97,109,115,59,10,32,32,32,32,125,10,32,32,125,59,10,10,
         32,32,74,97,118,97,83,99,114,105,112,116,67,111,109,112,105,108,101,114,
         46,112,114,111,116,111,116,121,112,101,32,61,32,123,10,32,32,32,32,47,47,
         32,80,85,66,76,73,67,32,65,80,73,58,32,89,111,117,32,99,97,110,32,111,
         118,101,114,114,105,100,101,32,116,104,101,115,101,32,109,101,116,104,
         111,100,115,32,105,110,32,97,32,115,117,98,99,108,97,115,115,32,116,111,
         32,112,114,111,118,105,100,101,10,32,32,32,32,47,47,32,97,108,116,101,
         114,110,97,116,105,118,101,32,99,111,109,112,105,108,101,100,32,102,111,
         114,109,115,32,102,111,114,32,110,97,109,101,32,108,111,111,107,117,112,
         32,97,110,100,32,98,117,102,102,101,114,105,110,103,32,115,101,109,97,
         110,116,105,99,115,10,32,32,32,32,110,97,109,101,76,111,111,107,117,112,
         58,32,102,117,110,99,116,105,111,110,40,112,97,114,101,110,116,44,32,110,
         97,109,101,44,32,116,121,112,101,41,32,123,10,9,9,9,105,102,32,40,47,94,
         91,48,45,57,93,43,36,47,46,116,101,115,116,40,110,97,109,101,41,41,32,
         123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,112,97,114,101,
         110,116,32,43,32,34,91,34,32,43,32,110,97,109,101,32,43,32,34,93,34,59,
         10,32,32,32,32,32,32,125,32,101,108,115,101,32,105,102,32,40,74,97,118,
         97,83,99,114,105,112,116,67,111,109,112,105,108,101,114,46,105,115,86,97,
         108,105,100,74,97,118,97,83,99,114,105,112,116,86,97,114,105,97,98,108,
         101,78,97,109,101,40,110,97,109,101,41,41,32,123,10,9,32,32,32,32,9,114,
         101,116,117,114,110,32,112,97,114,101,110,116,32,43,32,34,46,34,32,43,32,
         110,97,109,101,59,10,9,9,9,125,10,9,9,9,101,108,115,101,32,123,10,9,9,9,
         9,114,101,116,117,114,110,32,112,97,114,101,110,116,32,43,32,34,91,39,34,
         32,43,32,110,97,109,101,32,43,32,34,39,93,34,59,10,32,32,32,32,32,32,125,
         10,32,32,32,32,125,44,10,10,32,32,32,32,97,112,112,101,110,100,84,111,66,
         117,102,102,101,114,58,32,102,117,110,99,116,105,111,110,40,115,116,114,
         105,110,103,41,32,123,10,32,32,32,32,32,32,105,102,32,40,116,104,105,115,
         46,101,110,118,105,114,111,110,109,101,110,116,46,105,115,83,105,109,112,
         108,101,41,32,123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,
         34,114,101,116,117,114,110,32,34,32,43,32,115,116,114,105,110,103,32,43,
         32,34,59,34,59,10,32,32,32,32,32,32,125,32,101,108,115,101,32,123,10,32,
         32,32,32,32,32,32,32,114,101,116,117,114,110,32,34,98,117,102,102,101,
         114,32,43,61,32,34,32,43,32,115,116,114,105,110,103,32,43,32,34,59,34,59,
         10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,10,32,32,32,32,105,110,
         105,116,105,97,108,105,122,101,66,117,102,102,101,114,58,32,102,117,110,
         99,116,105,111,110,40,41,32,123,10,32,32,32,32,32,32,114,101,116,117,114,
         110,32,116,104,105,115,46,113,117,111,116,101,100,83,116,114,105,110,103,
         40,34,34,41,59,10,32,32,32,32,125,44,10,32,32,32,32,47,47,32,69,78,68,32,
         80,85,66,76,73,67,32,65,80,73,10,10,32,32,32,32,99,111,109,112,105,108,
         101,58,32,102,117,110,99,116,105,111,110,40,101,110,118,105,114,111,110,
         109,101,110,116,44,32,111,112,116,105,111,110,115,44,32,99,111,110,116,
         101,120,116,44,32,97,115,79,98,106,101,99,116,41,32,123,10,32,32,32,32,
         32,32,116,104,105,115,46,101,110,118,105,114,111,110,109,101,110,116,32,
         61,32,101,110,118,105,114,111,110,109,101,110,116,59,10,32,32,32,32,32,
         32,116,104,105,115,46,111,112,116,105,111,110,115,32,61,32,111,112,116,
         105,111,110,115,32,124,124,32,123,125,59,10,10,32,32,32,32,32,32,116,104,
         105,115,46,110,97,109,101,32,61,32,116,104,105,115,46,101,110,118,105,
         114,111,110,109,101,110,116,46,110,97,109,101,59,10,32,32,32,32,32,32,
         116,104,105,115,46,105,115,67,104,105,108,100,32,61,32,33,33,99,111,110,
         116,101,120,116,59,10,32,32,32,32,32,32,116,104,105,115,46,99,111,110,
         116,101,120,116,32,61,32,99,111,110,116,101,120,116,32,124,124,32,123,10,
         32,32,32,32,32,32,32,32,112,114,111,103,114,97,109,115,58,32,91,93,44,10,
         32,32,32,32,32,32,32,32,97,108,105,97,115,101,115,58,32,123,32,115,101,
         108,102,58,32,39,116,104,105,115,39,32,125,44,10,32,32,32,32,32,32,32,32,
         114,101,103,105,115,116,101,114,115,58,32,123,108,105,115,116,58,32,91,
         93,125,10,32,32,32,32,32,32,125,59,10,10,32,32,32,32,32,32,116,104,105,
         115,46,112,114,101,97,109,98,108,101,40,41,59,10,10,32,32,32,32,32,32,
         116,104,105,115,46,115,116,97,99,107,83,108,111,116,32,61,32,48,59,10,32,
         32,32,32,32,32,116,104,105,115,46,115,116,97,99,107,86,97,114,115,32,61,
         32,91,93,59,10,10,32,32,32,32,32,32,116,104,105,115,46,99,111,109,112,
         105,108,101,67,104,105,108,100,114,101,110,40,101,110,118,105,114,111,
         110,109,101,110,116,44,32,111,112,116,105,111,110,115,41,59,10,10,32,32,
         32,32,32,32,118,97,114,32,111,112,99,111,100,101,115,32,61,32,101,110,
         118,105,114,111,110,109,101,110,116,46,111,112,99,111,100,101,115,44,32,
         111,112,99,111,100,101,59,10,10,32,32,32,32,32,32,116,104,105,115,46,105,
         32,61,32,48,59,10,10,32,32,32,32,32,32,102,111,114,40,108,61,111,112,99,
         111,100,101,115,46,108,101,110,103,116,104,59,32,116,104,105,115,46,105,
         60,108,59,32,116,104,105,115,46,105,43,43,41,32,123,10,32,32,32,32,32,32,
         32,32,111,112,99,111,100,101,32,61,32,116,104,105,115,46,110,101,120,116,
         79,112,99,111,100,101,40,48,41,59,10,10,32,32,32,32,32,32,32,32,105,102,
         40,111,112,99,111,100,101,91,48,93,32,61,61,61,32,39,68,69,67,76,65,82,
         69,39,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,105,
         32,61,32,116,104,105,115,46,105,32,43,32,50,59,10,32,32,32,32,32,32,32,
         32,32,32,116,104,105,115,91,111,112,99,111,100,101,91,49,93,93,32,61,32,
         111,112,99,111,100,101,91,50,93,59,10,32,32,32,32,32,32,32,32,125,32,101,
         108,115,101,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,
         105,32,61,32,116,104,105,115,46,105,32,43,32,111,112,99,111,100,101,91,
         49,93,46,108,101,110,103,116,104,59,10,32,32,32,32,32,32,32,32,32,32,116,
         104,105,115,91,111,112,99,111,100,101,91,48,93,93,46,97,112,112,108,121,
         40,116,104,105,115,44,32,111,112,99,111,100,101,91,49,93,41,59,10,32,32,
         32,32,32,32,32,32,125,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,
         114,101,116,117,114,110,32,116,104,105,115,46,99,114,101,97,116,101,70,
         117,110,99,116,105,111,110,67,111,110,116,101,120,116,40,97,115,79,98,
         106,101,99,116,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,110,101,120,
         116,79,112,99,111,100,101,58,32,102,117,110,99,116,105,111,110,40,110,41,
         32,123,10,32,32,32,32,32,32,118,97,114,32,111,112,99,111,100,101,115,32,
         61,32,116,104,105,115,46,101,110,118,105,114,111,110,109,101,110,116,46,
         111,112,99,111,100,101,115,44,32,111,112,99,111,100,101,32,61,32,111,112,
         99,111,100,101,115,91,116,104,105,115,46,105,32,43,32,110,93,44,32,110,
         97,109,101,44,32,118,97,108,59,10,32,32,32,32,32,32,118,97,114,32,101,
         120,116,114,97,80,97,114,97,109,115,44,32,99,111,100,101,115,59,10,10,32,
         32,32,32,32,32,105,102,40,111,112,99,111,100,101,32,61,61,61,32,39,68,69,
         67,76,65,82,69,39,41,32,123,10,32,32,32,32,32,32,32,32,110,97,109,101,32,
         61,32,111,112,99,111,100,101,115,91,116,104,105,115,46,105,32,43,32,49,
         93,59,10,32,32,32,32,32,32,32,32,118,97,108,32,32,61,32,111,112,99,111,
         100,101,115,91,116,104,105,115,46,105,32,43,32,50,93,59,10,32,32,32,32,
         32,32,32,32,114,101,116,117,114,110,32,91,39,68,69,67,76,65,82,69,39,44,
         32,110,97,109,101,44,32,118,97,108,93,59,10,32,32,32,32,32,32,125,32,101,
         108,115,101,32,123,10,32,32,32,32,32,32,32,32,110,97,109,101,32,61,32,67,
         111,109,112,105,108,101,114,46,68,73,83,65,83,83,69,77,66,76,69,95,77,65,
         80,91,111,112,99,111,100,101,93,59,10,10,32,32,32,32,32,32,32,32,101,120,
         116,114,97,80,97,114,97,109,115,32,61,32,67,111,109,112,105,108,101,114,
         46,109,117,108,116,105,80,97,114,97,109,83,105,122,101,40,111,112,99,111,
         100,101,41,59,10,32,32,32,32,32,32,32,32,99,111,100,101,115,32,61,32,91,
         93,59,10,10,32,32,32,32,32,32,32,32,102,111,114,40,118,97,114,32,106,61,
         48,59,32,106,60,101,120,116,114,97,80,97,114,97,109,115,59,32,106,43,43,
         41,32,123,10,32,32,32,32,32,32,32,32,32,32,99,111,100,101,115,46,112,117,
         115,104,40,111,112,99,111,100,101,115,91,116,104,105,115,46,105,32,43,32,
         106,32,43,32,49,32,43,32,110,93,41,59,10,32,32,32,32,32,32,32,32,125,10,
         10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,91,110,97,109,101,
         44,32,99,111,100,101,115,93,59,10,32,32,32,32,32,32,125,10,32,32,32,32,
         125,44,10,10,32,32,32,32,101,97,116,58,32,102,117,110,99,116,105,111,110,
         40,111,112,99,111,100,101,41,32,123,10,32,32,32,32,32,32,116,104,105,115,
         46,105,32,61,32,116,104,105,115,46,105,32,43,32,111,112,99,111,100,101,
         46,108,101,110,103,116,104,59,10,32,32,32,32,125,44,10,10,32,32,32,32,
         112,114,101,97,109,98,108,101,58,32,102,117,110,99,116,105,111,110,40,41,
         32,123,10,32,32,32,32,32,32,118,97,114,32,111,117,116,32,61,32,91,93,59,
         10,10,32,32,32,32,32,32,105,102,32,40,33,116,104,105,115,46,105,115,67,
         104,105,108,100,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,99,
         111,112,105,101,115,32,61,32,34,104,101,108,112,101,114,115,32,61,32,104,
         101,108,112,101,114,115,32,124,124,32,72,97,110,100,108,101,98,97,114,
         115,46,104,101,108,112,101,114,115,59,34,59,10,32,32,32,32,32,32,32,32,
         105,102,40,116,104,105,115,46,101,110,118,105,114,111,110,109,101,110,
         116,46,117,115,101,80,97,114,116,105,97,108,41,32,123,32,99,111,112,105,
         101,115,32,61,32,99,111,112,105,101,115,32,43,32,34,32,112,97,114,116,
         105,97,108,115,32,61,32,112,97,114,116,105,97,108,115,32,124,124,32,72,
         97,110,100,108,101,98,97,114,115,46,112,97,114,116,105,97,108,115,59,34,
         59,32,125,10,32,32,32,32,32,32,32,32,111,117,116,46,112,117,115,104,40,
         99,111,112,105,101,115,41,59,10,32,32,32,32,32,32,125,32,101,108,115,101,
         32,123,10,32,32,32,32,32,32,32,32,111,117,116,46,112,117,115,104,40,39,
         39,41,59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,105,102,32,40,
         33,116,104,105,115,46,101,110,118,105,114,111,110,109,101,110,116,46,105,
         115,83,105,109,112,108,101,41,32,123,10,32,32,32,32,32,32,32,32,111,117,
         116,46,112,117,115,104,40,34,44,32,98,117,102,102,101,114,32,61,32,34,32,
         43,32,116,104,105,115,46,105,110,105,116,105,97,108,105,122,101,66,117,
         102,102,101,114,40,41,41,59,10,32,32,32,32,32,32,125,32,101,108,115,101,
         32,123,10,32,32,32,32,32,32,32,32,111,117,116,46,112,117,115,104,40,34,
         34,41,59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,47,47,32,116,
         114,97,99,107,32,116,104,101,32,108,97,115,116,32,99,111,110,116,101,120,
         116,32,112,117,115,104,101,100,32,105,110,116,111,32,112,108,97,99,101,
         32,116,111,32,97,108,108,111,119,32,115,107,105,112,112,105,110,103,32,
         116,104,101,10,32,32,32,32,32,32,47,47,32,103,101,116,67,111,110,116,101,
         120,116,32,111,112,99,111,100,101,32,119,104,101,110,32,105,116,32,119,
         111,117,108,100,32,98,101,32,97,32,110,111,111,112,10,32,32,32,32,32,32,
         116,104,105,115,46,108,97,115,116,67,111,110,116,101,120,116,32,61,32,48,
         59,10,32,32,32,32,32,32,116,104,105,115,46,115,111,117,114,99,101,32,61,
         32,111,117,116,59,10,32,32,32,32,125,44,10,10,32,32,32,32,99,114,101,97,
         116,101,70,117,110,99,116,105,111,110,67,111,110,116,101,120,116,58,32,
         102,117,110,99,116,105,111,110,40,97,115,79,98,106,101,99,116,41,32,123,
         10,32,32,32,32,32,32,118,97,114,32,108,111,99,97,108,115,32,61,32,116,
         104,105,115,46,115,116,97,99,107,86,97,114,115,59,10,32,32,32,32,32,32,
         105,102,32,40,33,116,104,105,115,46,105,115,67,104,105,108,100,41,32,123,
         10,32,32,32,32,32,32,32,32,108,111,99,97,108,115,32,61,32,108,111,99,97,
         108,115,46,99,111,110,99,97,116,40,116,104,105,115,46,99,111,110,116,101,
         120,116,46,114,101,103,105,115,116,101,114,115,46,108,105,115,116,41,59,
         10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,105,102,40,108,111,99,
         97,108,115,46,108,101,110,103,116,104,32,62,32,48,41,32,123,10,32,32,32,
         32,32,32,32,32,116,104,105,115,46,115,111,117,114,99,101,91,49,93,32,61,
         32,116,104,105,115,46,115,111,117,114,99,101,91,49,93,32,43,32,34,44,32,
         34,32,43,32,108,111,99,97,108,115,46,106,111,105,110,40,34,44,32,34,41,
         59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,47,47,32,71,101,110,
         101,114,97,116,101,32,109,105,110,105,109,105,122,101,114,32,97,108,105,
         97,115,32,109,97,112,112,105,110,103,115,10,32,32,32,32,32,32,105,102,32,
         40,33,116,104,105,115,46,105,115,67,104,105,108,100,41,32,123,10,32,32,
         32,32,32,32,32,32,118,97,114,32,97,108,105,97,115,101,115,32,61,32,91,93,
         10,32,32,32,32,32,32,32,32,102,111,114,32,40,118,97,114,32,97,108,105,97,
         115,32,105,110,32,116,104,105,115,46,99,111,110,116,101,120,116,46,97,
         108,105,97,115,101,115,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,
         104,105,115,46,115,111,117,114,99,101,91,49,93,32,61,32,116,104,105,115,
         46,115,111,117,114,99,101,91,49,93,32,43,32,39,44,32,39,32,43,32,97,108,
         105,97,115,32,43,32,39,61,39,32,43,32,116,104,105,115,46,99,111,110,116,
         101,120,116,46,97,108,105,97,115,101,115,91,97,108,105,97,115,93,59,10,
         32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,125,10,10,32,32,32,32,
         32,32,105,102,32,40,116,104,105,115,46,115,111,117,114,99,101,91,49,93,
         41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,115,111,117,114,
         99,101,91,49,93,32,61,32,34,118,97,114,32,34,32,43,32,116,104,105,115,46,
         115,111,117,114,99,101,91,49,93,46,115,117,98,115,116,114,105,110,103,40,
         50,41,32,43,32,34,59,34,59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,
         32,47,47,32,77,101,114,103,101,32,99,104,105,108,100,114,101,110,10,32,
         32,32,32,32,32,105,102,32,40,33,116,104,105,115,46,105,115,67,104,105,
         108,100,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,115,111,
         117,114,99,101,91,49,93,32,43,61,32,39,92,110,39,32,43,32,116,104,105,
         115,46,99,111,110,116,101,120,116,46,112,114,111,103,114,97,109,115,46,
         106,111,105,110,40,39,92,110,39,41,32,43,32,39,92,110,39,59,10,32,32,32,
         32,32,32,125,10,10,32,32,32,32,32,32,105,102,32,40,33,116,104,105,115,46,
         101,110,118,105,114,111,110,109,101,110,116,46,105,115,83,105,109,112,
         108,101,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,115,111,
         117,114,99,101,46,112,117,115,104,40,34,114,101,116,117,114,110,32,98,
         117,102,102,101,114,59,34,41,59,10,32,32,32,32,32,32,125,10,10,32,32,32,
         32,32,32,118,97,114,32,112,97,114,97,109,115,32,61,32,116,104,105,115,46,
         105,115,67,104,105,108,100,32,63,32,91,34,100,101,112,116,104,48,34,44,
         32,34,100,97,116,97,34,93,32,58,32,91,34,72,97,110,100,108,101,98,97,114,
         115,34,44,32,34,100,101,112,116,104,48,34,44,32,34,104,101,108,112,101,
         114,115,34,44,32,34,112,97,114,116,105,97,108,115,34,44,32,34,100,97,116,
         97,34,93,59,10,10,32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,
         48,44,32,108,61,116,104,105,115,46,101,110,118,105,114,111,110,109,101,
         110,116,46,100,101,112,116,104,115,46,108,105,115,116,46,108,101,110,103,
         116,104,59,32,105,60,108,59,32,105,43,43,41,32,123,10,32,32,32,32,32,32,
         32,32,112,97,114,97,109,115,46,112,117,115,104,40,34,100,101,112,116,104,
         34,32,43,32,116,104,105,115,46,101,110,118,105,114,111,110,109,101,110,
         116,46,100,101,112,116,104,115,46,108,105,115,116,91,105,93,41,59,10,32,
         32,32,32,32,32,125,10,10,32,32,32,32,32,32,105,102,40,112,97,114,97,109,
         115,46,108,101,110,103,116,104,32,61,61,61,32,52,32,38,38,32,33,116,104,
         105,115,46,101,110,118,105,114,111,110,109,101,110,116,46,117,115,101,80,
         97,114,116,105,97,108,41,32,123,32,112,97,114,97,109,115,46,112,111,112,
         40,41,59,32,125,10,10,32,32,32,32,32,32,105,102,32,40,97,115,79,98,106,
         101,99,116,41,32,123,10,32,32,32,32,32,32,32,32,112,97,114,97,109,115,46,
         112,117,115,104,40,116,104,105,115,46,115,111,117,114,99,101,46,106,111,
         105,110,40,34,92,110,32,32,34,41,41,59,10,10,32,32,32,32,32,32,32,32,114,
         101,116,117,114,110,32,70,117,110,99,116,105,111,110,46,97,112,112,108,
         121,40,116,104,105,115,44,32,112,97,114,97,109,115,41,59,10,32,32,32,32,
         32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,118,97,
         114,32,102,117,110,99,116,105,111,110,83,111,117,114,99,101,32,61,32,39,
         102,117,110,99,116,105,111,110,32,39,32,43,32,40,116,104,105,115,46,110,
         97,109,101,32,124,124,32,39,39,41,32,43,32,39,40,39,32,43,32,112,97,114,
         97,109,115,46,106,111,105,110,40,39,44,39,41,32,43,32,39,41,32,123,92,
         110,32,32,39,32,43,32,116,104,105,115,46,115,111,117,114,99,101,46,106,
         111,105,110,40,34,92,110,32,32,34,41,32,43,32,39,125,39,59,10,32,32,32,
         32,32,32,32,32,72,97,110,100,108,101,98,97,114,115,46,108,111,103,40,72,
         97,110,100,108,101,98,97,114,115,46,108,111,103,103,101,114,46,68,69,66,
         85,71,44,32,102,117,110,99,116,105,111,110,83,111,117,114,99,101,32,43,
         32,34,92,110,92,110,34,41,59,10,32,32,32,32,32,32,32,32,114,101,116,117,
         114,110,32,102,117,110,99,116,105,111,110,83,111,117,114,99,101,59,10,32,
         32,32,32,32,32,125,10,32,32,32,32,125,44,10,10,32,32,32,32,97,112,112,
         101,110,100,67,111,110,116,101,110,116,58,32,102,117,110,99,116,105,111,
         110,40,99,111,110,116,101,110,116,41,32,123,10,32,32,32,32,32,32,116,104,
         105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,116,104,105,115,
         46,97,112,112,101,110,100,84,111,66,117,102,102,101,114,40,116,104,105,
         115,46,113,117,111,116,101,100,83,116,114,105,110,103,40,99,111,110,116,
         101,110,116,41,41,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,97,112,
         112,101,110,100,58,32,102,117,110,99,116,105,111,110,40,41,32,123,10,32,
         32,32,32,32,32,118,97,114,32,108,111,99,97,108,32,61,32,116,104,105,115,
         46,112,111,112,83,116,97,99,107,40,41,59,10,32,32,32,32,32,32,116,104,
         105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,34,105,102,40,34,
         32,43,32,108,111,99,97,108,32,43,32,34,32,124,124,32,34,32,43,32,108,111,
         99,97,108,32,43,32,34,32,61,61,61,32,48,41,32,123,32,34,32,43,32,116,104,
         105,115,46,97,112,112,101,110,100,84,111,66,117,102,102,101,114,40,108,
         111,99,97,108,41,32,43,32,34,32,125,34,41,59,10,32,32,32,32,32,32,105,
         102,32,40,116,104,105,115,46,101,110,118,105,114,111,110,109,101,110,116,
         46,105,115,83,105,109,112,108,101,41,32,123,10,32,32,32,32,32,32,32,32,
         116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,34,101,
         108,115,101,32,123,32,34,32,43,32,116,104,105,115,46,97,112,112,101,110,
         100,84,111,66,117,102,102,101,114,40,34,39,39,34,41,32,43,32,34,32,125,
         34,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,10,32,32,32,
         32,97,112,112,101,110,100,69,115,99,97,112,101,100,58,32,102,117,110,99,
         116,105,111,110,40,41,32,123,10,32,32,32,32,32,32,118,97,114,32,111,112,
         99,111,100,101,32,61,32,116,104,105,115,46,110,101,120,116,79,112,99,111,
         100,101,40,49,41,44,32,101,120,116,114,97,32,61,32,34,34,59,10,32,32,32,
         32,32,32,116,104,105,115,46,99,111,110,116,101,120,116,46,97,108,105,97,
         115,101,115,46,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,
         110,32,61,32,39,116,104,105,115,46,101,115,99,97,112,101,69,120,112,114,
         101,115,115,105,111,110,39,59,10,10,32,32,32,32,32,32,105,102,40,111,112,
         99,111,100,101,91,48,93,32,61,61,61,32,39,97,112,112,101,110,100,67,111,
         110,116,101,110,116,39,41,32,123,10,32,32,32,32,32,32,32,32,101,120,116,
         114,97,32,61,32,34,32,43,32,34,32,43,32,116,104,105,115,46,113,117,111,
         116,101,100,83,116,114,105,110,103,40,111,112,99,111,100,101,91,49,93,91,
         48,93,41,59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,101,97,116,40,
         111,112,99,111,100,101,41,59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,
         32,32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,
         116,104,105,115,46,97,112,112,101,110,100,84,111,66,117,102,102,101,114,
         40,34,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,34,
         32,43,32,116,104,105,115,46,112,111,112,83,116,97,99,107,40,41,32,43,32,
         34,41,34,32,43,32,101,120,116,114,97,41,41,59,10,32,32,32,32,125,44,10,
         10,32,32,32,32,103,101,116,67,111,110,116,101,120,116,58,32,102,117,110,
         99,116,105,111,110,40,100,101,112,116,104,41,32,123,10,32,32,32,32,32,32,
         105,102,40,116,104,105,115,46,108,97,115,116,67,111,110,116,101,120,116,
         32,33,61,61,32,100,101,112,116,104,41,32,123,10,32,32,32,32,32,32,32,32,
         116,104,105,115,46,108,97,115,116,67,111,110,116,101,120,116,32,61,32,
         100,101,112,116,104,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,
         10,32,32,32,32,108,111,111,107,117,112,87,105,116,104,72,101,108,112,101,
         114,115,58,32,102,117,110,99,116,105,111,110,40,110,97,109,101,44,32,105,
         115,83,99,111,112,101,100,41,32,123,10,32,32,32,32,32,32,105,102,40,110,
         97,109,101,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,116,111,
         112,83,116,97,99,107,32,61,32,116,104,105,115,46,110,101,120,116,83,116,
         97,99,107,40,41,59,10,10,32,32,32,32,32,32,32,32,116,104,105,115,46,117,
         115,105,110,103,75,110,111,119,110,72,101,108,112,101,114,32,61,32,102,
         97,108,115,101,59,10,10,32,32,32,32,32,32,32,32,118,97,114,32,116,111,80,
         117,115,104,59,10,32,32,32,32,32,32,32,32,105,102,32,40,33,105,115,83,99,
         111,112,101,100,32,38,38,32,116,104,105,115,46,111,112,116,105,111,110,
         115,46,107,110,111,119,110,72,101,108,112,101,114,115,91,110,97,109,101,
         93,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,111,80,117,115,104,32,
         61,32,116,111,112,83,116,97,99,107,32,43,32,34,32,61,32,34,32,43,32,116,
         104,105,115,46,110,97,109,101,76,111,111,107,117,112,40,39,104,101,108,
         112,101,114,115,39,44,32,110,97,109,101,44,32,39,104,101,108,112,101,114,
         39,41,59,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,117,115,105,
         110,103,75,110,111,119,110,72,101,108,112,101,114,32,61,32,116,114,117,
         101,59,10,32,32,32,32,32,32,32,32,125,32,101,108,115,101,32,105,102,32,
         40,105,115,83,99,111,112,101,100,32,124,124,32,116,104,105,115,46,111,
         112,116,105,111,110,115,46,107,110,111,119,110,72,101,108,112,101,114,
         115,79,110,108,121,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,111,80,
         117,115,104,32,61,32,116,111,112,83,116,97,99,107,32,43,32,34,32,61,32,
         34,32,43,32,116,104,105,115,46,110,97,109,101,76,111,111,107,117,112,40,
         39,100,101,112,116,104,39,32,43,32,116,104,105,115,46,108,97,115,116,67,
         111,110,116,101,120,116,44,32,110,97,109,101,44,32,39,99,111,110,116,101,
         120,116,39,41,59,10,32,32,32,32,32,32,32,32,125,32,101,108,115,101,32,
         123,10,32,32,32,32,32,32,32,32,32,32,116,111,80,117,115,104,32,61,32,32,
         116,111,112,83,116,97,99,107,32,43,32,34,32,61,32,34,10,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,43,32,116,104,105,115,46,110,97,109,101,76,
         111,111,107,117,112,40,39,104,101,108,112,101,114,115,39,44,32,110,97,
         109,101,44,32,39,104,101,108,112,101,114,39,41,10,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,43,32,34,32,124,124,32,34,10,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,43,32,116,104,105,115,46,110,97,109,101,76,111,111,
         107,117,112,40,39,100,101,112,116,104,39,32,43,32,116,104,105,115,46,108,
         97,115,116,67,111,110,116,101,120,116,44,32,110,97,109,101,44,32,39,99,
         111,110,116,101,120,116,39,41,59,10,32,32,32,32,32,32,32,32,125,10,32,32,
         32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,116,111,80,117,115,104,32,
         43,61,32,39,59,39,59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,115,
         111,117,114,99,101,46,112,117,115,104,40,116,111,80,117,115,104,41,59,10,
         32,32,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,
         32,116,104,105,115,46,112,117,115,104,83,116,97,99,107,40,39,100,101,112,
         116,104,39,32,43,32,116,104,105,115,46,108,97,115,116,67,111,110,116,101,
         120,116,41,59,10,32,32,32,32,32,32,125,10,32,32,32,32,125,44,10,10,32,32,
         32,32,108,111,111,107,117,112,58,32,102,117,110,99,116,105,111,110,40,
         110,97,109,101,41,32,123,10,32,32,32,32,32,32,118,97,114,32,116,111,112,
         83,116,97,99,107,32,61,32,116,104,105,115,46,116,111,112,83,116,97,99,
         107,40,41,59,10,32,32,32,32,32,32,116,104,105,115,46,115,111,117,114,99,
         101,46,112,117,115,104,40,116,111,112,83,116,97,99,107,32,43,32,34,32,61,
         32,40,34,32,43,32,116,111,112,83,116,97,99,107,32,43,32,34,32,61,61,61,
         32,110,117,108,108,32,124,124,32,34,32,43,32,116,111,112,83,116,97,99,
         107,32,43,32,34,32,61,61,61,32,117,110,100,101,102,105,110,101,100,32,
         124,124,32,34,32,43,32,116,111,112,83,116,97,99,107,32,43,32,34,32,61,61,
         61,32,102,97,108,115,101,32,63,32,34,32,43,10,32,9,9,9,9,116,111,112,83,
         116,97,99,107,32,43,32,34,32,58,32,34,32,43,32,116,104,105,115,46,110,97,
         109,101,76,111,111,107,117,112,40,116,111,112,83,116,97,99,107,44,32,110,
         97,109,101,44,32,39,99,111,110,116,101,120,116,39,41,32,43,32,34,41,59,
         34,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,112,117,115,104,83,116,
         114,105,110,103,80,97,114,97,109,58,32,102,117,110,99,116,105,111,110,40,
         115,116,114,105,110,103,41,32,123,10,32,32,32,32,32,32,116,104,105,115,
         46,112,117,115,104,83,116,97,99,107,40,39,100,101,112,116,104,39,32,43,
         32,116,104,105,115,46,108,97,115,116,67,111,110,116,101,120,116,41,59,10,
         32,32,32,32,32,32,116,104,105,115,46,112,117,115,104,83,116,114,105,110,
         103,40,115,116,114,105,110,103,41,59,10,32,32,32,32,125,44,10,10,32,32,
         32,32,112,117,115,104,83,116,114,105,110,103,58,32,102,117,110,99,116,
         105,111,110,40,115,116,114,105,110,103,41,32,123,10,32,32,32,32,32,32,
         116,104,105,115,46,112,117,115,104,83,116,97,99,107,40,116,104,105,115,
         46,113,117,111,116,101,100,83,116,114,105,110,103,40,115,116,114,105,110,
         103,41,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,112,117,115,104,58,
         32,102,117,110,99,116,105,111,110,40,110,97,109,101,41,32,123,10,32,32,
         32,32,32,32,116,104,105,115,46,112,117,115,104,83,116,97,99,107,40,110,
         97,109,101,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,105,110,118,111,
         107,101,77,117,115,116,97,99,104,101,58,32,102,117,110,99,116,105,111,
         110,40,112,97,114,97,109,83,105,122,101,44,32,111,114,105,103,105,110,97,
         108,44,32,104,97,115,72,97,115,104,41,32,123,10,32,32,32,32,32,32,116,
         104,105,115,46,112,111,112,117,108,97,116,101,80,97,114,97,109,115,40,
         112,97,114,97,109,83,105,122,101,44,32,116,104,105,115,46,113,117,111,
         116,101,100,83,116,114,105,110,103,40,111,114,105,103,105,110,97,108,41,
         44,32,34,123,125,34,44,32,110,117,108,108,44,32,104,97,115,72,97,115,104,
         44,32,102,117,110,99,116,105,111,110,40,110,101,120,116,83,116,97,99,107,
         44,32,104,101,108,112,101,114,77,105,115,115,105,110,103,83,116,114,105,
         110,103,44,32,105,100,41,32,123,10,32,32,32,32,32,32,32,32,105,102,32,40,
         33,116,104,105,115,46,117,115,105,110,103,75,110,111,119,110,72,101,108,
         112,101,114,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,
         46,99,111,110,116,101,120,116,46,97,108,105,97,115,101,115,46,104,101,
         108,112,101,114,77,105,115,115,105,110,103,32,61,32,39,104,101,108,112,
         101,114,115,46,104,101,108,112,101,114,77,105,115,115,105,110,103,39,59,
         10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,116,101,
         120,116,46,97,108,105,97,115,101,115,46,117,110,100,101,102,32,61,32,39,
         118,111,105,100,32,48,39,59,10,32,32,32,32,32,32,32,32,32,32,116,104,105,
         115,46,115,111,117,114,99,101,46,112,117,115,104,40,34,101,108,115,101,
         32,105,102,40,34,32,43,32,105,100,32,43,32,34,61,61,61,32,117,110,100,
         101,102,41,32,123,32,34,32,43,32,110,101,120,116,83,116,97,99,107,32,43,
         32,34,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,
         97,108,108,40,34,32,43,32,104,101,108,112,101,114,77,105,115,115,105,110,
         103,83,116,114,105,110,103,32,43,32,34,41,59,32,125,34,41,59,10,32,32,32,
         32,32,32,32,32,32,32,105,102,32,40,110,101,120,116,83,116,97,99,107,32,
         33,61,61,32,105,100,41,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,116,
         104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,34,101,108,
         115,101,32,123,32,34,32,43,32,110,101,120,116,83,116,97,99,107,32,43,32,
         34,32,61,32,34,32,43,32,105,100,32,43,32,34,59,32,125,34,41,59,10,32,32,
         32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,125,10,32,32,32,
         32,32,32,125,41,59,10,32,32,32,32,125,44,10,10,32,32,32,32,105,110,118,
         111,107,101,80,114,111,103,114,97,109,58,32,102,117,110,99,116,105,111,
         110,40,103,117,105,100,44,32,112,97,114,97,109,83,105,122,101,44,32,104,
         97,115,72,97,115,104,41,32,123,10,32,32,32,32,32,32,118,97,114,32,105,
         110,118,101,114,115,101,32,61,32,116,104,105,115,46,112,114,111,103,114,
         97,109,69,120,112,114,101,115,115,105,111,110,40,116,104,105,115,46,105,
         110,118,101,114,115,101,41,59,10,32,32,32,32,32,32,118,97,114,32,109,97,
         105,110,80,114,111,103,114,97,109,32,61,32,116,104,105,115,46,112,114,
         111,103,114,97,109,69,120,112,114,101,115,115,105,111,110,40,103,117,105,
         100,41,59,10,10,32,32,32,32,32,32,116,104,105,115,46,112,111,112,117,108,
         97,116,101,80,97,114,97,109,115,40,112,97,114,97,109,83,105,122,101,44,
         32,110,117,108,108,44,32,109,97,105,110,80,114,111,103,114,97,109,44,32,
         105,110,118,101,114,115,101,44,32,104,97,115,72,97,115,104,44,32,102,117,
         110,99,116,105,111,110,40,110,101,120,116,83,116,97,99,107,44,32,104,101,
         108,112,101,114,77,105,115,115,105,110,103,83,116,114,105,110,103,44,32,
         105,100,41,32,123,10,32,32,32,32,32,32,32,32,105,102,32,40,33,116,104,
         105,115,46,117,115,105,110,103,75,110,111,119,110,72,101,108,112,101,114,
         41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,
         116,101,120,116,46,97,108,105,97,115,101,115,46,98,108,111,99,107,72,101,
         108,112,101,114,77,105,115,115,105,110,103,32,61,32,39,104,101,108,112,
         101,114,115,46,98,108,111,99,107,72,101,108,112,101,114,77,105,115,115,
         105,110,103,39,59,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,
         115,111,117,114,99,101,46,112,117,115,104,40,34,101,108,115,101,32,123,
         32,34,32,43,32,110,101,120,116,83,116,97,99,107,32,43,32,34,32,61,32,98,
         108,111,99,107,72,101,108,112,101,114,77,105,115,115,105,110,103,46,99,
         97,108,108,40,34,32,43,32,104,101,108,112,101,114,77,105,115,115,105,110,
         103,83,116,114,105,110,103,32,43,32,34,41,59,32,125,34,41,59,10,32,32,32,
         32,32,32,32,32,125,10,32,32,32,32,32,32,125,41,59,10,32,32,32,32,125,44,
         10,10,32,32,32,32,112,111,112,117,108,97,116,101,80,97,114,97,109,115,58,
         32,102,117,110,99,116,105,111,110,40,112,97,114,97,109,83,105,122,101,44,
         32,104,101,108,112,101,114,73,100,44,32,112,114,111,103,114,97,109,44,32,
         105,110,118,101,114,115,101,44,32,104,97,115,72,97,115,104,44,32,102,110,
         41,32,123,10,32,32,32,32,32,32,118,97,114,32,110,101,101,100,115,82,101,
         103,105,115,116,101,114,32,61,32,104,97,115,72,97,115,104,32,124,124,32,
         116,104,105,115,46,111,112,116,105,111,110,115,46,115,116,114,105,110,
         103,80,97,114,97,109,115,32,124,124,32,105,110,118,101,114,115,101,32,
         124,124,32,116,104,105,115,46,111,112,116,105,111,110,115,46,100,97,116,
         97,59,10,32,32,32,32,32,32,118,97,114,32,105,100,32,61,32,116,104,105,
         115,46,112,111,112,83,116,97,99,107,40,41,44,32,110,101,120,116,83,116,
         97,99,107,59,10,32,32,32,32,32,32,118,97,114,32,112,97,114,97,109,115,32,
         61,32,91,93,44,32,112,97,114,97,109,44,32,115,116,114,105,110,103,80,97,
         114,97,109,44,32,115,116,114,105,110,103,79,112,116,105,111,110,115,59,
         10,10,32,32,32,32,32,32,105,102,32,40,110,101,101,100,115,82,101,103,105,
         115,116,101,114,41,32,123,10,32,32,32,32,32,32,32,32,116,104,105,115,46,
         114,101,103,105,115,116,101,114,40,39,116,109,112,49,39,44,32,112,114,
         111,103,114,97,109,41,59,10,32,32,32,32,32,32,32,32,115,116,114,105,110,
         103,79,112,116,105,111,110,115,32,61,32,39,116,109,112,49,39,59,10,32,32,
         32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,115,
         116,114,105,110,103,79,112,116,105,111,110,115,32,61,32,39,123,32,104,97,
         115,104,58,32,123,125,32,125,39,59,10,32,32,32,32,32,32,125,10,10,32,32,
         32,32,32,32,105,102,32,40,110,101,101,100,115,82,101,103,105,115,116,101,
         114,41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,104,97,115,104,32,
         61,32,40,104,97,115,72,97,115,104,32,63,32,116,104,105,115,46,112,111,
         112,83,116,97,99,107,40,41,32,58,32,39,123,125,39,41,59,10,32,32,32,32,
         32,32,32,32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,
         40,39,116,109,112,49,46,104,97,115,104,32,61,32,39,32,43,32,104,97,115,
         104,32,43,32,39,59,39,41,59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,
         32,32,105,102,40,116,104,105,115,46,111,112,116,105,111,110,115,46,115,
         116,114,105,110,103,80,97,114,97,109,115,41,32,123,10,32,32,32,32,32,32,
         32,32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,39,
         116,109,112,49,46,99,111,110,116,101,120,116,115,32,61,32,91,93,59,39,41,
         59,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,102,111,114,40,118,
         97,114,32,105,61,48,59,32,105,60,112,97,114,97,109,83,105,122,101,59,32,
         105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,112,97,114,97,109,32,61,
         32,116,104,105,115,46,112,111,112,83,116,97,99,107,40,41,59,10,32,32,32,
         32,32,32,32,32,112,97,114,97,109,115,46,112,117,115,104,40,112,97,114,97,
         109,41,59,10,10,32,32,32,32,32,32,32,32,105,102,40,116,104,105,115,46,
         111,112,116,105,111,110,115,46,115,116,114,105,110,103,80,97,114,97,109,
         115,41,32,123,10,32,32,32,32,32,32,32,32,32,32,116,104,105,115,46,115,
         111,117,114,99,101,46,112,117,115,104,40,39,116,109,112,49,46,99,111,110,
         116,101,120,116,115,46,112,117,115,104,40,39,32,43,32,116,104,105,115,46,
         112,111,112,83,116,97,99,107,40,41,32,43,32,39,41,59,39,41,59,10,32,32,
         32,32,32,32,32,32,125,10,32,32,32,32,32,32,125,10,10,32,32,32,32,32,32,
         105,102,40,105,110,118,101,114,115,101,41,32,123,10,32,32,32,32,32,32,32,
         32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,39,
         116,109,112,49,46,102,110,32,61,32,116,109,112,49,59,39,41,59,10,32,32,
         32,32,32,32,32,32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,
         115,104,40,39,116,109,112,49,46,105,110,118,101,114,115,101,32,61,32,39,
         32,43,32,105,110,118,101,114,115,101,32,43,32,39,59,39,41,59,10,32,32,32,
         32,32,32,125,10,10,32,32,32,32,32,32,105,102,40,116,104,105,115,46,111,
         112,116,105,111,110,115,46,100,97,116,97,41,32,123,10,32,32,32,32,32,32,
         32,32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,104,40,39,
         116,109,112,49,46,100,97,116,97,32,61,32,100,97,116,97,59,39,41,59,10,32,
         32,32,32,32,32,125,10,10,32,32,32,32,32,32,112,97,114,97,109,115,46,112,
         117,115,104,40,115,116,114,105,110,103,79,112,116,105,111,110,115,41,59,
         10,10,32,32,32,32,32,32,116,104,105,115,46,112,111,112,117,108,97,116,
         101,67,97,108,108,40,112,97,114,97,109,115,44,32,105,100,44,32,104,101,
         108,112,101,114,73,100,32,124,124,32,105,100,44,32,102,110,41,59,10,32,
         32,32,32,125,44,10,10,32,32,32,32,112,111,112,117,108,97,116,101,67,97,
         108,108,58,32,102,117,110,99,116,105,111,110,40,112,97,114,97,109,115,44,
         32,105,100,44,32,104,101,108,112,101,114,73,100,44,32,102,110,41,32,123,
         10,32,32,32,32,32,32,118,97,114,32,112,97,114,97,109,83,116,114,105,110,
         103,32,61,32,91,34,100,101,112,116,104,48,34,93,46,99,111,110,99,97,116,
         40,112,97,114,97,109,115,41,46,106,111,105,110,40,34,44,32,34,41,59,10,
         32,32,32,32,32,32,118,97,114,32,104,101,108,112,101,114,77,105,115,115,
         105,110,103,83,116,114,105,110,103,32,61,32,91,34,100,101,112,116,104,48,
         34,93,46,99,111,110,99,97,116,40,104,101,108,112,101,114,73,100,41,46,99,
         111,110,99,97,116,40,112,97,114,97,109,115,41,46,106,111,105,110,40,34,
         44,32,34,41,59,10,10,32,32,32,32,32,32,118,97,114,32,110,101,120,116,83,
         116,97,99,107,32,61,32,116,104,105,115,46,110,101,120,116,83,116,97,99,
         107,40,41,59,10,10,32,32,32,32,32,32,105,102,32,40,116,104,105,115,46,
         117,115,105,110,103,75,110,111,119,110,72,101,108,112,101,114,41,32,123,
         10,32,32,32,32,32,32,32,32,116,104,105,115,46,115,111,117,114,99,101,46,
         112,117,115,104,40,110,101,120,116,83,116,97,99,107,32,43,32,34,32,61,32,
         34,32,43,32,105,100,32,43,32,34,46,99,97,108,108,40,34,32,43,32,112,97,
         114,97,109,83,116,114,105,110,103,32,43,32,34,41,59,34,41,59,10,32,32,32,
         32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,116,
         104,105,115,46,99,111,110,116,101,120,116,46,97,108,105,97,115,101,115,
         46,102,117,110,99,116,105,111,110,84,121,112,101,32,61,32,39,34,102,117,
         110,99,116,105,111,110,34,39,59,10,32,32,32,32,32,32,32,32,116,104,105,
         115,46,115,111,117,114,99,101,46,112,117,115,104,40,34,105,102,40,116,
         121,112,101,111,102,32,34,32,43,32,105,100,32,43,32,34,32,61,61,61,32,
         102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,32,34,32,43,32,
         110,101,120,116,83,116,97,99,107,32,43,32,34,32,61,32,34,32,43,32,105,
         100,32,43,32,34,46,99,97,108,108,40,34,32,43,32,112,97,114,97,109,83,116,
         114,105,110,103,32,43,32,34,41,59,32,125,34,41,59,10,32,32,32,32,32,32,
         125,10,32,32,32,32,32,32,102,110,46,99,97,108,108,40,116,104,105,115,44,
         32,110,101,120,116,83,116,97,99,107,44,32,104,101,108,112,101,114,77,105,
         115,115,105,110,103,83,116,114,105,110,103,44,32,105,100,41,59,10,32,32,
         32,32,32,32,116,104,105,115,46,117,115,105,110,103,75,110,111,119,110,72,
         101,108,112,101,114,32,61,32,102,97,108,115,101,59,10,32,32,32,32,125,44,
         10,10,32,32,32,32,105,110,118,111,107,101,80,97,114,116,105,97,108,58,32,
         102,117,110,99,116,105,111,110,40,99,111,110,116,101,120,116,41,32,123,
         10,32,32,32,32,32,32,116,104,105,115,46,112,117,115,104,83,116,97,99,107,
         40,34,115,101,108,102,46,105,110,118,111,107,101,80,97,114,116,105,97,
         108,40,34,32,43,32,116,104,105,115,46,110,97,109,101,76,111,111,107,117,
         112,40,39,112,97,114,116,105,97,108,115,39,44,32,99,111,110,116,101,120,
         116,44,32,39,112,97,114,116,105,97,108,39,41,32,43,32,34,44,32,39,34,32,
         43,32,99,111,110,116,101,120,116,32,43,32,34,39,44,32,34,32,43,32,116,
         104,105,115,46,112,111,112,83,116,97,99,107,40,41,32,43,32,34,44,32,104,
         101,108,112,101,114,115,44,32,112,97,114,116,105,97,108,115,41,59,34,41,
         59,10,32,32,32,32,125,44,10,10,32,32,32,32,97,115,115,105,103,110,84,111,
         72,97,115,104,58,32,102,117,110,99,116,105,111,110,40,107,101,121,41,32,
         123,10,32,32,32,32,32,32,118,97,114,32,118,97,108,117,101,32,61,32,116,
         104,105,115,46,112,111,112,83,116,97,99,107,40,41,59,10,32,32,32,32,32,
         32,118,97,114,32,104,97,115,104,32,61,32,116,104,105,115,46,116,111,112,
         83,116,97,99,107,40,41,59,10,10,32,32,32,32,32,32,116,104,105,115,46,115,
         111,117,114,99,101,46,112,117,115,104,40,104,97,115,104,32,43,32,34,91,
         39,34,32,43,32,107,101,121,32,43,32,34,39,93,32,61,32,34,32,43,32,118,97,
         108,117,101,32,43,32,34,59,34,41,59,10,32,32,32,32,125,44,10,10,32,32,32,
         32,47,47,32,72,69,76,80,69,82,83,10,10,32,32,32,32,99,111,109,112,105,
         108,101,114,58,32,74,97,118,97,83,99,114,105,112,116,67,111,109,112,105,
         108,101,114,44,10,10,32,32,32,32,99,111,109,112,105,108,101,67,104,105,
         108,100,114,101,110,58,32,102,117,110,99,116,105,111,110,40,101,110,118,
         105,114,111,110,109,101,110,116,44,32,111,112,116,105,111,110,115,41,32,
         123,10,32,32,32,32,32,32,118,97,114,32,99,104,105,108,100,114,101,110,32,
         61,32,101,110,118,105,114,111,110,109,101,110,116,46,99,104,105,108,100,
         114,101,110,44,32,99,104,105,108,100,44,32,99,111,109,112,105,108,101,
         114,59,10,10,32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,48,44,
         32,108,61,99,104,105,108,100,114,101,110,46,108,101,110,103,116,104,59,
         32,105,60,108,59,32,105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,99,
         104,105,108,100,32,61,32,99,104,105,108,100,114,101,110,91,105,93,59,10,
         32,32,32,32,32,32,32,32,99,111,109,112,105,108,101,114,32,61,32,110,101,
         119,32,116,104,105,115,46,99,111,109,112,105,108,101,114,40,41,59,10,10,
         32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,116,101,120,116,46,
         112,114,111,103,114,97,109,115,46,112,117,115,104,40,39,39,41,59,32,32,
         32,32,32,47,47,32,80,108,97,99,101,104,111,108,100,101,114,32,116,111,32,
         112,114,101,118,101,110,116,32,110,97,109,101,32,99,111,110,102,108,105,
         99,116,115,32,102,111,114,32,110,101,115,116,101,100,32,99,104,105,108,
         100,114,101,110,10,32,32,32,32,32,32,32,32,118,97,114,32,105,110,100,101,
         120,32,61,32,116,104,105,115,46,99,111,110,116,101,120,116,46,112,114,
         111,103,114,97,109,115,46,108,101,110,103,116,104,59,10,32,32,32,32,32,
         32,32,32,99,104,105,108,100,46,105,110,100,101,120,32,61,32,105,110,100,
         101,120,59,10,32,32,32,32,32,32,32,32,99,104,105,108,100,46,110,97,109,
         101,32,61,32,39,112,114,111,103,114,97,109,39,32,43,32,105,110,100,101,
         120,59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,116,101,
         120,116,46,112,114,111,103,114,97,109,115,91,105,110,100,101,120,93,32,
         61,32,99,111,109,112,105,108,101,114,46,99,111,109,112,105,108,101,40,99,
         104,105,108,100,44,32,111,112,116,105,111,110,115,44,32,116,104,105,115,
         46,99,111,110,116,101,120,116,41,59,10,32,32,32,32,32,32,125,10,32,32,32,
         32,125,44,10,10,32,32,32,32,112,114,111,103,114,97,109,69,120,112,114,
         101,115,115,105,111,110,58,32,102,117,110,99,116,105,111,110,40,103,117,
         105,100,41,32,123,10,32,32,32,32,32,32,105,102,40,103,117,105,100,32,61,
         61,32,110,117,108,108,41,32,123,32,114,101,116,117,114,110,32,34,115,101,
         108,102,46,110,111,111,112,34,59,32,125,10,10,32,32,32,32,32,32,118,97,
         114,32,99,104,105,108,100,32,61,32,116,104,105,115,46,101,110,118,105,
         114,111,110,109,101,110,116,46,99,104,105,108,100,114,101,110,91,103,117,
         105,100,93,44,10,32,32,32,32,32,32,32,32,32,32,100,101,112,116,104,115,
         32,61,32,99,104,105,108,100,46,100,101,112,116,104,115,46,108,105,115,
         116,59,10,32,32,32,32,32,32,118,97,114,32,112,114,111,103,114,97,109,80,
         97,114,97,109,115,32,61,32,91,99,104,105,108,100,46,105,110,100,101,120,
         44,32,99,104,105,108,100,46,110,97,109,101,44,32,34,100,97,116,97,34,93,
         59,10,10,32,32,32,32,32,32,102,111,114,40,118,97,114,32,105,61,48,44,32,
         108,32,61,32,100,101,112,116,104,115,46,108,101,110,103,116,104,59,32,
         105,60,108,59,32,105,43,43,41,32,123,10,32,32,32,32,32,32,32,32,100,101,
         112,116,104,32,61,32,100,101,112,116,104,115,91,105,93,59,10,10,32,32,32,
         32,32,32,32,32,105,102,40,100,101,112,116,104,32,61,61,61,32,49,41,32,
         123,32,112,114,111,103,114,97,109,80,97,114,97,109,115,46,112,117,115,
         104,40,34,100,101,112,116,104,48,34,41,59,32,125,10,32,32,32,32,32,32,32,
         32,101,108,115,101,32,123,32,112,114,111,103,114,97,109,80,97,114,97,109,
         115,46,112,117,115,104,40,34,100,101,112,116,104,34,32,43,32,40,100,101,
         112,116,104,32,45,32,49,41,41,59,32,125,10,32,32,32,32,32,32,125,10,10,
         32,32,32,32,32,32,105,102,40,100,101,112,116,104,115,46,108,101,110,103,
         116,104,32,61,61,61,32,48,41,32,123,10,32,32,32,32,32,32,32,32,114,101,
         116,117,114,110,32,34,115,101,108,102,46,112,114,111,103,114,97,109,40,
         34,32,43,32,112,114,111,103,114,97,109,80,97,114,97,109,115,46,106,111,
         105,110,40,34,44,32,34,41,32,43,32,34,41,34,59,10,32,32,32,32,32,32,125,
         32,101,108,115,101,32,123,10,32,32,32,32,32,32,32,32,112,114,111,103,114,
         97,109,80,97,114,97,109,115,46,115,104,105,102,116,40,41,59,10,32,32,32,
         32,32,32,32,32,114,101,116,117,114,110,32,34,115,101,108,102,46,112,114,
         111,103,114,97,109,87,105,116,104,68,101,112,116,104,40,34,32,43,32,112,
         114,111,103,114,97,109,80,97,114,97,109,115,46,106,111,105,110,40,34,44,
         32,34,41,32,43,32,34,41,34,59,10,32,32,32,32,32,32,125,10,32,32,32,32,
         125,44,10,10,32,32,32,32,114,101,103,105,115,116,101,114,58,32,102,117,
         110,99,116,105,111,110,40,110,97,109,101,44,32,118,97,108,41,32,123,10,
         32,32,32,32,32,32,116,104,105,115,46,117,115,101,82,101,103,105,115,116,
         101,114,40,110,97,109,101,41,59,10,32,32,32,32,32,32,116,104,105,115,46,
         115,111,117,114,99,101,46,112,117,115,104,40,110,97,109,101,32,43,32,34,
         32,61,32,34,32,43,32,118,97,108,32,43,32,34,59,34,41,59,10,32,32,32,32,
         125,44,10,10,32,32,32,32,117,115,101,82,101,103,105,115,116,101,114,58,
         32,102,117,110,99,116,105,111,110,40,110,97,109,101,41,32,123,10,32,32,
         32,32,32,32,105,102,40,33,116,104,105,115,46,99,111,110,116,101,120,116,
         46,114,101,103,105,115,116,101,114,115,91,110,97,109,101,93,41,32,123,10,
         32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,116,101,120,116,46,
         114,101,103,105,115,116,101,114,115,91,110,97,109,101,93,32,61,32,116,
         114,117,101,59,10,32,32,32,32,32,32,32,32,116,104,105,115,46,99,111,110,
         116,101,120,116,46,114,101,103,105,115,116,101,114,115,46,108,105,115,
         116,46,112,117,115,104,40,110,97,109,101,41,59,10,32,32,32,32,32,32,125,
         10,32,32,32,32,125,44,10,10,32,32,32,32,112,117,115,104,83,116,97,99,107,
         58,32,102,117,110,99,116,105,111,110,40,105,116,101,109,41,32,123,10,32,
         32,32,32,32,32,116,104,105,115,46,115,111,117,114,99,101,46,112,117,115,
         104,40,116,104,105,115,46,110,101,120,116,83,116,97,99,107,40,41,32,43,
         32,34,32,61,32,34,32,43,32,105,116,101,109,32,43,32,34,59,34,41,59,10,32,
         32,32,32,32,32,114,101,116,117,114,110,32,34,115,116,97,99,107,34,32,43,
         32,116,104,105,115,46,115,116,97,99,107,83,108,111,116,59,10,32,32,32,32,
         125,44,10,10,32,32,32,32,110,101,120,116,83,116,97,99,107,58,32,102,117,
         110,99,116,105,111,110,40,41,32,123,10,32,32,32,32,32,32,116,104,105,115,
         46,115,116,97,99,107,83,108,111,116,43,43,59,10,32,32,32,32,32,32,105,
         102,40,116,104,105,115,46,115,116,97,99,107,83,108,111,116,32,62,32,116,
         104,105,115,46,115,116,97,99,107,86,97,114,115,46,108,101,110,103,116,
         104,41,32,123,32,116,104,105,115,46,115,116,97,99,107,86,97,114,115,46,
         112,117,115,104,40,34,115,116,97,99,107,34,32,43,32,116,104,105,115,46,
         115,116,97,99,107,83,108,111,116,41,59,32,125,10,32,32,32,32,32,32,114,
         101,116,117,114,110,32,34,115,116,97,99,107,34,32,43,32,116,104,105,115,
         46,115,116,97,99,107,83,108,111,116,59,10,32,32,32,32,125,44,10,10,32,32,
         32,32,112,111,112,83,116,97,99,107,58,32,102,117,110,99,116,105,111,110,
         40,41,32,123,10,32,32,32,32,32,32,114,101,116,117,114,110,32,34,115,116,
         97,99,107,34,32,43,32,116,104,105,115,46,115,116,97,99,107,83,108,111,
         116,45,45,59,10,32,32,32,32,125,44,10,10,32,32,32,32,116,111,112,83,116,
         97,99,107,58,32,102,117,110,99,116,105,111,110,40,41,32,123,10,32,32,32,
         32,32,32,114,101,116,117,114,110,32,34,115,116,97,99,107,34,32,43,32,116,
         104,105,115,46,115,116,97,99,107,83,108,111,116,59,10,32,32,32,32,125,44,
         10,10,32,32,32,32,113,117,111,116,101,100,83,116,114,105,110,103,58,32,
         102,117,110,99,116,105,111,110,40,115,116,114,41,32,123,10,32,32,32,32,
         32,32,114,101,116,117,114,110,32,39,34,39,32,43,32,115,116,114,10,32,32,
         32,32,32,32,32,32,46,114,101,112,108,97,99,101,40,47,92,92,47,103,44,32,
         39,92,92,92,92,39,41,10,32,32,32,32,32,32,32,32,46,114,101,112,108,97,99,
         101,40,47,34,47,103,44,32,39,92,92,34,39,41,10,32,32,32,32,32,32,32,32,
         46,114,101,112,108,97,99,101,40,47,92,110,47,103,44,32,39,92,92,110,39,
         41,10,32,32,32,32,32,32,32,32,46,114,101,112,108,97,99,101,40,47,92,114,
         47,103,44,32,39,92,92,114,39,41,32,43,32,39,34,39,59,10,32,32,32,32,125,
         10,32,32,125,59,10,10,32,32,118,97,114,32,114,101,115,101,114,118,101,
         100,87,111,114,100,115,32,61,32,40,34,98,114,101,97,107,32,99,97,115,101,
         32,99,97,116,99,104,32,99,111,110,116,105,110,117,101,32,100,101,102,97,
         117,108,116,32,100,101,108,101,116,101,32,100,111,32,101,108,115,101,32,
         102,105,110,97,108,108,121,32,34,32,43,10,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,34,102,111,114,32,102,117,110,99,
         116,105,111,110,32,105,102,32,105,110,32,105,110,115,116,97,110,99,101,
         111,102,32,110,101,119,32,114,101,116,117,114,110,32,115,119,105,116,99,
         104,32,116,104,105,115,32,116,104,114,111,119,32,34,32,43,32,10,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,34,116,114,
         121,32,116,121,112,101,111,102,32,118,97,114,32,118,111,105,100,32,119,
         104,105,108,101,32,119,105,116,104,32,110,117,108,108,32,116,114,117,101,
         32,102,97,108,115,101,34,41,46,115,112,108,105,116,40,34,32,34,41,59,10,
         10,32,32,118,97,114,32,99,111,109,112,105,108,101,114,87,111,114,100,115,
         32,61,32,74,97,118,97,83,99,114,105,112,116,67,111,109,112,105,108,101,
         114,46,82,69,83,69,82,86,69,68,95,87,79,82,68,83,32,61,32,123,125,59,10,
         10,32,32,102,111,114,40,118,97,114,32,105,61,48,44,32,108,61,114,101,115,
         101,114,118,101,100,87,111,114,100,115,46,108,101,110,103,116,104,59,32,
         105,60,108,59,32,105,43,43,41,32,123,10,32,32,32,32,99,111,109,112,105,
         108,101,114,87,111,114,100,115,91,114,101,115,101,114,118,101,100,87,111,
         114,100,115,91,105,93,93,32,61,32,116,114,117,101,59,10,32,32,125,10,10,
         9,74,97,118,97,83,99,114,105,112,116,67,111,109,112,105,108,101,114,46,
         105,115,86,97,108,105,100,74,97,118,97,83,99,114,105,112,116,86,97,114,
         105,97,98,108,101,78,97,109,101,32,61,32,102,117,110,99,116,105,111,110,
         40,110,97,109,101,41,32,123,10,9,9,105,102,40,33,74,97,118,97,83,99,114,
         105,112,116,67,111,109,112,105,108,101,114,46,82,69,83,69,82,86,69,68,95,
         87,79,82,68,83,91,110,97,109,101,93,32,38,38,32,47,94,91,97,45,122,65,45,
         90,95,36,93,91,48,45,57,97,45,122,65,45,90,95,36,93,43,36,47,46,116,101,
         115,116,40,110,97,109,101,41,41,32,123,10,9,9,9,114,101,116,117,114,110,
         32,116,114,117,101,59,10,9,9,125,10,9,9,114,101,116,117,114,110,32,102,
         97,108,115,101,59,10,9,125,10,10,125,41,40,72,97,110,100,108,101,98,97,
         114,115,46,67,111,109,112,105,108,101,114,44,32,72,97,110,100,108,101,98,
         97,114,115,46,74,97,118,97,83,99,114,105,112,116,67,111,109,112,105,108,
         101,114,41,59,10,10,72,97,110,100,108,101,98,97,114,115,46,112,114,101,
         99,111,109,112,105,108,101,32,61,32,102,117,110,99,116,105,111,110,40,
         115,116,114,105,110,103,44,32,111,112,116,105,111,110,115,41,32,123,10,
         32,32,111,112,116,105,111,110,115,32,61,32,111,112,116,105,111,110,115,
         32,124,124,32,123,125,59,10,10,32,32,118,97,114,32,97,115,116,32,61,32,
         72,97,110,100,108,101,98,97,114,115,46,112,97,114,115,101,40,115,116,114,
         105,110,103,41,59,10,32,32,118,97,114,32,101,110,118,105,114,111,110,109,
         101,110,116,32,61,32,110,101,119,32,72,97,110,100,108,101,98,97,114,115,
         46,67,111,109,112,105,108,101,114,40,41,46,99,111,109,112,105,108,101,40,
         97,115,116,44,32,111,112,116,105,111,110,115,41,59,10,32,32,114,101,116,
         117,114,110,32,110,101,119,32,72,97,110,100,108,101,98,97,114,115,46,74,
         97,118,97,83,99,114,105,112,116,67,111,109,112,105,108,101,114,40,41,46,
         99,111,109,112,105,108,101,40,101,110,118,105,114,111,110,109,101,110,
         116,44,32,111,112,116,105,111,110,115,41,59,10,125,59,10,10,72,97,110,
         100,108,101,98,97,114,115,46,99,111,109,112,105,108,101,32,61,32,102,117,
         110,99,116,105,111,110,40,115,116,114,105,110,103,44,32,111,112,116,105,
         111,110,115,41,32,123,10,32,32,111,112,116,105,111,110,115,32,61,32,111,
         112,116,105,111,110,115,32,124,124,32,123,125,59,10,10,32,32,118,97,114,
         32,97,115,116,32,61,32,72,97,110,100,108,101,98,97,114,115,46,112,97,114,
         115,101,40,115,116,114,105,110,103,41,59,10,32,32,118,97,114,32,101,110,
         118,105,114,111,110,109,101,110,116,32,61,32,110,101,119,32,72,97,110,
         100,108,101,98,97,114,115,46,67,111,109,112,105,108,101,114,40,41,46,99,
         111,109,112,105,108,101,40,97,115,116,44,32,111,112,116,105,111,110,115,
         41,59,10,32,32,118,97,114,32,116,101,109,112,108,97,116,101,83,112,101,
         99,32,61,32,110,101,119,32,72,97,110,100,108,101,98,97,114,115,46,74,97,
         118,97,83,99,114,105,112,116,67,111,109,112,105,108,101,114,40,41,46,99,
         111,109,112,105,108,101,40,101,110,118,105,114,111,110,109,101,110,116,
         44,32,111,112,116,105,111,110,115,44,32,117,110,100,101,102,105,110,101,
         100,44,32,116,114,117,101,41,59,10,32,32,114,101,116,117,114,110,32,72,
         97,110,100,108,101,98,97,114,115,46,116,101,109,112,108,97,116,101,40,
         116,101,109,112,108,97,116,101,83,112,101,99,41,59,10,125,59,10,59,10,47,
         47,32,108,105,98,47,104,97,110,100,108,101,98,97,114,115,47,118,109,46,
         106,115,10,72,97,110,100,108,101,98,97,114,115,46,86,77,32,61,32,123,10,
         32,32,116,101,109,112,108,97,116,101,58,32,102,117,110,99,116,105,111,
         110,40,116,101,109,112,108,97,116,101,83,112,101,99,41,32,123,10,32,32,
         32,32,47,47,32,74,117,115,116,32,97,100,100,32,119,97,116,101,114,10,32,
         32,32,32,118,97,114,32,99,111,110,116,97,105,110,101,114,32,61,32,123,10,
         32,32,32,32,32,32,101,115,99,97,112,101,69,120,112,114,101,115,115,105,
         111,110,58,32,72,97,110,100,108,101,98,97,114,115,46,85,116,105,108,115,
         46,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,44,10,32,
         32,32,32,32,32,105,110,118,111,107,101,80,97,114,116,105,97,108,58,32,72,
         97,110,100,108,101,98,97,114,115,46,86,77,46,105,110,118,111,107,101,80,
         97,114,116,105,97,108,44,10,32,32,32,32,32,32,112,114,111,103,114,97,109,
         115,58,32,91,93,44,10,32,32,32,32,32,32,112,114,111,103,114,97,109,58,32,
         102,117,110,99,116,105,111,110,40,105,44,32,102,110,44,32,100,97,116,97,
         41,32,123,10,32,32,32,32,32,32,32,32,118,97,114,32,112,114,111,103,114,
         97,109,87,114,97,112,112,101,114,32,61,32,116,104,105,115,46,112,114,111,
         103,114,97,109,115,91,105,93,59,10,32,32,32,32,32,32,32,32,105,102,40,
         100,97,116,97,41,32,123,10,32,32,32,32,32,32,32,32,32,32,114,101,116,117,
         114,110,32,72,97,110,100,108,101,98,97,114,115,46,86,77,46,112,114,111,
         103,114,97,109,40,102,110,44,32,100,97,116,97,41,59,10,32,32,32,32,32,32,
         32,32,125,32,101,108,115,101,32,105,102,40,112,114,111,103,114,97,109,87,
         114,97,112,112,101,114,41,32,123,10,32,32,32,32,32,32,32,32,32,32,114,
         101,116,117,114,110,32,112,114,111,103,114,97,109,87,114,97,112,112,101,
         114,59,10,32,32,32,32,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,
         32,32,32,32,32,32,32,32,112,114,111,103,114,97,109,87,114,97,112,112,101,
         114,32,61,32,116,104,105,115,46,112,114,111,103,114,97,109,115,91,105,93,
         32,61,32,72,97,110,100,108,101,98,97,114,115,46,86,77,46,112,114,111,103,
         114,97,109,40,102,110,41,59,10,32,32,32,32,32,32,32,32,32,32,114,101,116,
         117,114,110,32,112,114,111,103,114,97,109,87,114,97,112,112,101,114,59,
         10,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,125,44,10,32,32,32,
         32,32,32,112,114,111,103,114,97,109,87,105,116,104,68,101,112,116,104,58,
         32,72,97,110,100,108,101,98,97,114,115,46,86,77,46,112,114,111,103,114,
         97,109,87,105,116,104,68,101,112,116,104,44,10,32,32,32,32,32,32,110,111,
         111,112,58,32,72,97,110,100,108,101,98,97,114,115,46,86,77,46,110,111,
         111,112,10,32,32,32,32,125,59,10,10,32,32,32,32,114,101,116,117,114,110,
         32,102,117,110,99,116,105,111,110,40,99,111,110,116,101,120,116,44,32,
         111,112,116,105,111,110,115,41,32,123,10,32,32,32,32,32,32,111,112,116,
         105,111,110,115,32,61,32,111,112,116,105,111,110,115,32,124,124,32,123,
         125,59,10,32,32,32,32,32,32,114,101,116,117,114,110,32,116,101,109,112,
         108,97,116,101,83,112,101,99,46,99,97,108,108,40,99,111,110,116,97,105,
         110,101,114,44,32,72,97,110,100,108,101,98,97,114,115,44,32,99,111,110,
         116,101,120,116,44,32,111,112,116,105,111,110,115,46,104,101,108,112,101,
         114,115,44,32,111,112,116,105,111,110,115,46,112,97,114,116,105,97,108,
         115,44,32,111,112,116,105,111,110,115,46,100,97,116,97,41,59,10,32,32,32,
         32,125,59,10,32,32,125,44,10,10,32,32,112,114,111,103,114,97,109,87,105,
         116,104,68,101,112,116,104,58,32,102,117,110,99,116,105,111,110,40,102,
         110,44,32,100,97,116,97,44,32,36,100,101,112,116,104,41,32,123,10,32,32,
         32,32,118,97,114,32,97,114,103,115,32,61,32,65,114,114,97,121,46,112,114,
         111,116,111,116,121,112,101,46,115,108,105,99,101,46,99,97,108,108,40,97,
         114,103,117,109,101,110,116,115,44,32,50,41,59,10,10,32,32,32,32,114,101,
         116,117,114,110,32,102,117,110,99,116,105,111,110,40,99,111,110,116,101,
         120,116,44,32,111,112,116,105,111,110,115,41,32,123,10,32,32,32,32,32,32,
         111,112,116,105,111,110,115,32,61,32,111,112,116,105,111,110,115,32,124,
         124,32,123,125,59,10,10,32,32,32,32,32,32,114,101,116,117,114,110,32,102,
         110,46,97,112,112,108,121,40,116,104,105,115,44,32,91,99,111,110,116,101,
         120,116,44,32,111,112,116,105,111,110,115,46,100,97,116,97,32,124,124,32,
         100,97,116,97,93,46,99,111,110,99,97,116,40,97,114,103,115,41,41,59,10,
         32,32,32,32,125,59,10,32,32,125,44,10,32,32,112,114,111,103,114,97,109,
         58,32,102,117,110,99,116,105,111,110,40,102,110,44,32,100,97,116,97,41,
         32,123,10,32,32,32,32,114,101,116,117,114,110,32,102,117,110,99,116,105,
         111,110,40,99,111,110,116,101,120,116,44,32,111,112,116,105,111,110,115,
         41,32,123,10,32,32,32,32,32,32,111,112,116,105,111,110,115,32,61,32,111,
         112,116,105,111,110,115,32,124,124,32,123,125,59,10,10,32,32,32,32,32,32,
         114,101,116,117,114,110,32,102,110,40,99,111,110,116,101,120,116,44,32,
         111,112,116,105,111,110,115,46,100,97,116,97,32,124,124,32,100,97,116,97,
         41,59,10,32,32,32,32,125,59,10,32,32,125,44,10,32,32,110,111,111,112,58,
         32,102,117,110,99,116,105,111,110,40,41,32,123,32,114,101,116,117,114,
         110,32,34,34,59,32,125,44,10,32,32,105,110,118,111,107,101,80,97,114,116,
         105,97,108,58,32,102,117,110,99,116,105,111,110,40,112,97,114,116,105,97,
         108,44,32,110,97,109,101,44,32,99,111,110,116,101,120,116,44,32,104,101,
         108,112,101,114,115,44,32,112,97,114,116,105,97,108,115,41,32,123,10,32,
         32,32,32,105,102,40,112,97,114,116,105,97,108,32,61,61,61,32,117,110,100,
         101,102,105,110,101,100,41,32,123,10,32,32,32,32,32,32,116,104,114,111,
         119,32,110,101,119,32,72,97,110,100,108,101,98,97,114,115,46,69,120,99,
         101,112,116,105,111,110,40,34,84,104,101,32,112,97,114,116,105,97,108,32,
         34,32,43,32,110,97,109,101,32,43,32,34,32,99,111,117,108,100,32,110,111,
         116,32,98,101,32,102,111,117,110,100,34,41,59,10,32,32,32,32,125,32,101,
         108,115,101,32,105,102,40,112,97,114,116,105,97,108,32,105,110,115,116,
         97,110,99,101,111,102,32,70,117,110,99,116,105,111,110,41,32,123,10,32,
         32,32,32,32,32,114,101,116,117,114,110,32,112,97,114,116,105,97,108,40,
         99,111,110,116,101,120,116,44,32,123,104,101,108,112,101,114,115,58,32,
         104,101,108,112,101,114,115,44,32,112,97,114,116,105,97,108,115,58,32,
         112,97,114,116,105,97,108,115,125,41,59,10,32,32,32,32,125,32,101,108,
         115,101,32,105,102,32,40,33,72,97,110,100,108,101,98,97,114,115,46,99,
         111,109,112,105,108,101,41,32,123,10,32,32,32,32,32,32,116,104,114,111,
         119,32,110,101,119,32,72,97,110,100,108,101,98,97,114,115,46,69,120,99,
         101,112,116,105,111,110,40,34,84,104,101,32,112,97,114,116,105,97,108,32,
         34,32,43,32,110,97,109,101,32,43,32,34,32,99,111,117,108,100,32,110,111,
         116,32,98,101,32,99,111,109,112,105,108,101,100,32,119,104,101,110,32,
         114,117,110,110,105,110,103,32,105,110,32,118,109,32,109,111,100,101,34,
         41,59,10,32,32,32,32,125,32,101,108,115,101,32,123,10,32,32,32,32,32,32,
         112,97,114,116,105,97,108,115,91,110,97,109,101,93,32,61,32,72,97,110,
         100,108,101,98,97,114,115,46,99,111,109,112,105,108,101,40,112,97,114,
         116,105,97,108,41,59,10,32,32,32,32,32,32,114,101,116,117,114,110,32,112,
         97,114,116,105,97,108,115,91,110,97,109,101,93,40,99,111,110,116,101,120,
         116,44,32,123,104,101,108,112,101,114,115,58,32,104,101,108,112,101,114,
         115,44,32,112,97,114,116,105,97,108,115,58,32,112,97,114,116,105,97,108,
         115,125,41,59,10,32,32,32,32,125,10,32,32,125,10,125,59,10,10,72,97,110,
         100,108,101,98,97,114,115,46,116,101,109,112,108,97,116,101,32,61,32,72,
         97,110,100,108,101,98,97,114,115,46,86,77,46,116,101,109,112,108,97,116,
         101,59,10,59,10,10,10,47,42,42,10,32,42,32,67,117,115,116,111,109,32,97,
         100,100,105,116,105,111,110,32,102,111,114,32,116,104,101,32,75,97,110,
         115,111,32,112,97,99,107,97,103,101,46,32,69,120,112,111,114,116,32,116,
         104,101,32,115,97,109,101,32,98,114,111,119,115,101,114,32,105,110,116,
         101,114,102,97,99,101,10,32,42,32,119,104,101,110,32,117,115,101,100,32,
         97,115,32,97,32,67,111,109,109,111,110,74,83,32,109,111,100,117,108,101,
         32,105,110,32,67,111,117,99,104,68,66,46,10,32,42,47,10,10,105,102,32,40,
         116,121,112,101,111,102,32,109,111,100,117,108,101,32,33,61,61,32,39,117,
         110,100,101,102,105,110,101,100,39,32,38,38,32,116,121,112,101,111,102,
         32,101,120,112,111,114,116,115,32,33,61,61,32,39,117,110,100,101,102,105,
         110,101,100,39,41,32,123,10,32,32,32,32,118,97,114,32,101,120,112,111,
         114,116,115,32,61,32,109,111,100,117,108,101,46,101,120,112,111,114,116,
         115,32,61,32,72,97,110,100,108,101,98,97,114,115,59,10,125,10,10,40,102,
         117,110,99,116,105,111,110,40,41,32,123,10,32,32,118,97,114,32,116,101,
         109,112,108,97,116,101,32,61,32,72,97,110,100,108,101,98,97,114,115,46,
         116,101,109,112,108,97,116,101,44,32,116,101,109,112,108,97,116,101,115,
         32,61,32,72,97,110,100,108,101,98,97,114,115,46,116,101,109,112,108,97,
         116,101,115,32,61,32,72,97,110,100,108,101,98,97,114,115,46,116,101,109,
         112,108,97,116,101,115,32,124,124,32,123,125,59,10,116,101,109,112,108,
         97,116,101,115,91,34,98,111,111,107,109,97,114,107,46,104,116,109,108,34,
         93,32,61,32,116,101,109,112,108,97,116,101,40,102,117,110,99,116,105,111,
         110,32,40,72,97,110,100,108,101,98,97,114,115,44,100,101,112,116,104,48,
         44,104,101,108,112,101,114,115,44,112,97,114,116,105,97,108,115,44,100,
         97,116,97,41,32,123,10,32,32,104,101,108,112,101,114,115,32,61,32,104,
         101,108,112,101,114,115,32,124,124,32,72,97,110,100,108,101,98,97,114,
         115,46,104,101,108,112,101,114,115,59,10,32,32,118,97,114,32,98,117,102,
         102,101,114,32,61,32,34,34,44,32,115,116,97,99,107,49,44,32,115,101,108,
         102,61,116,104,105,115,44,32,102,117,110,99,116,105,111,110,84,121,112,
         101,61,34,102,117,110,99,116,105,111,110,34,44,32,104,101,108,112,101,
         114,77,105,115,115,105,110,103,61,104,101,108,112,101,114,115,46,104,101,
         108,112,101,114,77,105,115,115,105,110,103,44,32,117,110,100,101,102,61,
         118,111,105,100,32,48,44,32,101,115,99,97,112,101,69,120,112,114,101,115,
         115,105,111,110,61,116,104,105,115,46,101,115,99,97,112,101,69,120,112,
         114,101,115,115,105,111,110,59,10,10,10,32,32,98,117,102,102,101,114,32,
         43,61,32,34,60,100,105,118,32,105,100,61,92,34,66,117,116,116,111,110,72,
         111,108,100,101,114,92,34,62,60,97,32,111,110,99,108,105,99,107,61,92,34,
         97,108,101,114,116,40,39,68,114,97,103,32,109,101,32,116,111,32,116,104,
         101,32,98,111,111,107,97,114,107,115,32,98,97,114,39,41,59,32,114,101,
         116,117,114,110,32,102,97,108,115,101,59,92,34,32,104,114,101,102,61,92,
         34,106,97,118,97,115,99,114,105,112,116,58,118,111,105,100,40,40,102,117,
         110,99,116,105,111,110,40,41,123,118,97,114,32,101,61,100,111,99,117,109,
         101,110,116,46,99,114,101,97,116,101,69,108,101,109,101,110,116,40,39,
         115,99,114,105,112,116,39,41,59,101,46,115,101,116,65,116,116,114,105,98,
         117,116,101,40,39,116,121,112,101,39,44,39,116,101,120,116,47,106,97,118,
         97,115,99,114,105,112,116,39,41,59,101,46,115,101,116,65,116,116,114,105,
         98,117,116,101,40,39,99,104,97,114,115,101,116,39,44,39,85,84,70,45,56,
         39,41,59,101,46,115,101,116,65,116,116,114,105,98,117,116,101,40,39,105,
         100,39,44,39,99,111,117,99,104,45,98,111,111,107,109,97,114,107,108,101,
         116,39,41,59,101,46,115,101,116,65,116,116,114,105,98,117,116,101,40,39,
         100,97,116,97,45,108,111,99,97,116,105,111,110,39,44,32,39,34,59,10,32,
         32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,108,111,
         99,97,116,105,111,110,32,124,124,32,100,101,112,116,104,48,46,108,111,99,
         97,116,105,111,110,59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,
         116,97,99,107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,
         112,101,41,32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,
         46,99,97,108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,
         58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,
         115,116,97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,
         116,97,99,107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,
         103,46,99,97,108,108,40,100,101,112,116,104,48,44,32,34,108,111,99,97,
         116,105,111,110,34,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,
         59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,99,97,112,
         101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,107,49,41,32,
         43,32,34,39,41,59,101,46,115,101,116,65,116,116,114,105,98,117,116,101,
         40,39,115,114,99,39,44,39,34,59,10,32,32,115,116,97,99,107,49,32,61,32,
         104,101,108,112,101,114,115,46,108,111,99,97,116,105,111,110,32,124,124,
         32,100,101,112,116,104,48,46,108,111,99,97,116,105,111,110,59,10,32,32,
         105,102,40,116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,
         32,102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,
         99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,
         116,104,48,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,
         10,32,32,101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,
         117,110,100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,
         108,112,101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,
         112,116,104,48,44,32,34,108,111,99,97,116,105,111,110,34,44,32,123,32,
         104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,102,
         101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,115,105,
         111,110,40,115,116,97,99,107,49,41,32,43,32,34,115,116,97,116,105,99,47,
         106,115,47,98,111,111,107,109,97,114,107,108,101,116,46,106,115,63,114,
         61,39,43,77,97,116,104,46,114,97,110,100,111,109,40,41,42,57,57,57,57,57,
         57,57,57,41,59,100,111,99,117,109,101,110,116,46,98,111,100,121,46,97,
         112,112,101,110,100,67,104,105,108,100,40,101,41,125,41,40,41,41,59,92,
         34,32,116,105,116,108,101,61,92,34,80,105,110,32,73,116,92,34,32,105,100,
         61,92,34,66,105,103,80,105,110,73,116,66,117,116,116,111,110,92,34,62,60,
         115,116,114,111,110,103,62,80,105,110,32,73,116,60,47,115,116,114,111,
         110,103,62,60,115,112,97,110,62,60,47,115,112,97,110,62,60,47,97,62,60,
         112,32,105,100,61,92,34,66,117,116,116,111,110,73,110,115,116,114,117,99,
         116,105,111,110,115,92,34,62,226,134,144,38,110,98,115,112,59,38,110,98,
         115,112,59,65,100,100,32,116,104,105,115,32,108,105,110,107,32,116,111,
         32,121,111,117,114,32,66,111,111,107,109,97,114,107,115,32,66,97,114,60,
         47,112,62,60,47,100,105,118,62,92,110,92,110,34,59,10,32,32,114,101,116,
         117,114,110,32,98,117,102,102,101,114,59,125,41,59,10,125,41,40,41,59,10,
         10,40,102,117,110,99,116,105,111,110,40,41,32,123,10,32,32,118,97,114,32,
         116,101,109,112,108,97,116,101,32,61,32,72,97,110,100,108,101,98,97,114,
         115,46,116,101,109,112,108,97,116,101,44,32,116,101,109,112,108,97,116,
         101,115,32,61,32,72,97,110,100,108,101,98,97,114,115,46,116,101,109,112,
         108,97,116,101,115,32,61,32,72,97,110,100,108,101,98,97,114,115,46,116,
         101,109,112,108,97,116,101,115,32,124,124,32,123,125,59,10,116,101,109,
         112,108,97,116,101,115,91,34,98,111,111,107,109,97,114,107,95,114,111,
         119,46,104,116,109,108,34,93,32,61,32,116,101,109,112,108,97,116,101,40,
         102,117,110,99,116,105,111,110,32,40,72,97,110,100,108,101,98,97,114,115,
         44,100,101,112,116,104,48,44,104,101,108,112,101,114,115,44,112,97,114,
         116,105,97,108,115,44,100,97,116,97,41,32,123,10,32,32,104,101,108,112,
         101,114,115,32,61,32,104,101,108,112,101,114,115,32,124,124,32,72,97,110,
         100,108,101,98,97,114,115,46,104,101,108,112,101,114,115,59,10,32,32,118,
         97,114,32,98,117,102,102,101,114,32,61,32,34,34,44,32,115,116,97,99,107,
         49,44,32,115,116,97,99,107,50,44,32,116,109,112,49,44,32,115,101,108,102,
         61,116,104,105,115,44,32,102,117,110,99,116,105,111,110,84,121,112,101,
         61,34,102,117,110,99,116,105,111,110,34,44,32,104,101,108,112,101,114,77,
         105,115,115,105,110,103,61,104,101,108,112,101,114,115,46,104,101,108,
         112,101,114,77,105,115,115,105,110,103,44,32,117,110,100,101,102,61,118,
         111,105,100,32,48,44,32,101,115,99,97,112,101,69,120,112,114,101,115,115,
         105,111,110,61,116,104,105,115,46,101,115,99,97,112,101,69,120,112,114,
         101,115,115,105,111,110,59,10,10,102,117,110,99,116,105,111,110,32,112,
         114,111,103,114,97,109,49,40,100,101,112,116,104,48,44,100,97,116,97,41,
         32,123,10,32,32,10,32,32,118,97,114,32,98,117,102,102,101,114,32,61,32,
         34,34,44,32,115,116,97,99,107,49,59,10,32,32,98,117,102,102,101,114,32,
         43,61,32,34,92,110,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,60,97,
         32,104,114,101,102,61,92,34,35,47,116,97,103,103,101,100,47,34,59,10,32,
         32,115,116,97,99,107,49,32,61,32,100,101,112,116,104,48,59,10,32,32,105,
         102,40,116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,
         102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,
         107,49,32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,
         104,48,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,
         32,32,101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,
         110,100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,
         112,101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,
         116,104,48,44,32,34,116,104,105,115,34,44,32,123,32,104,97,115,104,58,32,
         123,125,32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,
         101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,
         97,99,107,49,41,32,43,32,34,92,34,32,99,108,97,115,115,61,92,34,116,97,
         103,45,108,105,110,107,92,34,62,34,59,10,32,32,115,116,97,99,107,49,32,
         61,32,100,101,112,116,104,48,59,10,32,32,105,102,40,116,121,112,101,111,
         102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,116,105,111,
         110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,
         99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,
         115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,
         105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,
         123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,77,105,115,
         115,105,110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,32,34,116,
         104,105,115,34,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,
         125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,99,97,112,101,69,
         120,112,114,101,115,115,105,111,110,40,115,116,97,99,107,49,41,32,43,32,
         34,60,47,97,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,34,
         59,10,32,32,114,101,116,117,114,110,32,98,117,102,102,101,114,59,125,10,
         10,102,117,110,99,116,105,111,110,32,112,114,111,103,114,97,109,51,40,
         100,101,112,116,104,48,44,100,97,116,97,41,32,123,10,32,32,10,32,32,118,
         97,114,32,98,117,102,102,101,114,32,61,32,34,34,44,32,115,116,97,99,107,
         49,59,10,32,32,98,117,102,102,101,114,32,43,61,32,34,92,110,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,60,105,32,99,108,97,115,115,61,92,34,
         105,99,111,110,45,111,107,92,34,62,60,47,105,62,32,60,115,112,97,110,32,
         99,108,97,115,115,61,92,34,118,105,101,119,115,92,34,62,34,59,10,32,32,
         115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,99,108,105,
         99,107,115,32,124,124,32,100,101,112,116,104,48,46,99,108,105,99,107,115,
         59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,97,99,107,49,
         32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,
         32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,108,108,
         40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,125,32,
         125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,115,116,97,99,
         107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,116,97,99,107,49,
         32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,97,108,
         108,40,100,101,112,116,104,48,44,32,34,99,108,105,99,107,115,34,44,32,
         123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,
         102,102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,
         115,105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,60,47,115,112,97,
         110,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,34,59,10,32,32,114,101,
         116,117,114,110,32,98,117,102,102,101,114,59,125,10,10,32,32,98,117,102,
         102,101,114,32,43,61,32,34,60,100,105,118,32,99,108,97,115,115,61,92,34,
         114,111,119,32,116,111,112,105,99,92,34,32,105,100,61,92,34,34,59,10,32,
         32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,95,105,
         100,32,124,124,32,100,101,112,116,104,48,46,95,105,100,59,10,32,32,105,
         102,40,116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,
         102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,
         107,49,32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,
         104,48,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,
         32,32,101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,
         110,100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,
         112,101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,
         116,104,48,44,32,34,95,105,100,34,44,32,123,32,104,97,115,104,58,32,123,
         125,32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,
         115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,
         99,107,49,41,32,43,32,34,92,34,62,92,110,32,32,32,32,60,100,105,118,32,
         99,108,97,115,115,61,92,34,114,111,119,92,34,62,92,110,32,32,32,32,32,32,
         32,32,60,100,105,118,32,99,108,97,115,115,61,92,34,115,112,97,110,50,92,
         34,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,97,32,104,114,101,
         102,61,92,34,34,59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,108,
         112,101,114,115,46,117,114,108,32,124,124,32,100,101,112,116,104,48,46,
         117,114,108,59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,97,
         99,107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,101,
         41,32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,
         108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,
         125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,115,116,
         97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,116,97,99,
         107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,
         97,108,108,40,100,101,112,116,104,48,44,32,34,117,114,108,34,44,32,123,
         32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,
         102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,115,
         105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,92,34,32,32,99,108,97,
         115,115,61,92,34,98,111,111,107,109,97,114,107,92,34,32,32,100,97,116,97,
         45,105,100,61,92,34,34,59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,
         108,112,101,114,115,46,95,105,100,32,124,124,32,100,101,112,116,104,48,
         46,95,105,100,59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,
         97,99,107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,
         101,41,32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,
         99,97,108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,
         32,123,125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,
         115,116,97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,
         116,97,99,107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,
         103,46,99,97,108,108,40,100,101,112,116,104,48,44,32,34,95,105,100,34,44,
         32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,
         117,102,102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,
         115,115,105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,92,34,62,92,
         110,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,60,105,109,103,32,
         115,114,99,61,39,104,116,116,112,58,47,47,119,119,119,46,98,105,116,112,
         105,120,101,108,115,46,99,111,109,47,103,101,116,116,104,117,109,98,110,
         97,105,108,63,115,105,122,101,61,50,48,48,38,99,111,100,101,61,34,59,10,
         32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,114,
         97,110,100,111,109,32,124,124,32,100,101,112,116,104,48,46,114,97,110,
         100,111,109,59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,97,
         99,107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,101,
         41,32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,
         108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,
         125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,115,116,
         97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,116,97,99,
         107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,
         97,108,108,40,100,101,112,116,104,48,44,32,34,114,97,110,100,111,109,34,
         44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,
         98,117,102,102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,
         101,115,115,105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,38,117,
         114,108,61,34,59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,
         101,114,115,46,117,114,108,32,124,124,32,100,101,112,116,104,48,46,117,
         114,108,59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,97,99,
         107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,101,41,
         32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,
         108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,
         125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,115,116,
         97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,116,97,99,
         107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,
         97,108,108,40,100,101,112,116,104,48,44,32,34,117,114,108,34,44,32,123,
         32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,
         102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,115,
         105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,39,32,99,108,97,115,
         115,61,92,34,115,105,116,101,45,105,109,97,103,101,92,34,47,62,92,110,32,
         32,32,32,32,32,32,32,32,32,32,32,60,47,97,62,92,110,32,32,32,32,32,32,32,
         32,60,47,100,105,118,62,92,110,32,32,32,32,32,32,32,32,60,100,105,118,32,
         99,108,97,115,115,61,92,34,115,112,97,110,53,92,34,62,92,110,32,32,32,32,
         32,32,32,32,32,32,32,32,60,100,105,118,32,99,108,97,115,115,61,92,34,116,
         105,116,108,101,92,34,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,60,97,32,99,108,97,115,115,61,92,34,98,111,111,107,109,97,114,
         107,92,34,32,104,114,101,102,61,92,34,34,59,10,32,32,115,116,97,99,107,
         49,32,61,32,104,101,108,112,101,114,115,46,117,114,108,32,124,124,32,100,
         101,112,116,104,48,46,117,114,108,59,10,32,32,105,102,40,116,121,112,101,
         111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,116,105,
         111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,32,115,
         116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,123,32,
         104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,115,
         101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,102,
         41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,77,
         105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,32,
         34,117,114,108,34,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,
         32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,99,97,112,101,
         69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,107,49,41,32,43,
         32,34,92,34,32,32,100,97,116,97,45,105,100,61,92,34,34,59,10,32,32,115,
         116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,95,105,100,32,
         124,124,32,100,101,112,116,104,48,46,95,105,100,59,10,32,32,105,102,40,
         116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,
         110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,
         32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,
         44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,
         101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,
         100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,
         101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,
         104,48,44,32,34,95,105,100,34,44,32,123,32,104,97,115,104,58,32,123,125,
         32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,
         99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,
         107,49,41,32,43,32,34,92,34,62,34,59,10,32,32,115,116,97,99,107,49,32,61,
         32,104,101,108,112,101,114,115,46,116,105,116,108,101,32,124,124,32,100,
         101,112,116,104,48,46,116,105,116,108,101,59,10,32,32,105,102,40,116,121,
         112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,
         116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,
         32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,
         123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,
         115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,
         102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,
         77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,
         32,34,116,105,116,108,101,34,44,32,123,32,104,97,115,104,58,32,123,125,
         32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,
         99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,
         107,49,41,32,43,32,34,60,47,97,62,92,110,32,32,32,32,32,32,32,32,32,32,
         32,32,60,47,100,105,118,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,
         112,32,99,108,97,115,115,61,92,34,115,109,97,108,108,32,116,101,120,116,
         92,34,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,34,59,10,
         32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,115,
         104,111,114,116,95,116,101,120,116,32,124,124,32,100,101,112,116,104,48,
         46,115,104,111,114,116,95,116,101,120,116,59,10,32,32,105,102,40,116,121,
         112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,
         116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,
         32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,
         123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,
         115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,
         102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,
         77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,
         32,34,115,104,111,114,116,95,116,101,120,116,34,44,32,123,32,104,97,115,
         104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,
         43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,
         115,116,97,99,107,49,41,32,43,32,34,92,110,32,32,32,32,32,32,32,32,32,32,
         32,32,60,47,112,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,100,105,
         118,32,99,108,97,115,115,61,92,34,116,97,103,115,92,34,62,92,110,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,32,32,34,59,10,32,32,115,116,97,99,
         107,49,32,61,32,104,101,108,112,101,114,115,46,116,97,103,115,32,124,124,
         32,100,101,112,116,104,48,46,116,97,103,115,59,10,32,32,115,116,97,99,
         107,50,32,61,32,104,101,108,112,101,114,115,46,101,97,99,104,59,10,32,32,
         116,109,112,49,32,61,32,115,101,108,102,46,112,114,111,103,114,97,109,40,
         49,44,32,112,114,111,103,114,97,109,49,44,32,100,97,116,97,41,59,10,32,
         32,116,109,112,49,46,104,97,115,104,32,61,32,123,125,59,10,32,32,116,109,
         112,49,46,102,110,32,61,32,116,109,112,49,59,10,32,32,116,109,112,49,46,
         105,110,118,101,114,115,101,32,61,32,115,101,108,102,46,110,111,111,112,
         59,10,32,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,50,46,99,97,
         108,108,40,100,101,112,116,104,48,44,32,115,116,97,99,107,49,44,32,116,
         109,112,49,41,59,10,32,32,105,102,40,115,116,97,99,107,49,32,124,124,32,
         115,116,97,99,107,49,32,61,61,61,32,48,41,32,123,32,98,117,102,102,101,
         114,32,43,61,32,115,116,97,99,107,49,59,32,125,10,32,32,98,117,102,102,
         101,114,32,43,61,32,34,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,47,
         100,105,118,62,92,110,32,32,32,32,32,32,32,32,60,47,100,105,118,62,92,
         110,32,32,32,32,32,32,32,32,60,100,105,118,32,99,108,97,115,115,61,92,34,
         115,112,97,110,49,92,34,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,34,
         59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,
         99,108,105,99,107,115,32,124,124,32,100,101,112,116,104,48,46,99,108,105,
         99,107,115,59,10,32,32,115,116,97,99,107,50,32,61,32,104,101,108,112,101,
         114,115,91,39,105,102,39,93,59,10,32,32,116,109,112,49,32,61,32,115,101,
         108,102,46,112,114,111,103,114,97,109,40,51,44,32,112,114,111,103,114,97,
         109,51,44,32,100,97,116,97,41,59,10,32,32,116,109,112,49,46,104,97,115,
         104,32,61,32,123,125,59,10,32,32,116,109,112,49,46,102,110,32,61,32,116,
         109,112,49,59,10,32,32,116,109,112,49,46,105,110,118,101,114,115,101,32,
         61,32,115,101,108,102,46,110,111,111,112,59,10,32,32,115,116,97,99,107,
         49,32,61,32,115,116,97,99,107,50,46,99,97,108,108,40,100,101,112,116,104,
         48,44,32,115,116,97,99,107,49,44,32,116,109,112,49,41,59,10,32,32,105,
         102,40,115,116,97,99,107,49,32,124,124,32,115,116,97,99,107,49,32,61,61,
         61,32,48,41,32,123,32,98,117,102,102,101,114,32,43,61,32,115,116,97,99,
         107,49,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,34,92,110,
         92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,100,105,118,32,99,108,97,
         115,115,61,92,34,97,99,116,105,111,110,115,92,34,62,92,110,32,32,32,32,
         32,32,32,32,32,32,32,32,32,32,32,32,60,98,117,116,116,111,110,32,99,108,
         97,115,115,61,92,34,98,116,110,32,98,116,110,45,115,109,97,108,108,32,97,
         114,99,104,105,118,101,92,34,32,32,100,97,116,97,45,105,100,61,92,34,34,
         59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,
         95,105,100,32,124,124,32,100,101,112,116,104,48,46,95,105,100,59,10,32,
         32,105,102,40,116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,
         61,32,102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,
         97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,
         112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,
         125,10,32,32,101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,
         32,117,110,100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,
         101,108,112,101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,
         101,112,116,104,48,44,32,34,95,105,100,34,44,32,123,32,104,97,115,104,58,
         32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,
         32,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,
         116,97,99,107,49,41,32,43,32,34,92,34,62,65,114,99,104,105,118,101,60,47,
         98,117,116,116,111,110,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,
         47,100,105,118,62,92,110,32,32,32,32,32,32,32,32,60,47,100,105,118,62,92,
         110,32,32,32,32,60,47,100,105,118,62,92,110,60,47,100,105,118,62,34,59,
         10,32,32,114,101,116,117,114,110,32,98,117,102,102,101,114,59,125,41,59,
         10,125,41,40,41,59,10,10,40,102,117,110,99,116,105,111,110,40,41,32,123,
         10,32,32,118,97,114,32,116,101,109,112,108,97,116,101,32,61,32,72,97,110,
         100,108,101,98,97,114,115,46,116,101,109,112,108,97,116,101,44,32,116,
         101,109,112,108,97,116,101,115,32,61,32,72,97,110,100,108,101,98,97,114,
         115,46,116,101,109,112,108,97,116,101,115,32,61,32,72,97,110,100,108,101,
         98,97,114,115,46,116,101,109,112,108,97,116,101,115,32,124,124,32,123,
         125,59,10,116,101,109,112,108,97,116,101,115,91,34,110,101,119,66,111,
         111,107,109,97,114,107,46,104,116,109,108,34,93,32,61,32,116,101,109,112,
         108,97,116,101,40,102,117,110,99,116,105,111,110,32,40,72,97,110,100,108,
         101,98,97,114,115,44,100,101,112,116,104,48,44,104,101,108,112,101,114,
         115,44,112,97,114,116,105,97,108,115,44,100,97,116,97,41,32,123,10,32,32,
         104,101,108,112,101,114,115,32,61,32,104,101,108,112,101,114,115,32,124,
         124,32,72,97,110,100,108,101,98,97,114,115,46,104,101,108,112,101,114,
         115,59,10,32,32,118,97,114,32,98,117,102,102,101,114,32,61,32,34,34,44,
         32,115,116,97,99,107,49,44,32,115,101,108,102,61,116,104,105,115,44,32,
         102,117,110,99,116,105,111,110,84,121,112,101,61,34,102,117,110,99,116,
         105,111,110,34,44,32,104,101,108,112,101,114,77,105,115,115,105,110,103,
         61,104,101,108,112,101,114,115,46,104,101,108,112,101,114,77,105,115,115,
         105,110,103,44,32,117,110,100,101,102,61,118,111,105,100,32,48,44,32,101,
         115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,61,116,104,105,
         115,46,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,59,
         10,10,10,32,32,98,117,102,102,101,114,32,43,61,32,34,60,104,116,109,108,
         62,92,110,60,104,101,97,100,62,92,110,32,32,32,32,60,116,105,116,108,101,
         62,67,114,101,97,116,101,32,66,111,111,107,109,97,114,107,60,47,116,105,
         116,108,101,62,92,110,32,32,32,32,60,108,105,110,107,32,114,101,108,61,
         92,34,115,116,121,108,101,115,104,101,101,116,92,34,32,116,121,112,101,
         61,92,34,116,101,120,116,47,99,115,115,92,34,32,104,114,101,102,61,92,34,
         115,116,97,116,105,99,47,99,115,115,47,109,97,105,110,46,99,115,115,92,
         34,32,47,62,92,110,60,47,104,101,97,100,62,92,110,60,98,111,100,121,62,
         92,110,32,32,32,60,102,111,114,109,32,99,108,97,115,115,61,92,34,102,111,
         114,109,32,119,101,108,108,92,34,32,97,99,116,105,111,110,61,92,34,46,47,
         115,97,118,101,92,34,32,109,101,116,104,111,100,61,92,34,80,79,83,84,92,
         34,62,92,110,32,32,32,32,32,32,32,60,108,97,98,101,108,62,84,105,116,108,
         101,60,47,108,97,98,101,108,62,92,110,32,32,32,32,32,32,32,60,105,110,
         112,117,116,32,110,97,109,101,61,92,34,116,105,116,108,101,92,34,32,118,
         97,108,117,101,61,92,34,34,59,10,32,32,115,116,97,99,107,49,32,61,32,104,
         101,108,112,101,114,115,46,116,105,116,108,101,32,124,124,32,100,101,112,
         116,104,48,46,116,105,116,108,101,59,10,32,32,105,102,40,116,121,112,101,
         111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,116,105,
         111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,32,115,
         116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,123,32,
         104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,115,
         101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,102,
         41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,77,
         105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,32,
         34,116,105,116,108,101,34,44,32,123,32,104,97,115,104,58,32,123,125,32,
         125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,99,
         97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,107,
         49,41,32,43,32,34,92,34,32,99,108,97,115,115,61,92,34,115,112,97,110,52,
         92,34,47,62,92,110,32,32,32,32,32,32,32,60,108,97,98,101,108,62,78,111,
         116,101,60,47,108,97,98,101,108,62,92,110,32,32,32,32,32,32,32,60,116,
         101,120,116,97,114,101,97,32,110,97,109,101,61,92,34,115,104,111,114,116,
         95,116,101,120,116,92,34,32,105,100,61,92,34,98,111,111,107,109,97,114,
         107,83,104,111,114,116,84,101,120,116,92,34,32,32,99,108,97,115,115,61,
         92,34,115,112,97,110,52,92,34,62,60,47,116,101,120,116,97,114,101,97,62,
         92,110,92,110,32,32,32,32,32,32,32,60,108,97,98,101,108,62,85,114,108,60,
         47,108,97,98,101,108,62,92,110,32,32,32,32,32,32,32,60,105,110,112,117,
         116,32,110,97,109,101,61,92,34,117,114,108,92,34,32,118,97,108,117,101,
         61,92,34,34,59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,
         101,114,115,46,117,114,108,32,124,124,32,100,101,112,116,104,48,46,117,
         114,108,59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,97,99,
         107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,101,41,
         32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,
         108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,
         125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,115,116,
         97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,116,97,99,
         107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,
         97,108,108,40,100,101,112,116,104,48,44,32,34,117,114,108,34,44,32,123,
         32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,
         102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,115,
         105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,92,34,32,32,99,108,97,
         115,115,61,92,34,115,112,97,110,52,92,34,47,62,92,110,32,32,32,32,32,32,
         32,60,108,97,98,101,108,62,60,47,108,97,98,101,108,62,92,110,32,32,32,32,
         32,32,32,60,105,110,112,117,116,32,116,121,112,101,61,92,34,115,117,98,
         109,105,116,92,34,32,118,97,108,117,101,61,92,34,115,97,118,101,92,34,32,
         99,108,97,115,115,61,92,34,98,116,110,32,98,116,110,45,112,114,105,109,
         97,114,121,92,34,47,62,92,110,32,32,32,32,32,32,32,60,97,32,104,114,101,
         102,61,92,34,106,97,118,97,115,99,114,105,112,116,58,112,97,114,101,110,
         116,46,112,111,115,116,77,101,115,115,97,103,101,40,39,99,108,111,115,
         101,39,44,32,39,42,39,41,92,34,32,99,108,97,115,115,61,92,34,98,116,110,
         92,34,62,67,97,110,99,101,108,60,47,97,62,92,110,32,32,32,60,47,102,111,
         114,109,62,92,110,60,47,98,111,100,121,62,92,110,60,47,104,116,109,108,
         62,34,59,10,32,32,114,101,116,117,114,110,32,98,117,102,102,101,114,59,
         125,41,59,10,125,41,40,41,59,10,10,40,102,117,110,99,116,105,111,110,40,
         41,32,123,10,32,32,118,97,114,32,116,101,109,112,108,97,116,101,32,61,32,
         72,97,110,100,108,101,98,97,114,115,46,116,101,109,112,108,97,116,101,44,
         32,116,101,109,112,108,97,116,101,115,32,61,32,72,97,110,100,108,101,98,
         97,114,115,46,116,101,109,112,108,97,116,101,115,32,61,32,72,97,110,100,
         108,101,98,97,114,115,46,116,101,109,112,108,97,116,101,115,32,124,124,
         32,123,125,59,10,116,101,109,112,108,97,116,101,115,91,34,110,101,119,66,
         111,111,107,109,97,114,107,70,117,108,108,46,104,116,109,108,34,93,32,61,
         32,116,101,109,112,108,97,116,101,40,102,117,110,99,116,105,111,110,32,
         40,72,97,110,100,108,101,98,97,114,115,44,100,101,112,116,104,48,44,104,
         101,108,112,101,114,115,44,112,97,114,116,105,97,108,115,44,100,97,116,
         97,41,32,123,10,32,32,104,101,108,112,101,114,115,32,61,32,104,101,108,
         112,101,114,115,32,124,124,32,72,97,110,100,108,101,98,97,114,115,46,104,
         101,108,112,101,114,115,59,10,32,32,118,97,114,32,98,117,102,102,101,114,
         32,61,32,34,34,44,32,115,116,97,99,107,49,44,32,115,101,108,102,61,116,
         104,105,115,44,32,102,117,110,99,116,105,111,110,84,121,112,101,61,34,
         102,117,110,99,116,105,111,110,34,44,32,104,101,108,112,101,114,77,105,
         115,115,105,110,103,61,104,101,108,112,101,114,115,46,104,101,108,112,
         101,114,77,105,115,115,105,110,103,44,32,117,110,100,101,102,61,118,111,
         105,100,32,48,44,32,101,115,99,97,112,101,69,120,112,114,101,115,115,105,
         111,110,61,116,104,105,115,46,101,115,99,97,112,101,69,120,112,114,101,
         115,115,105,111,110,59,10,10,10,32,32,98,117,102,102,101,114,32,43,61,32,
         34,60,33,68,79,67,84,89,80,69,32,104,116,109,108,32,80,85,66,76,73,67,32,
         92,34,45,47,47,87,51,67,47,47,68,84,68,32,88,72,84,77,76,32,49,46,48,32,
         83,116,114,105,99,116,47,47,69,78,92,34,32,92,34,104,116,116,112,58,47,
         47,119,119,119,46,119,51,46,111,114,103,47,84,82,47,120,104,116,109,108,
         49,47,68,84,68,47,120,104,116,109,108,49,45,115,116,114,105,99,116,46,
         100,116,100,92,34,62,92,110,60,104,116,109,108,32,120,109,108,110,115,61,
         92,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,
         49,57,57,57,47,120,104,116,109,108,92,34,32,120,109,108,58,108,97,110,
         103,61,92,34,101,110,92,34,32,108,97,110,103,61,92,34,101,110,92,34,62,
         92,110,32,32,60,104,101,97,100,62,92,110,32,32,32,32,32,32,60,109,101,
         116,97,32,104,116,116,112,45,101,113,117,105,118,61,92,34,67,111,110,116,
         101,110,116,45,84,121,112,101,92,34,32,99,111,110,116,101,110,116,61,92,
         34,116,101,120,116,47,104,116,109,108,59,32,99,104,97,114,115,101,116,61,
         85,84,70,45,56,92,34,32,47,62,92,110,32,32,32,32,32,32,60,108,105,110,
         107,32,114,101,108,61,92,34,115,116,121,108,101,115,104,101,101,116,92,
         34,32,116,121,112,101,61,92,34,116,101,120,116,47,99,115,115,92,34,32,
         104,114,101,102,61,92,34,115,116,97,116,105,99,47,99,115,115,47,109,97,
         105,110,46,99,115,115,92,34,32,47,62,92,110,32,32,32,32,32,32,60,108,105,
         110,107,32,114,101,108,61,92,34,115,116,121,108,101,115,104,101,101,116,
         92,34,32,116,121,112,101,61,92,34,116,101,120,116,47,99,115,115,92,34,32,
         104,114,101,102,61,92,34,115,116,97,116,105,99,47,99,115,115,47,99,104,
         111,115,101,110,46,99,115,115,92,34,47,62,92,110,32,32,32,32,32,32,60,
         108,105,110,107,32,114,101,108,61,92,34,105,99,111,110,92,34,32,116,121,
         112,101,61,92,34,105,109,97,103,101,47,112,110,103,92,34,32,104,114,101,
         102,61,92,34,115,116,97,116,105,99,47,105,109,103,47,97,114,107,50,46,
         112,110,103,92,34,32,47,62,92,110,32,32,32,32,60,116,105,116,108,101,62,
         66,111,111,107,109,97,114,107,115,33,60,47,116,105,116,108,101,62,92,110,
         32,32,60,47,104,101,97,100,62,92,110,32,32,60,98,111,100,121,62,92,110,
         92,110,92,110,32,32,32,32,60,100,105,118,32,99,108,97,115,115,61,92,34,
         99,111,110,116,97,105,110,101,114,92,34,32,114,111,108,101,61,92,34,109,
         97,105,110,92,34,62,92,110,32,32,32,32,32,32,32,32,60,104,49,62,67,114,
         101,97,116,101,32,66,111,111,107,109,97,114,107,60,47,104,49,62,92,110,
         32,32,32,32,32,32,32,32,60,102,111,114,109,32,99,108,97,115,115,61,92,34,
         102,111,114,109,32,119,101,108,108,92,34,32,62,92,110,32,32,32,32,32,32,
         32,32,32,32,32,32,60,108,97,98,101,108,62,84,105,116,108,101,60,47,108,
         97,98,101,108,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,105,110,
         112,117,116,32,110,97,109,101,61,92,34,116,105,116,108,101,92,34,32,105,
         100,61,92,34,98,111,111,107,109,97,114,107,84,105,116,108,101,92,34,32,
         118,97,108,117,101,61,92,34,34,59,10,32,32,115,116,97,99,107,49,32,61,32,
         104,101,108,112,101,114,115,46,116,105,116,108,101,32,124,124,32,100,101,
         112,116,104,48,46,116,105,116,108,101,59,10,32,32,105,102,40,116,121,112,
         101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,116,
         105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,32,
         115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,
         123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,
         115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,
         102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,
         77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,
         32,34,116,105,116,108,101,34,44,32,123,32,104,97,115,104,58,32,123,125,
         32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,
         99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,
         107,49,41,32,43,32,34,92,34,32,99,108,97,115,115,61,92,34,115,112,97,110,
         52,92,34,47,62,92,110,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,108,
         97,98,101,108,62,84,97,103,115,60,47,108,97,98,101,108,62,92,110,32,32,
         32,32,32,32,32,32,32,32,32,32,60,115,101,108,101,99,116,32,110,97,109,
         101,61,92,34,116,97,103,115,92,34,32,105,100,61,92,34,116,111,112,105,99,
         84,97,103,115,92,34,32,109,117,108,116,105,112,108,101,32,100,97,116,97,
         45,112,108,97,99,101,104,111,108,100,101,114,61,92,34,67,104,111,111,115,
         101,32,115,111,109,101,32,116,97,103,115,46,92,34,62,92,110,92,110,32,32,
         32,32,32,32,32,32,32,32,32,32,60,47,115,101,108,101,99,116,62,92,110,92,
         110,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,108,97,98,101,108,62,
         78,111,116,101,60,47,108,97,98,101,108,62,92,110,32,32,32,32,32,32,32,32,
         32,32,32,32,60,116,101,120,116,97,114,101,97,32,110,97,109,101,61,92,34,
         115,104,111,114,116,95,116,101,120,116,92,34,32,105,100,61,92,34,98,111,
         111,107,109,97,114,107,83,104,111,114,116,84,101,120,116,92,34,32,32,99,
         108,97,115,115,61,92,34,115,112,97,110,52,92,34,62,60,47,116,101,120,116,
         97,114,101,97,62,92,110,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,
         108,97,98,101,108,62,85,114,108,60,47,108,97,98,101,108,62,92,110,32,32,
         32,32,32,32,32,32,32,32,32,32,60,105,110,112,117,116,32,110,97,109,101,
         61,92,34,117,114,108,92,34,32,105,100,61,92,34,98,111,111,107,109,97,114,
         107,85,114,108,92,34,32,118,97,108,117,101,61,92,34,34,59,10,32,32,115,
         116,97,99,107,49,32,61,32,104,101,108,112,101,114,115,46,117,114,108,32,
         124,124,32,100,101,112,116,104,48,46,117,114,108,59,10,32,32,105,102,40,
         116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,
         110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,
         32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,
         44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,
         101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,
         100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,
         101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,
         104,48,44,32,34,117,114,108,34,44,32,123,32,104,97,115,104,58,32,123,125,
         32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,101,115,
         99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,97,99,
         107,49,41,32,43,32,34,92,34,32,99,108,97,115,115,61,92,34,115,112,97,110,
         54,92,34,32,47,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,108,97,
         98,101,108,62,60,47,108,97,98,101,108,62,92,110,32,32,32,32,32,32,32,32,
         32,32,32,32,60,105,110,112,117,116,32,116,121,112,101,61,92,34,115,117,
         98,109,105,116,92,34,32,118,97,108,117,101,61,92,34,115,97,118,101,92,34,
         32,99,108,97,115,115,61,92,34,98,116,110,32,98,116,110,45,112,114,105,
         109,97,114,121,92,34,47,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,60,
         105,110,112,117,116,32,116,121,112,101,61,92,34,115,117,98,109,105,116,
         92,34,32,118,97,108,117,101,61,92,34,99,97,110,99,101,108,92,34,32,99,
         108,97,115,115,61,92,34,98,116,110,32,99,97,110,99,101,108,92,34,47,62,
         92,110,92,110,32,32,32,32,32,32,32,32,60,47,102,111,114,109,62,92,110,32,
         32,32,32,60,47,100,105,118,62,92,110,92,110,32,32,32,32,60,115,99,114,
         105,112,116,32,116,121,112,101,61,92,34,116,101,120,116,47,106,97,118,97,
         115,99,114,105,112,116,92,34,32,115,114,99,61,92,34,115,116,97,116,105,
         99,47,106,115,47,108,105,98,47,106,113,117,101,114,121,45,49,46,55,46,49,
         46,109,105,110,46,106,115,92,34,62,60,47,115,99,114,105,112,116,62,92,
         110,32,32,32,32,60,115,99,114,105,112,116,32,116,121,112,101,61,92,34,
         116,101,120,116,47,106,97,118,97,115,99,114,105,112,116,92,34,32,115,114,
         99,61,92,34,47,100,97,115,104,98,111,97,114,100,47,95,100,101,115,105,
         103,110,47,100,97,115,104,98,111,97,114,100,47,95,114,101,119,114,105,
         116,101,47,115,116,97,116,105,99,47,106,115,47,116,111,112,98,97,114,46,
         106,115,92,34,62,60,47,115,99,114,105,112,116,62,92,110,32,32,32,32,60,
         115,99,114,105,112,116,32,116,121,112,101,61,92,34,116,101,120,116,47,
         106,97,118,97,115,99,114,105,112,116,92,34,32,115,114,99,61,92,34,115,
         116,97,116,105,99,47,106,115,47,108,105,98,47,99,104,111,115,101,110,46,
         106,113,117,101,114,121,46,109,105,110,46,106,115,92,34,62,60,47,115,99,
         114,105,112,116,62,92,110,32,32,32,32,60,115,99,114,105,112,116,32,116,
         121,112,101,61,92,34,116,101,120,116,47,106,97,118,97,115,99,114,105,112,
         116,92,34,32,115,114,99,61,92,34,109,111,100,117,108,101,115,46,106,115,
         92,34,62,60,47,115,99,114,105,112,116,62,92,110,32,32,32,32,60,115,99,
         114,105,112,116,32,116,121,112,101,61,92,34,116,101,120,116,47,106,97,
         118,97,115,99,114,105,112,116,92,34,32,115,114,99,61,92,34,115,116,97,
         116,105,99,47,106,115,47,110,101,119,66,111,111,107,109,97,114,107,70,
         117,108,108,46,106,115,92,34,62,60,47,115,99,114,105,112,116,62,92,110,
         32,32,60,47,98,111,100,121,62,92,110,60,47,104,116,109,108,62,92,110,34,
         59,10,32,32,114,101,116,117,114,110,32,98,117,102,102,101,114,59,125,41,
         59,10,125,41,40,41,59,10,10,40,102,117,110,99,116,105,111,110,40,41,32,
         123,10,32,32,118,97,114,32,116,101,109,112,108,97,116,101,32,61,32,72,97,
         110,100,108,101,98,97,114,115,46,116,101,109,112,108,97,116,101,44,32,
         116,101,109,112,108,97,116,101,115,32,61,32,72,97,110,100,108,101,98,97,
         114,115,46,116,101,109,112,108,97,116,101,115,32,61,32,72,97,110,100,108,
         101,98,97,114,115,46,116,101,109,112,108,97,116,101,115,32,124,124,32,
         123,125,59,10,116,101,109,112,108,97,116,101,115,91,34,116,97,103,115,45,
         97,108,108,46,104,116,109,108,34,93,32,61,32,116,101,109,112,108,97,116,
         101,40,102,117,110,99,116,105,111,110,32,40,72,97,110,100,108,101,98,97,
         114,115,44,100,101,112,116,104,48,44,104,101,108,112,101,114,115,44,112,
         97,114,116,105,97,108,115,44,100,97,116,97,41,32,123,10,32,32,104,101,
         108,112,101,114,115,32,61,32,104,101,108,112,101,114,115,32,124,124,32,
         72,97,110,100,108,101,98,97,114,115,46,104,101,108,112,101,114,115,59,10,
         32,32,118,97,114,32,98,117,102,102,101,114,32,61,32,34,34,44,32,115,116,
         97,99,107,49,44,32,115,116,97,99,107,50,44,32,116,109,112,49,44,32,115,
         101,108,102,61,116,104,105,115,44,32,102,117,110,99,116,105,111,110,84,
         121,112,101,61,34,102,117,110,99,116,105,111,110,34,44,32,104,101,108,
         112,101,114,77,105,115,115,105,110,103,61,104,101,108,112,101,114,115,46,
         104,101,108,112,101,114,77,105,115,115,105,110,103,44,32,117,110,100,101,
         102,61,118,111,105,100,32,48,44,32,101,115,99,97,112,101,69,120,112,114,
         101,115,115,105,111,110,61,116,104,105,115,46,101,115,99,97,112,101,69,
         120,112,114,101,115,115,105,111,110,59,10,10,102,117,110,99,116,105,111,
         110,32,112,114,111,103,114,97,109,49,40,100,101,112,116,104,48,44,100,97,
         116,97,41,32,123,10,32,32,10,32,32,118,97,114,32,98,117,102,102,101,114,
         32,61,32,34,34,44,32,115,116,97,99,107,49,59,10,32,32,98,117,102,102,101,
         114,32,43,61,32,34,92,110,32,32,32,32,60,116,114,62,92,110,32,32,32,32,
         32,32,60,116,100,62,60,97,32,104,114,101,102,61,92,34,35,47,116,97,103,
         115,47,115,104,111,119,47,34,59,10,32,32,115,116,97,99,107,49,32,61,32,
         104,101,108,112,101,114,115,46,107,101,121,32,124,124,32,100,101,112,116,
         104,48,46,107,101,121,59,10,32,32,105,102,40,116,121,112,101,111,102,32,
         115,116,97,99,107,49,32,61,61,61,32,102,117,110,99,116,105,111,110,84,
         121,112,101,41,32,123,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,
         49,46,99,97,108,108,40,100,101,112,116,104,48,44,32,123,32,104,97,115,
         104,58,32,123,125,32,125,41,59,32,125,10,32,32,101,108,115,101,32,105,
         102,40,115,116,97,99,107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,
         115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,77,105,115,115,105,
         110,103,46,99,97,108,108,40,100,101,112,116,104,48,44,32,34,107,101,121,
         34,44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,
         32,98,117,102,102,101,114,32,43,61,32,101,115,99,97,112,101,69,120,112,
         114,101,115,115,105,111,110,40,115,116,97,99,107,49,41,32,43,32,34,92,34,
         62,34,59,10,32,32,115,116,97,99,107,49,32,61,32,104,101,108,112,101,114,
         115,46,107,101,121,32,124,124,32,100,101,112,116,104,48,46,107,101,121,
         59,10,32,32,105,102,40,116,121,112,101,111,102,32,115,116,97,99,107,49,
         32,61,61,61,32,102,117,110,99,116,105,111,110,84,121,112,101,41,32,123,
         32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,49,46,99,97,108,108,
         40,100,101,112,116,104,48,44,32,123,32,104,97,115,104,58,32,123,125,32,
         125,41,59,32,125,10,32,32,101,108,115,101,32,105,102,40,115,116,97,99,
         107,49,61,61,61,32,117,110,100,101,102,41,32,123,32,115,116,97,99,107,49,
         32,61,32,104,101,108,112,101,114,77,105,115,115,105,110,103,46,99,97,108,
         108,40,100,101,112,116,104,48,44,32,34,107,101,121,34,44,32,123,32,104,
         97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,98,117,102,102,101,
         114,32,43,61,32,101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,
         110,40,115,116,97,99,107,49,41,32,43,32,34,60,47,97,62,60,47,116,100,62,
         92,110,32,32,32,32,32,32,60,116,100,62,34,59,10,32,32,115,116,97,99,107,
         49,32,61,32,104,101,108,112,101,114,115,46,118,97,108,117,101,32,124,124,
         32,100,101,112,116,104,48,46,118,97,108,117,101,59,10,32,32,105,102,40,
         116,121,112,101,111,102,32,115,116,97,99,107,49,32,61,61,61,32,102,117,
         110,99,116,105,111,110,84,121,112,101,41,32,123,32,115,116,97,99,107,49,
         32,61,32,115,116,97,99,107,49,46,99,97,108,108,40,100,101,112,116,104,48,
         44,32,123,32,104,97,115,104,58,32,123,125,32,125,41,59,32,125,10,32,32,
         101,108,115,101,32,105,102,40,115,116,97,99,107,49,61,61,61,32,117,110,
         100,101,102,41,32,123,32,115,116,97,99,107,49,32,61,32,104,101,108,112,
         101,114,77,105,115,115,105,110,103,46,99,97,108,108,40,100,101,112,116,
         104,48,44,32,34,118,97,108,117,101,34,44,32,123,32,104,97,115,104,58,32,
         123,125,32,125,41,59,32,125,10,32,32,98,117,102,102,101,114,32,43,61,32,
         101,115,99,97,112,101,69,120,112,114,101,115,115,105,111,110,40,115,116,
         97,99,107,49,41,32,43,32,34,60,47,116,100,62,92,110,32,32,32,32,60,47,
         116,114,62,92,110,34,59,10,32,32,114,101,116,117,114,110,32,98,117,102,
         102,101,114,59,125,10,10,32,32,98,117,102,102,101,114,32,43,61,32,34,92,
         110,60,100,105,118,62,92,110,32,32,32,32,60,97,32,99,108,97,115,115,61,
         92,34,98,116,110,32,105,110,102,111,92,34,32,104,114,101,102,61,92,34,46,
         47,35,47,116,97,103,115,47,110,101,119,92,34,62,78,101,119,32,84,97,103,
         60,47,97,62,92,110,60,47,100,105,118,62,92,110,92,110,92,110,92,110,92,
         110,60,116,97,98,108,101,32,99,108,97,115,115,61,92,34,116,97,98,108,101,
         32,115,116,114,105,112,101,100,45,116,97,98,108,101,92,34,62,92,110,32,
         32,60,116,104,101,97,100,62,92,110,32,32,32,32,60,116,114,62,92,110,32,
         32,32,32,32,32,60,116,104,62,84,97,103,60,47,116,104,62,92,110,32,32,32,
         32,32,32,60,116,104,62,67,111,117,110,116,60,47,116,104,62,92,110,32,32,
         32,32,60,47,116,114,62,92,110,32,32,60,47,116,104,101,97,100,62,92,110,
         32,32,60,116,98,111,100,121,62,92,110,34,59,10,32,32,115,116,97,99,107,
         49,32,61,32,104,101,108,112,101,114,115,46,114,111,119,115,32,124,124,32,
         100,101,112,116,104,48,46,114,111,119,115,59,10,32,32,115,116,97,99,107,
         50,32,61,32,104,101,108,112,101,114,115,46,101,97,99,104,59,10,32,32,116,
         109,112,49,32,61,32,115,101,108,102,46,112,114,111,103,114,97,109,40,49,
         44,32,112,114,111,103,114,97,109,49,44,32,100,97,116,97,41,59,10,32,32,
         116,109,112,49,46,104,97,115,104,32,61,32,123,125,59,10,32,32,116,109,
         112,49,46,102,110,32,61,32,116,109,112,49,59,10,32,32,116,109,112,49,46,
         105,110,118,101,114,115,101,32,61,32,115,101,108,102,46,110,111,111,112,
         59,10,32,32,115,116,97,99,107,49,32,61,32,115,116,97,99,107,50,46,99,97,
         108,108,40,100,101,112,116,104,48,44,32,115,116,97,99,107,49,44,32,116,
         109,112,49,41,59,10,32,32,105,102,40,115,116,97,99,107,49,32,124,124,32,
         115,116,97,99,107,49,32,61,61,61,32,48,41,32,123,32,98,117,102,102,101,
         114,32,43,61,32,115,116,97,99,107,49,59,32,125,10,32,32,98,117,102,102,
         101,114,32,43,61,32,34,92,110,32,32,60,47,116,98,111,100,121,62,92,110,
         60,47,116,97,98,108,101,62,92,110,92,110,92,110,34,59,10,32,32,114,101,
         116,117,114,110,32,98,117,102,102,101,114,59,125,41,59,10,125,41,40,41,
         59,10,10,40,102,117,110,99,116,105,111,110,40,41,32,123,10,32,32,118,97,
         114,32,116,101,109,112,108,97,116,101,32,61,32,72,97,110,100,108,101,98,
         97,114,115,46,116,101,109,112,108,97,116,101,44,32,116,101,109,112,108,
         97,116,101,115,32,61,32,72,97,110,100,108,101,98,97,114,115,46,116,101,
         109,112,108,97,116,101,115,32,61,32,72,97,110,100,108,101,98,97,114,115,
         46,116,101,109,112,108,97,116,101,115,32,124,124,32,123,125,59,10,116,
         101,109,112,108,97,116,101,115,91,34,116,97,103,115,45,110,101,119,46,
         104,116,109,108,34,93,32,61,32,116,101,109,112,108,97,116,101,40,102,117,
         110,99,116,105,111,110,32,40,72,97,110,100,108,101,98,97,114,115,44,100,
         101,112,116,104,48,44,104,101,108,112,101,114,115,44,112,97,114,116,105,
         97,108,115,44,100,97,116,97,41,32,123,10,32,32,104,101,108,112,101,114,
         115,32,61,32,104,101,108,112,101,114,115,32,124,124,32,72,97,110,100,108,
         101,98,97,114,115,46,104,101,108,112,101,114,115,59,10,32,32,118,97,114,
         32,115,101,108,102,61,116,104,105,115,59,10,10,10,32,32,114,101,116,117,
         114,110,32,34,60,117,108,32,99,108,97,115,115,61,92,34,98,114,101,97,100,
         99,114,117,109,98,92,34,62,92,110,32,32,60,108,105,62,92,110,32,32,32,32,
         60,97,32,104,114,101,102,61,92,34,35,47,116,97,103,115,92,34,62,84,97,
         103,115,60,47,97,62,32,60,115,112,97,110,32,99,108,97,115,115,61,92,34,
         100,105,118,105,100,101,114,92,34,62,47,60,47,115,112,97,110,62,92,110,
         32,32,60,47,108,105,62,92,110,32,32,60,108,105,32,99,108,97,115,115,61,
         92,34,97,99,116,105,118,101,92,34,62,92,110,32,32,32,32,60,97,32,104,114,
         101,102,61,92,34,35,47,116,97,103,115,47,110,101,119,92,34,62,78,101,119,
         60,47,97,62,92,110,32,32,60,47,108,105,62,92,110,60,47,117,108,62,92,110,
         92,110,92,110,60,102,111,114,109,32,99,108,97,115,115,61,92,34,119,101,
         108,108,92,34,62,92,110,32,32,32,32,60,108,101,103,101,110,100,62,67,114,
         101,97,116,101,32,84,97,103,60,47,108,101,103,101,110,100,62,92,110,92,
         110,92,110,92,110,32,32,32,32,60,108,97,98,101,108,62,78,97,109,101,60,
         47,108,97,98,101,108,62,92,110,32,32,32,32,60,105,110,112,117,116,32,116,
         121,112,101,61,92,34,116,101,120,116,92,34,32,110,97,109,101,61,92,34,
         110,97,109,101,92,34,32,47,62,92,110,92,110,92,110,32,32,32,32,60,102,
         105,101,108,100,115,101,116,32,99,108,97,115,115,61,92,34,99,111,110,116,
         114,111,108,45,103,114,111,117,112,92,34,62,92,110,32,32,32,32,32,32,32,
         32,32,32,32,60,108,97,98,101,108,32,99,108,97,115,115,61,92,34,99,111,
         110,116,114,111,108,45,108,97,98,101,108,92,34,32,102,111,114,61,92,34,
         112,114,101,112,101,110,100,101,100,73,110,112,117,116,92,34,62,84,97,
         103,60,47,108,97,98,101,108,62,92,110,32,32,32,32,32,32,32,32,32,32,32,
         60,100,105,118,32,99,108,97,115,115,61,92,34,99,111,110,116,114,111,108,
         115,92,34,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,32,60,100,105,
         118,32,99,108,97,115,115,61,92,34,105,110,112,117,116,45,112,114,101,112,
         101,110,100,92,34,62,92,110,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
         60,115,112,97,110,32,99,108,97,115,115,61,92,34,97,100,100,45,111,110,92,
         34,62,35,60,47,115,112,97,110,62,92,110,32,32,32,32,32,32,32,32,32,32,32,
         32,32,32,32,60,105,110,112,117,116,32,99,108,97,115,115,61,92,34,115,112,
         97,110,51,92,34,32,105,100,61,92,34,116,97,103,92,34,32,110,97,109,101,
         61,92,34,104,97,115,104,92,34,32,115,105,122,101,61,92,34,49,54,92,34,32,
         116,121,112,101,61,92,34,116,101,120,116,92,34,62,92,110,32,32,32,32,32,
         32,32,32,32,32,32,32,32,60,47,100,105,118,62,92,110,32,32,32,32,32,32,32,
         32,32,32,32,32,32,60,112,32,99,108,97,115,115,61,92,34,104,101,108,112,
         45,98,108,111,99,107,92,34,62,87,104,101,110,32,101,110,116,101,114,105,
         110,103,32,116,101,120,116,44,32,117,115,101,32,116,104,105,115,32,116,
         111,32,114,101,102,101,114,101,110,99,101,32,116,104,105,115,32,116,97,
         103,60,47,112,62,92,110,32,32,32,32,32,32,32,32,32,32,32,60,47,100,105,
         118,62,92,110,32,32,32,32,60,47,102,105,101,108,100,115,101,116,62,92,
         110,92,110,32,32,32,32,60,108,97,98,101,108,62,68,101,115,99,114,105,112,
         116,105,111,110,60,47,108,97,98,101,108,62,92,110,32,32,32,32,60,116,101,
         120,116,97,114,101,97,32,99,108,97,115,115,61,92,34,105,110,112,117,116,
         45,120,108,97,114,103,101,92,34,32,114,111,119,115,61,92,34,51,92,34,32,
         32,110,97,109,101,61,92,34,100,101,115,99,114,105,112,116,105,111,110,92,
         34,62,60,47,116,101,120,116,97,114,101,97,62,92,110,92,110,92,110,32,32,
         32,32,60,102,105,101,108,100,115,101,116,32,99,108,97,115,115,61,92,34,
         102,111,114,109,45,97,99,116,105,111,110,115,92,34,62,92,110,32,32,32,32,
         32,32,32,32,60,98,117,116,116,111,110,32,99,108,97,115,115,61,92,34,98,
         116,110,32,98,116,110,45,112,114,105,109,97,114,121,92,34,62,67,114,101,
         97,116,101,60,47,98,117,116,116,111,110,62,92,110,32,32,32,32,32,32,32,
         32,60,98,117,116,116,111,110,32,99,108,97,115,115,61,92,34,98,116,110,32,
         99,97,110,99,101,108,92,34,62,67,97,110,99,101,108,60,47,98,117,116,116,
         111,110,62,92,110,32,32,32,32,60,47,102,105,101,108,100,115,101,116,62,
         92,110,92,110,60,47,102,111,114,109,62,92,110,92,110,34,59,125,41,59,10,
         125,41,40,41,59,10,72,97,110,100,108,101,98,97,114,115,46,114,101,103,
         105,115,116,101,114,72,101,108,112,101,114,40,39,117,99,39,44,32,102,117,
         110,99,116,105,111,110,32,40,115,116,114,41,32,123,10,32,32,32,32,114,
         101,116,117,114,110,32,101,110,99,111,100,101,85,82,73,67,111,109,112,
         111,110,101,110,116,40,115,116,114,41,59,10,125,41,59,10,10,47,47,32,84,
         79,68,79,58,32,97,100,100,32,111,112,116,105,111,110,97,108,32,99,111,
         110,116,101,120,116,32,97,114,103,117,109,101,110,116,63,10,72,97,110,
         100,108,101,98,97,114,115,46,114,101,103,105,115,116,101,114,72,101,108,
         112,101,114,40,39,105,110,99,108,117,100,101,39,44,32,102,117,110,99,116,
         105,111,110,32,40,110,97,109,101,41,32,123,10,32,32,32,32,105,102,32,40,
         33,101,120,112,111,114,116,115,46,116,101,109,112,108,97,116,101,115,91,
         110,97,109,101,93,41,32,123,10,32,32,32,32,32,32,32,32,116,104,114,111,
         119,32,110,101,119,32,69,114,114,111,114,40,39,84,101,109,112,108,97,116,
         101,32,78,111,116,32,70,111,117,110,100,58,32,39,32,43,32,110,97,109,101,
         41,59,10,32,32,32,32,125,10,32,32,32,32,114,101,116,117,114,110,32,101,
         120,112,111,114,116,115,46,116,101,109,112,108,97,116,101,115,91,110,97,
         109,101,93,40,116,104,105,115,44,32,123,125,41,59,10,125,41,59,10,10,72,
         97,110,100,108,101,98,97,114,115,46,114,101,103,105,115,116,101,114,72,
         101,108,112,101,114,40,39,105,102,101,113,117,97,108,39,44,32,102,117,
         110,99,116,105,111,110,32,40,118,97,108,49,44,32,118,97,108,50,44,32,102,
         110,44,32,101,108,115,101,70,110,41,32,123,10,32,32,32,32,105,102,32,40,
         118,97,108,49,32,61,61,61,32,118,97,108,50,41,32,123,10,32,32,32,32,32,
         32,32,32,114,101,116,117,114,110,32,102,110,40,41,59,10,32,32,32,32,125,
         10,32,32,32,32,101,108,115,101,32,105,102,32,40,101,108,115,101,70,110,
         41,32,123,10,32,32,32,32,32,32,32,32,114,101,116,117,114,110,32,101,108,
         115,101,70,110,40,41,59,10,32,32,32,32,125,10,125,41,59,10>>},
      {<<"md5">>,
       <<"/*\n * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message\n * Digest Algorithm, as defined in RFC 1321.\n * Version 2.1 Copyright (C) Paul Johnston 1999 - 2002.\n * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet\n * Distributed under the BSD License\n * See http://pajhome.org.uk/crypt/md5 for more info.\n */\n\n\n/*\n * Configurable variables. You may need to tweak these to be compatible with\n * the server-side, but the defaults work in most cases.\n *\n * These are passed as an options object to the exported methods\n */\n\nvar hexcase = 0; /* hex output format. 0 - lowercase; 1 - uppercase       */\nvar b64pad = \"\"; /* base-64 pad character. \"=\" for strict RFC compliance  */\nvar chrsz = 8;   /* bits per input character. 8 - ASCII; 16 - Unicode     */\n\n\n\n/*\n * Calculate the MD5 of an array of little-endian words, and a bit length\n */\n\nfunction core_md5(x, len) {\n    /* append padding */\n    x[len >> 5] |= 0x80 << ((len) % 32);\n    x[(((len + 64) >>> 9) << 4) + 14] = len;\n\n    var a =  1732584193;\n    var b = -271733879;\n    var c = -1732584194;\n    var d =  271733878;\n\n    for(var i = 0; i < x.length; i += 16)\n    {\n        var olda = a;\n        var oldb = b;\n        var oldc = c;\n        var oldd = d;\n\n        a = md5_ff(a, b, c, d, x[i+ 0], 7 , -680876936);\n        d = md5_ff(d, a, b, c, x[i+ 1], 12, -389564586);\n        c = md5_ff(c, d, a, b, x[i+ 2], 17,  606105819);\n        b = md5_ff(b, c, d, a, x[i+ 3], 22, -1044525330);\n        a = md5_ff(a, b, c, d, x[i+ 4], 7 , -176418897);\n        d = md5_ff(d, a, b, c, x[i+ 5], 12,  1200080426);\n        c = md5_ff(c, d, a, b, x[i+ 6], 17, -1473231341);\n        b = md5_ff(b, c, d, a, x[i+ 7], 22, -45705983);\n        a = md5_ff(a, b, c, d, x[i+ 8], 7 ,  1770035416);\n        d = md5_ff(d, a, b, c, x[i+ 9], 12, -1958414417);\n        c = md5_ff(c, d, a, b, x[i+10], 17, -42063);\n        b = md5_ff(b, c, d, a, x[i+11], 22, -1990404162);\n        a = md5_ff(a, b, c, d, x[i+12], 7 ,  1804603682);\n        d = md5_ff(d, a, b, c, x[i+13], 12, -40341101);\n        c = md5_ff(c, d, a, b, x[i+14], 17, -1502002290);\n        b = md5_ff(b, c, d, a, x[i+15], 22,  1236535329);\n\n        a = md5_gg(a, b, c, d, x[i+ 1], 5 , -165796510);\n        d = md5_gg(d, a, b, c, x[i+ 6], 9 , -1069501632);\n        c = md5_gg(c, d, a, b, x[i+11], 14,  643717713);\n        b = md5_gg(b, c, d, a, x[i+ 0], 20, -373897302);\n        a = md5_gg(a, b, c, d, x[i+ 5], 5 , -701558691);\n        d = md5_gg(d, a, b, c, x[i+10], 9 ,  38016083);\n        c = md5_gg(c, d, a, b, x[i+15], 14, -660478335);\n        b = md5_gg(b, c, d, a, x[i+ 4], 20, -405537848);\n        a = md5_gg(a, b, c, d, x[i+ 9], 5 ,  568446438);\n        d = md5_gg(d, a, b, c, x[i+14], 9 , -1019803690);\n        c = md5_gg(c, d, a, b, x[i+ 3], 14, -187363961);\n        b = md5_gg(b, c, d, a, x[i+ 8], 20,  1163531501);\n        a = md5_gg(a, b, c, d, x[i+13], 5 , -1444681467);\n        d = md5_gg(d, a, b, c, x[i+ 2], 9 , -51403784);\n        c = md5_gg(c, d, a, b, x[i+ 7], 14,  1735328473);\n        b = md5_gg(b, c, d, a, x[i+12], 20, -1926607734);\n\n        a = md5_hh(a, b, c, d, x[i+ 5], 4 , -378558);\n        d = md5_hh(d, a, b, c, x[i+ 8], 11, -2022574463);\n        c = md5_hh(c, d, a, b, x[i+11], 16,  1839030562);\n        b = md5_hh(b, c, d, a, x[i+14], 23, -35309556);\n        a = md5_hh(a, b, c, d, x[i+ 1], 4 , -1530992060);\n        d = md5_hh(d, a, b, c, x[i+ 4], 11,  1272893353);\n        c = md5_hh(c, d, a, b, x[i+ 7], 16, -155497632);\n        b = md5_hh(b, c, d, a, x[i+10], 23, -1094730640);\n        a = md5_hh(a, b, c, d, x[i+13], 4 ,  681279174);\n        d = md5_hh(d, a, b, c, x[i+ 0], 11, -358537222);\n        c = md5_hh(c, d, a, b, x[i+ 3], 16, -722521979);\n        b = md5_hh(b, c, d, a, x[i+ 6], 23,  76029189);\n        a = md5_hh(a, b, c, d, x[i+ 9], 4 , -640364487);\n        d = md5_hh(d, a, b, c, x[i+12], 11, -421815835);\n        c = md5_hh(c, d, a, b, x[i+15], 16,  530742520);\n        b = md5_hh(b, c, d, a, x[i+ 2], 23, -995338651);\n\n        a = md5_ii(a, b, c, d, x[i+ 0], 6 , -198630844);\n        d = md5_ii(d, a, b, c, x[i+ 7], 10,  1126891415);\n        c = md5_ii(c, d, a, b, x[i+14], 15, -1416354905);\n        b = md5_ii(b, c, d, a, x[i+ 5], 21, -57434055);\n        a = md5_ii(a, b, c, d, x[i+12], 6 ,  1700485571);\n        d = md5_ii(d, a, b, c, x[i+ 3], 10, -1894986606);\n        c = md5_ii(c, d, a, b, x[i+10], 15, -1051523);\n        b = md5_ii(b, c, d, a, x[i+ 1], 21, -2054922799);\n        a = md5_ii(a, b, c, d, x[i+ 8], 6 ,  1873313359);\n        d = md5_ii(d, a, b, c, x[i+15], 10, -30611744);\n        c = md5_ii(c, d, a, b, x[i+ 6], 15, -1560198380);\n        b = md5_ii(b, c, d, a, x[i+13], 21,  1309151649);\n        a = md5_ii(a, b, c, d, x[i+ 4], 6 , -145523070);\n        d = md5_ii(d, a, b, c, x[i+11], 10, -1120210379);\n        c = md5_ii(c, d, a, b, x[i+ 2], 15,  718787259);\n        b = md5_ii(b, c, d, a, x[i+ 9], 21, -343485551);\n\n        a = safe_add(a, olda);\n        b = safe_add(b, oldb);\n        c = safe_add(c, oldc);\n        d = safe_add(d, oldd);\n    }\n    return Array(a, b, c, d);\n\n}\n\n/*\n * These functions implement the four basic operations the algorithm uses.\n */\n\nfunction md5_cmn(q, a, b, x, s, t) {\n    return safe_add(\n        bit_rol(\n            safe_add(\n                safe_add(a, q),\n                safe_add(x, t)\n            ),\n            s\n        ),\n        b\n    );\n}\n\nfunction md5_ff(a, b, c, d, x, s, t) {\n    return md5_cmn(\n        (b & c) | ((~b) & d), a, b, x, s, t\n    );\n}\n\nfunction md5_gg(a, b, c, d, x, s, t) {\n    return md5_cmn(\n        (b & d) | (c & (~d)), a, b, x, s, t\n    );\n}\n\nfunction md5_hh(a, b, c, d, x, s, t) {\n    return md5_cmn(\n        b ^ c ^ d, a, b, x, s, t\n    );\n}\n\nfunction md5_ii(a, b, c, d, x, s, t) {\n    return md5_cmn(\n        c ^ (b | (~d)), a, b, x, s, t\n    );\n}\n\n/*\n * Calculate the HMAC-MD5, of a key and some data\n */\n\nfunction core_hmac_md5(key, data) {\n    var bkey = str2binl(key);\n    if(bkey.length > 16) bkey = core_md5(bkey, key.length * chrsz);\n\n    var ipad = Array(16), opad = Array(16);\n    for(var i = 0; i < 16; i++)\n    {\n        ipad[i] = bkey[i] ^ 0x36363636;\n        opad[i] = bkey[i] ^ 0x5C5C5C5C;\n    }\n\n    var hash = core_md5(\n        ipad.concat(\n            str2binl(data)\n        ),\n        512 + data.length * chrsz\n    );\n    return core_md5(opad.concat(hash), 512 + 128);\n}\n\n/*\n * Add integers, wrapping at 2^32. This uses 16-bit operations internally\n * to work around bugs in some JS interpreters.\n */\n\nfunction safe_add(x, y) {\n    var lsw = (x & 0xFFFF) + (y & 0xFFFF);\n    var msw = (x >> 16) + (y >> 16) + (lsw >> 16);\n    return (msw << 16) | (lsw & 0xFFFF);\n}\n\n/*\n * Bitwise rotate a 32-bit number to the left.\n */\n\nfunction bit_rol(num, cnt) {\n    return (num << cnt) | (num >>> (32 - cnt));\n}\n\n/*\n * Convert a string to an array of little-endian words\n * If chrsz is ASCII, characters >255 have their hi-byte silently ignored.\n */\n\nfunction str2binl(str) {\n    var bin = Array();\n    var mask = (1 << chrsz) - 1;\n    for(var i = 0; i < str.length * chrsz; i += chrsz)\n        bin[i>>5] |= (str.charCodeAt(i / chrsz) & mask) << (i%32);\n    return bin;\n}\n\n/*\n * Convert an array of little-endian words to a string\n */\n\nfunction binl2str(bin) {\n    var str = \"\";\n    var mask = (1 << chrsz) - 1;\n    for(var i = 0; i < bin.length * 32; i += chrsz)\n        str += String.fromCharCode((bin[i>>5] >>> (i % 32)) & mask);\n    return str;\n}\n\n/*\n * Convert an array of little-endian words to a hex string.\n */\n\nfunction binl2hex(binarray) {\n    var hex_tab = hexcase ? \"0123456789ABCDEF\" : \"0123456789abcdef\";\n    var str = \"\";\n    for(var i = 0; i < binarray.length * 4; i++)\n    {\n        str += hex_tab.charAt((binarray[i>>2] >> ((i%4)*8+4)) & 0xF) +\n               hex_tab.charAt((binarray[i>>2] >> ((i%4)*8  )) & 0xF);\n    }\n    return str;\n}\n\n/*\n * Convert an array of little-endian words to a base-64 string\n */\n\nfunction binl2b64(binarray) {\n    var tab = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/\";\n    var str = \"\";\n    for(var i = 0; i < binarray.length * 4; i += 3)\n    {\n        var triplet = (((binarray[i   >> 2] >> 8 * ( i   %4)) & 0xFF) << 16)\n                    | (((binarray[i+1 >> 2] >> 8 * ((i+1)%4)) & 0xFF) << 8 )\n                    |  ((binarray[i+2 >> 2] >> 8 * ((i+2)%4)) & 0xFF);\n        for(var j = 0; j < 4; j++)\n        {\n            if(i * 8 + j * 6 > binarray.length * 32) str += b64pad;\n            else str += tab.charAt((triplet >> 6*(3-j)) & 0x3F);\n        }\n    }\n    return str;\n}\n\n\nfunction updateSettings(options) {\n    if (!options) {\n        options = {};\n    }\n    hexcase = (options.hexcase === undefined) ?  0:  options.hexcase;\n    b64pad  = (options.b64pad === undefined)  ?  \"\": options.b64pad;\n    chrsz   = (options.chrsz === undefined)   ?  8:  options.chrsz;\n}\n\n\n/*\n * These are the functions you'll usually want to call\n * They take string arguments and return either hex or base-64 encoded strings\n */\n\nexports.hex = function (s, /*optional*/options) {\n    updateSettings(options);\n    return binl2hex(\n        core_md5(\n            str2binl(s),\n            s.length * chrsz\n        )\n    );\n};\n\nexports.base64 = function (s, /*optional*/options) {\n    updateSettings(options);\n    return binl2b64(\n        core_md5(\n            str2binl(s),\n            s.length * chrsz\n        )\n    );\n};\n\nexports.str = function (s, /*optional*/options) {\n    updateSettings(options);\n    return binl2str(\n        core_md5(\n            str2binl(s),\n            s.length * chrsz\n        )\n    );\n};\n\nexports.hex_hmac = function (key, data, /*optional*/options) {\n    updateSettings(options);\n    return binl2hex(\n        core_hmac_md5(key, data)\n    );\n};\n\nexports.base64_hmac = function (key, data, /*optional*/options) {\n    updateSettings(options);\n    return binl2b64(\n        core_hmac_md5(key, data)\n    );\n};\n\nexports.str_hmac = function (key, data, /*optional*/options) {\n    updateSettings(options);\n    return binl2str(\n        core_hmac_md5(key, data)\n    );\n};\n\n/*\n * Perform a simple self-test to see if the VM is working\n */\nexports.vm_test = function () {\n    updateSettings();\n    return exports.hex(\"abc\") == \"900150983cd24fb0d6963f7d28e17f72\";\n};\n">>},
      {<<"querystring">>,
       <<"var _ = require('underscore')._;\n\n/**\n * Querystring functions ported from node.js to work in CouchDB and the browser.\n * This module is used internally by Kanso, although you can use it in your\n * apps too if you find the functions useful.\n *\n * @module\n */\n\n\n// Copyright Joyent, Inc. and other Node contributors.\n//\n// Permission is hereby granted, free of charge, to any person obtaining a\n// copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to permit\n// persons to whom the Software is furnished to do so, subject to the\n// following conditions:\n//\n// The above copyright notice and this permission notice shall be included\n// in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n// USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n// Query String Utilities\n\nvar QueryString = exports;\n\n/**\n * Decodes a URI Component, provided so that it could be overridden if\n * necessary.\n *\n * @name unescape(str)\n * @param {String} str\n * @returns {String}\n * @api public\n */\n\nQueryString.unescape = function (str) {\n    return decodeURIComponent(str);\n};\n\n/**\n * Encodes a URI Component, provided so that it could be overridden if\n * necessary.\n *\n * @name escape(str)\n * @param {String} str\n * @returns {String}\n * @api public\n */\n\nQueryString.escape = function (str) {\n    return encodeURIComponent(str);\n};\n\nvar stringifyPrimitive = function (v) {\n    switch (typeof v) {\n    case 'string':\n        return v;\n\n    case 'boolean':\n        return v ? 'true' : 'false';\n\n    case 'number':\n        return isFinite(v) ? v : '';\n\n    default:\n        return '';\n    }\n};\n\n/**\n * Serialize an object to a query string. Optionally override the default\n * separator and assignment characters.\n *\n * **Example:**\n *\n * <pre><code class=\"javascript\">\n * querystring.stringify({foo: 'bar'})\n * // returns\n * 'foo=bar'\n *\n * querystring.stringify({foo: 'bar', baz: 'bob'}, ';', ':')\n * // returns\n * 'foo:bar;baz:bob'\n * </code></pre>\n *\n * @name stringify(obj, [sep, eq, name])\n * @param {Object} obj\n * @param {String} sep\n * @param {String} eq\n * @param {String} name\n * @returns {String}\n * @api public\n */\n\nQueryString.stringify = QueryString.encode = function (obj, sep, eq, name) {\n    sep = sep || '&';\n    eq = eq || '=';\n    obj = (obj === null) ? undefined : obj;\n\n    if (typeof obj === 'object') {\n        return _.map(_.keys(obj), function (k) {\n            if (_.isArray(obj[k])) {\n                return _.map(obj[k], function (v) {\n                    return QueryString.escape(stringifyPrimitive(k)) +\n                           eq +\n                           QueryString.escape(stringifyPrimitive(v));\n                }).join(sep);\n            }\n            else {\n                return QueryString.escape(stringifyPrimitive(k)) +\n                       eq +\n                       QueryString.escape(stringifyPrimitive(obj[k]));\n            }\n        }).join(sep);\n    }\n    if (!name) {\n        return '';\n    }\n    return QueryString.escape(stringifyPrimitive(name)) + eq +\n           QueryString.escape(stringifyPrimitive(obj));\n};\n\n/**\n * Deserialize a query string to an object. Optionally override the default\n * separator and assignment characters.\n *\n * **Example:**\n *\n * <pre><code class=\"javascript\">\n * querystring.parse('a=b&b=c')\n * // returns\n * // { a: 'b', b: 'c' }\n * </code></pre>\n *\n * @name decode(qs, [sep, eq])\n * @param {String} qs\n * @param {String} sep\n * @param {String} eq\n * @returns {Object}\n * @api public\n */\n\nQueryString.parse = QueryString.decode = function (qs, sep, eq) {\n    sep = sep || '&';\n    eq = eq || '=';\n    var obj = {};\n\n    if (typeof qs !== 'string' || qs.length === 0) {\n        return obj;\n    }\n\n    qs.split(sep).forEach(function (kvp) {\n        var x = kvp.split(eq);\n        var k = QueryString.unescape(x[0]);\n        var v = QueryString.unescape(x.slice(1).join(eq));\n\n        if (!(k in obj)) {\n            obj[k] = v;\n        }\n        else if (!_.isArray(obj[k])) {\n            obj[k] = [obj[k], v];\n        }\n        else {\n            obj[k].push(v);\n        }\n    });\n\n    return obj;\n};\n">>},
      {<<"db">>,
       <<"/*global $: false */\n\n/**\n * ## DB Module\n *\n * This contains the core functions for dealing with CouchDB. That includes\n * document CRUD operations, querying views and creating/deleting databases.\n *\n *\n * ### Events\n *\n * The db module is an EventEmitter. See the\n * [events package](http://kan.so/packages/details/events) for more information.\n *\n * #### unauthorized\n *\n * Emitted by the db module when a request results in a 401 Unauthorized\n * response. This is listened to used by the session module to help detect\n * session timeouts etc.\n *\n * ```javascript\n * var db = require(\"db\");\n *\n * db.on('unauthorized', function (req) {\n *     // req is the ajax request object which returned 401\n * });\n * ```\n *\n * @module\n */\n\n\nvar events = require('events'),\n    _ = require('underscore')._;\n\n\n/**\n * Tests if running in the browser\n *\n * @returns {Boolean}\n */\n\nfunction isBrowser() {\n    return (typeof(window) !== 'undefined');\n}\n\n\n/**\n * This module is an EventEmitter, used for emitting 'unauthorized' events\n */\n\nvar exports = module.exports = new events.EventEmitter();\n\n\n/**\n * Taken from jQuery 1.4.4 so we can support more recent versions of jQuery.\n */\n\nvar httpData = function (xhr, type, s) {\n    var ct = xhr.getResponseHeader(\"content-type\") || \"\",\n        xml = type === \"xml\" || !type && ct.indexOf(\"xml\") >= 0,\n        data = xml ? xhr.responseXML : xhr.responseText;\n\n    if (xml && data.documentElement.nodeName === \"parsererror\") {\n        $.error(\"parsererror\");\n    }\n    if (s && s.dataFilter) {\n        data = s.dataFilter(data, type);\n    }\n    if (typeof data === \"string\") {\n        if (type === \"json\" || !type && ct.indexOf(\"json\") >= 0) {\n            data = $.parseJSON(data);\n        }\n        else if (type === \"script\" || !type && ct.indexOf(\"javascript\") >= 0) {\n            $.globalEval(data);\n        }\n    }\n    return data;\n};\n\n\n/**\n * Returns a function for handling ajax responses from jquery and calls\n * the callback with the data or appropriate error.\n *\n * @param {Function} callback(err,response)\n * @api private\n */\n\nfunction onComplete(options, callback) {\n    return function (req) {\n        var resp;\n        var ctype = req.getResponseHeader('Content-Type');\n        if (ctype === 'application/json' || ctype === 'text/json') {\n            try {\n                resp = httpData(req, \"json\");\n            }\n            catch (e) {\n                return callback(e);\n            }\n        }\n        else {\n            if (options.expect_json) {\n                try {\n                    resp = httpData(req, \"json\");\n                }\n                catch (ex) {\n                    return callback(\n                        new Error('Expected JSON response, got ' + ctype)\n                    );\n                }\n            }\n            else {\n                resp = req.responseText;\n            }\n        }\n        if (req.status === 401) {\n            exports.emit('unauthorized', req);\n        }\n        if (req.status === 200 || req.status === 201 || req.status === 202) {\n            callback(null, resp);\n        }\n        else if (resp.error || resp.reason) {\n            var err = new Error(resp.reason || resp.error);\n            err.error = resp.error;\n            err.reason = resp.reason;\n            err.code = resp.code;\n            err.status = req.status;\n            callback(err);\n        }\n        else {\n            // TODO: map status code to meaningful error message\n            var err2 = new Error('Returned status code: ' + req.status);\n            err2.status = req.status;\n            callback(err2);\n        }\n    };\n}\n\n\n/**\n * Attempts to guess the database name and design doc id from the current URL,\n * or the loc paramter. Returns an object with 'db', 'design_doc' and 'root'\n * properties, or null for a URL not matching the expected format (perhaps\n * behing a vhost).\n *\n * You wouldn't normally use this function directly, but use `db.current()` to\n * return a DB object bound to the current database instead.\n *\n * @name guessCurrent([loc])\n * @param {String} loc - An alternative URL to use instead of window.location\n *     (optional)\n * @returns {Object|null} - An object with 'db', 'design_doc' and 'root'\n *     properties, or null for a URL not matching the\n *     expected format (perhaps behing a vhost)\n * @api public\n */\n\nexports.guessCurrent = function (loc) {\n    var loc = loc || window.location;\n\n    /**\n     * A database must be named with all lowercase letters (a-z), digits (0-9),\n     * or any of the _$()+-/ characters and must end with a slash in the URL.\n     * The name has to start with a lowercase letter (a-z).\n     *\n     * http://wiki.apache.org/couchdb/HTTP_database_API\n     */\n\n    var re = /\\/([a-z][a-z0-9_\\$\\(\\)\\+-\\/]*)\\/_design\\/([^\\/]+)\\//;\n    var match = re.exec(loc.pathname);\n\n    if (match) {\n        return {\n            db: match[1],\n            design_doc: match[2],\n            root: '/'\n        }\n    }\n    return null;\n};\n\n/**\n * Converts an object to a string of properly escaped URL parameters.\n *\n * @name escapeUrlParams([obj])\n * @param {Object} obj - An object containing url parameters, with\n *       parameter names stored as property names (or keys).\n * @returns {String}\n * @api public\n */\n\nexports.escapeUrlParams = function (obj) {\n    var rv = [ ];\n    for (var key in obj) {\n        rv.push(\n            encodeURIComponent(key) +\n                '=' + encodeURIComponent(obj[key])\n        );\n    }\n    return (rv.length > 0 ? ('?' + rv.join('&')) : '');\n};\n\n/**\n * Encodes a document id or view, list or show name. This also will make sure\n * the forward-slash is not escaped for documents with id's beginning with\n * \"\\_design/\".\n *\n * @name encode(str)\n * @param {String} str - the name or id to escape\n * @returns {String}\n * @api public\n */\n\nexports.encode = function (str) {\n    return encodeURIComponent(str).replace(/^_design%2F/, '_design/');\n};\n\n\n/**\n * Properly encodes query parameters to CouchDB views etc. Handle complex\n * keys and other non-string parameters by passing through JSON.stringify.\n * Returns a shallow-copied clone of the original query after complex values\n * have been stringified.\n *\n * @name stringifyQuery(query)\n * @param {Object} query\n * @returns {Object}\n * @api public\n */\n\nexports.stringifyQuery = function (query) {\n    var q = {};\n    for (var k in query) {\n        if (typeof query[k] !== 'string') {\n            q[k] = JSON.stringify(query[k]);\n        }\n        else {\n            q[k] = query[k];\n        }\n    }\n    return q;\n};\n\n\n/**\n * Make a request, with some default settings, proper callback\n * handling, and optional caching. Used behind-the-scenes by\n * most other DB module functions.\n *\n * @name request(options, callback)\n * @param {Object} options\n * @param {Function} callback(err,response)\n * @api public\n */\n\nexports.request = function (options, callback) {\n    options.complete = onComplete(options, callback);\n    options.dataType = 'json';\n    $.ajax(options);\n};\n\n\n/**\n * Creates a CouchDB database.\n *\n * If you're running behind a virtual host you'll need to set up\n * appropriate rewrites for a DELETE request to '/' either turning off safe\n * rewrites or setting up a new vhost entry.\n *\n * @name createDatabase(name, callback)\n * @param {String} name\n * @param {Function} callback(err,response)\n * @api public\n */\n\nexports.createDatabase = function (name, callback) {\n    var req = {\n        type: 'PUT',\n        url: '/' + exports.encode(name.replace(/^\\/+/, ''))\n    };\n    exports.request(req, callback);\n};\n\n/**\n * Deletes a CouchDB database.\n *\n * If you're running behind a virtual host you'll need to set up\n * appropriate rewrites for a DELETE request to '/' either turning off safe\n * rewrites or setting up a new vhost entry.\n *\n * @name deleteDatabase(name, callback)\n * @param {String} name\n * @param {Function} callback(err,response)\n * @api public\n */\n\n// TODO: detect when 'name' argument is a url and don't construct a url then\nexports.deleteDatabase = function (name, callback) {\n    var req = {\n        type: 'DELETE',\n        url: '/' + exports.encode(name.replace(/^\\/+/, ''))\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Lists all databses\n *\n * If you're running behind a virtual host you'll need to set up\n * appropriate rewrites for a DELETE request to '/' either turning off safe\n * rewrites or setting up a new vhost entry.\n *\n * @name allDbs(callback)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nexports.allDbs = function (callback) {\n    var req = {\n        type: 'GET',\n        url: '/_all_dbs'\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Returns a new UUID generated by CouchDB. Its possible to cache\n * multiple UUIDs for later use, to avoid making too many requests.\n *\n * @name newUUID(cacheNum, callback)\n * @param {Number} cacheNum (optional, default: 1)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nvar uuidCache = [];\n\nexports.newUUID = function (cacheNum, callback) {\n    if (!callback) {\n        callback = cacheNum;\n        cacheNum = 1;\n    }\n    if (uuidCache.length) {\n        return callback(null, uuidCache.shift());\n    }\n    var req = {\n        url: '/_uuids',\n        data: {count: cacheNum},\n        expect_json: true\n    };\n    exports.request(req, function (err, resp) {\n        if (err) {\n            return callback(err);\n        }\n        uuidCache = resp.uuids;\n        callback(null, uuidCache.shift());\n    });\n};\n\n\n/**\n * DB object created by use(dbname) function\n */\n\nfunction DB(url) {\n    this.url = url;\n    // add the module functions to the DB object\n    for (var k in exports) {\n        this[k] = exports[k];\n    }\n};\n\n\n/**\n * Creates a new DB object with methods operating on the database at 'url'\n *\n * The DB object also exposes the same module-level methods (eg, createDatabase)\n * so it can be used in-place of the db exports object, for example:\n *\n * ```javascript\n * var db = require('db').use('mydb');\n *\n * db.createDatabase('example', function (err, resp) {\n *     // do something\n * });\n * ```\n *\n * @name use(url)\n * @param {String} url - The url to bind the new DB object to\n * @returns {DB}\n * @api public\n */\n\n// TODO: handle full urls, not just db names\nexports.use = function (url) {\n    /* Force leading slash; make absolute path */\n    return new DB(url);\n};\n\n/**\n * Attempts to guess the current DB name and return a DB object using that.\n * Should work reliably unless running behind a virtual host.\n *\n * Throws an error if the current database url cannot be detected.\n *\n * The DB object also exposes the same module-level methods (eg, createDatabase)\n * so it can be used in-place of the db exports object, for example:\n *\n * ```javascript\n * var db = require('db').current();\n *\n * db.createDatabase('example', function (err, resp) {\n *     // do something\n * });\n * ```\n *\n * @name current()\n * @returns {DB}\n * @api public\n */\n\nexports.current = function () {\n    // guess current db url etc\n    var curr = exports.guessCurrent();\n    if (!curr) {\n        throw new Error(\n            'Cannot guess current database URL, if running behind a virtual ' +\n            'host you need to explicitly set the database URL using ' +\n            'db.use(database_url) instead of db.current()'\n        );\n    }\n    return exports.use(curr.db);\n};\n\n\n/**\n * Fetches a rewrite from the database the app is running on. Results\n * are passed to the callback, with the first argument of the callback\n * reserved for any exceptions that occurred (node.js style).\n *\n * @name DB.getRewrite(name, path, [q], callback)\n * @param {String} name - the name of the design doc\n * @param {String} path\n * @param {Object} q (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.getRewrite = function (name, path, /*optional*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    // prepend forward-slash if missing\n    path = (path[0] === '/') ? path: '/' + path;\n\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        url: this.url + '/_design/' + exports.encode(name) + '/_rewrite' + path,\n        data: data\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Queries all design documents in the database.\n *\n * @name DB.allDesignDocs([q], callback)\n * @param {Object} q - query parameters to pass to /_all_docs (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.allDesignDocs = function (/*optional*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    q.startkey = '\"_design\"';\n    q.endkey = '\"_design0\"';\n    this.allDocs(q, callback);\n};\n\n\n/**\n * Queries all documents in the database (include design docs).\n *\n * @name DB.allDocs([q], callback)\n * @param {Object} q - query parameters to pass to /_all_docs (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.allDocs = function (/*optional*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        url: this.url + '/_all_docs',\n        data: data,\n        expect_json: true\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Fetches a document from the database the app is running on. Results are\n * passed to the callback, with the first argument of the callback reserved\n * for any exceptions that occurred (node.js style).\n *\n * @name DB.getDoc(id, [q], callback)\n * @param {String} id\n * @param {Object} q (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.getDoc = function (id, /*optional*/q, callback) {\n    if (!id) {\n        throw new Error('getDoc requires an id parameter to work properly');\n    }\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        url: this.url + '/' + exports.encode(id),\n        expect_json: true,\n        data: data\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Saves a document to the database the app is running on. Results are\n * passed to the callback, with the first argument of the callback reserved\n * for any exceptions that occurred (node.js style).\n *\n * @name DB.saveDoc(doc, callback)\n * @param {Object} doc\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.saveDoc = function (doc, callback) {\n    var method, url = this.url;\n    if (doc._id === undefined) {\n        method = \"POST\";\n    }\n    else {\n        method = \"PUT\";\n        url += '/' + doc._id;\n    }\n    try {\n        var data = JSON.stringify(doc);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        type: method,\n        url: url,\n        data: data,\n        processData: false,\n        contentType: 'application/json',\n        expect_json: true\n    };\n    exports.request(req, callback);\n};\n\n/**\n * Deletes a document from the database the app is running on. Results are\n * passed to the callback, with the first argument of the callback reserved\n * for any exceptions that occurred (node.js style).\n *\n * @name DB.removeDoc(doc, callback)\n * @param {Object} doc\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.removeDoc = function (doc, callback) {\n    if (!doc._id) {\n        throw new Error('removeDoc requires an _id field in your document');\n    }\n    if (!doc._rev) {\n        throw new Error('removeDoc requires a _rev field in your document');\n    }\n    var req = {\n        type: 'DELETE',\n        url: this.url + '/' + exports.encode(doc._id) +\n             '?rev=' + exports.encode(doc._rev)\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Fetches a view from the database the app is running on. Results are\n * passed to the callback, with the first argument of the callback reserved\n * for any exceptions that occurred (node.js style).\n *\n * @name DB.getView(name, view, [q], callback)\n * @param {String} name - name of the design doc to use\n * @param {String} view - name of the view\n * @param {Object} q (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.getView = function (name, view, /*opt*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    var viewname = exports.encode(view);\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        url: (this.url +\n            '/_design/' + exports.encode(name) +\n            '/_view/' + viewname\n        ),\n        expect_json: true,\n        data: data\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Fetches a spatial view from the database the app is running on. Results are\n * passed to the callback, with the first argument of the callback reserved\n * for any exceptions that occurred (node.js style).\n *\n * __Parameters:__\n * * bbox - the bounding box filter e.g.: bbox: '0,0,180,90'\n * * plane_bounds - e.g.: plane_bounds: '-180,-90,180,90'\n * * stale - stale: 'ok' prevents the spatial index to be rebuilt\n * * count - count: true will only return the number of geometries\n *\n * @name DB.getSpatialView(name, view, q, callback)\n * @param {String} name - name of the design doc to use\n * @param {String} view - name of the view\n * @param {Object} q - query parameters (see options above)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.getSpatialView = function (name, view, q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    var viewname = exports.encode(view);\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        url: (this.url +\n            '/_design/' + exports.encode(name) +\n            '/_spatial/' + viewname\n        ),\n        expect_json: true,\n        data: data\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Transforms and fetches a view through a list from the database the app\n * is running on. Results are passed to the callback, with the first\n * argument of the callback reserved for any exceptions that occurred\n * (node.js style).\n *\n * @name DB.getList(name, list, view, [q], callback)\n * @param {String} name - name of the design doc to use\n * @param {String} list - name of the list function\n * @param {String} view - name of the view to apply the list function to\n * @param {Object} q (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\n// TODO: run list function client-side?\nDB.prototype.getList = function (name, list, view, /*optional*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    var listname = exports.encode(list);\n    var viewname = exports.encode(view);\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        url: this.url + '/_design/' + exports.encode(name) +\n            '/_list/' + listname + '/' + viewname,\n        data: data\n    };\n    exports.request(req, callback);\n};\n\n/**\n * Transforms and fetches a document through a show from the database the app\n * is running on. Results are passed to the callback, with the first\n * argument of the callback reserved for any exceptions that occurred\n * (node.js style).\n *\n * @name DB.getShow(name, show, docid, [q], callback)\n * @param {String} name - name of the design doc to use\n * @param {String} show - name of the show function\n * @param {String} docid - id of the document to apply the show function to\n * @param {Object} q (optional)\n * @param {Function} callback(err,response)\n * @api public\n */\n\n// TODO: run show function client-side?\nDB.prototype.getShow = function (name, show, docid, /*optional*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n    try {\n        var data = exports.stringifyQuery(q);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var showname = exports.encode(show);\n    var show_url = this.url + '/_design/' +\n        exports.encode(name) + '/_show/' + exports.encode(showname);\n    var req = {\n        url: show_url + (docid ? '/' + exports.encode(docid): ''),\n        data: data\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Fetch a design document from CouchDB.\n *\n * @name DB.getDesignDoc(name, callback)\n * @param name The name of (i.e. path to) the design document without the\n *     preceeding \"\\_design/\".\n * @param callback The callback to invoke when the request completes.\n * @api public\n */\n\nDB.prototype.getDesignDoc = function (name, callback) {\n    this.getDoc('_design/' + name, function (err, ddoc) {\n        if (err) {\n            return callback(err);\n        }\n        return callback(null, ddoc);\n    });\n};\n\n/**\n * Gets information about the database.\n *\n * @name DB.info(callback)\n * @param {Function} callback(err,response)\n * @api public\n */\n\nDB.prototype.info = function (callback) {\n    var req = {\n        url: this.url,\n        expect_json: true,\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Listen to the changes feed for a database.\n *\n * __Options:__\n * * _filter_ - the filter function to use\n * * _since_ - the update_seq to start listening from\n * * _heartbeat_ - the heartbeat time (defaults to 10 seconds)\n * * _include_docs_ - whether to include docs in the results\n *\n * Returning false from the callback will cancel the changes listener\n *\n * @name DB.changes([q], callback)\n * @param {Object} q (optional) query parameters (see options above)\n * @param {Function} callback(err,response)\n * @api public\n */\n\n// TODO: change this to use an EventEmitter\nDB.prototype.changes = function (/*optional*/q, callback) {\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n\n    var that = this;\n\n    q = q || {};\n    q.feed = 'longpoll';\n    q.heartbeat = q.heartbeat || 10000;\n\n    function getChanges(since) {\n        q.since = since;\n        try {\n            var data = exports.stringifyQuery(q);\n        }\n        catch (e) {\n            return callback(e);\n        }\n        var req = {\n            type: 'GET',\n            expect_json: true,\n            url: that.url + '/_changes',\n            data: data\n        };\n        var cb = function (err, data) {\n            var result = callback.apply(this, arguments);\n            if (result !== false) {\n                getChanges(data.last_seq);\n            }\n        }\n        exports.request(req, cb);\n    }\n\n    // use setTimeout to pass control back to the browser briefly to\n    // allow the loading spinner to stop on page load\n    setTimeout(function () {\n        if (q.hasOwnProperty('since')) {\n            getChanges(q.since);\n        }\n        else {\n            that.info(function (err, info) {\n                if (err) {\n                    return callback(err);\n                }\n                getChanges(info.update_seq);\n            });\n        }\n    }, 0);\n};\n\n\n/**\n * Saves a list of documents, without using separate requests.\n * This function uses CouchDB's HTTP bulk document API (_bulk_docs).\n * The return value is an array of objects, each containing an 'id'\n * and a 'rev' field. The return value is passed to the callback you\n * provide via its second argument; the first argument of the callback\n * is reserved for any exceptions that occurred (node.js style).\n *\n * **Options:**\n * * *all_or\\_nothing* - Require that all documents be saved\n *   successfully (or saved with a conflict); otherwise roll\n *   back the operation.\n *\n * @name DB.bulkSave(docs, [options], callback)\n * @param {Array} docs An array of documents; each document is an object\n * @param {Object} options (optional) Options for the bulk-save operation.\n * @param {Function} callback(err,response) - A function to accept results\n *          and/or errors. Document update conflicts are reported in the\n *          results array.\n * @api public\n */\n\nDB.prototype.bulkSave = function (docs, /*optional*/ options, callback) {\n    if (!_.isArray(docs)) {\n        throw new Error(\n            'bulkSave requires an array of documents to work properly'\n        );\n    }\n    if (!callback) {\n        callback = options;\n        options = {};\n    }\n    options.docs = docs;\n    try {\n        var data = JSON.stringify(options);\n    }\n    catch (e) {\n        return callback(e);\n    }\n    var req = {\n        type: 'POST',\n        url: this.url + '/_bulk_docs',\n        data: data,\n        processData: false,\n        contentType: 'application/json',\n        expect_json: true\n    };\n    exports.request(req, callback);\n};\n\n\n/**\n * Requests a list of documents, using only a single HTTP request.\n * This function uses CouchDB's HTTP bulk document API (_all_docs).\n * The return value is an array of objects, each of which is a document.\n * The return value is passed to the callback you provide via its second\n * argument; the first argument of the callback is reserved for any\n * exceptions that occurred (node.js style).\n *\n * @name DB.bulkGet(keys, [q], callback)\n * @param {Array} keys An array of documents identifiers (i.e. strings).\n * @param {Object} q (optional) Query parameters for the bulk-read operation.\n * @param {Function} callback(err,response) - A function to accept results\n *          and/or errors. Document update conflicts are reported in the\n *          results array.\n * @api public\n */\n\nDB.prototype.bulkGet = function (keys, /*optional*/ q, callback) {\n    if (keys && !_.isArray(keys)) {\n        throw new Error(\n            'bulkGet requires that _id values be supplied as a list'\n        );\n    }\n    if (!callback) {\n        callback = q;\n        q = {};\n    }\n\n    /* Encode every query-string option:\n        CouchDB requires that these be JSON, even though they\n        will be URL-encoded as part of the request process. */\n\n    try {\n        for (var k in q) {\n            q[k] = JSON.stringify(q[k]);\n        }\n    }\n    catch (e) {\n        return callback(e);\n    }\n\n    /* Make request:\n        If we have a list of keys, use a post request containing\n        a JSON-encoded list of keys. Otherwise, use a get request. */\n\n    var req = {\n        expect_json: true,\n        url: this.url + '/_all_docs' + exports.escapeUrlParams(q)\n    };\n    if (keys) {\n        try {\n            var data = JSON.stringify({ keys: keys});\n        }\n        catch (e) {\n            return callback(e);\n        }\n        req = _.extend(req, {\n            type: 'POST',\n            processData: false,\n            contentType: 'application/json',\n            data: data\n        });\n    } else {\n        req = _.extend(req, {\n            type: 'GET'\n        });\n    }\n\n    exports.request(req, callback);\n};\n\n\n/**\n * DB methods can only be called client-side\n */\n\n_.each(_.keys(DB.prototype), function (k) {\n    var _fn = DB.prototype[k];\n    DB.prototype[k] = function () {\n        if (!isBrowser()) {\n            throw new Error(k + ' cannot be called server-side');\n        }\n        return _fn.apply(this, arguments);\n    };\n});\n">>},
      {<<"events">>,
       <<"/**\n * ## Events module\n *\n * This is a browser port of the node.js events module. Many objects and\n * modules emit events and these are instances of events.EventEmitter.\n *\n * You can access this module by doing: `require(\"events\")`\n *\n * Functions can then be attached to objects, to be executed when an event is\n * emitted. These functions are called listeners.\n *\n * @module\n */\n\n\n/**\n * To access the EventEmitter class, require('events').EventEmitter.\n *\n * When an EventEmitter instance experiences an error, the typical action is to\n * emit an 'error' event. Error events are treated as a special case. If there\n * is no listener for it, then the default action is for the error to throw.\n *\n * All EventEmitters emit the event 'newListener' when new listeners are added.\n *\n * @name events.EventEmitter\n * @api public\n *\n * ```javascript\n * var EventEmitter = require('events').EventEmitter;\n *\n * // create an event emitter\n * var emitter = new EventEmitter();\n * ```\n */\n\nvar EventEmitter = exports.EventEmitter = function () {};\n\nvar isArray = Array.isArray || function (obj) {\n    return toString.call(obj) === '[object Array]';\n};\n\n\n/**\n * By default EventEmitters will print a warning if more than 10 listeners are\n * added for a particular event. This is a useful default which helps finding\n * memory leaks. Obviously not all Emitters should be limited to 10. This\n * function allows that to be increased. Set to zero for unlimited.\n *\n * @name emitter.setMaxListeners(n)\n * @param {Number} n - The maximum number of listeners\n * @api public\n */\n\n// By default EventEmitters will print a warning if more than\n// 10 listeners are added to it. This is a useful default which\n// helps finding memory leaks.\n//\n// Obviously not all Emitters should be limited to 10. This function allows\n// that to be increased. Set to zero for unlimited.\nvar defaultMaxListeners = 10;\nEventEmitter.prototype.setMaxListeners = function(n) {\n  if (!this._events) this._events = {};\n  this._events.maxListeners = n;\n};\n\n\n/**\n * Execute each of the listeners in order with the supplied arguments.\n *\n * @name emitter.emit(event, [arg1], [arg2], [...])\n * @param {String} event - The event name/id to fire\n * @api public\n */\n\nEventEmitter.prototype.emit = function(type) {\n  // If there is no 'error' event listener then throw.\n  if (type === 'error') {\n    if (!this._events || !this._events.error ||\n        (isArray(this._events.error) && !this._events.error.length))\n    {\n      if (arguments[1] instanceof Error) {\n        throw arguments[1]; // Unhandled 'error' event\n      } else {\n        throw new Error(\"Uncaught, unspecified 'error' event.\");\n      }\n      return false;\n    }\n  }\n\n  if (!this._events) return false;\n  var handler = this._events[type];\n  if (!handler) return false;\n\n  if (typeof handler == 'function') {\n    switch (arguments.length) {\n      // fast cases\n      case 1:\n        handler.call(this);\n        break;\n      case 2:\n        handler.call(this, arguments[1]);\n        break;\n      case 3:\n        handler.call(this, arguments[1], arguments[2]);\n        break;\n      // slower\n      default:\n        var args = Array.prototype.slice.call(arguments, 1);\n        handler.apply(this, args);\n    }\n    return true;\n\n  } else if (isArray(handler)) {\n    var args = Array.prototype.slice.call(arguments, 1);\n\n    var listeners = handler.slice();\n    for (var i = 0, l = listeners.length; i < l; i++) {\n      listeners[i].apply(this, args);\n    }\n    return true;\n\n  } else {\n    return false;\n  }\n};\n\n\n/**\n * Adds a listener to the end of the listeners array for the specified event.\n *\n * @name emitter.on(event, listener) | emitter.addListener(event, listener)\n * @param {String} event - The event name/id to listen for\n * @param {Function} listener - The function to bind to the event\n * @api public\n *\n * ```javascript\n * session.on('change', function (userCtx) {\n *     console.log('session changed!');\n * });\n * ```\n */\n\n// EventEmitter is defined in src/node_events.cc\n// EventEmitter.prototype.emit() is also defined there.\nEventEmitter.prototype.addListener = function(type, listener) {\n  if ('function' !== typeof listener) {\n    throw new Error('addListener only takes instances of Function');\n  }\n\n  if (!this._events) this._events = {};\n\n  // To avoid recursion in the case that type == \"newListeners\"! Before\n  // adding it to the listeners, first emit \"newListeners\".\n  this.emit('newListener', type, listener);\n\n  if (!this._events[type]) {\n    // Optimize the case of one listener. Don't need the extra array object.\n    this._events[type] = listener;\n  } else if (isArray(this._events[type])) {\n\n    // Check for listener leak\n    if (!this._events[type].warned) {\n      var m;\n      if (this._events.maxListeners !== undefined) {\n        m = this._events.maxListeners;\n      } else {\n        m = defaultMaxListeners;\n      }\n\n      if (m && m > 0 && this._events[type].length > m) {\n        this._events[type].warned = true;\n        console.error('(node) warning: possible EventEmitter memory ' +\n                      'leak detected. %d listeners added. ' +\n                      'Use emitter.setMaxListeners() to increase limit.',\n                      this._events[type].length);\n        console.trace();\n      }\n    }\n\n    // If we've already got an array, just append.\n    this._events[type].push(listener);\n  } else {\n    // Adding the second element, need to change to array.\n    this._events[type] = [this._events[type], listener];\n  }\n\n  return this;\n};\n\nEventEmitter.prototype.on = EventEmitter.prototype.addListener;\n\n/**\n * Adds a one time listener for the event. This listener is invoked only the\n * next time the event is fired, after which it is removed.\n *\n * @name emitter.once(event, listener)\n * @param {String} event- The event name/id to listen for\n * @param {Function} listener - The function to bind to the event\n * @api public\n *\n * ```javascript\n * db.once('unauthorized', function (req) {\n *     // this event listener will fire once, then be unbound\n * });\n * ```\n */\n\nEventEmitter.prototype.once = function(type, listener) {\n  var self = this;\n  self.on(type, function g() {\n    self.removeListener(type, g);\n    listener.apply(this, arguments);\n  });\n\n  return this;\n};\n\n/**\n * Remove a listener from the listener array for the specified event. Caution:\n * changes array indices in the listener array behind the listener.\n *\n * @name emitter.removeListener(event, listener)\n * @param {String} event - The event name/id to remove the listener from\n * @param {Function} listener - The listener function to remove\n * @api public\n *\n * ```javascript\n * var callback = function (init) {\n *     console.log('duality app loaded');\n * };\n * devents.on('init', callback);\n * // ...\n * devents.removeListener('init', callback);\n * ```\n */\n\nEventEmitter.prototype.removeListener = function(type, listener) {\n  if ('function' !== typeof listener) {\n    throw new Error('removeListener only takes instances of Function');\n  }\n\n  // does not use listeners(), so no side effect of creating _events[type]\n  if (!this._events || !this._events[type]) return this;\n\n  var list = this._events[type];\n\n  if (isArray(list)) {\n    var i = list.indexOf(listener);\n    if (i < 0) return this;\n    list.splice(i, 1);\n    if (list.length == 0)\n      delete this._events[type];\n  } else if (this._events[type] === listener) {\n    delete this._events[type];\n  }\n\n  return this;\n};\n\n/**\n * Removes all listeners, or those of the specified event.\n *\n * @name emitter.removeAllListeners([event])\n * @param {String} event - Event name/id to remove all listeners for (optional)\n * @api public\n */\n\nEventEmitter.prototype.removeAllListeners = function(type) {\n  // does not use listeners(), so no side effect of creating _events[type]\n  if (type && this._events && this._events[type]) this._events[type] = null;\n  return this;\n};\n\n/**\n * Returns an array of listeners for the specified event. This array can be\n * manipulated, e.g. to remove listeners.\n *\n * @name emitter.listeners(event)\n * @param {String} events - The event name/id to return listeners for\n * @api public\n *\n * ```javascript\n * session.on('change', function (stream) {\n *     console.log('session changed');\n * });\n * console.log(util.inspect(session.listeners('change'))); // [ [Function] ]\n * ```\n */\n\nEventEmitter.prototype.listeners = function(type) {\n  if (!this._events) this._events = {};\n  if (!this._events[type]) this._events[type] = [];\n  if (!isArray(this._events[type])) {\n    this._events[type] = [this._events[type]];\n  }\n  return this._events[type];\n};\n\n\n/**\n * @name emitter Event: 'newListener'\n *\n * This event is emitted any time someone adds a new listener.\n *\n * ```javascript\n * emitter.on('newListener', function (event, listener) {\n *     // new listener added\n * });\n * ```\n */\n">>},
      {<<"views">>,
       {[{<<"by_date">>,
          {[{<<"map">>,
             <<"function (doc) {\n\n        if (doc.archive) return;\n\n        if (doc.type && doc.type === 'com.eckoit.bookmark' ) {\n            var timestamp = doc.timestamp;\n            if (!timestamp) timestamp = new Date(0);\n            emit(timestamp, null);\n        }\n    }">>}]}},
         {<<"by_views">>,
          {[{<<"map">>,
             <<"function (doc) {\n\n        if (doc.archive) return;\n\n        if (doc.type && doc.type === 'com.eckoit.bookmark' ) {\n            var clicks = doc.clicks;\n            if (!clicks) clicks = 0;\n\n            var timestamp = doc.timestamp;\n            if (!timestamp) timestamp = new Date(0);\n\n            emit([clicks, timestamp], null);\n        }\n    }">>}]}},
         {<<"all_tags">>,
          {[{<<"map">>,
             <<"function (doc) {\n        if (doc.type && doc.type == 'garden.tag') {\n            emit(doc.hash, null);\n        }\n    }">>}]}}]}},
      {<<"shows">>,
       {[{<<"bookmark_lite">>,
          <<"function(){return require(\"lib/app\")[\"shows\"][\"bookmark_lite\"].apply(this, arguments);}">>},
         {<<"bookmark">>,
          <<"function(){return require(\"lib/app\")[\"shows\"][\"bookmark\"].apply(this, arguments);}">>}]}},
      {<<"rewrites">>,
       [{[{<<"from">>,<<"/static/*">>},{<<"to">>,<<"static/*">>}]},
        {[{<<"from">>,<<"/bootstrap/*">>},{<<"to">>,<<"bootstrap/*">>}]},
        {[{<<"from">>,<<"/modules.js">>},{<<"to">>,<<"modules.js">>}]},
        {[{<<"from">>,<<"/_db/*">>},{<<"to">>,<<"../../*">>}]},
        {[{<<"from">>,<<"/_db">>},{<<"to">>,<<"../..">>}]},
        {[{<<"from">>,<<"/bookmark_lite">>},{<<"to">>,<<"_show/bookmark_lite">>}]},
        {[{<<"from">>,<<"/bookmark">>},{<<"to">>,<<"_show/bookmark">>}]},
        {[{<<"from">>,<<"/save">>},{<<"to">>,<<"_update/bookmark">>}]},
        {[{<<"from">>,<<"/click/*">>},{<<"to">>,<<"_update/click/*">>}]},
        {[{<<"from">>,<<"/archive/*">>},{<<"to">>,<<"_update/archive/*">>}]},
        {[{<<"from">>,<<"/">>},{<<"to">>,<<"index.html">>}]}]},
      {<<"updates">>,
       {[{<<"bookmark">>,
          <<"function(){return require(\"lib/app\")[\"updates\"][\"bookmark\"].apply(this, arguments);}">>},
         {<<"click">>,
          <<"function(){return require(\"lib/app\")[\"updates\"][\"click\"].apply(this, arguments);}">>},
         {<<"archive">>,
          <<"function(){return require(\"lib/app\")[\"updates\"][\"archive\"].apply(this, arguments);}">>}]}},
      {<<"kanso">>,
       {[{<<"git">>,
          {[{<<"commit">>,<<"7f8959e590deab4f5753e2ea6208c15ff567d420">>},
            {<<"uncommitted">>,
             [<<"M lib/shows.js">>,<<" M lib/views.js">>,<<" M static/js/ui.js">>,
              <<" M templates/newBookmarkFull.html">>,
              <<"?? static/css/chosen-sprite.png">>,
              <<"?? static/css/chosen.css">>,
              <<"?? static/js/lib/chosen.jquery.min.js">>]}]}},
         {<<"config">>,
          {[{<<"name">>,<<"bookmarks">>},
            {<<"version">>,<<"0.0.1">>},
            {<<"description">>,<<"A bookmark management app">>},
            {<<"url">>,<<"https://github.com/ryanramage/bookmarks">>},
            {<<"categories">>,[<<"productivity">>]},
            {<<"attachments">>,[<<"static">>,<<"index.html">>]},
            {<<"modules">>,<<"lib">>},
            {<<"load">>,<<"lib/app">>},
            {<<"less">>,{[{<<"compile">>,<<"static/css/main.less">>}]}},
            {<<"handlebars">>,
             {[{<<"all_partials">>,true},{<<"templates">>,<<"templates">>}]}},
            {<<"dependencies">>,
             {[{<<"attachments">>,null},
               {<<"modules">>,null},
               {<<"bootstrap-less">>,null},
               {<<"less-precompiler">>,null},
               {<<"properties">>,null},
               {<<"underscore">>,null},
               {<<"async">>,null},
               {<<"handlebars">>,null},
               {<<"handlebars-helpers">>,<<"0.0.2">>},
               {<<"git-info">>,null},
               {<<"md5">>,null},
               {<<"querystring">>,null},
               {<<"db">>,null}]}},
            {<<"minify">>,false}]}},
         {<<"build_time">>,<<"2012-04-23T16:36:22Z">>},
         {<<"kanso_version">>,<<"0.2.1">>},
         {<<"push_time">>,<<"2012-04-23T16:36:23Z">>},
         {<<"pushed_by">>,null}]}},
      {<<"_attachments">>,
       {[{<<"index.html">>,
          {[{<<"content_type">>,<<"text/html">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-khTmAdQuj4c/CdFGur+70A==">>},
            {<<"length">>,3077},
            {<<"stub">>,true}]}},
         {<<"static/css/chosen-sprite.png">>,
          {[{<<"content_type">>,<<"image/png">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-jnDRIEN//Gob986+yiktXA==">>},
            {<<"length">>,559},
            {<<"stub">>,true}]}},
         {<<"static/css/chosen.css">>,
          {[{<<"content_type">>,<<"text/css">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-SyQr5kbsGOFn6Wxdn6Z3aw==">>},
            {<<"length">>,13899},
            {<<"stub">>,true}]}},
         {<<"static/css/main.less">>,
          {[{<<"content_type">>,<<"application/octet-stream">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-URaiBx11XH8x05cl59dAzA==">>},
            {<<"length">>,8689},
            {<<"stub">>,true}]}},
         {<<"static/css/variables.less">>,
          {[{<<"content_type">>,<<"application/octet-stream">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-reoRg9btxVRj+e0TyJhNQA==">>},
            {<<"length">>,3025},
            {<<"stub">>,true}]}},
         {<<"static/img/ark2.png">>,
          {[{<<"content_type">>,<<"image/png">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-4vrSFHDWaZHKWifwcG8hVA==">>},
            {<<"length">>,2057},
            {<<"stub">>,true}]}},
         {<<"static/js/newBookmarkFull.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-yjXxo3qXTP6l65XvrkWerw==">>},
            {<<"length">>,683},
            {<<"stub">>,true}]}},
         {<<"static/js/ui.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-mlDGSXBi+0BrWbVYeRp72g==">>},
            {<<"length">>,3707},
            {<<"stub">>,true}]}},
         {<<"static/js/lib/chosen.jquery.min.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-rRlrgD1wuvENf8tZgAA9cA==">>},
            {<<"length">>,21600},
            {<<"stub">>,true}]}},
         {<<"static/js/lib/director-1.0.9-1.min.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-fUNuZ9tCEe5BltVN6nHjsg==">>},
            {<<"length">>,8394},
            {<<"stub">>,true}]}},
         {<<"static/js/bookmarklet.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-9MCMOYyBYco5sxwIcm9zdA==">>},
            {<<"length">>,98961},
            {<<"stub">>,true}]}},
         {<<"static/js/lib/jquery-1.7.1.min.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-kDrm5DSU7ipIDNCUHWqsGw==">>},
            {<<"length">>,93868},
            {<<"stub">>,true}]}},
         {<<"bootstrap/img/glyphicons-halflings-white.png">>,
          {[{<<"content_type">>,<<"image/png">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-ERGK6Nt5bUHdEUggZ8idAQ==">>},
            {<<"length">>,4352},
            {<<"stub">>,true}]}},
         {<<"bootstrap/img/glyphicons-halflings.png">>,
          {[{<<"content_type">>,<<"image/png">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-Ux1LYHNlrGWwmhgSFvBmTQ==">>},
            {<<"length">>,4352},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-alert.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-sKmVzKPq4M8ZMup4XnQ4Fw==">>},
            {<<"length">>,2444},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-button.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-hLbaDlvTgpd4KjeTjo+iPg==">>},
            {<<"length">>,2736},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-carousel.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-I6kPQOlMEjO3iWpe8IlLqA==">>},
            {<<"length">>,4569},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-collapse.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-1BR3K0TnDmf8EnG0idcogw==">>},
            {<<"length">>,3912},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-dropdown.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-PbNWk9+5k1lIrJFEKVP9+A==">>},
            {<<"length">>,2558},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-modal.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-kcSFEqPCzH7crA7OfzIizQ==">>},
            {<<"length">>,5539},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-popover.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-AuzcmyJ+hs9xkq+COAid3Q==">>},
            {<<"length">>,2869},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-scrollspy.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-WE8ePmYfzSPR9uMw1IkdyQ==">>},
            {<<"length">>,3669},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-tab.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-4BYRnw0fmHMTrYe1I98mdQ==">>},
            {<<"length">>,3307},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-tooltip.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-5mgKJG2Enk2HqMp/5mqB6g==">>},
            {<<"length">>,7374},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-transition.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-u0BKvKPVmFgJ/rZCHrq4Tg==">>},
            {<<"length">>,1867},
            {<<"stub">>,true}]}},
         {<<"bootstrap/js/bootstrap-typeahead.js">>,
          {[{<<"content_type">>,<<"application/javascript">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-0vDawx/paP5jos4SRX4vGg==">>},
            {<<"length">>,6706},
            {<<"stub">>,true}]}},
         {<<"static/css/main.css">>,
          {[{<<"content_type">>,<<"text/css">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-N3/GGAfrdHr5LBmyQjE/Kg==">>},
            {<<"length">>,91240},
            {<<"stub">>,true}]}},
         {<<"modules.js">>,
          {[{<<"content_type">>,<<"application/json; charset=utf-8">>},
            {<<"revpos">>,1},
            {<<"digest">>,<<"md5-53jnl3ILqpg9lKQuQ9fx0Q==">>},
            {<<"length">>,179950},
            {<<"stub">>,true}]}}]}}]}.
