package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2012
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the Logistic distribution in ELKI.
 * 
 * The reference values were computed using GNU R and SciPy.
 * 
 * @author Erich Schubert
 */
public class TestLogisticDistribution extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  1e-10, 1e-05, 0.1, 0.1234567, 0.2, 0.271828182846, 0.3, 0.314159265359, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.71828182846, 3.14159265359 //
  };

  public static final double[] SCIPY_LOGISTIC_CDF_05 = { //
  3.77540668821645775121709220911725424230098724365234e-01, // 0.000000
  3.77543018838145283400109519789111800491809844970703e-01, // 0.000010
  4.01312339887547997463457249978091567754745483398438e-01, // 0.100000
  4.06960880864213336849388724658638238906860351562500e-01, // 0.123457
  4.25557483188341023616629854586790315806865692138672e-01, // 0.200000
  4.43203246664875705196351418635458685457706451416016e-01, // 0.271828
  4.50166002687522159853017456043744459748268127441406e-01, // 0.300000
  4.53673071561317309274841136357281357049942016601562e-01, // 0.314159
  4.75020812521059987432181515032425522804260253906250e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  5.24979187478939901545516022451920434832572937011719e-01, // 0.600000
  5.49833997312477840146982543956255540251731872558594e-01, // 0.700000
  5.74442516811659031894521376671036705374717712402344e-01, // 0.800000
  5.98687660112452002536542750021908432245254516601562e-01, // 0.900000
  6.22459331201854593196287623868556693196296691894531e-01, // 1.000000
  6.45656306225795395548061605950351804494857788085938e-01, // 1.100000
  6.68187772168166160824398502882104367017745971679688e-01, // 1.200000
  6.89974481127612504494095446716528385877609252929688e-01, // 1.300000
  7.10949502625003892930521942616906017065048217773438e-01, // 1.400000
  7.31058578630004896048433238320285454392433166503906e-01, // 1.500000
  7.50260105595117687826700603181961923837661743164062e-01, // 1.600000
  7.68524783499017538623832024313742294907569885253906e-01, // 1.700000
  7.85834983042558610222272363898809999227523803710938e-01, // 1.800000
  8.02183888558581692507232219213619828224182128906250e-01, // 1.900000
  8.17574476193643651100728675373829901218414306640625e-01, // 2.000000
  9.01879254389253204315934908663621172308921813964844e-01, // 2.718282
  9.33490913616609740977025921893073245882987976074219e-01, // 3.141593
  };

  public static final double[] SCIPY_LOGISTIC_PDF_05 = { //
  2.35003712207350168306163595843827351927757263183594e-01, // 0.000000
  2.35004287764725150466915692959446460008621215820312e-01, // 0.000010
  2.40260745741529169183792191688553430140018463134766e-01, // 0.100000
  2.41343722310436908928821253539354074746370315551758e-01, // 0.123457
  2.44458311690745860866869065830542240291833877563477e-01, // 0.200000
  2.46774128810589049587420618081523571163415908813477e-01, // 0.271828
  2.47516572711860005640005510940682142972946166992188e-01, // 0.300000
  2.47853815701437218965708098039613105356693267822266e-01, // 0.314159
  2.49376040192891945679320997442118823528289794921875e-01, // 0.400000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  2.49376040192891945679320997442118823528289794921875e-01, // 0.600000
  2.47516572711859950128854279682855121791362762451172e-01, // 0.700000
  2.44458311690745888622444681459455750882625579833984e-01, // 0.800000
  2.40260745741529169183792191688553430140018463134766e-01, // 0.900000
  2.35003712201594494590750628049136139452457427978516e-01, // 1.000000
  2.28784240456657267381856968313513789325952529907227e-01, // 1.100000
  2.21712873293109097305730870175466407090425491333008e-01, // 1.200000
  2.13909696520294428934150232635147403925657272338867e-01, // 1.300000
  2.05500307342263432985873805591836571693420410156250e-01, // 1.400000
  1.96611933241481878775758218580449465662240982055664e-01, // 1.500000
  1.87369879547520601370536041940795257687568664550781e-01, // 1.600000
  1.77894440646805707118005557276774197816848754882812e-01, // 1.700000
  1.68298362469060241997098614774586167186498641967773e-01, // 1.800000
  1.58684897495614651852235965634463354945182800292969e-01, // 1.900000
  1.49146452070332835582178176991874352097511291503906e-01, // 2.000000
  8.84930648915379924890345364474342204630374908447266e-02, // 2.718282
  6.20856278118370533136705091692419955506920814514160e-02, // 3.141593
  };

  public static final double[] GNUR_LOGISTIC_CDF_05 = { //
  3.77540668821645775121709220911725424230098724365234e-01, // 0.000000
  3.77543018838145283400109519789111800491809844970703e-01, // 0.000010
  4.01312339887547997463457249978091567754745483398438e-01, // 0.100000
  4.06960880864213336849388724658638238906860351562500e-01, // 0.123457
  4.25557483188341023616629854586790315806865692138672e-01, // 0.200000
  4.43203246664899241924473471954115666449069976806641e-01, // 0.271828
  4.50166002687522159853017456043744459748268127441406e-01, // 0.300000
  4.53673071561322416300754412077367305755615234375000e-01, // 0.314159
  4.75020812521059987432181515032425522804260253906250e-01, // 0.400000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  5.24979187478939901545516022451920434832572937011719e-01, // 0.600000
  5.49833997312477840146982543956255540251731872558594e-01, // 0.700000
  5.74442516811659031894521376671036705374717712402344e-01, // 0.800000
  5.98687660112452002536542750021908432245254516601562e-01, // 0.900000
  6.22459331201854593196287623868556693196296691894531e-01, // 1.000000
  6.45656306225795395548061605950351804494857788085938e-01, // 1.100000
  6.68187772168166160824398502882104367017745971679688e-01, // 1.200000
  6.89974481127612504494095446716528385877609252929688e-01, // 1.300000
  7.10949502625003892930521942616906017065048217773438e-01, // 1.400000
  7.31058578630004896048433238320285454392433166503906e-01, // 1.500000
  7.50260105595117687826700603181961923837661743164062e-01, // 1.600000
  7.68524783499017538623832024313742294907569885253906e-01, // 1.700000
  7.85834983042558610222272363898809999227523803710938e-01, // 1.800000
  8.02183888558581692507232219213619828224182128906250e-01, // 1.900000
  8.17574476193643651100728675373829901218414306640625e-01, // 2.000000
  9.01879254389337470243503958045039325952529907226562e-01, // 2.718282
  9.33490913616622508541809111193288117647171020507812e-01, // 3.141593
  };

  public static final double[] GNUR_LOGISTIC_PDF_05 = { //
  2.35003712207350168306163595843827351927757263183594e-01, // 0.000000
  2.35004287764725178222491308588359970599412918090820e-01, // 0.000010
  2.40260745741529169183792191688553430140018463134766e-01, // 0.100000
  2.41343722310436908928821253539354074746370315551758e-01, // 0.123457
  2.44458311690745888622444681459455750882625579833984e-01, // 0.200000
  2.46774128810591714122679718457220587879419326782227e-01, // 0.271828
  2.47516572711859977884429895311768632382154464721680e-01, // 0.300000
  2.47853815701437635299342332473315764218568801879883e-01, // 0.314159
  2.49376040192891945679320997442118823528289794921875e-01, // 0.400000
  2.50000000000000000000000000000000000000000000000000e-01, // 0.500000
  2.49376040192891945679320997442118823528289794921875e-01, // 0.600000
  2.47516572711859950128854279682855121791362762451172e-01, // 0.700000
  2.44458311690745888622444681459455750882625579833984e-01, // 0.800000
  2.40260745741529169183792191688553430140018463134766e-01, // 0.900000
  2.35003712201594494590750628049136139452457427978516e-01, // 1.000000
  2.28784240456657267381856968313513789325952529907227e-01, // 1.100000
  2.21712873293109097305730870175466407090425491333008e-01, // 1.200000
  2.13909696520294428934150232635147403925657272338867e-01, // 1.300000
  2.05500307342263432985873805591836571693420410156250e-01, // 1.400000
  1.96611933241481878775758218580449465662240982055664e-01, // 1.500000
  1.87369879547520601370536041940795257687568664550781e-01, // 1.600000
  1.77894440646805707118005557276774197816848754882812e-01, // 1.700000
  1.68298362469060241997098614774586167186498641967773e-01, // 1.800000
  1.58684897495614651852235965634463354945182800292969e-01, // 1.900000
  1.49146452070332835582178176991874352097511291503906e-01, // 2.000000
  8.84930648914700607177152846816170495003461837768555e-02, // 2.718282
  6.20856278118259094500608341604674933478236198425293e-02, // 3.141593
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_LOGISTIC_QUANT_05 = { //
  -8.71024036697584946864481025841087102890014648437500e+00, // 0.000100
  -6.40675477864855391629816949716769158840179443359375e+00, // 0.001000
  -4.09511985013458978954759004409424960613250732421875e+00, // 0.010000
  -1.69722457733621956421643517387565225362777709960938e+00, // 0.100000
  -5.98612288668109782108217586937826126813888549804688e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  1.59861228866811000415282251196913421154022216796875e+00, // 0.750000
  2.69722457733621912012722532381303608417510986328125e+00, // 0.900000
  5.09511985013458357229865214321762323379516601562500e+00, // 0.990000
  7.40675477864846509845619948464445769786834716796875e+00, // 0.999000
  9.71024036697667902728881017537787556648254394531250e+00, // 0.999900
  };

  public static final double[] GNUR_LOGISTIC_QUANT_05 = { //
  -8.71024036697584946864481025841087102890014648437500e+00, // 0.000100
  -6.40675477864855391629816949716769158840179443359375e+00, // 0.001000
  -4.09511985013458978954759004409424960613250732421875e+00, // 0.010000
  -1.69722457733621912012722532381303608417510986328125e+00, // 0.100000
  -5.98612288668109782108217586937826126813888549804688e-01, // 0.250000
  5.00000000000000000000000000000000000000000000000000e-01, // 0.500000
  1.59861228866810978210821758693782612681388854980469e+00, // 0.750000
  2.69722457733621956421643517387565225362777709960938e+00, // 0.900000
  5.09511985013458890136917034396901726722717285156250e+00, // 0.990000
  7.40675477864855302811974979704245924949645996093750e+00, // 0.999000
  9.71024036697595960276885307393968105316162109375000e+00, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new LogisticDistribution(.5, 1.), P_CDFPDF, SCIPY_LOGISTIC_PDF_05, 1e-12);
    checkPDF(new LogisticDistribution(.5, 1.), P_CDFPDF, GNUR_LOGISTIC_PDF_05, 1e-15);
  }

  @Test
  public void testCDF() {
    checkCDF(new LogisticDistribution(.5, 1.), P_CDFPDF, SCIPY_LOGISTIC_CDF_05, 1e-13);
    checkCDF(new LogisticDistribution(.5, 1.), P_CDFPDF, GNUR_LOGISTIC_CDF_05, 0.);
  }

  @Test
  public void testProbit() {
    checkQuantile(new LogisticDistribution(.5, 1.), P_QUANT, SCIPY_LOGISTIC_QUANT_05, 1e-13);
    checkQuantile(new LogisticDistribution(.5, 1.), P_QUANT, GNUR_LOGISTIC_QUANT_05, 0.);
  }
}
