/*

   Derby - Class DummyVTI

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

import java.sql.*;

/**
 * <p>
 * This class goes into a jar file called dummy_vti.jar. We  use this class to
 * verify that table functions can be invoked from inside jar files stored
 * inside the database. We use this jar file in the DatabaseClassLoading test.
 * Compile this class with the Java 5 compiler.
 * </p>
 */
public class DummyVTI
{
    public static double reciprocal( double original ) { return 1.0 / original; }
    
    public static ResultSet dummyVTI( ) throws SQLException
    {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement( "select tablename from sys.systables" );
        ResultSet rs = ps.executeQuery();

        return rs;
    }
}