#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "transformation.hpp"

#include "control_file.hpp"

#include "transformations.hpp"

namespace {

class bootstrap_transformation :
	public transformation
{
public:
	virtual ~bootstrap_transformation(void) throw() { }
	virtual void operator()(control_file &) const;
};

void bootstrap_transformation::operator()(control_file &control) const
{
	for(control_file::binary_iterator i = control.binaries_begin();
			i != control.binaries_end(); ++i)
		i->bootstrap = false;
	return;
}

}

transformation const &transform_bootstrap = bootstrap_transformation();
