info = {
    "name": "bg",
    "date_order": "DMY",
    "january": [
        "яну",
        "януари",
        "ян"
    ],
    "february": [
        "фев",
        "февруари",
        "фв"
    ],
    "march": [
        "март"
    ],
    "april": [
        "апр",
        "април",
        "ап"
    ],
    "may": [
        "май"
    ],
    "june": [
        "юни",
        "юн"
    ],
    "july": [
        "юли",
        "юл"
    ],
    "august": [
        "авг",
        "август"
    ],
    "september": [
        "сеп",
        "септември",
        "септ",
        "септм"
    ],
    "october": [
        "окт",
        "октомври"
    ],
    "november": [
        "ное",
        "ноември"
    ],
    "december": [
        "дек",
        "декември"
    ],
    "monday": [
        "пн",
        "понеделник",
        "пон"
    ],
    "tuesday": [
        "вт",
        "вторник",
        "вто"
    ],
    "wednesday": [
        "ср",
        "сряда",
        "сря"
    ],
    "thursday": [
        "четвъртък",
        "чт"
    ],
    "friday": [
        "петък",
        "пт"
    ],
    "saturday": [
        "сб",
        "събота"
    ],
    "sunday": [
        "нд",
        "неделя"
    ],
    "am": [
        "am",
        "проб"
    ],
    "pm": [
        "pm",
        "слоб"
    ],
    "year": [
        "г",
        "година",
        "год",
        "години"
    ],
    "month": [
        "м",
        "месец",
        "мес",
        "месеци"
    ],
    "week": [
        "седм",
        "седмица",
        "с",
        "сед",
        "седмици"
    ],
    "day": [
        "д",
        "ден",
        "дни",
        "дена"
    ],
    "hour": [
        "ч",
        "час",
        "часа"
    ],
    "minute": [
        "мин",
        "минута",
        "минути"
    ],
    "second": [
        "с",
        "секунда",
        "сек",
        "секунди"
    ],
    "relative-type": {
        "0 day ago": [
            "днес"
        ],
        "0 hour ago": [
            "в този час"
        ],
        "0 minute ago": [
            "в тази минута"
        ],
        "0 month ago": [
            "т м",
            "този мес",
            "този месец"
        ],
        "0 second ago": [
            "сега"
        ],
        "0 week ago": [
            "тази седм",
            "тази седмица"
        ],
        "0 year ago": [
            "т г",
            "тази година"
        ],
        "1 day ago": [
            "вчера",
            "снощи",
            "преди ден"
        ],
        "1 month ago": [
            "мин м",
            "мин мес",
            "предходен месец"
        ],
        "1 week ago": [
            "мин седм",
            "миналата седмица",
            "предходната седмица",
            "преди седмица"
        ],
        "1 year ago": [
            "мин г",
            "миналата година",
            "преди година"
        ],
        "in 1 day": [
            "утре",
            "след ден"
        ],
        "in 1 month": [
            "сл м",
            "следв мес",
            "следващ месец"
        ],
        "in 1 week": [
            "сл седм",
            "следв седм",
            "следващата седмица"
        ],
        "in 1 year": [
            "сл г",
            "следв г",
            "следващата година"
        ],
        "10 year ago": [
            "преди десетилетие"
        ],
        "in 10 year": [
            "след 1 десетилетие"
        ],
        "2 day ago": [
            "онзи ден"
        ],
        "in 2 day": [
            "вдругиден"
        ],
        "1 hour ago": [
            "преди час"
        ],
        "in 1 hour": [
            "след час"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "пр (\\d+) д",
            "преди (\\d+) ден",
            "преди (\\d+) дни"
        ],
        "\\1 hour ago": [
            "пр (\\d+) ч",
            "преди (\\d+) ч",
            "преди (\\d+) час",
            "преди (\\d+) часа"
        ],
        "\\1 minute ago": [
            "пр (\\d+) мин",
            "преди (\\d+) мин",
            "преди (\\d+) минута",
            "преди (\\d+) минути"
        ],
        "\\1 month ago": [
            "пр (\\d+) м",
            "преди (\\d+) м",
            "преди (\\d+) месец",
            "преди (\\d+) месеца"
        ],
        "\\1 second ago": [
            "пр (\\d+) сек",
            "преди (\\d+) сек",
            "преди (\\d+) секунда",
            "преди (\\d+) секунди"
        ],
        "\\1 week ago": [
            "пр (\\d+) седм",
            "преди (\\d+) седм",
            "преди (\\d+) седмица",
            "преди (\\d+) седмици"
        ],
        "\\1 year ago": [
            "пр (\\d+) г",
            "преди (\\d+) г",
            "преди (\\d+) година",
            "преди (\\d+) години"
        ],
        "in \\1 day": [
            "сл (\\d+) д",
            "след (\\d+) ден",
            "след (\\d+) дни"
        ],
        "in \\1 hour": [
            "сл (\\d+) ч",
            "след (\\d+) ч",
            "след (\\d+) час",
            "след (\\d+) часа"
        ],
        "in \\1 minute": [
            "сл (\\d+) мин",
            "след (\\d+) мин",
            "след (\\d+) минута",
            "след (\\d+) минути"
        ],
        "in \\1 month": [
            "сл (\\d+) м",
            "след (\\d+) м",
            "след (\\d+) месец",
            "след (\\d+) месеца"
        ],
        "in \\1 second": [
            "сл (\\d+) сек",
            "след (\\d+) сек",
            "след (\\d+) секунда",
            "след (\\d+) секунди"
        ],
        "in \\1 week": [
            "сл (\\d+) седм",
            "след (\\d+) седм",
            "след (\\d+) седмица",
            "след (\\d+) седмици"
        ],
        "in \\1 year": [
            "сл (\\d+) г",
            "след (\\d+) г",
            "след (\\d+) година",
            "след (\\d+) години"
        ]
    },
    "locale_specific": {},
    "skip": [
        "върху",
        "до",
        "на",
        "около",
        "от",
        "под",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "преди"
    ],
    "in": [
        "след",
        "после",
        "подир"
    ],
    "simplifications": [
        {
            "един": "1"
        },
        {
            "два": "2"
        },
        {
            "три": "3"
        }
    ]
}
