/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pull.PullNamespaceReducer;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.xpath.NamespaceContextImpl;

public class PullToStax
implements XMLStreamReader {
    private PullNamespaceReducer provider;
    private NamePool namePool;
    private boolean previousAtomic;
    private FastStringBuffer currentTextNode = new FastStringBuffer(100);
    private int currentStaxEvent;
    private XPathException pendingException = null;

    public PullToStax(PullProvider pullProvider) {
        this.provider = pullProvider instanceof PullNamespaceReducer ? (PullNamespaceReducer)pullProvider : new PullNamespaceReducer(pullProvider);
        this.namePool = pullProvider.getPipelineConfiguration().getConfiguration().getNamePool();
    }

    public int getAttributeCount() {
        try {
            return this.provider.getAttributes().getLength();
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return 0;
        }
    }

    public boolean isAttributeSpecified(int n) {
        return true;
    }

    public QName getAttributeName(int n) {
        try {
            AttributeCollection attributeCollection = this.provider.getAttributes();
            return new QName(attributeCollection.getURI(n), attributeCollection.getLocalName(n), attributeCollection.getPrefix(n));
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return new QName("http://saxon.sf.net/error", "error", "");
        }
    }

    public String getAttributeLocalName(int n) {
        try {
            return this.provider.getAttributes().getLocalName(n);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "error";
        }
    }

    public String getAttributeNamespace(int n) {
        try {
            return this.provider.getAttributes().getURI(n);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "http://saxon.sf.net/error";
        }
    }

    public String getAttributePrefix(int n) {
        try {
            return this.provider.getAttributes().getPrefix(n);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "";
        }
    }

    public String getAttributeType(int n) {
        try {
            AttributeCollection attributeCollection = this.provider.getAttributes();
            if (attributeCollection.isId(n)) {
                return "ID";
            }
            if (attributeCollection.isIdref(n)) {
                return "IDREFS";
            }
            return "CDATA";
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "CDATA";
        }
    }

    public String getAttributeValue(int n) {
        try {
            return this.provider.getAttributes().getValue(n);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "error";
        }
    }

    public String getAttributeValue(String string, String string2) {
        try {
            return this.provider.getAttributes().getValue(string, string2);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "";
        }
    }

    public int getEventType() {
        return this.currentStaxEvent;
    }

    public int getNamespaceCount() {
        try {
            return this.provider.getNamespaceDeclarations().getNumberOfNamespaces();
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return 0;
        }
    }

    public String getText() {
        if (this.previousAtomic) {
            return this.currentTextNode.toString();
        }
        try {
            return this.provider.getStringValue().toString();
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "";
        }
    }

    public int getTextLength() {
        if (this.previousAtomic) {
            return this.currentTextNode.length();
        }
        try {
            return this.provider.getStringValue().length();
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return 0;
        }
    }

    public int getTextStart() {
        return 0;
    }

    public char[] getTextCharacters() {
        if (this.previousAtomic) {
            return this.currentTextNode.getCharArray();
        }
        try {
            String string = this.provider.getStringValue().toString();
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            return cArray;
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return new char[0];
        }
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.previousAtomic) {
            int n4 = n + n3;
            if (n4 > this.currentTextNode.length()) {
                n4 = this.currentTextNode.length();
            }
            this.currentTextNode.getChars(n, n4, cArray, n2);
            return n4 - n;
        }
        try {
            String string = this.provider.getStringValue().subSequence(n, n + n3).toString();
            string.getChars(0, n3, cArray, n2);
            return n3;
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return 0;
        }
    }

    public int next() throws XMLStreamException {
        int n;
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        try {
            n = this.provider.next();
        }
        catch (XPathException xPathException) {
            throw new XMLStreamException(xPathException);
        }
        switch (n) {
            case 0: {
                return this.next();
            }
            case 1: {
                this.currentTextNode.setLength(0);
                if (this.previousAtomic) {
                    this.currentTextNode.append(' ');
                }
                this.currentTextNode.append(this.provider.getAtomicValue().getStringValue());
                this.currentStaxEvent = 4;
                break;
            }
            case 2: {
                this.currentStaxEvent = 7;
                break;
            }
            case 3: {
                this.currentStaxEvent = 8;
                break;
            }
            case 4: {
                this.currentStaxEvent = 1;
                break;
            }
            case 5: {
                this.currentStaxEvent = 2;
                break;
            }
            case 8: {
                this.currentStaxEvent = 4;
                break;
            }
            case 9: {
                this.currentStaxEvent = 5;
                break;
            }
            case 10: {
                this.currentStaxEvent = 3;
                break;
            }
            case -1: {
                this.currentStaxEvent = 8;
                break;
            }
            case 6: {
                throw new XMLStreamException("Free-standing attributes cannot be serialized");
            }
            case 7: {
                throw new XMLStreamException("Free-standing namespace nodes cannot be serialized");
            }
            default: {
                throw new IllegalStateException("Unknown Stax event " + n);
            }
        }
        this.previousAtomic = n == 1;
        return this.currentStaxEvent;
    }

    public int nextTag() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return n;
    }

    public void close() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        this.provider.close();
    }

    public boolean hasName() {
        return this.currentStaxEvent == 1 || this.currentStaxEvent == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        return this.currentStaxEvent != 8;
    }

    public boolean hasText() {
        return this.currentStaxEvent == 4 || this.currentStaxEvent == 5;
    }

    public boolean isCharacters() {
        return this.currentStaxEvent == 4;
    }

    public boolean isEndElement() {
        return this.currentStaxEvent == 2;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean isStartElement() {
        return this.currentStaxEvent == 1;
    }

    public boolean isWhiteSpace() {
        try {
            return this.currentStaxEvent == 4 && Whitespace.isWhite(this.provider.getStringValue());
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return false;
        }
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int n = this.next();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content", this.getLocation());
                }
                if (n == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + n, this.getLocation());
            }
            n = this.next();
        }
        return stringBuffer.toString();
    }

    public String getEncoding() {
        return null;
    }

    public String getLocalName() {
        return this.namePool.getLocalName(this.provider.getNameCode());
    }

    public String getNamespaceURI() {
        return this.namePool.getURI(this.provider.getNameCode());
    }

    public String getPIData() {
        if (this.currentStaxEvent != 3) {
            throw new IllegalStateException("Not positioned at a processing instruction");
        }
        try {
            return this.provider.getStringValue().toString();
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "";
        }
    }

    public String getPITarget() {
        if (this.currentStaxEvent != 3) {
            throw new IllegalStateException("Not positioned at a processing instruction");
        }
        return this.namePool.getLocalName(this.provider.getNameCode());
    }

    public String getPrefix() {
        return this.namePool.getPrefix(this.provider.getNameCode());
    }

    public String getVersion() {
        return "1.0";
    }

    public String getNamespacePrefix(int n) {
        try {
            return this.provider.getNamespaceDeclarations().getPrefix(n);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "";
        }
    }

    public String getNamespaceURI(int n) {
        try {
            return this.provider.getNamespaceDeclarations().getURI(n);
        }
        catch (XPathException xPathException) {
            this.pendingException = xPathException;
            return "";
        }
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContextImpl((NamespaceResolver)this.provider);
    }

    public QName getName() {
        int n = this.provider.getNameCode();
        return new QName(this.namePool.getURI(n), this.namePool.getLocalName(n), this.namePool.getPrefix(n));
    }

    public Location getLocation() {
        SourceLocator sourceLocator = this.provider.getSourceLocator();
        if (sourceLocator == null) {
            sourceLocator = new ExpressionLocation();
        }
        return new SourceStreamLocation(sourceLocator);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return null;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.currentStaxEvent != n) {
            throw new XMLStreamException("Required event type is " + n + ", actual event is " + this.currentStaxEvent);
        }
        if (string != null && string != this.getNamespaceURI()) {
            throw new XMLStreamException("Required namespace is " + string + ", actual is " + this.getNamespaceURI());
        }
        if (string2 != null && string2 != this.getLocalName()) {
            throw new XMLStreamException("Required local name is " + string2 + ", actual is " + this.getLocalName());
        }
    }

    public String getNamespaceURI(String string) {
        return this.provider.getURIForPrefix(string, true);
    }

    public class SourceStreamLocation
    implements Location {
        private SourceLocator locator;

        public SourceStreamLocation(SourceLocator sourceLocator) {
            this.locator = sourceLocator;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return this.locator.getColumnNumber();
        }

        public int getLineNumber() {
            return this.locator.getLineNumber();
        }

        public String getPublicId() {
            return this.locator.getPublicId();
        }

        public String getSystemId() {
            return this.locator.getSystemId();
        }
    }
}

