import _extends from "@babel/runtime-corejs2/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime-corejs2/helpers/esm/objectWithoutPropertiesLoose";
import _inheritsLoose from "@babel/runtime-corejs2/helpers/esm/inheritsLoose";
import classNames from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { bsClass, prefix, splitBsProps } from './utils/bootstrapUtils';
var propTypes = {
  /**
   * Sets image as responsive image
   */
  responsive: PropTypes.bool,

  /**
   * Sets image shape as rounded
   */
  rounded: PropTypes.bool,

  /**
   * Sets image shape as circle
   */
  circle: PropTypes.bool,

  /**
   * Sets image shape as thumbnail
   */
  thumbnail: PropTypes.bool
};
var defaultProps = {
  responsive: false,
  rounded: false,
  circle: false,
  thumbnail: false
};

var Image =
/*#__PURE__*/
function (_React$Component) {
  _inheritsLoose(Image, _React$Component);

  function Image() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = Image.prototype;

  _proto.render = function render() {
    var _classes;

    var _this$props = this.props,
        responsive = _this$props.responsive,
        rounded = _this$props.rounded,
        circle = _this$props.circle,
        thumbnail = _this$props.thumbnail,
        className = _this$props.className,
        props = _objectWithoutPropertiesLoose(_this$props, ["responsive", "rounded", "circle", "thumbnail", "className"]);

    var _splitBsProps = splitBsProps(props),
        bsProps = _splitBsProps[0],
        elementProps = _splitBsProps[1];

    var classes = (_classes = {}, _classes[prefix(bsProps, 'responsive')] = responsive, _classes[prefix(bsProps, 'rounded')] = rounded, _classes[prefix(bsProps, 'circle')] = circle, _classes[prefix(bsProps, 'thumbnail')] = thumbnail, _classes);
    return React.createElement("img", _extends({}, elementProps, {
      className: classNames(className, classes)
    }));
  };

  return Image;
}(React.Component);

Image.propTypes = propTypes;
Image.defaultProps = defaultProps;
export default bsClass('img', Image);