<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Pledge/PledgePayment.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:37953335e5e08db4328298ec003c97a8)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Pledge_DAO_PledgePayment constructor.
 */
class CRM_Pledge_DAO_PledgePayment extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_pledge_payment';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   *
   * @var int unsigned
   */
  public $id;
  /**
   * FK to Pledge table
   *
   * @var int unsigned
   */
  public $pledge_id;
  /**
   * FK to contribution table.
   *
   * @var int unsigned
   */
  public $contribution_id;
  /**
   * Pledged amount for this payment (the actual contribution amount might be different).
   *
   * @var float
   */
  public $scheduled_amount;
  /**
   * Actual amount that is paid as the Pledged installment amount.
   *
   * @var float
   */
  public $actual_amount;
  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;
  /**
   * The date the pledge payment is supposed to happen.
   *
   * @var datetime
   */
  public $scheduled_date;
  /**
   * The date that the most recent payment reminder was sent.
   *
   * @var datetime
   */
  public $reminder_date;
  /**
   * The number of payment reminders sent.
   *
   * @var int unsigned
   */
  public $reminder_count;
  /**
   *
   * @var int unsigned
   */
  public $status_id;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_pledge_payment';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'pledge_id', 'civicrm_pledge', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_id', 'civicrm_contribution', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'pledge_payment_id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Payment ID') ,
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge_payment.id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
        ) ,
        'pledge_id' => array(
          'name' => 'pledge_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge') ,
          'description' => 'FK to Pledge table',
          'required' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
          'FKClassName' => 'CRM_Pledge_DAO_Pledge',
        ) ,
        'contribution_id' => array(
          'name' => 'contribution_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contribution') ,
          'description' => 'FK to contribution table.',
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contribute_DAO_Contribution',
        ) ,
        'pledge_payment_scheduled_amount' => array(
          'name' => 'scheduled_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Scheduled Amount') ,
          'description' => 'Pledged amount for this payment (the actual contribution amount might be different).',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'import' => true,
          'where' => 'civicrm_pledge_payment.scheduled_amount',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
        ) ,
        'pledge_payment_actual_amount' => array(
          'name' => 'actual_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Actual Amount') ,
          'description' => 'Actual amount that is paid as the Pledged installment amount.',
          'precision' => array(
            20,
            2
          ) ,
          'import' => true,
          'where' => 'civicrm_pledge_payment.actual_amount',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
        ) ,
        'currency' => array(
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Currency') ,
          'description' => '3 character string, value from config setting or input via user.',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'default' => 'NULL',
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'name',
          )
        ) ,
        'pledge_payment_scheduled_date' => array(
          'name' => 'scheduled_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Scheduled Date') ,
          'description' => 'The date the pledge payment is supposed to happen.',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge_payment.scheduled_date',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
        ) ,
        'pledge_payment_reminder_date' => array(
          'name' => 'reminder_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Last Reminder') ,
          'description' => 'The date that the most recent payment reminder was sent.',
          'import' => true,
          'where' => 'civicrm_pledge_payment.reminder_date',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
        ) ,
        'pledge_payment_reminder_count' => array(
          'name' => 'reminder_count',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Reminders Sent') ,
          'description' => 'The number of payment reminders sent.',
          'import' => true,
          'where' => 'civicrm_pledge_payment.reminder_count',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
        ) ,
        'pledge_payment_status_id' => array(
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Payment Status') ,
          'import' => true,
          'where' => 'civicrm_pledge_payment.status_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => false,
          'table_name' => 'civicrm_pledge_payment',
          'entity' => 'PledgePayment',
          'bao' => 'CRM_Pledge_BAO_PledgePayment',
          'localizable' => 0,
          'pseudoconstant' => array(
            'optionGroupName' => 'contribution_status',
            'optionEditPath' => 'civicrm/admin/options/contribution_status',
          )
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'pledge_payment', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'pledge_payment', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'index_contribution_pledge' => array(
        'name' => 'index_contribution_pledge',
        'field' => array(
          0 => 'contribution_id',
          1 => 'pledge_id',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_pledge_payment::0::contribution_id::pledge_id',
      ) ,
      'index_status' => array(
        'name' => 'index_status',
        'field' => array(
          0 => 'status_id',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_pledge_payment::0::status_id',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
