//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Project/ProjectUtil.cpp
//! @brief     Implements ProjectUtils namespace
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Project/ProjectUtil.h"
#include <QFileInfo>

QString GUI::Project::Util::projectName(const QString& projectFullPath)
{
    return QFileInfo(projectFullPath).baseName();
}

QString GUI::Project::Util::projectDir(const QString& projectFullPath)
{
    return QFileInfo(projectFullPath).path();
}

QString GUI::Project::Util::autosaveSubdir()
{
    return "autosave";
}

QString GUI::Project::Util::autosaveDir(const QString& projectFullPath)
{
    return projectDir(projectFullPath) + "/" + autosaveSubdir();
}

QString GUI::Project::Util::autosaveFullPath(const QString& projectFullPath)
{
    return autosaveDir(projectFullPath) + "/" + projectName(projectFullPath) + projectFileExtension;
}

bool GUI::Project::Util::hasAutosavedData(const QString& projectFullPath)
{
    return QFile::exists(projectFullPath) && QFile::exists(autosaveFullPath(projectFullPath));
}

bool GUI::Project::Util::isAutosave(const QString& projectFullPath)
{
    return projectFullPath.contains(autosaveSubdir());
}
