

#include "stdplatform.h"

std::string getStdPlatformXML(const std::string & platform) {
  std::string result = "<?xml version=\"1.0\"?>";
  result += "<xhex version=\"1.0\">";
  if (platform =="NIBObee") {
    result += "<platform>NIBObee</platform>";
    result += "<programmer type=\"usbasp\"/>";
    result += "<device part=\"atmega16\" erase=\"yes\">";
  } else if (platform =="NIBObee Tuning") {
    result += "<platform>NIBObee Tuning</platform>";
    result += "<programmer type=\"usbasp\"/>";
    result += "<device part=\"atmega1284\" erase=\"yes\">";
  } else if (platform =="NIBO burger") {
    result += "<platform>NIBO burger</platform>";
    result += "<programmer type=\"usbasp\"/>";
    result += "<device part=\"atmega16\" erase=\"yes\">";
  } else if (platform =="NIBO burger Tuning") {
    result += "<platform>NIBO burger Tuning</platform>";
    result += "<programmer type=\"usbasp\"/>";
    result += "<device part=\"atmega1284\" erase=\"yes\">";
  } else if (platform =="NIBO 2") {
    result += "<platform>NIBO 2</platform>";
    result += "<programmer type=\"stk500v2\"/>";
    result += "<device part=\"atmega128\" erase=\"yes\">";
  } else {
    result += "<platform>Custom MCU</platform>";
    result += "<device part=\"_\" erase=\"yes\">";
  }
  result += "<segment id=\"flash\" format=\"ihex\">";
  result += "</segment>";
  result += "</device>";
  result += "</xhex>";
  return result;
}
