/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 20:29:10 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.util.LinkedList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.components.variant.CDSFeature;
import uk.ac.sanger.artemis.components.variant.VCFview;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class VCFview_ESTest extends VCFview_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      LinkedList<CDSFeature> linkedList0 = new LinkedList<CDSFeature>();
      RangeVector rangeVector0 = new RangeVector();
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 17, 215, "ER_ARG_LITERAL");
      linkedList0.offerLast(cDSFeature0);
      boolean boolean0 = VCFview.isOverlappingFeature(linkedList0, 610);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      LinkedList<CDSFeature> linkedList0 = new LinkedList<CDSFeature>();
      RangeVector rangeVector0 = new RangeVector((Range) null);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, 8388607, 15, "-h-h");
      linkedList0.add(cDSFeature0);
      boolean boolean0 = VCFview.isOverlappingFeature(linkedList0, (-122607198));
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String[] stringArray0 = new String[5];
      stringArray0[0] = "-v";
      // Undeclared exception!
      try { 
        VCFview.main(stringArray0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // null
         //
         verifyException("java.lang.Integer", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      String[] stringArray0 = new String[7];
      stringArray0[0] = "|l$+kz[@\"d";
      stringArray0[1] = "-r";
      // Undeclared exception!
      try { 
        VCFview.main(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      String[] stringArray0 = new String[3];
      stringArray0[0] = "-f";
      stringArray0[1] = "-f";
      stringArray0[2] = "s*MM9l5*#K^hB0bx";
      // Undeclared exception!
      try { 
        VCFview.main(stringArray0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      String[] stringArray0 = new String[0];
      // Undeclared exception!
      try { 
        VCFview.main(stringArray0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      LinkedList<CDSFeature> linkedList0 = new LinkedList<CDSFeature>();
      RangeVector rangeVector0 = new RangeVector();
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, (-122607198), 4000000, "3?l:gE]3wl0aA");
      linkedList0.add(cDSFeature0);
      boolean boolean0 = VCFview.isOverlappingFeature(linkedList0, 610);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      LinkedList<CDSFeature> linkedList0 = new LinkedList<CDSFeature>();
      RangeVector rangeVector0 = new RangeVector((Range) null);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, (-122607198), 4000000, "3?l:gE]3wl0aA");
      linkedList0.add(cDSFeature0);
      boolean boolean0 = VCFview.isOverlappingFeature(linkedList0, 4000000);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      LinkedList<CDSFeature> linkedList0 = new LinkedList<CDSFeature>();
      RangeVector rangeVector0 = new RangeVector((Range) null);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, (-122607198), 4000000, "3?l:gE]3wl0aA");
      linkedList0.add(cDSFeature0);
      // Undeclared exception!
      try { 
        VCFview.isOverlappingFeature(linkedList0, 610);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFview", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LinkedList<CDSFeature> linkedList0 = new LinkedList<CDSFeature>();
      RangeVector rangeVector0 = new RangeVector((Range) null);
      CDSFeature cDSFeature0 = new CDSFeature(false, rangeVector0, (-122607198), 4000000, "3?l:gE]3wl0aA");
      linkedList0.add(cDSFeature0);
      boolean boolean0 = VCFview.isOverlappingFeature(linkedList0, (-122607198));
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      KeyVector keyVector0 = new KeyVector(key0);
      // Undeclared exception!
      try { 
        VCFview.isOverlappingFeature(keyVector0, (-1597));
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Key cannot be cast to uk.ac.sanger.artemis.components.variant.CDSFeature
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFview", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      Entry entry0 = new Entry(bases0, emblDocumentEntry0);
      FeatureVector featureVector0 = entry0.checkForNonEMBLKeys();
      featureVector0.insertElementAfter((Feature) null, (Feature) null);
      // Undeclared exception!
      try { 
        VCFview.isOverlappingFeature(featureVector0, (-5));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFview", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(simpleEntryInformation0);
      Entry entry0 = new Entry(bases0, emblDocumentEntry0);
      FeatureVector featureVector0 = entry0.getAllFeatures();
      boolean boolean0 = VCFview.isOverlappingFeature(featureVector0, (-5));
      assertFalse(boolean0);
  }
}
