/*
 * Copyright 2021 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef SOC_DEFAULT_BASE_ADDR_H
#define SOC_DEFAULT_BASE_ADDR_H

/* CCSR mmu_def.h */
#define NXP_CCSR_ADDR			0x1000000
#define NXP_CCSR_SIZE			0xF000000

#define NXP_DCSR_ADDR			0x700000000
#define NXP_DCSR_SIZE			0x40000000

/* Flex-SPI controller address */
#define NXP_FLEXSPI_ADDR		0x020C0000
/* Flex-SPI Flash Start address */
#define NXP_FLEXSPI_FLASH_ADDR		0x20000000

/* MMU 500 soc.c*/
#define NXP_SMMU_ADDR			0x05000000

#define NXP_SNVS_ADDR			0x01E90000

#define NXP_DCFG_ADDR			0x01E00000
#define NXP_PMU_CCSR_ADDR		0x01E30000
#define NXP_PMU_DCSR_ADDR		0x700123000
#define NXP_PMU_ADDR                    NXP_PMU_CCSR_ADDR
#define NXP_SFP_ADDR			0x01E80000
#define NXP_SCFG_ADDR			0x01FC0000
#define NXP_I2C_ADDR			0x02000000
#define NXP_ESDHC_ADDR			0x02140000
#define NXP_ESDHC2_ADDR			0x02150000
#define NXP_UART_ADDR			0x021C0000
#define NXP_UART1_ADDR			0x021D0000

#define NXP_GPIO1_ADDR			0x02300000
#define NXP_GPIO2_ADDR			0x02310000
#define NXP_GPIO3_ADDR			0x02320000
#define NXP_GPIO4_ADDR			0x02330000

#define NXP_WDOG1_NS_ADDR		0x02390000
#define NXP_WDOG2_NS_ADDR		0x023A0000
#define NXP_WDOG1_TZ_ADDR		0x023B0000
#define NXP_WDOG2_TZ_ADDR		0x023C0000

#define NXP_TIMER_STATUS_ADDR		0x023F0000

#define NXP_GICD_ADDR			0x06000000
#define NXP_GICR_ADDR			0x06200000
#define NXP_GICR_SGI_ADDR		0x06210000

#define NXP_CAAM_ADDR			0x08000000

#define NXP_TZC_ADDR			0x01100000
#define NXP_TZC2_ADDR			0x01110000
#define NXP_TZC3_ADDR			0x01120000

#define NXP_RESET_ADDR			0x01E60000
#define NXP_SEC_REGFILE_ADDR		0x01E88000
#endif	/*	SOC_DEFAULT_BASE_ADDR_H		*/
