
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Adjacent CDATASection nodes cannot be merged together by
 * use of the "normalize()" method from the Element interface.
 * Retrieve second child of the second employee and invoke
 * the "normalize()" method.  The Element under contains
 * two CDATASection nodes that should not be merged together
 * by the "normalize()" method.
* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-162CF083</a>
*/
public final class cdatasectionnormalize extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public cdatasectionnormalize(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList nameList;
      Element lChild;
      NodeList childNodes;
      CDATASection cdataN;
      String data;
      doc = (Document) load("staff", true);
      nameList = doc.getElementsByTagName("name");
      lChild = (Element) nameList.item(1);
      lChild.normalize();
      childNodes = lChild.getChildNodes();
      cdataN = (CDATASection) childNodes.item(1);
      assertNotNull("firstCDATASection", cdataN);
      data = cdataN.getData();
      assertEquals("data1", "This is a CDATASection with EntityReference number 2 &ent2;", data);
      cdataN = (CDATASection) childNodes.item(3);
      assertNotNull("secondCDATASection", cdataN);
      data = cdataN.getData();
      assertEquals("data3", "This is an adjacent CDATASection with a reference to a tab &tab;", data);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/cdatasectionnormalize";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(cdatasectionnormalize.class, args);
   }
}

