/* $Id$ */

/* _PDCLIB_stdinit

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

/* This is an example initialization of stdin, stdout and stderr to the integer
   file descriptors 0, 1, and 2, respectively. This applies for a great variety
   of operating systems, including POSIX compliant ones.
*/

#include <stdio.h>
#include <locale.h>
#include <limits.h>

#ifndef REGTEST

/* In a POSIX system, stdin / stdout / stderr are equivalent to the (int) file
   descriptors 0, 1, and 2 respectively.
*/
/* TODO: This is proof-of-concept, requires finetuning. */

__attribute__ ((section(".text")))
struct _PDCLIB_file_t * stdin = (struct _PDCLIB_file_t *) 1;
__attribute__ ((section(".text")))
struct _PDCLIB_file_t * stdout = (struct _PDCLIB_file_t *) 1;
__attribute__ ((section(".text")))
struct _PDCLIB_file_t * stderr = (struct _PDCLIB_file_t *) 1;

#endif

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    /* Testing covered by several other testdrivers using stdin / stdout / 
       stderr.
    */
    return TEST_RESULTS;
}

#endif
