package adql.query;

/*
 * This file is part of ADQLLibrary.
 * 
 * ADQLLibrary is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * ADQLLibrary is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ADQLLibrary.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Copyright 2012 - UDS/Centre de Données astronomiques de Strasbourg (CDS)
 */

import java.util.NoSuchElementException;

/**
 * An ADQL iterator which has no ADQL objects on which iterate.
 * 
 * @author Gr&eacute;gory Mantelet (CDS)
 * @version 06/2011
 */
public class NullADQLIterator implements ADQLIterator {

	public boolean hasNext(){
		return false;
	}

	public ADQLObject next(){
		throw new NoSuchElementException();
	}

	public void remove(){
		throw new UnsupportedOperationException();
	}

	public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException{
		throw new UnsupportedOperationException();
	}

}
