/*
 *             Otter 3.0.x -- Automated Deduction System
 *
 *                   Argonne National Laboratory
 *
 */

#define OTTER_VERSION "3.0.6"
#define VERSION_DATE  "April 2000"

#define IN_MAIN  /* so that global vars in header.h will not be external */
#include "header.h"

 int main(argc, argv)
     int argc;
     char **argv;
{
    struct clause *giv_cl;
    int errors, status, level, first_of_next_level;
    char *str;
    FILE *xlog_fp;
    
    non_portable_init(argc, argv);
    print_banner(argc, argv);
    init();

#ifdef SCOTT
    CLOCK_START(FINDER_TIME)
    finder_init(argc, argv);
    CLOCK_STOP(FINDER_TIME)
#endif

    read_all_input(argc, argv);
    errors = Stats[INPUT_ERRORS];
    if (errors != 0) {
	fprintf(stderr, "\n%d input errors were found.%c\n\n", errors, Bell);
	printf("%d input errors were found.\n", errors);
	exit(INPUT_ERROR_EXIT);
	}
    else {
	status = check_stop();
	if (status == KEEP_SEARCHING) {
	  if (splitting() && Parms[SPLIT_GIVEN].val == 0)
	    always_split();  /* never returns */
	  giv_cl = extract_given_clause();
	}
	else
	  giv_cl = NULL;
#ifdef SCOTT
        CLOCK_START(FINDER_TIME)
        test_if_dsr(giv_cl);
        CLOCK_STOP(FINDER_TIME)
#endif
	level = 0;
	first_of_next_level = 0;

	if (Flags[LOG_FOR_X_SHOW].val)
	    xlog_fp = init_log_for_x_show();

/* --------------------- MAIN LOOP STARTS HERE --------------------- */

	printf("\n=========== start of search ===========\n"); fflush(stdout);

	while (giv_cl != NULL && status == KEEP_SEARCHING) {

	    if (Flags[SOS_QUEUE].val && giv_cl->id >= first_of_next_level) {
		level++;
		first_of_next_level = next_cl_num();
		printf("\nStarting on level %d, last kept clause of level %d is %d.\n\n", level, level-1, first_of_next_level-1);
		fprintf(stderr, "\n%cStarting on level %d, last kept clause of level %d is %d.\n\n", Bell, level, level-1, first_of_next_level-1);
		}

	    if (Flags[LOG_FOR_X_SHOW].val)
		log_for_x_show(xlog_fp);

	    Stats[CL_GIVEN]++;

	    if (Flags[PRINT_GIVEN].val) {
		printf("\ngiven clause #%ld: ", Stats[CL_GIVEN]);
		printf("(wt=%d) ", giv_cl->pick_weight);
		print_clause(stdout, giv_cl); fflush(stdout);
		}
#if defined(DOS_GCC) || defined(TURBO_C) || defined(THINK_C)
	    /* if DOS or Macintosh, so user knows something is happening */
            fprintf(stderr, ".");
            if (Stats[CL_GIVEN] % 50 == 0)
		fprintf(stderr, " %ld clauses given.\n", Stats[CL_GIVEN]);
#endif
	    index_lits_clash(giv_cl);
	    append_cl(Usable, giv_cl);
#ifdef PRUNE
	    giv_cl->time_stamp = next_cl_num();
	    possible_prune();
#endif
	    if (splitting())
	      possible_given_split(giv_cl);
	    infer_and_process(giv_cl);

	    if (Parms[INTERRUPT_GIVEN].val > 0 &&
		Stats[CL_GIVEN] % Parms[INTERRUPT_GIVEN].val == 0) {
		fprintf(stderr, "\n%c%ld clauses have been given.\n", Bell, Stats[CL_GIVEN]);
		interact();
		}

	    status = check_stop();


	    if (status == KEEP_SEARCHING) {
		if (Parms[CHANGE_LIMIT_AFTER].val == Stats[CL_GIVEN]) {
		    int new_limit;
		    new_limit = Parms[NEW_MAX_WEIGHT].val;
		    Parms[MAX_WEIGHT].val = new_limit;
		    printf("\nreducing weight limit to %d.\n", new_limit);
		    }
		if (splitting())
		  possible_split();  /* parent does not return if successful */
		giv_cl = extract_given_clause();
#ifdef SCOTT
                CLOCK_START(FINDER_TIME)
                test_if_dsr(giv_cl);
                CLOCK_STOP(FINDER_TIME)
#endif
		}

	    if (status == KEEP_SEARCHING && giv_cl && Parms[REPORT].val > 0)
		report();

	    }  /* end of main loop */

/* --------------------- MAIN LOOP ENDS HERE --------------------- */

	/* print the reason the search ended */

	if (status == KEEP_SEARCHING) {
	    if (splitting() && current_case() != NULL)
	      exit_with_possible_model();  /* this call does not return here */
	    status = SOS_EMPTY_EXIT;
	    fprintf(stderr, "\n%cSearch stopped because sos empty.\n\n", Bell);
	    printf("\nSearch stopped because sos empty.\n");
	    }
	else {
	    switch (status) {
	      case MAX_GIVEN_EXIT: str = "max_given"; break;
	      case MAX_GEN_EXIT: str = "max_gen"; break;
	      case MAX_KEPT_EXIT: str = "max_kept"; break;
	      case MAX_SECONDS_EXIT: str = "max_seconds"; break;
	      default: str = "???"; break;
		}

	    fprintf(stderr, "\nSearch stopped by %s option.%c\n\n", str, Bell);
	    printf("\nSearch stopped by %s option.\n", str);
	    }

	cleanup();
	exit(status);
	}

}  /* main */

/*************
 *
 *    void print_banner(argc, argv)
 *
 *************/

void print_banner(argc, argv)
     int argc;
     char **argv;
{
    int i;
    int pid = my_process_id();
    
    printf("----- Otter %s, %s -----\n", OTTER_VERSION, VERSION_DATE);
    printf("The process was started by %s on %s, %s",
	   username(), hostname(), get_time());

    printf("The command was \"");
    for(i = 0; i < argc; i++)
        printf("%s%s", argv[i], (i < argc-1 ? " " : ""));
    printf("\".");
    if (pid != 0)
      printf("  The process ID is %d.\n\n", pid);
    else
      printf("\n\n");
    
}  /* print_banner */
