/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_SAPAvailableForSoftwareInventoryAccess.h"

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(SoftwareInventory_CIM_ServiceAccessPoint_load(broker, errorMessage));
	CF_assert(SoftwareInventory_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(SoftwareInventory_CIM_ServiceAccessPoint_unload(errorMessage));
	CF_assert(SoftwareInventory_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_isAssociated(const Instance& AvailableSAP, const Instance& ManagedElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SAPAvailableForSoftwareInventory>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateAvailableSAPs(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateAvailableSAPs(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			AvailableSAP_classnames[0], ManagedElement_classnames[0],
			AvailableSAP_role.c_str(), ManagedElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_referenceAvailableSAPToManagedElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SAPAvailableForSoftwareInventory& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath AvailableSAP_objectpath;
	instance.getAvailableSAP(AvailableSAP_objectpath);
	Instance AvailableSAP_instance;
	CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_getAvailableSAP(broker, ctx, AvailableSAP_objectpath, AvailableSAP_instance, NULL, errorMessage));
	
	Objectpath ManagedElement_objectpath;
	instance.getManagedElement(ManagedElement_objectpath);
	Instance ManagedElement_instance;
	CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_getManagedElement(broker, ctx, ManagedElement_objectpath, ManagedElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_isAssociated(AvailableSAP_instance, ManagedElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SAPAvailableForSoftwareInventory& newInstance, const OpenDRIM_SAPAvailableForSoftwareInventory& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SAPAvailableForSoftwareInventory& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SAPAvailableForSoftwareInventory& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_associatorAvailableSAPToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AvailableSAP_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ManagedElement_instances;
	if (discriminant=="a")
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ManagedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_isAssociated(AvailableSAP_instance, ManagedElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ManagedElement_associatedInstances.push_back(ManagedElement_instances[i]);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_associatorManagedElementToAvailableSAP(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& AvailableSAP_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> AvailableSAP_instances;
	if (discriminant=="a")
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateAvailableSAPs(broker, ctx, AvailableSAP_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateAvailableSAPs(broker, ctx, AvailableSAP_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_enumerateAvailableSAPs(broker, ctx, AvailableSAP_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<AvailableSAP_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_isAssociated(AvailableSAP_instances[i], ManagedElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			AvailableSAP_associatedInstances.push_back(AvailableSAP_instances[i]);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_referenceAvailableSAPToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AvailableSAP_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SAPAvailableForSoftwareInventory>& OpenDRIM_SAPAvailableForSoftwareInventory_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ManagedElement_instances.size(); i++) {
		OpenDRIM_SAPAvailableForSoftwareInventory instance;
		instance.setAvailableSAP(((Instance) AvailableSAP_instance).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instances[i]).getObjectpath());
		
		OpenDRIM_SAPAvailableForSoftwareInventory_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_referenceManagedElementToAvailableSAP(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& AvailableSAP_instances, vector<OpenDRIM_SAPAvailableForSoftwareInventory>& OpenDRIM_SAPAvailableForSoftwareInventory_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < AvailableSAP_instances.size(); i++) {
		OpenDRIM_SAPAvailableForSoftwareInventory instance;
		instance.setAvailableSAP(((Instance) AvailableSAP_instances[i]).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instance).getObjectpath());
		
		OpenDRIM_SAPAvailableForSoftwareInventory_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_SAPAvailableForSoftwareInventory_populate(OpenDRIM_SAPAvailableForSoftwareInventory& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

