/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class GPSInfoIFD
extends IFD {
    private static final int GPSVERSIONID = 0;
    private static final int GPSLATITUDEREF = 1;
    private static final int GPSLATITUDE = 2;
    private static final int GPSLONGITUDEREF = 3;
    private static final int GPSLONGITUDE = 4;
    private static final int GPSALTITUDEREF = 5;
    private static final int GPSALTITUDE = 6;
    private static final int GPSTIMESTAMP = 7;
    private static final int GPSSATELLITES = 8;
    private static final int GPSSTATUS = 9;
    private static final int GPSMEASUREMODE = 10;
    private static final int GPSDOP = 11;
    private static final int GPSSPEEDREF = 12;
    private static final int GPSSPEED = 13;
    private static final int GPSTRACKREF = 14;
    private static final int GPSTRACK = 15;
    private static final int GPSIMGDIRECTIONREF = 16;
    private static final int GPSIMGDIRECTION = 17;
    private static final int GPSMAPDATUM = 18;
    private static final int GPSDESTLATITUDEREF = 19;
    private static final int GPSDESTLATITUDE = 20;
    private static final int GPSDESTLONGITUDEREF = 21;
    private static final int GPSDESTLONGITUDE = 22;
    private static final int GPSDESTBEARINGREF = 23;
    private static final int GPSDESTBEARING = 24;
    private static final int GPSDESTDISTANCEREF = 25;
    private static final int GPSDESTDISTANCE = 26;
    private static final int GPSPROCESSINGMETHOD = 27;
    private static final int GPSAREAINFORMATION = 28;
    private static final int GPSDATESTAMP = 29;
    private static final int GPSDIFFERENTIAL = 30;
    private int[] _gpsVersionID = new int[]{2, 2, 0, 0};
    private String _gpsLatitudeRef;
    private Rational[] _gpsLatitude;
    private String _gpsLongitudeRef;
    private Rational[] _gpsLongitude;
    private int _gpsAltitudeRef = 0;
    private Rational _gpsAltitude;
    private Rational[] _gpsTimeStamp;
    private String _gpsSatellites;
    private String _gpsStatus;
    private String _gpsMeasureMode;
    private Rational _gpsDOP;
    private String _gpsSpeedRef = "K";
    private Rational _gpsSpeed;
    private String _gpsTrackRef = "T";
    private Rational _gpsTrack;
    private String _gpsImgDirectionRef = "T";
    private Rational _gpsImgDirection;
    private String _gpsMapDatum;
    private String _gpsDestLatitudeRef;
    private Rational[] _gpsDestLatitude;
    private String _gpsDestLongitudeRef;
    private Rational[] _gpsDestLongitude;
    private String _gpsDestBearingRef = "T";
    private Rational _gpsDestBearing;
    private String _gpsDestDistanceRef = "K";
    private Rational _gpsDestDistance;
    private int[] _gpsProcessingMethod;
    private int[] _gpsAreaInformation;
    private String _gpsDateStamp;
    private int _gpsDifferential = -1;

    public GPSInfoIFD(long l, RepInfo repInfo, RandomAccessFile randomAccessFile, boolean bl) {
        super(l, repInfo, randomAccessFile, bl);
    }

    public Rational getGPSAltitude() {
        return this._gpsAltitude;
    }

    public int getGPSAltitudeRef() {
        return this._gpsAltitudeRef;
    }

    public String getGPSDateStamp() {
        return this._gpsDateStamp;
    }

    public Rational getGPSDestBearing() {
        return this._gpsDestBearing;
    }

    public String getGPSDestBearingRef() {
        return this._gpsDestBearingRef;
    }

    public Rational getGPSDestDistance() {
        return this._gpsDestDistance;
    }

    public String getGPSDestDistanceRef() {
        return this._gpsDestDistanceRef;
    }

    public Rational[] getGPSDestLatitude() {
        return this._gpsDestLatitude;
    }

    public String getGPSDestLatitudeRef() {
        return this._gpsDestLatitudeRef;
    }

    public Rational[] getGPSDestLongitude() {
        return this._gpsDestLongitude;
    }

    public String getGPSDestLongitudeRef() {
        return this._gpsDestLongitudeRef;
    }

    public int getGPSDifferential() {
        return this._gpsDifferential;
    }

    public Rational getGPSDOP() {
        return this._gpsDOP;
    }

    public Rational getGPSImgDirection() {
        return this._gpsImgDirection;
    }

    public String getGPSImgDirectionRef() {
        return this._gpsImgDirectionRef;
    }

    public Rational[] getGPSLatitude() {
        return this._gpsLatitude;
    }

    public String getGPSLatitudeRef() {
        return this._gpsLatitudeRef;
    }

    public Rational[] getGPSLongitude() {
        return this._gpsLongitude;
    }

    public String getGPSLongitudeRef() {
        return this._gpsLongitudeRef;
    }

    public String getGPSMapDatum() {
        return this._gpsMapDatum;
    }

    public String getGPSMeasureMode() {
        return this._gpsMeasureMode;
    }

    public int[] getGPSProcessingMethod() {
        return this._gpsProcessingMethod;
    }

    public String getGPSSatellites() {
        return this._gpsSatellites;
    }

    public Rational getGPSSpeed() {
        return this._gpsSpeed;
    }

    public String getGPSSpeedRef() {
        return this._gpsSpeedRef;
    }

    public String getGPStatus() {
        return this._gpsStatus;
    }

    public Rational[] getGPTimeStamp() {
        return this._gpsTimeStamp;
    }

    public Rational getGPSTrack() {
        return this._gpsTrack;
    }

    public String getGPSTrackRef() {
        return this._gpsTrackRef;
    }

    public int[] getGPSVersionID() {
        return this._gpsVersionID;
    }

    @Override
    public Property getProperty(boolean bl) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        linkedList.add(new Property("GPSVersionID", PropertyType.STRING, (Object)(Integer.toString(this._gpsVersionID[0]) + "." + Integer.toString(this._gpsVersionID[1]) + "." + Integer.toString(this._gpsVersionID[2]) + "." + Integer.toString(this._gpsVersionID[3]))));
        if (this._gpsLatitudeRef != null) {
            linkedList.add(new Property("GPSLatitudeRef", PropertyType.STRING, (Object)this._gpsLatitudeRef));
        }
        if (this._gpsLatitude != null) {
            linkedList.add(new Property("GPSLatitude", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._gpsLatitude));
        }
        if (this._gpsLongitudeRef != null) {
            linkedList.add(new Property("GPSLongitudeRef", PropertyType.STRING, (Object)this._gpsLongitudeRef));
        }
        if (this._gpsLongitude != null) {
            linkedList.add(new Property("GPSLongitude", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._gpsLongitude));
        }
        linkedList.add(new Property("GPSAltitudeRef", PropertyType.INTEGER, (Object)new Integer(this._gpsAltitudeRef)));
        if (this._gpsAltitude != null) {
            linkedList.add(new Property("GPSAltitude", PropertyType.RATIONAL, (Object)this._gpsAltitude));
        }
        if (this._gpsTimeStamp != null) {
            linkedList.add(new Property("GPSTimeStamp", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._gpsTimeStamp));
        }
        if (this._gpsSatellites != null) {
            linkedList.add(new Property("GPSSatellites", PropertyType.STRING, (Object)this._gpsSatellites));
        }
        if (this._gpsStatus != null) {
            linkedList.add(new Property("GPSStatus", PropertyType.STRING, (Object)this._gpsStatus));
        }
        if (this._gpsMeasureMode != null) {
            linkedList.add(new Property("GPSMeasureMode", PropertyType.STRING, (Object)this._gpsMeasureMode));
        }
        if (this._gpsDOP != null) {
            linkedList.add(new Property("GPSDOP", PropertyType.RATIONAL, (Object)this._gpsDOP));
        }
        linkedList.add(new Property("GPSSpeedRef", PropertyType.STRING, (Object)this._gpsSpeedRef));
        if (this._gpsSpeed != null) {
            linkedList.add(new Property("GPSSpeed", PropertyType.RATIONAL, (Object)this._gpsSpeed));
        }
        linkedList.add(new Property("GPSTrackRef", PropertyType.STRING, (Object)this._gpsTrackRef));
        if (this._gpsTrack != null) {
            linkedList.add(new Property("GPSTrack", PropertyType.RATIONAL, (Object)this._gpsTrack));
        }
        linkedList.add(new Property("GPSImgDirectionRef", PropertyType.STRING, (Object)this._gpsImgDirectionRef));
        if (this._gpsImgDirection != null) {
            linkedList.add(new Property("GPSImgDirection", PropertyType.RATIONAL, (Object)this._gpsImgDirection));
        }
        if (this._gpsMapDatum != null) {
            linkedList.add(new Property("GPSMapDatum", PropertyType.STRING, (Object)this._gpsMapDatum));
        }
        if (this._gpsDestLatitudeRef != null) {
            linkedList.add(new Property("GPSDestLatitudeRef", PropertyType.STRING, (Object)this._gpsDestLatitudeRef));
        }
        if (this._gpsDestLatitude != null) {
            linkedList.add(new Property("GPSDestLatitude", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._gpsDestLatitude));
        }
        if (this._gpsDestLongitudeRef != null) {
            linkedList.add(new Property("GPSDestLongitudeRef", PropertyType.STRING, (Object)this._gpsDestLongitudeRef));
        }
        if (this._gpsDestLongitude != null) {
            linkedList.add(new Property("GPSDestLongitude", PropertyType.RATIONAL, PropertyArity.ARRAY, (Object)this._gpsDestLongitude));
        }
        linkedList.add(new Property("GPSDestBearingRef", PropertyType.STRING, (Object)this._gpsDestBearingRef));
        if (this._gpsDestBearing != null) {
            linkedList.add(new Property("GPSDestBearing", PropertyType.RATIONAL, (Object)this._gpsDestBearing));
        }
        linkedList.add(new Property("GPSDestDistanceRef", PropertyType.STRING, (Object)this._gpsDestDistanceRef));
        if (this._gpsDestDistance != null) {
            linkedList.add(new Property("GPSDestDistance", PropertyType.RATIONAL, (Object)this._gpsDestDistance));
        }
        if (this._gpsDestDistanceRef != null) {
            linkedList.add(new Property("GPSDestDistanceRef", PropertyType.STRING, (Object)this._gpsDestDistanceRef));
        }
        if (this._gpsProcessingMethod != null) {
            linkedList.add(new Property("GPSProcessingMethod", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._gpsProcessingMethod));
        }
        if (this._gpsAreaInformation != null) {
            linkedList.add(new Property("GPSAreaInformation", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._gpsAreaInformation));
        }
        if (this._gpsDateStamp != null) {
            linkedList.add(new Property("GPSDateStamp", PropertyType.STRING, (Object)this._gpsDateStamp));
        }
        linkedList.add(new Property("GPSDifferential", PropertyType.INTEGER, (Object)new Integer(this._gpsDifferential)));
        return this.propertyHeader("GPSInfo", linkedList);
    }

    @Override
    public void lookupTag(int n, int n2, long l, long l2) throws TiffException {
        try {
            if (n == 6) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsAltitude = this.readRational(l, l2);
            } else if (n == 5) {
                GPSInfoIFD.checkType(n, n2, 1);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsAltitudeRef = this.readByte(n2, l, l2);
            } else if (n == 29) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 11);
                this._gpsDateStamp = this.readASCII(l, l2);
            } else if (n == 24) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsDestBearing = this.readRational(l, l2);
            } else if (n == 23) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsDestBearingRef = this.readASCII(l, l2);
            } else if (n == 26) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsDestDistance = this.readRational(l, l2);
            } else if (n == 25) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsDestDistanceRef = this.readASCII(l, l2);
            } else if (n == 20) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 3);
                this._gpsDestLatitude = this.readRationalArray(l, l2);
            } else if (n == 19) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsDestLatitudeRef = this.readASCII(l, l2);
            } else if (n == 22) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 3);
                this._gpsDestLongitude = this.readRationalArray(l, l2);
            } else if (n == 21) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsDestLongitudeRef = this.readASCII(l, l2);
            } else if (n == 30) {
                GPSInfoIFD.checkType(n, n2, 3);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsDifferential = this.readShort(n2, l, l2);
            } else if (n == 11) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsDOP = this.readRational(l, l2);
            } else if (n == 17) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsImgDirection = this.readRational(l, l2);
            } else if (n == 16) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsImgDirectionRef = this.readASCII(l, l2);
            } else if (n == 2) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 3);
                this._gpsLatitude = this.readRationalArray(l, l2);
            } else if (n == 1) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsLatitudeRef = this.readASCII(l, l2);
            } else if (n == 4) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 3);
                this._gpsLongitude = this.readRationalArray(l, l2);
            } else if (n == 3) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsLongitudeRef = this.readASCII(l, l2);
            } else if (n == 18) {
                GPSInfoIFD.checkType(n, n2, 2);
                this._gpsMapDatum = this.readASCII(l, l2);
            } else if (n == 10) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsMeasureMode = this.readASCII(l, l2);
            } else if (n == 27) {
                GPSInfoIFD.checkType(n, n2, 7);
                this._gpsProcessingMethod = this.readByteArray(n2, l, l2);
            } else if (n == 8) {
                GPSInfoIFD.checkType(n, n2, 2);
                this._gpsSatellites = this.readASCII(l, l2);
            } else if (n == 13) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsSpeed = this.readRational(l, l2);
            } else if (n == 12) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsSpeedRef = this.readASCII(l, l2);
            } else if (n == 9) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsStatus = this.readASCII(l, l2);
            } else if (n == 7) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 3);
                this._gpsTimeStamp = this.readRationalArray(l, l2);
            } else if (n == 15) {
                GPSInfoIFD.checkType(n, n2, 5);
                GPSInfoIFD.checkCount(n, l, 1);
                this._gpsTrack = this.readRational(l, l2);
            } else if (n == 14) {
                GPSInfoIFD.checkType(n, n2, 2);
                GPSInfoIFD.checkCount(n, l, 2);
                this._gpsTrackRef = this.readASCII(l, l2);
            } else if (n == 0) {
                GPSInfoIFD.checkType(n, n2, 1);
                GPSInfoIFD.checkCount(n, l, 4);
                this._gpsVersionID = this.readByteArray(n2, l, l2);
            } else {
                this._info.setMessage((Message)new ErrorMessage("Unknown GPSInfo IFD tag", "Tag = " + n, l2));
            }
        }
        catch (IOException iOException) {
            throw new TiffException("Read error for tag" + n, l2);
        }
    }
}

