/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import com.mongodb.ReflectionDBObject;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.PolymorphicStatus;

public class MongoGenotype
extends ReflectionDBObject {
    private static final String SAMPLE_NAME = "NA12878";
    public static final Genotype NO_CALL = GenotypeBuilder.createMissing((String)"NA12878", (int)2);
    public static final int DISCORDANT_GQ = 0;
    int allele1 = -1;
    int allele2 = -1;
    int GQ = -1;
    int DP = -1;

    public static Genotype create(VariantContext vc, int allele1, int allele2) {
        return new MongoGenotype(allele1, allele2).toGenotype(vc.getAlleles());
    }

    public static Genotype createDiscordant(Genotype g) {
        return new GenotypeBuilder(g.getSampleName(), g.getAlleles()).GQ(0).make();
    }

    public MongoGenotype() {
    }

    public MongoGenotype(List<Allele> alleles, Genotype gt) {
        if (gt.getPloidy() == 0) {
            this.allele2 = -1;
            this.allele1 = -1;
        } else {
            if (gt.getPloidy() != 2) {
                throw new IllegalArgumentException("Ploidy must be two for conversion to MongoGenotype " + gt);
            }
            this.allele1 = alleles.indexOf(gt.getAllele(0));
            this.allele2 = alleles.indexOf(gt.getAllele(1));
        }
        this.DP = gt.hasDP() ? gt.getDP() : -1;
        this.GQ = gt.hasGQ() ? gt.getGQ() : -1;
        this.validate();
    }

    public MongoGenotype(int allele1, int allele2) {
        this(allele1, allele2, -1, -1);
        this.validate();
    }

    public MongoGenotype(int allele1, int allele2, int GQ, int DP) {
        this.allele1 = allele1;
        this.allele2 = allele2;
        this.GQ = GQ;
        this.DP = DP;
    }

    public Genotype toGenotype(List<Allele> alleles) {
        GenotypeBuilder gb = new GenotypeBuilder(SAMPLE_NAME);
        gb.alleles(Arrays.asList(this.getAllele(alleles, this.allele1), this.getAllele(alleles, this.allele2)));
        if (this.DP != -1) {
            gb.DP(this.DP);
        }
        if (this.GQ != -1) {
            gb.GQ(this.GQ);
        }
        return gb.make();
    }

    public PolymorphicStatus getPolymorphicStatus() {
        if (this.isUnknown()) {
            return PolymorphicStatus.UNKNOWN;
        }
        if (this.isPolymorphic()) {
            return PolymorphicStatus.POLYMORPHIC;
        }
        if (this.isMonomorphic()) {
            return PolymorphicStatus.MONOMORPHIC;
        }
        if (this.isDiscordant()) {
            return PolymorphicStatus.DISCORDANT;
        }
        throw new IllegalStateException("Expected polymorphic state " + (Object)((Object)this));
    }

    public boolean isUnknown() {
        return this.allele1 == -1;
    }

    public boolean isPolymorphic() {
        return (this.allele1 > 0 || this.allele2 > 0) && !this.isDiscordant();
    }

    public boolean isMonomorphic() {
        return this.allele1 == 0 && this.allele2 == 0 && !this.isDiscordant();
    }

    public boolean isDiscordant() {
        return this.GQ == 0;
    }

    public int getAllele1() {
        return this.allele1;
    }

    public void setAllele1(int allele1) {
        this.allele1 = allele1;
    }

    public int getAllele2() {
        return this.allele2;
    }

    public void setAllele2(int allele2) {
        this.allele2 = allele2;
    }

    public int getGQ() {
        return this.GQ;
    }

    public void setGQ(int GQ) {
        this.GQ = GQ;
    }

    public int getDP() {
        return this.DP;
    }

    public void setDP(int DP) {
        this.DP = DP;
    }

    public boolean isHeterozygous() {
        return this.allele1 != -1 && this.allele2 != -1 && this.allele1 != this.allele2;
    }

    private Allele getAllele(List<Allele> alleles, int i) {
        return i == -1 ? Allele.NO_CALL : alleles.get(i);
    }

    public String toString() {
        return this.alleleString(this.allele1) + "/" + this.alleleString(this.allele2) + (this.isDiscordant() ? " DISCORDANT" : this.option(", GQ=", this.GQ)) + this.option(", DP=", this.DP);
    }

    private String option(String prefix, int v) {
        return v == -1 ? "" : prefix + String.valueOf(v);
    }

    private String alleleString(int i) {
        return i == -1 ? "." : String.valueOf(i);
    }

    protected String validate() {
        if (this.allele1 < -1 || this.allele1 > 1) {
            return "allele1 " + this.allele1 + " not between -1 and 1";
        }
        if (this.allele2 < -1 || this.allele2 > 1) {
            return "allele2 " + this.allele2 + " not between -1 and 1";
        }
        if (this.allele1 == -1 && this.allele2 != -1) {
            return "Both allele1 and allele2 must be -1 if one is but saw " + this.allele1 + "/" + this.allele2;
        }
        if (this.allele2 == -1 && this.allele1 != -1) {
            return "Both allele1 and allele2 must be -1 if one is but saw " + this.allele1 + "/" + this.allele2;
        }
        if (this.GQ < -1) {
            return "GQ " + this.GQ + " < -1";
        }
        if (this.DP < -1) {
            return "DP " + this.DP + " < -1";
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MongoGenotype that = (MongoGenotype)((Object)o);
        if (this.DP != that.DP) {
            return false;
        }
        if (this.GQ != that.GQ) {
            return false;
        }
        if (this.allele1 != that.allele1) {
            return false;
        }
        return this.allele2 == that.allele2;
    }

    public int hashCode() {
        int result = this.allele1;
        result = 31 * result + this.allele2;
        result = 31 * result + this.GQ;
        result = 31 * result + this.DP;
        return result;
    }
}

